/*#define DEBUG*/
/****************************************************************************
 *
 *  desc1.c  occam 2  Object file handling
 *
 ****************************************************************************/
/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
******************************************************************************/
/*}}}  */

/*{{{  include files*/
# include <stdio.h>
# include <string.h>
# include <ctype.h>

# include "includes.h"

#ifdef TCOFF
# include <stdlib.h>
# ifdef ANSI
#  include <stdarg.h>
# else
#  include <varargs.h>
# endif
/*# include <time.h> */  /* for creating a unique module id */
#endif /* TCOFF */

# include "lexconst.h" /**/
# include "lexerror.h" /**/
# include "synerror.h"
# include "chkerror.h"
# include "deschdr.h" /**/
# include "desc1def.h" /**/
# include "lex1def.h" /**/
# include "lexdef.h" /**/
# include "syn1def.h" /**/
# include "syndef.h" /**/
# include "chkdef.h" /**/
# include "chk4def.h" /**/
# include "usehdr.h" /**/
# include "usedef.h" /**/
# include "genhdr.h"
# include "tcoff.h"
# include "gen1def.h"
# include "generror.h"
# include "popen.h"
/*}}}  */

/*{{{  constant definitions*/
/*#define MAX_NESTED_SCS 50*/   /* #SC is now obsolete */
/*#define MAX_ENTRYPOINTS 200*/ /* No longer hard-coded */

#ifndef TCOFF
#define LIB_STRING_PREFIX "OCCAM 2 LIBRARY "
#endif

#ifndef CONFIG
/* This ensures that only the 'most compatible' definition from a library
   is stored on the chain. It is purely an optimisation; it would work
   ok if this were not defined thus
*/
#define SINGLE_PROCDEF
#endif

#ifdef CONFIG
/* we run the configurer after linking, so all the object files will
   be linked already, and we have to generate an object file
   which looks like it has been linked.
*/
#define LINKED_INPUT_FILE
#define LINKED_OUTPUT_FILE
PRIVATE long int seek_position_of_startmodule;

/* so that we only write the comment string once */
PRIVATE int written_comment = FALSE;
#endif

#if 0 /* #SC is obsolete */
typedef struct  /* used for remembering nested SCs (obsolete) */
  {
    int sc_filenum;     /* Index into file table for file containing SC code */
    BIT32 sc_codesize;                        /* Length of SC code, in bytes */
    treenode *sc_entrypoints;                      /* List of SC entrypoints */
  } sc_t;
#endif /* 0 */

typedef struct libentry_s /* A name defined in a library */
  {
    struct libentry_s     *l_next;     /* Next entry in chain */
    wordnode *l_name;     /* Name of entrypoint */
    procdef_t             *l_procdefs; /* list of individual definitions */
    unsigned int           l_bits;     /* various bit patterns */
    BIT32                  l_hash;     /* Hash function of descriptor */
  } libentry_t;
#define LIBENTRY_BIT_DESC_SENT      0x1
#define LIBENTRY_BIT_COMPATIBLE     0x2
#define LIBENTRY_BIT_COMPATIBLE_ERR 0x4

typedef struct translate_s /* used for origin matching, and name translation too */
  {                /* And for patching in WS and VS requirements */
    struct translate_s    *n_next;   /* next on chain */
    wordnode *n_name;
    struct translate_s    *n_pair;   /* translation name */
  } translate_t;

typedef struct commentchain_s /* used for remembering #COMMENTs */
  {
    struct commentchain_s *next;      /* ptr to next on chain */
  #if 0 /* This uses the dubious practice of 'running off' a struct */
    char                   string[1]; /* the actual string */
  #else
    char *stringptr;                  /* the actual string */
  #endif
  } commentchain_t;

#ifndef TCOFF
#define MAX_3L_STRING_SIZE 512
/*{{{  3L constants:*/
#define C_PREFIX 0x80

#define C_NEWID (-39)
#define C_NEWENTRY (-31)
#define C_LIBRARY (-30)
#define C_COMMENT (-17)
#define C_ID (-16)
#define C_ADDRESS (-15)
#define C_DEBUG (-13)
#define C_ENTRY (-12)
#define C_CODE (-11)
#define C_TOTALCODE (-10)
#define C_DESC  (-8)
#define C_REF 34
#define C_CODEFIX 37
#define C_NEXTMODULE 46
#define C_ENTRYSYMB 47
#define C_NEWENTRYSYMB 49

#define MAX_DESCSTRING_SIZE 512

#define T212_3L  2
#define T414_3L  4
#define T425_3L  9
#define T800_3L  8
#define TA_3L   10
#define TB_3L   11
#define TC_3L   12

#define REDUCED_3L      0
#define HALT_3L         1
#define STOP_3L         2
#define UNIVERSAL_3L    3
/*}}}  */
#endif

/*}}}  */

/* Various flags concerning what to put into the object file */
PUBLIC int object_file_flags;

/*{{{  private variables*/
PRIVATE int desc_eof;

#if 0  /* #SC is obsolete */
PRIVATE sc_t sctable[MAX_NESTED_SCS]; /* list of all #SC stuff */
PRIVATE int sctableptr;                      /* (obsolete)             */
#endif /* 0 */

/* The parser builds up a list of the entrypoints onto here, so that we
   can patch back the workspace and vectorspace requirements.
   It was also (historically) used to patch #SC offsets */
PRIVATE treenode *entrypointlist;

/* Global list of #USEd names, used to find modules when writing object file */
PRIVATE libentry_t *libentries;   /* List for just this library when reading */
PRIVATE module_t   *localmodules; /* Just this library ditto */

PRIVATE commentchain_t *commentchain;    /* list of #COMMENTs */
#ifdef CONFIG
  PRIVATE int reversed_commentchain = FALSE;
#endif

#ifndef TCOFF
  PRIVATE int donetarget;            /* FALSE until we have read a valid NEWID */
  PRIVATE int passingthrough;/* FALSE unless we encounter an inapplicable lib. */
  PRIVATE int selectiveloading;                /* FALSE until we see a LIB tag */
#endif

PRIVATE int refno;              /* Number of library entry point references */
PRIVATE long int current_module_seekpos;    /* Used as pseudo seek_val if not in a lib */
PRIVATE BIT32 module_instr;     /* details of current module */
PRIVATE BIT32 module_attr;
PRIVATE BIT32 sourcehash;       /* Hash function on whole of source */
  
#ifdef TCOFF
  #define INVALID_SYMBOL_ID (-1)  /* Any negative value */
  PRIVATE int exported_origin_id;
  #ifndef LINKED_OUTPUT_FILE
    PRIVATE int local_text;
  #endif
  PRIVATE size_t code_size;

  PRIVATE int in_descriptor;
  PRIVATE char *current_descriptor;
  PRIVATE char *sub_desc;
  PRIVATE int reading_module;
  PRIVATE int module_level;

  PRIVATE translate_t *trans_internals = NULL; /* Name pairs for name */
  PRIVATE translate_t *trans_externals = NULL; /* translations */
  PRIVATE libentry_t  *globalnames   = NULL;   /* Names already #USE-d */
  PRIVATE libentry_t  *thrownentries = NULL;   /* Those names not in occam syntax */

  PRIVATE char *text_name_default  =     "text%base";
  PRIVATE char *text_name_priority = "pri%text%base";
  PRIVATE char *text_name;        /* Name of text section in TCOFF file */

  PRIVATE int language_name; /* Name to be stored in descriptor */

  #ifdef LINKED_INPUT_FILE
    PRIVATE INT32 current_symbol_value;
    PRIVATE INT32 current_module_size;
    PRIVATE module_t *current_module;
    PRIVATE int    file_is_a_library;
  #endif
#endif


/*{{{  data for descriptor handling*/
/* This is used as a buffer for building descriptors for output */
#define DESC_BUFFER_SIZE 512

#ifdef TCOFF
  PRIVATE char *desc_buffer = NULL;
  PRIVATE int desc_buffer_size = DESC_BUFFER_SIZE;
#else
  PRIVATE char desc_buffer[DESC_BUFFER_SIZE]; /* Output descriptor buffer */
#endif

PRIVATE int desc_buffer_ptr;
/*}}}  */

/*}}}  */

/*{{{  PUBLIC int tcoff_obj_format*/
/* This flag is examined by the harness so that it knows whether it has been
   built to use TCOFF or not */
#ifdef TCOFF
  PUBLIC int tcoff_obj_format = TRUE;
#else
  PUBLIC int tcoff_obj_format = FALSE;
#endif
/*}}}  */

/*{{{  private routines*/
/*{{{  processor type and error mode checking*/
/*{{{  PRIVATE int compatible_call(callee_instr, callee_attr)*/
PRIVATE int compatible_call ( BIT32 callee_instr , BIT32 callee_attr )
{
  /* return TRUE if the callee's bits are a subset of the caller's */
  return ((processortype | callee_instr) == processortype) && 
	 ((processorattr | callee_attr)  == processorattr);
}
/*}}}  */
#ifndef TCOFF
/*{{{  PRIVATE int compatible_call_3L(machine, mode) */
PRIVATE int compatible_call_3L ( BIT32 machine , BIT32 mode )
{
  BIT32 instr = ~0, attr = ~0; /* ~0 is likely to be invalid */
  switch (machine)
    {
      case T212_3L : instr = T212_INSTR; attr = T212_ATTRIB; break;
      case T414_3L : instr = T414_INSTR; attr = T414_ATTRIB; break;
      case T425_3L : instr = T425_INSTR; attr = T425_ATTRIB; break;
      case T800_3L : instr = T800_INSTR; attr = T800_ATTRIB; break;
      case TA_3L   : instr = TA_INSTR;   attr = TA_ATTRIB;   break;
      case TB_3L   : instr = TB_INSTR;   attr = TB_ATTRIB;   break;
    /*case TC_3L   : instr = TC_INSTR;   attr = TC_ATTRIB;   break;*/
    }
  switch (mode)
    {
      case REDUCED_3L   : attr |= ATTRIB_ERROR_MASK; break; /* OBSOLETE */
      case UNIVERSAL_3L : attr |= ATTRIB_UNIVERSAL;  break;
      case HALT_3L      : attr |= ATTRIB_HALT;       break;
      case STOP_3L      : attr |= ATTRIB_STOP;       break;
    }
  return (compatible_call(instr, attr));
}
/*}}}  */
#endif
#if 0
/*{{{  PRIVATE int compatibleprocessor (int p)*/
/*****************************************************************************
 *
 *  compatibleprocessor returns TRUE if processor type 'p' is compatible
 *                      with the processor type for which we are compiling,
 *                      held in global variable 'processortype'.
 *
 *****************************************************************************/
PRIVATE int compatibleprocessor ( int p )
{
  switch (processortype)
    {
      case T212: return (p == T212);
      case T414: return (p == T414) || (p == TA) || (p == TB);
      case T425: return (p == T425) || (p == TA) || (p == TB) || (p == TC);
      case T800: return (p == T800) || (p == TA) || (p == TC);
      case TA  : return (p == TA);
      case TB  : return (p == TA) || (p == TB);
      case TC  : return (p == TA) || (p == TC);
      default  : return (FALSE);
    }
}
/*}}}  */
/*{{{  PRIVATE int compatibleerrormode (int e)*/
/*****************************************************************************
 *
 *  compatibleerrormode returns TRUE if error mode 'e' is compatible
 *                      with the error mode for which we are compiling,
 *                      held in global variable 'errormode'.
 *
 *****************************************************************************/
PRIVATE int compatibleerrormode ( int e )
{
  switch (errormode)
    {
      case UNDEFINED_3L: return (e == UNDEFINED_3L) || (e == UNIVERSAL_3L);
      case HALT_3L:      return (e == HALT_3L)      || (e == UNIVERSAL_3L);
      case STOP_3L:      return (e == STOP_3L)      || (e == UNIVERSAL_3L);
      case UNIVERSAL_3L: return (e == UNIVERSAL_3L);
      default:           return (FALSE);
    }
}
/*}}}  */
#ifdef TCOFF
/*{{{  PRIVATE int processortype_to_3L (tf)*/
PRIVATE int processortype_to_3L ( long int tf )
{
  switch (tf)
  {
    case T212_INSTR:
      return (T212);
    case T425_INSTR:
      return (T425);
    case T800_INSTR:
      return (T800);
    case TA_INSTR:
      return (TA);

    /*********************/
    /*       OOPS        */
    /*********************/
    /*     ambiguity about equivalent mode !
    case T414_INSTR:
      return (T414);
    */
    case TB_INSTR:
      return (TB);

    /*case TC_INSTR:
      return (TC);*/
    default:
      lexfatal(LEX_TCOFF_BAD_PROCESSOR, NOPOSN);
      return (0);  /* not reached */
  }
}
/*}}}  */
/*{{{  PRIVATE int errormode_to_3L (em)*/
PRIVATE int errormode_to_3L ( long int em )
{
  switch (em)
  {
    case TCOFF_HALT | TCOFF_STOP | TCOFF_IGNORE:
      return (UNIVERSAL_3L);
    case TCOFF_IGNORE:
      return (UNDEFINED_3L);
    case TCOFF_HALT:
      return (HALT_3L);
    case TCOFF_STOP:
      return (STOP_3L);
    default:
      lexfatal(LEX_TCOFF_BAD_MODE, NOPOSN);
      return (0); /* not reached */
  }
}
/*}}}  */
#endif /* TCOFF */
#endif /* 0 */
/*}}}  */

/*{{{  search_translations*/
PRIVATE translate_t *search_translations ( translate_t *ptr , wordnode *name )
{
  DEBUG_MSG(("search_translations: name is \"%s\"\n", WNameOf(name)));
  while ((ptr != NULL) && (name != ptr->n_name))
    ptr = ptr->n_next;
  return (ptr);
}
/*}}}  */
/*{{{  search_libentries*/
PRIVATE libentry_t *search_libentries ( libentry_t *ptr , wordnode *name )
{
  DEBUG_MSG(("search_libentries: name is \"%s\"\n", WNameOf(name)));
  while ((ptr != NULL) && (name != ptr->l_name))
    ptr = ptr->l_next;
  return (ptr);
}
/*}}}  */
/*{{{  search_modulechain*/
PRIVATE module_t *search_modulechain ( module_t *ptr , long int seek_val )
{
  DEBUG_MSG(("search_modulechain: seekval is %ld\n", seek_val));
  while ((ptr != NULL) && (seek_val != ptr->m_seek_ptr))
    ptr = ptr->m_next;
  return (ptr);
}
/*}}}  */
/*{{{  process_externalname*/
PRIVATE int process_externalname (wordnode *name,
  const long int seek_val, const BIT32 ws, const BIT32 vs,
  const BIT32 instr, const BIT32 attr, const BIT32 hash, const int in_libindex )
{
  libentry_t *libentry;
  procdef_t *procdef;
  module_t *module;
  int compatible = compatible_call(instr, attr);
  DEBUG_MSG(("process_externalname: name is \"%s\", seek_val: %ld, ws %ld, vs %ld\n", WNameOf(name), seek_val, ws, vs));

#if 0
  if ((ws != ORIGIN_WS) && (search_namechain(libentrynames, name) != NULL))
    { /* Found same name in different libraries */
      /* But don't want spurious errors generated by origin strings */
      synerror(SYN_DUPLICATE_IN_LIB, flocn, (BIT32)(WNameOf(name)));
      return (TRUE);  /* Don't process this descriptor */
    }
#endif
  libentry = search_libentries(libentries, name);
  if (libentry == NULL)
    {
      DEBUG_MSG(("Creating a libentry node; adding to libentries\n"));
      /* use newvec here rather than memalloc, cos we never free the space */
      libentry = (libentry_t *)newvec(sizeof (libentry_t));
      libentry->l_name     = name;
      libentry->l_procdefs = NULL;
      libentry->l_bits     = 0;
      libentry->l_hash     = hash;
      libentry->l_next     = libentries;
      libentries           = libentry;
    }
  else if (libentry->l_hash != hash)
    /*synwarn1(SYN_DIFFERENT_DESCRIPTORS, flocn, (BIT32)(WNameOf(name)));*/
    synerr_s(SYN_DIFFERENT_DESCRIPTORS, flocn, WNameOf(name));

  libentry->l_bits |= (compatible * LIBENTRY_BIT_COMPATIBLE);

  module = search_modulechain(localmodules, seek_val);
  if (module == NULL)
    {
      DEBUG_MSG(("Creating a module node\n"));
      /* use newvec here rather than memalloc, cos we never free the space */
      module = (module_t *)newvec(sizeof (module_t));
      module->m_name     = lookupword("?", 1);
      module->m_seek_ptr = seek_val;
      module->m_id_val   = ORIGIN_NOT_FOUND;
      module->m_filenum  = currentfilenum;
      module->m_instr    = instr;
      module->m_attr     = attr;
      module->m_size     = 0;
    #ifdef CONFIG
      module->m_config   = NULL;
      module->m_filestr  = NULL;
    #endif
      module->m_next     = localmodules;
      localmodules       = module;
    }
  if (ws == ORIGIN_WS)
    {
      DEBUG_MSG(("Marking origin as found\n"));
      module->m_name     = name;
      module->m_id_val   = ORIGIN_FOUND;
    }

#ifdef LINKED_INPUT_FILE
  current_module = module;

  if (file_is_a_library && !in_libindex)
    {
      procdef_t *this_procdef = libentry->l_procdefs;
      while ((this_procdef != NULL) &&
	     (this_procdef->p_module->m_seek_ptr != seek_val))
        this_procdef = this_procdef->p_next;
      if (this_procdef != NULL)
        {
	  DEBUG_MSG(("Setting offset to %d\n", current_symbol_value));
	  this_procdef->p_offset = current_symbol_value; /* value comes before descriptor */
        }
      return TRUE; /* don't send the descriptor */
    }
#else
  { int i = in_libindex; i = i; } /* stop unused var warning */
#endif

  /* If we're compiling rather than configuring, just add the FIRST
     compatible definition, to save a little space (and time later) */
#ifdef SINGLE_PROCDEF
  if ((libentry->l_procdefs == NULL) && compatible)
#endif
  {
    procdef = (procdef_t *)newvec(sizeof(procdef_t));
    procdef->p_ws = ws;
    procdef->p_vs = vs;
  #ifdef LINKED_INPUT_FILE
    procdef->p_offset = current_symbol_value; /* value comes before descriptor */
  #endif
    procdef->p_module = module;
    procdef->p_next   = libentry->l_procdefs;
    libentry->l_procdefs = procdef;
  }

  if ((ws != ORIGIN_WS) && 
      ((libentry->l_bits & LIBENTRY_BIT_DESC_SENT) == 0)
#ifndef CONFIG
      /* when configuring, we MUST read all libs, since we don't yet know
	 what processor types will be needed */
   && (compatible || ((object_file_flags & OBJ_FILE_READ_INCOMPATIBLE_LIBS) != 0))
#endif
     )
    {
      libentry->l_bits |= LIBENTRY_BIT_DESC_SENT;
      return FALSE;
    }
  return TRUE;
}
/*}}}  */
/*{{{  lookup_translations*/
PRIVATE wordnode *lookup_translations(translate_t *from, wordnode *name)
{
  translate_t *ptr = search_translations(from, name);
  return (ptr == NULL) ? name : ptr->n_pair->n_name;
}
/*}}}  */

/*{{{  PUBLIC char *addbuf_3L_num(buffer, n)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  addbuf_3L_num writes 'n' as a Lattice encoded number to 'buffer'.
 *                         A pointer to the next free byte in 'buffer' is
 *                         returned.
 *
 *****************************************************************************/
/*}}}  */
#ifdef HOSTWORD16BIT
  #define MASK     0x0FF00000l
  #define TOP5BITS 0xF8000000l
#else
  #define MASK     0x0FF00000
  #define TOP5BITS 0xF8000000
#endif

PUBLIC char *addbuf_3L_num ( char *buffer , INT32 n )
{
  int bits = 28;
  INT32 mask = MASK;
  if (n < 0L)
    {
      if ((n & TOP5BITS) != TOP5BITS)
        *buffer++ = (char)(0xF0 | (n >> 28));
      else
        {
	  while (((n & mask) == mask) && (bits > 7))
	    {
	      mask >>= 7;
	      bits  -= 7;
	    }
        }
    }
  else
    {
      if ((n & TOP5BITS) != ZERO32)
        *buffer++ = (char)(0x80 | (n >> 28));
      else
        {
	  while (((n & mask) == ZERO32) && (bits > 7))
	    {
	      mask >>= 7;
	      bits  -= 7;
	    }
        }
    }
  while (bits > 7)
    {
      bits -= 7;
      *buffer++ = (char)(0x80 | ((n >> bits) & 0x7F));
    }
  *buffer++ = (char)(n & 0x7F);
  return(buffer);
}
/*}}}  */
/*{{{  PUBLIC char *addbuf_3L_str(buffer, s)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  addbuf_3L_str writes string 's' as a Lattice encoded string to 'buffer'.
 *                         A pointer to the next free byte in 'buffer' is
 *                         returned.
 *
 *****************************************************************************/
/*}}}  */
PUBLIC char *addbuf_3L_str ( char *buffer , char *s )
{
  int l = strlen(s);
  int i;
  buffer = addbuf_3L_num(buffer, (INT32)l);
  for (i = 0; i < l; i++)
    *buffer++ = *s++;
  return(buffer);
}
/*}}}  */

#ifndef BACKEND
/*{{{  PRIVATE desc_name*/
PRIVATE wordnode *desc_name ( char *desc , int *startptr )
{
  char *str, *end, missing_bit;
  wordnode *name;
  str = strstr (desc, "PROC ");
  if (str == desc) /* bingo */
  /* could have said (*str != NULL) but 'PROC ' might occur in
  a function name ?! */
    str += 5; /* 5 is strlen("PROC "); */
  else
  {
    str = strstr (desc, " FUNCTION ");
    if (str != NULL) /* bingo */
      str += 10; /* 10 is strlen(" FUNCTION "); */
    else
      return (NULL);
  }
  end = str;
  while ((*end != ' ') && (*end != '(') && (end != '\0')) end++;
  if (*end == '\0')
    return (NULL);

  missing_bit = *end;
  *end = '\0';
  name = lookupword (str, end - str);
  *end = missing_bit;
  (*startptr) = str - desc;
  return (name);
}
/*}}}  */
#ifdef TCOFF
/*{{{  low level tcoff Input & supporting functions*/
/*{{{  look up table*/
PRIVATE long int bytes_to_tag[] =
{
  0L,       /* not used */
  251L,     /* 1 byte  use 1 byte   */
  252L,     /* 2 bytes use 2 bytes  */
  253L,     /* 3 bytes use 4 bytes  */
  253L,     /* 4 bytes use ...      */
  254L,     /* 5 bytes use 8 bytes  */
  254L,     /* 6 bytes use ...      */
  254L,     /* 7 bytes use ...      */
  254L      /* 8 bytes use ...      */
};
/*}}}  */
/*{{{  PRIVATE void write_error ()*/
PRIVATE void write_error ( void )
{
  lexfatal_i(LEX_OBJFILE_WRITE_ERROR, NOPOSN, ferror(objfile));
}
/*}}}  */
#ifndef LINKED_OUTPUT_FILE
/*{{{  PRIVATE char *str_concat (str1, str2)*/
PRIVATE char *str_concat ( const char *str1 , const char *str2 )
{
  char *res;
  int i, l1 = 0, l2 = 0;
  while (str1[l1] != '\0') l1++;
  while (str2[l2] != '\0') l2++;
  res = memalloc ((1 + l1 + l2) * sizeof (char));
  for (i = 0; i < l1; i++) res[i] = str1[i];
  for (i = 0; i < l2; i++) res[l1 + i] = str2[i];
  res[l1 + l2] = '\0';
  return (res);
}
/*}}}  */
#endif
/*{{{  PRIVATE long int tcoff_getl_test (fs, ok)*/
PRIVATE long int tcoff_getl_test ( FILE *fs , int *ok )
{
  long int res;
  int size, i, c, neg;
  if ((c = fgetc (fs)) == EOF)
  {
    *ok = FALSE;
    return (0L);
  }
  else *ok = TRUE;
  if (c == 255)
  {
    neg = TRUE;
    if ((c = fgetc (fs)) == EOF)
    {
      *ok = FALSE;
      return (0L);
    }
  }
  else if (c == 254)
    lexfatal(LEX_TCOFF_IOERR, NOPOSN);
  else neg = FALSE;
  if ((0 <= c) && (c <= 250)) res = (long int) c;
  else
  {
    size = 1 << (c - 251);
    res = 0L;
    for (i = 0; i < size; i++)
    {
      c = fgetc (fs);
      if (c == EOF)
      {
        *ok = FALSE;
        return (0L);
      }
      res = res | (((long int) c) << (8 * i)) ;
    }
  }
  return (neg ? (~res) : res);
}
/*}}}  */
/*{{{  PRIVATE long int tcoff_sizel (l)*/
PRIVATE long int tcoff_sizel ( long int l )
{
  long int size, inc;
  if (l < 0L)
  {
    size = 2L;   /* leading 255 specifies negative number */
    l = ~l;
  }
  else size = 1L;

  if ((l < 0L) || (l > 250L))
  {
    inc = 1L;        /* we know we need at least one */
    l >>= 8;
    while (l != 0L)
    {
      l >>= 8;
      inc++;
    }
    size += 1L << (bytes_to_tag[inc] - 251);
  }
  return (size);
}
/*}}}  */
/*{{{  PRIVATE long int tcoff_getl (fs)*/
PRIVATE long int tcoff_getl ( FILE *fs )
{
  int ok;
  long int n;
  n = tcoff_getl_test (fs, &ok);
  if (!ok)
    lexfatal(LEX_EOF, NOPOSN);
  return (n);
}
/*}}}  */
/*{{{  PRIVATE unsigned long int tcoff_getl_uli (fs)*/
PRIVATE unsigned long int tcoff_getl_uli ( FILE *fs )
{
  int i, c;
  unsigned long int l;
  l = 0;
  for (i = 0; i < 4; i++)
  {
    if ((c = getc (fs)) == EOF)
      lexfatal(LEX_EOF, NOPOSN);
    l = l | (((unsigned long int) c) << (8 * i)) ;
  }
  return (l);
}
/*}}}  */
/*{{{  tcoff_getbytes*/
PRIVATE char *tcoff_getbytes ( FILE *fs , int len )
{
  int i, c;
  char *str = memalloc (sizeof (char) * len + 1);
  for (i = 0; i < len; i++)
  {
    c = fgetc (fs);
    if (c == EOF)
      lexfatal(LEX_EOF, NOPOSN);
    str[i] = c;
  }
  str[i] = '\0';
  return str;
}
/*}}}  */
/*{{{  PRIVATE void tcoff_throw_bytes*/
PRIVATE void tcoff_throw_bytes(FILE *fs, long int l)
{
  long int i;
  if (l >= BUFSIZ) fseek (fs, l, SEEK_CUR);
  else for (i = 0; i < l; i++) (void) fgetc (fs);
}
/*}}}  */
/*{{{  PRIVATE void tcoff_throw_record (fs)*/
PRIVATE void tcoff_throw_record ( FILE *fs )
{
  long int l;
  l = tcoff_getl (fs);
  tcoff_throw_bytes(fs, l);
}
/*}}}  */
/*}}}  */

/*{{{  PRIVATE is_occam_syntax*/
PRIVATE int is_occam_syntax ( char *s )
{
  if (isupper(*s) || islower(*s))
    {
      s++;
      while (*s != '\0')
        {
	  if (isupper(*s) || islower(*s) || isdigit(*s) || ((*s) == '.'))
	    s++;
	  else
	    return (FALSE);
        }
      return (TRUE);
    }
  return (FALSE);
}
/*}}}  */
/*{{{  PRIVATE char *process_descstring (infile)*/
PRIVATE char *process_descstring ( FILE *infile , long int seek_val,
        int in_libindex, BIT32 instr, BIT32 attr )
{
  int len, index;
  long int ws, vs;
  wordnode *name, *local;
  char *descriptor;
  BIT32 hash = 0xdeaddead;
  DEBUG_MSG(("process_descstring: seek_val: %ld, in_libindex: %d\n", seek_val, in_libindex));
  len = (int) tcoff_getl (infile);
  ws = tcoff_getl (infile);
  vs = tcoff_getl (infile);
  len -= ((int)tcoff_sizel(ws) + (int)tcoff_sizel(vs));
  descriptor = tcoff_getbytes (infile, len);

  if (ws == ORIGIN_WS) /* Special ORIGIN descriptor */
    {
      char *str;
      if (!in_libindex)  /* ignore origin descriptors unless in lib index */
        { memfree(descriptor); return (NULL);}
      len = (int)tcoff_getl (infile);
      str = tcoff_getbytes (infile, len);
      name = lookupword(str, len);
      memfree(str);
    }
  else
    {
      if (in_libindex)
        tcoff_throw_record (infile);  /* string */
      name = desc_name (descriptor, &index); /* index is used for translating */
    }
  if (name == NULL)
    lexfatal_s(LEX_TCOFF_BAD_DESC, flocn, descriptor);

  if ((lexmode == LEX_STDLIB) && (vs != 0L))
  /*synerror (SYN_STDLIB_HAS_VS, genlocn, (BIT32)(WNameOf(name)));*/
    genwarn_s(GEN_STDLIB_HAS_VS, WNameOf(name));

  /* Do name translation here */
  local = lookup_translations (trans_externals, name);
  if (local != name)  /* we've got to translate the name */
    {
      char *str = memalloc(len + (WLengthOf(local) - WLengthOf(name)) + 1);
      DEBUG_MSG(("Translating input \"%s\" to \"%s\"\n", WNameOf(name), WNameOf(local)));
      strncpy (str, descriptor, index);
      str[index] = '\0';
      strcat  (str, WNameOf(local));
      strcat  (str, descriptor + (index + WLengthOf(name)));
      memfree (descriptor);
      descriptor = str;
      name       = local;
    }
  else if ((ws != ORIGIN_WS) && (lexmode != LEX_STDLIB) && !is_occam_syntax(WNameOf(name)))
    {  /* Simply ignore it */
      libentry_t *libentry = search_libentries(thrownentries, name);
      if (libentry == NULL)
        {
	  libentry = (libentry_t *)newvec(sizeof (libentry_t));
	  libentry->l_name = name;
	  libentry->l_next = thrownentries;
	  thrownentries    = libentry;
        }
      memfree (descriptor);
      DEBUG_MSG(("Ignoring name %s\n", WNameOf(name)));
      return (NULL);
    }

  {
    char *s = descriptor;
    while ((*s) != '\0')
      {
        hash = (hash << 1) ^ (*s);
        s++;
      }
  }
  if ( process_externalname(name, seek_val, ws, vs, instr, attr, hash, in_libindex) )
    { /* This one can be junked */
      memfree (descriptor);
      return (NULL);
    }
  return (descriptor);
}
/*}}}  */
#else
/*{{{  PRIVATE int read_descbyte()*/
/*****************************************************************************
 *
 *  read_descbyte reads a byte from a descriptor file.
 *
 *****************************************************************************/
PRIVATE int read_descbyte ( void )
{
  return(fgetc(infile));
}
/*}}}  */
/*{{{  PRIVATE INT32 read_descnumber()*/
/*****************************************************************************
 *
 *  read_descnumber reads an encoded number from a descriptor file.
 *
 *****************************************************************************/
PRIVATE INT32 read_descnumber ( void )
{
     INT32 value = 0;
     int n;
     n = read_descbyte();
     if (n == EOF)
       /*{{{  flag end of file*/
       {
	 desc_eof = TRUE;
	 return(0);
       }
       /*}}}  */
     else
       /*{{{  read an encoded number into value*/
       {
	 if ((n & 64) == 0)   /* check the sign bit */
	   value = 0;
	 else
	   value = -1;
       
	 while ((n & C_PREFIX) != 0)
	   {
	     value = (value << 7) | (n & 0x7f);
	     n = read_descbyte();
	   }
	 value = (value << 7) | n ;
       }
       /*}}}  */
     return(value);
}
/*}}}  */
/*{{{  PRIVATE int read_descblock(buffer)*/
/*****************************************************************************
 *
 *  read_descblock reads an encoded string from a descriptor file, and
 *                 returns the number of bytes read in.
 *
 *****************************************************************************/
PRIVATE int read_descblock ( char *buffer )
{
  int i;
  int error = FALSE;
  int len = read_descnumber();
  for (i = 0; (i < len) && !error; i++)
    /*{{{  read a byte of the string*/
    {
      int e = read_descbyte();
      if (e == EOF)
        error = TRUE;
      else
        buffer[i] = e;
    }
    /*}}}  */
  if (error)
    /*{{{  report error, recover and return*/
    {
      desc_eof = TRUE;
      lexerror(LEX_READ_ERROR, flocn, (BIT32)ferror(infile));
      return(0);
    }
    /*}}}  */
  else
    return(len);
}
/*}}}  */
/*{{{  PRIVATE void sink_descblock()*/
/*****************************************************************************
 *
 *  sink_descblock reads an encoded string from a dsecriptor file,
 *                 and throws it away.
 *
 *****************************************************************************/
PRIVATE void sink_descblock ( void )
{
  int i;
  int error = FALSE;
  int len = read_descnumber();
  for (i = 0; (i < len) && !error; i++)
    /*{{{  read a byte of the string*/
    {
      int e = read_descbyte();
      if (e == EOF)
        error = TRUE;
    }
    /*}}}  */
  if (error)
    /*{{{  report error, recover and return*/
    {
      desc_eof = TRUE;
      lexerror(LEX_READ_ERROR, flocn, (BIT32)ferror(infile));
    }
    /*}}}  */
}
/*}}}  */
/*{{{  PRIVATE char *read_descstring(string)*/
/*****************************************************************************
 *
 *  read_descstring reads an encoded string from a descriptor file, and
 *                  NULL terminates  it, and returns a pointer to string.
 *
 *****************************************************************************/
PRIVATE char *read_descstring ( char *string )
{
  int len = read_descblock(string);
  if (len == 0)
    return(NULL);
  else
    {
      string[len] = '\0';
      return(string);
    }
}
/*}}}  */
#endif 
#endif


/*}}}  */
/*{{{  public routines*/
#ifndef BACKEND
/*{{{  PUBLIC FILE *open_descfile(name)         for the lexer*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  open_descfile opens the file with name 'name' as a descriptor file
 *                'mode' gives the descriptor file mode, either LEX_LIB,
 *                LEX_STDLIB or LEX_SC.
 *
 *****************************************************************************/
/*}}}  */
PUBLIC FILE *open_descfile ( char *name, int mode)
{
  FILE *fptr = NULL;
  mode = mode; /* stop warning */
  DEBUG_MSG(("open_descfile: %s\n", name));
#if 0 /* sctable no longer used */
  if (sctableptr >= MAX_NESTED_SCS)
    lexfatal_s(LEX_TOO_MANY_NESTED_SCS, flocn, name);
  else
#endif
    {
      char full_name[MAX_FILENAME_LENGTH];
      fptr = popen_read(name, pathname, &full_name[0], POPEN_MODE_BINARY);
      if (fptr != NULL)
        {
	  desc_eof = FALSE;
        #ifdef TCOFF
	  {
	    long int tag = tcoff_getl (fptr);
	  #ifdef LINKED_INPUT_FILE
	    if (tag != LINKED_UNIT_TAG)
	      lexfatal_s(LEX_TCOFF_NOT_LINKED, flocn, name);
	  #else
	    if (tag != LINKABLE_TAG)
	      lexfatal_s(LEX_TCOFF_WRONG_FORMAT, flocn, name);
	  #endif
	    tcoff_throw_record (fptr);
	  }
	  module_level = 0;
	  in_descriptor = FALSE;
	  reading_module = FALSE;
        #ifdef LINKED_INPUT_FILE
	  file_is_a_library = FALSE;
        #endif
        #else
	  donetarget = FALSE;
	  passingthrough = FALSE;
	  selectiveloading = FALSE;
        #endif
        }
    }
  return(fptr);
}
/*}}}  */
#ifdef TCOFF
/*{{{  PUBLIC char *readdescriptorline (line)         for the lexer*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  readdescriptorline reads a line of occam source from the infile, returns
 *                     a pointer to the line, or NULL if eof or error.
 *                     Any descriptor information found is stored on the
 *                     descriptor stack.
 *
 *****************************************************************************/
/*}}}  */
PUBLIC char *readdescriptorline ( char *line )
{
  INT32 x, lang, seek_val;
  int i, ok, finished;
  BIT32 instr, attr;

  DEBUG_MSG(("readdescriptorline: "));
  if (!desc_eof && !in_descriptor)
  /*{{{  get new descriptor*/
  {
    DEBUG_MSG(("Looking for next descriptor\n"));
    ok = TRUE;
    finished = FALSE;
    while (ok && !finished)
    {
      x = tcoff_getl_test (infile, &ok);
      /*DEBUG_MSG(("S,T: %ld, %ld, ", ftell(infile), x)); */
      if (ok) switch ((int) x)
      {
        /*{{{  case INDEX_ENTRY_TAG      check if valid entrypoint*/
        case INDEX_ENTRY_TAG:
	  DEBUG_MSG(("Found an index entry\n"));
        #ifdef LINKED_INPUT_FILE
	  file_is_a_library = TRUE;
        #endif
	  (void) tcoff_getl (infile);          /* length */
	  seek_val = tcoff_getl_uli (infile);     /* position */
	  instr = tcoff_getl (infile);            /* transputer function */
	  attr  = tcoff_getl (infile);            /* error mode */
	  lang  = tcoff_getl (infile);            /* language */
	  /*{{{  get descriptor                     descriptor*/
	  if ((lang == LANG_OCCAM) /* && compatible_call(instr, attr)*/)
	  {
	    current_descriptor = process_descstring (infile, seek_val, TRUE, instr, attr);
	    if (current_descriptor != NULL)
	      {
	        in_descriptor = TRUE;
	        finished = TRUE;
	      }
	  }
	  else 
	    {
	      tcoff_throw_record (infile);  /* descriptor */
	      tcoff_throw_record (infile);  /* string */
	    }
	  /*}}}  */
	  break;
        /*}}}  */
        /*{{{  case START_MODULE_TAG:    lex level++; check if valid module*/
        case START_MODULE_TAG:
	  {
	    long int seekpos = ftell(infile);
	    module_level++;
	    DEBUG_MSG(("Found startmodule, level is now: %d\n", module_level));
	    (void)  tcoff_getl (infile);          /* length */
	    instr = tcoff_getl (infile);          /* transputer function */
	    attr  = tcoff_getl (infile);          /* error mode */
	    (void)  tcoff_getl (infile);          /* language */
	    tcoff_throw_record (infile);          /* string */
        
	    if (module_level == 1)                /* ignore nested modules */
	    {
	      current_module_seekpos = seekpos - tcoff_sizel(START_MODULE_TAG);
	      reading_module = /*compatible_call(module_instr, module_attr)*/ TRUE;
	      module_instr = instr;
	      module_attr  = attr;
	    #ifdef LINKED_INPUT_FILE
	      current_module_size = 0;
	      current_module = NULL;
	    #endif
	    }
	  }
	  break;
        /*}}}  */
        /*{{{  SYMBOL_TAG  (looking for origins)*/
        case SYMBOL_TAG:
        /* We don't need to bother about SPECIFIC_SYMBOL_TAG cos we're only
	   interested in actual origin symbols here, which are always defined
	   using a SYMBOL_TAG */
	  if (reading_module && (module_level == 1))
	    {
	      (void) tcoff_getl (infile);       /* length */
	      x = tcoff_getl (infile);          /* usage */
	      if ((x | (EXPORT_USAGE | ORIGIN_USAGE)) == x)
	        {
		  char *name;
		  DEBUG_MSG(("Found an exported ORIGIN tag\n"));
		  x = tcoff_getl (infile);      /* len */
		  name = tcoff_getbytes(infile, (int)x);
		  (void) process_externalname (lookupword(name, strlen(name)),
			 current_module_seekpos, ORIGIN_WS, ZERO32, module_instr, module_attr, 0, FALSE);
		  memfree (name);
	        }
	      else
	        tcoff_throw_record (infile);    /* string */
	    }
	  else tcoff_throw_record (infile);
	  break;
        /*}}}  */
        /*{{{  case DESCRIPTOR_TAG:      load descriptor (if in valid module)*/
        case DESCRIPTOR_TAG:
	  if (reading_module && (module_level == 1))
	  {
	    DEBUG_MSG(("Found a descriptor\n"));
	    (void) tcoff_getl (infile);    /* length */
	    (void) tcoff_getl (infile);    /* id */
	    lang = tcoff_getl (infile);    /* language */
	    /*{{{  get descriptor            descriptor*/
	    if (lang == LANG_OCCAM)
	    {
	      current_descriptor = process_descstring (infile, current_module_seekpos, FALSE,
		      module_instr, module_attr);
	      if (current_descriptor != NULL)
	        {
		  in_descriptor = TRUE;
		  finished = TRUE;
	        }
	    }
	    else tcoff_throw_record (infile);
	    /*}}}  */
	  }
	  else tcoff_throw_record (infile);
	  break;
        /*}}}  */
        /*{{{  case END_MODULE_TAG:      lex level--;*/
        case END_MODULE_TAG:
	  module_level--;
	  DEBUG_MSG(("Found endmodule, level is now %d\n", module_level));
	  if (module_level < 0)
	    lexfatal(LEX_TCOFF_UNMATCHED_ENDMODULE, flocn /*ZERO32*/);
	  tcoff_throw_record (infile);
        #ifdef LINKED_INPUT_FILE
	  if ((module_level == 0) && (current_module != NULL))
	    current_module->m_size = current_module_size;
        #endif
	  break;
        /*}}}  */
        /*{{{  case LIB_INDEX_END_TAG:   stop reading*/
        case LIB_INDEX_END_TAG:
	  tcoff_throw_record (infile);
        #ifndef LINKED_INPUT_FILE
	  ok = FALSE; /* stop reading at the end of the index */
        #endif
	  break;
        /*}}}  */
        #ifdef LINKED_INPUT_FILE
        /*{{{  case DEFINE_SYMBOL */
        case DEFINE_SYMBOL_TAG:
	  {
	    long int expression;
	    (void) tcoff_getl(infile); /* length */
	    (void) tcoff_getl(infile); /* id */
	    expression = tcoff_getl(infile); /* CO_VALUE_TAG */
	    assert(expression == CO_VALUE_TAG);
	    current_symbol_value = tcoff_getl(infile);
	  }
	  break;
        /*}}}  */
        /*{{{  LOAD_TEXT*/
        case LOAD_TEXT_TAG:
	  {
	    long int len;
	    (void) tcoff_getl(infile); /* record length */
	    len = tcoff_getl(infile);  /* code length */
	    tcoff_throw_bytes(infile, len); /* the code */
	    current_module_size += len;
	    DEBUG_MSG(("Found a LOAD_TEXT tag: size %ld, current size is now: %ld\n",
		       len, current_module_size));
	  }
	  break;
        /*}}}  */
        #endif
        /*{{{  default:  throw away all other records*/
        default:
	  tcoff_throw_record (infile);
	  break;
        /*}}}  */
      }
    }
    if (!ok) desc_eof = TRUE;
    sub_desc = current_descriptor;
  }
  /*}}}  */
  if (desc_eof)
  /*{{{  return null, finished getting descriptors*/
  {
    DEBUG_MSG(("Returning NULL\n"));
    return (NULL);
  }
  /*}}}  */
  else
  /*{{{  return next line of descriptor*/
  {
    for (i = 0; (sub_desc[i] != '\n') && (sub_desc[i] != '\0'); i++)
      line[i] = sub_desc[i];
    line[i] = '\n';
    line[i + 1] = '\0';
    if (sub_desc[i] == '\0')
    {
      in_descriptor = FALSE;
      memfree (current_descriptor);
    }
    else sub_desc = &sub_desc[i + 1];
    DEBUG_MSG(("Returning %s", line));
    return (line);
  }
  /*}}}  */
}
/*}}}  */
#else
/*{{{  PUBLIC char *readdescriptorline (line)         for the lexer*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  readdescriptorline reads a line of occam source from the infile, returns
 *                     a pointer to the line, or NULL if eof or error.
 *                     Any descriptor information found is stored on the
 *                     descriptor stack.
 *
 *****************************************************************************/
/*}}}  */
PUBLIC char *readdescriptorline ( char *line )
{
  int reading = !desc_eof;
  while (reading)
    {
      int tag = read_descnumber();
      if (!desc_eof)
        switch(tag)
	  /*{{{  tags*/
	  {
	    /*{{{  instruction*/
	    case 0: case 1: case 2: case 3: case 4: case 5: case 6: case 7:
	    case 8: case 9: case 10: case 11: case 12: case 13: case 14: case 15:
	      {
	        BIT32 offset;
	        offset = read_descnumber();
	        tag = read_descnumber();
	        switch(tag)
		  /*{{{  interpret the operand*/
		  {
		    case C_CODEFIX:
		      {
		        BIT32 symbol;
		        symbol = read_descnumber();
		      }
		      break;
		    default:
		      lexfatal_i(LEX_BAD_SCDESC_FORMAT, flocn, tag);
		      break;
		  }
		  /*}}}  */
	      }
	      break;
	    /*}}}  */
	    /*{{{  C_CODE C_COMMENT C_DEBUG C_REF*/
	    case C_CODE:
	    case C_DEBUG: case C_REF:
	      sink_descblock();
	      break;
	    /*}}}  */
	    /*{{{  C_COMMENT*/
	    case C_COMMENT:
	      read_descstring(line);
	      break;
	    /*}}}  */
	    /*{{{  C_DESC*/
	    case C_DESC:
	      /* pass occam source on to parser */
	      if (!passingthrough)
	        {
		  int len = read_descblock(line);
		  if (len != 0)
		    {
		      line[len] = '\n';
		      line[len + 1] = 0;
		    }
		  reading = FALSE;
	        }
	      /* else we are going through an inapplicable library */
	      else
	        sink_descblock();
	      break;
	    /*}}}  */
	    /*{{{  C_NEWENTRY*/
	    case C_NEWENTRY:
	       /* string; offset; scalarspace; vectorspace */
	      {
	        char name[MAX_DESCSTRING_SIZE];
	        BIT32 offset, workspace, vecspace;
	    
	        read_descstring(name);
	        offset = read_descnumber();
	        workspace = read_descnumber();
	        vecspace = read_descnumber();
	        if (!passingthrough)
		  (void)process_externalname(lookupword(name, strlen(name)), ZERO32, workspace, vecspace, 0, FALSE);
	      }
	      break;
	    /*}}}  */
	    /*{{{  C_NEWENTRYSYMB*/
	    case C_NEWENTRYSYMB:
	      /* This declares an entry point to the linker, there is always an
		 associated NEWENTRY which declares the entry point to us (the compiler)
		 so we ignore NEWENTRYSYMB. */
	      {
	        char dummyname[MAX_DESCSTRING_SIZE];
	        BIT32 dummy;
	        read_descstring(dummyname);
	        dummy = read_descnumber();  /* Offset */
	        dummy = read_descnumber();  /* Workspace */
	        dummy = read_descnumber();  /* Vector space */
	      }
	      break;
	    /*}}}  */
	    /*{{{  C_NEWID*/
	    case C_NEWID:
	      if (donetarget)
	        lexfatal_s(LEX_BAD_DESC_FORMAT, flocn, filename);
	      else
	        {
		  INT32 machine, mode;
		  char compatibility[MAX_DESCSTRING_SIZE + 1];
		  char version[MAX_DESCSTRING_SIZE + 1];
	    
		  donetarget = TRUE;
		  machine = read_descnumber();
		  mode = read_descnumber();
		  read_descstring(compatibility);
		  read_descstring(version);
		  /*{{{  check the compatibility*/
		  if (strcmp(compatibility, C_COMPATIBILITY) != 0)
		    /* report error and give up */
		    lexfatal_s(LEX_BAD_SC_COMPATIBILITY, flocn, filename);
		  /*}}}  */
		  /*{{{  check processor type and error mode*/
		  if (!compatible_call_3L(machine, mode))
		    {
		      if (selectiveloading)
		        passingthrough = TRUE;  /* Skip on to next library */
		      else
		        /*{{{  report the error and give up*/
		        {
			  if (machine != processortype)
			    lexfatal_s(LEX_BAD_SC_PROCTYPE, flocn, filename);
			  else
			    lexfatal_s(LEX_BAD_SC_ERRORMODE, flocn, filename);
		        }
		        /*}}}  */
		    }
		  /*}}}  */
	        }
	      break;
	    /*}}}  */
	    /*{{{  C_TOTALCODE*/
	    case C_TOTALCODE:
	      /* module size; sc size */
	      {
	        INT32 modulesize, scsize;
	        modulesize = read_descnumber();
	        scsize = read_descnumber();
	        #if 0  /* #SC is no longer supported */
	        if (lexmode == LEX_SC)
		  sctable[sctableptr].sc_codesize = modulesize + scsize;
	        #endif
	      }
	      break;
	    /*}}}  */
	    /*{{{  C_LIBRARY*/
	    case C_LIBRARY:
	      if ((lexmode == LEX_LIB) || (lexmode == LEX_STDLIB))
	        {
		  char dummyname[MAX_DESCSTRING_SIZE];
		  read_descstring(dummyname); /* Read in file name and ignore */
		  donetarget = FALSE;
		  passingthrough = FALSE;
		  selectiveloading = TRUE;
	        }
	      else
	        lexfatal_s(LEX_LIBRARY_NOT_SC, flocn, filename);
	      break;
	    /*}}}  */
	    /*{{{  C_ADDRESS*/
	    case C_ADDRESS:
	      read_descnumber(); /* Read address and throw away */
	      break;
	    /*}}}  */
	    /*{{{  C_NEXTMODULE*/
	    case C_NEXTMODULE:
	      break;
	    /*}}}  */
	    default:
	      lexfatal_i(LEX_BAD_SCDESC_FORMAT, flocn, tag);
	      break;
	  }
	  /*}}}  */
      else
        {
	  reading = FALSE;
	  return(NULL);
        }
    }
  return(line);
}
/*}}}  */
#endif /* not TCOFF */

#ifndef CONFIG
/* #PRAGMA EXTERNAL is disabled when configuring */
/*{{{  EXTERNAL handling */
PRIVATE char *extern_buf;
PRIVATE int extern_status;
#define EXTERNAL_VALUE_ERR  (-1L)
#define DEFAULT_EXTERNAL_WS EXTERNAL_VALUE_ERR
#define DEFAULT_EXTERNAL_VS 0

/*{{{  PRIVATE get_optional_num */
/*  return negative if error */
PRIVATE char *get_optional_num ( char *ptr , INT32 *res , char c )
{
  INT32 n = ZERO32;
  while (*ptr == ' ') ptr++;
  if (*ptr == c)
    {
      ptr++; /* skip past the matched character */
      while (*ptr == ' ') ptr++;
      while ((*ptr >= '0') && (*ptr <= '9'))
        {
	  if (n > 0x7FFFFFFF)
	    {
	      n = EXTERNAL_VALUE_ERR;
	      break;
	    }
	  n = (n * 10) + ((INT32)(*ptr) - '0');
	  ptr++;
        }
    }
  else if (*ptr == '\0')
    n = (*res);
  else
    n = EXTERNAL_VALUE_ERR;
  (*res) = n;
  return (ptr);
}
/*}}}  */
/*{{{  PUBLIC init_external */
PUBLIC int init_external ( char *string )
{
  wordnode *name = NULL;
  char *ptr;
  int len = strlen(string);
  INT32 ws = DEFAULT_EXTERNAL_WS, vs = DEFAULT_EXTERNAL_VS;
  int dummy;

  /* PARSE: "PROC P () = 1", or "PROC P () = 1 , 10" */

  while ((len > 0) && string[len] != ')')
    len--;
  extern_buf = memalloc(len + 3);
  memcpy(extern_buf, string, len+1);
  extern_buf[len+1] = '\n';
  extern_buf[len+2] = '\0';
  extern_status = 0;
  
  DEBUG_MSG(("init_external: string is \"%s\"\n", string));
  DEBUG_MSG(("init_external: line   is \"%s\"\n", extern_buf));

  ptr = &string[len+1];
  ptr = get_optional_num (ptr, &ws, '=');
  ptr = get_optional_num (ptr, &vs, ',');
  while (*ptr == ' ') ptr++;
  DEBUG_MSG(("ws : %ld, vs : %ld\n", ws, vs));
  if ((ws >= 0) && (vs >= 0) && (*ptr == '\0'))
    name = desc_name (extern_buf, &dummy); /* Don't bother translating these */
  if (name == NULL)
    {
      synwarn_s(SYN_BAD_PRAGMA_DIRECTIVE, flocn, "EXTERNAL");
      return FALSE;
    }
  (void)process_externalname(name, ZERO32, ws, vs, processortype, processorattr, 0, FALSE);
  extern_status = 1;
  return TRUE;
}
/*}}}  */
/*{{{  PUBLIC char *readexternalline () for the lexer*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  readexternalline reads a line of occam source from the saved #EXTERNAL, returns
 *                     a pointer to the line, or NULL if eof or error.
 *
 *****************************************************************************/
/*}}}  */
PUBLIC char *readexternalline ( void )
{
  char *line;
  switch (extern_status++)
    {
      case 1  : line = extern_buf;
	        break;
      case 2  : memfree (extern_buf); 
	        line = "  SEQ\n";
	        break;
      case 3  : line = ":\n";
	        break;
      default : extern_status = 0;
	        DEBUG_MSG(("readexternalline: returning NULL\n"));
	        return (NULL);
    }
  DEBUG_MSG(("readexternalline: returning :%s", line));
  return (line);
}
/*}}}  */
/*}}}  */
#endif /* end of #PRAGMA external stuff */
/*{{{  PUBLIC process_hcomment*/
PUBLIC void process_hcomment ( char *string , int len )
{
  commentchain_t *ptr;
#if 0 /* This uses the dubious practice of 'running off' a struct */
  ptr = (commentchain_t *)memalloc(sizeof(commentchain_t) + len + 1);
  memcpy(&(ptr->string[0]), string, len);
  ptr->string[len] = '\0';
#else
  char *copy = (char *)memalloc(len + 1);
  ptr = (commentchain_t *)memalloc(sizeof(commentchain_t));
  memcpy(copy, string, len);
  copy[len] = '\0';
  ptr->stringptr = copy;
#endif
  ptr->next    = commentchain;
  commentchain = ptr;
  DEBUG_MSG(("process_hcomment; string: \"%s\", len:%d\n", string, len));
  if (information)
    fprintf(outfile, "%s \"%s\"\n", tagstring(S_HCOMMENT), string);
}
/*}}}  */
#endif
/*{{{  PUBLIC void addtoentrypointlist (nptr)  for the parser*/
/*****************************************************************************
 *
 *  addtoentrypointlist adds nptr to the entrypointlist
 *
 *****************************************************************************/
PUBLIC void addtoentrypointlist ( treenode *nptr )
{
  DEBUG_MSG(("addtoentrypointlist: adding %lx (\"%s\") (was %lx)\n", (BIT32)nptr, WNameOf(NNameOf(nptr)), (BIT32)entrypointlist));
  SetNLEntryNext(nptr, entrypointlist);
  entrypointlist = nptr;
}
/*}}}  */
/*{{{  PUBLIC void patchdescriptors(mode)      **     for the lexer*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  patchdescriptors patches the namenodes of the entry points in the
 *                   'entrypointlist' using information in the
 *                   entry point table, empties the entry point table,
 *                   and adds the entry point list to the entry for this
 *                   SC in the SC table. If the entry point list is for a
 *                   library, it is thrown away.
 *
 *****************************************************************************/
/*}}}  */
PUBLIC void patchdescriptors ( int mode )
{
  treenode *ep = entrypointlist;
  DEBUG_MSG(("patchdescriptors\n"));
  mode = mode; /* dummy because unused variable */

  while (ep != NULL)
    /*{{{  find this ep in the entry point table*/
    {
      treenode *epnext = NLEntryNextOf(ep);
      libentry_t *thisentry;
      DEBUG_MSG(("Patching descriptor for \"%s\"\n", WNameOf(NNameOf(ep))));
      thisentry = search_libentries(libentries, NNameOf(ep));
      if (thisentry == NULL)
        lexerr_s(LEX_MISSING_ENTRYPOINT, flocn, WNameOf(NNameOf(ep)));
      else
        /*{{{  patch in offset and space usage for the entrypoint*/
        {
	  /* the offset is obsolete cos #SC is obsolete */
	  /*SetNSCEntryOffset(ep, thisentry->n_offset);*/
	  /*SetNPDatasize(ep, thisentry->n_ws);*/
	  /*SetNPVSUsage(ep,  thisentry->n_vs);*/
        #ifndef SINGLE_PROCDEF
	  /* if compiling rather than configuring, we only have a max of
	     ONE procdef on the chain */
	  {
	    /* reverse the procdefs so that the most suitable is at */
	    /* the start of the list */
	    procdef_t *p = thisentry->l_procdefs;
	    procdef_t *reverser = NULL, *temp;
	    while (p != NULL)
	      {
	        temp      = p->p_next;
	        p->p_next = reverser;
	        reverser  = p;
	        p         = temp;
	      }
	    thisentry->l_procdefs = reverser;
	  }
        #endif
	  SetNLExternal(ep, thisentry);
	  /*if (mode != LEX_SC)*/
	    SetNLEntryNext(ep, NULL);
        }
        /*}}}  */
      ep = epnext;
    }
    /*}}}  */

#if 0 /* #SC is no longer supported */
  if (mode == LEX_SC)
    /*{{{  finish this entry in the SC table*/
    {
      sc_t *scentry = &(sctable[sctableptr]);
      scentry->sc_filenum = currentfilenum;
      scentry->sc_entrypoints = entrypointlist;
      sctableptr = sctableptr + 1;
    }
    /*}}}  */
#endif

  /*{{{  delete this descriptor's entry points*/
  entrypointlist = NULL;
  /*}}}  */

  /*{{{  Cleanup local entrynames*/
  {  /* add all names to globalnames */
    unsigned int module_found = 0;
    while (libentries != NULL)
      {
        libentry_t *t = libentries->l_next;
        module_found |= (libentries->l_bits & LIBENTRY_BIT_COMPATIBLE);
        libentries->l_next   = globalnames;
        globalnames = libentries;
        libentries  = t;
      }
    #ifndef CONFIG
    if (module_found == 0)
      synwarn_s(SYN_NOTHING_IN_LIB, NOPOSN, filename);
    #endif
  }
  localmodules = NULL;
  current_module_seekpos   = 0;
  /*}}}  */
}
/*}}}  */
#ifdef CONFIG
/*{{{  PRIVATE procdef *check_fpu_calling_convention*/
PRIVATE procdef_t *check_fpu_calling_convention(procdef_t *procdef,
		     treenode *nptr, SOURCEPOSN locn, int check)
/* this is called if the specified routine only exists compiled
   for the `wrong' calling convention. We allow this as long as the
   code works (when configuring!).
*/
{
  if (procdef != NULL)
  switch(TagOf(nptr))
    {
      case N_LIBFUNCDEF: case N_SCFUNCDEF: case N_STDLIBFUNCDEF:
        {
	  treenode *resultlist = FnTypeListOf(NTypeOf(nptr));
	  DEBUG_MSG(("check_fpu_calling_convention: found a function\n"));
	  if (listitems(resultlist) == 1)
	    {
	      DEBUG_MSG(("check_fpu_calling_convention: only one result param\n"));
	      if (isreal(TagOf(ThisItem(resultlist))))
	        {
		  libentry_t *libentry = NLExternalOf(nptr);
		  procdef = NULL;
		  DEBUG_MSG(("check_fpu_calling_convention: one REAL result param\n"));
		  if (check && ((libentry->l_bits & LIBENTRY_BIT_COMPATIBLE_ERR) == 0))
		    {
		      libentry->l_bits |= LIBENTRY_BIT_COMPATIBLE_ERR;
		      chkerr_s(CHK_CALLING_CONVENTION, locn, WNameOf(NNameOf(nptr)));
		    }
	        }
	    }
        }
        break;
      default:
        DEBUG_MSG(("check_fpu_calling_convention: found a procedure\n"));
        break;
    }
  return procdef;
}
/*}}}  */
#endif
/*{{{  PRIVATE procdef_t *lookup_procdef*/
PRIVATE procdef_t *lookup_procdef(treenode *nptr)
{
  libentry_t *libentry = NLExternalOf(nptr);
  procdef_t *procdef = libentry->l_procdefs;
#ifndef SINGLE_PROCDEF
  while ((procdef != NULL) &&
	 !compatible_call(procdef->p_module->m_instr, procdef->p_module->m_attr))
    procdef = procdef->p_next;
#endif
  return procdef;
}
/*}}}  */
/*{{{  PRIVATE procdef_t *get_procdef*/
PRIVATE procdef_t *get_procdef(treenode *nptr, SOURCEPOSN locn, int check)
{
  procdef_t *procdef = lookup_procdef(nptr);
  libentry_t *libentry = NLExternalOf(nptr);
#ifdef CONFIG
  if ((procdef == NULL) && ((processorattr & ATTRIB_FPU_CALLING) != 0))
    {
      BIT32 saved_attr = processorattr;
      DEBUG_MSG(("get_procdef: trying non-fpu calling convention\n"));
      processorattr = (processorattr & ~ATTRIB_FPU_CALLING_MASK) | ATTRIB_NON_FPU_CALLING;
      procdef = check_fpu_calling_convention(lookup_procdef(nptr), nptr, locn, check);
      processorattr = saved_attr;
    }
#endif
  if (check && (procdef == NULL) && ((libentry->l_bits & LIBENTRY_BIT_COMPATIBLE_ERR) == 0))
    {
      libentry->l_bits |= LIBENTRY_BIT_COMPATIBLE_ERR;
      /* bug 1055 20/12/90 - changed this back from a warning to an error */
      /* (I think it got accidentally changed when I modified the error handling */
      msg_out_ss(SEV_ERR, CHK, CHK_LIB_WRONG_TARGET, locn,
	      (TagOf(NDeclOf(nptr)) == S_PROCDEF) ? "PROC" : "FUNCTION",
	      WNameOf(NNameOf(nptr)));
    }
  return procdef;
}
/*}}}  */
/*{{{  PUBLIC void checklibproctype*/
PUBLIC void checklibproctype(treenode *nptr, SOURCEPOSN locn)
{
  (void)get_procdef(nptr, locn, TRUE);
}
/*}}}  */
/*{{{  PUBLIC int compiledforcorrectproc*/
PUBLIC int compiledforcorrectproc(treenode *nptr)
{
  return (get_procdef(nptr, NOPOSN, FALSE) != NULL);
}
/*}}}  */
/*{{{  PUBLIC void getlibwsandvs*/
PUBLIC void getlibwsandvs(treenode *nptr, SOURCEPOSN locn, INT32 *ws, INT32 *vs)
{
  procdef_t *procdef = get_procdef(nptr, locn, TRUE);
  if (procdef == NULL) /* we've just supplied an error message */
    {
      *ws = 0; *vs = 0;
    }
  else
    {
      *ws = procdef->p_ws;
      *vs = procdef->p_vs;
    }
  return;
}
/*}}}  */

#ifdef CONFIG
/*{{{  PUBLIC INT32 add_to_module_list*/
PUBLIC INT32 add_to_module_list(treenode **list_ptr, treenode *lib)
/* Takes a list of modules already attached to that processor,
   and a library entrypoint.
   returns the address of the library entrypoint
*/
{
  treenode *list = *list_ptr;
  procdef_t *procdef = get_procdef(lib, NOPOSN, FALSE);
  module_t *module = procdef->p_module;
  int found = FALSE;
  INT32 module_address = 0;

  while (!EndOfList(list) && !found)
    {
      module_t *thismodule = (module_t *)ThisItem(list);
      found = (module == thismodule);
      module_address -= thismodule->m_size;
      list_ptr = NextItemAddr(list);
      list = NextItem(list);
    }

  if (!found) /* Not already on list */
    {
      /* add to the end of the list */
      *list_ptr = addtofront((treenode *)module, NULL);
      module_address -= module->m_size;
    }

  return (module_address + procdef->p_offset);
}
/*}}}  */
/*{{{  PUBLIC BIT32 get_sourcehash*/
PUBLIC BIT32 get_sourcehash(void)
{
  return sourcehash;
}
/*}}}  */
#endif
/*{{{  compiler library loading*/
#ifndef BACKEND

/*{{{  PUBLIC treenode *loadstdlib (filename)*/
/*****************************************************************************
 *
 *  loadstdlib loads the extended type operation library and stores
 *              the entry points in the table stdlibentries.
 *              stdlibcount is set to the number of entries in the table.
 *
 *****************************************************************************/
PUBLIC treenode *loadstdlib ( char *filename )
{
  BIT32 saved_sourcehash = sourcehash;
  int entered = open_file(filename, LEX_STDLIB, 0);
  int savedlinebreakindent = linebreakindent;
  int saved_information = information;
  treenode *stdlibtree;
  if (information)
    fprintf(outfile, "Loading standard library \"%s\"\n", filename);
  information = FALSE;
  if (!entered)
    lexfatal_s(LEX_FILE_OPEN_ERROR, NOPOSN, filename);
  linebreakindent = (-1);
  nextsymb();
  stdlibtree = rscunit();
  scopeandcheck_main(&stdlibtree);
  alias_and_usage_check(stdlibtree); /* Set up free variable lists */
  linebreakindent = savedlinebreakindent;
  information = saved_information;
  sourcehash = saved_sourcehash;
  return(stdlibtree);
}
/*}}}  */
#endif
/*}}}  */

#ifndef FRONTEND
#if 0 /* #SC is no longer supported */
/*{{{  PUBLIC INT32 sc_size()                         for the code emitter*/
/*****************************************************************************
 *
 *  sc_size returns the total code size of all nested SCs
 *
 *****************************************************************************/
PUBLIC INT32 sc_size ( void )
{
  INT32 size = ZERO32;
  int i;
  for (i = 0; i < sctableptr; i++)
    size += sctable[i].sc_codesize;
  return(size);
}
/*}}}  */
/*{{{  PUBLIC void apply_to_sc_entries(p)      for the code generator*/
/*****************************************************************************
 *
 *  apply_to_sc_entries calls the function 'p' for the list of entry points
 *                      for each nested SC. The second parameter passed to 'p'
 *                      is the total code size for all SCs previous to the
 *                      one containing the current entry points, ie. The amount
 *                      of code before the current SC.
 *
 *****************************************************************************/
PUBLIC void apply_to_sc_entries ( void (*p )())
{
  int i;
  INT32 scsize = ZERO32;
  DEBUG_MSG(("apply_to_sc_entries\n"));
  for (i = 0; i < sctableptr; i++)
    {
      (*p)(sctable[i].sc_entrypoints, scsize);
      scsize += sctable[i].sc_codesize;
    }
}
/*}}}  */
#endif


#ifdef TCOFF
/*{{{  PRIVATE void tcoff_putul (fs, l)*/
PRIVATE void tcoff_putul ( FILE *fs , unsigned long int l )
{
  int i;
  for (i = 0; i < 4; i++)
  {
    if (fputc ((char) (l & 0xFFL), fs) == EOF) write_error();
    l >>= 8;
  }
}
/*}}}  */
/*{{{  PRIVATE void tcoff_putl (fs, l)*/
PRIVATE void tcoff_putl ( FILE *fs , long int l )
{
  int size, i;
  long int n, bytes;
  if (l < 0L)
  {
    if (fputc (255, fs) == EOF) write_error ();
    l = ~l;
  }
  if ((l >= 0L) && (l <= 250L))
    /*{ if (fputc ((char) l, fs) == EOF) write_error(); }*/
    { if (fputc ((int) l, fs) == EOF) write_error(); }
  else
  {
    size = 1;
    n = l >> 8;
    while (n != 0L)
    {
      n >>= 8;
      size++;
    }
    /*if (fputc ((char) bytes_to_tag[size], fs) == EOF) write_error ();*/
    if (fputc ((int) bytes_to_tag[size], fs) == EOF) write_error ();
    bytes = 1L << (bytes_to_tag[size] - 251);
    for (i = 0; i < bytes; i++)
    {
      /*if (fputc ((char) (l & 0xFFL), fs) == EOF) write_error ();*/
      if (fputc ((int) (l & 0xFFL), fs) == EOF) write_error ();
      l >>= 8;
    }
  }
}
/*}}}  */
/*{{{  PRIVATE void tcoff_puts (fs, size, string)*/
PRIVATE void tcoff_puts ( FILE *fs , long int size , char *string )
{
  tcoff_putl (fs, size);
  fwrite (string, (size_t) sizeof (char), (size_t) size, fs);
}
/*}}}  */
/*{{{  PRIVATE long int tcoff_record_length (ap, va_alist)*/
PRIVATE long int tcoff_record_length ( va_list ap , char *va_alist )
{
  long int res, l;
  unsigned long int dummy;
  char *p, *fmt;
  res = 0L;
#ifdef ANSI
  fmt = va_alist;
#else
  fmt = va_arg (ap, char *);
#endif
  for (p = fmt; *p; p++)
  {
    /*{{{  if (*p == '%') switch (*++p)*/
    if (*p == '%') switch (*++p)
    {
      case 's':
        l = (long int) strlen (va_arg (ap, char *));
        res += (tcoff_sizel (l) + l);
        break;
      case 'l':
        switch (*++p)
	  {
	    case 'd':
	      res += tcoff_sizel (va_arg (ap, long int));
	      break;
	    case 'u':
	      res += 4L;
	      dummy = va_arg (ap, unsigned long int);
	      break;
	    default:
	      lexfatal_i(LEX_TCOFF_BAD_LCHAR, NOPOSN, *p);
	      break;
	  }
        break;
      default:
        lexfatal_i(LEX_TCOFF_BAD_CHAR, NOPOSN, (INT32)*p);
        break;
    }
    /*}}}  */
    else if (*p != ' ')
      lexfatal_i(LEX_TCOFF_BAD_CHAR, NOPOSN, *p);
  }
  return (res);
}
/*}}}  */
/*{{{  PRIVATE long int tcoff_print_rec (fs, ap, va_alist)*/
PRIVATE void tcoff_print_rec ( FILE *fs , va_list ap , char *va_alist )
{
  long int l;
  char *p, *str, *fmt;
#ifdef ANSI
  fmt = va_alist;
#else
  fmt = va_arg (ap, char *);
#endif
  for (p = fmt; *p; p++)
  {
    /*{{{  if (*p == '%') switch (*++p)*/
    if (*p == '%') switch (*++p)
    {
      case 's':
        str = va_arg (ap, char *);
        l = (long int) strlen (str);
        tcoff_puts (fs, l, str);
        break;
      case 'l': switch (*++p)
	        {
		  case 'd': tcoff_putl (fs, va_arg (ap, long int)); break;
		  case 'u': tcoff_putul (fs, va_arg (ap, unsigned long int)); break;
		  default:
			    lexfatal_i(LEX_TCOFF_BAD_LCHAR, NOPOSN, *p);
			    break;
	        }
	        break;
      default:
        lexfatal_i(LEX_TCOFF_BAD_CHAR, NOPOSN, *p);
        break;
    }
    /*}}}  */
    else if (*p != ' ')
      lexfatal_i(LEX_TCOFF_BAD_CHAR, NOPOSN, *p);
  }
}
/*}}}  */
/*{{{  PRIVATE void tcoff_putrec (FILE *fs, long int tag, char *va_alist, ...)*/
PRIVATE void tcoff_putrec (FILE *fs , long int tag , char *va_alist , ...)
{
  va_list ap;
  long int rec_len;

  tcoff_putl (fs, tag);
#ifdef ANSI
  va_start (ap, va_alist);
#else
  va_start (ap);
#endif
  rec_len = tcoff_record_length (ap, va_alist);
  va_end (ap);

  tcoff_putl (fs, rec_len);
#ifdef ANSI
  va_start (ap, va_alist);
#else
  va_start (ap);
#endif
  tcoff_print_rec (fs, ap, va_alist);
  va_end (ap);
}
/*}}}  */
/*{{{  PRIVATE int p_symbol_id (fs, type, scope, string)*/
PRIVATE int p_symbol_id ( FILE *fs , long int type , long int scope , char *string, long int origin_id )
{
  if (type != 0L)
    tcoff_putrec (fs, SECTION_TAG, "%ld%ld%s", type, scope, string);
  else if (origin_id != INVALID_SYMBOL_ID)
    tcoff_putrec (fs, SPECIFIC_SYMBOL_TAG, "%ld%s%ld", scope, string, origin_id);
  else
    tcoff_putrec (fs, SYMBOL_TAG, "%ld%s", scope, string);
  origin_id = origin_id;  /* shut up unused variable warnings */
  return (refno++);
}
/*}}}  */
/*{{{  PRIVATE put_descriptor (id, str, ws, vs);*/
PRIVATE void put_descriptor ( long int id , char *str , long int ws , long int vs )
{
  long int rec_len, str_len, pseudo_str_len;
  str_len = (long) strlen (str);
  pseudo_str_len = tcoff_sizel (ws) + tcoff_sizel (vs) + str_len;
  rec_len = tcoff_sizel (id) + tcoff_sizel (language_name) +
	    tcoff_sizel (pseudo_str_len) + pseudo_str_len;

  tcoff_putl (objfile, DESCRIPTOR_TAG);
  tcoff_putl (objfile, rec_len);
  tcoff_putl (objfile, id);
  tcoff_putl (objfile, language_name);
  tcoff_putl (objfile, pseudo_str_len);  /* ws + vs + str */
  tcoff_putl (objfile, ws);
  tcoff_putl (objfile, vs);
  fwrite (str, sizeof (char), (size_t) str_len, objfile);
}
/*}}}  */
#endif /* TCOFF */

/*{{{  low-level object file writing           for the backend*/
#ifndef TCOFF
/*{{{  PRIVATE void write_byte(b)*/
PRIVATE void write_byte ( int b )
{
  int e = fputc((char)b, objfile);
  if ((e == EOF) && ferror(objfile))
    lexfatal_i(LEX_OBJFILE_WRITE_ERROR, NOPOSN, ferror(objfile));
}
/*}}}  */
/*{{{  PRIVATE void write_number(n)*/
PRIVATE void write_number ( INT32 n )
{
  char buf[10];  /* Plenty of space for an INT32 */
  char *p = buf;
  char *ptr = addbuf_3L_num(buf, n);
  while (p != ptr)
    write_byte(*p++);
}
/*}}}  */
/*{{{  PRIVATE void write_string(s)*/
PRIVATE void write_string ( char s [])
{
  char buf[MAX_3L_STRING_SIZE + 10];  /* Allow space for leading number */
  char *p = buf;
  char *ptr = addbuf_3L_str(buf, s);
  while (p != ptr)
    write_byte(*p++);
}
/*}}}  */
/*{{{  PRIVATE void write_instruction_patch (tag, offset, operand)*/
/*****************************************************************************
 *
 *  write_instruction_patch writes out an instruction patch record.
 *
 *****************************************************************************/
PRIVATE void write_instruction_patch ( int instruction , INT32 offset , int symbol )
{
  write_number((INT32)instruction);
  write_number(offset);
  write_number(C_CODEFIX);
  write_number((INT32)symbol);
}
/*}}}  */
/*{{{  PRIVATE int  write_ref (name)*/
/*****************************************************************************
 *
 *  write_ref writes out a reference record to name 'name' and returns the
 *            corresponding reference number.
 *
 *****************************************************************************/
PRIVATE int write_ref ( char *name )
{
  int r = refno;
  write_number(C_REF);
  write_string(name);
  refno = refno + 1;
  return(r);
}
/*}}}  */
#endif /* not TCOFF */

/*{{{  descriptor buffer handling              for the backend*/
/*{{{  PRIVATE int isformalparam(tptr)*/
PRIVATE int isformalparam ( treenode *tptr )
{
  return((TagOf(tptr) == N_PARAM) || (TagOf(tptr) == N_VALPARAM));
}
/*}}}  */
/*{{{  write_descprotocol forward declaration*/
PRIVATE void write_descprotocol PARMS((treenode *pptr0));
/*}}}  */
#ifndef TCOFF
/*{{{  PRIVATE void write_desc_buffer()*/
PRIVATE void write_desc_buffer ( void )
{
  write_number(C_DESC);
  desc_buffer[desc_buffer_ptr] = '\0';
  write_string(desc_buffer);
  desc_buffer_ptr = 0;
}
/*}}}  */
#endif /* not TCOFF */
/*{{{  PRIVATE void write_descstring(s)*/
PRIVATE void write_descstring ( char *s )
{
  int len = strlen(s);
#ifdef TCOFF
  if ((desc_buffer_ptr + len + 1) >= desc_buffer_size)
  {
    /*lexfatal(LEX_TCOFF_DESC_OVERFLOW, NOPOSN);*/

    /* This is basically a realloc */
    char *new;
    desc_buffer_size *= 2;
    DEBUG_MSG(("write_descstring: extending buffer to size %d\n", desc_buffer_size));
    new = memalloc(desc_buffer_size);
    memcpy(new, desc_buffer, desc_buffer_ptr);
    memfree(desc_buffer);
    desc_buffer = new;
  }
#else
  if ((desc_buffer_ptr + len + 1) >= DESC_BUFFER_SIZE)
    write_desc_buffer();
#endif
  strcpy(&(desc_buffer[desc_buffer_ptr]), s);
  desc_buffer_ptr += len;
}
/*}}}  */
/*{{{  PRIVATE void write_descnumber(n)*/
PRIVATE void write_descnumber ( INT32 n )
{
  char number_buffer[12];
  sprintf(number_buffer, "%ld", n);
  write_descstring(number_buffer);
}
/*}}}  */

/*{{{  PRIVATE void write_desctype(tptr)*/
PRIVATE void write_desctype ( treenode *tptr )
{
  switch(TagOf(tptr))
    {
      default:       write_descstring(tagstring(TagOf(tptr))); break;
      /*{{{  ARRAY*/
      case S_ARRAY:  write_descstring("[");
		     if (ARDimOf(tptr) != (-1))
		       write_descnumber((INT32)ARDimOf(tptr));
		     write_descstring("]");
		     write_desctype(ARTypeOf(tptr));
		     break;
      /*}}}  */
      /*{{{  CHAN/PORT*/
      case S_CHAN: case S_PORT:
        write_descstring(tagstring(TagOf(tptr)));
        write_descstring(" OF ");
        write_descprotocol(ProtocolOf(tptr));
        break;
      /*}}}  */
    }
}
/*}}}  */
/*{{{  PRIVATE void write_desctypelist(tptr)*/
PRIVATE void write_desctypelist ( treenode *tptr )
{
  if (!EndOfList(tptr))
    {
      write_desctype(ThisItem(tptr));
      tptr = NextItem(tptr);
    }
  while (!EndOfList(tptr))
    {
      write_descstring(",");
      write_desctype(ThisItem(tptr));
      tptr = NextItem(tptr);
    }
}
/*}}}  */
/*{{{  PRIVATE void write_descprotocol(pptr)*/
PRIVATE void write_descprotocol ( treenode *pptr )
{
  switch(TagOf(pptr))
    {
      case N_TPROTDEF:
      case N_SPROTDEF: write_descstring(WNameOf(NNameOf(pptr)));
		       break;
      case S_COLON2:   write_desctype(LeftOpOf(pptr));
		       write_descstring("::");
		       write_desctype(RightOpOf(pptr));
		       break;
      default:         write_desctype(pptr);
    }
}
/*}}}  */
/*{{{  PRIVATE void write_descparam(tptr)*/
PRIVATE void write_descparam ( treenode *nptr )
{
  if (TagOf(nptr) == N_VALPARAM) write_descstring("VAL ");
  write_desctype(NTypeOf(nptr));
  write_descstring(" ");
  write_descstring(WNameOf(NNameOf(nptr)));
}
/*}}}  */

/*{{{  PRIVATE void write_descheader(nptr)*/
PRIVATE void write_descheader ( treenode *nptr , wordnode *nameptr )
{
  treenode *params;
  if (TagOf(nptr) == N_PROCDEF)                 /* Write a PROC header */
    {
      params = NTypeOf(nptr);
      write_descstring("PROC ");
    }
  else                                            /* Write a FUNCTION header */
    {
      params = FnParamsOf(NTypeOf(nptr));
      write_desctypelist(FnTypeListOf(NTypeOf(nptr)));
      write_descstring(" FUNCTION ");
    }
  write_descstring(WNameOf(nameptr));
  write_descstring("(");
  /*{{{  write the parameters*/
  {
    /* Skip leading hidden parameters */
    while (!EndOfList(params) && !isformalparam(ThisItem(params)))
      params = NextItem(params);
  
    /* Write first visible parameter, if any */
    if (!EndOfList(params))
      {
        write_descparam(ThisItem(params));
        params = NextItem(params);
      }
  
    /* Write subsequent visible parameters, if any */
    while (!EndOfList(params))
      /*{{{  write this parameter, move to next*/
      {
        treenode *thisparam = ThisItem(params);
        if (isformalparam(thisparam))
	  {
      #ifdef TCOFF
	    write_descstring(",\n");
      #else
	    write_descstring(",");
	    write_desc_buffer();
      #endif
	    write_descparam(thisparam);
	  }
        params = NextItem(params);
      }
      /*}}}  */
  }
  /*}}}  */
#ifdef TCOFF
  write_descstring(")\n");
#else
  write_descstring(")");
#endif
}
/*}}}  */
/*{{{  PRIVATE void write_paramusage(nptr)*/
PRIVATE void write_paramusage ( treenode *nptr )
{
  treenode *params = NParamListOf(nptr);
  while (!EndOfList(params))
    /*{{{  write usage for this param*/
    {
      treenode *thisparam = ThisItem(params);
      if (TagOf(thisparam) == N_PARAM)
        {
	  treenode *type = NTypeOf(thisparam);
	  while (TagOf(type) == S_ARRAY) type = ARTypeOf(type);
	  if (TagOf(type) == S_CHAN || TagOf(type) == S_PORT)
	    {
	      if (paraminputon(thisparam))
	        {
		  write_descstring("    ");
		  write_descstring(WNameOf(NNameOf(thisparam)));
    #ifdef TCOFF
		  write_descstring("?\n");
    #else
		  write_descstring("?");
		  write_desc_buffer();
    #endif
	        }
	      if (paramoutputon(thisparam))
	        {
		  write_descstring("    ");
		  write_descstring(WNameOf(NNameOf(thisparam)));
    #ifdef TCOFF
		  write_descstring("!\n");
    #else
		  write_descstring("!");
		  write_desc_buffer();
    #endif
	        }
	    }
        }
      params = NextItem(params);
    }
    /*}}}  */
}
/*}}}  */
/*}}}  */
/*}}}  */


/*{{{  high level object file writing          for the code emitter*/
/*{{{  PUBLIC void write_id() ->LINKABLE, START_MODULE, etc */
PUBLIC void write_id ( char *libname, int write_lib_id )
{
#ifndef TCOFF
  int type;
  switch (processortype)
    {
      case T212_INSTR : type = T212_3L; break;
    /*case T414_INSTR : type = T414_3L; break;*/ /* TB is the same! */
      case T425_INSTR : type = T425_3L; break;
      case T800_INSTR : type = T800_3L; break;
      case TA_INSTR   : type = TA_3L;   break;
      case TB_INSTR   : type = TB_3L;   break;
    /*case TC_INSTR   : type = TC_3L;   break;*/ /* TC is obsolete */
    }

  if (write_lib_id)
    {
      char libstring[MAX_DESCSTRING_SIZE];
      strcpy(libstring, LIB_STRING_PREFIX);
      strcat(libstring, libname);
      write_number(C_LIBRARY);
      write_string(libstring);
    }

  write_number(C_NEWID);
  write_number(type);

  write_number((errormode & ERRORMODE_STOP)     ? STOP_3L       :
	       (errormode & ERRORMODE_REDUCED)  ? REDUCED_3L    :
	       (errormode & ERRORMODE_UNIVERSAL)? UNIVERSAL_3L  : HALT_3L);

  write_string(C_COMPATIBILITY);
  write_string(C_VERSION);
#else
  int text_base;
  char unique_id[MAX_FILENAME_LENGTH + 20]; /* used for assembling unique module id */

  DEBUG_MSG(("write_id\n"));
  libname = libname; /* stop warning */
  write_lib_id = write_lib_id; /* ditto */
/*sprintf(unique_id, "%s:%lX", sourcefilename, time(NULL));*/
  sprintf(unique_id, "%s:%08lX", sourcefilename, sourcehash);

#ifdef LINKED_OUTPUT_FILE
  tcoff_putrec (objfile, LINKED_UNIT_TAG, "");
  seek_position_of_startmodule = ftell(objfile);
#else
  tcoff_putrec (objfile, LINKABLE_TAG, "");
#endif
  tcoff_putrec (objfile, START_MODULE_TAG, "%ld%ld%ld%s",
	        processortype, processorattr,
  #ifdef LINKED_OUTPUT_FILE
	        LANG_LINKED,
  #else
	        language_name,
  #endif
	        /*unique_id*/ /* "" */ chanaspointer ? "" : "Old chans");
  tcoff_putrec (objfile, VERSION_TAG, "%s%s", compilername, sourcefilename);

#ifdef CONFIG
  if (!written_comment)
#endif
    {
    /*tcoff_putrec (objfile, COMMENT_TAG, "%ld%ld%s", FALSE, TRUE, C_COMPATIBILITY);*/
      tcoff_putrec (objfile, COMMENT_TAG, "%ld%ld%s", FALSE, TRUE, C_VERSION);
    #ifdef CONFIG
      written_comment = TRUE;
    #endif
    }
  text_base  = p_symbol_id (objfile, EXECUTE_SECTION | READ_SECTION,
				     EXPORT_USAGE, text_name, INVALID_SYMBOL_ID);
  tcoff_putrec (objfile, SET_LOAD_POINT_TAG, "%ld", text_base);
#ifndef LINKED_OUTPUT_FILE
  local_text = p_symbol_id (objfile, 0L, LOCAL_USAGE,  "local%text", INVALID_SYMBOL_ID);
  tcoff_putrec (objfile, DEFINE_LABEL_TAG,   "%ld", local_text);
#endif

  if (!(object_file_flags & OBJ_FILE_NO_EXPORT_ORIGINS))
    {
      exported_origin_id = p_symbol_id (objfile, 0L, ORIGIN_USAGE | EXPORT_USAGE, unique_id, INVALID_SYMBOL_ID);
    #ifdef LINKED_OUTPUT_FILE
      exported_origin_id = INVALID_SYMBOL_ID; /* don't use it for export */
    #else
      put_descriptor (exported_origin_id, "", ORIGIN_WS, 0);
    #endif
    }
  else
    exported_origin_id = INVALID_SYMBOL_ID;

#ifdef CONFIG
  if (!reversed_commentchain)
#endif
  {
    commentchain_t *reverser = NULL;
    /* reverse the commentchain to get them back into correct order */
    while (commentchain != NULL)
      {
        commentchain_t *next = commentchain->next;
        commentchain->next   = reverser;
        reverser             = commentchain;
        commentchain         = next;
      }
    commentchain = reverser;
  #ifdef CONFIG
    reversed_commentchain = TRUE;
  #endif
  }
  while (commentchain != NULL)
    {
    #ifndef CONFIG
      commentchain_t *temp = commentchain;
    #endif
    #if 0 /* This uses the dubious practice of 'running off' a struct */
      DEBUG_MSG(("Writing comment to object file: \"%s\"\n", commentchain->string));
      tcoff_putrec (objfile, COMMENT_TAG, "%ld%ld%s", FALSE, TRUE, commentchain->string);
    #else
      DEBUG_MSG(("Writing comment to object file: \"%s\"\n", commentchain->stringptr));
      tcoff_putrec (objfile, COMMENT_TAG, "%ld%ld%s", FALSE, TRUE, commentchain->stringptr);
    #endif
      commentchain = commentchain->next;
    #ifndef CONFIG /* we must not free this up when configuring, cos we must
		      write lots of object files */
    #if 1
      memfree(temp->stringptr);
    #endif
      memfree(temp);
    #endif
    }

#endif /* TCOFF */
}
/*}}}  */
/*{{{  void write_entry_desc*/
PUBLIC void write_entry_desc ( treenode *nptr, INT32 offset, int pass )
{
  DEBUG_MSG(("write_entry_desc: for \"%s\"\n", WNameOf(NNameOf(nptr))));

#ifdef TCOFF
  if (pass == 1)
    {
      int id;
    #ifndef LINKED_OUTPUT_FILE
      int label_ws, label_vs;
      char *str;
    #endif
      wordnode *nameptr = lookup_translations(trans_internals, NNameOf(nptr));
      desc_buffer_ptr = 0;
      write_descheader(nptr, nameptr);
      if (NNestedPriParOf(nptr))
        write_descstring("  PRI PAR\n");
      else
        write_descstring("  SEQ\n");
      write_paramusage(nptr);
      write_descstring(":");
      desc_buffer[desc_buffer_ptr] = '\0';

      id       = p_symbol_id (objfile, 0L, EXPORT_USAGE, WNameOf(nameptr), exported_origin_id);
    #ifndef LINKED_OUTPUT_FILE
      str      = str_concat (WNameOf(nameptr), "'ws");
      label_ws = p_symbol_id (objfile, 0L, EXPORT_USAGE | UNINDEXED_USAGE, str, exported_origin_id);
      memfree (str);
      str      = str_concat (WNameOf(nameptr), "'vs");
      label_vs = p_symbol_id (objfile, 0L, EXPORT_USAGE | UNINDEXED_USAGE, str, exported_origin_id);
      memfree (str);
    #endif

    #ifdef LINKED_OUTPUT_FILE
      tcoff_putrec (objfile, DEFINE_SYMBOL_TAG, "%ld%ld%ld", id, CO_VALUE_TAG, offset);
    #else
      tcoff_putrec (objfile, DEFINE_SYMBOL_TAG, "%ld%ld%ld%ld%ld%ld", id,
			     PLUS_OP, SV_VALUE_TAG, local_text,
				      CO_VALUE_TAG, offset);
      tcoff_putrec (objfile, DEFINE_SYMBOL_TAG, "%ld%ld%ld", label_ws, CO_VALUE_TAG, NPDatasizeOf(nptr));
      tcoff_putrec (objfile, DEFINE_SYMBOL_TAG, "%ld%ld%ld", label_vs, CO_VALUE_TAG, NPVSUsageOf(nptr));
    #endif
      put_descriptor (id, desc_buffer, NPDatasizeOf(nptr), NPVSUsageOf(nptr));

    #ifdef LINKED_OUTPUT_FILE
      tcoff_putrec (objfile, DEFINE_MAIN_TAG, "%ld", id);
    #endif

    }
#else
  if (pass == 1)
    {
      write_number(C_NEWENTRY);
      write_string(WNameOf(NNameOf(nptr)));
      write_number(offset);
      write_number(NPDatasizeOf(nptr));
      write_number(NPVSUsageOf(nptr));

      write_number(C_NEWENTRYSYMB);
      write_string(WNameOf(NNameOf(nptr)));
      write_number(offset);
      write_number(NPDatasizeOf(nptr));
      write_number(NPVSUsageOf(nptr));
    }
  else
    {
      write_descheader(nptr, NNameOf(nptr));    write_desc_buffer();
      if (NNestedPriParOf(nptr))
        write_descstring("  PRI PAR");
      else
        write_descstring("  SEQ");
      write_desc_buffer();
      write_paramusage(nptr);
      write_descstring(":");     write_desc_buffer();
    }
#endif
}
/*}}}  */
/*{{{  PUBLIC void write_library_calls (libcalls, instruction) ->loads of stuff*/
/*****************************************************************************
 *
 *  write_library_calls writes out the patch information for all library
 *                      routine calls on 'libcalls'
 *
 *****************************************************************************/
PUBLIC void write_library_calls ( treenode *libcalls , int instruction )
{
#ifdef TCOFF
#ifdef LINKED_OUTPUT_FILE  /* don't import anything if linked */
  libcalls = libcalls; instruction = instruction; /* stop warnings */
#else
  DEBUG_MSG(("write_library_calls\n"));

  {
    treenode *reverser = NULL;
    /* reverse the list of calls so that we need less 'ADJUST_POINT' tags */
    /* If you wanted, this bit could simply be left out.                  */
    while (libcalls != NULL)
      {
        treenode *next = NLEntryNextOf(libcalls);
        SetNLEntryNext(libcalls, reverser);
        reverser = libcalls;
        libcalls = next;
      }
    libcalls = reverser;
    /* Now the list is the same, but reversed */
  }

  if (libcalls != NULL)
  {
    INT32 adjust, pos = code_size;
    while (libcalls != NULL)
      {
        int label, origin_id = INVALID_SYMBOL_ID;
        wordnode *extern_name;
        module_t *module = get_procdef(libcalls, NOPOSN, FALSE)->p_module;
        DEBUG_MSG(("Libcall: \"%s\", refno %d, ", WNameOf(NNameOf(libcalls)), refno));
        extern_name = lookup_translations(trans_internals, NNameOf(libcalls));
        if (extern_name != NNameOf(libcalls))
	  DEBUG_MSG(("Translated to: \"%s\"\n", WNameOf(extern_name)));

        adjust = NLEntryOffsetOf (libcalls) - pos;
        pos    = NLEntryOffsetOf (libcalls) + libpatchsize;
        if (adjust != 0L)
	  tcoff_putrec (objfile, ADJUST_POINT_TAG, "%ld%ld", CO_VALUE_TAG, adjust);

        if (object_file_flags & OBJ_FILE_NO_IMPORT_ORIGINS)
	  DEBUG_MSG(("Not importing names\n"));
        else if (module->m_id_val == ORIGIN_NOT_FOUND)
	  /* imported from a lib, but no origin there */
	  DEBUG_MSG(("No origin\n"));
        else /* there is an origin for this entryname*/
	  {
	    if (module->m_id_val == ORIGIN_FOUND) /* not yet imported */
	      {
	        DEBUG_MSG(("First time found: \"%s\", set to %d, ",
			   WNameOf(module->m_name), refno));
	        module->m_id_val = p_symbol_id(objfile, 0L,
		       IMPORT_USAGE | ORIGIN_USAGE, WNameOf(module->m_name),
		       INVALID_SYMBOL_ID);
	      }
	    origin_id = module->m_id_val;
	  }

        label = p_symbol_id (objfile, 0L, IMPORT_USAGE,
			     WNameOf(extern_name), origin_id);
        tcoff_putrec (objfile, LOAD_PREFIX_TAG, "%ld%ld%ld%ld%ld%ld%ld",
			  libpatchsize, AP_VALUE_TAG,
			  MINUS_OP, SV_VALUE_TAG, label,
				    LP_VALUE_TAG,
			  (long int) instruction);

        libcalls = NLEntryNextOf(libcalls);
      }
    adjust = code_size - pos;
    if (adjust != 0L)
      tcoff_putrec (objfile, ADJUST_POINT_TAG, "%ld%ld", CO_VALUE_TAG, adjust);
   }
#endif
#else
  while (libcalls != NULL)
    {
      int ref = write_ref(WNameOf(NNameOf(libcalls)));
      write_instruction_patch(instruction, NLEntryOffsetOf(libcalls), ref);
      libcalls = NLEntryNextOf(libcalls);
    }
#endif
}
/*}}}  */
#ifdef LINKED_OUTPUT_FILE
/*{{{  PUBLIC void write_linker_map*/
PUBLIC void write_linker_map(char *filename, INT32 toplevel_size, long int seek_pos,
			     treenode *module_list)
{
  /* Each line looks like:
     SC filename (nnnnnnnn) nnnnnnnn nnnnnnnn : -
     Hence we need enough string space for filenames plus 36 or so.
     plus first line looks like:
     LINKER TCOFF
  */
  const int len_per_line = 40;
  int len = 50 + (strlen(filename) + len_per_line);
  treenode *list = module_list;
  INT32 tot_size = toplevel_size, start;
  char *buf, *ptr;

  while (!EndOfList(list))
    {
      module_t *module = (module_t *)ThisItem(list);
      len += strlen(lookupfilename(module->m_filenum)) + len_per_line;
      tot_size += module->m_size;
      list = NextItem(list);
    }

  buf = (char *)memalloc(len);
  sprintf(buf, "LINKER TCOFF (%s)\n", compilername);
  /*sprintf(buf, "LINKER TCOFF\n");*/
  ptr = buf + strlen(buf);
  start = tot_size - toplevel_size;
  sprintf(ptr, "SC %s (%ld) %ld %ld : -\n", filename, seek_pos, start, start + toplevel_size - 1);
  ptr += strlen(ptr);

  list = module_list;
  while (!EndOfList(list))
    {
      module_t *module = (module_t *)ThisItem(list);
      start -= module->m_size;
      sprintf(ptr, "PRE %s (%ld) %ld %ld : -\n",
	      lookupfilename(module->m_filenum),
	      module->m_seek_ptr,
	      start, start + module->m_size - 1);
      ptr += strlen(ptr);
      list = NextItem(list);
    }

  tcoff_putrec(objfile, COMMENT_TAG, "%ld%ld%s", FALSE, TRUE, buf);
  memfree(buf);
}
/*}}}  */
#endif
/*{{{  PUBLIC void write_debug_string(string, length)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  write_debug_string outputs a debug record to the object file.
 *
 *****************************************************************************/
/*}}}  */
PUBLIC void write_debug_string ( char string [], int length )
  {
#ifdef TCOFF
    size_t written;
    long int rec_len;
    rec_len = tcoff_sizel (FALSE) + tcoff_sizel (FALSE) +
	      tcoff_sizel ((long int) length) + (long int) length;
    tcoff_putl (objfile, COMMENT_TAG);
    tcoff_putl (objfile, rec_len);
    tcoff_putl (objfile, FALSE);
    tcoff_putl (objfile, FALSE);
    tcoff_putl (objfile, (long int) length);
    written = fwrite (string, sizeof (char), (size_t) length, objfile);
    if (written != length) write_error();
#else
    int i;
    write_number(C_DEBUG);
    write_number(length);
    for (i = 0; i < length; i++)
      write_byte((int)string[i]);
#endif
  }
/*}}}  */
/*{{{  PUBLIC void write_code_block_start*/
PUBLIC void write_code_block_start(size_t length)
{
#ifdef TCOFF
  if (length > 0)
  {
    long int rec_len;
    DEBUG_MSG(("write_code_block_start: writing total of %u bytes\n", length));
    rec_len = tcoff_sizel ((long int) length) + (long int) length;
    tcoff_putl (objfile, LOAD_TEXT_TAG);
    tcoff_putl (objfile, rec_len);
    tcoff_putl (objfile, (long int) length);
    /* following calls to write_code_block will write the data */
  }
  code_size = length;
#endif
}
/*}}}  */
/*{{{  PUBLIC void write_code_block*/
PUBLIC void write_code_block(size_t buflen, BYTE *buffer)
{
  DEBUG_MSG(("write_code_block: buflen is %u\n", buflen));
  if (buflen > 0)
  {
#ifdef TCOFF
    /* The tag, etc, has already been written by write_code_block_start */
    size_t written = fwrite(buffer, sizeof(char), buflen, objfile);
    if (written != buflen) write_error();
#else
    int i;
    write_number(C_CODE);
    write_number(buflen);
    for (i = 0; i < buflen; i++) write_byte((int)buffer[i]);
#endif 
  }
}
/*}}}  */
/*{{{  PUBLIC void write_total_code(module_size, sc_size)*/
PUBLIC void write_total_code(INT32 module_size /*, INT32 sc_size*/)
{
#ifdef TCOFF
  module_size = module_size /*+ sc_size*/; /* stop warning */
#else
  write_number(C_TOTALCODE);
  write_number(module_size);
  write_number(/*sc_size*/ 0);
#endif
}
/*}}}  */
/*{{{  PUBLIC void write_end_module ()*/
PUBLIC void write_end_module (void)
{
#ifdef TCOFF
  tcoff_putrec (objfile, END_MODULE_TAG, "");
#endif /* TCOFF */
}
/*}}}  */
#ifdef LINKED_OUTPUT_FILE
/*{{{  PUBLIC long int save_seek_position*/
PUBLIC long int saved_seek_position(void)
{
  return seek_position_of_startmodule;
}
/*}}}  */
#endif
/*}}}  */


#endif

/*{{{  translation handling*/
/*{{{  setup_translation(...) */
PUBLIC int setup_translation(wordnode *in_name, char *ex_name, int ex_len)
{
#ifdef TCOFF
  /*{{{  */
  translate_t *in, *ex;
  wordnode *trans_name = lookupword(ex_name, ex_len);
  int i;
  DEBUG_MSG(("setup_translation %s to \"%s\":%d\n", WNameOf(in_name), ex_name, ex_len));
  for (i = 0; i < ex_len; i++)
  if (ex_name[i] == '\0')
    {
      synwarn_s(SYN_TRANSLATE_NULL, flocn, WNameOf(in_name));
      return (FALSE);
    }
  in = search_translations(trans_internals, in_name);
  if (in != NULL)  /* Already translated this internal name */
    {
      if ((in->n_pair->n_name) == trans_name)
        return (TRUE);  /* We've already set up an identical translation */
       /* This 'internal' symbol has already been used in a translation */
      synwarn_s(SYN_TRANSLATE_DUPLICATE_IN, flocn, WNameOf(in_name));
      return (FALSE);
    }
  if (search_translations(trans_externals, trans_name) != NULL)
    { /* This 'external' symbol has already been used in a translation */
      synwarn_s(SYN_TRANSLATE_DUPLICATE_EX, flocn, ex_name);
      return (FALSE);
    }
  /*if (search_libentries(globalnames, trans_name) != NULL)*/
  if ((search_libentries(globalnames,   in_name   ) != NULL) ||
      (search_libentries(globalnames,   trans_name) != NULL) ||
      (search_libentries(thrownentries, trans_name) != NULL))
    { /* This 'external' symbol has already been loaded by a #USE */
      synwarn_s(SYN_TRANSLATE_SEQUENCE, flocn, ex_name);
      return(FALSE);
    }
  /* use newvec here rather than memalloc, cos we never free the space */
  in = (translate_t *)newvec(sizeof (translate_t));
  ex = (translate_t *)newvec(sizeof (translate_t));
  in->n_name = in_name;
  in->n_pair = ex;
  in->n_next = trans_internals;
  ex->n_name = trans_name;
  ex->n_pair = in;
  ex->n_next = trans_externals;
  trans_internals = in;
  trans_externals = ex;
  return (TRUE);
  /*}}}  */
#else
  return FALSE;
#endif
}
/*}}}  */
/*}}}  */

#ifndef CONFIG
/* we don't bother with this when configuring cos it will never be linked */
/*{{{  linkage section name handling*/
/*{{{  PRIVATE char *str_duplicate (str)*/
PRIVATE char *str_duplicate ( const char *str )
{
  const int l = strlen(str);
  char *newstr = (memalloc (1 + l));
  (void) strcpy (newstr, str);
  return (newstr);
}
/*}}}  */
/*{{{  setup_text_name(...) */
PUBLIC int setup_text_name(char *name, int len)
{
#ifdef TCOFF
  len = len; /* stop unused variable warning */
  DEBUG_MSG(("setup_text_name \"%s\":%d\n", name, len));

  if (name == NULL)
    text_name = text_name_priority;
  else
    text_name = str_duplicate(name);
#endif
  return (TRUE);
}
/*}}}  */
/*}}}  */
#endif

/*{{{  calc_len_and_hash*/
PUBLIC int calc_len_and_hash(char *string)
{
  register char *s = string;
  register BIT32 hash = sourcehash;  /* copy into temporary for fast access */

  while (*s != '\0')
    hash ^= (*s++);

  sourcehash = ((hash & 0x80000000) ? (hash << 1) + 1 : (hash << 1)); /* rotate */
  return (s - string);
}
/*}}}  */
/*{{{  hash_BIT32*/
PRIVATE void hash_BIT32 (const BIT32 n)
{
  sourcehash ^= n;
}
/*}}}  */


/*{{{  void descinit()*/
/*****************************************************************************
 *
 *  descinit initialises the nested SC structures
 *
 *****************************************************************************/
PUBLIC void descinit ()
{
#ifdef TCOFF
  /* We ensure that the hash code is unique for any different compilation
     options */
  sourcehash = 0xdefaced;
  if ((object_file_flags & OBJ_FILE_NO_HASH_VERSION) == 0)
    (void) calc_len_and_hash(C_VERSION);
  hash_BIT32 (processortype);
  hash_BIT32 (processorattr);
  hash_BIT32 (errormode);
  hash_BIT32 ((int)((checkalias << 1) | checkusage));

  current_module_seekpos = 0;
  text_name = (object_file_flags & OBJ_FILE_PRI_TEXT_SECTION) ?
	      text_name_priority : text_name_default;

  trans_internals = NULL;
  trans_externals = NULL;

  language_name = (object_file_flags & OBJ_FILE_OCCAM_HARNESS) ?
		   LANG_OCCAM_HARNESS : LANG_OCCAM;

  if (desc_buffer == NULL)
    desc_buffer = memalloc(desc_buffer_size);
#endif
  refno = 0;
  /*sctableptr = 0;*/ /* #SC is no longer supported */
  entrypointlist = NULL;
#ifndef CONFIG /* no #PRAGMA EXTERNAL when configuring */
  extern_buf = NULL;
  extern_status = 0;
#endif
  libentries = NULL;
  localmodules = NULL;
  commentchain = NULL;
}
/*}}}  */
/*}}}  */
