/******************************************************************************
*
*  occam configurer header
*
*
******************************************************************************/

/*{{{   copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1990
*
******************************************************************************/
/*}}}*/

/*{{{  Structure definitions for hardware graphs */
struct namedesc_s /* used to describe a name and/or link etc */
  {
    treenode *n_name;   /* The namenode of the base declaration */
    INT32     n_index;  /* The index into the flattened array */
  };
typedef struct namedesc_s namedesc_t;

struct connection_s; /* forward declaration */
struct chanswnode_s; /* forward declaration */

struct edgehwnode_s /* EDGE hardware node */
  {
    struct connection_s *e_conn; /* pointer to relevant connection */
  };
typedef struct edgehwnode_s edgehwnode_t;

#define MAX_PROC_LINKS 4
/*
   if this goes above 8 will have to modify typedef linkbits_t
*/
typedef unsigned char linkbits_t;

struct prochwnode_s /* processor's hardware node */
  {
    struct namedesc_s      p_name;      /* processor's name */
    wordnode              *p_type;      /* processor type */
    linkbits_t             p_linkbits;  /* bit map of output links used */
    char                   p_bpw;       /* bytes per word */
    char                   p_links;     /* number of links */
    char                   p_connected; /* whether connected to the rest */
    INT32                  p_mem;       /* memory size */
    INT32                  p_ordercode; /* Priority of code section */
    INT32                  p_ordervs;   /* Priority of VS   section */
    struct edgehwnode_s p_edge[MAX_PROC_LINKS];
    void                  *p_nameexp;   /* Cached copy of backend expression */
  };
typedef struct prochwnode_s prochwnode_t;

#define PROCNODE_INIT_MEMVAL (-1)
#define DEFAULT_ORDER_VALUE  0

struct archwnode_s /* ARC hardware node */
  {
    struct namedesc_s    a_name;    /* arc's name */
    struct connection_s *a_conn;    /* pointer to relevant connection */
    /*int                a_usage;*/ /* used to check direction usage of arc */
    struct chanswnode_s *a_usage[2][2];  /* two ends; two directions */
    /* first  index: 0 is end 0; 1 is end 1. (of the connection)
       second index: 0 is input; 1 is output.
    */
    /*int                a_used;*/  /* TRUE if any channel placed onto arc */
  };
typedef struct archwnode_s archwnode_t;

struct edgedesc_s /* describes an edge */
  {
    int                  e_link; /* link number or EDGENODE_NO_LINK */
    union {
    struct prochwnode_s *e_proc; /* pointer to proc record */
    struct namedesc_s    e_edge; /* or actual name of edge */
          }              e_un;
  };
typedef struct edgedesc_s edgedesc_t;

struct connection_s /* hardware connection */
  {
    struct archwnode_s  *c_arc;     /* the arc which names the connection */
    struct edgedesc_s    c_edge[2]; /* the two connected edges */
    struct connection_s *c_next;    /* chain of all connections */
  };
typedef struct connection_s connection_t;
#define EDGENODE_NO_LINK (-1)

/*}}}*/

/*{{{  Structure definitions for software graphs */
struct procswnode_s  /* processor's software node */
  {
    struct namedesc_s p_name; /* processor's name */
    int       p_count;    /* number of PROCESSOR statements for that processor */
    varlist  *p_varlist;  /* free variable list */
    treenode *p_specs;    /* A copy of the outermost specifications */
    treenode *p_fparams;  /* Formal parameter list (channel parameters) */
    treenode *p_locals;   /* Local channels used for both directions */
    treenode *p_process;  /* The body of that processor */
    treenode *p_modules;  /* List of modules for that processor */
    INT32     p_ws, p_vs; /* Workspace and vectorspace requirements of body */
    INT32     p_offset;   /* Entry point offset of body */
    INT32     p_size;     /* Code size of body */
    long int  p_seek;     /* Seek value in the object file */
    wordnode *p_procname; /* procedure's name */
    void     *p_procnameexp; /* cached version of backend's Expression node */
  };
typedef struct procswnode_s procswnode_t;

struct chan_dir_s /* Chan direction node */
  {
    struct procswnode_s *c_proc;      /* which processors are connected */
    struct namedesc_s    c_id;        /* formal param names */
  };
typedef struct chan_dir_s chan_dir_t;

struct chanswnode_s /* CHAN software node */
  {
    struct namedesc_s    c_name;          /* channel's name */
    struct archwnode_s  *c_arc;           /* Named connection */
    chan_dir_t           c_dirn[2];       /* details for input and output */
  };
typedef struct chanswnode_s chanswnode_t;
/*}}}*/

/*{{{  Structure definitions for logical graphs*/
struct logicalprocnode_s /* logical processor node */
  {
    struct procswnode_s *p_translation; /* physical proc */
    INT32                p_priority;    /* priority */
  };
typedef struct logicalprocnode_s logicalprocnode_t;

#define PRIORITY_HI 0
#define PRIORITY_LO 1
struct chanabbrnode_s /* CHAN abbreviation node */
  {
    struct chanswnode_s *c_abbr;
  };
typedef struct chanabbrnode_s chanabbrnode_t;
/*}}}*/

/*{{{  Access to hardware graph from normal tree*/
typedef enum
  {
    C_DECLNODE_DEVICE,  C_DECLNODE_EDGE,     C_DECLNODE_ARC, C_DECLNODE_CHAN,
    C_DECLNODE_LOGICAL, C_DECLNODE_CHANABBR, C_DECLNODE_EDGEABBR
  } c_declnode_tag;

typedef struct /* Configuration node's declaration */
  {
    c_declnode_tag c_nodetype; /* type of declaration */
    void          *c_hwnodes;  /* pointer to array of hardware nodes */
    void          *c_swnodes;  /* pointer to equivalent software nodes */
  } c_declnode_t;

#define NVGraphOf(N)    ((c_declnode_t *)NVNextTempOf(N))
#define SetNVGraph(N,V) SetNVNextTemp(N,(treenode *)(V))

/* This is used for channel formal parameters */
#define NVDirectionOf(N)       NVVarNumOf(N)
#define SetNVDirectionOf(N, V) SetNVVarNum(N,(V))
/*}}}*/

/*{{{  Access to direction info of channels and arcs */
#define DIRN_IN  0
#define DIRN_OUT 1

#define DIRN_START (DIRN_IN)
#define DIRN_END   (DIRN_OUT + 1)
/*}}}*/

/*{{{  Name translation bits*/
#define INPUT_SUFFIX    "_i"     /* Used for input channels  */
#define OUTPUT_SUFFIX   "_o"     /* Used for output channels */
#define PROCNAME_SUFFIX "_p"     /* Used for unmapped processes */

#define PARSEABLE_SEPARATOR "_"  /* Used between subscripts */

/*}}}*/
