/****************************************************************************
 *
 *  Occam two compiler  harness   definitions
 *
 ****************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
*  %Z%%M% %I%
*
******************************************************************************/
/*}}}*/

/*extern char *C_COMPATIBILITY;*/ /* no longer used */
extern char C_VERSION[];
extern char *compilername;
extern char *compilerfunction;

/*{{{  global variables*/
extern FILE *infile, *outfile, *errfile, *objfile;
extern char sourcefilename[];
extern char objfilename[];
extern char extlibfilename[];
extern char vlibsfilename[];
extern char pathname[];
/* Processor attributes */
extern BIT32 processortype, processorattr;
extern int targetintsize, bytesperword;
extern int real32isaword;
extern int fpinline, hasdup, haswsubdb, fpsupport, graphicsmove,
    hascrc, hasbitops, fracmul, debugsupport, haslddevid, haspop,
    fptesterr, hastimerdis, hasldmemstart;
extern int H1_instr;
extern int H1L_process;
extern int onlylex;
extern int nochecking;
extern int checkalias, checkusage;
extern int errormode;
/*extern int compilemode;*/ /* never used */
extern int vsenabled;
extern int guyinserts;
extern int information;
extern int disassemble;
extern int assembly_output, diagnostics;
extern int debuguse;
extern int brieferrors;
extern int debugoutput;
extern int minimal_debugoutput; /* Just enough for backtracing */
extern int symbolic_debugoutput;
extern int source_output;
extern int iobycall;
extern int chanaspointer;
extern int stdlibsenabled;
extern int vlibsenabled;
extern int allowpredefs;

extern int hidelibnames;        /* Whether to use the 'hidden' REALOP etc */
extern int libpatchsize;        /* How many bytes to use for libpatch */
extern int code_style_flags;    /* Flags for variations in code style */
extern int warning_flags;       /* Which warnings are enabled */
extern char *predefsuffix;      /* Extra suffix for predefined routines */
extern char *compilersuffix;    /* Extra suffix for compiler library names */
extern char *vlibsuffix;        /* Extra suffix for i/o library names */

extern int prtree;
extern int testflag;

#ifdef COMMENT   /* Experimental data flow analysis */
extern int dfa_info;
extern int usedags;
#endif
/*}}}*/
/*{{{  procedures*/
BIT32 setprocessor PARMS((char *));
void setprocessorattr PARMS((void));
void setprocessordefault PARMS((void));
BIT32 typeofprocessor PARMS((char *name));
char *processorstring PARMS((BIT32 p, BIT32 a));

int setup_version_string PARMS((void));
void add_default_extension PARMS((char *filename));
int process_option PARMS((char *s));
void allocateworkspace PARMS((treenode *treeroot ));
void codegenerate PARMS((int open_file, treenode *treeroot ));
void end_compiler PARMS((int result));
void print_memstats PARMS((void));
/*}}}*/

/*{{{  error modes*/
#define ERRORMODE_RANGECHECK            (0x1)
#define ERRORMODE_CONVERSIONCHECK       (0x2)
#define ERRORMODE_NEED_ERRORS           (0x4)
#define ERRORMODE_TIMESLICECHECK        (0x8)
#define ERRORMODE_NEED_STOPERR          (0x10)
#define ERRORMODE_STOP_IS_SETERR        (0x20)
#define ERRORMODE_STOP_IS_STOPP         (0x40)

/* These flags are all coupled together: */
#define ERRORMODE_SHIFTCHECK ERRORMODE_NEED_ERRORS
#define ERRORMODE_ALIGNCHECK ERRORMODE_NEED_ERRORS
#define ERRORMODE_REPLCHECK  ERRORMODE_NEED_ERRORS

#define ERRORMODE_HALT                  (0x1000)
#define ERRORMODE_STOP                  (0x2000)
#define ERRORMODE_REDUCED               (0x4000) /* no longer used */
#define ERRORMODE_UNIVERSAL             (0x8000)

#define RANGECHECKING           (errormode & ERRORMODE_RANGECHECK)
#define CONVERSIONCHECKING      (errormode & ERRORMODE_CONVERSIONCHECK)
#define NEED_ERRORS             (errormode & ERRORMODE_NEED_ERRORS)
/*}}}*/

/*{{{  warning flags*/
#define WARNING_OVERLAPS (0x01)  /* Run-time overlap checks */
#define WARNING_UNUSED_V (0x02)  /* Unused variables  */
#define WARNING_UNUSED_R (0x04)  /* Unused routines   */
#define WARNING_UNUSED_P (0x08)  /* Unused parameters */
#define WARNING_DESCOPED_N (0x10)  /* Warn when descoping a name by a name*/
#define WARNING_DESCOPED_P (0x20)  /* Warn when descoping a name by a param*/
/*#define WARNING_CSE      (0x4)*/ /* Common subexpression elimination UNUSED */

#define WARNING_DEFAULT  (WARNING_UNUSED_V | WARNING_UNUSED_R | WARNING_UNUSED_P)
/*}}}*/

/*{{{  code style bits*/
#define CODE_STYLE_DEFAULT      0       /* All off */
#define CODE_STYLE_ALT_PRI_PAR  0x1     /* Use ALT for PRI PAR */
#define CODE_STYLE_CJ_NOT_J     0x2     /* Use ldc 0; cj rather than j */
/*}}}*/

#ifndef EXIT_SUCCESS  /* Might be defined in stdlib */
  #ifdef DEC
    #define EXIT_SUCCESS 1
    #define EXIT_FAILURE 42
  #else
    #define EXIT_SUCCESS 0
    #define EXIT_FAILURE 1
  #endif
#endif


