/******************************************************************************
*
*  Code generator  genhdr.h
*
******************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
*  @(#)genhdr.h 1.5
*
******************************************************************************/
/*}}}*/

/*{{{  special namenode values*/
/* Workspace offset of name which doesn't have an offset */
#define NO_SLOT 0x80000000
/*}}}*/

/*{{{  static link, vector space, constant pointer constants*/
#define MAX_LEX_LEVELS           254
#define STATICLINK_NOT_USED      0xFF    /* an illegal lexical level */
#define CONSTANTPOINTER_NOT_USED NO_SLOT /* an impossible offset */

/* Fields within an entry in staticlinkoffsets */
#define OFFSET_BITS 0x7fffffff
#define REPL_FLAG   0x80000000

/* An object of size greater than MAX_WS_BYTES bytes will be placed in vector
   space if vector space is enabled, otherwise the object will be placed in
   workspace: vector space should really be called 'large object space' */
#define MAX_WS_BYTES 8
/*}}}*/
/*{{{  expression evaluation constants*/
#define MAXREGS 3
#define MAXFPUREGS 3
#define MANY_REGS (-1)
/*}}}*/
/*{{{  compilation types*/
#define COMP_PROGRAM 0
#define COMP_SC      1
#define COMP_LIB     2
/*}}}*/
/*{{{  expression modes*/
#define P_EXP     1   /* operand is an expression */
#define P_TEMP    2   /* operand is an evaluated temporary */
#define P_TEMPPTR 3   /* operand is an evaluated temporary pointer */
#define P_PTR     4   /* operand is a pointer */
/*}}}*/
/*{{{  abbreviation modes*/
#define AM_CONST 0
#define AM_ISRHS 1
#define AM_VAL   2
#define AM_PTR   3
/*}}}*/
/*{{{  constants for below workspace data requirements*/
#if 0
#define DS_MIN  2   /* All processes need at least two slots */
#define DS_IO   3   /* Processes using channels need three slots */
#define DS_WAIT 5   /* Processes using timers need five slots */
#else
/* if H1L_process is 1 (TRUE), then add 1 to each of these: */
#define DS_MIN  (2 + H1L_process) /* All processes need at two(three) slots */
#define DS_IO   (3 + H1L_process) /* Processes using channels need three(four) slots */
#define DS_WAIT (5 + H1L_process) /* Processes using timers need five(six) slots */
#endif
#define HIGH_PRI_TRAP_OFFSET 20   /* H1 L-process's high priority trap handler */
                                  /* is at this many words from low pri one */

/* Three below workspace slots contain the register parameters */
#define REG_PARAMS MAXREGS
/* One below workspace slot contains the return address */
#define INS_EXTRA  ((INT32)1)
/*}}}*/
/*{{{  constants used when generating replicators*/
/* Offsets from replicator workspace position of the components of a
   replicator */
#define REPL_BASE 0
#define REPL_COUNT 1
/*#define REPL_SELECTED 2*/ /* For an ALT replicator, the selected value */
/*}}}*/
/*{{{  constants used when generating repl PAR*/
/* Offsets from wptr when setting up repl PAR */
#define MIN_REPLPAR_SLOTS 3  /* Minimum number of slots required to set up */
                             /* a repl PAR: par join, count & tempws  */
#define REPLPAR_WS_TEMP   2  /* Temp. slot for calculating repl wptrs */
#define REPLPAR_VS_TEMP   3  /* Temp. slot for calculating repl vsps  */

/* Special slots in a replicated PAR process' workspace */
/* These are above any variables local to the process */
#define MIN_REPLPAR_SPECIALS 2 /* Minimum number of special slots */
#define REPLPAR_REPLICATOR 0 /* Local value of replicator */
#define REPLPAR_STATICLINK 1 /* Link to workspace of invoking process */
#define REPLPAR_VSP        2 /* Vector space pointer (may not be needed) */
/*}}}*/
/*{{{  constants used when generating input/output*/
#define INP_INPUT         1
#define INP_TIMER_INPUT   2
#define INP_PORT_INPUT    3
#define INP_DELAYED_INPUT 4
#define INP_SKIP          5
#define INP_CASE_INPUT    6
#define INP_TAGGED_INPUT  7
/*}}}*/
/*{{{  constants used when deciding how to load a constant*/
/* If a constant takes more than CONST_MAX_BYTES to load, then place it in a
   constant table */
#define CONST_MAX_BYTES 6

#define ADCNEG_INT16 (-32753)        /* 0xFFFF800F */
#define ADCNEG_INT32 (-2146435073)   /* 0x800FFFFF */

#define LDNLPNEG_INT16 (-32705)      /* 0xFFFF803F */
#define LDNLPNEG_INT32 (-2143289345) /* 0x803FFFFF */

#define LDINF_NEG_WORD (0x7F7FC000)
#define LDINF_POS_WORD (0x7F803FFF)
#define LDINF_NEG_BYTE (0x7F7FF000)
#define LDINF_POS_BYTE (0x7F800FFF)
/*}}}*/
/*{{{  constants used inside predefines */
#define INFINITY (0x7F800000)
/*}}}*/

/* Optimising local channels when chanaspointer is true breaks
   when you try to RETYPE channels */
/* This has now been fixed to notice that special case */
#define OPTIMISE_LOCAL_CHANS TRUE

/* This is used to check for links being placed on the top of the
   debugger's links */
#define NO_OF_LINKS 4
