/*#define DEBUG*/
/******************************************************************************
*
*  Code generator gen8 - Procedure, function and valof instance generation
*
******************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
*
******************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include "includes.h"
# include "instruct.h"
# include "generror.h"
# include "genhdr.h"
# include "chkdef.h"
# include "predefhd.h"
# include "trandef.h"
# include "bind1def.h"
# include "bind2def.h"
# include "bind3def.h"
# include "gen1def.h"
# include "gen2def.h"
# include "gen4def.h"
# include "gen8def.h"
# include "gen11def.h"
# include "gen12def.h"
# include "code1def.h"
/*}}}*/

/*{{{  constants and definitions*/
typedef struct
  {
    int pmaxparamslotused;
    int pnestedfunctions;
    int pevaluated;
    int pmode;
    treenode **pparamexp;
    treenode *pformaltype;
  } paraminfo_t;

#define MAX_PREDEFPARAMS 20
#define MAX_PREDEFDESTS  3

PUBLIC int ignore_assertions = FALSE;

/*{{{  private variables*/
PRIVATE treenode **valofdestlist;
/*}}}*/

/*{{{  private routines*/
/*{{{  PRIVATE treenode *hiddenparamnodeof(aparam, dimension)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  hiddenparamnodeof takes an actual parameter expression and a dimension
 *                    number and returns a pointer to a bit of tree
 *                    representing that dimension of the actual parameter.
 *                    This will normally be a pointer to the array node
 *                    in the type field of the name of the parameter.
 *                    However, the dimension may be a segment length expression
 *                    in which case we return a pointer to that expression.
 *                    This isn't really satisfactory as the expression is
 *                    liable to get transformed later on!
 *                    At the moment, though, if a segment length is to be
 *                    transformed, ie. a temp node inserted to preevaluate it
 *                    into, this will be done by mappreprocess, which will
 *                    already have run.
 *
 *                    This routine also works when augmenting formal  parameter
 *                    lists: it will return a pointer to the array node in the
 *                    type field of the formal parameter name node.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE treenode *hiddenparamnodeof ( treenode *aparam , int dimension )
{
#if 0 /* This creates a cross-link in the tree */
  return(newhiddenparamnode(S_HIDDEN_PARAM, 0, dimexpof(aparam, dimension),
                                               dimension));
#else /* no cross-links - bug 1107 16/1/91 */
  return(newhiddenparamnode(S_HIDDEN_PARAM, 0, copytree(dimexpof(aparam, dimension)),
                                               dimension));
#endif
}
/*}}}*/
/*{{{  PRIVATE buildchecktree(treenode *exp, treenode *range, treenode *extent)*/
/*{{{  comment*/
/*****************************************************************************
 *
 * buildchecktree builds, constant folds, and returns the tree
 *
 *  OLD:                 csub0              Failed to detect negative extent,
 *                     /       \            and disallowed (exp + extent) = 0
 *                   add       range
 *                /      \
 *            csub0       subtract
 *           /    \       /      \
 *         exp   range   extent   1
 *
 *  NEW:                  csub0
 *                       /       \
 *                   add           plus
 *                /      \         |    \
 *            csub0       csub0   range  1
 *           /    \       /     \
 *         exp   range   extent  mint
 *
 *  IE: 0 <= exp < range AND extent >= 0 AND 0 <= (exp + extent) <= range
 *
 *****************************************************************************/
/*}}}*/
PRIVATE treenode *buildchecktree ( treenode *exp , treenode *range , treenode *extent )
{
  SOURCEPOSN locn = LocnOf(exp);
  treenode *checkexp, *mint, *size;

/*checkexp = newdopnode(S_CSUB0, locn, exp, range, S_INT);
  extent = newdopnode(S_SUBTRACT, locn,
             extent, newconstant(1), S_INT);
  checkexp = newdopnode(S_ADD, locn, checkexp, extent, S_INT);
  checkexp = newdopnode(S_CSUB0, locn, checkexp, range, S_INT);
  checkexp = foldexp(checkexp);
*/
  mint     = newconstexpnode(S_CONSTEXP, locn, dummyexp_p, ZERO32,
             ((targetintsize == S_INT16) ? MOSTNEG_INT16 : MOSTNEG_INT32));
  checkexp = newdopnode(S_CSUB0, locn, exp,      range,  S_INT);
  extent   = newdopnode(S_CSUB0, locn, extent,   mint,   S_INT);
  checkexp = newdopnode(S_ADD,   locn, checkexp, extent, S_INT);
  size     = newdopnode(S_PLUS,  locn, range,    newconstant(1), S_INT);
  checkexp = newdopnode(S_CSUB0, locn, checkexp, size,   S_INT);
  checkexp = foldexp(checkexp);
  return isconst(checkexp) ? NULL : checkexp;
}
/*}}}*/
/*{{{  PRIVATE int mapevalexp(int expmode, treenode **exp)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  mapevalexp takes the expression (expmode, exp) and if it requires
 *             more than one register to generate, maps the evaluation
 *             of it into a temporary, updating exp. returns new expmode.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE int mapevalexp ( int expmode , treenode **exp )
{
  if (regsforopd(expmode, *exp) > 1)
    {
      mapexpopd(expmode, exp);
      *exp = gettemp(*exp, NM_WORKSPACE);
      upusecount(*exp, 1);
      return tempmodeof(expmode);
    }
  return expmode;
}
/*}}}*/
/*{{{  PRIVATE int findinstances (tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  findinstances searches through an expression tree, tptr, looking for
 *                nested functions.  If no nested functions are found, the
 *                value returned is -1, otherwise the value returned is
 *                the number of parameters of the function with most parameters
 *                in the expression.
 *
 *                Now extended to cope with in-line VALOFs, it will also
 *                search through VALOF bodies for both function and
 *                procedure instances as above.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE int findinstances ( treenode *tptr )
{
  while (tptr != NULL)
    {
      DEBUG_MSG(("findinstances : %s\n", itagstring(TagOf(tptr))));
      switch(nodetypeoftag(TagOf(tptr)))
        {
          /*{{{  expressions*/
          /*{{{  monadic operators*/
          case MOPNODE:
            if (TagOf(tptr) == S_ELSIZE)
              return (-1);
            else
              return max(implicitparams(TagOf(tptr), MOpTypeOf(tptr)),
                         findinstances(OpOf(tptr)));
          /*}}}*/
          /*{{{  dyadic operators*/
          case DOPNODE:
            {
              int m = implicitparams(TagOf(tptr), DOpTypeOf(tptr));
              return(max(m, max(findinstances(LeftOpOf(tptr)),
                                findinstances(RightOpOf(tptr)) ) ));
            }
          /*}}}*/
          /*{{{  constant expression*/
          case CONSTEXPNODE: case CONSTTABLENODE:
          case HIDDENPARAMNODE:
          case LEAFNODE:
          case WORDNODE: /* added for S_GUYCODE and S_GUYSTEP */
            return(-1);
          /*}}}*/
          /*{{{  function instance*/
          case INSTANCENODE:
            {
              int pdreq = pdparams(tptr);
              DEBUG_MSG(("findinstances: pdparams returned %d\n", pdreq));
              return(max(pdreq,
                         max((int)NPParamsOf(INameOf(tptr)),
                             findinstances(IParamListOf(tptr)) )));
            }
          /*}}}*/
          /*{{{  subscript or segment*/
          case ARRAYSUBNODE:
            if (TagOf(tptr) == S_ARRAYITEM)
              return findinstances(ASExpOf(tptr));
            else
              return(findinstances(ASBaseOf(tptr)));

          case SEGMENTNODE:
            {
              int m = findinstances(SStartExpOf(tptr));
              m = max(m, findinstances(SLengthExpOf(tptr)));
              return(max(m, findinstances(SNameOf(tptr))));
            }
          /*}}}*/
          /*{{{  name*/
          case NAMENODE:
            switch(TagOf(tptr))
              {
                case T_TEMP: case T_PREEVALTEMP:
                  return(findinstances(NDeclOf(tptr)));
                default:
                  return(-1);
              }
          /*}}}*/
          /*{{{  specification ... valof*/
          case DECLNODE:
            {
              int max_i = -1;
              while (isspecification(tptr))
                {
                  max_i = max(max_i, findinstances(DValOf(tptr)));
                  tptr = DBodyOf(tptr);
                }
              return max(max_i, findinstances(tptr));
            }
          case VALOFNODE:
            return (max(findinstances(VLBodyOf(tptr)),
                        findinstances(VLResultListOf(tptr))));
          /*}}}*/
          /*}}}*/
          /*{{{  processes  (inside a VALOF)*/
          /*{{{  SEQ IF*/
          case CNODE:
            return(findinstances(CBodyOf(tptr)));
          /*}}}*/
          /*{{{  REPLSEQ REPLIF*/
          case REPLCNODE:
            return(max(findinstances(ReplCStartExpOf(tptr)),
                   max(findinstances(ReplCLengthExpOf(tptr)),
                       findinstances(ReplCBodyOf(tptr)))));
          /*}}}*/
          /*{{{  WHILE CHOICE*/
          case CONDNODE:
            return(max(findinstances(CondGuardOf(tptr)),
                       findinstances(CondBodyOf(tptr))));
          /*}}}*/
          /*{{{  CASE*/
          case ACTIONNODE:
            return(max(findinstances(LHSOf(tptr)),
                       findinstances(RHSOf(tptr))));
          /*}}}*/
          /*{{{  LIST*/
          case LISTNODE:
            {
              int m = -1;
              while (!EndOfList(tptr))
                {
                  m = max(m, findinstances(ThisItem(tptr)));
                  tptr = NextItem(tptr);
                }
              return(m);
            }
          /*}}}*/
          /*}}}*/
          default:
            badtag(genlocn, TagOf(tptr), "findinstances");
        }
    }
  return(-1);
}
/*}}}*/

#if 0 /* no longer used */
/*{{{  PRIVATE int maxparamslot (paramtable, nparams)*/
/*****************************************************************************
 *
 *  maxparamslot returns the highest workspace parameter slot required to
 *               evaluate all unevaluated parameters in the paramtable.
 *
 *****************************************************************************/
PRIVATE int maxparamslot ( paraminfo_t paramtable [], int nparams )
{
  int i;
  int p = -1;
  for (i = 0; i < nparams; i++)
    {
      if (!paramtable[i].pevaluated)
        p = max(p, paramtable[i].pmaxparamslotused);
    }
  return(p);
}
/*}}}*/
#endif
/*{{{  PRIVATE void loadparamtable(paramtable, nparams, instanceptr)*/
/*****************************************************************************
 *
 *  loadparamtable loads up the table 'paramtable' with lots of crucial
 *                 info. on the actual parameters contained in the tree
 *                 'instanceptr'. nparams is the number of actual parameters
 *                 including any hidden ones.
 *
 *****************************************************************************/
PRIVATE void loadparamtable ( paraminfo_t paramtable [], int nparams , treenode *instanceptr )
{
  treenode *nptr = INameOf(instanceptr);
  treenode *aparams = IParamListOf(instanceptr);
  treenode *fparams = NTypeOf(nptr);
  int i;
  DEBUG_MSG(("loadparamtable\n"));
  if (TagOf(instanceptr) == S_FINSTANCE) fparams = FnParamsOf(fparams);
  for (i = 0; i < nparams; i++)
    /*{{{  set information for parameter i*/
    {
      /*{{{  skip over TIMER parameters*/
      while (basetype(gettype(ThisItem(fparams))) == S_TIMER)
        {
          fparams = NextItem(fparams);
          aparams = NextItem(aparams);
        }
      /*}}}*/
      {
        paraminfo_t *paraminfo = &(paramtable[i]);
        int f;
        paraminfo->pparamexp = ThisItemAddr(aparams);
        paraminfo->pformaltype = gettype(ThisItem(fparams));
        paraminfo->pevaluated = FALSE;
    
        /* These are defaults, modified later if neccessary  */
        paraminfo->pnestedfunctions = FALSE;
        paraminfo->pmaxparamslotused = -1;
    
        /*{{{  set up paraminfo->pmode to be P_EXP or P_PTR or P_TEMPPTR*/
        {
          if (ishiddenparam(ThisItem(fparams)))
            /*{{{  its a hidden parameter*/
            {
              DEBUG_MSG(("loadparamtable: param %d is hidden (P_EXP)\n", i));
              paraminfo->pmode = P_EXP;
            }
            /*}}}*/
          else
            /*{{{  its a real parameter*/
            {
              int pointerparam = ispointer(ThisItem(fparams));
              treenode *aparam = ThisItem(aparams);
              if (pointerparam && !isaddressable(aparam))
                {
                  DEBUG_MSG(("loadparamtable: param %d is pointer and not addresable (P_TEMPPTR)\n", i));
                  paraminfo->pmode = P_TEMPPTR;
                }
              else
                {
                  f = findinstances(aparam);
                  DEBUG_MSG(("loadparamtable: param %d is pointer? %d (P_EXP/P_PTR)(findinstances %d)\n", i, pointerparam, f));
                  paraminfo->pmode = (pointerparam) ? P_PTR : P_EXP;
                  paraminfo->pnestedfunctions = (f >= 0);
                  paraminfo->pmaxparamslotused = ((f >= 0) ? max(0, f - MAXREGS) : -1);
                }
            }
            /*}}}*/
        }
        /*}}}*/
    
        fparams = NextItem(fparams);
        aparams = NextItem(aparams);
      }
    }
    /*}}}*/
}
/*}}}*/
/*{{{  PRIVATEPARAM void mapvalofmain (treenode *tptr)*/
PRIVATEPARAM void mapvalofmain ( treenode *tptr )
{
  treenode *resultlist = VLResultListOf(tptr);
  treenode *savedtemplist = templist;
  int nresults = listitems(resultlist);
  treenode *templist = NULL;
  int simpleexp = FALSE;
  templist = NULL;
  mapprocess(VLBodyOf(tptr));
  /*walkpreprocesslist(resultlist);*/ /* already done in mappreprocess CON 5/10/90 */
  if (nresults == 1)
    /*{{{  maybe load the result in Areg*/
    {
      int type = typeof(ThisItem(resultlist));
      simpleexp = TRUE;
      if (fpinline && isreal(type)) /* added for bug 1002 04/10/90 */
        mapfpexp(ThisItemAddr(resultlist));
      else if (fitsinregister(type))
        mapexp(ThisItemAddr(resultlist));
      else
        simpleexp = FALSE;
    }
    /*}}}*/
  if (!simpleexp)
    mapassign(valofdestlist, VLResultListAddr(tptr));
  freetemplist(templist);
  templist = savedtemplist;
}
/*}}}*/
/*}}}*/

/*{{{  public routines*/
/*{{{  PRIVATE treenode *hiddenparamsof(aparam, fparam)*/
/*****************************************************************************
 *
 *  hiddenparamsof takes an actual parameter 'aparam' and a formal
 *                 parameter corresponding to 'aparam'
 *                 and returns a tree representing
 *                 any associated hidden parameters
 *                 (ie. sizes of an unsized array).
 *
 *****************************************************************************/
PRIVATE treenode *hiddenparamsof ( treenode *aparam , treenode *fparam )
{
  treenode *hparams = NULL;
  treenode *ftype = NTypeOf(fparam);
  int dimension = 0;
  /*{{{  walk the formal type tree searching for unknown sizes*/
  while (TagOf(ftype) == S_ARRAY)
    {
      if (ARDimOf(ftype) == (-1)) /* we have a hidden parameter */
        /*hparams = appendnode(hiddenparamnodeof(aparam, dimension), hparams);*/
        hparams = appendnode(newhiddenparamnode(S_HIDDEN_PARAM, 0,
                                                dimexpof(aparam, dimension),
                                                dimension), hparams);
      dimension++;
      ftype = ARTypeOf(ftype);
    }
  /*}}}*/
  return(hparams);
}
/*}}}*/
/*{{{  PUBLIC treenode *augmentparams(aptr, fptr, destlist)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  augmentparams augments an actual parameter list 'aptr' using the
 *                augmented formal parameter list 'fptr' and, for a function,
 *                the list of destinations 'destlist'.  For a procedure
 *                call, 'destlist' will be null.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC treenode *augmentparams ( treenode *aptr , treenode *fptr , treenode *destlist )
{
  /*{{{  COMMENT remove TIMER parameters from the actual list*/
  /**********************  Start comment out ****************************
  @*{{{  remove TIMER parameters from the actual list*@
  {
    treenode **paramptr = &aptr;
    while (!EndOfList(*paramptr))
      {
        if (basetype(gettype(ThisItem(*paramptr))) == S_TIMER)
          *paramptr = NextItem(*paramptr);
        else
          paramptr = NextItemAddr(*paramptr);
      }
  }
  @*}}}*@
   **********************   End comment out  ****************************/
  /*}}}*/
  /*{{{  augment actual parameter list*/
  {
    treenode *resultlist = aptr;
    treenode **a         = &resultlist;
    treenode *lastactual = NULL;
    int nregdests = 0;
    DEBUG_MSG(("augmentparams\n"));
    while (!EndOfList(fptr))
      {
        treenode *thisformal = ThisItem(fptr),
                 *thisactual = (!EmptyList(aptr)) ? ThisItem(aptr) : NULL;
        switch(TagOf(thisformal))
          /*{{{  augment actual param list for this formal parameter*/
          {
            /*{{{  N_PARAM N_VALPARAM*/
            case N_PARAM:
            case N_VALPARAM:
              lastactual = thisactual;
              break;
            /*}}}*/
            /*{{{  S_PARAM_STATICLINK*/
            case S_PARAM_STATICLINK:
              *a = addtofront(newleafnode(S_PARAM_STATICLINK, NOPOSN), *a);
              aptr = *a;
              break;
            /*}}}*/
            /*{{{  S_PARAM_VSP*/
            case S_PARAM_VSP:
              *a = addtofront(newhiddenparamnode(S_PARAM_VSP, NOPOSN, NULL, vsp), *a);
              aptr = *a;
              break;
            /*}}}*/
            /*{{{  S_HIDDEN_PARAM*/
            case S_HIDDEN_PARAM:
              {
                int dimension = HDimensionOf(thisformal);
                *a = addtofront(hiddenparamnodeof(lastactual, (INT32)dimension), *a);
                aptr = *a;
              }
              break;
            /*}}}*/
            /*{{{  S_FNFORMALRESULT*/
            case S_FNFORMALRESULT:
              {
                while (fitsinregister(typeof(ThisItem(destlist))) &&
                       (nregdests < MAXREGS))
                  {
                    nregdests++;
                    destlist = NextItem(destlist);
                  }
                /* If this result is aliassed by a parameter to the function,
                   or is a free variable of the function, we need to make it a temp */
                *a = addtofront(newhiddenparamnode(S_FNACTUALRESULT, NOPOSN, ThisItem(destlist),
                                                                       0), *a);
                aptr = *a;
                destlist = NextItem(destlist);
              }
              break;
            /*}}}*/
            default:
              badtag(genlocn, TagOf(thisformal), "augmentparams");
          }
          /*}}}*/
        if (!EmptyList(aptr))
          /*{{{  update a and aptr*/
          {
            a = NextItemAddr(aptr);
            aptr = NextItem(aptr);
          }
          /*}}}*/
        fptr = NextItem(fptr);
      }
    return(resultlist);
  }
  /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC void augmentformals(nptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  augmentformals adds hidden array dimensions and result pointer parameters
 *                 to a formal parameter list.  Note that it does not add
 *                 a static link parameter or a vector space parameter as
 *                 we don't know if they are needed until we have mapped the
 *                 routine body.
 *
 *                 This routine is applied in the trans phase.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void augmentformals ( treenode *nptr )
{
  treenode *fparams;
  /*{{{  COMMENT remove TIMER parameters from the formal list*/
  /**********************  Start comment out ****************************
  @*{{{  remove TIMER parameters from the formal list*@
  {
    treenode *n = NParamListOf(nptr);
    treenode **fptr = &n;
    while (!EndOfList(*fptr))
      {
        if (basetype(NTypeOf(ThisItem(*fptr))) == S_TIMER)
          *fptr = NextItem(*fptr);
        else
          fptr = NextItemAddr(*fptr);
      }
    SetNParamList(nptr, n);
  }
  @*}}}*@
   **********************   End comment out  ****************************/
  /*}}}*/
  DEBUG_MSG(("augmentformals: %s\n", WNameOf(NNameOf(nptr))));
  fparams = NParamListOf(nptr);
  /*{{{  add unknown array dimensions*/
  {
    treenode *fptr = fparams;
    while (!EndOfList(fptr))
      {
        treenode *thisformal = ThisItem(fptr),
                 *nextformal = NextItem(fptr);
        treenode *h;
        treenode *type = NTypeOf(thisformal);
        /*SetNVNext(thisformal, NULL);*/ /* This is done by the mapper */
        /*{{{  put temporaries in unknown array dimensions*/
        {
          treenode *thistype;
          for (thistype = type; TagOf(thistype) == S_ARRAY; thistype = ARTypeOf(thistype))
            if (ARDimOf(thistype) == (-1))
              SetARDimLength(thistype, newtempnode(T_PREEVALTEMP,dummyexp_p,NM_WORKSPACE));
        }
        /*}}}*/
        /* bug 1156 - insert the modes of the parameters while still in trans! */
        {
          int nm;
          if ((TagOf(thisformal) == N_PARAM) &&
              (!chanaspointer || basetype(type) != S_CHAN))
            nm = NM_POINTER;
          else
            {
              if (isscalartype(TagOf(type)) && (wordsin(type) <= 1))
                nm = NM_WORKSPACE;
              else
                nm = NM_POINTER;
            }
          SetNMode(thisformal, nm);
        }
        
        h = hiddenparamsof(thisformal, thisformal);
        if (!EmptyList(h))
          fptr = insertlist(h, fptr);
        fptr = nextformal;
      }
  }
  /*}}}*/
  switch(TagOf(nptr))
    {
      default:
        break;
      case N_SFUNCDEF: case N_LFUNCDEF:
      case N_SCFUNCDEF: case N_LIBFUNCDEF: case N_STDLIBFUNCDEF:
      /*{{{  prepend result pointer parameters*/
      {
        treenode *resultptrlist = NULL;
        treenode *fresulttypes = FnTypeListOf(NTypeOf(nptr));
        int regresults = 0;
        /* Special case a single-valued REAL64 function with inline fp */
        if (!(fpinline && (listitems(fresulttypes) == 1) &&
            isreal(TagOf(ThisItem(fresulttypes)))))
          while (!EndOfList(fresulttypes))
            {
              treenode *thisresulttype = ThisItem(fresulttypes);
              if ((regresults == MAXREGS) || !fitsinregister(TagOf(thisresulttype)))
                {
                  treenode *rnode = newhiddenparamnode(S_FNFORMALRESULT, NOPOSN,
                                                       thisresulttype, 0);
                  resultptrlist = addtofront(rnode, resultptrlist);
                }
              else
                regresults++;
              fresulttypes = NextItem(fresulttypes);
            }
        /* this has created a list in reverse order, so */
        resultptrlist = reverselist(resultptrlist);
        if (resultptrlist != NULL)
          /* Swapped fparams with resulttptrlist */
          SetFnParams(NTypeOf(nptr), appendlist(fparams, resultptrlist));
      }
      break;
      /*}}}*/
  }
}
/*}}}*/
/*{{{  PRIVATE void mapparameter*/
PRIVATE void mapparameter(paraminfo_t *paraminfoptr, int i, int make_temp)
{
  treenode **expptr = paraminfoptr->pparamexp;
  i = i; /* make sure there's no unused variable warning */
  DEBUG_MSG(("mapparameter: param %d, temporary?:%d\n", i, make_temp));
  mapexpopd(paraminfoptr->pmode, expptr);
  paraminfoptr->pevaluated = TRUE;
  if (make_temp)
    {
      *expptr = gettemp(*expptr, NM_WORKSPACE);
      upusecount(*expptr, 1);
      paraminfoptr->pmode = P_TEMP;
    }
}
/*}}}*/
/*{{{  PRIVATE int preevalrealbyvalue*/
PRIVATE int preevalrealbyvalue (paraminfo_t *paraminfoptr)
/* returns TRUE if we have to preevaluate a real parameter when FPU */
{
  treenode *exp = *paraminfoptr->pparamexp;
  return fpinline &&
         paraminfoptr->pmode == P_EXP && /* passed by value */
         isreal(typeof(exp)) &&    /* real-valued */
         !isaddressable(exp);      /* not addressable */
}
/*}}}*/
/*{{{  PUBLIC void mapinstance(tptr)           with inline fp*/
/*{{{  comment*/
/*****************************************************************************
 *
 * mapinstance allocates workspace required during the call of a procedure or
 *             function.
 *
 *****************************************************************************/
/* Order of loading parameters:
   if there are non-register parameters ...
     1.   Register function calls which use workspace parameter slots
          are preevaluated to temporaries.
     2.   Non-register function calls are evaluated right to left
          directly into their parameter slots if possible, otherwise
          into temporaries.
     3.   Any temporaries generated in (2) are moved to their parameter slots.
     4.   Any remaining non-register parameters are evaluated into
          their parameter slots.
     5.   Register parameters are loaded.
   else ...
     1.   Register parameters are loaded.
 */
/*}}}*/
PUBLIC void mapinstance ( treenode *tptr )
{
  treenode *const nptr = INameOf(tptr);
  const int nparams = NPParamsOf(nptr);
  /*{{{  COMMENT  wsp optimisation*/
  /**********************  Start comment out ****************************
  @*{{{  *@
  int params_below_ws = nparams > (MAX_LOCAL_PARAMS + REG_PARAMS)
                         ? nparams - (MAX_LOCAL_PARAMS + REG_PARAMS)
                         : 0;
  @*}}}*@
   **********************   End comment out  ****************************/
  /*}}}*/

  int i;
  /*int savedinsidealtguard;*/ /* no longer used - bug 1159 15/2/91 */
  DEBUG_MSG(("mapinstance: %s\n", WNameOf(NNameOf(nptr))));
    /* Workspace is pulled down alt_ds + nparams slots */
  /*{{{  update staticlinkused, vector space and datasize, mark routine as used*/
  {
    INT32 ws, vs;
    getprocwsandvs(nptr, &ws, &vs);
    if (insidealtguard)
      /* A function call inside an ALT guard has its parameters stored
         BELOW the alt's belowworkspace slots */
      datasize = max(datasize, ws +
                    max(findinstances(tptr), REG_PARAMS) + INS_EXTRA + alt_ds);
    else
      datasize = max(datasize, ws + REG_PARAMS + INS_EXTRA);
    if (separatelycompiled(nptr))
      {
        if (isinlibrary(nptr))
          add_to_libentries(nptr);
      }
    else
      staticlinkused = min(staticlinkused, NPSLUsageOf(nptr));
    maxvsp = max(maxvsp, vsp + vs);
  }
  /*}}}*/
#if 0
  /* bug 1159 - CON - 15/2/91 - this isn't used;
     nested functions still have to know that they're inside an ALT guard,
     a) so that the datasize can be calculated;
     b) so that they do not attempt to reserve their parameter slots
  */
  savedinsidealtguard = insidealtguard;
  insidealtguard = FALSE; /* Nested functions don't need to pull down wptr */
#endif
  /*{{{  map parameter loading*/
  if (nparams > 0)
    {
      int freereg[MAXREGS];
      treenode *lowwsp = NULL;
      paraminfo_t *paramtable =
         (paraminfo_t *)memalloc (sizeof(paraminfo_t) * nparams);
      loadparamtable(paramtable, nparams, tptr);
      /*{{{  initialise freereg*/
      for (i = 0; i < MAXREGS; i++) freereg[i] = FALSE;
      /*}}}*/
      /*{{{  preevaluate non-addressable params passed by reference, into temps.*/
      /* Preevaluate non-addressable params passed by reference :
         sounds silly, but does actually occur for INT64/REAL64 expressions,
         array constructors etc. */
      {
        for (i = 0; i < nparams; i++)
          if (paramtable[i].pmode == P_TEMPPTR)
            /*{{{  evaluate to temporary*/
            {
              treenode **paramexp = paramtable[i].pparamexp;
              DEBUG_MSG(("mapinstance: %s, param %d must be preevaluated\n", WNameOf(NNameOf(nptr)), i));
              if (isconst(*paramexp))
                {
                  placeintable(*paramexp);
                  paramtable[i].pmode = P_PTR;
                }
              else
                {
                  const int type = typeof(*paramexp);
                  *paramexp = gettemp (*paramexp, NM_WORKSPACE); /* Andy's */
                  mapsimpleassign(type, P_TEMP, paramexp, P_EXP, NDeclAddr(*paramexp));
                  /* We don't set 'pevaluated' because we have yet
                     to load a pointer to it */
                }
            }
            /*}}}*/
      }
      /*}}}*/
      /*{{{  preevaluate real non-addressable register params on fp processor*/
      /* For a floating point processor only,
         preevaluate non-addressable real-valued register parameters passed by
         value  */
      if (fpinline)
        {
          const int p = min(nparams, MAXREGS);
          for (i = 0; i < p; i++)
            {
              if (preevalrealbyvalue(&paramtable[i]))
                /*{{{  evaluate to temporary*/
                {
                  treenode **paramexp = paramtable[i].pparamexp;
                  if (isconst(*paramexp))
                    placeintable(*paramexp);
                  else
                    {
                      mapfpexp(paramexp);
                      *paramexp = gettemp (*paramexp, NM_WORKSPACE); /* Andy's */
                      /* store into the temporary */
                      paramtable[i].pevaluated = TRUE;
                      paramtable[i].pmode = P_TEMP;
                      freereg[i] = TRUE; /* Flag temporary needs to be freed later */
                    }
                }
                /*}}}*/
            }
        }
      /*}}}*/
      if (nparams > REG_PARAMS)
        {
          /*{{{  preevaluate register parameters which use parameter slots*/
          for (i = 0; i < MAXREGS; i++)
            if (!paramtable[i].pevaluated && paramtable[i].pmaxparamslotused > 0)
              {
                mapparameter(&(paramtable[i]), i, TRUE);
                freereg[i] = TRUE; /* Flag temporary needs to be freed later */
              }
          /*}}}*/
          /*{{{  evaluate non-register parameters containing function calls to param slots*/
          for (i = nparams - 1; i >= MAXREGS; i--)
            {
              paraminfo_t *const paraminfoptr = &(paramtable[i]);
              if (paraminfoptr->pnestedfunctions)
                {
                  const int next_slot = i+1-MAXREGS; /* bug 1064 6/12/90 */
                  if (paraminfoptr->pmaxparamslotused > next_slot /*(i - MAXREGS)*/) /* bug 1064 */
                    mapparameter(paraminfoptr, i, TRUE);
                  else if (insidealtguard || (i == (nparams - 1)))
                    mapparameter(paraminfoptr, i, FALSE);
                  else
                    {
                      /* we have to protect the slots already copied into */
                      /* bug 1013 12/10/90 */
                      treenode *const paramslots =
                         alloc_fixedws(next_slot, nparams-MAXREGS-next_slot);
                      mapparameter(paraminfoptr, i, FALSE);
                      kill_var(paramslots);
                    }
                }
            }
          /*}}}*/
          /*{{{  reserve low workspace used by params*/
          /* This test moved up here so that we have allocated these param
             slots in advance of mapping the other params:
             bug 1013 11/10/90
          */
          if (!insidealtguard)
            lowwsp = alloc_fixedws(0, nparams - MAXREGS);
            /* Inside an ALT guard, all parameters are stored below normal workspace */
          /*}}}*/
          /*{{{  evaluate all non-register parameters to parameter slots*/
          for (i = nparams - 1; i >= MAXREGS; i--)
            {
              paraminfo_t *const paraminfoptr = &(paramtable[i]);
              if (paraminfoptr->pmode == P_TEMP)
                {
                  /*  Move any parameters evaluated to temporaries to their real slot*/
                  /* and free the temporaries NO: bug 745 - must free later! 2/10/90 */
                  DEBUG_MSG(("mapinstance: %s, param %d moved to real slot\n", WNameOf(NNameOf(nptr)), i));
                  upusecount(*(paraminfoptr->pparamexp), 1);
                }
              if (!paraminfoptr->pevaluated)
                mapparameter(paraminfoptr, i, FALSE);
            }
          /*}}}*/
        }

      /* We used to allocate param slots here, but that is too late.
         they've now been moved forward a bit.
         bug 1013 11/10/90
      */

      /*{{{  load register parameters*/
      if (nparams >= 3)
        SetILoadSeq(tptr, mapload3regs(paramtable[2].pmode, paramtable[2].pparamexp,
                                       paramtable[1].pmode, paramtable[1].pparamexp,
                                       paramtable[0].pmode, paramtable[0].pparamexp));
      else if (nparams == 2)
        SetILoadSeq(tptr, mapload2regs(paramtable[1].pmode, paramtable[1].pparamexp,
                                       paramtable[0].pmode, paramtable[0].pparamexp));
      else /* nparams == 1 */
        {
          mapexpopd(paramtable[0].pmode, paramtable[0].pparamexp);
          SetILoadSeq(tptr, 1);
        }
      /*}}}*/
      /*{{{  free any temporaries holding register parameters*/
      for (i = 0; i < MAXREGS; i++)
        if (freereg[i])
          freetemp(*(paramtable[i].pparamexp));
      /*}}}*/
      /*{{{  free preevaluated, non-addressable param temps.*/
      for (i = 0; i < nparams; i++)
        {
          int mode = paramtable[i].pmode;
          if ((mode == P_TEMPPTR) ||
              ((i >= MAXREGS) && (mode == P_TEMP))) /* bug 745 2/10/90 */
            freetemp(*(paramtable[i].pparamexp));
        }
      /*}}}*/
      /*{{{  free low workspace used by parameters*/
      if (lowwsp != NULL)
        kill_var(lowwsp);
      /*}}}*/
      memfree(paramtable);
    }
  /*}}}*/
  /*insidealtguard = savedinsidealtguard;*/ /* bug 1159 - 15/2/91 */
}
/*}}}*/
/*{{{  PRIVATE void tparamexpopd(int opdmode, treenode *opd, int paramslot)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tparamexpopd generates the operand (opdmode, opd) and stores it in
 *               local workspace 'paramslot'.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void tparamexpopd ( int opdmode , treenode *opd , const int paramslot )
{
  if (fpinline && opdmode == P_EXP && isreal(typeof(opd)))
    {
      tfpexp(opd, MANY_REGS, MANY_REGS);
      genprimary(I_LDLP, paramslot);
      gensecondary(I_FPSTNLSN);
    }
  else
    {
      texpopd(opdmode, opd, MANY_REGS);
      genprimary(I_STL, paramslot);
    }
  gencomment0 ("parameter");
}
/*}}}*/
/*{{{  PUBLIC void tinstance(tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tinstance generates code for procedure or function instance tptr
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void tinstance ( treenode *tptr )
{
  treenode *const iname = INameOf(tptr);
  const int nparams = NPParamsOf(iname);
  /* Inside an ALT guard, we have to pull wptr down below the ALT below
     workspace, to avoid overwriting alt instruction temporaries. */
  const INT32 altadjust = insidealtguard
                       ? max(0, findinstances(tptr) - REG_PARAMS) + alt_ds : 0;
  /*{{{  COMMENT  wsp optimisation*/
  /**********************  Start comment out ****************************
  @*{{{  *@
  int params_below_ws = nparams > (MAX_LOCAL_PARAMS + REG_PARAMS)
                         ? nparams - (MAX_LOCAL_PARAMS + REG_PARAMS)
                         : 0;
  @*}}}*@
   **********************   End comment out  ****************************/
  /*}}}*/
  const int savedinsidealtguard = insidealtguard;
  const int oldinstancedlevel = instancedlevel;
  /* instancedlevel is global variable containing
     level of variables within instanced routine */
  instancedlevel = NLexLevelOf(iname) + 1;
  insidealtguard = FALSE; /* Nested functions don't adjust wptr */
  /*{{{  COMMENT  wsp optimisation*/
  /**********************  Start comment out ****************************
  @*{{{  adjust workspace downwards if necessary*@
  if (params_below_ws > 0)
    {
      genprimary(I_AJW, -params_below_ws);
      adjustworkspace(params_below_ws);
    }
  @*}}}*@
   **********************   End comment out  ****************************/
  /*}}}*/
  /*{{{  adjust wptr down if we are in an alt guard*/
  genprimary(I_AJW, -altadjust);
  adjustworkspace(altadjust);
  /*}}}*/
  if (nparams != 0)
    /*{{{  load parameters*/
    {
      int i;
      paraminfo_t *paramtable = (paraminfo_t *)
                                memalloc(sizeof(paraminfo_t) * nparams);
      loadparamtable(paramtable, nparams, tptr);
      /*{{{  check actual parameter dimensions*/
      for (i = 0; i < nparams; i++)
        {
          treenode *ftype = paramtable[i].pformaltype,
                   *atype = gettype(*(paramtable[i].pparamexp));
          while (TagOf(ftype) == S_ARRAY)
            {
              if (ARDimOf(atype) == (-1) && ARDimOf(ftype) != (-1))
                tcheckdim(ftype, atype);
              ftype = ARTypeOf(ftype);
              atype = ARTypeOf(atype);
            }
        }
      /*}}}*/
      /*{{{  preevaluate non-addressable params passed by reference, into temps.*/
      /* Preevaluate non-addressable params passed by reference :
         sounds silly, but does actually occur for INT64 expressions,
         array constructors etc. */
      {
        for (i = 0; i < nparams; i++)
          if (paramtable[i].pmode == P_TEMPPTR)
            /*{{{  evaluate to temporary*/
            {
              DEBUG_MSG(("tinstance: simplifying param %d cos P_TEMPPTR\n", i));
              simplify(P_EXP, *(paramtable[i].pparamexp));
              /* We don't set 'pevaluated' because we have yet
                 to load a pointer to the temporary */
            }
            /*}}}*/
      }
      /*}}}*/
      /*{{{  preevaluate any parameters requiring temporaries*/
      for (i = 0; (i < nparams) && (i < MAXREGS); i++) /* register params */
        {
          paraminfo_t *const paraminfoptr = &(paramtable[i]);
          treenode *const exp = *(paraminfoptr->pparamexp);
          /* This used to always simplify if preeval returned TRUE.
             However, this breaks when the argument was turned into a temp
             by something other than mapinstance.
             So we re-create the same tests as were done when mapping */
          /* bug 1000 3/10/90 CON */
          if (preeval(paraminfoptr->pmode, exp)
           && ((paraminfoptr->pmaxparamslotused > 0) ||
               preevalrealbyvalue(paraminfoptr)))
            {
              DEBUG_MSG(("tinstance: simplifying param %d cos preeval/nested\n", i));
              paraminfoptr->pmode = simplify(paraminfoptr->pmode, exp);
              paraminfoptr->pevaluated = TRUE;
              /* we use the fact that the mode has been changed to 'TEMP' to
                 remember to copy the temp into the actual param slot later */
            }
        }
      /* modified 6/12/90 to ensure that these are done in the same order as
         they were done while mapping - bug 1064 6/12/90 */
      for (i = nparams - 1; i >= MAXREGS; i--) /* non register params */
        {
          paraminfo_t *const paraminfoptr = &(paramtable[i]);
          treenode *const exp = *(paraminfoptr->pparamexp);
          /* This used to always simplify if preeval returned TRUE.
             However, this breaks when the argument was turned into a temp
             by something other than mapinstance.
             So we re-create the same tests as were done when mapping */
          /* bug 1000 3/10/90 CON */
          if (preeval(paraminfoptr->pmode, exp)
           && (paraminfoptr->pmaxparamslotused > (i+1 - MAXREGS)))
              /* test was modified inline with the mapper for bug 1064 6/12/90 */
            {
              DEBUG_MSG(("tinstance: simplifying param %d cos preeval/nested\n", i));
              paraminfoptr->pmode = simplify(paraminfoptr->pmode, exp);
              paraminfoptr->pevaluated = TRUE;
              /* we use the fact that the mode has been changed to 'TEMP' to
                 remember to copy the temp into the actual param slot later */
            }
        }
      /*}}}*/
      /*{{{  evaluate non-register parameters containing function calls to param slots*/
      for (i = nparams - 1; i >= MAXREGS; i--)
        {
          paraminfo_t *const paraminfoptr = &(paramtable[i]);
          if (!paraminfoptr->pevaluated && paraminfoptr->pnestedfunctions)
            {
              DEBUG_MSG(("tinstance: doing param %d cos nestedfunctions\n", i));
              tparamexpopd(paraminfoptr->pmode,
                           *(paraminfoptr->pparamexp), i - MAXREGS);
              paraminfoptr->pevaluated = TRUE;
            }
        }
      /*}}}*/
      /*{{{  evaluate all non-register parameters to parameter slots*/
      for (i = nparams - 1; i >= MAXREGS; i--)
        {
          paraminfo_t *const paraminfoptr = &(paramtable[i]);
          if (!paraminfoptr->pevaluated || (paraminfoptr->pmode == P_TEMP))
            {
              treenode *exp = *(paraminfoptr->pparamexp);
              DEBUG_MSG(("tinstance: doing param %d at last\n", i));
              paraminfoptr->pmode = simplify(paraminfoptr->pmode, exp); /* bug 1000 3/10/90 */
              tparamexpopd(paraminfoptr->pmode, exp, i - MAXREGS);
              paraminfoptr->pevaluated = TRUE; /* not strictly necessary */
            }
        }
      /*}}}*/
      /*{{{  load register parameters*/
      DEBUG_MSG(("tinstance: doing register params\n"));
      if (nparams == 1)
        texpopd(paramtable[0].pmode, *(paramtable[0].pparamexp), MANY_REGS);
      else if (nparams == 2)
        tload2regs(paramtable[1].pmode, *(paramtable[1].pparamexp),
                   paramtable[0].pmode, *(paramtable[0].pparamexp),  FALSE);
      else /* nparams >= 3 */
        tload3regs(paramtable[2].pmode, *(paramtable[2].pparamexp),
                   paramtable[1].pmode, *(paramtable[1].pparamexp),
                   paramtable[0].pmode, *(paramtable[0].pparamexp), ILoadSeqOf(tptr));
      /*}}}*/
      checkerror ();
      memfree(paramtable);
    }
    /*}}}*/
  /*{{{  call routine*/
  genbranch (I_CALL, NPLabelOf(iname));
  gencomment1("Call %s", (BIT32)WNameOf(NNameOf(iname)));
  /*}}}*/
  /*{{{  COMMENT  wsp optimisation*/
  /**********************  Start comment out ****************************
  @*{{{  restore workspace if necessary*@
  if (params_below_ws > 0)
    {
      genprimary(I_AJW, params_below_ws);
      adjustworkspace(-params_below_ws);
    }
  @*}}}*@
   **********************   End comment out  ****************************/
  /*}}}*/
  /*{{{  adjust wptr up if we are in an alt guard*/
  genprimary(I_AJW, altadjust);
  adjustworkspace(-altadjust);
  /*}}}*/
  insidealtguard = savedinsidealtguard;
  instancedlevel = oldinstancedlevel;
}
/*}}}*/
/*{{{  PUBLIC void mapvalof(tptr, destlistptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  mapvalof maps out workspace requirement for the VALOF, 'tptr',
 *           whose result is either left in Areg, or stored in the list
 *           'destlistptr'.  N.B. If anything else is required (result
 *           in fpreg, or double or quad-length results), this must be
 *           dealt with expicitly elsewhere.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void mapvalof ( treenode *tptr , treenode **destlistptr )
{
  treenode **savedvalofdestlist = valofdestlist;
  valofdestlist = destlistptr;
  mapdeclandbody(tptr, mapvalofmain, FALSE, FALSE);
  valofdestlist = savedvalofdestlist;
}
/*}}}*/
/*{{{  PUBLIC void tvalof(tptr, destlist)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tvalof generates code for the VALOF, 'tptr', leaving the result in
 *         Areg if there is only one result and it will fit in Areg,
 *         otherwise storing each result in the corresponding item of
 *         'destlist'.  N.B. If anything else is required (result in fp reg,
 *         double and quad-length result) it should be dealt with explicitly
 *         elsewhere.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void tvalof ( treenode *tptr , treenode *destlist )
{
  treenode *resultlist;
  int nresults;

  tptr = tspecs(tptr);
  resultlist = VLResultListOf(tptr);
  nresults = listitems(resultlist);
  tprocess(VLBodyOf(tptr));
  tpreexp(resultlist);
  if (nresults == 1)
    /*{{{  single result*/
    {
      if (fitsinregister(typeof(ThisItem(resultlist))))
        /*{{{  load the result in Areg*/
        texp(ThisItem(resultlist), MANY_REGS);
        /*}}}*/
      else
        /* Can't do other types here */
        geninternal_is(GEN_ERROR_IN_ROUTINE, 1, "tvalof");
    }
    /*}}}*/
  else
    /*{{{  multiple results*/
    tassign(destlist, resultlist);
    /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC int mappredef (tptr, destlist)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  mappredef maps the evaluation of a predefined routine.
 *            Parameters are reordered where neccessary, and dummy parameters
 *            are inserted where neccessary.
 *            For a multiply-valued predef, 'destlist' is a list of the
 *            destinations which is reordered if neccessary.
 *
 *            Returns TRUE if done inline.
 *            Returns FALSE if lib call, with mapinstance stiil to be done.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC int mappredef ( treenode *tptr , treenode *destlist )
{
  treenode *iname = INameOf(tptr);
  int pdno = NModeOf(iname);
  treenode *paramlist = IParamListOf(tptr);
  treenode **param[MAX_PREDEFPARAMS];
  treenode **dest[MAX_PREDEFDESTS];
  if (pdinline(pdno))
    {
      int loadseq;
      int i;
      /*{{{  load parameters into param*/
      i = 0;
      while (!EndOfList(paramlist))
        {
          param[i] = ThisItemAddr(paramlist);
          i++;
          paramlist = NextItem(paramlist);
        }
      /*}}}*/
      /*{{{  load destinations into dest*/
      i = 0;
      while (!EndOfList(destlist))
        {
          dest[i] = ThisItemAddr(destlist);
          i++;
          destlist = NextItem(destlist);
        }
      /*}}}*/
      /*{{{  load parameters, perform operation, store results maybe*/
      switch (pdno)
        {
          /*{{{  LONGADD CRCWORD CRCBYTE      load 2, 1, 0*/
          case PD_LONGADD:
          case PD_CRCWORD:
          case PD_CRCBYTE:
            loadseq = mapload3regs(P_EXP, param[2], P_EXP, param[1], P_EXP, param[0]);
            break;
          /*}}}*/
          /*{{{  LONGSUM LONGPROD             load 2, 1, 0  store 1, 0*/
          case PD_LONGSUM:
          case PD_LONGPROD:
            loadseq = mapload3regs(P_EXP, param[2], P_EXP, param[1], P_EXP, param[0]);
            mapstoreregs(dest, 2);
            break;
          /*}}}*/
          /*{{{  LONGSUB                      load 2, 0, 1*/
          case PD_LONGSUB:
            loadseq = mapload3regs(P_EXP, param[2], P_EXP, param[0], P_EXP, param[1]);
            break;
          /*}}}*/
          /*{{{  LONGDIFF                     load 2, 0, 1  store 1, 0*/
          case PD_LONGDIFF:
            loadseq = mapload3regs(P_EXP, param[2], P_EXP, param[0], P_EXP, param[1]);
            mapstoreregs(dest, 2);
            break;
          /*}}}*/
          /*{{{  LONGDIV                      load 0, 1, 2  store 0, 1*/
          case PD_LONGDIV:
            {
              treenode **temp;
              loadseq = mapload3regs(P_EXP, param[0], P_EXP, param[1], P_EXP, param[2]);
              temp = dest[0]; dest[0] = dest[1]; dest[1] = temp;
              mapstoreregs(dest, 2);
            }
            break;
          /*}}}*/
          /*{{{  SHIFTRIGHT SHIFTLEFT         load 0, 1, 2  store 1, 0*/
          case PD_SHIFTRIGHT:
          case PD_SHIFTLEFT:
            loadseq = mapload3regs(P_EXP, param[0], P_EXP, param[1], P_EXP, param[2]);
            mapstoreregs(dest, 2);
            break;
          /*}}}*/
          /*{{{  NORMALISE                    load 0, 1     store 2, 1, 0*/
          case PD_NORMALISE:
            loadseq = mapload2regs(P_EXP, param[0], P_EXP, param[1]);
            mapstoreregs(dest, 3);
            break;
          /*}}}*/
          /*{{{  FRACMUL BITCOUNT             load 1, 0*/
          case PD_FRACMUL:
          case PD_BITCOUNT:
            loadseq = mapload2regs(P_EXP, param[1], P_EXP, param[0]);
            break;
          /*}}}*/
          /*{{{  BITREVNBITS                  load 0, 1*/
          case PD_BITREVNBITS:
            loadseq = mapload2regs(P_EXP, param[0], P_EXP, param[1]);
          /*}}}*/
          /*{{{  BITREVWORD                   load 0*/
          case PD_BITREVWORD:
            mapexp(param[0]);
            loadseq = 0;
            break;
          /*}}}*/
          /*{{{  ABS ISNAN ...                load fp0*/
          case PD_ABS:        case PD_DABS:
          case PD_ISNAN:      case PD_DISNAN:
                              case PD_DNOTFINITE:
          case PD_MULBY2:     case PD_DMULBY2:
          case PD_DIVBY2:     case PD_DDIVBY2:
          case PD_SQRT:       case PD_DSQRT:
          case PD_FPINT:      case PD_DFPINT:
            mapfpexp(param[0]);
            loadseq = 0;
            break;
          /*}}}*/
          /*{{{  ORDERED DORDERED             load fp0, fp1 in either order*/
          case PD_ORDERED:
          case PD_DORDERED:
            mapfpload2regs(param[0], param[1]);
            loadseq = 0;
            break;
          /*}}}*/
          /*{{{  CAUSEERROR RESCHEDULE*/
          case PD_CAUSEERROR:
          case PD_RESCHEDULE:
            break;
          /*}}}*/
          /*{{{  ASSERT*/
          case PD_ASSERT:
            if (NEED_ERRORS && !ignore_assertions)
              mapexp(param[0]);
            break;
          /*}}}*/
          /*{{{  ASHIFTRIGHT ASHIFTLEFT       special*/
          case PD_ASHIFTRIGHT:
          case PD_ASHIFTLEFT:
            /* param[0] has to be extended to double-length and so requires two
               registers to hold, so we have to preevaluate the count (param[1])
               needs more than MAXREGS - 2 */
            if (regsfor(*param[1]) > MAXREGS - 2)
              /*{{{  preevaluate param[1], the count*/
              {
                treenode **count = param[1];
                mapexp(count);
                *count = gettemp(*param[1], NM_WORKSPACE);
                upusecount(*count,2);
                mapexp(param[0]);
                freetemp(*count);
              }
              /*}}}*/
            else
              /*{{{  load operand; load count*/
              {
                mapexp(param[0]);
                mapexp(param[1]);
              }
              /*}}}*/
            loadseq = 1;
            break;
          /*}}}*/
          /*{{{  ROTATERIGHT ROTATELEFT       special*/
          case PD_ROTATERIGHT:
          case PD_ROTATELEFT:
            {
              treenode *zero;
              switch_to_temp_workspace();
              zero = newconstant(0);
              switch_to_real_workspace();
              if (pdno == PD_ROTATERIGHT)
                loadseq = mapload3regs(P_EXP, param[0], P_EXP, &zero, P_EXP, param[1]);
              else
                loadseq = mapload3regs(P_EXP, &zero, P_EXP, param[0], P_EXP, param[1]);
            }
            break;
          /*}}}*/
          /*{{{  UNPACKSN                     special*/
          case PD_UNPACKSN:
            /* either
                 ldc 0; param0  or param0; ldc 0; rev
               the order does not affect the mapping  */
            {
              treenode **temp;
              mapexp(param[0]);
              temp = dest[0]; dest[0] = dest[2]; dest[2] = temp;
              mapstoreregs(dest, 3);
            }
            break;
          /*}}}*/
          /*{{{  ROUNDSN                      special*/
          case PD_ROUNDSN:
            /* Yexp IS param[0], Yfrac IS param[1], Yguard IS param[2].
               If Yfrac or Yguard require a certain amount of evaluation (more than
               a simple load), then we load pointers to them into temporaries. */
            {
              int Yfracmode = P_EXP, Yguardmode = P_EXP;
              treenode **Yexp = param[0], **Yfrac = param[1], **Yguard = param[2];
              if (regsfor(*Yfrac) > 1)
                /*{{{  load Yfrac to temporary*/
                {
                  mapexp(Yfrac);
                  *Yfrac = gettemp(*Yfrac, NM_WORKSPACE);
                  upusecount(*Yfrac, 1);
                  Yfracmode = P_TEMP;
                }
                /*}}}*/
              if (regsfor(*Yguard) > 1)
                /*{{{  load Yguard to temporary*/
                {
                  mapexp(Yguard);
                  *Yguard = gettemp(*Yguard, NM_WORKSPACE);
                  upusecount(*Yguard, 1);
                  Yguardmode = P_TEMP;
                }
                /*}}}*/
              loadseq = mapload2regs(Yfracmode, Yfrac, Yguardmode, Yguard);
              mapexp(Yexp);
              /*{{{  reserve local 0 for postnormsn*/
              if (!insidealtguard)
                reservelowworkspace(1);/* local 0 is used as a parameter to postnormsn */
              else
                /* If we are inside an ALT guard, we have to pull wptr down, so
                   that postnormsn's local 0 temporary doesn't overwrite the alt's
                   local 0 temporary. */
                datasize = max(datasize, alt_ds + 1);
              /*}}}*/
              freeiftemp(*Yfrac);
              freeiftemp(*Yguard);
            }
            break;
          /*}}}*/
          /*{{{  MINUSX                       special*/
          case PD_MINUSX:
            if (!fpinline)
              /*{{{  inline without floating point*/
              {
                if (isconst(*param[0]))
                  {
                    treenode *pptr = *param[0];
                    SetLoVal(pptr, LoValOf(pptr) ^ 0x80000000);
                  }
                mapexp(param[0]);
              }
              /*}}}*/
            else
              /*{{{  inline with floating point*/
              {
                treenode **tptr = param[0];
                treenode *t = *tptr;
                if (isconst(t))
                  {
                    SetLoVal(t, LoValOf(t) ^ 0x80000000);
                    mapaddr(tptr);  /* Will put it in the constant table */
                  }
                else
                  /*{{{  generate source to temp., load into integer register*/
                  {
                    *tptr = gettemp(*tptr, NM_WORKSPACE);
                    if (isaddressable(NDeclOf(*tptr)))
                      mapaddr(NDeclAddr(*tptr));
                    else
                      mapsimpleassign(typeof(*tptr), P_TEMP, tptr, P_EXP, NDeclAddr(*tptr));
                    freetemp(*tptr);
                  }
                  /*}}}*/
              }
              /*}}}*/
            break;
          /*}}}*/
          /*{{{  DMINUSX                      special*/
          case PD_DMINUSX:
            /* must have fpinline to reach here */
            {
              treenode **tptr = param[0];
              treenode *t = *tptr;
              if (isconst(t))
                {
                  SetHiVal(t, HiValOf(t) ^ 0x80000000);
                  mapaddr(tptr);  /* Will put it in the constant table */
                }
              else
                {
                  *tptr = gettemp(*tptr, NM_WORKSPACE);
                  mapsimpleassign(typeof(*tptr), P_TEMP, tptr, P_EXP, NDeclAddr(*tptr));
                  freetemp(*tptr);
                }
            }
            break;
          /*}}}*/
          /*{{{  NOTFINITE                    special*/
          case PD_NOTFINITE:
            if (fpinline)
              mapfpexp(param[0]);
            else if (fpsupport)
              mapexp(param[0]);
            else  /* to work on any 32 bit processor */
              {
                #if 0  /* putting the constant into the constant table doesn't help */
                treenode *inf;
                switch_to_temp_workspace();
                inf = newconstant(INFINITY);
                switch_to_real_workspace();
                mapload2regs(P_EXP, &inf, P_EXP, param[0]);
                #endif /* 0 */
                mapexp(param[0]);
              }
            break;
          /*}}}*/
          /*{{{  LOADINPUTCHANNEL + friends   special*/
          case PD_LOADINPUTCHANNEL:
          case PD_LOADOUTPUTCHANNEL:
            mapsimpleassign(S_INT, P_EXP, param[0],
                            chanaspointer ? P_EXP : P_PTR, param[1]);
            break;
          case PD_LOADINPUTCHANNELVECTOR:
          case PD_LOADOUTPUTCHANNELVECTOR:
          case PD_LOADBYTEVECTOR:
            mapsimpleassign(S_INT, P_EXP, param[0], P_PTR, param[1]);
            break;
          /*}}}*/
          /*{{{  KERNELRUN                    special*/
          case PD_KERNELRUN:
            {
              SOURCEPOSN locn = LocnOf(tptr);
              treenode **code = param[0],
                       **entryoffset = param[1],
                       **workspace = param[2],
                       *nparams = *(param[3]);
              if (!isconst(nparams) || LoValOf(nparams) < 3)
                generr(GEN_KERNEL_RUN_ERROR);
              /*{{{  overwrite the parameters we are given with what we want to load*/
              *code = transformelement(newarraysubnode(S_ARRAYSUB, locn,
                                                    *code, *entryoffset), RANGECHECKING);
              /* Note that S_ELSIZE is special and can break the tree structure - bug 1142 7/2/91 */
              *workspace = transformelement(newarraysubnode(S_ARRAYSUB, locn,
                                   *workspace,
                                   foldexp(newmopnode(S_ELSIZE, locn, *workspace, S_INT))), FALSE);
              *entryoffset = newnamenode(N_LABELDEF, locn, tempname_p,
                                         newleafnode(S_LABEL, locn),
                                         NULL, 0, 0, NM_DEFAULT);
              /*}}}*/
              loadseq = mapload3regs(P_PTR, code, P_PTR, entryoffset,
                                     P_PTR, workspace);
            }
            break;
          /*}}}*/
          /*{{{  MOVE2D CLIP2D DRAW2D         special*/
          case PD_MOVE2D:
          case PD_CLIP2D:
          case PD_DRAW2D:
            {
              SOURCEPOSN locn = LocnOf(tptr);
              /*{{{  abbreviate the parameters to sensible names*/
              /* Note that S_ELSIZE is special and can break the tree structure - bug 1142 7/2/91 */
              treenode **source = param[0],
                       *sourcerows = foldexp(newmopnode(S_ELSIZE, locn, *source, S_INT)),
                       *sourcestride = foldexp(newmopnode(S_ELSIZE, locn,
                                       newarraysubnode(S_ARRAYSUB, locn, *source, dummyexp_p), S_INT)),
                       **sx =     param[1],
                       **sy =     param[2],
                       **dest =   param[3],
                       *destrows = foldexp(newmopnode(S_ELSIZE, locn, *dest, S_INT)),
                       *deststride = foldexp(newmopnode(S_ELSIZE, locn,
                                       newarraysubnode(S_ARRAYSUB, locn, *dest, dummyexp_p), S_INT)),
                       **dx =     param[4],
                       **dy =     param[5],
                       **width =  param[6],
                       **length = param[7];
              /*}}}*/
              int sxmode = P_EXP, symode = P_EXP, dxmode = P_EXP, dymode = P_EXP,
                  widthmode = P_EXP, lengthmode = P_EXP,
                  sourcemode = P_EXP, destmode = P_EXP;
              treenode *sourceaddr = NULL, *destaddr = NULL,
                       *sxcheck = NULL, *sycheck = NULL,
                       *dxcheck = NULL, *dycheck = NULL;
              int loadseq1; /* load sequence for move2dinit parameters : we throw it */
                            /* away here and recalculate it during code generation   */

              /* we have to simplify this first, so that we can't timeslice
                 between move2dinit and move2d etc. Bug 403 29/8/90
                 Note that some of the range checks depend upon the width.
              */
              if (regsforopd(widthmode, *width) >= MAXREGS)
                widthmode = mapevalexp(widthmode, width);
              /*{{{  do some checking*/
              {
                if (RANGECHECKING)
                  /*{{{  simplify sx, sy, dx, dy, length, width*/
                  {
                    sxmode = mapevalexp(sxmode, sx);
                    symode = mapevalexp(symode, sy);
                    dxmode = mapevalexp(dxmode, dx);
                    dymode = mapevalexp(dymode, dy);
                    lengthmode = mapevalexp(lengthmode, length);
                  }
                  /*}}}*/
                /* I build the check trees whatever 'errormode' we are compiling
                   as they might need constant folding, and the constant folding
                   might generate a compile time error. */
                sxcheck = buildchecktree(*sx, sourcestride, *width);
                sycheck = buildchecktree(*sy, sourcerows, *length);
                dxcheck = buildchecktree(*dx, deststride, *width);
                dycheck = buildchecktree(*dy, destrows, *length);
                if (RANGECHECKING)
                  /*{{{  map the check expressions*/
                  {
                    if (sxcheck != NULL) mapexp(&sxcheck);
                    if (sycheck != NULL) mapexp(&sycheck);
                    if (dxcheck != NULL) mapexp(&dxcheck);
                    if (dycheck != NULL) mapexp(&dycheck);
                  }
                  /*}}}*/
              }
              /*}}}*/
              /*{{{  build sourceaddr and destaddr*/
              sourceaddr = transformelement(
                             newarraysubnode(S_ARRAYSUB, locn,
                               newarraysubnode(S_ARRAYSUB, locn, *source, *sy),
                               *sx), FALSE);
              destaddr = transformelement(
                           newarraysubnode(S_ARRAYSUB, locn,
                             newarraysubnode(S_ARRAYSUB, locn, *dest, *dy),
                             *dx), FALSE);
              sourceaddr = newmopnode(S_ADDRESSOF, locn, sourceaddr, 0);
              destaddr   = newmopnode(S_ADDRESSOF, locn, destaddr, 0);

              /* we have to simplify these first, so that we can't timeslice
                 between move2dinit and move2d etc. Bug 403 29/8/90
              */
              if (regsforopd(sourcemode, sourceaddr) >= MAXREGS)
                sourcemode = mapevalexp(sourcemode, &sourceaddr);
              if (regsforopd(destmode,   destaddr  ) >= MAXREGS)
                destmode   = mapevalexp(destmode,   &destaddr);
              /*}}}*/
              /*{{{  map the load for move2dinit*/
              loadseq1 = mapload3regs(P_EXP, &sourcestride, P_EXP, &deststride,
                                      lengthmode, length);
              /*}}}*/
              /*{{{  map the load for the move operation proper*/
              loadseq = mapload3regs(sourcemode, &sourceaddr, destmode, &destaddr,
                                      widthmode, width);
              /*}}}*/
              /*{{{  free temporaries used*/
              freeiftemp(*sx);
              freeiftemp(*sy);
              freeiftemp(*dx);
              freeiftemp(*dy);
              freeiftemp(*length);
              freeiftemp(*width);
              freeiftemp(sourceaddr);
              freeiftemp(destaddr);
              /*}}}*/
              /*{{{  add new parameters to the parameter list*/
              {
                treenode *newparams =
                  newlistnode(S_LIST, locn, sourceaddr,
                    newlistnode(S_LIST, locn, destaddr,
                      newlistnode(S_LIST, locn, sxcheck,
                        newlistnode(S_LIST, locn, sycheck,
                          newlistnode(S_LIST, locn, dxcheck,
                            newlistnode(S_LIST, locn, dycheck, NULL))))));
                appendlist(newparams, IParamListOf(tptr));
              }
              /*}}}*/
          }
          /*}}}*/
        }
      /*}}}*/
      SetILoadSeq(tptr, loadseq);
    }
  else
    /*{{{  transform to call to library routine and map that*/
    {
      iname = libentry(pdlibname(NNameOf(iname), pdno), LocnOf(tptr));
      SetIName(tptr, iname);
      return (FALSE);  /* indicate that it is now a lib call */
    }
    /*}}}*/
    return (TRUE);  /* indicate that it is done in line */
}
/*}}}*/
/*{{{  PUBLIC void tpredef (tptr, destlist)*/
/*****************************************************************************
 *
 *  tpredef generates code for the predefined routine call tptr.
 *          If there are multiple results, 'destlist' contains a list of
 *          destinations, otherwise 'destlist' is NULL.
 *
 *****************************************************************************/
PUBLIC void tpredef ( treenode *tptr , treenode *destlist )
{
  treenode *iname = INameOf(tptr);
  int loadseq = ILoadSeqOf(tptr);
  int pdno = NModeOf(iname);
  treenode *paramlist = IParamListOf(tptr);
  treenode *param[MAX_PREDEFPARAMS];
  treenode **dest[MAX_PREDEFDESTS];
  int i;
  /*{{{  load parameters into param*/
  i = 0;
  while (!EndOfList(paramlist))
    {
      assert(i < MAX_PREDEFPARAMS);
      param[i] = ThisItem(paramlist);
      i++;
      paramlist = NextItem(paramlist);
    }
  /*}}}*/
  /*{{{  load destinations into dest*/
  i = 0;
  while (!EndOfList(destlist))
    {
      assert(i < MAX_PREDEFDESTS);
      dest[i] = ThisItemAddr(destlist);
      i++;
      destlist = NextItem(destlist);
    }
  /*}}}*/
  /*{{{  load parameters, perform operation, store results maybe*/
  switch (pdno)
    {
      /*{{{  LONGADD CRCWORD CRCBYTE*/
      case PD_LONGADD:
      case PD_CRCWORD:
      case PD_CRCBYTE:
        tload3regs(P_EXP, param[2], P_EXP, param[1], P_EXP, param[0], loadseq);
        gensecondary(pdno == PD_LONGADD ? I_LADD    :
                     pdno == PD_CRCWORD ? I_CRCWORD :
                                          I_CRCBYTE);
        break;
      /*}}}*/
      /*{{{  LONGSUM LONGPROD*/
      case PD_LONGSUM:
      case PD_LONGPROD:
        tload3regs(P_EXP, param[2], P_EXP, param[1], P_EXP, param[0], loadseq);
        if (pdno == PD_LONGSUM)
          gensecondary(I_LSUM);
        else
          gensecondary(I_LMUL);
        tstoreregs(dest, 2);
        break;
      /*}}}*/
      /*{{{  LONGSUB*/
      case PD_LONGSUB:
        tload3regs(P_EXP, param[2], P_EXP, param[0], P_EXP, param[1], loadseq);
        gensecondary(I_LSUB);
        break;
      /*}}}*/
      /*{{{  LONGDIFF*/
      case PD_LONGDIFF:
        tload3regs(P_EXP, param[2], P_EXP, param[0], P_EXP, param[1], loadseq);
        gensecondary(I_LDIFF);
        tstoreregs(dest, 2);
        break;
      /*}}}*/
      /*{{{  LONGDIV*/
      case PD_LONGDIV:
        {
          treenode **temp;
          tload3regs(P_EXP, param[0], P_EXP, param[1], P_EXP, param[2], loadseq);
          temp = dest[0]; dest[0] = dest[1]; dest[1] = temp;
          gensecondary(I_LDIV);
          tstoreregs(dest, 2);
        }
        break;
      /*}}}*/
      /*{{{  SHIFTRIGHT SHIFTLEFT*/
      case PD_SHIFTRIGHT:
      case PD_SHIFTLEFT:
        tload3regs(P_EXP, param[0], P_EXP, param[1], P_EXP, param[2], loadseq);
        if (pdno == PD_SHIFTRIGHT)
          gensecondary(I_LSHR);
        else
          gensecondary(I_LSHL);
        tstoreregs(dest, 2);
        break;
      /*}}}*/
      /*{{{  NORMALISE*/
       case PD_NORMALISE:
        tload2regs(P_EXP, param[0], P_EXP, param[1], FALSE);
        gensecondary(I_NORM);
        tstoreregs(dest, 3);
        break;
      /*}}}*/
      /*{{{  FRACMUL BITCOUNT*/
      case PD_FRACMUL:
      case PD_BITCOUNT:
        tload2regs(P_EXP, param[1], P_EXP, param[0], FALSE);
        gensecondary(pdno == PD_FRACMUL  ? I_FMUL   :
                                          I_BITCNT);
        break;
      /*}}}*/
      /*{{{  BITREVNBITS*/
      case PD_BITREVNBITS:
        tload2regs(P_EXP, param[0], P_EXP, param[1], FALSE);
        gensecondary(I_BITREVNBITS);
        break;
      /*}}}*/
      /*{{{  ASHIFTRIGHT ASHIFTLEFT*/
      case PD_ASHIFTRIGHT:
      case PD_ASHIFTLEFT:
        /* param[0] has to be extended to double-length and so requires two
           registers to hold, so we have to preevaluate the count (param[1])
           needs more than MAXREGS - 2 */
        {
          int param1mode = P_EXP;
          if (preeval(param1mode, param[1]))
            /*{{{  preevaluate count to temporary*/
            {
              texp(NDeclOf(param[1]), MANY_REGS);
              storeinname(param[1], 0);
              param1mode = P_TEMP;
            }
            /*}}}*/
      
          texp(param[0], MANY_REGS);
          gensecondary(I_XDBLE);
          texpopd(param1mode, param[1], MAXREGS-2);
          if (pdno == PD_ASHIFTRIGHT)
            gensecondary(I_LSHR);
          else
            {
              gensecondary(I_LSHL);
              if (errormode & ERRORMODE_SHIFTCHECK) gensecondary(I_CSNGL);
            }
        }
        break;
      /*}}}*/
      /*{{{  ROTATERIGHT ROTATELEFT*/
      case PD_ROTATERIGHT:
      case PD_ROTATELEFT:
        {
          treenode *zero;
          switch_to_temp_workspace();
          zero = newconstant(0);
          switch_to_real_workspace();
          if (pdno == PD_ROTATERIGHT)
            {
              tload3regs(P_EXP, param[0], P_EXP, zero, P_EXP, param[1], loadseq);
              gensecondary(I_LSHR);
            }
          else
            {
              tload3regs(P_EXP, zero, P_EXP, param[0], P_EXP, param[1], loadseq);
              gensecondary(I_LSHL);
            }
          gensecondary(I_OR);
        }
        break;
      /*}}}*/
      /*{{{  UNPACKSN*/
      case PD_UNPACKSN:
        {
          treenode *zero;
          switch_to_temp_workspace();
          zero = newconstant(0);
          switch_to_real_workspace();
          tload2regs(P_EXP, zero, P_EXP, param[0], FALSE);
          gensecondary(I_UNPACKSN);
          /*{{{  reorder destinations*/
          {
            treenode **temp;
            temp = dest[0]; dest[0] = dest[2]; dest[2] = temp;
          }
          /*}}}*/
          tstoreregs(dest, 3);
        }
        break;
      /*}}}*/
      /*{{{  ROUNDSN*/
      case PD_ROUNDSN:
        {
          int Yfracmode = P_EXP, Yguardmode = P_EXP;
          treenode *Yexp = param[0], *Yfrac = param[1], *Yguard = param[2];
          int skiplab = newlab();
          INT32 altadjust = insidealtguard ? alt_ds + 1 : 0;
          if (preeval(Yfracmode, Yfrac))
            /*{{{  load Yfrac to temporary*/
            {
              texp(NDeclOf(Yfrac), MANY_REGS);
              storeinname(Yfrac, 0);
              Yfracmode = P_TEMP;
            }
            /*}}}*/
          if (preeval(Yguardmode, Yguard))
            /*{{{  load Yguard to temporary*/
            {
              texp(NDeclOf(Yguard), MANY_REGS);
              storeinname(Yguard, 0);
              Yguardmode = P_TEMP;
            }
            /*}}}*/
          tload2regs(Yfracmode, Yfrac,                 /*           Yfrac          */
                     Yguardmode, Yguard, TRUE);        /*           Yguard         */
          gensecondary(I_OR);                          /*           or             */
          genbranch(I_CJ, skiplab);                    /*           cj     skiplab */
          /*{{{  adjust workspace for alt if necessary*/
          genprimary(I_AJW, -altadjust);               /*           ajw    -n      */
          adjustworkspace(altadjust);
          /*}}}*/
          texp(Yexp, MANY_REGS);                       /*           Yexp           */
          genprimary(I_STL, ZERO32);                   /*           stl    0       */
          tload2regs(Yfracmode, Yfrac,                 /*           Yfrac          */
                     Yguardmode, Yguard, FALSE);       /*           Yguard         */
          gensecondary(I_NORM);                        /*           norm           */
          gensecondary(I_POSTNORMSN);                  /*           postnormsn     */
          /*{{{  adjust workspace for alt if necessary*/
          genprimary(I_AJW, altadjust);                /*           ajw    n       */
          adjustworkspace(-altadjust);
          /*}}}*/
          gensecondary(I_ROUNDSN);                     /*           roundsn        */
          setlab(skiplab);                             /* skiplab:                 */
        }
        break;
      /*}}}*/
      /*{{{  CAUSEERROR*/
      case PD_CAUSEERROR:
        gensecondary(I_SETERR);
        checkerror();
        break;
      /*}}}*/
      /*{{{  BITREVWORD*/
      case PD_BITREVWORD:
        texp(param[0], MANY_REGS);
        gensecondary(I_BITREVWORD);
        break;
      /*}}}*/
      /*{{{  MINUSX*/
      case PD_MINUSX:
        if (fpinline)
          /*{{{  generate it inline with operand on floating point stack*/
          {
            if (isconst(param[0]))
              tfpexp(param[0], MANY_REGS, MANY_REGS);
            else
              {
                treenode *temp = param[0];
                treenode *x = NDeclOf(temp);
                if (isaddressable(x))
                  loadelement(x, 0, MANY_REGS);
                else
                  {
                    tsimpleassign(typeof(temp), P_TEMP, temp, P_EXP, x, MANY_REGS);
                    loadname(temp, 0);
                  }
                gensecondary(I_MINT);
                gensecondary(I_XOR);
                storeinname(temp, 0);
                tfpexp(temp, MANY_REGS, MANY_REGS);
              }
          }
          /*}}}*/
        else
          {
            if (isconst(param[0]))
             texp(param[0], MANY_REGS);
            else
              {
                texp(param[0], MANY_REGS);
                gensecondary(I_MINT);
                gensecondary(I_XOR);
              }
          }
        break;
      /*}}}*/
      /*{{{  DMINUSX*/
      case PD_DMINUSX:
        /* fpinline must be TRUE to reach here */
        {
          if (isconst(param[0]))
            tfpexp(param[0], MANY_REGS, MANY_REGS);
          else
            {
              treenode *temp = param[0];
              tsimpleassign(S_REAL64, P_TEMP, temp, P_EXP, NDeclOf(temp), MANY_REGS);
              loadname(temp, 1);
              gensecondary(I_MINT);
              gensecondary(I_XOR);
              storeinname(temp, 1);
              tfpexp(temp, MANY_REGS, MANY_REGS);
            }
        }
        break;
      /*}}}*/
      /*{{{  DNOTFINITE ABS ISNAN MULBY2 DIVBY2 SQRT FPINT + double-length versions*/
      case PD_ABS:        case PD_DABS:
      case PD_ISNAN:      case PD_DISNAN:
                          case PD_DNOTFINITE:
      case PD_MULBY2:     case PD_DMULBY2:
      case PD_DIVBY2:     case PD_DDIVBY2:
      case PD_SQRT:       case PD_DSQRT:
      case PD_FPINT:      case PD_DFPINT:
        tfpexp(param[0], MANY_REGS, MANY_REGS);
        switch (pdno)
          {
            case PD_ABS:    case PD_DABS:
              if (H1_instr) gensecondary(I_FPABS);
              else          genfpuentry(I_FPUABS);
              break;
            case PD_ISNAN:  case PD_DISNAN:   gensecondary(I_FPNAN);       break;
            case PD_MULBY2: case PD_DMULBY2:
              if (H1_instr) gensecondary(I_FPMULBY2);
              else          genfpuentry(I_FPUMULBY2);
              break;
            case PD_DIVBY2: case PD_DDIVBY2:
              if (H1_instr) gensecondary(I_FPDIVBY2);
              else          genfpuentry(I_FPUDIVBY2);
              break;
            case PD_FPINT:  case PD_DFPINT:   gensecondary(I_FPINT);       break;
            case PD_DNOTFINITE:               gensecondary(I_FPNOTFINITE); break;
            case PD_SQRT:   case PD_DSQRT:
              if (H1_instr)
                gensecondary(I_FPSQRT);
              else
                /*{{{  fpusqrtfirst; fpusqrtstep; ...; fpusqrtlast*/
                {
                  int i = (pdno == PD_SQRT) ? 2 : 5;
                  genfpuentry(I_FPUSQRTFIRST);
                  while (i-- > 0)
                    genfpuentry(I_FPUSQRTSTEP);
                  genfpuentry(I_FPUSQRTLAST);
                }
                /*}}}*/
              break;
          }
        break;
      /*}}}*/
      /*{{{  ORDERED DORDERED*/
      case PD_ORDERED:
      case PD_DORDERED:
        tfpload2regs(param[0], param[1], MANY_REGS, MANY_REGS, TRUE);
        gensecondary(I_FPORDERED);
        break;
      /*}}}*/
      /*{{{  NOTFINITE*/
      case PD_NOTFINITE:
        if (fpinline)
          {
            tfpexp(param[0], MANY_REGS, MANY_REGS);
            gensecondary(I_FPNOTFINITE);
          }
        else if (fpsupport)
          {
            texp(param[0], MANY_REGS);
            gensecondary(I_LDINF);
            gensecondary(I_AND);
            gensecondary(I_LDINF);
            gensecondary(I_DIFF);
            genprimary(I_EQC, ZERO32);
          }
        else /* to work on any 32 bit processor */
          {
            #if 0
            /* we couldn't get the infinity into the constant table */
            /* cos we re-generate the node here. We need to somehow use the */
            /* same one as was used when mapping */
            treenode *inf;
            switch_to_temp_workspace();
            inf = newconstant(INFINITY);
            switch_to_prev_workspace();
            tload2regs(P_EXP, inf, P_EXP, param[0], FALSE);
            #endif /* 0 */
            texp(param[0], MANY_REGS);
            loadconstant(INFINITY);
            gensecondary(I_AND);
            genprimary(I_EQC, INFINITY);
          }
        break;
      /*}}}*/
      /*{{{  LOADINPUTCHANNEL + friends*/
      case PD_LOADINPUTCHANNEL:
      case PD_LOADOUTPUTCHANNEL:
        tsimpleassign(S_INT, P_EXP, param[0],
               chanaspointer ? P_EXP : P_PTR, param[1], MANY_REGS);
        break;
      case PD_LOADINPUTCHANNELVECTOR:
      case PD_LOADOUTPUTCHANNELVECTOR:
      case PD_LOADBYTEVECTOR:
        tsimpleassign(S_INT, P_EXP, param[0], P_PTR, param[1], MANY_REGS);
        break;
      /*}}}*/
      /*{{{  KERNELRUN*/
      case PD_KERNELRUN:
        {
          treenode *codeptr = param[0],
                   *returnaddress = param[1],
                   *workspaceend = param[2];
          INT32 nparams = LoValOf(param[3]);
          int returnlab = newlab();
          SetNVOffset(returnaddress, returnlab);
          tload3regs(P_PTR, codeptr, P_PTR, returnaddress, P_PTR, workspaceend,
                     loadseq);
          gensecondary(I_GAJW);
          genprimary(I_AJW, -(nparams + 2));
          genprimary(I_STL, nparams + 1);
          genprimary(I_STL, 0);
          checkerror ();
          gensecondary(I_GCALL);
          setlab(returnlab);
          genprimary(I_LDL, nparams - 3); /* was nparams + 3 ? */
          gensecondary(I_GAJW);
        }
        break;
      /*}}}*/
      /*{{{  MOVE2D CLIP2D DRAW2D*/
      case PD_MOVE2D:
      case PD_CLIP2D:
      case PD_DRAW2D:
        {
          /*{{{  abbreviate the parameters to sensible names*/
          treenode *source =     param[0], *sourcestride = dimexpof(source, 1),
                   *sx =         param[1],
                   *sy =         param[2],
                   *dest =       param[3], *deststride = dimexpof(dest, 1),
                   *dx =         param[4],
                   *dy =         param[5],
                   *width =      param[6],
                   *length =     param[7],
                   *sourceaddr = param[8],
                   *destaddr =   param[9],
                   *sxcheck =    param[10],
                   *sycheck =    param[11],
                   *dxcheck =    param[12],
                   *dycheck =    param[13];
          /*}}}*/
          int sxmode = P_EXP, symode = P_EXP, dxmode =  P_EXP, dymode = P_EXP,
              widthmode = P_EXP, lengthmode = P_EXP,
              sourcemode = P_EXP, destmode = P_EXP;
          int loadseq1, preeval_e2, preeval_e3;
      
          /* we have to simplify this first, so that we can't timeslice
             between move2dinit and move2d etc. Bug 403 29/8/90
             Note that some of the range checks depend upon the width.
          */
          widthmode = simplify(widthmode, width);
      
          if (RANGECHECKING)
            /*{{{  do some checking*/
            {
              sxmode = simplify(sxmode, sx);
              symode = simplify(symode, sy);
              dxmode = simplify(dxmode, dx);
              dymode = simplify(dymode, dy);
              lengthmode = simplify(lengthmode, length);
              if (sxcheck != NULL) texp(sxcheck, MANY_REGS);
              if (sycheck != NULL) texp(sycheck, MANY_REGS);
              if (dxcheck != NULL) texp(dxcheck, MANY_REGS);
              if (dycheck != NULL) texp(dycheck, MANY_REGS);
            }
            /*}}}*/

          /* we have to simplify these first, so that we can't timeslice
             between move2dinit and move2d etc. Bug 403 29/8/90
          */
          sourcemode = simplify(sourcemode, sourceaddr);
          destmode   = simplify(destmode,   destaddr);

          loadseq1 = giveorder(P_EXP, sourcestride, P_EXP, deststride,
                               lengthmode, length, &preeval_e2, &preeval_e3);
          tload3regs(P_EXP, sourcestride, P_EXP, deststride,
                     lengthmode, length, loadseq1);
          gensecondary(I_MOVE2DINIT);
      
          tload3regs(sourcemode, sourceaddr, destmode, destaddr, widthmode, width, loadseq);
          checkerror ();
          gensecondary((pdno == PD_MOVE2D) ? I_MOVE2DALL :
                       (pdno == PD_DRAW2D) ? I_MOVE2DNONZERO :
                                             I_MOVE2DZERO);
        }
        break;
      /*}}}*/
      /*{{{  RESCHEDULE*/
      case PD_RESCHEDULE:
        if (H1_instr)
          gensecondary(I_TIMESLICE);
        else
          {
            genprimary(I_LDLP, 0);
            gensecondary(I_STARTP);
            gensecondary(I_STOPP);
          }
        genstartblock();
        break;
      /*}}}*/
      /*{{{  ASSERT*/
      case PD_ASSERT:
        if (NEED_ERRORS && !ignore_assertions && !isconst(param[0]))
          {
            texp(param[0], MANY_REGS);
            genprimary(I_LDC, 1);
            gensecondary(I_CCNT1);
            checkerror();
          }
        break;
      /*}}}*/
    }
  /*}}}*/
}
/*}}}*/
/*}}}*/
