
/******************************************************************************
*
*  Code generator gen7 - Boolean expression generation - single & double length
*
******************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
*
******************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include "includes.h"
# include "generror.h"
# include "instruct.h"
# include "genhdr.h"
# include "chkdef.h"
# include "gen1def.h"
# include "gen2def.h"
# include "gen4def.h"
# include "gen5def.h"
# include "gen7def.h"
# include "gen11def.h"
# include "gen12def.h"
# include "bind3def.h"
# include "code1def.h"
/*}}}*/

/*{{{  PRIVATE void trelop(op, type, left, right, sense, genbool, regs)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  trelop generates code for relational operator 'op' into Areg, using at
 *         most 'regs' registers.
 *         If 'genbool' is TRUE, a strictly Boolean result is left in Areg.
 *         If 'sense' is FALSE, the result is inverted.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void trelop ( int op , int type , treenode *left , treenode *right , int sense , int genbool , int regs )
{
  if (fpinline && isreal(type))
    /*{{{  do inline floating comparison*/
    {
      treenode *comparison;
      int old = switch_to_temp_workspace();
      comparison = newdopnode(op, 0, left, right, type);
      switch_to_prev_workspace(old);
      tfpexp(comparison, regs, MAXFPUREGS);
      if (!sense) genprimary(I_EQC, ZERO32);
    }
    /*}}}*/
  else if (fitsinword(type))
    switch (op)
      {
        /*{{{  S_EQ*/
        case S_EQ:
          if (isconst(right))
            /*{{{  swap left and right*/
            {
              treenode *temp = left;
              left = right; right = temp;
            }
            /*}}}*/
        
          if (type == S_BOOL)
            /*{{{  BOOL*/
            {
              if (isconst(left))
                /*{{{  right; (eqc 0)*/
                {
                  texp(right, regs);
                  if (((LoValOf(left) == ZERO32) && sense) ||
                      ((LoValOf(left) == ONE32) && (!sense)))
                    genprimary(I_EQC, ZERO32);
                }
                /*}}}*/
              else
                /*{{{  left; right; xor; (eqc 0)*/
                {
                  tdop(S_XOR, type, left, right, regs, TRUE);
                  if (sense) genprimary(I_EQC, ZERO32);
                }
                /*}}}*/
            }
            /*}}}*/
          else if (istargetintsize(type) || (isshorttype(type)))
            /*{{{  short or INT*/
            {
              /*{{{  comment on the following guard*/
              /* The genbool || sense || (LoValOf(left) == 0) guard is used because
                 this branch would generate
                   exp; eqc n; eqc 0
                 under the condition (!genbool && !sense && (LoValOf(left) != 0))
                 whereas
                   exp; ldc n; diff
                 is two cycles quicker.
               */
              /*}}}*/
              if (isconst(left) && !isinconstanttable(left) &&
                  (genbool || sense || LoValOf(left) == ZERO32))
                /* constant, but not in a table */
                /*{{{  right; eqc left*/
                {
                  texp(right, regs);
                  if (!genbool && !sense && (LoValOf(left) == ZERO32))
                    /* we don't need to generate anything */
                    ;
                  else
                    {
                      genprimary(I_EQC, LoValOf(left));
                      if (!sense) genprimary(I_EQC, ZERO32);
                    }
                }
                /*}}}*/
              else
                /*{{{  left; right; diff*/
                {
                  tdop(S_MINUS, type, left, right, regs, TRUE);
                  /* must have at least one EQC to convert expr to Boolean */
                  if (!sense)
                    /*{{{  we already have correct sense - do we convert to Boolean?*/
                    {
                      if (genbool)  /* Result must be a genuine Boolean */
                        {
                          genprimary(I_EQC, ZERO32);
                          genprimary(I_EQC, ZERO32);
                        }
                    }
                    /*}}}*/
                  else
                    genprimary(I_EQC, ZERO32);
                }
                /*}}}*/
            }
            /*}}}*/
          else
            geninternal_is(GEN_ERROR_IN_ROUTINE, 1, "trelop");
          break;
        /*}}}*/
        /*{{{  S_GR*/
        case S_GR:
          if (istargetintsize(type) || isshorttype(type))
            /*{{{  short or INT*/
            {
              tdop(S_GR, type, left, right, regs, FALSE);
              if (!sense)
                genprimary(I_EQC, ZERO32);
            }
            /*}}}*/
          else
            geninternal_is(GEN_ERROR_IN_ROUTINE, 3, "trelop");
          break;
        /*}}}*/
        default:
          geninternal_is(GEN_ERROR_IN_ROUTINE, 2, "trelop");
      }
  else
    trellop(op, type, left, right, sense, genbool);
  checkerror();
}
/*}}}*/
/*{{{  PRIVATE void jumpcond(tptr, truelab, falselab, sense, genbool, regs)*/

/*{{{  comment*/
/* Evaluate expression tptr.
Go to truelab/falselab
if you hit the result early, but make sure that the result
left in Areg is inverted if sense is FALSE.
If genbool is TRUE make sure any result left in Areg is a genuine Boolean
value.
If regs == MANY_REGS then the Boolean expressions may contain temporaries,
otherwise use at most 'regs' registers in evaluating the expressions.
*/
/*}}}*/
PRIVATE void jumpcond ( treenode *tptr , int truelab , int falselab , int sense , int genbool , int regs )
{
  switch(TagOf(tptr))
    {
      /*{{{  dyadic nodes*/
      /*{{{  S_AND*/
      case S_AND:
        if (sense)
          {
            int il = newlab();
            jumpcond (LeftOpOf(tptr), il, falselab, TRUE, FALSE, regs);
            genbranch(I_CJ, falselab);
            setlab(il);
            tpreexp(RightOpOf(tptr));
            jumpcond(RightOpOf(tptr), truelab, falselab, TRUE, genbool, regs);
          }
        else
          {
            int il = newlab(), l = newlab();
            jumpcond (LeftOpOf(tptr), il, l, TRUE, FALSE, regs);
            genbranch(I_CJ, l);
            setlab(il);
            tpreexp(RightOpOf(tptr));
            jumpcond(RightOpOf(tptr), l, l, TRUE, FALSE, regs);
            setlab(l);
            genprimary (I_EQC, ZERO32);
          }
        break;
      /*}}}*/
      /*{{{  S_OR*/
      case S_OR:
        if (sense)
          {
            int l = newlab(), il = newlab();
            jumpcond(LeftOpOf(tptr), l, il, FALSE, FALSE, regs);
            genbranch(I_CJ, l);
            setlab(il);
            jumpcond(RightOpOf(tptr), l, l, FALSE, FALSE, regs);
            setlab(l);
            genprimary(I_EQC, ZERO32);
          }
        else
          {
            int il = newlab();
            jumpcond(LeftOpOf(tptr), truelab, il, FALSE, FALSE, regs);
            genbranch(I_CJ, truelab);
            setlab(il);
            jumpcond(RightOpOf(tptr), truelab, falselab, FALSE, genbool, regs);
          }
        break;
      /*}}}*/
      /*{{{  S_EQ*/
      case S_EQ:
        trelop (S_EQ, DOpTypeOf(tptr),
                      LeftOpOf(tptr), RightOpOf(tptr), sense, genbool, regs);
        break;
      /*}}}*/
      /*{{{  S_NE*/
      case S_NE:
        trelop (S_EQ, DOpTypeOf(tptr),
                LeftOpOf(tptr), RightOpOf(tptr), !sense, genbool, regs);
        break;
      /*}}}*/
      /*{{{  S_GR*/
      case S_GR:
        trelop (S_GR, DOpTypeOf(tptr),
                LeftOpOf(tptr), RightOpOf(tptr), sense, genbool, regs);
        break;
      /*}}}*/
      /*{{{  S_LS*/
      case S_LS:
        trelop (S_GR, DOpTypeOf(tptr),
                RightOpOf(tptr), LeftOpOf(tptr), sense, genbool, regs);
        break;
      /*}}}*/
      /*{{{  S_GE*/
      case S_GE:
        trelop (S_GR, DOpTypeOf(tptr),
                RightOpOf(tptr), LeftOpOf(tptr), !sense, genbool, regs);
        break;
      /*}}}*/
      /*{{{  S_LE*/
      case S_LE:
        trelop (S_GR, DOpTypeOf(tptr),
                LeftOpOf(tptr), RightOpOf(tptr), !sense, genbool, regs);
        break;
      /*}}}*/
      /*{{{  S_AFTER*/
      case S_AFTER:
        /* Convert { left AFTER right } to { (left MINUS right) > 0 } */
        SetTag(tptr, S_MINUS);
        trelop(S_GR, DOpTypeOf(tptr), tptr, newconstant(0), sense, genbool, regs);
        break;
      /*}}}*/
      /*}}}*/
      /*{{{  monadic nodes*/
      /*{{{  S_NOT*/
      case S_NOT:
        jumpcond(OpOf(tptr), falselab, truelab, !sense, genbool, regs);
        break;
      /*}}}*/
      /*}}}*/
      default:  /* load expression */
        texp(tptr, regs);
        checkerror ();
        if (!sense) genprimary (I_EQC, ZERO32);
        break;
    }
}
/*}}}*/
/*{{{  PUBLIC void tbool(tptr, regs)*/
/*****************************************************************************
 *
 *  tbool generates Boolean expression tptr into Areg using at most 'regs'
 *        registers.
 *
 *****************************************************************************/
PUBLIC void tbool ( treenode *tptr , int regs )
{
  int l = newlab();
  jumpcond(tptr, l, l, TRUE, TRUE, regs);
  setlab(l);
}
/*}}}*/
/*{{{  PUBLIC void tguard(tptr, fallthroughsense, otherlabel)*/
/*****************************************************************************
 *
 *  tguard generates code for the conditional expression tptr such that if
 *         the expression evaluates to the same sense (TRUE/FALSE) as
 *         'fallthroughsense', control passes to the first instruction
 *         following tguard, otherwise control passes to the label
 *         'otherlabel'.
 *         This routine differs from jumpcond as the expression result is
 *         not preserved, and thus greater shortcuts can be taken.
 *
 *****************************************************************************/
PUBLIC void tguard ( treenode *tptr , int fallthroughsense , int otherlabel )
{
  switch(TagOf(tptr))
    {
      /*{{{  cases*/
      /*{{{  case S_OR*/
      case S_OR:
        {
          int lab;
          if (fallthroughsense)
            lab = newlab();
          else
            lab = otherlabel;
          tguard(LeftOpOf(tptr), FALSE, lab);
          tpreexp(RightOpOf(tptr));
          tguard(RightOpOf(tptr), fallthroughsense, otherlabel);
          if (fallthroughsense)
            setlab(lab);
        }
        break;
      /*}}}*/
      /*{{{  case S_AND*/
      case S_AND:
        {
          int lab;
          if (fallthroughsense)
            lab = otherlabel;
          else
            lab = newlab();
          tguard(LeftOpOf(tptr), TRUE, lab);
          tpreexp(RightOpOf(tptr));
          tguard(RightOpOf(tptr), fallthroughsense, otherlabel);
          if (!fallthroughsense)
            setlab(lab);
        }
        break;
      /*}}}*/
      /*{{{  case S_EQ*/
      case S_EQ:
        trelop(S_EQ, DOpTypeOf(tptr), LeftOpOf(tptr), RightOpOf(tptr),
               fallthroughsense, FALSE, MANY_REGS);
        genbranch(I_CJ, otherlabel);
        break;
      /*}}}*/
      /*{{{  case S_NE*/
      case S_NE:
        trelop(S_EQ, DOpTypeOf(tptr), LeftOpOf(tptr), RightOpOf(tptr),
               !fallthroughsense, FALSE, MANY_REGS);
        genbranch(I_CJ, otherlabel);
        break;
      /*}}}*/
      /*{{{  case S_GR*/
      case S_GR:
        trelop(S_GR, DOpTypeOf(tptr), LeftOpOf(tptr), RightOpOf(tptr),
               fallthroughsense, FALSE, MANY_REGS);
        genbranch(I_CJ, otherlabel);
        break;
      /*}}}*/
      /*{{{  case S_LS*/
      case S_LS:
        trelop(S_GR, DOpTypeOf(tptr), RightOpOf(tptr), LeftOpOf(tptr),
               fallthroughsense, FALSE, MANY_REGS);
        genbranch(I_CJ, otherlabel);
        break;
      /*}}}*/
      /*{{{  case S_GE*/
      case S_GE:
        trelop(S_GR, DOpTypeOf(tptr), RightOpOf(tptr), LeftOpOf(tptr),
               !fallthroughsense, FALSE, MANY_REGS);
        genbranch(I_CJ, otherlabel);
        break;
      /*}}}*/
      /*{{{  case S_LE*/
      case S_LE:
        trelop(S_GR, DOpTypeOf(tptr), LeftOpOf(tptr), RightOpOf(tptr),
               !fallthroughsense, FALSE, MANY_REGS);
        genbranch(I_CJ, otherlabel);
        break;
      /*}}}*/
      /*{{{  case S_NOT*/
      case S_NOT:
        tguard(OpOf(tptr), !fallthroughsense, otherlabel);
        break;
      /*}}}*/
      default:
        texp(tptr, MANY_REGS);
        checkerror ();
        if (!fallthroughsense)
          genprimary(I_EQC, ZERO32);
        genbranch(I_CJ, otherlabel);
        break;
      /*}}}*/
    }
}
/*}}}*/
