/*#define DEBUG*/
/******************************************************************************
*
*  Code generator gen5 - double-length expression generation
*
******************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
*
******************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include "includes.h"
# include "generror.h"
# include "instruct.h"
# include "genhdr.h"
# include "syndef.h"
# include "chkdef.h"
# include "usedef.h"
# include "desc1def.h"
# include "bind1def.h"
# include "bind2def.h"
# include "bind3def.h"
# include "gen1def.h"
# include "gen2def.h"
# include "gen4def.h"
# include "gen5def.h"
# include "gen8def.h"
# include "gen11def.h"
# include "gen12def.h"
# include "code1def.h"
/*}}}*/

/*{{{  forward declarations*/
void mapmovelopd PARMS((int destmode, treenode **dest, int sourcemode, treenode **source));
void movelopd PARMS((int destmode, treenode *dest, int sourcemode, treenode *source));
/*}}}*/

/*{{{  local variables*/
PRIVATE treenode **valofresult;
PRIVATE int valofresultmode;
/*}}}*/

/*{{{  private*/
/*{{{  support*/
/*{{{  PRIVATE int isnotexpression*/
PRIVATE int isnotexpression(treenode *tptr)
/*****************************************************************************
 *
 *  isnotexpression returns TRUE if tptr is a name, or subscripted name, etc
 *                  (infact it is TRUE iff we can call basedecl)
 *
 *****************************************************************************/
{
  switch(nodetypeoftag(TagOf(tptr)))
    {
      case NAMENODE:
      case ARRAYSUBNODE: case SEGMENTNODE:
      case HIDDENPARAMNODE:  /* incase of formal parameters */
        return TRUE;
      default:
        return FALSE;
    }
}
/*}}}*/
/*{{{  PRIVATE int issameopd (opdmode1, opd1, opdmode2, opd2)  ***/
/*****************************************************************************
 *
 *  issameopd returns TRUE if (opdmode1, opd1) and (opdmode2, opd2)
 *            represent the same variables.
 *
 *****************************************************************************/
PRIVATE int issameopd ( int opdmode1 , treenode *opd1 , int opdmode2 , treenode *opd2 )
{
  if ((opdmode1 == P_TEMP) || (opdmode2 == P_TEMP) ||
      isconstopd(opdmode1, opd1) || isconstopd(opdmode2, opd2))
    return(FALSE);
  else if (isnotexpression(opd1) && isnotexpression(opd2))
    return(basedecl(opd1) == basedecl(opd2));
  else
    return(FALSE);
}
/*}}}*/
/*{{{  PRIVATE void gendoubleaddop (result.., left.., right.., ilow, ihigh)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  gendoubleaddop generates code for a double length additive operator.
 *                 ilow is the operation to be applied to the lower halves,
 *                 ihigh is the operation to be applied to the upper halves.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void gendoubleaddop ( int resultmode , treenode *result , int leftmode , treenode *left , int rightmode , treenode *right , int ilow , int ihigh )
{
  int lconst = isconstopd(leftmode, left),
      rconst = isconstopd(rightmode, right);

  /*{{{  do lower half*/
  if (rconst && wordof(right, 0) == 0)
    /*{{{  optimise*/
    {
      loadopd(leftmode, left, 0);                   /* ld    leftlow        */
      storeinopd(resultmode, result, 0, MAXREGS -1);/* st    resultlow      */
      genprimary(I_LDC, 0);                         /* ldc   0              */
    }
    /*}}}*/
  else if ((ilow == I_LSUM) && lconst && (wordof(left, 0) == 0))
    /*{{{  optimise*/
    {
      loadopd(rightmode, right, 0);                 /* ld    rightlow       */
      storeinopd(resultmode, result, 0, MAXREGS-1); /* st    resultlow      */
      genprimary(I_LDC, 0);                         /* ldc   0              */
    }
    /*}}}*/
  else
    {
      genprimary (I_LDC, 0);                        /* ldc   0              */
      loadopd(leftmode, left, 0);                   /* ld    leftlow        */
      loadopd(rightmode, right, 0);                 /* ld    rightlow       */
      gensecondary (ilow);                          /* ilow                 */
      storeinopd (resultmode, result, 0, MAXREGS-2);/* st    resultlow      */
    }
  /*}}}*/
  /*{{{  do upper half*/
  loadopd(leftmode, left, 1);                   /* ld    lefthigh       */
  loadopd(rightmode, right, 1);                 /* ld    righthigh      */
  gensecondary (ihigh);                         /* ihigh                */
  storeinopd(resultmode, result, 1, MAXREGS-1); /* st    resulthigh     */
  /*}}}*/
}
/*}}}*/
/*{{{  PRIVATE int crossoperator (op)*/
/*****************************************************************************
 *
 *  crossoperator returns TRUE if the double-length operator 'op' is a cross
 *                operator.
 *
 *****************************************************************************/
PRIVATE int crossoperator ( int op )
{
  return((op == S_TIMES) || (op == S_MULT));
}
/*}}}*/
/*{{{  PRIVATE int complexity (tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  complexity is a heuristic which we use to decide which side of a
 *             (non-word length) dyadic operator to evaluate first.
 *             Basically,
 *               complexity(name) = 1
 *               complexity(constant) = 1
 *               complexity(monadic_op(op)) = complexity(op)
 *               complexity(dyadic_op(op1, op2)) =
 *                        (complexity(op1) == complexity(op2))      ?
 *                            complexity(op1) + 1                   :
 *                            max(complexity(op1), complexity(op2))
 *
 *****************************************************************************/
/*}}}*/
PRIVATE int complexity ( treenode *tptr )
{
  switch(TagOf(tptr))
    {
      /*{{{  monadic operators*/
      case S_NEG:
      case S_BITNOT: return(complexity(OpOf(tptr)));
      /*}}}*/
      /*{{{  conversion*/
      case S_EXACT: case S_ROUND: case S_TRUNC:
        return(complexity(OpOf(tptr)));
      /*}}}*/
      /*{{{  dyadic operators*/
      case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV: case S_REM:
      case S_BITAND: case S_BITOR: case S_XOR:
      case S_PLUS: case S_MINUS: case S_TIMES:
        {
          const int leftc  = complexity(LeftOpOf(tptr));
          const int rightc = complexity(RightOpOf(tptr));
          return((leftc == rightc) ? leftc + 1 : max(leftc, rightc));
        }
      /*}}}*/
      /*{{{  shifts*/
      case S_LSHIFT: case S_RSHIFT:
        return(complexity(LeftOpOf(tptr)));
      /*}}}*/
      /*{{{  function instance/valof*/
      case S_FINSTANCE: case S_VALOF:
        return(100);
      /*}}}*/
      /*{{{  elements*/
      case S_ARRAYITEM:
      case N_VALABBR: case N_ABBR:
      case N_VALRETYPE: case N_RETYPE:
      case N_VALPARAM: case N_PARAM:
      case N_DECL:
      case T_PREEVALTEMP: case N_REPL:
      case S_CONSTEXP:
        return(1);
      case T_TEMP:
        return(complexity(NDeclOf(tptr)));
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "complexity");
    }
  return (0); /* Not reached */
}
/*}}}*/
/*{{{  PRIVATE int loadlopdptr (opdmode, opd)*/
/*****************************************************************************
 *
 *  loadlopdptr returns TRUE if we should preevaluate a pointer to double-
 *              length operand (opdmode, opd)
 *
 *****************************************************************************/
PRIVATE int loadlopdptr ( int opdmode , treenode *opd )
{
  return !(issimpleopd(opdmode, opd) || isconstopd(opdmode, opd) ||
           ((opdmode == P_EXP) && (TagOf(opd) == S_ARRAYITEM) &&
            (ASExpOf(opd) == NULL)) );
}
/*}}}*/
/*}}}*/

/*{{{  private mapping routines*/
/*{{{  PRIVATEPARAM void maplvalof (treenode *valoftree)*/
PRIVATEPARAM void maplvalof ( treenode *valoftree )
{
  mapprocess(VLBodyOf(valoftree));
  mapmovelopd(valofresultmode, valofresult,
              P_EXP, ThisItemAddr(VLResultListOf(valoftree)));
}
/*}}}*/
/*{{{  PRIVATEPARAM void mapqvalof (treenode *valoftree)*/
PRIVATEPARAM void mapqvalof ( treenode *valoftree )
{
  mapprocess(VLBodyOf(valoftree));
  mapmoveqopd(valofresultmode, valofresult,
              P_EXP, ThisItemAddr(VLResultListOf(valoftree)));
}
/*}}}*/
/*{{{  PRIVATE int mappreparelopd (opdmode, opd, tempmade)*/
/*****************************************************************************
 *
 *  mappreparelopd allocates a temporary in which to load a pointer to opd
 *                 if neccesary.
 *
 *****************************************************************************/
PRIVATE int mappreparelopd ( int opdmode , treenode **opd , int *tempmade )
{
  DEBUG_MSG(("mappreparelopd: opdmode = %d\n", opdmode));
  if (opdmode != P_TEMP)
    {
      if (loadlopdptr(opdmode, *opd))
        /*{{{  load a pointer to opd into a temporary*/
        {
          /* Note that here we load a pointer to the operand into
             a temporary, but we still want to access the operand, not a
             pointer to it, so we DON'T do
               opdmode = tempmodeof(ptrmodeof(opd))   */
          DEBUG_MSG(("mappreparelopd: creating a pointer temporary\n"));
          mapexpopd(ptrmodeof(opdmode), opd);
          *opd = gettemp(*opd, NM_POINTER);
          upusecount (*opd, 1);
          opdmode = tempmodeof(opdmode);
          *tempmade = TRUE;
        }
        /*}}}*/
      else
        {
          DEBUG_MSG(("mappreparelopd: NOT creating a pointer temporary\n"));
          mapexpopd(opdmode, opd);
        }
    }
  else
    upusecount (*opd, 1);
  return(opdmode);
}
/*}}}*/
/*{{{  PRIVATE void mapqopandassign(resultmode, result, opd)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  mapqopandassign maps the evaluation of expression 'opd' into
 *                  (resultmode, result).
 *                  The calling of this routine is such that we can always
 *                  generate into result.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void mapqopandassign ( int resultmode , treenode **result , treenode **opd )
{
  while (TRUE)
    {
      int op = TagOf(*opd);
      SOURCEPOSN locn = LocnOf(*opd);
      int type = typeof(*opd);
      if (isreal(type))
        /*{{{  pick out special real cases*/
        {
          switch(op)
            {
              default:
                break;  /* Fall out to other cases */
              /*{{{  ADD SUBTRACT MULT DIV REM*/
              case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV: case S_REM:
                *opd = makedopfunction(*opd);
                break;
              /*}}}*/
              /*{{{  NEG*/
              case S_NEG:
                {
                  treenode *zeroopd = newconstexpnode(S_CONSTEXP, locn,
                                        newlitnode(littag(type), locn, NULL),
                                        ZERO32, ZERO32);
                  *opd = newdopnode(S_SUBTRACT, locn, zeroopd, OpOf(*opd), type);
                  *opd = makedopfunction(*opd);
                }
                break;
              /*}}}*/
              /*{{{  EXACT ROUND TRUNC*/
              case S_EXACT:
              case S_ROUND: case S_TRUNC:
                {
                  treenode *source = OpOf(*opd);
                  int sourcetype = typeof(source);
                  int desttype = MOpTypeOf(*opd);
                  if (sourcetype == S_INT) sourcetype = targetintsize;
                  #if 0 /* this was done in trans */
                  if (sourcetype == desttype)
                    {
                      *opd = OpOf(*opd); /* Remove the conversion */
                      mapmoveqopd(resultmode, result, P_EXP, opd);
                      return;
                    }
                  else  /* must be REAL32 to REAL64 */
                  #endif
                    *opd = makeconversion(sourcetype, desttype, source, op);
                }
                break;
              /*}}}*/
            }
          op = TagOf(*opd);
        }
        /*}}}*/
      switch (op)
        {
          default:
            badtag(genlocn, op, "mapqopandassign");
            break;
          /*{{{  dyadics  -> function calls*/
          case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV: case S_REM:
          case S_PLUS: case S_MINUS: case S_TIMES:
          case S_BITAND: case S_BITOR: case S_XOR:
          case S_LSHIFT: case S_RSHIFT:
            *opd = makedopfunction(*opd);
            break;
          /*}}}*/
          /*{{{  monadics -> dyadic function calls*/
          case S_UMINUS: case S_NEG:
            {
              int type = MOpTypeOf(*opd);
              *opd = newdopnode((op == S_NEG) ? S_SUBTRACT : S_MINUS, locn,
                         newconstexpnode(S_CONSTEXP, locn,
                                         newlitnode(littag(type), locn, NULL),
                                         ZERO32, ZERO32),
                         OpOf(*opd), type);
            }
            break;
          /*}}}*/
          /*{{{  monadics -> monadic function calls*/
          case S_BITNOT:
            {
              int type = MOpTypeOf(*opd);
              *opd = newinstancenode(S_FINSTANCE, locn,
                                  libentry(libcallstring(op, type), locn),
                                  newlistnode(S_LIST, locn, OpOf(*opd), NULL));
            }
            break;
          /*}}}*/
          /*{{{  conversions -> function calls*/
          case S_EXACT:
          case S_ROUND:
          case S_TRUNC:
            {
              treenode *source = OpOf(*opd);
              int sourcetype = typeof(source);
              int desttype = MOpTypeOf(*opd);
              #if 0 /* this was done in trans */
              if (sourcetype == desttype)
                {
                  *opd = source; /* Remove the conversion */
                  mapmoveqopd(resultmode, result, P_EXP, opd);
                  return;
                }
              else
              #endif
                {
                  if (isshortint(sourcetype) || istargetbytesize(sourcetype))
                    /*{{{  convert source to an integer first*/
                    {
                      source = newmopnode(S_EXACT, LocnOf(source), source, S_INT);
                      sourcetype = S_INT;
                    }
                    /*}}}*/
                  *opd = makeconversion(sourcetype, desttype, source, op);
                }
            }
            break;
          /*}}}*/
          /*{{{  function call*/
          case S_FINSTANCE:
            {
              treenode *instancedfn;
              if (TagOf(INameOf(*opd)) == N_PREDEFFUNCTION)
                /*{{{  map the predef, or convert it to a library call*/
                {
                  if (mappredef(*opd, newlistnode(S_LIST, locn, *result, NULL)))
                      return; /* it was done inline */
                    }
                /*}}}*/
              instancedfn = INameOf(*opd);
              {
                treenode *paramlist = IParamListOf(*opd);
                int maketempresult = FALSE;
                /*{{{  see if result is aliassed in the function*/
                if ((resultmode ==P_EXP) || (resultmode == P_PTR))
                  {
                    treenode *p = paramlist;
                    if (isafreevarof(basedecl(*result), instancedfn))
                      maketempresult = TRUE;
                    while (!maketempresult && !EndOfList(p))
                      {
                        if (isaddressable(ThisItem(p)) && usedin(*result, ThisItem(p)))
                          maketempresult = TRUE;
                        p = NextItem(p);
                      }
                  }
                /*}}}*/
                if (maketempresult)
                  /*{{{  generate fn. result to temporary, then after call move to result*/
                  {
                    *opd = gettemp(*opd, NM_WORKSPACE);
                    mapqopandassign(P_TEMP, opd, NDeclAddr(*opd));
                    mapmoveqopd(resultmode, result, P_TEMP, opd);
                    freetemp(*opd);
                  }
                  /*}}}*/
                else
                  /*{{{  generate fn. to result*/
                  {
                    /*{{{  augment actual parameters*/
                    {
                      treenode *dest;
                      int old = switch_to_temp_workspace();
                      dest = newlistnode(S_LIST, 0, *result, NULL);
                      switch_to_prev_workspace(old);
                      paramlist = augmentparams(paramlist,
                                                FnParamsOf(NTypeOf(instancedfn)), dest);
                      SetIParamList(*opd, paramlist);
                    }
                    /*}}}*/
                    mapinstance(*opd);
                  }
                  /*}}}*/
              }
            }
            return;
          /*}}}*/
          /*{{{  specification .. VALOF*/
          case S_VALABBR: case S_ABBR:
          case S_VALRETYPE: case S_RETYPE:
          case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
          case S_TPROTDEF: case S_SPROTDEF:
          case S_DECL:
          case S_VALOF:
            {
              /* Save statics here, just in case we have valof within valof */
              treenode **savedvalofresult = valofresult;
              int savedvalofresultmode = valofresultmode;
              valofresult = result;
              valofresultmode = resultmode;
              mapdeclandbody(*opd, mapqvalof, FALSE, FALSE);
              valofresult = savedvalofresult;
              valofresultmode = savedvalofresultmode;
            }
            return;
          /*}}}*/
        }
    }
}
/*}}}*/
/*{{{  PRIVATE void maplopandassign (resultmode, result, leftmode, rightmode, opd)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  maplopandassign maps the evaluation of expression 'opd' into
 *                  doubgle length (resultmode, result).
 *                  The calling of this routine is such that we can always
 *                  generate into result.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void maplopandassign ( int resultmode , treenode **result , int leftmode , int rightmode , treenode **opd )
{
  int op = TagOf(*opd);
  SOURCEPOSN locn = LocnOf(*opd);
  int type = typeof(*opd);
  if (isreal(type))
    /*{{{  pick out special real cases*/
    switch(op)
      {
        default:
          break;  /* Fall out to other cases */
        /*{{{  ADD SUBTRACT MULT DIV REM*/
        case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV:
        case S_REM:
          /*{{{  COMMENT what the tree looks like*/
          /**********************  Start comment out ****************************
          @*
                  rem                    finstance
                /    \       =>         /       \
               e1    e2          real64rem      list
                                                /   \
                                              e1    list
                                                    /   \
                                                  e2    NULL
          *@
           **********************   End comment out  ****************************/
          /*}}}*/
          *opd = makedopfunction(*opd);
          maplopandassign(resultmode, result, P_EXP, P_EXP, opd);
          return;
        /*}}}*/
        /*{{{  NEG*/
        case S_NEG:
          {
            treenode *zeroopd = newconstexpnode(S_CONSTEXP, locn,
                                  newlitnode(littag(type), locn, NULL),
                                  ZERO32, ZERO32);
            *opd = newdopnode(S_SUBTRACT, locn, zeroopd, OpOf(*opd), type);
            maplopandassign(resultmode, result, leftmode, rightmode, opd);
          }
          return;
        /*}}}*/
        /*{{{  EXACT ROUND TRUNC*/
        case S_EXACT:
        case S_ROUND: case S_TRUNC:
        /* the destination is a double-length real */
          {
            treenode *source = OpOf(*opd);
            int sourcetype = typeof(source);
            int desttype = MOpTypeOf(*opd);
            if (sourcetype == S_INT) sourcetype = targetintsize;
            #if 0 /* this was done in trans */
            if (sourcetype == desttype)
              /*{{{  ignore null conversion*/
              {
                *opd = OpOf(*opd); /* Remove the conversion */
                mapmovelopd(resultmode, result, leftmode, opd);
              }
              /*}}}*/
            else
            #endif
              {
                if (sourcetype == S_INT16 && targetintsize == S_INT32)
                  /*{{{  convert to an INT32 first*/
                  {
                    source = newmopnode(S_EXACT, locn, source, S_INT32);
                    sourcetype = S_INT32;
                    SetOp(*opd, source);
                  }
                  /*}}}*/
                *opd = makeconversion(sourcetype, desttype, source, op);
                maplopandassign(resultmode, result, leftmode, rightmode, opd);
              }
          }
          return;
        /*}}}*/
      }
    /*}}}*/
  switch (op)
    /*{{{  cases*/
    {
      /*{{{  MULT DIV REM*/
      case S_MULT: case S_DIV: case S_REM:
        /* Make a function call up, recurse to map it */
        /*{{{  what the transformed tree looks like*/
        /*
             result
                .                            S_FINSTANCE
                 .             -\             /     \
               S_MULT          -/  N_STDLIBFUNCDEF   LIST
                /  \                      /         /   \
              left right               name       left  LIST
                                                       /   \
                                                    right  NULL
        
        */
        /*}}}*/
        *opd = makedopfunction(*opd);
        maplopandassign(resultmode, result, leftmode, rightmode, opd);
        break;
      /*}}}*/
      /*{{{  FINSTANCE*/
      case S_FINSTANCE:
        {
          treenode *instancedfn = INameOf(*opd);
          if (TagOf(INameOf(*opd)) == N_PREDEFFUNCTION)
            /*{{{  map the predef, or convert it to a library call*/
            {
              if (mappredef(*opd, newlistnode(S_LIST, locn, *result, NULL)))
                  break;  /* it was an inline function */
                }
            /*}}}*/
          instancedfn = INameOf(*opd);
          {
            treenode *paramlist = IParamListOf(*opd);
            int maketempresult = FALSE;
            /*{{{  see if result is aliassed in the function*/
            if ((resultmode == P_EXP) || (resultmode == P_PTR))
              {
                treenode *p = paramlist;
                if (isafreevarof(basedecl(*result), instancedfn))
                  maketempresult = TRUE;
                while (!maketempresult && !EndOfList(p))
                  {
                    if (isaddressable(ThisItem(p)) && usedin(*result, ThisItem(p)))
                      maketempresult = TRUE;
                    p = NextItem(p);
                  }
              }
            /*}}}*/
            if
              (maketempresult)
                /*{{{  generate fn. result to temporary, then after call move to result*/
                {
                  *opd = gettemp(*opd, NM_WORKSPACE);
                  maplopandassign(P_TEMP, opd, P_EXP, P_EXP, NDeclAddr(*opd));
                  mapmovelopd(resultmode, result, P_TEMP, opd);
                  freetemp(*opd);
                }
                /*}}}*/
              else
                /*{{{  generate fn. to result*/
                {
                  /*{{{  augment actual parameters*/
                  {
                    treenode *dest;
                    int old = switch_to_temp_workspace();
                    dest = newlistnode(S_LIST, 0, *result, NULL);
                    switch_to_prev_workspace(old);
                    paramlist = augmentparams(paramlist,
                                              FnParamsOf(NTypeOf(instancedfn)), dest);
                    SetIParamList(*opd, paramlist);
                  }
                  /*}}}*/
                  mapinstance(*opd);
                }
                /*}}}*/
          }
        }
        break;
      /*}}}*/
      /*{{{  ADD SUBTRACT PLUS MINUS TIMES BITAND BITOR XOR*/
      case S_ADD: case S_SUBTRACT:
      case S_PLUS: case S_MINUS:  case S_TIMES:
      case S_BITAND: case S_BITOR: case S_XOR:
        {
          treenode **left = LeftOpAddr(*opd),
                   **right = RightOpAddr(*opd);
          int leftaddressable = isaddressableopd(leftmode, *left) ||
                                isconstopd(leftmode, *left);
          int rightaddressable = isaddressableopd(rightmode, *right)  ||
                                 isconstopd(rightmode, *right);
          /*int swapped = FALSE;*/ /* never used - CON 8/2/91 */
          int freelefttemp = FALSE, freerighttemp = FALSE, freeresulttemp = FALSE;
      
          /*{{{  prepare the result*/
          resultmode = mappreparelopd(resultmode, result, &freeresulttemp);
          /*}}}*/
          /*{{{  set up left and right operands*/
          if (leftaddressable && rightaddressable)
            /*{{{  left and right addressable*/
            {
              leftmode = mappreparelopd(leftmode, left, &freelefttemp);
              rightmode = mappreparelopd(rightmode, right, &freerighttemp);
            }
            /*}}}*/
          else if (leftaddressable || rightaddressable)
            /*{{{  one side addressable, the other side not addressable*/
            {
              if (rightaddressable)
                /*{{{  swap left and right*/
                {
                  /* NOTE that we don't actually swap the stuff on the tree! */
                  treenode  **tempptr;
                  int tempmode;
                  tempptr = left; left = right; right = tempptr;
                  tempmode = leftmode; leftmode = rightmode; rightmode = tempmode;
                  /*swapped = TRUE;*/ /* never used */
                }
                /*}}}*/
            
              /* TIMES uses a cross-multiply, so we cannot generate the
                 result into either of the operands directly: if either
                 of the operands is the same location as the result, we
                 must generate into a temporary.
                 For the other operations, we can generate one operand into the result
                 provided the other operand does not use the result. */
              if (usedinopd(resultmode, *result, *left) ||
                   (crossoperator(op) && usedinopd(resultmode, *result, *right)))
                /*{{{  generate right into temporary*/
                {
                  *right = gettemp (*right, NM_WORKSPACE);
                  rightmode = P_TEMP;
                  freerighttemp = TRUE;
                  mapmovelopd(P_TEMP, right, P_EXP, NDeclAddr(*right));
                  upusecount (*right, 1);
                }
                /*}}}*/
              else
                /*{{{  generate right into result*/
                mapmovelopd(resultmode, result, rightmode, right);
                /*}}}*/
              leftmode = mappreparelopd(leftmode, left, &freelefttemp);
            }
            /*}}}*/
          else
            /*{{{  neither left nor right addressable*/
            {
              int usedinleft = usedinopd(resultmode, *result, *left),
                  usedinright = usedinopd(resultmode, *result, *right);
            
              if (usedinright && !usedinleft)
                /*{{{  swap left and right*/
                {
                  /* NOTE that we don't actually swap the stuff on the tree! */
                  treenode  **tempptr;
                  int tempmode;
                  tempptr = left; left = right; right = tempptr;
                  tempmode = leftmode; leftmode = rightmode; rightmode = tempmode;
                  /*swapped = TRUE;*/ /* never used */
                }
                /*}}}*/
            
              if (usedinleft || usedinright)
                /*{{{  generate right into temporary and left into result/temp*/
                {
                  /* bug 1150 - make sure that we map in the same order
                     as we code generate - CON 8/2/91 */
                  const int leftfirst = complexity(*left) <= complexity(*right);
                  if (!leftfirst) /* first do the right */
                    {
                      *right = gettemp(*right, NM_WORKSPACE);
                      rightmode = P_TEMP;
                      freerighttemp = TRUE;
                      mapmovelopd(P_TEMP, right, P_EXP, NDeclAddr(*right));
                    }

                  /* bug 1150 - if used in both, create two temporaries!
                     CON - 8/2/91 */
                  if (usedinleft && usedinright)
                    {
                      *left = gettemp(*left, NM_WORKSPACE);
                      leftmode = P_TEMP;
                      freelefttemp = TRUE;
                      mapmovelopd(P_TEMP, left, P_EXP, NDeclAddr(*left));
                    }
                  else /* generate left directly into result */
                    mapmovelopd(resultmode, result, leftmode, left);

                  if (leftfirst) /* now do the right */
                    {
                      *right = gettemp(*right, NM_WORKSPACE);
                      rightmode = P_TEMP;
                      freerighttemp = TRUE;
                      mapmovelopd(P_TEMP, right, P_EXP, NDeclAddr(*right));
                    }
                }
                /*}}}*/
              else
                /*{{{  generate most complex operand to result, least complex to temporary*/
                {
                  if (complexity(*right) > complexity(*left))
                    /*{{{  swap left and right*/
                    {
                      /* NOTE that we don't actually swap the stuff on the tree! */
                      treenode  **tempptr;
                      int tempmode;
                      tempptr = left; left = right; right = tempptr;
                      tempmode = leftmode; leftmode = rightmode; rightmode = tempmode;
                      /*swapped = TRUE;*/ /*never used */
                    }
                    /*}}}*/
                
                  /*{{{  generate left into result, right into temporary*/
                  {
                    mapmovelopd(resultmode, result, leftmode, left);
                    *right = gettemp(*right, NM_WORKSPACE);
                    rightmode = P_TEMP;
                    freerighttemp = TRUE;
                    mapmovelopd(P_TEMP, right, P_EXP, NDeclAddr(*right));
                  }
                  /*}}}*/
                }
                /*}}}*/
            }
            /*}}}*/
          /*}}}*/
          /*{{{  perform operation*/
          if (crossoperator(op))
            {
              if (issameopd(resultmode, *result, leftmode, *left) ||
                  issameopd(resultmode, *result, rightmode, *right))
                /*{{{  generate into a temporary, then move to result*/
                {
                  *opd = gettemp(*opd, NM_WORKSPACE);
                  upusecount (*opd, 2);
                }
                /*}}}*/
            }
          /* other operations need no further mapping */
          /*}}}*/
          /*{{{  free temporaries*/
          if (freelefttemp)   freetemp(*left);
          if (freerighttemp)  freetemp(*right);
          if (freeresulttemp) freetemp(*result);
          /*}}}*/
        }
        break;
      /*}}}*/
      /*{{{  BITNOT*/
      case S_BITNOT:
        {
          treenode **operand = OpAddr(*opd);
          int operandmode = leftmode;
          int freeresulttemp = FALSE, freeoperandtemp = FALSE;
          /*{{{  prepare the result*/
          resultmode = mappreparelopd(resultmode, result, &freeresulttemp);
          /*}}}*/
          if (isaddressableopd(operandmode, *operand))
            operandmode = mappreparelopd(operandmode, operand, &freeoperandtemp);
          else
            mapmovelopd(resultmode, result, operandmode, operand);
          /* perform the operation */
          /*{{{  free temporaries*/
          if (freeoperandtemp)
            freetemp(*operand);
          if (freeresulttemp)
            freetemp(*result);
          /*}}}*/
        }
        break;
      /*}}}*/
      /*{{{  NEG UMINUS*/
      case S_NEG:
      case S_UMINUS:
        {
          int type = MOpTypeOf(*opd);
          int tag = (op == S_NEG) ? S_SUBTRACT : S_MINUS;
          *opd = newdopnode(tag, locn, newconstant(0), OpOf(*opd), type);
          maplopandassign(resultmode, result, leftmode, rightmode, opd);
        }
        break;
      /*}}}*/
      /*{{{  LSHIFT RSHIFT*/
      case S_LSHIFT:
      case S_RSHIFT:
        {
          treenode **left = LeftOpAddr(*opd);
          int freeresulttemp = FALSE, freelefttemp = FALSE;
          /*{{{  prepare the result*/
          resultmode = mappreparelopd(resultmode, result, &freeresulttemp);
          /*}}}*/
          if (isaddressableopd(leftmode, *left) || isconstopd(leftmode, *left))
            leftmode = mappreparelopd(leftmode, left, &freelefttemp);
          else
            mapmovelopd(resultmode, result, leftmode, left);
          mapexpopd(rightmode, RightOpAddr(*opd));
          /* perform the operation */
          /*{{{  free temporaries*/
          if (freelefttemp)
            freetemp(*left);
          if (freeresulttemp)
            freetemp(*result);
          /*}}}*/
        }
        break;
      /*}}}*/
      /*{{{  EXACT*/
      case S_EXACT:
        {
          treenode **operand = OpAddr(*opd);
          int sourcetype = typeof(*operand);
          int desttype = MOpTypeOf(*opd);
          int freeresulttemp = FALSE;
          #if 0 /* this was done in trans */
          if (sourcetype == desttype)  /* null conversion */
            /*{{{  ignore null conversion*/
            {
              *opd = OpOf(*opd); /* Remove the conversion */
              mapmovelopd(resultmode, result, leftmode, opd);
            }
            /*}}}*/
          else
          #endif
          if (fitsinregister(sourcetype))
            {
              /*{{{  prepare the result*/
              resultmode = mappreparelopd(resultmode, result, &freeresulttemp);
              /*}}}*/
              mapexpopd(leftmode, operand);
              /* xdble */
              /*{{{  free temporaries*/
              if (freeresulttemp)
                freetemp(*result);
              /*}}}*/
            }
          else if (isquadlength(sourcetype))
            /*{{{  convert to a function call*/
            {
              *opd = makeconversion(sourcetype, desttype, *operand, op);
              maplopandassign(resultmode, result, P_EXP, P_EXP, opd);
            }
            /*}}}*/
          else
            badtag(genlocn, op, "maplopandassign");
        }
        break;
      /*}}}*/
      /*{{{  ROUND TRUNC*/
      case S_ROUND: case S_TRUNC:
        /* The destination type is a double-length integer */
        {
          treenode *source = OpOf(*opd);
          int sourcetype = typeof(source);
          int desttype = MOpTypeOf(*opd);
          #if 0 /* we've done this in trans */
          if (sourcetype == desttype)
            /*{{{  null conversion*/
            {
              *opd = OpOf(*opd); /* Remove the conversion */
              mapmovelopd(resultmode, result, leftmode, opd);
            }
            /*}}}*/
          #endif
          if (fpinline && isreal(sourcetype))
            {
            #if 0 /* This breaks when rhs is complicated: bug 739 24/9/90 */
              mapfpexp(OpAddr(*opd));
              resultmode = ptrmodeof(resultmode);
              mapexpopd(resultmode, result);
            #else
              int freeresulttemp = FALSE;
              resultmode = mappreparelopd(resultmode, result, &freeresulttemp);
              mapfpexp(OpAddr(*opd));
              if (freeresulttemp)
                freetemp(*result);
            #endif
            }
          else
            {
              *opd = makeconversion(sourcetype, desttype, source, op);
              maplopandassign(resultmode, result, leftmode, rightmode, opd);
            }
        }
        break;
      /*}}}*/
      /*{{{  specification .. VALOF*/
      case S_VALABBR: case S_ABBR:
      case S_VALRETYPE: case S_RETYPE:
      case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
      case S_TPROTDEF: case S_SPROTDEF:
      case S_DECL:
      case S_VALOF:
        {
          /* Save statics here, just in case we have valof within valof */
          treenode **savedvalofresult = valofresult;
          int savedvalofresultmode = valofresultmode;
          valofresult = result;
          valofresultmode = resultmode;
          mapdeclandbody(*opd, maplvalof, FALSE, FALSE);
          valofresult = savedvalofresult;
          valofresultmode = savedvalofresultmode;
        }
        break;
      /*}}}*/
      default:
        badtag(genlocn, op, "maplopandassign");
    }
    /*}}}*/
}
/*}}}*/
/*}}}*/
/*{{{  private generating routines*/
/*{{{  PRIVATE int preparelopd (opdmode, opd)*/
/*****************************************************************************
 *
 *  preparelopd generates any neccessary preparation code for (opdmode, opd)
 *              ie. loads a pointer to it into a temp.
 *
 *****************************************************************************/
PRIVATE int preparelopd ( int opdmode , treenode *opd )
{
  if (preeval(opdmode, opd))
    {
      loadelementpointer(NDeclOf(opd), 0, MANY_REGS);
      storeinname(opd, 0);
      opdmode = tempmodeof(opdmode);
    }
  return(opdmode);
}
/*}}}*/
/*{{{  PRIVATE void evallopd (opdmodevar, opdvar, destmode, dest)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  evallopd evaluates (*opdmodevar, *opdvar) either to a temporary or to
 *           (destmode, dest).
 *           A bit untidy because we get (destmode, dest) as parameters
 *           whether we need them or not.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void evallopd ( int *opdmodevar , treenode **opdvar , int destmode , treenode *dest )
{
  /*{{{  facetious comment*/
  /* In a sensible language, opdmode and opd would be var. parameters,
     here we have to pass them via pointers.
     To make the code more legible, we load them into locals on entry, and
     write them out again on exit */
  /*}}}*/
  int opdmode = *opdmodevar;
  treenode *opd = *opdvar;

  if (preeval(opdmode, opd))
    /*{{{  generate to a temporary*/
    {
      movelopd(P_TEMP, opd, opdmode, NDeclOf(opd));
      opdmode = P_TEMP;
    }
    /*}}}*/
  else
    /*{{{  generate to (destmode, dest)*/
    {
      if (dest == NULL)
        geninternal_is(GEN_BAD_OPD, destmode, "evallopd");
      movelopd(destmode, dest, opdmode, opd);
      opdmode = destmode;
      opd = dest;
    }
    /*}}}*/

  *opdmodevar = opdmode;
  *opdvar = opd;
}
/*}}}*/
/*{{{  PRIVATE void tlopandassign (resultmode, result, leftmode, rightmode, opd)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  tlopandassign generates code to evaluate opd and store it in
 *              double length (resultmode, result).
 *              opd is a non-addressable expression
 *              The calling of this function is such that we can always
 *              generate into result.
 *
 *****************************************************************************/
/*}}}*/
PRIVATE void tlopandassign ( int resultmode , treenode *result , int leftmode , int rightmode , treenode *opd )
{
  int op = TagOf(opd);
  /*{{{  print expression*/
  if (diagnostics)
    commentexp(opd);
  /*}}}*/
  switch (op)
    {
      /*{{{  ADD SUBTRACT PLUS MINUS TIMES BITAND BITOR XOR*/
      case S_ADD:    case S_SUBTRACT:
      case S_PLUS:   case S_MINUS:    case S_TIMES:
      case S_BITAND: case S_BITOR:    case S_XOR:
        {
          treenode *left = LeftOpOf(opd),
                   *right = RightOpOf(opd);
          int leftaddressable = isaddressableopd(leftmode, left) ||
                                isconstopd(leftmode, left);
          int rightaddressable = isaddressableopd(rightmode, right) ||
                                 isconstopd(rightmode, right);
      
          /*{{{  prepare the result*/
          resultmode = preparelopd(resultmode, result);
          /*}}}*/
          /*{{{  prepare left and right*/
          if (leftaddressable && rightaddressable)
            /*{{{  both addressable*/
            {
              leftmode = preparelopd(leftmode, left);
              rightmode = preparelopd(rightmode, right);
            }
            /*}}}*/
          else if (leftaddressable)
            /*{{{  left addressable, right not addressable*/
            {
              evallopd(&rightmode, &right, resultmode, result);
              leftmode = preparelopd(leftmode, left);
            }
            /*}}}*/
          else if (rightaddressable)
            /*{{{  right addressable, left not addressable*/
            {
              evallopd(&leftmode, &left, resultmode, result);
              rightmode = preparelopd(rightmode, right);
            }
            /*}}}*/
          else
            /*{{{  neither addressable*/
            {
              /* The mapper may have inserted a temporary on the rhs
                 to force evaluation before the lhs, because of
                 the destination variable being used in the lhs.
                 This bug fix ensures that the rhs is generated first in
                 such a case. - CON bug 1150 8/2/91 */
              /* NO - this breaks other things. We have to stop trying
                 to be so bloody clever, and simply insert a temporary on
                 both sides - CON 8/2/91 */
              if ((complexity(right) > complexity(left))
                  /*|| preeval(rightmode, right)*/)  /* bug 1150 8/2/91 */
                /*{{{  generate right, then left*/
                {
                  evallopd(&rightmode, &right, resultmode, result);
                  evallopd(&leftmode, &left, resultmode, result);
                }
                /*}}}*/
              else
                /*{{{  generate left, then right*/
                {
                  evallopd(&leftmode, &left, resultmode, result);
                  evallopd(&rightmode, &right, resultmode, result);
                }
                /*}}}*/
            }
            /*}}}*/
          /*}}}*/
      
          /*{{{  generate code for this operator*/
          switch (op)
            {
              /*{{{  ADD SUBTRACT PLUS MINUS*/
              case S_ADD: case S_SUBTRACT: case S_PLUS: case S_MINUS:
                {
                  int ilow, ihigh;
                  if (op == S_ADD)           { ilow = I_LSUM;  ihigh = I_LADD;  }
                  else if (op == S_SUBTRACT) { ilow = I_LDIFF; ihigh = I_LSUB;  }
                  else if (op == S_PLUS)     { ilow = I_LSUM;  ihigh = I_LSUM;  }
                  else /* op == S_MINUS */   { ilow = I_LDIFF; ihigh = I_LDIFF; }
                  gendoubleaddop(resultmode, result, leftmode, left, rightmode, right,
                                 ilow, ihigh);
                }
                break;
              /*}}}*/
              /*{{{  TIMES*/
              case S_TIMES:
                /*{{{  perform a cross-multiply*/
                {
                  int lconst = isconstopd(leftmode, left),
                      rconst = isconstopd(rightmode, right);
                
                  INT32 leftlowval   = lconst ? wordof(left, 0)  : 100,
                        lefthighval  = lconst ? wordof(left, 1)  : 100,
                        rightlowval  = rconst ? wordof(right, 0) : 100,
                        righthighval = rconst ? wordof(right, 1) : 100;
                
                  int zerocarry = TRUE;
                
                  genprimary (I_LDC, 0);                                 /* ldc  0         */
                  /*{{{  ld rightlow; ld leftlow; lmul; st resultlow*/
                  if ((leftlowval == ZERO32) || (rightlowval == ZERO32))
                    /*{{{  optimise*/
                    genprimary (I_LDC, 0);                               /* ldc  0         */
                    /*}}}*/
                  else if (leftlowval == ONE32)
                    /*{{{  optimise*/
                    loadopd(rightmode, right, 0);                       /* ld   rightlow  */
                    /*}}}*/
                  else if (rightlowval == ONE32)
                    /*{{{  optimise*/
                    loadopd(leftmode, left, 0);                         /* ld   leftlow   */
                    /*}}}*/
                  else
                    /*{{{  basic code*/
                    {
                      loadopd(rightmode, right, 0);                     /* ld   rightlow  */
                      loadopd(leftmode, left, 0);                       /* ld   leftlow   */
                      gensecondary(I_LMUL);                             /* lmul           */
                      zerocarry = FALSE;
                    }
                    /*}}}*/
                  storeinopd (resultmode, result, 0, MAXREGS - 2);       /* st   resultlow */
                  /*}}}*/
                  /*{{{  ld rightlow; ld lefthigh; lmul*/
                  if ((lefthighval == ZERO32) || (rightlowval == ZERO32))
                    /*{{{  optimise*/
                    ; /* No code at all, use existing carry */
                    /*}}}*/
                  else if (zerocarry && (lefthighval == ONE32))
                    /*{{{  optimise*/
                    loadopd(rightmode, right, 0);                       /* ld   rightlow  */
                    /*}}}*/
                  else if (zerocarry && (rightlowval == ONE32))
                    /*{{{  optimise*/
                    loadopd(leftmode, left, 1);                         /* ld   lefthigh  */
                    /*}}}*/
                  else
                    /*{{{  basic code*/
                    {
                      loadopd(rightmode, right, 0);                     /* ld   rightlow  */
                      loadopd(leftmode, left, 1);                       /* ld   lefthigh  */
                      gensecondary(I_LMUL);                             /* lmul           */
                      zerocarry = FALSE;
                    }
                    /*}}}*/
                  /*}}}*/
                  /*{{{  ld righthigh; ld leftlow; lmul*/
                  if ((leftlowval == ZERO32) || (righthighval == ZERO32))
                    /*{{{  optimise*/
                    ; /* No code at all, use existing carry */
                    /*}}}*/
                  else if (zerocarry && (leftlowval == ONE32))
                    /*{{{  optimise*/
                    loadopd(rightmode, right, 1);                       /* ld   righthigh */
                    /*}}}*/
                  else if (zerocarry && (righthighval == ONE32))
                    /*{{{  optimise*/
                    loadopd(leftmode, left, 0);                         /* ld   leftlow   */
                    /*}}}*/
                  else
                    /*{{{  basic code*/
                    {
                      loadopd(rightmode, right, 1);                     /* ld   righthigh */
                      loadopd(leftmode, left, 0);                       /* ld   leftlow   */
                      gensecondary(I_LMUL);                             /* lmul           */
                    }
                    /*}}}*/
                  /*}}}*/
                  storeinopd (resultmode, result, 1, MAXREGS - 1);       /* st   resulthigh */
                }
                /*}}}*/
                break;
              /*}}}*/
              /*{{{  BITAND BITOR XOR*/
              case S_BITAND:
              case S_BITOR:
              case S_XOR:
                {
                  INT32 identityval = (op == S_BITAND) ? (-1)   : ZERO32;
                  INT32 zeroval =     (op == S_BITAND) ? ZERO32 : (-1);
                  int iop =           (op == S_BITAND) ? I_AND  :
                                      (op == S_BITOR)  ? I_OR   : I_XOR;
                  int lconst = isconstopd(leftmode, left),
                      rconst = isconstopd(rightmode, right);
              
                  /*{{{  ld leftlow; ld rightlow; and; st resultlow*/
                  {
                    INT32 leftlowval =  lconst ? wordof(left, 0)  : 100,
                          rightlowval = rconst ? wordof(right, 0) : 100;
                  
                    if ((op != S_XOR) && (leftlowval == zeroval || rightlowval == zeroval))
                      /*{{{  optimise*/
                      loadconstant(zeroval);
                      /*}}}*/
                    else if (leftlowval == identityval)
                      /*{{{  optimise*/
                      loadopd(rightmode, right, 0);                       /* ld   rightlow  */
                      /*}}}*/
                    else if (rightlowval == identityval)
                      /*{{{  optimise*/
                      loadopd(leftmode, left, 0);                         /* ld   leftlow   */
                      /*}}}*/
                    else
                      /*{{{  basic code*/
                      {
                        loadopd(leftmode, left, 0);                      /* ld   leftlow   */
                        loadopd(rightmode, right, 0);                    /* ld   rightlow  */
                        gensecondary(iop);                               /* and/or         */
                      }
                      /*}}}*/
                    storeinopd(resultmode, result, 0, MAXREGS - 1);          /* st   resultlow */
                  }
                  /*}}}*/
                  /*{{{  ld lefthigh; ld righthigh; and; st resulthigh*/
                  {
                    INT32 lefthighval =  lconst ? wordof(left, 1)  : 100,
                          righthighval = rconst ? wordof(right, 1) : 100;
                  
                    if ((op != S_XOR) && (lefthighval == zeroval) || (righthighval == zeroval))
                      /*{{{  optimise*/
                      loadconstant(zeroval);
                      /*}}}*/
                    else if (lefthighval == identityval)
                      /*{{{  optimise*/
                      loadopd(rightmode, right, 1);                       /* ld   righthigh */
                      /*}}}*/
                    else if (righthighval == identityval)
                      /*{{{  optimise*/
                      loadopd(leftmode, left, 1);                         /* ld   lefthigh  */
                      /*}}}*/
                    else
                      /*{{{  basic code*/
                      {
                        loadopd(leftmode, left, 1);                      /* ld   lefthigh  */
                        loadopd(rightmode, right, 1);                    /* ld   righthigh */
                        gensecondary(iop);                               /* and/or         */
                      }
                      /*}}}*/
                    storeinopd(resultmode, result, 1, MAXREGS - 1);       /* st   resulthigh */
                  }
                  /*}}}*/
                }
                break;
              /*}}}*/
            }
          /*}}}*/
        }
        break;
      /*}}}*/
      /*{{{  BITNOT*/
      case S_BITNOT:
        {
          treenode *operand = OpOf(opd);
          int operandmode = leftmode;
      
          /*{{{  prepare the result*/
          resultmode = preparelopd(resultmode, result);
          /*}}}*/
          if (isaddressableopd(operandmode, operand))
            operandmode = preparelopd(operandmode, operand);
          else
            evallopd(&operandmode, &operand, resultmode, result);
          loadopd(operandmode, operand, 0);
          gensecondary(I_NOT);
          storeinopd(resultmode, result, 0, MAXREGS - 1);
          loadopd(operandmode, operand, 1);
          gensecondary(I_NOT);
          storeinopd(resultmode, result, 1, MAXREGS - 1);
        }
        break;
      /*}}}*/
      /*{{{  LSHIFT RSHIFT*/
      case S_LSHIFT:
      case S_RSHIFT:
        {
          treenode *left = LeftOpOf(opd),
                   *right = RightOpOf(opd);
      
          resultmode = preparelopd(resultmode, result);
      
          /*{{{  set up left*/
          if (isaddressableopd(leftmode, left))
            leftmode = preparelopd(leftmode, left);
          else if (!isconstopd(leftmode, left))
            evallopd(&leftmode, &left, resultmode, result);
          /*}}}*/
      
          /*{{{  ld lefthigh; ld leftlow; ld count*/
          if (regsfor(right) > 2)
            /*{{{  load count first*/
            {
              texp(right, MANY_REGS);                           /* ld   count     */
              loadopd(leftmode, left, 1);                       /* ld   lefthigh  */
              gensecondary(I_REV);                              /* rev            */
              loadopd(leftmode, left, 0);                       /* ld   leftlow   */
              gensecondary(I_REV);                              /* rev            */
            }
            /*}}}*/
          else if (regsfor(right) > 1)
            /*{{{  load count second*/
            {
              loadopd(leftmode, left, 1);                       /* ld   lefthigh  */
              texp(right, MAXREGS - 1);                         /* ld   count     */
              loadopd(leftmode, left, 0);                       /* ld   leftlow   */
              gensecondary(I_REV);                              /* rev            */
            }
            /*}}}*/
          else
            /*{{{  load count last*/
            {
              loadopd(leftmode, left, 1);                       /* ld   lefthigh  */
              loadopd(leftmode, left, 0);                       /* ld   leftlow   */
              texp(right, MAXREGS - 2);                         /* ld   count     */
            }
            /*}}}*/
          /*}}}*/
      
          gensecondary(op == S_LSHIFT ? I_LSHL : I_LSHR);       /* lshl/lshr       */
      
          storeinopd(resultmode, result, 0, MAXREGS - 2);       /* st   resultlow  */
          storeinopd(resultmode, result, 1, MAXREGS - 1);       /* st   resulthigh */
        }
        break;
      /*}}}*/
      /*{{{  EXACT*/
      case S_EXACT:
        {
          treenode *right = OpOf(opd);
          int sourcetype = typeof(right);
          if (fitsinregister(sourcetype))
            /*{{{  BOOL/BYTE/short INT/INT  to double-length*/
            {
              resultmode = preparelopd(resultmode, result);
              texp(right, MANY_REGS);
              if (hasgreaterrange(S_INT, sourcetype) && issignedtype(sourcetype))
                /*{{{  extend to full word*/
                {
                  if (H1_instr)
                    gensecondary(I_XSWORD);
                  else
                    {
                      loadconstant(typemask(sourcetype));
                      gensecondary(I_AND);
                      loadconstant(checkmask(sourcetype));
                      gensecondary(I_XWORD);
                    }
                }
                /*}}}*/
              gensecondary(I_XDBLE);
              storeinopd(resultmode, result, 0, MAXREGS - 2);
              storeinopd(resultmode, result, 1, MAXREGS - 1);
            }
            /*}}}*/
          else if (isdoublelength(sourcetype))
            ; /* We are there already */
          else
            /* quad-length to double-length done by function call
               real to int either done by function call or not supported */
            badtag(genlocn, S_EXACT, "tlopandassign");
        }
        break;
      /*}}}*/
      /*{{{  ROUND TRUNC*/
      /* We must be on an fp processor and source must be real,
         otherwise these conversions would have been turned into function calls */
      case S_ROUND: case S_TRUNC:
        {
          int simple;
          resultmode = preparelopd(resultmode, result); /* added 24/9/90 for bug 739 */
          simple = issimplelocal(result); /* bug 738 5/11/90 */
          tfpexp(OpOf(opd), MANY_REGS, MANY_REGS);         /*        source       */
          if (op == S_TRUNC)
            {
              if (H1_instr) gensecondary(I_FPRZ);          /*        (fprz)       */
              else          genfpuentry(I_FPURZ);
            }
          gensecondary(I_FPINT);                           /*        fpint        */
          if (CONVERSIONCHECKING)
            {
              if (H1_instr) gensecondary(I_FPCHKI64);      /*        (fpchki64)   */
              else          genfpuentry(I_FPUCHKI64);
            }
          resultmode = ptrmodeof(resultmode);
          loadopd(resultmode, result, 0);                  /*        ldp   result */
          gensecondary(I_FPDUP);                           /*        fpdup        */
          if (!simple) gensecondary(I_DUP);                /*        dup          */
          checkerror ();
          gensecondary(I_FPSTNLI32);                       /*        fpstnli32    */
          if (H1_instr) gensecondary(I_FPEXPDEC32);        /*        fpexpdec32   */
          else          genfpuentry(I_FPUEXPDEC32);
          mark_flag_clean(TRUE); /* so we don't do another fpchkerr */
          if (simple)
            loadopd(resultmode, result, 1);                /*        ldp result+1  */
          else
            genprimary(I_LDNLP, ONE32);                    /*        ldnlp 1      */
          gensecondary(I_FPSTNLI32);                       /*        fpstnli32    */
        }
        break;
      /*}}}*/
      /*{{{  FINSTANCE*/
      case S_FINSTANCE:
        tinstance(opd);
        break;
      /*}}}*/
      /*{{{  specification .. VALOF*/
      case S_VALABBR: case S_ABBR:
      case S_VALRETYPE: case S_RETYPE:
      case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
      case S_TPROTDEF: case S_SPROTDEF:
      case S_DECL:
      case S_VALOF:
        {
          treenode *resultexp;
          opd = tspecs(opd);
          resultexp = ThisItem(VLResultListOf(opd));
          tprocess(VLBodyOf(opd));
          tpreexp(resultexp);
          movelopd(resultmode, result, P_EXP, resultexp);
        }
        break;
      /*}}}*/
      default:
        badtag(genlocn, op, "tlopandassign");
    }
}
/*}}}*/
/*}}}*/
/*}}}*/

/*{{{  public*/
/*{{{  PUBLIC void mapmovelopd (destmode, dest, sourcemode, source)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  mapmovelopd maps the move of the double length expression
 *              (sourcemode, source) to the double length variable
 *              (destmode, dest)
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void mapmovelopd ( int destmode , treenode **dest , int sourcemode , treenode **source )
{
  DEBUG_MSG(("mapmovelopd: destmode = %d, sourcemode = %d\n", destmode, sourcemode));
  if (isaddressableopd(sourcemode, *source) || isconstopd(sourcemode, *source))
    {
      int freesourcetemp = FALSE, freedesttemp = FALSE;
      DEBUG_MSG(("mapmovelopd: source is addressable or const\n"));
      sourcemode = mappreparelopd(sourcemode, source, &freesourcetemp);
      destmode   = mappreparelopd(destmode, dest, &freedesttemp);
      /* perform the move */
      /*{{{  free temporaries*/
      if (freesourcetemp)
        freetemp(*source);
      if (freedesttemp)
        freetemp(*dest);
      /*}}}*/
    }
  else
    {
      DEBUG_MSG(("mapmovelopd: source is NOT addressable or const\n"));
      maplopandassign(destmode, dest, P_EXP, P_EXP, source);
    }
}
/*}}}*/
/*{{{  PUBLIC void movelopd (destmode, dest, sourcemode, source)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  movelopd generates code to move the double length expression
 *           (sourcemode, source) to the double length variable
 *           (destmode, dest)
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void movelopd ( int destmode , treenode *dest , int sourcemode , treenode *source )
{
  if (isaddressableopd(sourcemode, source) || isconstopd(sourcemode, source))
    {
      sourcemode = preparelopd(sourcemode, source);
      destmode = preparelopd(destmode, dest);
      loadopd(sourcemode, source, 0);
      storeinopd(destmode, dest, 0, MAXREGS - 1);
      loadopd(sourcemode, source, 1);
      storeinopd(destmode, dest, 1, MAXREGS - 1);
    }
  else if (preeval(sourcemode, source))
    {
      tlopandassign(P_TEMP, source, P_EXP, P_EXP, NDeclOf(source));
      movelopd(destmode, dest, P_TEMP, source);
    }
  else
    tlopandassign(destmode, dest, P_EXP, P_EXP, source);
  checkerror ();
}
/*}}}*/
/*{{{  PUBLIC void trellop(op, type, left, right, sense, genbool)   double-length*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  trellop generates code for relational operator 'op' into Areg, using at
 *          most 'regs' registers.
 *          If 'genbool' is TRUE, a strictly Boolean result is left in Areg.
 *          If 'sense' is FALSE, the result is inverted.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void trellop ( int op , int type , treenode *left , treenode *right , int sense , int genbool )
{
  const int leftaddressable  = isaddressable(left)  || isconst(left);
  const int rightaddressable = isaddressable(right) || isconst(right);
  int leftmode = P_EXP, rightmode = P_EXP;
  int dummy; dummy = type; /* stop unused variable warning */

  /*{{{  prepare left and right*/
  if (leftaddressable && rightaddressable)
    /*{{{  both addressable*/
    {
      leftmode = preparelopd(leftmode, left);
      rightmode = preparelopd(rightmode, right);
    }
    /*}}}*/
  else if (leftaddressable)
    /*{{{  left addressable, right not addressable*/
    {
      evallopd(&rightmode, &right, P_EXP, NULL);
      leftmode = preparelopd(leftmode, left);
    }
    /*}}}*/
  else if (rightaddressable)
    /*{{{  right addressable, left not addressable*/
    {
      evallopd(&leftmode, &left, P_EXP, NULL);
      rightmode = preparelopd(rightmode, right);
    }
    /*}}}*/
  else
    /*{{{  neither addressable*/
    {
      if (complexity(right) > complexity(left))
        /*{{{  generate right, then left*/
        {
          evallopd(&rightmode, &right, P_EXP, NULL);
          evallopd(&leftmode, &left, P_EXP, NULL);
        }
        /*}}}*/
      else
        /*{{{  generate left, then right*/
        {
          evallopd(&leftmode, &left, P_EXP, NULL);
          evallopd(&rightmode, &right, P_EXP, NULL);
        }
        /*}}}*/
    }
    /*}}}*/
  /*}}}*/
  switch (op)
    {
      /*{{{  S_EQ*/
      case S_EQ:
        /*{{{  double length INT*/
        {
          if (TagOf(right) == S_CONSTEXP)
            /*{{{  swap left and right*/
            {
              treenode *temp = left;
              left = right; right = temp;
            }
            /*}}}*/
        
          if (TagOf(left) == S_CONSTEXP)
            /*{{{  test against constant*/
            {
              /*{{{  do lower half*/
              loadopd(rightmode, right, 0);
              if (wordof(left, 0) != ZERO32)
                {
                  loadconstant(wordof(left, 0));
                  gensecondary(I_DIFF);
                }
              /*}}}*/
              /*{{{  do upper half*/
              loadopd(rightmode, right, 1);
              if (wordof(left, 1) != ZERO32)
                {
                  loadconstant(wordof(left, 1));
                  gensecondary(I_DIFF);
                }
              /*}}}*/
            
              gensecondary(I_OR);
            }
            /*}}}*/
          else
            /*{{{  leftlo; rightlo; diff; lefthi; righthi; diff; or*/
            {
              leftmode = preparelopd(leftmode, left);
              rightmode = preparelopd(rightmode, right);
            
              loadopd(leftmode, left, 0);
              loadopd(rightmode, right, 0);
              gensecondary(I_DIFF);
              loadopd(leftmode, left, 1);
              loadopd(rightmode, right, 1);
              gensecondary(I_DIFF);
              gensecondary(I_OR);
            }
            /*}}}*/
        
          if (!sense)
            /*{{{  we already have !sense - do we convert to Boolean?*/
            {
              if (genbool)  /* Result must be a genuine Boolean */
                {
                  genprimary(I_EQC, ZERO32);
                  genprimary(I_EQC, ZERO32);
                }
            }
            /*}}}*/
          else
            genprimary(I_EQC, ZERO32);
        }
        /*}}}*/
        break;
      /*}}}*/
      /*{{{  S_GR*/
      case S_GR:
        /*{{{  double length INT*/
        {
          int leftconst =  (TagOf(left) == S_CONSTEXP),
              rightconst = (TagOf(right) == S_CONSTEXP);
        
          if (leftconst && (wordof(left, 0) == ZERO32) && (wordof(left, 1) == ZERO32))
            /*{{{  optimise 0 > right to   ldc 0; righthi; gt*/
            {
              loadconstant(ZERO32);                          /*          ldc   0         */
              loadopd(rightmode, right, 1);                  /*          ld    righthi   */
              gensecondary(I_GT);                            /*          gt              */
              if (!sense)
                genprimary(I_EQC, ZERO32);                   /*          eqc   0         */
            }
            /*}}}*/
          else
            /*{{{  standard code*/
            {
              int label1 = newlab(), label2 = newlab();
            
              /*{{{  lefthi; righthi; gt; eqc 0; cj label1*/
              loadopd(leftmode, left, 1);                    /*          ld    lefthi    */
              loadopd(rightmode, right, 1);                  /*          ld    righthi   */
              gensecondary(I_GT);                            /*          gt              */
              genprimary(I_EQC, ZERO32);                     /*          cj    label1    */
              genbranch(I_CJ, label1);
              /*}}}*/
            
              /*{{{  lefthi; righthi; diff; eqc 0; cj label2*/
              if (leftconst && (wordof(left, 1) == ZERO32))
                /*{{{  righthi*/
                loadopd(rightmode, right, 1);                /*          ld    righthi   */
                /*}}}*/
              else
                /*{{{  lefthi; righthi; diff*/
                {
                  loadopd(leftmode, left, 1);                /*          ld    lefthi    */
                  if (rightconst && (wordof(right, 1) == ZERO32))
                    ; /* No need to diff with right */
                  else
                    /*{{{  righthi; diff*/
                    {
                      loadopd(rightmode, right, 1);          /*          ld    righthi   */
                      gensecondary(I_DIFF);                  /*          diff            */
                    }
                    /*}}}*/
                }
                /*}}}*/
              genprimary(I_EQC, ZERO32);                     /*          eqc   0         */
              genbranch(I_CJ, label2);                       /*          cj    label2    */
              /*}}}*/
            
              /*{{{  leftlo; mint; xor; rightlo; mint; xor; gt*/
              {
                BIT32 mint = (targetintsize == S_INT16) ? MOSTNEG_INT16 : MOSTNEG_INT32;
                if (leftconst)
                  loadconstant(wordof(left, 0) ^ mint);     /*        ldc   leflo xor mint */
                else
                  {
                    loadopd(leftmode, left, 0);             /*        ld    leftlo         */
                    gensecondary(I_MINT);                   /*        mint                 */
                    gensecondary(I_XOR);                    /*        xor                  */
                  }
              
                if (rightconst)
                  loadconstant(wordof(right, 0) ^ mint);    /*        ldc rightlo xor mint */
                else
                  {
                    loadopd(rightmode, right, 0);           /*          ld    rightlo      */
                    gensecondary(I_MINT);                   /*          mint               */
                    gensecondary(I_XOR);                    /*          xor                */
                  }
                gensecondary(I_GT);
              }
              /*}}}*/
            
              if (!sense)
                /*{{{  label2: eqc 0; label1:*/
                {
                  setlab(label2);
                  genprimary(I_EQC, ZERO32);
                  setlab(label1);
                }
                /*}}}*/
              else
                /*{{{  eqc 0; label1: eqc 0; label2:*/
                {
                  genprimary(I_EQC, ZERO32);
                  setlab(label1);
                  genprimary(I_EQC, ZERO32);
                  setlab(label2);
                }
                /*}}}*/
            }
            
            /*}}}*/
        }
        /*}}}*/
        break;
      /*}}}*/
      default:
        geninternal_is(GEN_ERROR_IN_ROUTINE, 2, "trellop");
    }
  checkerror();
}
/*}}}*/
/*{{{  PUBLIC void maprellop(op, type, left, right)                 double-length*/
/*****************************************************************************
 *
 *  maprellop maps workspace for generating relational operator 'op'
 *            of left and right into Areg.
 *
 *****************************************************************************/
PUBLIC void maprellop ( int op , int type , treenode **left , treenode **right )
{
  int leftaddressable = isaddressable(*left) || isconst(*left);
  int rightaddressable = isaddressable(*right)  || isconst(*right);
  int freelefttemp = FALSE, freerighttemp = FALSE;
  int leftmode = P_EXP, rightmode = P_EXP;
  int dummy; dummy = type; dummy = op; /* stop unused variable warnings */

  /*{{{  set up left and right operands*/
  if (leftaddressable && rightaddressable)
    /*{{{  left and right addressable*/
    {
      leftmode = mappreparelopd(leftmode, left, &freelefttemp);
      rightmode = mappreparelopd(rightmode, right, &freerighttemp);
    }
    /*}}}*/
  else if (leftaddressable || rightaddressable)
    /*{{{  one side addressable, the other side not addressable*/
    {
      if (rightaddressable)
        /*{{{  swap left and right*/
        {
          treenode  **tempptr;
          int tempmode;
          tempptr = left; left = right; right = tempptr;
          tempmode = leftmode; leftmode = rightmode; rightmode = tempmode;
        }
        /*}}}*/
    
      /*{{{  generate right into temporary*/
      {
        *right = gettemp(*right, NM_WORKSPACE);
        rightmode = P_TEMP;
        freerighttemp = TRUE;
        mapmovelopd(P_TEMP, right, P_EXP, NDeclAddr(*right));
      }
      /*}}}*/
      leftmode = mappreparelopd(leftmode, left, &freelefttemp);
    }
    /*}}}*/
  else
    /*{{{  neither left nor right addressable*/
    {
      /* Make left the most complex side */
      if (complexity(*left) < complexity(*right))
        {
          treenode  **tempptr;
          int tempmode;
          tempptr = left; left = right; right = tempptr;
          tempmode = leftmode; leftmode = rightmode; rightmode = tempmode;
        }
    
      *left = gettemp(*left, NM_WORKSPACE);
      rightmode = P_TEMP;
      freelefttemp = TRUE;
      mapmovelopd(P_TEMP, left, P_EXP, NDeclAddr(*left));
    
      *right = gettemp(*right, NM_WORKSPACE);
      rightmode = P_TEMP;
      freerighttemp = TRUE;
      mapmovelopd(P_TEMP, right, P_EXP, NDeclAddr(*right));
    }
    /*}}}*/
  /*}}}*/
  /* perform the operation */
  /*{{{  free temporaries*/
  if (freelefttemp)
    freetemp(*left);
  if (freerighttemp)
    freetemp(*right);
  /*}}}*/
}
/*}}}*/
/*{{{  PUBLIC int addresslopd (opdmode, opd)*/
/*****************************************************************************
 *
 *  addresslopd takes the long operand (opdmode, opd), makes it addressable
 *              and returns the new opdmode.
 *
 *****************************************************************************/
PUBLIC int addresslopd ( int opdmode , treenode *opd )
{
  if (isaddressableopd(opdmode, opd))
    /* Make a pointer to it if necessary */
    opdmode = preparelopd(opdmode, opd);
  else if (!isconstopd(opdmode, opd))
    /* Generate it into a temporary */
    evallopd(&opdmode, &opd, P_EXP, NULL);
  return(opdmode);
}
/*}}}*/
/*{{{  PUBLIC int mapaddresslopd (opdmode, opd)*/
/*****************************************************************************
 *
 *  mapaddresslopd maps workspace requirement for addressing (opdmode, opd)
 *                 see routine addresslopd.
 *
 *****************************************************************************/
int mapaddresslopd ( int opdmode , treenode **opd , int *freetempopd )
{
  if (isaddressableopd(opdmode, *opd) || isconstopd(opdmode, *opd))
    opdmode = mappreparelopd(opdmode, opd, freetempopd);
  else
    {
      /* Make a temporary and evaluate into that */
      *opd = gettemp(*opd, NM_WORKSPACE);
      *freetempopd = TRUE;
      mapmovelopd(P_TEMP, opd, opdmode, NDeclAddr(*opd));
      opdmode = P_TEMP;
    }
  return(opdmode);
}
/*}}}*/
/*{{{  PUBLIC void mapmoveqopd(destmode, dest, sourcemode, source)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  mapmoveqopd maps the move of the quadruple length expression
 *              (sourcemode, source) to the quadruple length variable
 *              (destmode, dest)
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void mapmoveqopd ( int destmode , treenode **dest , int sourcemode , treenode **source )
{
  if (isaddressableopd(sourcemode, *source) || isconstopd(sourcemode, *source))
    mapmoveopd(destmode, dest, sourcemode, source);
  else
    mapqopandassign(destmode, dest, source);
}
/*}}}*/
/*{{{  PUBLIC void moveqopd(destmode, dest, sourcemode, source)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  moveqopd generates code to move the quad-length expression
 *           (sourcemode, source) to the quad-length destination
 *           (destmode, dest).
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void moveqopd ( int destmode , treenode *dest , int sourcemode , treenode *source )
{
  if (isaddressableopd(sourcemode, source))
    moveopd(destmode, dest, sourcemode, source);
  else if (preeval(sourcemode, source))
    {
      sourcemode = simplify(sourcemode, source);
      moveopd(destmode, dest, sourcemode, source);
    }
  else
    /*{{{  function call or valof*/
    {
      /*{{{  print expression*/
      if (diagnostics)
        commentexp(source);
      /*}}}*/
      switch(TagOf(source))
        {
          default:
            badtag(genlocn, TagOf(source), "qopandassign");
            break;
          /*{{{  function call*/
          case S_FINSTANCE:
            tinstance(source);
            break;
          /*}}}*/
          /*{{{  specification .. valof*/
          case S_VALABBR: case S_ABBR:
          case S_VALRETYPE: case S_RETYPE:
          case S_PROCDEF: case S_SFUNCDEF: case S_LFUNCDEF:
          case S_TPROTDEF: case S_SPROTDEF:
          case S_DECL:
          case S_VALOF:
            {
              treenode *resultexp;
              source = tspecs(source);
              resultexp = ThisItem(VLResultListOf(source));
              tprocess(VLBodyOf(source));
              tpreexp(resultexp);
              moveqopd(destmode, dest, P_EXP, resultexp);
            }
            break;
          /*}}}*/
        }
    }
    /*}}}*/
}
/*}}}*/
/*}}}*/
