/*#define DEBUG*/
/*****************************************************************************
 *
 *  Code generator gen2 - support routines
 *
 *****************************************************************************/

/*{{{  copyright*/
/*****************************************************************************
 *
 *  occam 2 compiler
 *
 *  copyright Inmos Limited 1987
 *
 *
 *****************************************************************************/
/*}}}*/

/*{{{  include files*/
# include <stdio.h>
# include "includes.h"
# include "extlib.h"

# include "genhdr.h"
# include "generror.h"
# include "lex1def.h"
# include "syndef.h"
# include "chkdef.h"
# include "usehdr.h"
# include "usedef.h"
# include "desc1def.h"
# include "predefhd.h"
# include "gen1def.h"
# include "gen2def.h"
# include "gen4def.h"
# include "bind1def.h"
# include "bind2def.h"
# include "bind3def.h"
# include "code1def.h"
/*}}}*/

/*{{{  constants*/
#define BOOL_CHECK_MASK 2
#define BYTE_CHECK_MASK 0x100
#define INT16_CHECK_MASK 0x8000
#define INT32_CHECK_MASK 0x80000000

/*{{{  tables for routines libcallstring and libconvertstring*/
#define N_LIBOPS 16  /* number of different operations */
#define N_LIBTYPES 5 /* number of different data types */
PRIVATE const int libops[N_LIBOPS] =
  { S_ADD, S_MULT, S_PLUS, S_BITAND, S_BITOR, S_XOR,
    S_SUBTRACT, S_DIV, S_REM, S_TIMES, S_MINUS,
    S_LSHIFT, S_RSHIFT, S_BITNOT, S_GR, S_EQ };
PRIVATE const int libtypes[N_LIBTYPES] =
  { S_INT16, S_INT32, S_INT64, S_REAL32, S_REAL64 };

PRIVATE const char *libstrings[N_LIBOPS][N_LIBTYPES] =
  {
    /* "bug" 1065 - these are all changed to add %CHK on the end,
       in accordance with the new naming decision. CON, 6/12/90
    */
    {"INT16ADD%CHK",    NULL,           "INT64ADD%CHK",    "REAL32OPERR%CHK",  "REAL64OPERR%CHK" },
    {"INT16MUL%CHK",    "INT32MUL%CHK", "INT64MUL%CHK",    "REAL32OPERR%CHK",  "REAL64OPERR%CHK" },
    {"INT16PLUS%CHK",   NULL,           "INT64PLUS%CHK",   NULL,               NULL           },
    {"INT16BITAND%CHK", NULL,           "INT64BITAND%CHK", NULL,               NULL           },
    {"INT16BITOR%CHK",  NULL,           "INT64BITOR%CHK",  NULL,               NULL           },
    {"INT16XOR%CHK",    NULL,           "INT64XOR%CHK",    NULL,               NULL           },
    {"INT16SUB%CHK",    NULL,           "INT64SUB%CHK",    "REAL32OPERR%CHK",  "REAL64OPERR%CHK" },
    {"INT16DIV%CHK",    "INT32DIV%CHK", "INT64DIV%CHK",    "REAL32OPERR%CHK",  "REAL64OPERR%CHK" },
    {"INT16REM%CHK",    "INT32REM%CHK", "INT64REM%CHK",    "REAL32REMERR%CHK", "REAL64REMERR%CHK"},
    {"INT16TIMES%CHK",  NULL,           "INT64TIMES%CHK",  NULL,               NULL           },
    {"INT16MINUS%CHK",  NULL,           "INT64MINUS%CHK",  NULL,               NULL           },
    {"INT16LSHIFT%CHK", NULL,           "INT64LSHIFT%CHK", NULL,               NULL           },
    {"INT16RSHIFT%CHK", NULL,           "INT64RSHIFT%CHK", NULL,               NULL           },
    {"INT16BITNOT%CHK", NULL,           "INT64BITNOT%CHK", NULL,               NULL           },
    {"INT16GT%CHK",     NULL,           "INT64GT%CHK",     "REAL32GTERR%CHK",  "REAL64GTERR%CHK" },
    {"INT16EQ%CHK",     NULL,           "INT64EQ%CHK",     "REAL32EQERR%CHK",  "REAL64EQERR%CHK" }
  };

PRIVATE const char *convertstrings[N_LIBTYPES][N_LIBTYPES] =
  {
    /* "bug" 1065 - these are all changed to add %CHK on the end,
       in accordance with the new naming decision. CON, 6/12/90
    */
    {NULL,                NULL,                "INT16TOINT64%CHK",  "INT16TOREAL32%CHK",  "INT16TOREAL64%CHK" },
    {NULL,                NULL,                "INT32TOINT64%CHK",  "INT32TOREAL32%CHK",  "INT32TOREAL64%CHK" },
    {"INT64TOINT16%CHK",  "INT64TOINT32%CHK",  NULL,                "INT64TOREAL32%CHK",  "INT64TOREAL64%CHK" },
    {"REAL32TOINT16%CHK", "REAL32TOINT32%CHK", "REAL32TOINT64%CHK", NULL,                 "REAL32TOREAL64%CHK" },
    {"REAL64TOINT16%CHK", "REAL64TOINT32%CHK", "REAL64TOINT64%CHK", "REAL64TOREAL32%CHK", NULL }
  };
/* any of these which use a total (including hidden parameters) of
   more than 3 parameter slots:
   REAL32OPERR on 16bit, or REAL64OPERR on non fpinline,
   must be explicitly checked in implicitparams because it checks how many
   param slots are used by dyadic operators, etc, and it is called
   before they have been converted into library calls.

   Really, they should be treated in a similar way to the predefines,
   but since there are only two cases, there seemed no point.
*/
/*}}}*/
/*{{{  predefined routines defns.*/
#define MAX_PREDEFS_NAMELEN 20
PRIVATE const int trueval  = TRUE;
PRIVATE const int falseval = FALSE;
PRIVATE const struct
  {
    const int *inline;  /* Whether it is implemented inline */
    const int slots;    /* No of parameter slots required for library call */
                        /* (including hidden params)             */
                        /* Not needed if never compiled as lib call */
                        /* Hex values, 0xabc; a=16bit, b=32bit, c=fpinline */
  } pdinlines[] =
  {
    /*{{{  long arithmetic*/
    { &trueval, 0 }, /* LONGADD */
    { &trueval, 0 }, /* LONGSUM */
    { &trueval, 0 }, /* LONGSUB */
    { &trueval, 0 }, /* LONGDIFF */
    { &trueval, 0 }, /* LONGPROD */
    { &trueval, 0 }, /* LONGDIV */
    /*}}}*/
    /*{{{  shift*/
    { &trueval, 0 }, /* SHIFTRIGHT */
    { &trueval, 0 }, /* SHIFTLEFT   */
    /*}}}*/
    /*{{{  normalise, fracmul*/
    { &trueval, 0 }, /* NORMALISE */
    { &fracmul, 0x222 }, /* FRACMUL */
    /*}}}*/
    /*{{{  arithmetic shift, rotate*/
    { &trueval, 0 }, /* ASHIFTRIGHT */
    { &trueval, 0 }, /* ASHIFTLEFT */
    { &trueval, 0 }, /* ROTATERIGHT */
    { &trueval, 0 }, /* ROTATELEFT */
    /*}}}*/
    /*{{{  causeerror*/
    { &trueval, 0 }, /* CAUSEERROR */
    /*}}}*/
    /*{{{  kernel run, load channel, load channel vector, load byte vector*/
    { &trueval, 0 }, /* KERNELRUN */
    { &trueval, 0 }, /* LOADINPUTCHANNEL */
    { &trueval, 0 }, /* LOADOUTPUTCHANNEL */
    { &trueval, 0 }, /* LOADINPUTCHANNELVECTOR */
    { &trueval, 0 }, /* LOADOUTPUTCHANNELVECTOR */
    { &trueval, 0 }, /* LOADBYTEVECTOR */
    /*}}}*/
    /*{{{  unpacksn roundsn*/
    { &fpsupport, 0x111 }, /* UNPACKSN */
    { &fpsupport, 0x333 }, /* ROUNDSN */
    /* ROUNDSN is treated specially cos it needs Wptr+0; see below */
    /*}}}*/
    /*{{{  draw2d, clip2d, move2d*/
    { &graphicsmove, 0xCCC }, /* DRAW2D */
    { &graphicsmove, 0xCCC }, /* CLIP2D */
    { &graphicsmove, 0xCCC }, /* MOVE2D */
    /*}}}*/
    /*{{{  crc byte and word*/
    { &hascrc, 0x333 }, /* CRCWORD */
    { &hascrc, 0x333 }, /* CRCBYTE */
    /*}}}*/
    /*{{{  bit ops*/
    { &hasbitops, 0x222 }, /* BITCOUNT */
    { &hasbitops, 0x111 }, /* BITREVWORD */
    { &hasbitops, 0x222 }, /* BITREVNBITS */
    /*}}}*/
    /*{{{  floating point*/
    { &fpinline, 0x211 }, /* ABS */
    { &fpinline, 0x111 }, /* ISNAN */
    { &real32isaword, 0x111 },  /* NOTFINITE */
    { &fpinline, 0x222 }, /* ORDERED */
    { &real32isaword, 0x211 },  /* MINUSX */
    { &fpinline, 0x211 }, /* MULBY2 */
    { &fpinline, 0x211 }, /* DIVBY2 */
    { &fpinline, 0x211 }, /* SQRT */
    { &fpinline, 0x211 }, /* FPINT */
    { &fpinline, 0x221 }, /* DABS */
    { &fpinline, 0x111 }, /* DISNAN */
    { &fpinline, 0x111 }, /* DNOTFINITE */
    { &fpinline, 0x222 }, /* DORDERED */
    { &fpinline, 0x221 }, /* DMINUSX */
    { &fpinline, 0x221 }, /* DMULBY2 */
    { &fpinline, 0x221 }, /* DDIVBY2 */
    { &fpinline, 0x221 }, /* DSQRT */
    { &fpinline, 0x221 }, /* DFPINT */
    { &falseval, 0x322 }, /* SCALEB */
    { &falseval, 0x332 }, /* DSCALEB */
    { &falseval, 0x322 }, /* COPYSIGN */
    { &falseval, 0x332 }, /* DCOPYSIGN */
    { &falseval, 0x322 }, /* NEXTAFTER */
    { &falseval, 0x332 }, /* DNEXTAFTER */
    { &falseval, 0x211 }, /* LOGB */
    { &falseval, 0x221 }, /* DLOGB */
    { &falseval, 0x211 }, /* FLOATINGUNPACK */
    { &falseval, 0x222 }, /* DFLOATINGUNPACK */
    { &falseval, 0x533 }, /* ARGUMENTREDUCE */
    { &falseval, 0x544 }, /* DARGUMENTREDUCE */
    /*}}}*/
    /*{{{  IEEE arithmetic*/
    { &falseval, 0x433 }, /* REAL32OP */
    { &falseval, 0x443 }, /* REAL64OP */
    { &falseval, 0x544 }, /* IEEE32OP */
    { &falseval, 0x555 }, /* IEEE64OP */
    { &falseval, 0x322 }, /* REAL32REM */
    { &falseval, 0x332 }, /* REAL64REM */
    { &falseval, 0x222 }, /* REAL32EQ */
    { &falseval, 0x222 }, /* REAL64EQ */
    { &falseval, 0x222 }, /* REAL32GT */
    { &falseval, 0x222 }, /* REAL64GT */
    { &falseval, 0x222 }, /* IEEECOMPARE */
    { &falseval, 0x222 }, /* DIEEECOMPARE */
    { &falseval, 0x322 }, /* IEEE32REM */
    { &falseval, 0x333 }, /* IEEE64REM */
    /*}}}*/
    /*{{{  reschedule/assert*/
    { &trueval, 0 },  /* RESCHEDULE */
    { &trueval, 0 }   /* ASSERT */
    /*}}}*/
  };
/*}}}*/
/*}}}*/

/*{{{  routines*/
/*{{{  PUBLIC wordnode *processlibname*/
PUBLIC wordnode *processlibname(const char *str, const int suffix_len, const char *new_suffix)
/* This 'un-hides' the name if required.
   Or adds the new suffix if that is required.
   The default is 'hidden' because that is what would normally be wanted.
*/
{
  int len = strlen(str);
  if (!hidelibnames)
    len -= suffix_len; /* remove the '%' suffix */
  else if (new_suffix != NULL)
    {
      char buffer[MAX_PREDEFS_NAMELEN+15]; /* allow plenty of space */
      const int   old_len = len - suffix_len;
      const int extra_len = strlen(new_suffix);
      assert((old_len+extra_len) < (MAX_PREDEFS_NAMELEN+10));
      memcpy(buffer, str, old_len);
      memcpy(&buffer[old_len], new_suffix, extra_len);
      buffer[old_len+extra_len] = '\0'; /* probably not necessary really */
      return lookupword(buffer, old_len+extra_len);
    }
  return lookupword(str, len);
}
/*}}}*/
/*{{{  PUBLIC pdinline, pdlibname, pdparams*/
PUBLIC int pdinline ( const int pdno )
{
  return *(pdinlines[pdno].inline);
}
PUBLIC wordnode *pdlibname ( wordnode * const pdname, const int pdno )
{
  if (!hidelibnames || (pdinlines[pdno].slots == 0))
    return pdname;
  else
    {
      char buffer[MAX_PREDEFS_NAMELEN+2];
      const int len = WLengthOf(pdname);
      assert(len < MAX_PREDEFS_NAMELEN);
      memcpy(buffer, WNameOf(pdname), len);
      buffer[len]   = '%';
      buffer[len+1] = 'O'; /* "bug" 1065 - converted to %O rather than just % */
                           /* CON 6/12/90 */
      buffer[len+2] = '\0';
      DEBUG_MSG(("pdlibname: %s:%d\n", buffer, len));
      return processlibname(buffer, 2, predefsuffix);
    }
}
PUBLIC int pdparams ( const treenode *tptr )
{
  /* This returns the number of param slots (including hidden params)
     required by a predefine library call. -1 otherwise.
     This is used by findinstances, cos at that stage the hidden params
     haven't yet been augmented */

  int pdno ;
  if ((TagOf(INameOf(tptr)) != N_PREDEFFUNCTION) &&
      (TagOf(INameOf(tptr)) != N_PREDEFPROC)       )
      return (-1);
  pdno = NModeOf(INameOf(tptr));

  if (fpsupport && pdno == PD_ROUNDSN)
      return (4); /* ensure that Wptr+0 is left clear */
  if (*(pdinlines[pdno].inline))
      return (-1);

  if (fpinline)                      /* T8 */
    return (pdinlines[pdno].slots & 0xF);               /* Bottom hex digit */
  else if (targetintsize == S_INT32) /* T4 */
    return ((pdinlines[pdno].slots >> 4) & 0xF);        /* Middle hex digit */
  else                               /* T2 */
    return ((pdinlines[pdno].slots >> 8) & 0xF);        /* Top hex digit */
}
/*}}}*/
/*{{{  PUBLIC treenode *constantmatch(c, clist)*/
/*****************************************************************************
 *
 *  constantmatch takes a constant expression node c, and a list of
 *                constant nodes (scalars and vectors): if a constant
 *                expression node which matches c (ie. has same size and
 *                value) is found on the list before reaching c, then
 *                a pointer to that node is returned, otherwise NULL is
 *                returned.
 *
 *  Modified 18/10/90 as part of bug 1024: Now don't worry about the size;
 *  Hence a REAL32 can be the first half of a REAL64..
 *
 *****************************************************************************/
PUBLIC treenode *constantmatch ( treenode *c , treenode *clist )
{
  int bytesin_c = 0;
  while ((clist != c) && (clist != NULL))
    switch(TagOf(clist))
      {
        /*{{{  S_CONSTEXP                    break / return*/
        case S_CONSTEXP:
          if ((TagOf(c) == S_CONSTEXP) && (LoValOf(c) == LoValOf(clist)))
            {
              if (bytesin_c == 0)
                bytesin_c = bytesin(gettype(c));
              /* bug 1024: the test 'fitsinword' should be changed to
                 'bytesin(...) <= 4' - CON 18/10/90 */
              /*if ((fitsinword(TagOf(type)) || (HiValOf(c) == HiValOf(clist))) &&*/
              if ((bytesin_c <= 4) ||
                  ((HiValOf(c) == HiValOf(clist)) &&
                   (bytesin_c <= bytesin(gettype(clist))) )) /* this used to be 'wordsin' 18/10/90 */
                return(clist);
            }
          clist = CENextOf(clist);
          break;
        /*}}}*/
        /*{{{  S_STRING S_CONSTCONSTRUCTOR   break / return*/
        case S_STRING:
        case S_CONSTCONSTRUCTOR:
          if ((TagOf(c) != S_CONSTEXP) && (CTValOf(c) == CTValOf(clist)))
            return(clist);
          clist = CTNextOf(clist);
          break;
        /*}}}*/
        default:
          badtag(genlocn, TagOf(clist), "constantmatch");
      }
  return(NULL);
}
/*}}}*/
#if 0 /* never used */
/*{{{  PUBLIC void declare_sc_entries (nptr)*/
/*****************************************************************************
 *
 *  declare_sc_entries takes a list of SC entrypoints 'nptr' and
 *                     allocates each entry point a label and offset
 *                     of the label from the beginning of this module's code
 *
 *                     Warn about entry points with the same name, and don't
 *                     declare the descoped ones.
 *
 *****************************************************************************/
PUBLIC void declare_sc_entries ( treenode *nptr , INT32 prevcodesize )
{
  while (nptr != NULL)
    {
      int lab = newlab();
      SetNSCEntryLabel(nptr, (INT32)lab);
      SetNSCEntryOffset(nptr, NSCEntryOffsetOf(nptr) + prevcodesize);
      declarelabel(lab, NSCEntryOffsetOf(nptr));
      nptr = NSCEntryNextOf(nptr);
    }
}
/*}}}*/
#endif
/*{{{  PUBLIC int cancauseerror(treenode *tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  cancauseerror returns TRUE if execution of the tree 'tptr' could possibly
 *                set the error flag.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC int cancauseerror ( treenode *tptr )
{
  if (!(NEED_ERRORS)) return FALSE;
  switch (TagOf(tptr))
    {
      default: return TRUE;
      /*{{{  monadics whose operands might ...*/
      case S_UMINUS:
      case S_BITNOT:
      case S_NOT:
      case S_SIZE:
        return cancauseerror(OpOf(tptr));
      /*{{{  ROUND TRUNC EXACT*/
      case S_ROUND: case S_TRUNC:
      case S_EXACT:
        {
          int sourcetype = typeof(OpOf(tptr));
          int desttype = MOpTypeOf(tptr);
          if (sourcetype == S_INT) sourcetype = targetintsize;
          if (desttype   == S_INT) desttype   = targetintsize;
          if (TagOf(tptr) == S_EXACT)
            {
              if (isreal(sourcetype) || isreal(desttype) ||
                  hasgreaterrange(desttype, sourcetype))
                return cancauseerror(OpOf(tptr));
              else
                return TRUE;
            }
          else
            {
              if ((sourcetype == desttype) ||
                  (sourcetype == S_INT16 && isreal(desttype)) ||
                  (sourcetype == S_INT32 && desttype == S_REAL64))
                return cancauseerror(OpOf(tptr));
              else
                return TRUE;
            }
        }
      /*}}}*/
      /*}}}*/
      /*{{{  dyadics whose operands might ...*/
      case S_AND: case S_OR:
      case S_BITAND: case S_BITOR: case S_XOR:
      case S_PLUS: case S_MINUS: case S_TIMES:
      case S_EQ: case S_NE: case S_LS: case S_LE: case S_GR: case S_GE:
      case S_AFTER:
        return cancauseerror(LeftOpOf(tptr)) || cancauseerror(RightOpOf(tptr));
      /*}}}*/
      /*{{{  constants and names which can't*/
      case S_DUMMYEXP:
      case S_CONSTEXP:
      case N_VALABBR: case N_ABBR:
      case N_VALRETYPE: case N_RETYPE:
      case N_VALPARAM: case N_PARAM:
      case N_DECL: case N_REPL:
      case S_FNACTUALRESULT:
      case S_FNFORMALRESULT:
      case S_HIDDEN_PARAM:
        return FALSE;
      /*}}}*/
    }
}
/*}}}*/
/*{{{  PUBLIC int isconversion(treenode *tptr)*/
/*****************************************************************************
 *
 *  isconversion returns TRUE if 'tptr' is a conversion tree.
 *
 *****************************************************************************/
PUBLIC int isconversion ( treenode *tptr )
{
  int tag = TagOf(tptr);
  return (tag == S_EXACT || tag == S_TRUNC || tag == S_ROUND);
}
/*}}}*/
/*{{{  PUBLIC int needtemptoload(opdmode, opd)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  needtemptoload returns TRUE if we have to move (opdmode, opd) to a
 *                 temporary before we can load it.
 *                 Also decides, for real values on an fp processor, whether
 *                 we need to generate (opdmode, opd) to a temporary in order
 *                 to load it into an integer register.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC int needtemptoload ( int opdmode , treenode *opd )
{
  if (opdmode == P_EXP)
    {
      if (fpinline && ((typeof(opd) == S_REAL32 && !isaddressable(opd)) ||
                       (isconversion(opd) && isreal(typeof(OpOf(opd))))))
        return TRUE;
      switch (TagOf(opd))
        {
          /*{{{  PARAM ABBR RETYPE DECL*/
          case N_PARAM:
          case N_ABBR:
          case N_RETYPE:
          case N_DECL:
            {
              treenode *type = gettype(opd);
              if (TagOf(type) == S_PORT) type = ProtocolOf(type);
              return isshortint(TagOf(type)) &&
                     (ispointer(opd) || isplaced(opd));
            }
          /*}}}*/
          case S_ARRAYITEM: return isshortint(typeof(opd));
          default:          return FALSE;
        }
     }
   return FALSE;
}
/*}}}*/
/*{{{  PUBLIC treenode *firstresultof(tptr)*/
/*****************************************************************************
 *
 * firstresultof takes a formal parameter list 'tptr' and returns a list whose
 *               head is the first FNFORMALRESULT node on 'tptr'.
 *
 *****************************************************************************/
PUBLIC treenode *firstresultof ( treenode *tptr )
{
  while (!EndOfList(tptr) && (TagOf(ThisItem(tptr)) != S_FNFORMALRESULT))
    {
      DEBUG_MSG(("firstresultof: skipping %s\n", itagstring(TagOf(ThisItem(tptr)))));
      tptr = NextItem(tptr);
    }
  DEBUG_MSG(("firstresultof: returning %s\n",
             EndOfList(tptr) ? "End of list" : itagstring(TagOf(ThisItem(tptr)))));
  return(tptr);
}
/*}}}*/
/*{{{  PUBLIC treenode *nextresultof(tptr)*/
/*****************************************************************************
 *
 * nextresultof takes a formal parameter list 'tptr' and returns a list whose
 *              head is the next FN_RESULTPTR node on 'tptr'.
 *
 *****************************************************************************/
PUBLIC treenode *nextresultof ( treenode *tptr )
{
  DEBUG_MSG(("nextresultof\n"));
  return(firstresultof(NextItem(tptr)));
}
/*}}}*/
/*{{{  PUBLIC wordnode *libcallstring (op, type)*/
/***************************************************************************
 *
 *  libcallstring returns a string representing the name of extended
 *                type operation 'op' for type 'type'.
 *
 **************************************************************************/
PUBLIC wordnode *libcallstring ( int op , int type )
{
  int opix, typeix;
  int i, found;
  /*{{{  set up opix*/
  i = 0;
  found = FALSE;
  while ( !found && (i < (sizeof(libops) / sizeof(int))))
    if (libops[i] == op)
      {
        opix = i;
        found = TRUE;
      }
    else
      i++;
  if (!found)
    geninternal_is(GEN_ERROR_IN_ROUTINE, op, "libcallstring-op");
  /*}}}*/
  /*{{{  set up typeix*/
  i = 0;
  found = FALSE;
  while ( !found && (i < (sizeof(libtypes) / sizeof(int))))
    if (libtypes[i] == type)
      {
        typeix = i;
        found = TRUE;
      }
    else
      i++;
  if (!found)
    geninternal_is(GEN_ERROR_IN_ROUTINE, op, "libcallstring-type");
  /*}}}*/
  return processlibname(libstrings[opix][typeix], 4, compilersuffix);
}
/*}}}*/
/*{{{  PRIVATE wordnode *libconvertstring (sourcetype, desttype)*/
/***************************************************************************
 *
 *  libconvertstring returns a string representing the name of the extended
 *                   type conversion routine from sourcetype to desttype.
 *
 **************************************************************************/
PRIVATE wordnode *libconvertstring ( int sourcetype , int desttype )
{
  int sourceix, destix;
  int i, found;
  /*{{{  set up sourceix*/
  i = 0;
  found = FALSE;
  while ( !found && (i < (sizeof(libtypes) / sizeof(int))))
    if (libtypes[i] == sourcetype)
      {
        sourceix = i;
        found = TRUE;
      }
    else
      i++;
  if (!found)
    badtag(genlocn, sourcetype, "libconvertstring");
  /*}}}*/
  /*{{{  set up destix*/
  i = 0;
  found = FALSE;
  while ( !found && (i < (sizeof(libtypes) / sizeof(int))))
    if (libtypes[i] == desttype)
      {
        destix = i;
        found = TRUE;
      }
    else
      i++;
  if (!found)
    badtag(genlocn, desttype, "libconvertstring");
  /*}}}*/

  return processlibname(convertstrings[sourceix][destix], 4, compilersuffix);
}
/*}}}*/
/*{{{  PUBLIC int implicitparams(Op, type)*/
PUBLIC int implicitparams (int op, int type)
  /* Conceptually this returns the number of parameter slots required
     for any monadic or dyadic operator which is turned into a function call.
     It returns (-1) if the operation is perfomed inline.
     However, we can get away with being lazy and only returning the values
     for those function calls which require more parameters than there
     are registers. They are 'long' real operations only.
     We can get away with returning -1 for all others, because 'regsfor'
     correctly decides that all registers will be used for all other
     conversions.
     CO'N 30/4/90
  */
{
  switch (op)
    {
      case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV:
      case S_NEG:  /* unary negation */ /* Added to fix bug 295 30/4/90 by CO'N */
        /* We haven't turned REAL64 add etc into a lib call yet. Here's a bodge:
           They get turned into z := REAL64OPERR (x, op, y), or
           z := REAL32OPERR (x, op, y), but since types are
           double length, the extra hidden parameter causes problems */
        /* Unary negation is turned into a subtraction from zero */
        return (fpinline ? (-1) :
                (type == S_REAL64) ? 4 :
                (type == S_REAL32) ?
                  ((targetintsize == S_INT16) ? 4 : 3) :
                (-1) ) ;
      default:
        return (-1);
    }
}
/*}}}*/
/*{{{  PUBLIC treenode *makeconversion(sourcetype, desttype, source, mode)*/
/*****************************************************************************
 *
 *  makeconversion creates a function call to a standard library routine
 *                 to convert 'source' from 'sourcetype' to 'desttype' with
 *                 rounding mode 'mode'.
 *
 *****************************************************************************/
PUBLIC treenode *makeconversion ( int sourcetype , int desttype , treenode *source , int mode )
{
  SOURCEPOSN locn = LocnOf(source);
  treenode *iname;
  treenode *paramlist;
  if (sourcetype == S_INT) sourcetype = targetintsize;
  if (desttype   == S_INT) desttype   = targetintsize;
  iname = libentry (libconvertstring(sourcetype, desttype), locn);
  paramlist = newlistnode(S_LIST, locn, source, NULL);
  if
    /*{{{  conversion requires a rounding mode*/
    ((isreal(sourcetype) || isreal(desttype)) &&
    (!((sourcetype == S_REAL32 && desttype == S_REAL64) ||
       (sourcetype == S_INT32  && desttype == S_REAL64) ||
      (sourcetype == S_INT16  && (desttype == S_REAL32 || desttype == S_REAL64)))))
    /*}}}*/
      /*{{{  add rounding mode to parameter list*/
      {
        treenode *modeptr = newconstant((mode == S_ROUND) ? Nearest : Truncate);
        paramlist = newlistnode(S_LIST, locn, modeptr, paramlist);
      }
      /*}}}*/
  return newinstancenode(S_FINSTANCE, locn, iname, paramlist);
}
/*}}}*/
/*{{{  PUBLIC treenode *makedopfunction (tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  makedopfunction takes a dyadic operator node tptr and returns
 *                  a function instance tree which calls the appropriate
 *                  library routine for the dyadic.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC treenode *makedopfunction ( treenode *tptr )
{
  int op = TagOf(tptr);
  SOURCEPOSN locn = LocnOf(tptr);
  treenode *left = LeftOpOf(tptr), *right = RightOpOf(tptr);
  treenode *iname;
  treenode *paramlist;
  int type = DOpTypeOf(tptr);
  if (type == S_INT) type = targetintsize;
  if (commutes(tptr) && (regsfor(left) > regsfor(right)))
    /*{{{  swap left and right*/
    { treenode *temp = left; left = right; right = temp; }
    /*}}}*/

  iname = libentry(libcallstring(op, type), locn);
  /*{{{  make the parameter list*/
  if (isreal(type))
    /*{{{  make a call to realxxop/realxxrem*/
    {
      if (op == S_REM)
        /*{{{  call REALxxREM*/
        /*{{{  COMMENT what the tree looks like*/
        /**********************  Start comment out ****************************
        @*
                rem                    finstance
              /    \       =>         /       \
             e1    e2          real32rem      list
                                              /   \
                                            e1    list
                                                  /   \
                                                e2    NULL
        *@
         **********************   End comment out  ****************************/
        /*}}}*/
        paramlist = newlistnode(S_LIST, locn, left,
                      newlistnode(S_LIST, locn, right,
                                    NULL));
        /*}}}*/
      else
        /*{{{  call REALxxOP*/
        /*{{{  COMMENT what the tree looks like*/
        /**********************  Start comment out ****************************
        @*
                op                    finstance
              /    \       =>         /       \
             e1    e2          real32operr    list
                                              /   \
                                            e1'   list
                                                  /   \
                                              op.val  list
                                                      /   \
                                                    e2'   NULL
        
           If op is commutative, e1' =  most.complex(e1, e2)
                                 e2' =  least.complex(e1, e2)
        *@
         **********************   End comment out  ****************************/
        /*}}}*/
        {
          INT32 op_mode = (op == S_ADD) ?      Op_Add  :
                          (op == S_SUBTRACT) ? Op_Sub  :
                          (op == S_MULT) ?     Op_Mul  :
                                               Op_Div;
          paramlist =
            newlistnode(S_LIST, locn, left,
              newlistnode(S_LIST, locn,
                newconstexpnode(S_CONSTEXP, 0, dummyexp_p, ZERO32, op_mode),
                newlistnode(S_LIST, locn, right,
                              NULL)));
        }
        /*}}}*/
    }
    /*}}}*/
  else
    paramlist = newlistnode(S_LIST, locn, left,
                  newlistnode(S_LIST, locn, right, NULL));
  /*}}}*/

  return newinstancenode(S_FINSTANCE, locn, iname, paramlist);
}
/*}}}*/
/*{{{  PUBLIC int istrueguard(tptr)*/
/*****************************************************************************
 *
 *  istrueguard returns TRUE if the guard represented by 'tptr' is a 'TRUE'
 *              guard.
 *
 *****************************************************************************/
PUBLIC int istrueguard ( treenode *tptr )
{
  return((TagOf(tptr) == S_CONSTEXP) && (LoValOf(tptr) == ONE32));
}
/*}}}*/
/*{{{  PUBLIC int isfalseguard(tptr)*/
/*****************************************************************************
 *
 *  isfalseguard returns TRUE if the guard represented by 'tptr' is a 'FALSE'
 *              guard.
 *
 *****************************************************************************/
PUBLIC int isfalseguard ( treenode *tptr )
{
  return((TagOf(tptr) == S_CONSTEXP) && (LoValOf(tptr) == ZERO32));
}
/*}}}*/
/*{{{  PUBLIC int isskipbody(tptr)*/
/*****************************************************************************
 *
 *  isskipbody returns TRUE if the process represented by tptr is a SKIP
 *             process (any leading specifications are ignored
 *
 *****************************************************************************/
PUBLIC int isskipbody ( treenode *tptr )
  {
    tptr = skipspecifications(tptr);
    return (TagOf(tptr) == S_SKIP);
  }
/*}}}*/
/*{{{  PUBLIC int complexinitialise(typeptr)*/
/*****************************************************************************
 *
 *  complexinitialise returns TRUE if the initialisation of a variable of
 *                    type 'typeptr' requires workspace slots during the
 *                    initialisation.
 *                    ie. the type is an array of CHAN with more than 3
 *                    elements.
 *
 *****************************************************************************/
PUBLIC int complexinitialise ( treenode *typeptr )
{
  return ((TagOf(typeptr) == S_ARRAY) && (basetype(typeptr) == S_CHAN) &&
          (elementsin(typeptr) > 3));
}
/*}}}*/
/*{{{  PUBLIC int timerguardinalt(tptr)*/
/*****************************************************************************
 *
 *  timerguardinalt takes an ALT or replicated ALT tree 'tptr' and returns
 *                  TRUE if there is a timer guard in the ALT or any nested
 *                  ALTs, otherwise returns FALSE.
 *
 *****************************************************************************/
PUBLIC int timerguardinalt ( treenode *tptr )
  {
    tptr = skipspecifications(tptr);
    switch(TagOf(tptr))
      {
        /*{{{  S_ALT S_PRIALT*/
        case S_ALT: case S_PRIALT:
          {
            int result = FALSE;
            tptr = CBodyOf(tptr);
            while ((!EndOfList(tptr)) && (!result))
              {
                /* result = timerguardinalt(SpBodyOf(ThisItem(tptr))); */
                result = timerguardinalt(ThisItem(tptr));
                tptr = NextItem(tptr);
              }
            return(result);
          }
        /*}}}*/
        /*{{{  S_REPLALT S_PRIREPLALT*/
        case S_REPLALT: case S_PRIREPLALT:
          return(timerguardinalt(ReplCBodyOf(tptr)));
        /*}}}*/
        /*{{{  S_ALTERNATIVE*/
        case S_ALTERNATIVE:
          return(TagOf(AltInputOf(tptr)) == S_DELAYED_INPUT);
        /*}}}*/
        default:
          badtag(genlocn, TagOf(tptr), "timerguardinalt");
      }
  return (0); /* not reached */
  }
/*}}}*/
/*{{{  PUBLIC int inputtypeof(tptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  inputtypeof takes an input tree and returns its type:
 *              types are  INP_INPUT - channel ?
 *                         INP_DELAYED_INPUT - timer ? AFTER
 *                         INP_PORT_INPUT - port ?
 *                         INP_TIMER_INPUT - timer ?
 *                         INP_SKIP - no input
 *
 *****************************************************************************/
/*}}}*/
PUBLIC int inputtypeof ( treenode *tptr )
{
  switch (TagOf(tptr))
    {
      case S_SKIP:          return(INP_SKIP);
      case S_DELAYED_INPUT: return(INP_DELAYED_INPUT);
      case S_CASE_INPUT:    return(INP_CASE_INPUT);
      case S_TAGGED_INPUT:  return(INP_TAGGED_INPUT);
      /*{{{  S_INPUT*/
      case S_INPUT:
        {
          treenode *t = gettype(LHSOf(tptr));
          while (TagOf(t) == S_ARRAY) t = ARTypeOf(t);
          switch (TagOf(t))
            {
              case S_CHAN:  return INP_INPUT;
              case S_PORT:  return INP_PORT_INPUT;
              case S_TIMER: return INP_TIMER_INPUT;
              default:      badtag(genlocn, TagOf(t), "inputtypeof");
            }
        }
      /*}}}*/
    }
  return (0); /* not reached */
}
/*}}}*/
/*{{{  PUBLIC int istargetintsize (type)*/
/*****************************************************************************
 *
 *  istargetintsize returns TRUE if an object of type 'type' is the same
 *                  size as an object of type 'S_INT'.
 *
 *****************************************************************************/
PUBLIC int istargetintsize ( int type )
{
  return ((type == S_INT) || (type == targetintsize) ||
          ((type == S_REAL32) && (targetintsize == S_INT32)) ||
          (type == S_CHAN));
}
/*}}}*/
/*{{{  PUBLIC int istargetbytesize (type)*/
/*****************************************************************************
 *
 *  istargetbytesize returns TRUE if an object of type 'type' is the same size
 *                   as an object of type S_BYTE.
 *
 *****************************************************************************/
PUBLIC int istargetbytesize ( int type )
{
  return ((type == S_BOOL) || (type == S_BYTE));
}
/*}}}*/
/*{{{  PUBLIC int isdoublelength (type)*/
/*****************************************************************************
 *
 *  isdoublelength returns TRUE if a (scalar) object of type 'type' occupies
 *                 two machine words.
 *
 *****************************************************************************/
PUBLIC int isdoublelength ( int type )
{
  return ((targetintsize == S_INT16) && (type == S_INT32 || type == S_REAL32))
      || ((targetintsize == S_INT32) && (type == S_INT64 || type == S_REAL64));
}
/*}}}*/
/*{{{  PUBLIC int isshortint (type)*/
/*****************************************************************************
 *
 *  isshortint returns TRUE if 'type' is an integer type and an object
 *              of type 'type' is smaller than an object of type S_INT.
 *
 *****************************************************************************/
PUBLIC int isshortint ( int type )
{
  return (type == S_INT16) && (targetintsize == S_INT32);
}
/*}}}*/
/*{{{  PUBLIC int fitsin (sourcetype, desttype)*/
/*****************************************************************************
 *
 *  fitsin returns TRUE if a value of type 'sourcetype' will fit in an
 *         object of type 'desttype'.
 *
 *****************************************************************************/
PUBLIC int fitsin ( int sourcetype , int desttype )
{
  if (sourcetype == S_INT) sourcetype = targetintsize;
  if (desttype   == S_INT) desttype   = targetintsize;
  switch (sourcetype)
    /*{{{  pick out the FALSE cases*/
    {
      case S_INT16:
        if ((desttype == S_BOOL) || (desttype == S_BYTE))
          return (FALSE);
        break;
      case S_INT32:
      case S_REAL32:
        if ((desttype == S_BOOL) || (desttype == S_BYTE) ||
            (desttype == S_INT16))
          return (FALSE);
        break;
      case S_INT64:
      case S_REAL64:
        if ((desttype != S_INT64) && (desttype != S_REAL64))
          return (TRUE);
        break;
      default:  /* BOOL and BYTE */
        break;
    }
    /*}}}*/
  return (TRUE);
}
/*}}}*/
/*{{{  PUBLIC int isshorttype (type)*/
/*****************************************************************************
 *
 *  isshorttype returns TRUE if an object of type 'type' is smaller than
 *              an object of type S_INT.
 *
 *****************************************************************************/
PUBLIC int isshorttype ( int type )
{
  return (type == S_BOOL) || (type == S_BYTE) ||
         ((targetintsize == S_INT32) && (type == S_INT16));
}
/*}}}*/
/*{{{  PUBLIC int fitsinregister (type)*/
/*****************************************************************************
 *
 *  fitsinregister returns TRUE if a value of type 'type' can be held in a
 *                 register.
 *
 *****************************************************************************/
PUBLIC int fitsinregister ( int type )
{
  return (istargetintsize(type) || isshorttype(type));
}
/*}}}*/
/*{{{  PUBLIC int fitsinword (type)*/
/*****************************************************************************
 *
 *  fitsinword returns TRUE if a value of type 'type' can be held in a
 *             machine word.
 *
 *****************************************************************************/
PUBLIC int fitsinword ( int type )
{
  return (istargetintsize(type) || isshorttype(type));
}
/*}}}*/
/*{{{  PUBLIC int commutes (tptr)*/
/*****************************************************************************
 *
 *  commutes returns TRUE if the dyadic operator tree 'tptr' is commutative.
 *
 *****************************************************************************/
PUBLIC int commutes ( treenode *tptr )
{
  switch (TagOf(tptr))
    {
      /*{{{  ADD MULT BITAND BITOR XOR PLUS EQ*/
      case S_ADD:
      case S_MULT:
      case S_BITAND:
      case S_BITOR:
      case S_XOR:
      case S_PLUS:
      case S_EQ:
        return (TRUE);
      /*}}}*/
      /*{{{  SUBTRACT DIV REM LSHIFT RSHIFT MINUS TIMES CSUB0 CCNT1 GR*/
      case S_SUBTRACT:
      case S_DIV:
      case S_REM:
      case S_LSHIFT:
      case S_RSHIFT:
      case S_MINUS:
      case S_TIMES:
      case S_GR:
      case S_CSUB0: case S_CCNT1:
        return (FALSE);
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "commutes");
    }
  return (FALSE); /* not reached */
}
/*}}}*/
/*{{{  PUBLIC int isinconstanttable (tptr)*/
/*****************************************************************************
 *
 *  isinconstanttable returns TRUE if the constant node 'tptr' is in a
 *                    constant table.
 *
 *****************************************************************************/
PUBLIC int isinconstanttable ( treenode *tptr )
{
  return(CEOffsetOf(tptr) >= 0);
}
/*}}}*/
/*{{{  PUBLIC int issimplelocal (tptr)*/
/*****************************************************************************
 *
 *  issimplelocal returns TRUE if the element 'tptr' is  a simple
 *                (not subscripted or segmented) local variable.
 *
 *****************************************************************************/
PUBLIC int issimplelocal ( treenode *tptr )
{
#if 0 /* tidied so that it simply calls islocal - 5/11/90 */
  switch (TagOf(tptr))
    {
      case N_VALABBR: case N_ABBR:
      case N_VALRETYPE: case N_RETYPE:
      case N_DECL: case N_REPL:
      case N_VALPARAM: case N_PARAM:
      case T_TEMP: case T_PREEVALTEMP:
        return((NLexLevelOf(tptr) == lexlevel) &&
               ((NModeOf(tptr) == NM_WORKSPACE) ||
                (NModeOf(tptr) == NM_WSPLACED)  ||
                (NModeOf(tptr) == NM_DEFAULT)     ));  /* not yet mapped */
               /* It used to say this, but was changed to be OK for regsforaddr */
               /* (NModeOf(tptr) != NM_PLACED));  -- CO'N 20/2/90 */
      default:
        return (FALSE);
    }
#else
  if (islocal(tptr))
    {
      int m = NModeOf(tptr);
      return (m == NM_WORKSPACE || m == NM_WSPLACED || m == NM_DEFAULT);
    }
  else
    return FALSE;
#endif
}
/*}}}*/
/*{{{  PUBLIC int isaddressable (tptr)*/
/*****************************************************************************
 *
 *  isaddressable returns TRUE if the tree 'tptr' is addressable, ie. if it
 *                is an element not an expression.
 *
 *****************************************************************************/
PUBLIC int isaddressable ( treenode *tptr )
{
  switch(TagOf(tptr))
    {
      case S_ARRAYSUB: case S_ARRAYITEM:
      case S_SEGMENT: case S_SEGMENTITEM:
      case N_ABBR: case N_VALABBR:
      case N_RETYPE: case N_VALRETYPE:
      case N_DECL:
      case N_PARAM: case N_VALPARAM:
      case N_REPL:
      case T_PREEVALTEMP:
      case S_STRING: case S_CONSTCONSTRUCTOR:
        return (TRUE);
      case S_CONSTEXP:
        return(isinconstanttable(tptr));
      case T_TEMP:
        /* This is a bit strange:
             we use the result here to decide if the temporary means we are
             to load a pointer to the exp, or if we are to load the exp */
        return(isaddressable(NDeclOf(tptr)));
      default:
        return (FALSE);
    }
}
/*}}}*/
/*{{{  PUBLIC int issimpleopd (opdmode, opd)*/
/*****************************************************************************
 *
 *  issimpleopd returns TRUE if (opdmode, opd) is simple, ie. not
 *              subscripted or segmented.
 *
 *****************************************************************************/
PUBLIC int issimpleopd ( int opdmode , treenode *opd )
{
  switch (opdmode)
    {
      case P_TEMPPTR: return FALSE;
      case P_PTR:     /* added 30/8/90 for bug 351 CO'N */
      case P_EXP:     /*return issimple(opd);*/
        return ((TagOf(opd) == T_TEMP) ? FALSE : issimple(opd));
      default: /*case P_TEMP:*/    return TRUE;
    }
}
/*}}}*/
/*{{{  PUBLIC int issimplelocalopd(opdmode, opd)*/
/*****************************************************************************
 *
 *  issimplelocalopd returns TRUE if (opdmode, opd) represents a simple
 *                   local variable.
 *
 *****************************************************************************/
PUBLIC int issimplelocalopd ( int opdmode , treenode *opd )
{
  switch(opdmode)
   {
     case P_TEMP:     /* Temporaries aren't neccessarily local */
     case P_PTR:
     case P_EXP:
       return(issimplelocal(opd));
     default: /*case P_TEMPPTR:*/
       return FALSE;
    }
}
/*}}}*/
/*{{{  PUBLIC int isaddressableopd (opdmode, opd)*/
/*****************************************************************************
 *
 *  isaddressableopd returns TRUE if (opdmode, opd) is an addressable object.
 *
 *****************************************************************************/
PUBLIC int isaddressableopd ( int opdmode , treenode *opd )
{
  switch (opdmode)
    {
      case P_TEMP:
      case P_TEMPPTR: return (TRUE);
      case P_EXP:
      case P_PTR:     return (isaddressable(opd));
      default:        geninternal_is(GEN_BAD_OPD, opdmode, "isaddressableopd");
                      return (FALSE); /* not reached */
    }
}
/*}}}*/
/*{{{  PUBLIC int islocal(tptr)*/
/*****************************************************************************
 *
 *  islocal returns TRUE if 'tptr' is a variable and it is local.
 *
 *****************************************************************************/
PUBLIC int islocal ( treenode *tptr )
{
  /* We return FALSE for subscripts or segments */
  switch(TagOf(tptr))
    {
      case N_VALABBR: case N_ABBR:
      case N_VALRETYPE: case N_RETYPE:
      case N_DECL:
      case N_VALPARAM: case N_PARAM:
      case N_REPL:
      case T_TEMP: case T_PREEVALTEMP:
        return((NLexLevelOf(tptr) == lexlevel) &&
               (NModeOf(tptr) != NM_PLACED));
      default:
        return(FALSE);
    }
}
/*}}}*/
/*{{{  PUBLIC int ispointer(tptr)*/
/*****************************************************************************
 *
 *  ispointer returns TRUE if we access the element 'tptr' through a pointer,
 *            FALSE if we access it directly.  N.B. Non-local simple variables
 *            are not strictly accessed through a pointer.
 *
 *****************************************************************************/
PUBLIC int ispointer ( treenode *tptr )
{
  switch (TagOf(tptr))
    {
      /*{{{  N_DECL*/
      case N_DECL:
        return(isinvectorspace(tptr));
      /*}}}*/
      /*{{{  N_REPL*/
      case N_REPL:
        return(FALSE);
      /*}}}*/
      /*{{{  N_ABBR N_VALABBR N_RETYPE N_VALRETYPE N_PARAM N_VALPARAM*/
      case N_ABBR: case N_VALABBR:
      case N_RETYPE: case N_VALRETYPE:
      case N_PARAM:
      case N_VALPARAM:
        {
          int m = NModeOf(tptr);
          return(m == NM_POINTER || m == NM_VECSPACE);
        }
      /*}}}*/
      /*{{{  T_TEMP T_PREEVALTEMP*/
      case T_TEMP: case T_PREEVALTEMP:
        /*switch(NModeOf(tptr))
          {
            case NM_POINTER:   return(TRUE);
            case NM_WORKSPACE: return(FALSE);
          }*/
        return(NModeOf(tptr) == NM_POINTER);
      /*}}}*/
      /*{{{  S_FNFORMALRESULT*/
      case S_FNFORMALRESULT:
        return(TRUE);
      /*}}}*/
      /*{{{  S_STRING S_CONSTCONSTRUCTOR*/
      case S_STRING:
      case S_CONSTCONSTRUCTOR:
        return(TRUE);
      /*}}}*/
      /*{{{  S_CONSTRUCTOR*/
      /*}}}*/
      default:
        badtag(genlocn, TagOf(tptr), "ispointer");
    }
  return (FALSE); /* not reached */
}
/*}}}*/
/*{{{  PUBLIC int preeval(mode, opd)*/
/*****************************************************************************
 *
 *  preeval returns TRUE if (mode, opd) should be preevaluated in a
 *          temporary (in this case, opd will point to a tempnode),
 *          FALSE otherwise.
 *
 *****************************************************************************/
PUBLIC int preeval ( int mode , treenode *opd )
{
  return (((mode == P_EXP) || (mode == P_PTR)) &&
          (TagOf(opd) == T_TEMP));
}
/*}}}*/
/*{{{  PUBLIC int hasgreaterrange(type1, type2)*/
/*****************************************************************************
 *
 *  hasgreaterrange returns TRUE if type1 has a greater range than type2,
 *                  otherwise it returns FALSE.
 *                  It does not cope with REAL types.
 *
 *****************************************************************************/
PUBLIC int hasgreaterrange ( int type1 , int type2 )
{
  if (type1 == S_INT) type1 = targetintsize;
  if (type2 == S_INT) type2 = targetintsize;
  switch(type2)
    {
      case S_INT64: return  (FALSE);
      case S_INT32: return  (type1 == S_INT64);
      case S_INT16: return ((type1 == S_INT64) || (type1 == S_INT32));
      case S_BYTE:  return ((type1 != S_BYTE)  && (type1 != S_BOOL ));
      case S_BOOL:  return  (type1 != S_BOOL);
      default:      badtag(genlocn, type2, "hasgreaterrange");
    }
  return (FALSE); /* not reached */
}
/*}}}*/
/*{{{  PUBLIC int issignedtype(type)*/
/*****************************************************************************
 *
 *  issignedtype returns TRUE if 'type' is a signed type
 *
 *****************************************************************************/
PUBLIC int issignedtype ( int type )
{
  return((type != S_BOOL) && (type != S_BYTE));
}
/*}}}*/
/*{{{  PUBLIC BIT32 checkmask(type)*/
/*****************************************************************************
 *
 *  checkmask returns the constant to be used as operand when checking the
 *            range of integer/byte/boolean expressions
 *
 *****************************************************************************/
PUBLIC BIT32 checkmask ( int type )
{
  switch(type)
    {
      case S_BOOL:  return(BOOL_CHECK_MASK);
      case S_BYTE:  return(BYTE_CHECK_MASK);
      case S_INT16: return(INT16_CHECK_MASK);
      case S_INT32: return(INT32_CHECK_MASK);
      default:      badtag(genlocn, type, "checkmask"); return 0;
    }
}
/*}}}*/
/*{{{  PUBLIC BIT32 typemask(type)*/
/*****************************************************************************
 *
 *  typemask returns the constant to be used as operand when and'ing out the
 *           upper part of a partword signed type.
 *
 *****************************************************************************/
PUBLIC BIT32 typemask ( int type )
{
  switch(type)
    {
      case S_INT16: return(0xffff);
      default:      badtag(genlocn, type, "typemask"); return 0;
    }
}
/*}}}*/
/*{{{  PUBLIC int abbrevmode(tptr)*/
/*****************************************************************************
 *
 *  abbrevmode takes an abbreviation specification tree 'tptr' and returns
 *               AM_CONST if the abbreviation is a constant
 *               AM_ISRHS if the abbreviation is the same object as the rhs
 *               AM_PTR   if the abbreviation is a pointer to the rhs
 *               AM_VAL   if the abbreviation contains the value of the rhs
 *
 *****************************************************************************/
/*{{{  COMMENT note on how I do abbreviation*/
/**********************  Start comment out ****************************
@*{{{  note on how I do abbreviation*@
@*{{{  Definitions*@
The following BOOLs represent attributes of the abbreviation:

isvalabbrev    is TRUE for a VAL abbreviation

isconst        is TRUE if the RHS of a VAL abbreviation is constant

fitsinword     is TRUE if an object of the same type as the abbreviation
               can fit in a single machine word

iswordsize     is TRUE if an object of the same type as the abbreviation fits
               exactly into a word

hasconstantposn is TRUE if the workspace position of the RHS object is
               constant (ie. no variable array or segment subscripts)

isaddressable  is TRUE if the RHS of the abbreviation is an element

islocal        is TRUE if the RHS of the abbreviation is a local element

issimplelocal  is TRUE if the RHS of the abbreviation is a local name
               (N.B. issimplelocal implies isaddressable)
               (N.B. a local name subsequently placed is NOT local)

isinworkspace  is TRUE if the element on the RHS of the abbreviation is
               in workspace (as opposed to being in vector space)

Abbreviation modes:

A.PTR           the abbreviation is a pointer to an object
A.OBJECT        the abbreviation is the object itself
@*}}}*@
@*{{{  Algorithm for deciding abbreviation mode*@
IF
  @*{{{  val abbreviation*@
  isvalabbrev
    IF
      isconst
        -- The abbreviation is a constant
      issimplelocal
        -- The abbreviation is the RHS
        mode := A.OBJECT
      isaddressable AND islocal AND isinworkspace AND
        hasconstantposn
        -- The abbreviation is the RHS
        mode := A.OBJECT
      fitsinword
        -- Allocate a word for the abbreviation,
        -- evaluate RHS and store in this word
        mode := A.OBJECT
      isaddressable
        -- Allocate a word for the abbreviation,
        -- evaluate a pointer to RHS and store in this word
        mode := A.PTR
      TRUE
        -- Allocate number of words required to hold RHS,
        -- evaluate RHS into this space
        mode := A.OBJECT
  @*}}}*@
  @*{{{  var abbreviation*@
  TRUE
    IF
      issimplelocal
        -- The abbreviation  is the RHS
        mode := A.OBJECT
      isaddressable AND islocal AND isinworkspace AND hasconstantposn
        -- The abbreviation is the RHS
        mode := A.OBJECT
      TRUE
        -- Allocate a word for the abbreviation,
        -- evaluate a pointer to RHS and store in this word
        mode := A.PTR
  @*}}}*@
@*}}}*@
@*}}}*@
 **********************   End comment out  ****************************/
/*}}}*/
PUBLIC int abbrevmode ( treenode *tptr )
{
  treenode *name = DNameOf(tptr);
  treenode *rhs = DValOf(tptr);
  treenode *rhs_name = nameof(rhs); /* This is safe to do for any tag value */

  if (chanaspointer && (basetype(NTypeOf(name)) == S_CHAN))
    /*{{{  special case*/
    {
      if (TagOf(rhs) == S_ARRAYITEM ||
          (TagOf(rhs) != S_CONSTRUCTOR &&
           (ispointer(rhs_name) || isplaced(rhs_name))  /* added 11/12/90 for bug 1067 */
         ))
        return(AM_PTR);
      else
        return(AM_VAL);
    }
    /*}}}*/
  else if ((TagOf(tptr) == S_VALABBR) || (TagOf(tptr) == S_VALRETYPE))
    /*{{{  val abbreviation or retype*/
    {
      if (isconst(rhs))
        return(AM_CONST);
      else if (issimplelocal(rhs))
        return(AM_ISRHS);
      else if (istargetintsize(basetype(NTypeOf(name))) &&
               (TagOf(rhs) == S_ARRAYITEM) &&
               islocal(rhs_name) && !ispointer(rhs_name) &&
               /* It might have been a constructor put into a temp */
               TagOf(rhs_name) != T_TEMP &&
               (ASExpOf(rhs) == NULL))
        /* Optimisation to allow word-sized elements at a constant position
           of an array placed in local workspace to be used directly */
        return(AM_ISRHS);
      else if (fitsinregister(typeof(name)))
        return(AM_VAL);
      else if (isaddressable(rhs))
        return(AM_PTR);
      else
        return(AM_VAL);
    }
    /*}}}*/
  else
    /*{{{  var. abbreviation or retype*/
    {
      if (issimplelocal(rhs))
        return(AM_ISRHS);
      else if (istargetintsize(basetype(NTypeOf(name))) &&
               (TagOf(rhs) == S_ARRAYITEM) &&
               islocal(rhs_name) && !ispointer(rhs_name) &&
               TagOf(rhs_name) != T_TEMP &&
               (ASExpOf(rhs) == NULL))
        /* Optimisation to allow word-sized elements at a constant position
           of an array placed in local workspace to be used directly */
        return(AM_ISRHS);
      else if (basetype(NTypeOf(name)) == S_TIMER)
        return(AM_ISRHS);  /* 23/4/90 CO'N; bug 287; Stops it creating a pointer */
      else
        return(AM_PTR);
    }
    /*}}}*/
}
/*}}}*/
/*{{{  PRIVATE int set_vectorspace*/
PRIVATE int set_vectorspace(treenode *nptr)
{
  /* Put object in vector space if
     i.   vector space is enabled
     ii.  the object is large enough to warrant it
     iii. we don't want to load pointers to the object all the time
          eg. [4]INT16, [3]BYTE ...
  */
  /* Modified 29/1/91 to put ALL objects smaller than a word into workspace */
#if 0
  int invecspace = (TagOf(NTypeOf(nptr)) == S_ARRAY) && vsenabled
                && (   (bytesin(NTypeOf(nptr)) > MAX_WS_BYTES)
                    || (bytesinscalar(basetype(NTypeOf(nptr))) < bytesperword))
                && (basetype(NTypeOf(nptr)) != S_TIMER) /* Added 23/4/90 by CO'N to fix bug 287 */
                 ;
#else
  treenode *type = NTypeOf(nptr);
  int invecspace;
  int base = basetype(type);
  if ((TagOf(type) == S_ARRAY) && vsenabled && (base != S_TIMER))
    {
      const INT32 b = bytesin(type);
      invecspace =  (b > MAX_WS_BYTES) ||
                   ((b > bytesperword) && (bytesinscalar(base) < bytesperword));
    }
  else
    invecspace = FALSE;
#endif
  SetNMode(nptr, invecspace ? NM_VECSPACE : NM_WORKSPACE);
  return invecspace;
}
/*}}}*/
/*{{{  PUBLIC int isinvectorspace(nptr)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  isinvectorspace takes a namenode, nptr, and returns TRUE if the object is
 *                  in vector space, FALSE otherwise.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC int isinvectorspace ( treenode *nptr )
{
  switch (TagOf(nptr))
    {
      /*{{{  N_DECL*/
      case N_DECL:
        switch(NModeOf(nptr))
          {
            case NM_DEFAULT:  return set_vectorspace(nptr);
            case NM_VECSPACE: return(TRUE);
            default:          return(FALSE);
          }
      /*}}}*/
      /*{{{  N_ABBR N_VALABBR N_RETYPE N_VALRETYPE*/
      case N_ABBR: case N_VALABBR:
      case N_RETYPE: case N_VALRETYPE:
        switch(NModeOf(nptr))
          {
            /*{{{  NM_DEFAULT          return(invecspace)*/
            case NM_DEFAULT:
              if (abbrevmode(NDeclOf(nptr)) == AM_VAL)
                return set_vectorspace(nptr);
              else
                {
                  SetNMode(nptr, NM_WORKSPACE);
                  return FALSE;
                }
            /*}}}*/
            case NM_VECSPACE:        return(TRUE);
            default:                 return(FALSE);
          }
      /*}}}*/
      case T_TEMP:  case T_PREEVALTEMP: case T_RESERVEDWS:
      case N_PARAM: case N_VALPARAM:
      case N_REPL:
        return(FALSE);
      default:
        badtag(genlocn, TagOf(nptr), "isinvectorspace");
    }
  return (FALSE); /* not reached */
}
/*}}}*/
/*{{{  PUBLIC int isplaced(nptr)*/
/*****************************************************************************
 *
 *  isplaced returns TRUE if the symbol table entry nptr represents a PLACEd
 *           variable.
 *
 *****************************************************************************/
PUBLIC int isplaced ( treenode *nptr )
{
  return(NModeOf(nptr) == NM_PLACED);
}
/*}}}*/
/*{{{  PUBLIC int iswsplaced(nptr)*/
/*****************************************************************************
 *
 *  iswsplaced returns TRUE if the symbol table entry nptr has been PLACEd
 *             at a specific workspace offset.
 *
 *****************************************************************************/
PUBLIC int iswsplaced ( treenode *nptr )
{
  return(NModeOf(nptr) == NM_WSPLACED);
}
/*}}}*/
/*{{{  PUBLIC int ishiddenparam(param)*/
/*****************************************************************************
 *
 *  ishiddenparam takes a parameter node, 'param', and returns TRUE
 *                if it is a hidden parameter, FALSE otherwise.
 *
 *****************************************************************************/
PUBLIC int ishiddenparam ( treenode *param )
{
  switch(TagOf(param))
    {
      case S_PARAM_STATICLINK: case S_PARAM_VSP:
      case S_HIDDEN_PARAM:     case S_FNFORMALRESULT:
      case S_FNACTUALRESULT:
        return TRUE;
      default:
        return FALSE;
    }
}
/*}}}*/
/*{{{  PUBLIC treenode *consttableof(tptr)*/
/*****************************************************************************
 *
 * consttableof takes a S_VALABBR or S_VALRETYPE node
 *              and if it is an abbreviation of a
 *              constant table returns a pointer to the constant table node,
 *              otherwise retuns NULL.
 *
 *****************************************************************************/
PUBLIC treenode *consttableof ( treenode *tptr )
{
  treenode *t = DValOf(tptr);
  if ((TagOf(t) == S_STRING) || (TagOf(t) == S_CONSTCONSTRUCTOR))
    return(t);
  else
    return(NULL);
}
/*}}}*/
/*{{{  PUBLIC int isinlibrary (nptr)*/
/*****************************************************************************
 *
 *  isinlibrary returns TRUE if the namenode nptr represents a
 *              library entry point
 *
 *****************************************************************************/
PUBLIC int isinlibrary ( treenode *nptr )
{
  switch(TagOf(nptr))
    {
      case N_LIBPROCDEF:    case N_LIBFUNCDEF:
      case N_STDLIBPROCDEF: case N_STDLIBFUNCDEF:
        return TRUE;
      default:
        return FALSE;
    }
}
/*}}}*/
/*{{{  PUBLIC void applytovalofs(tptr, p)*/
/*{{{  comment*/
/*****************************************************************************
 *
 *  applytovalofs walks the expression tree 'tptr' looking for VALOFs.
 *                For each VALOF found, it calls the function 'p' with the
 *                VALOF tree as the parameter.
 *                N.B. we define the VALOF tree as including any leading
 *                specifications.
 *
 *****************************************************************************/
/*}}}*/
PUBLIC void applytovalofs ( treenode *tptr , void (*p )())
{
  while (tptr != NULL)
    switch(TagOf(tptr))
      {
        default:
          return;
        /*{{{  monadics                        break*/
        case S_NEG: case S_BITNOT: case S_SIZE:
          tptr = OpOf(tptr);
          break;
        /*}}}*/
        /*{{{  conversions                     break*/
        case S_EXACT: case S_ROUND: case S_TRUNC:
          tptr = OpOf(tptr);
          break;
        /*}}}*/
        /*{{{  dyadics                         break*/
        case S_AND: case S_OR:
        case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV: case S_REM:
        case S_BITAND: case S_BITOR: case S_XOR:
        case S_LSHIFT: case S_RSHIFT:
        case S_PLUS: case S_MINUS: case S_TIMES:
        case S_EQ: case S_NE: case S_LS: case S_LE: case S_GR: case S_GE:
        case S_AFTER:
        case S_COLON2:
        case S_CSUB0: case S_CCNT1: case S_EVAL:
          applytovalofs(LeftOpOf(tptr), p);
          tptr = RightOpOf(tptr);
          break;
        /*}}}*/
        /*{{{  constructor function call       return*/
        case S_CONSTRUCTOR:
        case S_FINSTANCE:
          {
            treenode *elist;
            elist = (TagOf(tptr) == S_CONSTRUCTOR) ? OpOf(tptr) : IParamListOf(tptr);
            while (!EndOfList(elist))
              {
                applytovalofs(ThisItem(elist), p);
                elist = NextItem(elist);
              }
            return;
          }
        /*}}}*/
        /*{{{  element subscript or segment    break*/
        case S_ARRAYITEM:
          tptr = ASExpOf(tptr);
          break;
        case S_SEGMENTITEM:
        case S_SEGMENT:
          applytovalofs(SNameOf(tptr), p);
          applytovalofs(SStartExpOf(tptr), p);
          tptr = SLengthExpOf(tptr);
          break;
        /*}}}*/
        /*{{{  specification ... valof         return*/
        case S_VALOF:
        case S_VALABBR: case S_ABBR:
        case S_VALRETYPE: case S_RETYPE:
        case S_TPROTDEF: case S_SPROTDEF:
        case S_DECL:
        case S_SFUNCDEF: case S_LFUNCDEF: case S_PROCDEF:
          (*p)(tptr);
          return;
        /*}}}*/
      }
}
/*}}}*/
/*{{{  PUBLIC treenode **dimexpaddr(tptr, dimension)*/
/*****************************************************************************
 *
 *  dimexpaddr returns a pointer to the dimension tree for the
 *             dimension'th dimension of element tptr.
 *             The first dimension is dimension 0.
 *
 *****************************************************************************/
PUBLIC treenode **dimexpaddr ( treenode *tptr , int dimension )
{
  while (TRUE)
    switch (TagOf(tptr))
      {
        /*{{{  ARRAYSUB ARRAYITEM       break*/
        case S_ARRAYITEM:
        case S_ARRAYSUB:
          dimension++;
          tptr = ASBaseOf(tptr);
          break;
        /*}}}*/
        /*{{{  SEGMENT SEGMENTITEM      break / return*/
        case S_SEGMENT:
        case S_SEGMENTITEM:
          /* The segment length may already have been evaluated into a temp,
             in which case dimexp will be a temp node */
          if (dimension == 0)
            return(SLengthExpAddr(tptr));
          else
            tptr = SNameOf(tptr);
          break;
        /*}}}*/
        /*{{{  CONSTCONSTRUCTOR         break*/
        case S_CONSTCONSTRUCTOR:
          tptr = CTExpOf(tptr);
          break;
        /*}}}*/
        /*{{{  CONSTRUCTOR              break / return*/
        case S_CONSTRUCTOR:
          if (dimension > 0)
            {
              tptr = ThisItem(OpOf(tptr));
              dimension--;
            }
          else
            return(OpAddr(newmopnode(S_DUMMYEXP, 0,
                            newconstexpnode(S_CONSTEXP, 0, dummyexp_p, ZERO32,
                                                    listitems(OpOf(tptr))),
                                     0)));
          break;
        /*}}}*/
        /*{{{  name                             return*/
        case N_VALABBR: case N_ABBR:
        case N_VALRETYPE: case N_RETYPE:
        case N_DECL:
        case N_VALPARAM: case N_PARAM:
        case T_TEMP: case T_PREEVALTEMP:
          tptr = NTypeOf(tptr);
          while (dimension > 0)
            {
              tptr = ARTypeOf(tptr);
              dimension--;
            }
          return(ARDimLengthAddr(tptr));
        /*}}}*/
        /*{{{  string*/
        case S_STRING:
          return(OpAddr(newmopnode(S_DUMMYEXP, 0,
                          newconstexpnode(S_CONSTEXP, 0, dummyexp_p, ZERO32,
                                 WLengthOf(CTValOf(tptr))),
                                   0)));
        /*}}}*/
        default:
          badtag(genlocn, TagOf(tptr), "dimexpaddr");
      }
}
/*}}}*/
/*{{{  PUBLIC int ptrmodeof(mode)*/
/*****************************************************************************
 *
 *  ptrmodeof converts an operand expression mode 'mode' to a pointer mode.
 *
 *****************************************************************************/
PUBLIC int ptrmodeof ( int mode )
{
  return((mode == P_EXP) ? P_PTR :
         (mode == P_TEMP) ? P_TEMPPTR :
         mode);
}
/*}}}*/
/*{{{  PUBLIC int tempmodeof(mode)*/
/*****************************************************************************
 *
 *  tempmodeof converts an operand mode 'mode' to a temporary mode.
 *
 *****************************************************************************/
PUBLIC int tempmodeof ( int mode )
{
  return((mode == P_EXP) ? P_TEMP :
         (mode == P_PTR) ? P_TEMPPTR :
         mode);
}
/*}}}*/
/*{{{  PUBLIC int usedin(t, tptr)*/
/*****************************************************************************
 *
 *  usedin checks if the element 't' is used or aliassed in the expression
 *         or list of expressions 'tptr'. Does not assume alias checking.
 *
 *****************************************************************************/
/*{{{  comment on definition of 'used or aliassed'*/
/*  For r := f(r) op exp :
    We want to evaluate f(r) and wish to know if we can assign the result
    directly into r.

We may not assign to r if:
  1. r' is used directly, or an alias is used directly, in exp
  2. if r' is a var. parameter and there are free variables (or other var.
     parameters) in exp
     Tighten this to  if r' is a var. parameter
  3. if r' is a free variable and there are var. parameters
where
  r' is the base decl. of r (unlocal-aliassed) (variable n in this function)
*/
/*}}}*/
PUBLIC int usedin ( treenode *t , treenode *tptr )
{
  treenode *n = basedecl(t);
  while(tptr != NULL)
    /*{{{  check n is not used or aliased in tptr*/
    switch (TagOf(tptr))
      {
        /*{{{  var abbreviation/retype*/
        case N_ABBR:          /* Check if used in the abbreviation */
        case N_RETYPE:        /* Check if used in the retype */
          if (n == tptr) return TRUE; /* bug 865 28/1/91 */
          tptr = DValOf(NDeclOf(tptr));
          break;
        /*}}}*/
        /*{{{  var parameter*/
        case N_PARAM:
          /* The expression contains a var parameter:
             if n is local we are ok, otherwise return FALSE. */
          return ((NLexLevelOf(n) != lexlevel) || (n == tptr));
          /* n is a free variable if its lexlevel is not the current lexlevel,
             otherwise n is local (n cannot be var. param) */
        /*}}}*/
        /*{{{  val abbrev/retype/param   constants   replicator*/
        case S_CONSTEXP:
        case S_STRING:
        case S_CONSTCONSTRUCTOR:
          return(FALSE);
        /*}}}*/
        /*{{{  decl*/
        case N_VALABBR:
        case N_VALRETYPE:
        case N_VALPARAM:
        case N_DECL:
        case N_REPL:
          return (n == tptr);      /* the name is the same n */
        /*}}}*/
        /*{{{  temporary*/
        case T_TEMP:
        case T_REGTEMP:
        case T_PREEVALTEMP:
          return(FALSE);
        /*}}}*/
        /*{{{  monadic operators constructor conversions*/
        case S_SIZE:
        case S_ELSIZE:
          return (FALSE);
        case S_NEG:
        case S_BITNOT:
        case S_NOT:
        case S_CONSTRUCTOR:
        case S_EXACT:
        case S_ROUND:
        case S_TRUNC:
          /*return (usedin(n, OpOf(tptr)));*/
          tptr = OpOf(tptr);
          break;
        /*}}}*/
        /*{{{  dyadic operators*/
        case S_AND: case S_OR:
        case S_ADD: case S_SUBTRACT: case S_MULT: case S_DIV: case S_REM:
        case S_BITAND: case S_BITOR: case S_XOR:
        case S_LSHIFT: case S_RSHIFT:
        case S_PLUS: case S_MINUS: case S_TIMES:
        case S_EQ: case S_NE: case S_LS: case S_LE: case S_GR: case S_GE: case S_AFTER:
        case S_CSUB0: case S_CCNT1: case S_EVAL:
        case S_COLON2:
          return (usedin(n, LeftOpOf(tptr)) || usedin(n, RightOpOf(tptr)));
        /*}}}*/
        /*{{{  array subscript*/
        case S_ARRAYITEM:
        case S_ARRAYSUB:
          return (usedin(n, ASBaseOf(tptr)) || usedin(n, ASExpOf(tptr)));
        /*}}}*/
        /*{{{  segment*/
        case S_SEGMENTITEM:
        case S_SEGMENT:
          return(usedin(n, SNameOf(tptr)) || usedin(n, SStartExpOf(tptr)) ||
                 usedin(n, SLengthExpOf(tptr)));
          break;
        /*}}}*/
        /*{{{  function instance*/
        case S_FINSTANCE:
          /* We say it's used if it is visible to the function,
             or if it is used in the parameter list */
          return(isafreevarof(n, INameOf(tptr)) ||
                 usedin(n, IParamListOf(tptr)));
        /*}}}*/
        /*{{{  specification ... valof*/
        case S_VALABBR: case S_VALRETYPE:
        case S_PROCDEF:
        case S_TPROTDEF: case S_SPROTDEF:
        case S_DECL:
        case S_SFUNCDEF: case S_LFUNCDEF:
        case S_ABBR: case S_RETYPE:
        case S_VALOF:
          /* Things are getting a bit complicated: take the easy option */
          return (TRUE);  /* Yes it is in danger of being used */
        /*}}}*/
        /*{{{  list    break / return*/
        case S_LIST:
          if (usedin(n, ThisItem(tptr)))
            return (TRUE);
          tptr = NextItem(tptr);
          break;
        /*}}}*/
        /*{{{  hidden parameters dummy expression*/
        case S_HIDDEN_PARAM:
        case S_PARAM_STATICLINK:
        case S_PARAM_VSP:
        case S_FNACTUALRESULT:
        case S_FNFORMALRESULT:
        case S_DUMMYEXP:
          return(FALSE);
        /*}}}*/
        default:
          badtag(genlocn, TagOf(tptr), "usedin");
      }
    /*}}}*/
  return(FALSE);
}
/*}}}*/
/*{{{  PUBLIC int usedinaddr(t, tptr)*/
/* Check if n is used or aliased in tptr. Cannot assume alias checking. */
/* As for usedin, except we only return TRUE if n is used as an array or
segment subscript in tptr.
tptr is an element or list of elements. */
PUBLIC int usedinaddr ( treenode *t , treenode *tptr )
{
  treenode *n = basedecl(t);
  while(tptr != NULL)
    /*{{{  check n is not used or aliassed in tptr*/
    switch (TagOf(tptr))
      {
        /*{{{  name*/
        case N_ABBR:
        case N_RETYPE:
        case N_PARAM:
        case N_VALABBR:
        case N_VALRETYPE:
        case N_VALPARAM:
        case N_REPL:
        case N_DECL:
          return(FALSE);
        /*}}}*/
        /*{{{  array subscript*/
        case S_ARRAYITEM:
        case S_ARRAYSUB:
          return (usedin(n, ASBaseOf(tptr)) || usedinaddr(n, ASExpOf(tptr)));
        /*}}}*/
        /*{{{  segment segment item*/
        case S_SEGMENTITEM:
        case S_SEGMENT:
          return(usedin(n, SStartExpOf(tptr)) || usedin(n, SLengthExpOf(tptr)) ||
                 usedinaddr(n, SNameOf(tptr)));
        /*}}}*/
        /*{{{  colon2*/
        case S_COLON2:
          return(usedinaddr(n, LeftOpOf(tptr)) || usedinaddr(n, RightOpOf(tptr)));
        /*}}}*/
        /*{{{  list*/
        case S_LIST:
          if (usedinaddr(n, ThisItem(tptr)))
            return (TRUE);
          else
            tptr = NextItem(tptr);
          break;
        /*}}}*/
        default:
          badtag(genlocn, TagOf(tptr), "usedinaddr");
      }
    /*}}}*/
  return(FALSE);
}
/*}}}*/
/*{{{  PUBLIC int usedinopd (opdmode, opd, exptree)*/
/* Check if (opdmode, opd) is used or aliased in exptree.
Cannot assume alias checking. */
/*{{{  comment on definition of 'used or aliassed'*/
/*  For r := f(r) op exp :
We want to evaluate f(r) and wish to know if we can assign the result
directly into r.

We may not assign to r if:
1. r' is used directly, or an alias is used directly, in exp
2. if r' is a var. parameter and there are free variables (or other var.
parameters) in exp
Tighten this to  if r' is a var. parameter
3. if r' is a free variable and there are var. parameters
where
r' is the base decl. of r (without local aliasses)
*/
/*}}}*/
PUBLIC int usedinopd ( int opdmode , treenode *opd , treenode *exptree )
{
  switch(opdmode)
    {
      case P_TEMP:
        {
          /* if mode of tempory is a pointer then it may be an abbreviation */
          if (NModeOf(opd) == NM_POINTER)
            return (usedin(NDeclOf(opd), exptree));
          else
            return (FALSE);                     /* A temporary cannot be needed */
        }
      case P_TEMPPTR:
        return (usedin(NDeclOf(opd), exptree));
      case P_EXP:
      case P_PTR:
        {
          treenode *n = basedecl(opd);
          if (TagOf(n) == N_PARAM)
            /* A var. param. is very unpredictable, so assume n is used */
            return (TRUE);
          else
            return(usedin(n, exptree));
        }
      default:
        geninternal_is(GEN_BAD_OPD, opdmode, "usedinopd");
        return (FALSE); /* not reached */
    }
}
/*}}}*/
/*{{{  PUBLIC int isconstopd (opdmode, opd)*/
/*****************************************************************************
 *
 *  isconstopd returns TRUE if (opdmode, opd) is constant)
 *
 *****************************************************************************/
PUBLIC int isconstopd ( int opdmode , treenode *opd )
{
  return((opdmode == P_EXP) && isconst(opd));
}
/*}}}*/
/*{{{  PUBLIC int directstore (destmode, dest)*/
/*****************************************************************************
 *
 *  directstore returns TRUE if we can store from a register directly into
 *              dest without loading a pointer first.
 *              Only ever called for word-length operands.
 *
 *****************************************************************************/
PUBLIC int directstore ( int destmode , treenode *dest )
{
  if (issimpleopd(destmode, dest))
    return(TRUE);
  if ((destmode == P_EXP) && (TagOf(dest) == S_ARRAYITEM))
    /* Constant subscript into local array in workspace where each element
       of the array occupies a whole number of words */
    {
      treenode *nptr = nameof(dest);
      if (!ispointer(nptr) && (ASExpOf(dest) == NULL) && islocal(nptr) &&
          (bytesinscalar(basetype(gettype(dest))) >= bytesperword))
        return(TRUE);
    }
  return(FALSE);
}
/*}}}*/
/*{{{  PUBLIC int directload (sourcemode, source)*/
/*****************************************************************************
 *
 *  directload returns TRUE if we can load (sourcemode, source) into a
 *             register without loading a pointer first.
 *             Only ever called for word-length operands.
 *
 *****************************************************************************/
PUBLIC int directload ( int sourcemode , treenode *source )
{
  /* The algorithm is the same for loading or storing */
  return directstore(sourcemode, source);
}
/*}}}*/
/*}}}*/
