/******************************************************************************
*
*  code1 declarations
*
******************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
*  %Z%%M% %I%
*
******************************************************************************/
/*}}}*/

extern int req_code_size;

/*{{{  routines*/
void compress_code PARMS((void));
void genprimary PARMS((int instruction, INT32 operand));
void genbranch PARMS((int instruction, int label));
void genjump PARMS((int label));
void genlabeldiff PARMS((int instruction, int label1, int label2));
void gensecondary PARMS((int instruction));
void checkerror PARMS((void));
void markdeadcode PARMS((void));
void mark_flag_clean PARMS((int fpu_not_int));
void genstartblock PARMS((void));
void setlab PARMS((int label));
void setsectionlab PARMS((int label));
void commentexp PARMS((treenode *tptr));
void gencomment0 PARMS((const char *c));
void gencomment1 PARMS((const char *c, BIT32 p1));
/* void gencomment2 PARMS((const char *c, BIT32 p1, BIT32 p2)); */
/* void gencomment3 PARMS((const char *c, BIT32 p1, BIT32 p2, BIT32 p3)); */
void add_entry_point PARMS((treenode *nptr));
void add_code_block PARMS((int l, const BYTE *p));
int genconstant PARMS((treenode *cptr));
void genstartjumptable PARMS((void));
void genjumptableentry PARMS((int instruction, int label));
void genendjumptable PARMS((void));
void gencasescale PARMS((int instruction));
void genfpuentry PARMS((int instruction));
void declarelabel PARMS((int label, BIT32 offset));
void add_to_libentries PARMS((treenode *nptr));
void genlibstubs PARMS((void));
void genlocate PARMS((treenode *address));
void genaddrfix PARMS((treenode *address, int label));
void genlibrpatch PARMS((void));
void genstartfile PARMS((const char filename[], int line));
void genendfile PARMS((int line));

int  get_padlen PARMS((int len, int alignment));
void genpadding PARMS((const int len));
int  endofsection_padlen PARMS((int alignment));
void alignendofsection PARMS((int alignment));
void alignwholemodule PARMS((void));

void initcode PARMS((void));
void freecode PARMS((void));

FILE *open_object_file PARMS((const char *filename));
void patch_jump PARMS((INT32 source_addr, INT32 target_addr));
void write_object_file PARMS((void));
void close_object_file PARMS((FILE *fptr, const char *filename));
/*}}}*/
