/*****************************************************************************
 *
 *  bind3 declarations
 *
 *****************************************************************************/

/*{{{  copyright*/
/******************************************************************************
*
*  occam 2 compiler
*
*  copyright Inmos Limited 1987
*
*  @(#)bind3def.h 1.5
*
******************************************************************************/
/*}}}*/

/*{{{  global variables*/
extern BIT32 vsp, maxvsp;
extern BIT32 datasize;
extern int staticlinkused;
extern INT32 loop_weight;
extern int var_base, num_var;
extern treenode *current_proc;

extern int alloc_strategy;
#define ALLOC_BYSCOPE     0x1
#define ALLOC_NOVSOPT     0x2
#define ALLOC_NOOPERANDS  0x4
#define ALLOC_NODIVBYSIZE 0x8
#define ALLOC_DEFAULT 0
/*}}}*/

/*{{{  routines*/
void initvsp PARMS((BIT32 n));
void setvsp PARMS((BIT32 n));
BIT32 newvs PARMS((BIT32 n));
void create_var PARMS((treenode *nptr));
void create_var_subsidiary PARMS((treenode *nptr));
void kill_var PARMS((treenode *nptr));
treenode *get_var PARMS((int n));
void resurrect_var PARMS((treenode *nptr));
int create_immortalvar PARMS((treenode *nptr));
treenode *alloc_fixedws PARMS((int slot, int size));
void free_fixedwslist PARMS((void));
INT32 allocsize PARMS((treenode *tptr));
void initallocvars PARMS((void));
int allocvars PARMS((int first_var, int free_paramslots, int inside_par));
void offsetvars PARMS((int first_var, int offset));
void addnamechain PARMS((treenode *chain, treenode *item));
void reservelowworkspace PARMS((INT32 n));
int newlab PARMS((void));
void initlabels PARMS((void));
void upusecount PARMS((treenode *nptr, INT32 n));
void addusecount PARMS((treenode *nptr, INT32 n));
void uploop_weight PARMS((INT32 n));
void alloctemp PARMS((treenode *tempptr));
treenode *newtempnode PARMS((int t, treenode *tptr, int mode));
treenode *newtypedtempnode
  PARMS((int t, treenode *tptr, int mode, treenode *type));
treenode *gettemp PARMS((treenode *tptr, int mode));
treenode *gettypedtemp PARMS((treenode *tptr, int mode, treenode *type));
treenode *getopdtemp PARMS((int opdmode, treenode *opd));
void freetemp PARMS((treenode *temp));
void freeiftemp PARMS((treenode *tptr));
void allocparams PARMS((treenode *nptr));
int *save_scope PARMS((void));
void restore_scope PARMS((int *scope));
treenode *resurrect_specs PARMS((treenode *tptr));
void init_mapping PARMS((void));

void initalloc PARMS((void));
#ifdef CONFIG
void freevarmap PARMS((void));
#endif
/*}}}*/
