/*{{{  module header */
/*
-- ----------------------------------------------------------------------------
--
--     Object Name : imstype.h
--     Revision    : 1
--
--     (c) Copyright INMOS Limited 1990.
--     All Rights Reserved.
--
--     DESCRIPTION
--         Standard INMOS header file for type definitions.
--
--     NOTES
--         None.
--
--     HISTORY
--         1-Aug-1990    Antony King    Created file.
--         1-Nov-1990    Antony King    Last change.
--
-- ----------------------------------------------------------------------------
*/
/*}}}*/

#ifndef _IMSTYPEH
/*{{{  not included header file */
#define _IMSTYPEH

/*{{{  constant definitions */
/*{{{  boolean truth values */
#ifndef TRUE
/*{{{   */
#define TRUE  1
#define FALSE 0
/*}}}*/
#endif
/*}}}*/

/*{{{  integer range values */
/*{{{  8 bit integer values */
#define BitsPerWord8  8
#define BytesPerWord8 1

#define MOSTPOS_INT8 127
#define MOSTNEG_INT8 ((-MOSTPOS_INT8) - 1)

#define MaxSignedInt8   MOSTPOS_INT8
#define MaxUnsignedInt8 0XFF

#define IntegerLimit8 ((MaxSignedInt8 / 10) - 1)
/*}}}*/

/*{{{  16 bit integer values */
#define BitsPerWord16  16
#define BytesPerWord16 2

#define MOSTPOS_INT16 32767
#define MOSTNEG_INT16 ((-MOSTPOS_INT16) - 1)

#define MaxSignedInt16   MOSTPOS_INT16
#define MaxUnsignedInt16 0XFFFF

#define IntegerLimit16 ((MaxSignedInt16 / 10) - 1)
/*}}}*/

/*{{{  32 bit integer values */
#define BitsPerWord32  32
#define BytesPerWord32 4

#define MOSTPOS_INT32 2147483647L
#define MOSTNEG_INT32 ((-MOSTPOS_INT32) - 1)

#define MaxSignedInt32   MOSTPOS_INT32
#define MaxUnsignedInt32 0XFFFFFFFFL

#define IntegerLimit32 ((MaxSignedInt32 / 10) - 1)
/*}}}*/
/*}}}*/

/*{{{  word selector values */
/*{{{  8 bit word values */
#define SignBit8  0X00000080L
#define LowBits8  0X000000FFL
#define HighBits8 0XFFFFFF00L
#define NegBits8  0XFFFFFF80L
/*}}}*/

/*{{{  16 bit word values */
#define SignBit16  0X00008000L
#define LowBits16  0X0000FFFFL
#define HighBits16 0XFFFF0000L
#define NegBits16  0XFFFF8000L
/*}}}*/

/*{{{  32 bit word values */
#define SignBit32  0X80000000L
#define LowBits32  0XFFFFFFFFL
#define HighBits32 0X00000000L
#define NegBits32  0X80000000L
/*}}}*/
/*}}}*/

/*{{{  useful 32 bit values */
#define ZERO32 0L
#define ONE32  1L
/*}}}*/
/*}}}*/

/*{{{  host compiler macros */
/*{{{  MS C specific macros */
#ifdef MSC
/*{{{   */
#define _HOSTTYPE /* Set host type flag */

typedef int                BOOL;

typedef void *             POINTER;

typedef char               CHAR;
typedef unsigned char      BYTE;

typedef signed int         INT;
typedef signed char        INT8;
typedef signed short int   INT16;
typedef signed long int    INT32;

typedef unsigned int       BIT;
typedef unsigned char      BIT8;
typedef unsigned short int BIT16;
typedef unsigned long int  BIT32;

#define VOID void /* Cannot typedef void */
/*}}}*/
#endif
/*}}}*/

/*{{{  DEC C specific macros */
#ifdef DEC
/*{{{   */
#define _HOSTTYPE /* Set host type flag */

typedef int                BOOL;

typedef void *             POINTER;

typedef char               CHAR;
typedef unsigned char      BYTE;

typedef int                INT;
typedef char               INT8;
typedef short int          INT16;
typedef long int           INT32;

typedef unsigned int       BIT;
typedef unsigned char      BIT8;
typedef unsigned short int BIT16;
typedef unsigned long int  BIT32;

#define VOID void /* Cannot typedef void */
/*}}}*/
#endif
/*}}}*/

/*{{{  3L C specific macros */
#ifdef LLL
/*{{{   */
#define _HOSTTYPE /* Set host type flag */

typedef int                BOOL;

typedef unsigned char *    POINTER;

typedef char               CHAR;
typedef unsigned char      BYTE;

typedef int                INT;
typedef char               INT8;
typedef short int          INT16;
typedef long int           INT32;

typedef unsigned int       BIT;
typedef unsigned char      BIT8;
typedef unsigned short int BIT16;
typedef unsigned long int  BIT32;

#define VOID void /* Cannot typedef void */
/*}}}*/
#endif
/*}}}*/

/*{{{  GNU C specific macros */
#ifdef GNU
/*{{{   */
#define _HOSTTYPE /* Set host type flag */

typedef int                BOOL;

typedef void *             POINTER;

typedef char               CHAR;
typedef unsigned char      BYTE;

typedef signed int         INT;
typedef signed char        INT8;
typedef signed short int   INT16;
typedef signed long int    INT32;

typedef unsigned int       BIT;
typedef unsigned char      BIT8;
typedef unsigned short int BIT16;
typedef unsigned long int  BIT32;

#define VOID void /* Cannot typedef void */
/*}}}*/
#endif
/*}}}*/

/*{{{  SUN C specific macros */
#ifdef SUN
/*{{{   */
#define _HOSTTYPE /* Set host type flag */

typedef int                BOOL;

typedef void *             POINTER;

typedef char               CHAR;
typedef unsigned char      BYTE;

typedef int                INT;
typedef char               INT8;
typedef short int          INT16;
typedef long int           INT32;

typedef unsigned int       BIT;
typedef unsigned char      BIT8;
typedef unsigned short int BIT16;
typedef unsigned long int  BIT32;

#define VOID void /* Cannot typedef void */
/*}}}*/
#endif
/*}}}*/

/*{{{  IMS C specific macros */
#ifdef IMS
/*{{{   */
#define _HOSTTYPE /* Set host type flag */

typedef int                BOOL;

typedef void *             POINTER;

typedef char               CHAR;
typedef unsigned char      BYTE;

typedef signed int         INT;
typedef signed char        INT8;
typedef signed short int   INT16;
typedef signed long int    INT32;

typedef unsigned int       BIT;
typedef unsigned char      BIT8;
typedef unsigned short int BIT16;
typedef unsigned long int  BIT32;

#define VOID void /* Cannot typedef void */
/*}}}*/
#endif
/*}}}*/
/*}}}*/

/*{{{  generic type defines */
#ifdef _HOSTTYPE
/*{{{   */
#undef _HOSTTYPE /* Reset host type flag */

typedef BIT   UINT;
typedef BIT8  UINT8;
typedef BIT16 UINT16;
typedef BIT32 UINT32;

typedef BIT   WORD;
typedef BIT8  WORD8;
typedef BIT16 WORD16;
typedef BIT32 WORD32;
/*}}}*/
#endif
/*}}}*/

/*{{{  manipulation defines */
#define GetMSBit(T) (((T) 1) << ((sizeof(T) * 8) - 1))

#define SetMSBit(V, T) ((T) ((V) | GetMSBit(T)))

#define ClrMSBit(V, T) ((T) ((V) & (~GetMSBit(T))))

#define TstMSBit(V, T) (((T) ((V) & GetMSBit(T))) == GetMSBit(T))
/*}}}*/
/*}}}*/
#endif
