/*{{{  module header */
/*
-- ----------------------------------------------------------------------------
--
--     Object Name : imsstd.h
--     Revision    : 1
--
--     (c) Copyright INMOS Limited 1990.
--     All Rights Reserved.
--
--     DESCRIPTION
--         Standard INMOS header file for standard includes.
--
--     NOTES
--         None.
--
--     HISTORY
--         1-Aug-1990    Antony King    Created file.
--         1-Nov-1990    Antony King    Last change.
--
-- ----------------------------------------------------------------------------
*/
/*}}}*/

#ifndef _IMSSTDH
/*{{{  not included header file */
#define _IMSSTDH

/*{{{  standard includes */
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>
/*}}}*/

/*{{{  host compiler macros */
/*{{{  MS C specific macros */
#ifdef MSC
/*{{{   */
#include <stdlib.h>
#include <stdarg.h>

#define EXIT_FAILURE 1
#define EXIT_SUCCESS 0

#define exit_repeat(Status) exit(Status)
/*}}}*/
#endif
/*}}}*/

/*{{{  DEC C specific macros */
#ifdef DEC
/*{{{   */
#include <stdlib.h>
#include <stdarg.h>

#define EXIT_FAILURE 42
#define EXIT_SUCCESS 1

#define exit_repeat(Status) exit(Status)
/*}}}*/
#endif
/*}}}*/

/*{{{  3L C specific macros */
#ifdef LLL
/*{{{   */
#include <stdlib.h>
#include <varargs.h>

#define EXIT_FAILURE 1
#define EXIT_SUCCESS 0

#define exit_repeat(Status) exit(Status)
/*}}}*/
#endif
/*}}}*/

/*{{{  GNU C specific macros */
#ifdef GNU
/*{{{   */
/*{{{  include <stdlib.h> */
#include <stdlib.h>
#include <unistd.h>

extern int unlink (char *);

#define remove(String) unlink(String)
/*}}}*/
#include <stdarg.h>

#define EXIT_FAILURE 1
#define EXIT_SUCCESS 0

#define exit_repeat(Status) exit(Status)
/*}}}*/
#endif
/*}}}*/

/*{{{  SUN C specific macros */
#ifdef SUN
/*{{{   */
/*{{{  include <stdlib.h> */
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2

extern char *getenv();

extern void exit();

extern int unlink();

#define remove(String) unlink(String)
/*}}}*/
#include <varargs.h>

#define EXIT_FAILURE 1
#define EXIT_SUCCESS 0

#define exit_repeat(Status) exit(Status)
/*}}}*/
#endif
/*}}}*/

/*{{{  IMS C specific macros */
#ifdef IMS
/*{{{   */
#include <stdlib.h>
#include <stdarg.h>

/*{{{  define exit_repeat */
#include <misc.h>

#include <host.h>
/*}}}*/
/*}}}*/
#endif
/*}}}*/
/*}}}*/
/*}}}*/
#endif
