/*  (c) Copyright 1989, 1990 INMOS Limited  */

/***************************************
*
*	Author:  Nigel Holder
*
*	Date:    20 April 1989
*		  2 April 1990    Added RTL_OPTIMISED
*		 24 May   1990    Added RTL_C_PLUSPLUS_BITS
*		 26 Sept  1990    Added RTL_HARRAY
*
*
*	Module name:	debughdr.h
*
*	Purpose:  Common header file for debug information.
*		  Defines RTL values as per document SW-0047.
*
***************************************/



#ifndef	__debughdr_h
#define	__debughdr_h


/*  ****  symbolic and code debug information  ****  */

#define		RTL_STARTFILE		(  0 )
#define		RTL_ENDFILE		(  1 )
#define		RTL_NEXTITEM		(  2 )
#define		RTL_WORKSPACE		(  3 )
#define		RTL_ENDSEG		(  4 )
#define		RTL_VARIABLE		(  5 )
#define		RTL_BEGSCOPE		(  6 )
#define		RTL_ENDSCOPE		(  7 )
#define		RTL_PROCEDURE		(  9 )
#define		RTL_CONSTANT		( 10 )
#define		RTL_FILENAME		( 11 )
#define		RTL_LIBPATCH		( 12 )
#define		RTL_VERSION		( 13 )
#define		RTL_CODEMARK		( 14 )
#define		RTL_ADDRESS_FIX		( 15 )
#define		RTL_LINEMARK		( 17 )
#define		RTL_PROFILENEXTITEM	( 18 )
#define		RTL_PROFILEMARK		( 19 )
#define		RTL_NOBREAKMARK		( 20 )
#define		RTL_NOBREAKNEXTITEM	( 21 )
#define		RTL_TYPEDEF		( 22 )
#define		RTL_OBJLENGTH		( 23 )
#define		RTL_ENUMMEMBER		( 24 )
#define		RTL_RECORDMEMBER	( 25 )
#define		RTL_VARIANTMEMBER	( 26 )
#define		RTL_PATHNAME		( 27 )

/*  ****  end of symbolic and code debug information  ****  */



/*  ****  segment types  ****  */

#define		RTL_SEGTYPE_PROC	( 1 )
#define		RTL_SEGTYPE_PAR		( 2 )
#define		RTL_SEGTYPE_REPL	( 3 )
#define		RTL_SEGTYPE_KERN	( 4 )
#define		RTL_SEGTYPE_MAIN	( 5 )
#define		RTL_SEGTYPE_RUN		( 6 )
#define		RTL_SEGTYPE_PRIPAR	( 7 )
#define		RTL_SEGTYPE_SEQ		( 8 )

/*  ****  end of segment types  ****  */



/*  ****  procedure types  ****  */

#define		RTL_PROCFLAG		( 0 )
#define		RTL_FUNCTIONFLAG	( 1 )
#define		RTL_SCPROCFLAG		( 2 )
#define		RTL_SCFUNCTIONFLAG	( 3 )
#define		RTL_LIBPROCFLAG		( 4 )
#define		RTL_LIBFUNCTIONFLAG	( 5 )
#define		RTL_FORWARDPROCFLAG	( 6 )
#define		RTL_FORWARDFUNCTIONFLAG	( 7 )

/*  ****  end of procedure types  ****  */




/*  ****  builtin types (must start at 0)  ****  */

#define		RTL_CHANNEL		(  0 )
#define		RTL_TIMER		(  1 )
#define		RTL_BOOLEAN		(  2 )
#define		RTL_BYTE		(  3 )
#define		RTL_INTEGER		(  4 )
#define		RTL_INT16		(  5 )
#define		RTL_INT32		(  6 )
#define		RTL_INT64		(  7 )
#define		RTL_REAL32		(  8 )
#define		RTL_REAL64		(  9 )
#define		RTL_PROTOCOL		( 10 )
#define		RTL_CASETAG		( 11 )
#define		RTL_PORT		( 12 )
#define		RTL_CHANPOINTER		( 13 )
#define		RTL_VOID		( 14 )
#define		RTL_INT8		( 15 )
#define		RTL_BIT16		( 16 )
#define		RTL_BIT32		( 17 )
#define		RTL_BIT64		( 18 )
#define		RTL_UINT		( 19 )
#define		RTL_FUNCPOINTER		( 20 )

#define		RTL_BUILTIN_TYPES	( 21 )

/*  ****  end of builtin types  ****  */



/*  ****  Type constructors  ****  */

#define		RTL_ARRAY		( 30 )
#define		RTL_POINTER		( 31 )
#define		RTL_ENUM		( 32 )
#define		RTL_RECORD		( 33 )
#define		RTL_VARIANT		( 34 )
#define		RTL_ALIAS		( 35 )
#define		RTL_QUALIFIER		( 36 )
#define		RTL_UNDEF		( 37 )
#define		RTL_HARRAY		( 38 )

/*  ****  end of Type constructors  ****  */



/*  ****  user Type reference numbers must start from this  ****  */
#define		RTL_MINUSERTYPE		( 50 )



/*  ****  access methods  ****  */

#define		RTL_CONST		(  1 )
#define		RTL_BYVAL		(  2 )
#define		RTL_BYREF		(  3 )
#define		RTL_PLACED		(  4 )
#define		RTL_VOIDACCESS		(  5 )
#define		RTL_LSB_BYVAL		(  6 )
#define		RTL_LSB_BYREF		(  7 )
#define		RTL_GSB_BYVAL		(  8 )
#define		RTL_GSB_BYREF		(  9 )
#define		RTL_OPTIMISED		( 10 )

/*  ****  end of access methods  ****  */



/*  ****  bits in Version field  ****  */

#define		RTL_NEXTITEM_BIT	( 1 << 0 ) 
#define		RTL_LINEMARK_BIT	( 1 << 1 ) 
#define		RTL_LANGUAGE_BITS	( (1 << 2) | (1 << 3) | (1 << 4) | \
					  (1 << 5) | (1 << 6) )
#define		RTL_REPLPAR_BIT		( 1 << 7 ) 
#define		RTL_CODEADDR_BIT	( 1 << 8 ) 
#define		RTL_PROCEDURE_BIT	( 1 << 9 ) 
#define		RTL_FILENAME_BIT	( 1 << 10) 
#define		RTL_COMPACTED_BIT	( 1 << 11) 
#define		RTL_ORDER_BIT		( 1 << 12 )
#define		RTL_3LICB_BIT		( 1 << 13 ) 
#define		RTL_VIRTUAL_LINK_BIT	( 1 << 14 ) 
#define		RTL_NULL_POINTER_BIT	( 1 << 15 ) 


#define		RTL_OCCAM_BITS		( 0 )
#define		RTL_C_BITS		( 1 << 2 )
#define		RTL_PASCAL_BITS		( 1 << 3 )
#define		RTL_FORTRAN_BITS	( (1 << 3) | (1 << 2) )
#define		RTL_ASSEMBLER_BITS	( 1 << 4 )
#define		RTL_ADA_BITS		( (1 << 4) | (1 << 2) )
#define		RTL_MODULA_2_BITS	( (1 << 4) | (1 << 3) )
#define		RTL_IMP_BITS		( (1 << 4) | (1 << 3) | (1 << 2) )
#define		RTL_C_PLUSPLUS_BITS	( 1 << 5 )

/*  ****  end of bits in Version field  ****  */



/*  ****  qualifier bit fields  ****  */

#define		RTL_CONSTANT_QUALIFIER	( 1 << 0 )
#define		RTL_VOLATILE_QUALIFIER	( 1 << 1 )
#define		RTL_NOALIAS_QUALIFIER	( 1 << 2 )

/*  ****  end of qualifier bit fields  ****  */



#endif	/*  !__debughdr_h  */
