#include "extlib.h"

/*{{{  static procedures */
/*{{{  ValidDigit */
#ifdef ANSI
PRIVATE INT ValidDigit (BOOL *Valid, INT Ch)
#else
PRIVATE INT ValidDigit (Valid, Ch)
    INT Ch;
    BOOL *Valid;
#endif
{
    if (isdigit(Ch))
    {
        /*{{{   */
        *Valid = TRUE;
        return(Ch - '0');
        /*}}}*/
    }
    else
    {
        /*{{{   */
        *Valid = FALSE;
        return(Ch);
        /*}}}*/
    }
}
/*}}}*/

/*{{{  ValidHexDigit */
#ifdef ANSI
PRIVATE INT ValidHexDigit (BOOL *Valid, INT Ch)
#else
PRIVATE INT ValidHexDigit (Valid, Ch)
    INT Ch;
    BOOL *Valid;
#endif
{
    if (isxdigit(Ch))
    {
        /*{{{   */
        *Valid = TRUE;
        
        if (isdigit(Ch))
            return(Ch - '0');
        else if (isupper(Ch))
            return((Ch - 'A') + 10);
        else
            return((Ch - 'a') + 10);
        /*}}}*/
    }
    else
    {
        /*{{{   */
        *Valid = FALSE;
        return(Ch);
        /*}}}*/
    }
}
/*}}}*/

/*{{{  ValidOctDigit */
#ifdef ANSI
PRIVATE INT ValidOctDigit (BOOL *Valid, INT Ch)
#else
PRIVATE INT ValidOctDigit (Valid, Ch)
    INT Ch;
    BOOL *Valid;
#endif
{
    if (('0' <= Ch) && (Ch <= '7'))
    {
        /*{{{   */
        *Valid = TRUE;
        return(Ch - '0');
        /*}}}*/
    }
    else
    {
        /*{{{   */
        *Valid = FALSE;
        return(Ch);
        /*}}}*/
    }
}
/*}}}*/

/*{{{  GetChar */
#ifdef ANSI
PRIVATE INT GetChar (CHAR String[], INT StringSize, INT *CharsScanned)
#else
PRIVATE INT GetChar (String, StringSize, CharsScanned)
    CHAR String[];
    INT StringSize, *CharsScanned;
#endif
{
    if ((*CharsScanned >= StringSize) || (String[*CharsScanned] == '\0'))
    {
        /*{{{   */
        (*CharsScanned)++;
        return(' ');
        /*}}}*/
    }
    else
        return(String[(*CharsScanned)++]);
}
/*}}}*/

/*{{{  DScaleX */
#define Bias10_32  4
#define Table10_32 27

#ifdef ANSI
PRIVATE VOID DScaleX (INT32 *Xexp, INT32 Xfrac[], INT32 Scale)
#else
PRIVATE VOID DScaleX (Xexp, Xfrac, Scale)
    INT32 *Xexp, Xfrac[], Scale;
#endif
{
    /*{{{  constant table definitions */
    PRIVATE INT32 PowerTenFrac[] =
    {
        /*{{{   */
        0X00000000, 0X80000000, 0X00000000, 0XA0000000,
        0X00000000, 0XC8000000, 0X00000000, 0XFA000000,
        0X00000000, 0X9C400000, 0X00000000, 0XC3500000,
        0X00000000, 0XF4240000, 0X00000000, 0X98968000,
        0X00000000, 0XBEBC2000, 0X00000000, 0XEE6B2800,
        0X00000000, 0X9502F900, 0X00000000, 0XBA43B740,
        0X00000000, 0XE8D4A510, 0X00000000, 0X9184E72A,
        0X80000000, 0XB5E620F4, 0XA0000000, 0XE35FA931,
        0X04000000, 0X8E1BC9BF, 0XC5000000, 0XB1A2BC2E,
        0X76400000, 0XDE0B6B3A, 0X89E80000, 0X8AC72304,
        0XAC620000, 0XAD78EBC5, 0X177A8000, 0XD8D726B7,
        0X6EAC9000, 0X87867832, 0X0A57B400, 0XA968163F,
        0XCCEDA100, 0XD3C21BCE, 0X401484A0, 0X84595161,
        0X9019A5C8, 0XA56FA5B9, 0XF4200F3A, 0XCECB8F27
        /*}}}*/
    };
    
    PRIVATE INT32 PowerTenExp[] =
    {
        /*{{{   */
         0,  3,  6,  9, 13, 16, 19, 23, 26, 29, 33, 36, 39, 43,
        46, 49, 53, 56, 59, 63, 66, 69, 73, 76, 79, 83, 86, 89
        /*}}}*/
    };
    
    PRIVATE INT32 BiasTenFrac[] =
    {
        /*{{{   */
                 0,          0, 0XF4200F3A, 0XCECB8F27, 0XCFE20766,
        0XD0CF4B50, 0X1A708DEA, 0XDA01EE64, 0XBD203E41, 0X9F79A169
        /*}}}*/
    };
    
    PRIVATE INT32 BiasTenExp[] = {0, 89, 182, 358, 684};
    
    PRIVATE INT32 BiasTen[] = {0, 27, 55, 108, 206};
    /*}}}*/

    INT32 Carry, Guard, N, Places, S, Zexp, Zfrac[2];

    if (Scale < ZERO32)
        S = -Scale;
    else
        S = Scale;

    Zexp = ZERO32;
    Zfrac[1] = SignBit32;
    Zfrac[0] = ZERO32;

    N = Bias10_32;
    while (N >= ZERO32)
    {
        /*{{{   */
        if ((N > ZERO32) && (S < BiasTen[N]))
            N = N - ONE32;
        else
        {
            /*{{{   */
            if ((N == ZERO32) && (S <= Table10_32))
            {
                /*{{{   */
                RealIMul(Zfrac, &Guard, PowerTenFrac[(S + S) + ONE32], PowerTenFrac[S + S]);
                Zexp = (Zexp + PowerTenExp[S]) + ONE32;
                /*}}}*/
            }
            else
            {
                /*{{{   */
                RealIMul(Zfrac, &Guard, BiasTenFrac[(N + N) + ONE32], BiasTenFrac[N + N]);
                S = S - BiasTen[N];
                Zexp = (Zexp + BiasTenExp[N]) + ONE32;
                /*}}}*/
            }
            
            NORMALISE((BIT32 *) &Places,
                      (BIT32 *) &Zfrac[1], (BIT32 *) &Carry, Zfrac[1], Zfrac[0]);
            SHIFTLEFT((BIT32 *) &Zfrac[0], (BIT32 *) &Guard, Zfrac[0], Guard, Places);
            
            Zexp = Zexp - Places;
            
            if ((Guard & SignBit32) == ZERO32)
                ;
            else
            {
                /*{{{   */
                LONGSUM((BIT32 *) &Carry, (BIT32 *) &Zfrac[0], Zfrac[0], ONE32, ZERO32);
                LONGSUM((BIT32 *) &Carry, (BIT32 *) &Zfrac[1], Zfrac[1], ZERO32, Carry);
                
                if (Carry != ZERO32)
                {
                    /*{{{   */
                    Zexp = Zexp + ONE32;
                    Zfrac[1] = SignBit32;
                    /*}}}*/
                }
                /*}}}*/
            }
            N = N - ONE32;
            /*}}}*/
        }
        /*}}}*/
    }

    if (S > Table10_32)
    {
        /*{{{   */
        if (Scale > ZERO32)
            *Xexp = DRealExp;
        else
            *Xexp = -DRealExp;
        
        Xfrac[1] = SignBit32;
        /*}}}*/
    }
    else if (Scale < ZERO32)
    {
        /*{{{   */
        *Xexp = *Xexp - Zexp;
        
        SHIFTRIGHT((BIT32 *) &Xfrac[1], (BIT32 *) &Xfrac[0], Xfrac[1], Xfrac[0], ONE32);
        
        Guard = ZERO32;
        Carry = ZERO32;
        
        RealIDiv(&Xfrac[1], &Xfrac[1], &Xfrac[0], &Guard, Zfrac);
        RealIDiv(&Xfrac[0], &Xfrac[0], &Guard, &Carry, Zfrac);
        
        SHIFTRIGHT((BIT32 *) &Zfrac[1], (BIT32 *) &Zfrac[0], Zfrac[1], Zfrac[0], ONE32);
        LONGDIFF((BIT32 *) &Carry, (BIT32 *) &N, Carry, Zfrac[0], ZERO32);
        LONGDIFF((BIT32 *) &Carry, (BIT32 *) &N, Guard, Zfrac[1], Carry);
        
        if (Carry == ZERO32)
            Guard = SignBit32;
        else
            Guard = ZERO32;
        /*}}}*/
    }
    else
    {
        /*{{{   */
        *Xexp = (*Xexp + Zexp) + ONE32;
        RealIMul(Xfrac, &Guard, Zfrac[1], Zfrac[0]);
        /*}}}*/
    }

    NORMALISE((BIT32 *) &Places,
              (BIT32 *) &Xfrac[1], (BIT32 *) &Carry, Xfrac[1], Xfrac[0]);
    SHIFTLEFT((BIT32 *) &Xfrac[0], (BIT32 *) &Guard, Xfrac[0], Guard, Places);

    *Xexp = *Xexp - Places;

    if ((Guard & SignBit32) == ZERO32)
        ;
    else
    {
        /*{{{   */
        LONGSUM((BIT32 *) &Carry, (BIT32 *) &Xfrac[0], Xfrac[0], ONE32, ZERO32);
        LONGSUM((BIT32 *) &Carry, (BIT32 *) &Xfrac[1], Xfrac[1], ZERO32, Carry);
        
        if (Carry)
            *Xexp = *Xexp + ONE32;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  ScaleX */
#define Bias10   3
#define Table10 13

#ifdef ANSI
PRIVATE VOID ScaleX (INT32 *Xexp, INT32 *Xfrac, INT32 Scale)
#else
PRIVATE VOID ScaleX (Xexp, Xfrac, Scale)
    INT32 *Xexp, *Xfrac, Scale;
#endif
{
    /*{{{  constant table definitions */
    PRIVATE INT32 PowerTenFrac[] =
    {
        /*{{{   */
        0X80000000, 0XA0000000,
        0XC8000000, 0XFA000000,
        0X9C400000, 0XC3500000,
        0XF4240000, 0X98968000,
        0XBEBC2000, 0XEE6B2800, 
        0X9502F900, 0XBA43B740,
        0XE8D4A510, 0X9184E72A
        /*}}}*/
    };
    
    PRIVATE INT32 PowerTenExp[] =
    {
        /*{{{   */
        0, 3, 6, 9, 13, 16, 19, 23, 26, 29, 33, 36, 39, 43
        /*}}}*/
    };
    
    PRIVATE INT32 BiasTenFrac[] = {0X9184E72A, 0XCECB8F28, 0XEB194F8E};
    
    PRIVATE INT32 BiasTenExp[] = {43, 89, 132};
    
    PRIVATE INT32 BiasTen[] = {14, 28, 41, 54};
    /*}}}*/
    
    INT32 Carry, N, Places, Sb, St, Zexp, Zfrac;
    
    if (Scale < ZERO32)
        St = -Scale;
    else
        St = Scale;

    if (St <= Table10)
    {
        /*{{{   */
        Zexp = PowerTenExp[St];
        Zfrac = PowerTenFrac[St];
        /*}}}*/
    }
    else if (St == (BiasTen[1] - ONE32))
    {
        /*{{{   */
        Zexp = BiasTenExp[1];
        Zfrac = BiasTenFrac[1];
        /*}}}*/
    }
    else
    {
        /*{{{   */
        INT Index;
        
        Sb = -ONE32;
        
        for (Index = 0; Index < Bias10; Index++)
        {
            /*{{{   */
            if (St < BiasTen[Index + 1])
            {
                /*{{{   */
                Sb = Index;
                break;
                /*}}}*/
            }
            /*}}}*/
        }
        
        if (Sb < ZERO32)
            Zexp = -ONE32;
        else
        {
            /*{{{   */
            St = (St - BiasTen[Sb]) + ONE32;
            Zexp = (PowerTenExp[St] + BiasTenExp[Sb]) + ONE32;
            
            LONGPROD((BIT32 *) &Zfrac, (BIT32 *) &Carry,
                      PowerTenFrac[St], BiasTenFrac[Sb], ZERO32);
            NORMALISE((BIT32 *) &Places, (BIT32 *) &Zfrac, (BIT32 *) &Carry, Zfrac, Carry);
            
            Zexp = Zexp - Places;
            /*}}}*/
        }
        /*}}}*/
    }

    if (Zexp < ZERO32)
    {
        /*{{{   */
        if (Scale < ZERO32)
            *Xexp = -RealExp;
        else
            *Xexp = RealExp;
        
        *Xfrac = SignBit32;
        /*}}}*/
    }
    else if (Scale < ZERO32)
    {
        /*{{{   */
        *Xexp = *Xexp - Zexp;
        
        LONGDIV((BIT32 *) Xfrac, (BIT32 *) &Carry,
                (*Xfrac >> ONE32) & MOSTPOS_INT32, ZERO32, Zfrac);
        LONGDIFF((BIT32 *) &Carry, (BIT32 *) &N, Carry,
                 (Zfrac >> ONE32) & MOSTPOS_INT32, ZERO32);
        
        if (Carry != ZERO32)
            Carry = ZERO32;
        else
            Carry = SignBit32;
        /*}}}*/
    }
    else
    {
        /*{{{   */
        *Xexp = (*Xexp + Zexp) + ONE32;
        LONGPROD((BIT32 *) Xfrac, (BIT32 *) &Carry, *Xfrac, Zfrac, ZERO32);
        /*}}}*/
    }
    
    NORMALISE((BIT32 *) &Places,
              (BIT32 *) Xfrac, (BIT32 *) &Carry, *Xfrac, Carry);

    *Xexp = *Xexp - Places;
    
    if (Carry & SignBit32)
    {
        /*{{{   */
        LONGSUM((BIT32 *) &Carry, (BIT32 *) Xfrac, *Xfrac, ONE32, ZERO32);
        
        if (Carry != ZERO32)
        {
           /*{{{   */
           *Xexp = *Xexp + ONE32;
           *Xfrac = SignBit32;
           /*}}}*/
        }
        /*}}}*/
    }
}
/*}}}*/
/*}}}*/

/*{{{  global procedures */
/*{{{  RealIMul */
#ifdef ANSI
PUBLIC VOID RealIMul (INT32 X[2], INT32 *Guard, INT32 Hi, INT32 Lo)
#else
PUBLIC VOID RealIMul (X, Guard, Hi, Lo)
    INT32 X[2], *Guard, Hi, Lo;
#endif
{
    BIT32 Carry, D[4];

    LONGPROD(&Carry, &D[0], X[0], Lo, ZERO32);
    LONGPROD(&Carry, &D[1], X[0], Hi, Carry);
    LONGPROD(&D[3], &D[2], X[1], Lo, ZERO32);
    LONGPROD((BIT32 *) &X[1], (BIT32 *) &X[0], X[1], Hi, Carry);
    LONGSUM(&Carry, (BIT32 *) Guard, D[2], D[1], ZERO32);
    LONGSUM(&Carry, (BIT32 *) &X[0], X[0], D[3], Carry);
    LONGSUM(&Carry, (BIT32 *) &X[1], X[1], ZERO32, Carry);

    if (D[0] == ZERO32)
        ;
    else
        *Guard = *Guard | ONE32;
}
/*}}}*/

/*{{{  RealIDiv */
#ifdef ANSI
PUBLIC VOID RealIDiv (INT32 *Quot, INT32 *Hi, INT32 *Lo, INT32 *Guard, INT32 Yfrac[2])
#else
PUBLIC VOID RealIDiv (Quot, Hi, Lo, Guard, Yfrac)
    INT32 *Quot, *Hi, *Lo, *Guard, Yfrac[2];
#endif
{
  BIT32 Carry, Q, W[3];

    if (Yfrac[1] == *Hi)
        Q = MaxUnsignedInt32;
    else
        LONGDIV(&Q, &Carry, *Hi, *Lo, Yfrac[1]);

    if (Q != ZERO32)
    {
        /*{{{   */
        LONGPROD(&W[1], &W[0], Q, Yfrac[0], ZERO32);
        LONGPROD(&W[2], &W[1], Q, Yfrac[1], W[1]);
        LONGDIFF(&Carry, (BIT32 *) Guard, *Guard, W[0], ZERO32);
        LONGDIFF(&Carry, (BIT32 *) Lo, *Lo, W[1], Carry);
        LONGDIFF(&Carry, (BIT32 *) Hi, *Hi, W[2], Carry);
        
        while ((*Hi & SignBit32) != ZERO32)
        {
            /*{{{   */
            LONGDIFF(&Carry, &Q, Q, ONE32, ZERO32);
            LONGSUM(&Carry, (BIT32 *) Guard, *Guard, Yfrac[0], ZERO32);
            LONGSUM(&Carry, (BIT32 *) Lo, *Lo, Yfrac[1], Carry);
            LONGSUM(&Carry, (BIT32 *) Hi, *Hi, ZERO32, Carry);
            /*}}}*/
        }
        /*}}}*/
    }
    *Quot = Q;
}
/*}}}*/

/*{{{  StrToR64 */
#ifdef ANSI
PUBLIC VOID StrToR64 (BOOL *Error, BIT32 *Xhi, BIT32 *Xlo, CHAR *String)
#else
PUBLIC VOID StrToR64 (Error, Xhi, Xlo, String)
    BOOL *Error;
    CHAR *String;
    BIT32 *Xhi, *Xlo;
#endif
{
    BOOL More, Neg;
    INT Ch, StringSize, Index, CharsScanned;
    INT32 Carry, Guard, Lost, M[2], N[2], Xfrac[2], Scale, Xexp;

    Neg = FALSE;
    *Error = FALSE;
    CharsScanned = 0;

    StringSize = strlen(String);
    Ch = GetChar (String, StringSize, &CharsScanned);

    if ((Ch == '-') || (Ch == '+'))
    {
        /*{{{   */
        Neg = (Ch == '-');
        Ch = GetChar(String, StringSize, &CharsScanned);
        /*}}}*/
    }

    Scale = ZERO32;
    N[0] = ZERO32;
    N[1] = ZERO32;
    M[0] = ZERO32;
    M[1] = ZERO32;
    Carry = ZERO32;
    Lost = ZERO32;
    
    Ch = ValidDigit(&More, Ch);
    for (Index = -1; Index < 1; Index++)
    {
      /*{{{   */
      if ((Index == 0) && (Ch == '.'))
      {
          /*{{{   */
          Ch = GetChar(String, StringSize, &CharsScanned);
          Ch = ValidDigit(&More, Ch);
          /*}}}*/
      }
      
      *Error = *Error || (! More);
      
      while (More)
      {
          /*{{{   */
          if (Index == 0)
              Scale = Scale - ONE32;
          
          if (Carry == ZERO32)
          {
              /*{{{   */
              RealIMul(M, &Guard, 10L, ZERO32);
              if (M[1] == ZERO32)
              {
                  /*{{{   */
                  LONGSUM((BIT32 *) &Carry, (BIT32 *) &Guard, Guard, (BIT32) Ch, ZERO32);
                  LONGSUM((BIT32 *) &M[1], (BIT32 *) &M[0], M[0], ZERO32, Carry);
                  /*}}}*/
              }
              
              Carry = M[1];
              if (Carry == ZERO32)
              {
                  /*{{{   */
                  M[1] = M[0];
                  M[0] = Guard;
                  N[1] = M[1];
                  N[0] = M[0];
                  /*}}}*/
              }
              else
              {
                  /*{{{   */
                  Lost = Lost | Ch;
                  Scale = Scale + ONE32;
                  /*}}}*/
              }
              /*}}}*/
          }
          else
          {
              /*{{{   */
              Lost = Lost | Ch;
              Scale = Scale + ONE32;
              /*}}}*/
          }
          
          Ch = GetChar(String, StringSize, &CharsScanned);
          Ch = ValidDigit(&More, Ch);
          /*}}}*/
      }
      /*}}}*/
    }
    
    if (Ch == 'E')
    {
        /*{{{   */
        Guard = ZERO32;
        
        Ch = GetChar(String, StringSize, &CharsScanned);
        if ((Ch == '+') || (Ch == '-'))
        {
            /*{{{   */
            if (Ch == '-')
                Guard = ONE32;
            
            Ch = GetChar(String, StringSize, &CharsScanned);
            /*}}}*/
        }
        else
            *Error = TRUE;
        
        Xexp = ZERO32;
        Ch = ValidDigit(&More, Ch);
        *Error = *Error || (! More);
        
        while (More)
        {
            /*{{{   */
            if (IntegerLimit32 >= Xexp)
            {
                /*{{{   */
                Xexp = (Xexp * 10L) + Ch;
                Ch = GetChar(String, StringSize, &CharsScanned);
                Ch = ValidDigit(&More, Ch);
                /*}}}*/
            }
            else
            {
                /*{{{   */
                INT StillChecking = TRUE;
                
                More = FALSE;
                Scale = ZERO32;
                Xexp = MOSTPOS_INT32;
                
                while (StillChecking)
                {
                    /*{{{   */
                    Ch = GetChar(String, StringSize, &CharsScanned);
                    Ch = ValidDigit(&StillChecking, Ch);
                    /*}}}*/
                }
                /*}}}*/
            }
            /*}}}*/
        }
        
        if (Guard == ZERO32)
            Scale = Scale + Xexp;
        else
            Scale = Scale - Xexp;
        /*}}}*/
    }
    
    Xexp = ZERO32;
    if ((N[1] | N[0]) == ZERO32)
        ;
    else
    {
        /*{{{   */
        NORMALISE((BIT32 *) &Carry,
                  (BIT32 *) &Xfrac[1], (BIT32 *) &Xfrac[0], N[1], N[0]);
        
        Xexp = Xexp + ((BitsPerWord32 * 2) - (Carry + ONE32));
        
        if (Scale != ZERO32)
            DScaleX(&Xexp, Xfrac, Scale);
        Xexp = Xexp + DRealXcess;
        
        if (Xexp >= DRealExp)
        {
            /*{{{   */
            N[1] = DRealInf;
            N[0] = ZERO32;
            
            /* NOTE: remove this line if overflow is OK */
            
            *Error = TRUE;
            /*}}}*/
        }
        else
        {
            /*{{{   */
            if (Xexp <= ZERO32)
            {
                /*{{{   */
                SHIFTRIGHT((BIT32 *) &Xfrac[1], (BIT32 *) &Xfrac[0],
                           Xfrac[1], Xfrac[0], ONE32 - Xexp);
                SHIFTRIGHT((BIT32 *) &Guard, (BIT32 *) &Carry,
                           Xfrac[0], ZERO32, ONE32 - Xexp);
                
                Xexp = ZERO32;
                Lost = Lost | Carry;
                
                /* NOTE: remove this line if underflow is OK */
                
                *Error = TRUE;
                /*}}}*/
            }
            
            if (Lost)
                Xfrac[0] = Xfrac[0] | ONE32;
            
            SHIFTRIGHT((BIT32 *) &Carry, (BIT32 *) &N[0],
                       Xfrac[1], Xfrac[0], (BIT32) DRealShift);
            SHIFTRIGHT((BIT32 *) &Carry, (BIT32 *) &N[1], 
                       Xexp, Xfrac[1] << ONE32, (BIT32) (DRealShift + ONE32));
            
            if ((Xfrac[0] & DRealRBit) == ZERO32)
                ;
            else if ((Xfrac[0] & ((DRealRBit << ONE32) | DRealXcess)) == ZERO32)
                ;
            else
            {
                /*{{{   */
                LONGSUM((BIT32 *) &Carry, (BIT32 *) &N[0], N[0], ONE32, ZERO32);
                LONGSUM((BIT32 *) &Carry, (BIT32 *) &N[1], N[1], ZERO32, Carry);
                /*}}}*/
            }
            /*}}}*/
        }
        /*}}}*/
    }
    
    if (Neg)
        *Xhi = N[1] | SignBit32;
    else
        *Xhi = N[1];
    *Xlo = N[0];

    if (*Error)
    {
        /*{{{   */
        *Xhi = DRealNaNHi;
        *Xlo = DRealNaNLo;
        /*}}}*/
    }
    *Error = *Error || (CharsScanned <= StringSize);
}
/*}}}*/

/*{{{  StrToR32 */
#ifdef ANSI
PUBLIC VOID StrToR32 (BOOL *Error, BIT32 *Xout, CHAR *String)
#else
PUBLIC VOID StrToR32 (Error, Xout, String)
    BOOL *Error;
    BIT32 *Xout;
    CHAR *String;
#endif
{
    BOOL More, Neg;
    INT Ch, Index, CharsScanned, StringSize;
    INT32 X, Carry, Lost, M, N, Scale, Xexp, Xfrac;

    StringSize = strlen(String);
    
    Neg = FALSE;
    *Error = FALSE;
    CharsScanned = 0;

    Ch = GetChar(String, StringSize, &CharsScanned);
    if ((Ch == '-') || (Ch == '+'))
    {
        /*{{{   */
        Neg = (Ch == '-');
        Ch = GetChar(String, StringSize, &CharsScanned);
        /*}}}*/
    }
    
    Scale = ZERO32;
    N = ZERO32;
    Carry = ZERO32;
    Lost = ZERO32;

    Ch = ValidDigit(&More, Ch);
    for (Index = -1; Index < 1; Index++)
    {
        /*{{{   */
        if ((Index == 0) && (Ch == '.'))
        {
            /*{{{   */
            Ch = GetChar(String, StringSize, &CharsScanned);
            Ch = ValidDigit(&More, Ch);
            /*}}}*/
        }
        
        *Error = *Error || (! More);
        while (More)
        {
            /*{{{   */
            if (Index == 0)
                Scale--;
            
            if (Carry == ZERO32)
            {
                /*{{{   */
                LONGPROD((BIT32 *) &Carry, (BIT32 *) &M, N, 10L, ZERO32);
                
                if (Carry == ZERO32)
                    LONGSUM((BIT32 *) &Carry, (BIT32 *) &M, M, (BIT32) Ch, ZERO32);
                
                if (Carry == ZERO32)
                    N = M;
                else
                {
                    /*{{{   */
                    Lost = Lost | Ch;
                    Scale = Scale + ONE32;
                    /*}}}*/
                }
                /*}}}*/
            }
            else
            {
                /*{{{   */
                Lost = Lost | Ch;
                Scale = Scale + ONE32;
                /*}}}*/
            }
              
            Ch = GetChar(String, StringSize, &CharsScanned);
            Ch = ValidDigit(&More, Ch);
            /*}}}*/
        }
        /*}}}*/
    }

    if (Ch == 'E')
    {
        /*{{{   */
        M = ZERO32;
        
        Ch = GetChar(String, StringSize, &CharsScanned);
        if ((Ch == '+') || (Ch == '-'))
        {
            /*{{{   */
            if (Ch == '-')
                M = ONE32;
            
            Ch = GetChar(String, StringSize, &CharsScanned);
            /*}}}*/
        }
        else
            *Error = TRUE;
        
        Xexp = ZERO32;
        
        Ch = ValidDigit(&More, Ch);
        *Error = *Error || (! More);
        
        while (More)
        {
            /*{{{   */
            if (IntegerLimit32 >= Xexp)
            {
                /*{{{   */
                Xexp = (Xexp * 10L) + Ch;
                Ch = GetChar(String, StringSize, &CharsScanned);
                Ch = ValidDigit(&More, Ch);
                /*}}}*/
            }
            else
            {
                /*{{{   */
                INT StillChecking = TRUE;
                
                More = FALSE;
                Scale = ZERO32;
                Xexp = MOSTPOS_INT32;
                
                while (StillChecking)
                {
                    /*{{{   */
                    Ch = GetChar(String, StringSize, &CharsScanned);
                    Ch = ValidDigit(&StillChecking, Ch);
                    /*}}}*/
                }
                /*}}}*/
            }
            /*}}}*/
        }
        
        if (M == ZERO32)
            Scale = Scale + Xexp;
        else
            Scale = Scale - Xexp;
        /*}}}*/
    }

    Xexp = ZERO32;
    if (N != ZERO32)
    {
        /*{{{   */
        NORMALISE((BIT32 *) &Carry, (BIT32 *) &Xfrac, (BIT32 *) &N, N, ZERO32);
        
        Xexp = Xexp + (BitsPerWord32 - (Carry + ONE32));
        
        if (Scale != ZERO32)
            ScaleX(&Xexp, &Xfrac, Scale);
        
        Xexp = Xexp + RealXcess;
        if (Xexp >= RealExp)
        {
            /*{{{   */
            N = RealInf;
            
            /* NOTE: remove this line if overflow is OK */
            
            *Error = TRUE;
            /*}}}*/
        }
        else
        {
            /*{{{   */
            if (Xexp <= ZERO32)
            {
                /*{{{   */
                SHIFTRIGHT((BIT32 *) &Xfrac, (BIT32 *) &N, Xfrac, ZERO32, ONE32 - Xexp);
                
                Xexp = ZERO32;
                Lost = Lost | N;
                
                /* NOTE: remove this line if underflow is OK */
                
                *Error = TRUE;
                /*}}}*/
            }
            
            if (Lost != ZERO32)
                Xfrac = Xfrac | ONE32;
            
            SHIFTRIGHT((BIT32 *) &Carry, (BIT32 *) &N, 
                       Xexp, Xfrac << ONE32, (BIT32) (RealShift + ONE32));
            
            if ((Xfrac & RealRBit) == ZERO32)
                ;
            else if ((Xfrac & ((RealRBit << ONE32) | RealXcess)) == ZERO32)
                ;
            else
                N = N + ONE32;
            /*}}}*/
        }
        /*}}}*/
    }

    if (Neg)
        X = N | SignBit32;
    else
        X = N;
    
    if (*Error)
        X = RealNaN;

    *Error = *Error || (CharsScanned <= StringSize);

    *Xout = X;
}
/*}}}*/

/*{{{  StrToInt */
#ifdef ANSI
PUBLIC VOID StrToInt (BOOL *Error, BIT32 *n, CHAR *String)
#else
PUBLIC VOID StrToInt (Error, n, String)
    BIT32 *n;
    BOOL *Error;
    CHAR *String;
#endif
{
    INT32 Carry;
    BOOL Neg, More;
    INT CharsScanned, Digit, StringSize;
    
    *n = ZERO32;
    *Error = FALSE;
    Neg = (String[0] == '-');

    if ((String[0] == '+') || (String[0] == '-'))
        CharsScanned = 1;
    else
        CharsScanned = 0;

    More = TRUE;
    Digit = 0;
    StringSize = strlen(String);

    while (More && (CharsScanned < StringSize))
    {
        /*{{{   */
        LONGPROD((BIT32 *) &Carry, (BIT32 *) n, *n, 10L, (INT32) Digit);
        
        *Error = *Error || (Carry != ZERO32);
        
        Digit = ValidDigit(&More, String[CharsScanned++]);
        /*}}}*/
    }

    if (More)
    {
        /*{{{   */
        LONGPROD((BIT32 *) &Carry, (BIT32 *) n, *n, 10L, (INT32) Digit);
        
        *Error = *Error || (Carry != ZERO32);
        /*}}}*/
    }
    else
        *Error = TRUE;

    if (Neg)
    {
        /*{{{   */
        *n = (~(*n)) + ONE32;
        
        *Error = (*Error || ((*n != ZERO32) && ((*n & SignBit32) == ZERO32)));
        /*}}}*/
    }
    else
        *Error = (*Error || ((*n & SignBit32) != ZERO32));
}
/*}}}*/

/*{{{  StrToI8 */
#ifdef ANSI
PUBLIC VOID StrToI8 (BOOL *Error, BIT32 *n, CHAR *String)
#else
PUBLIC VOID StrToI8 (Error, n, String)
    BIT32 *n;
    BOOL *Error;
    CHAR *String;
#endif
{
    StrToInt(Error, n, String);

    if ((*Error == FALSE) && ((*n & HighBits8) != ZERO32))
        *Error = TRUE;
}
/*}}}*/

/*{{{  StrToI16 */
#ifdef ANSI
PUBLIC VOID StrToI16 (BOOL *Error, BIT32 *n, CHAR *String)
#else
PUBLIC VOID StrToI16 (Error, n, String)
    BIT32 *n;
    BOOL *Error;
    CHAR *String;
#endif
{
    StrToInt(Error, n, String);

    if ((*Error == FALSE) && ((*n & NegBits16) != ZERO32) &&
        ((*n & NegBits16) != NegBits16))
        *Error = TRUE;
}
/*}}}*/

/*{{{  StrToI64 */
#ifdef ANSI
PUBLIC VOID StrToI64 (BOOL *Error, BIT32 *hi, BIT32 *lo, CHAR *String)
#else
PUBLIC VOID StrToI64 (Error, hi, lo, String)
BOOL *Error;
BIT32 *hi, *lo;
CHAR *String;
#endif
{
    BOOL Neg, More;
    INT32 Carry, n1, n0;
    INT Digit, CharsScanned, StringSize;

    n0 = ZERO32;
    n1 = ZERO32;
    *Error = FALSE;
    Neg = (String[0] == '-');

    if ((String[0] == '+') || (String[0] == '-'))
        CharsScanned = 1;
    else
        CharsScanned = 0;

    More = TRUE;
    Digit = 0;
    StringSize = strlen(String);

    while (More && (CharsScanned < StringSize))
    {
        /*{{{   */
        LONGPROD((BIT32 *) &Carry, (BIT32 *) &n0, n0, 10L, (BIT32) Digit);
        LONGPROD((BIT32 *) &Carry, (BIT32 *) &n1, n1, 10L, Carry);
        
        *Error = *Error || (Carry != ZERO32);
        
        Digit = ValidDigit(&More, String[CharsScanned++]);
        /*}}}*/
    }

    if (More)
    {
        /*{{{   */
        LONGPROD((BIT32 *) &Carry, (BIT32 *) &n0, n0, 10L, (BIT32) Digit);
        LONGPROD((BIT32 *) &Carry, (BIT32 *) &n1, n1, 10L, Carry);
        
        *Error = *Error || (Carry != ZERO32);
        /*}}}*/
    }
    else
        *Error = TRUE;

    if (Neg)
    {
        /*{{{   */
        LONGDIFF((BIT32 *) &Carry, (BIT32 *) &n0, ZERO32, n0, ZERO32);
        LONGDIFF((BIT32 *) &Carry, (BIT32 *) &n1, ZERO32, n1, Carry);
        
        *Error = *Error || (n1 > ZERO32);
        /*}}}*/
    }
    else
        *Error = *Error || (n1 < ZERO32);

    *hi = n1;
    *lo = n0;
}
/*}}}*/

/*{{{  StrToHex */
#ifdef ANSI
PUBLIC VOID StrToHex (BOOL *Error, BIT32 *n, CHAR *String)
#else
PUBLIC VOID StrToHex (Error, n, String)
BOOL *Error;
BIT32 *n;
CHAR *String;
#endif
{
    BOOL More;
    INT32 Carry;
    INT CharsScanned, Digit, StringSize;
    
    *n = ZERO32;
    *Error = FALSE;
    CharsScanned = 0;

    More = TRUE;
    Digit = 0;
    StringSize = strlen(String);

    while (More && (CharsScanned < StringSize))
    {
        /*{{{   */
        SHIFTLEFT((BIT32 *) &Carry, n, ZERO32, *n, 4L);
        
        *n = *n | Digit;
        
        *Error = *Error || (Carry != ZERO32);
        
        Digit = ValidHexDigit (&More, String[CharsScanned++]);
        /*}}}*/
    }

    if (More)
    {
        /*{{{   */
        SHIFTLEFT((BIT32 *) &Carry, n, ZERO32, *n, 4L);
        
        *n = *n | Digit;
        
        *Error = *Error || (Carry != ZERO32);
        /*}}}*/
    }
    else
        *Error = TRUE;
}
/*}}}*/

/*{{{  StrToH8 */
#ifdef ANSI
PUBLIC VOID StrToH8 (BOOL *Error, BIT32 *n, CHAR *String)
#else
PUBLIC VOID StrToH8 (Error, n, String)
    BIT32 *n;
    BOOL *Error;
    CHAR *String;
#endif
{
    StrToHex(Error, n, String);

    if ((*Error==FALSE) && ((*n & HighBits8) != ZERO32))
        *Error = TRUE;
}
/*}}}*/

/*{{{  StrToH16 */
#ifdef ANSI
PUBLIC VOID StrToH16 (BOOL *Error, BIT32 *n, CHAR *String)
#else
PUBLIC VOID StrToH16 (Error, n, String)
    BIT32 *n;
    BOOL *Error;
    CHAR *String;
#endif
{
    StrToHex(Error, n, String);

    if ((*Error==FALSE) && ((*n & HighBits16) != ZERO32))
        *Error = TRUE;

    if ((*Error==FALSE) && ((*n & SignBit16) != ZERO32))
        *n = *n | HighBits16;
}
/*}}}*/

/*{{{  StrToH64 */
#ifdef ANSI
PUBLIC VOID StrToH64 (BOOL *Error, BIT32 *hi, BIT32 *lo, CHAR *String)
#else
PUBLIC VOID StrToH64 (Error, hi, lo, String)
    BOOL *Error;
    CHAR *String;
    BIT32 *hi, *lo;
#endif
{
    BOOL More;
    INT32 Carry, Dump;
    INT CharsScanned, Digit, StringSize;
    
    *lo = ZERO32;
    *hi = ZERO32;
    *Error = FALSE;
    CharsScanned = 0;

    More = TRUE;
    Digit = 0;
    StringSize = strlen(String);

    while ((More) && (CharsScanned < StringSize))
    {
        /*{{{   */
        SHIFTLEFT((BIT32 *) &Carry, (BIT32 *) &Dump, ZERO32, *hi, 4L);
        SHIFTLEFT(hi, lo, *hi, *lo, 4L);
        
        *lo = *lo | Digit;
        
        *Error = *Error || (Carry != ZERO32);
        
        Digit = ValidHexDigit (&More, String[CharsScanned++]);
        /*}}}*/
    }

    if (More)
    {
        /*{{{   */
        SHIFTLEFT((BIT32 *) &Carry, (BIT32 *) &Dump, ZERO32, *hi, 4L);
        SHIFTLEFT(hi, lo, *hi, *lo, 4L);
        
        *lo = *lo | Digit;
        
        *Error = *Error || (Carry != ZERO32);
        /*}}}*/
    }
    else
        *Error = TRUE;
}
/*}}}*/

/*{{{  StrToOct */
#ifdef ANSI
PUBLIC VOID StrToOct (BOOL *Error, BIT32 *n, CHAR *String)
#else
PUBLIC VOID StrToOct (Error, n, String)
    BIT32 *n;
    BOOL *Error;
    CHAR *String;
#endif
{
    BOOL More;
    INT32 Carry;
    INT CharsScanned, Digit, StringSize;

    *n = ZERO32;
    *Error = FALSE;
    CharsScanned = 0;

    More = TRUE;
    Digit = 0;
    StringSize = strlen(String);

    while (More && (CharsScanned < StringSize))
    {
        /*{{{   */
        SHIFTLEFT((BIT32 *) &Carry, n, ZERO32, *n, 3L);
        
        *n = *n | Digit;
        
        *Error = *Error || (Carry != ZERO32);
        
        Digit = ValidOctDigit (&More, String[CharsScanned++]);
        /*}}}*/
    }

    if (More)
    {
        /*{{{   */
        SHIFTLEFT((BIT32 *) &Carry, n, ZERO32, *n, 3L);
        
        *n = *n | Digit;
        
        *Error = *Error || (Carry != ZERO32);
        /*}}}*/
    }
    else
        *Error = TRUE;
}
/*}}}*/
/*}}}*/
