#include "extlib.h"

/*{{{  static procedures */
/*{{{  MulDiv */
#ifdef ANSI
PRIVATE VOID MulDiv (INT Op, INT32 *Xexp, BIT32 *Xfrac, INT32 *Yexp, BIT32 *Yfrac, INT32 *Guard)
#else
PRIVATE VOID MulDiv (Op, Xexp, Xfrac, Yexp, Yfrac, Guard)
    INT Op;
    BIT32 *Xfrac, *Yfrac;
    INT32 *Xexp, *Guard, *Yexp;
#endif
{
    INT32 Places, Carry;

    if (Op == Op_Mul)
    {
        /*{{{   */
        LONGPROD(Xfrac, (BIT32 *) Guard, *Xfrac, *Yfrac, ZERO32);
        
        *Xexp = (*Xexp + *Yexp) + (ONE32 - RealXcess);
        /*}}}*/
    }
    else
    {
        /*{{{   */
        NORMALISE((BIT32 *) &Places, Yfrac, (BIT32 *) &Carry, *Yfrac, ZERO32);
        
        *Yexp = *Yexp - Places;
        
        NORMALISE((BIT32 *) &Places, Xfrac, (BIT32 *) &Carry, *Xfrac, ZERO32);
        LONGDIV(Xfrac, (BIT32 *) &Carry, (BIT32) (*Xfrac >> ONE32), ZERO32, *Yfrac);
        
        if (Carry == ZERO32)
            *Guard = ZERO32;
        else
            *Guard = ONE32;
        
        *Xexp = (*Xexp - *Yexp) + (RealXcess - Places);
        /*}}}*/
    }

    NORMALISE((BIT32 *) &Places, Xfrac, (BIT32 *) Guard, *Xfrac, *Guard);

    *Xexp = *Xexp - Places;
    if (*Xexp >= RealExp)
        ;
    else if (*Xexp > ZERO32)
        ;
    else
    {
        /*{{{   */
        Places = ONE32 - *Xexp;
        
        if (Places > BitsPerWord32)
        {
            /*{{{   */
            *Guard = *Guard | *Xfrac;
            *Xfrac = ZERO32;
            /*}}}*/
        }
        else
        {
            /*{{{   */
            Carry = *Guard;
            
            SHIFTRIGHT(Xfrac, (BIT32 *) Guard, *Xfrac, *Guard, Places);
            
            *Guard = Carry | *Guard;
            /*}}}*/
        }
        *Xexp = ZERO32;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  RndPack */
#ifdef ANSI
PRIVATE VOID RndPack (BOOL *Error, INT32 *Result, INT32 Ans, INT32 Xexp, BIT32 Xfrac, INT RoundMode, INT32 Guard)
#else
PRIVATE VOID RndPack (Error, Result, Ans, Xexp, Xfrac, RoundMode, Guard)
    BOOL *Error;
    INT RoundMode;
    INT32 *Result, Ans, Xexp, Guard;
    BIT32 Xfrac;
#endif
{
    INT32 Places;
    
    if (Xexp < RealExp)
    {
        /*{{{   */
        Places = Xfrac & RealExp;
        
        SHIFTRIGHT((BIT32 *) &Xexp, &Xfrac, 
                   Xexp, (BIT32) (Xfrac << ONE32), (BIT32) (RealShift + ONE32));
        
        if (RoundMode == RN)
        {
            /*{{{   */
            if ((Places & RealRBit) == ZERO32)
                ;
            else if (((Guard | (Places & RealXcess)) | (Xfrac & ONE32)) == ZERO32)
                ;
            else
                Xfrac = Xfrac + ONE32;
            /*}}}*/
        }
        else
        {
            /*{{{   */
            if (((RoundMode == RM) && (Ans == ZERO32)) ||  /* RM and +ve */
                (((RoundMode == RP) && (Ans != ZERO32)) || /* RP and -ve */
                (RoundMode == RZ)))                        /* RZ */
                ;
            else
            {
                /*{{{   */
                if ((Places | Guard) == ZERO32)
                    ;
                else
                    Xfrac = Xfrac + ONE32;
                /*}}}*/
            }
            /*}}}*/
        }
        
        *Error = (Xfrac == RealInf);
        
        *Result = Ans | Xfrac;
        /*}}}*/
    }
    else
    {
        /*{{{   */
        if (((RoundMode == RM) && (Ans == ZERO32)) ||  /* RM and unrounded +inf */
            (((RoundMode == RP) && (Ans != ZERO32)) || /* RP and unrounded -inf */
            (RoundMode == RZ)))                        /* RZ and unrounded  inf */
        {
            /*{{{   */
            *Result = Ans | BiggestFinite;
            *Error = TRUE;
            /*}}}*/
        }
        else
        {
            /*{{{   */
            *Result = Ans | RealInf;
            *Error = TRUE;
            /*}}}*/
        }
        /*}}}*/
    }
}
/*}}}*/
/*}}}*/

/*{{{  global procedures */
/*{{{  Real32Op */
#ifdef ANSI
PUBLIC VOID Real32Op (BOOL *Error, BIT32 *Result, BIT32 X, INT RMOp, BIT32 Yp)
#else
PUBLIC VOID Real32Op (Error, Result, X, RMOp, Yp)
    INT RMOp;
    BOOL *Error;
    BIT32 *Result, X, Yp;
#endif
{
    INT RoundMode, Op;
    BIT32 Xfrac, Yfrac;
    INT32 Xexp, Yexp, Carry, Guard, Places, Ans, Y;
    
    /*{{{  unpack the operands */
    Op = RMOp & OpMask;
    RoundMode = RMOp >> RMShift;
    
    if (Op == Op_Sub)
        Y = Yp ^ SignBit32;
    else
        Y = Yp;
    
    SHIFTLEFT((BIT32 *) &Xexp, &Xfrac, ZERO32, (X << ONE32), (BIT32) RealShift);
    Xfrac = Xfrac >> ONE32;
    SHIFTLEFT((BIT32 *) &Yexp, &Yfrac, ZERO32, (Y << ONE32), (BIT32) RealShift);
    Yfrac = Yfrac >> ONE32;
    /*}}}*/
    
    /*{{{  determine special case */
    /*{{{  assume not normal case */
    Carry = ZERO32;
    *Error = FALSE;
    /*}}}*/
    
    if ((Xexp != RealExp) && (Yexp != RealExp))
    {
        /*{{{   */
        if ((Xexp != ZERO32) && (Yexp != ZERO32))
        {
            /*{{{   */
            Carry = ONE32;
            Xfrac = Xfrac | SignBit32;
            Yfrac = Yfrac | SignBit32;
            /*}}}*/
        }
        else if ((Xexp | Xfrac) == ZERO32)
        {
            /*{{{   */
            if ((Yexp | Yfrac) == ZERO32)
            {
                /*{{{   */
                if (Op < Op_Mul)
                {
                    /*{{{   */
                    if (RoundMode == RM)
                        Ans = X | Y;
                    else
                        Ans = X & Y;
                    /*}}}*/
                }
                else if (Op == Op_Mul)
                    Ans = X ^ Y;
                else
                {
                    /*{{{   */
                    Ans = ZeroZeroDivNaN;
                    *Error = TRUE;
                    /*}}}*/
                }
                /*}}}*/
            }
            else if (Op < Op_Mul)
                Ans = Y;
            else
                Ans = (X ^ Y) & SignBit32;
            /*}}}*/
        }
        else if ((Yexp | Yfrac) == ZERO32)
        {
            /*{{{   */
            if (Op < Op_Mul)
                Ans = X;
            else if (Op == Op_Mul)
                Ans = (X ^ Y) & SignBit32;
            else
            {
                /*{{{   */
                Ans = ((X ^ Y) & SignBit32) | RealInf;
                *Error = TRUE;
                /*}}}*/
            }
            /*}}}*/
        }
        else
        {
            /*{{{   */
            Carry = ONE32;
            
            if (Xexp != ZERO32)
                Xfrac = Xfrac | SignBit32;
            else
                Xexp = ONE32;
            
            if (Yexp != ZERO32)
                Yfrac = Yfrac | SignBit32;
            else
                Yexp = ONE32;
            /*}}}*/
        }
        /*}}}*/
    }
    else
    {
        /*{{{   */
        *Error = TRUE;
        
        if ((Xexp == RealExp) && (Yexp == RealExp))
        {
            /*{{{   */
            if ((Xfrac | Yfrac) != ZERO32)
            {
                /*{{{   */
                if (Yfrac > Xfrac)
                    Ans = Yp;
                else
                    Ans = X;
                
                if (Op >= Op_Mul)
                    Ans = (Ans & (~SignBit32)) | ((X ^ Y) & SignBit32);
                /*}}}*/
            }
            else if ((Op < Op_Mul) && (((X ^ Y) & SignBit32) == ZERO32))
                Ans = X;
            else if (Op == Op_Mul)
                Ans = ((X ^ Y) & SignBit32) | RealInf;
            else
            {
                /*{{{   */
                if (Op == Op_Div)
                    Ans = InfInfDivNaN;
                else
                    Ans = AddSubInfInfNaN;
                /*}}}*/
            }
            /*}}}*/
        }
        else if (Xexp == RealExp)
        {
            /*{{{   */
            if (Op < Op_Mul)
                Ans = X;
            else if (Xfrac != ZERO32)
                Ans = X ^ (Y & SignBit32);
            else if (Op == Op_Mul)
            {
                /*{{{   */
                if ((Yexp | Yfrac) == ZERO32)
                    Ans = ZeroInfMulNaN;
                else
                    Ans = ((X ^ Y) & SignBit32) | RealInf;
                /*}}}*/
            }
            else
                Ans = ((X ^ Y) & SignBit32) | RealInf;
            /*}}}*/
        }
        else if (Yfrac != ZERO32)
        {
            /*{{{   */
            if (Op < Op_Mul)
                Ans = Yp;
            else
                Ans = Y ^ (X & SignBit32);
            /*}}}*/
        }
        else
        {
            /*{{{   */
            if (Op < Op_Mul)
                Ans = Y;
            else if (Op == Op_Mul)
            {
                /*{{{   */
                if ((Xexp | Xfrac) == ZERO32)
                    Ans = ZeroInfMulNaN;
                else
                    Ans = ((X ^ Y) & SignBit32) | RealInf;
                /*}}}*/
            }
            else
                Ans = (X ^ Y) & SignBit32;
            /*}}}*/
        }
        /*}}}*/
    }
    /*}}}*/
    
    if (Carry == ZERO32)
        *Result = Ans;
    else
    {
        /*{{{   */
        if (Op < Op_Mul)
        {
            /*{{{  add/sub */
            Places = Xexp - Yexp;
            
            if (Places == ZERO32)
                Guard = ZERO32;
            else if (Places > BitsPerWord32)
            {
                /*{{{   */
                Yfrac = ZERO32;
                Guard = ONE32;
                /*}}}*/
            }
            else if (Places > ZERO32)
                SHIFTRIGHT(&Yfrac, (BIT32 *) &Guard, Yfrac, ZERO32, Places);
            else if (Places < (-BitsPerWord32))
            {
                /*{{{   */
                Xfrac = ZERO32;
                Guard = ONE32;
                Xexp = Yexp;
                /*}}}*/
            }
            else
            {
                /*{{{   */
                SHIFTRIGHT(&Xfrac, (BIT32 *) &Guard, Xfrac, ZERO32, (BIT32) (-Places));
                Xexp = Yexp;
                /*}}}*/
            }
            
            if (((X ^ Y) & SignBit32) == ZERO32)
            {
                /*{{{   */
                Ans = X & SignBit32;
                
                LONGSUM((BIT32 *) &Carry, &Xfrac, Xfrac, Yfrac, ZERO32);
                
                if (Carry != ZERO32)
                {
                    /*{{{   */
                    Xexp = Xexp + ONE32;
                    
                    if (Xexp == RealExp)
                        ;
                    else
                    {
                        /*{{{   */
                        SHIFTRIGHT(&Xfrac, (BIT32 *) &Guard, Xfrac, Guard, ONE32);
                        Xfrac = Xfrac | SignBit32;
                        /*}}}*/
                    }
                    /*}}}*/
                }
                else if (Xexp == ONE32)
                {
                    /*{{{   */
                    if ((Xfrac & SignBit32) == ZERO32)
                        Xexp = ZERO32;
                    /*}}}*/
                }
                /*}}}*/
            }
            else
            {
                /*{{{   */
                LONGDIFF((BIT32 *) &Carry, (BIT32 *) &Guard, ZERO32, Guard, ZERO32);
                LONGDIFF((BIT32 *) &Places, (BIT32 *) &Ans, Xfrac, Yfrac, Carry);
                
                if (Places == ZERO32)
                {
                    /*{{{   */
                    Xfrac = Ans;
                    Ans = X & SignBit32;
                    /*}}}*/
                }
                else
                {
                    /*{{{   */
                    LONGDIFF((BIT32 *) &Carry, (BIT32 *) &Xfrac, Yfrac, Xfrac, Carry);
                    Ans = Y & SignBit32;
                    /*}}}*/
                }
                
                if ((Xfrac & SignBit32) != ZERO32)
                    ;
                else if ((Xfrac | Guard) == ZERO32)
                {
                    /*{{{   */
                    if (RoundMode == RM)
                        Ans = SignBit32;
                    else
                        Ans = ZERO32;
                    
                    Xexp = ZERO32;
                    /*}}}*/
                }
                else if (Xexp > ONE32)
                {
                    /*{{{   */
                    NORMALISE((BIT32 *) &Places, &Xfrac, (BIT32 *) &Guard, Xfrac, Guard);
                    
                    Xexp = Xexp - Places;
                    if (Xexp > ZERO32)
                        ;
                    else
                    {
                        /*{{{   */
                        SHIFTRIGHT(&Xfrac, (BIT32 *) &Guard, Xfrac, Guard, (BIT32) (ONE32 - Xexp));
                        Xexp = ZERO32;
                        /*}}}*/
                    }
                    /*}}}*/
                }
                else
                    Xexp = ZERO32;
                /*}}}*/
            }
            /*}}}*/
        }
        else
        {
            /*{{{  mul/div */
            Ans = (X ^ Y) & SignBit32;
            
            MulDiv(Op, &Xexp, &Xfrac, &Yexp, &Yfrac, &Guard);
            /*}}}*/
        }
        
        RndPack(Error, (INT32 *) Result, Ans, Xexp, Xfrac, RoundMode, Guard);
        /*}}}*/
    }
}
/*}}}*/

/*{{{  Real32Rem */
#ifdef ANSI
PUBLIC VOID Real32Rem (BOOL *Error, BIT32 *Result, BIT32 X, BIT32 Y)
#else
PUBLIC VOID Real32Rem (Error, Result, X, Y)
    BOOL *Error;
    BIT32 *Result, X, Y;
#endif
{
    BIT32 Xfrac, Yfrac;
    INT32 Xexp, Yexp, Carry, Guard, Places, Ans;
    
    /*{{{  unpack the operands */
    SHIFTLEFT((BIT32 *) &Xexp, &Xfrac, ZERO32, X << ONE32, (BIT32) RealShift);
    Xfrac = Xfrac >> ONE32;
    SHIFTLEFT((BIT32 *) &Yexp, &Yfrac, ZERO32, Y << ONE32, (BIT32) RealShift);
    Yfrac = Yfrac >> ONE32;
    /*}}}*/

    /*{{{  determine special cases */
    /*{{{  assume not normal case */
    *Error = FALSE;
    Carry = ZERO32;
    /*}}}*/
    
    if ((Xexp != RealExp) && (Yexp != RealExp))
    {
        /*{{{   */
        if ((Xexp != ZERO32) && (Yexp != ZERO32))
        {
            /*{{{   */
            Carry = ONE32;
            Xfrac = Xfrac | SignBit32;
            Yfrac = Yfrac | SignBit32;
            /*}}}*/
        }
        else if ((Yexp | Yfrac) == ZERO32)
        {
            /*{{{   */
            Ans = RemZeroNaN;
            *Error = TRUE;
            /*}}}*/
        }
        else if ((Xexp | Xfrac) == ZERO32)
            Ans = X;
        else
        {
            /*{{{   */
            Carry = ONE32;
            
            if (Xexp != ZERO32)
                Xfrac = Xfrac | SignBit32;
            else
                Xexp = ONE32;
            
            if (Yexp != ZERO32)
                Yfrac = Yfrac | SignBit32;
            else
                Yexp = ONE32;
            /*}}}*/
        }
        /*}}}*/
    }
    else
    {
        /*{{{   */
        *Error = TRUE;
        
        if ((Xexp == RealExp) && (Yexp == RealExp))
        {
            /*{{{   */
            if ((Xfrac | Yfrac) == ZERO32)
                Ans = RemInfNaN;
            else if (Yfrac > Xfrac)
                Ans = Y;
            else
                Ans = (X & (~SignBit32)) | (Y & SignBit32);
            /*}}}*/
        }
        else if (Xexp == RealExp)
        {
            /*{{{   */
            if (Xfrac != ZERO32)
                Ans = (X & (~SignBit32)) | (Y & SignBit32);
            else
                Ans = RemInfNaN;
            /*}}}*/
        }
        else if (Yfrac != ZERO32)
            Ans = Y;
        else
            Ans = X;
        /*}}}*/
    }
    /*}}}*/

    if (Carry == ZERO32)
        *Result = Ans;
    else
    {
        /*{{{   */
        if (Yexp == ONE32)
        {
            /*{{{   */
            NORMALISE((BIT32 *) &Places, &Yfrac, (BIT32 *) &Guard, Yfrac, ZERO32);
            Yexp = Yexp - Places;
            NORMALISE((BIT32 *) &Places, &Xfrac, (BIT32 *) &Guard, Xfrac, ZERO32);
            Xexp = Xexp - Places;
            /*}}}*/
        }
        
        Ans = X & SignBit32;
        Places = Xexp - Yexp;
        
        if (Places >= ZERO32)
        {
            /*{{{   */
            Carry = BitsPerWord32 - (Places & (BitsPerWord32 - ONE32));
            
            SHIFTRIGHT(&Xfrac, (BIT32 *) &Guard, Xfrac, ZERO32, Carry);
            LONGDIV((BIT32 *) &Guard, &Xfrac, Xfrac, Guard, Yfrac);
            
            while (Places >= BitsPerWord32)
            {
                /*{{{   */
                LONGDIV((BIT32 *) &Guard, &Xfrac, Xfrac, ZERO32, Yfrac);
                Places = Places - BitsPerWord32;
                /*}}}*/
            }
            
            if (Xfrac == ZERO32)
                Xexp = ZERO32;
            else
            {
                /*{{{   */
                LONGDIFF((BIT32 *) &Carry, (BIT32 *) &Xexp, Yfrac >> ONE32, Xfrac, ZERO32);
                
                if ((Carry != ZERO32) || ((Xexp == ZERO32) && ((Guard & ONE32) != ZERO32)))
                {
                    /*{{{   */
                    Ans = Ans ^ SignBit32;
                    Xfrac = Yfrac - Xfrac;
                    /*}}}*/
                }
                
                Xexp = Yexp;
                /*}}}*/
            }
            /*}}}*/
        }
        else if (Places == -ONE32)
        {
            /*{{{   */
            LONGDIFF((BIT32 *) &Carry, (BIT32 *) &Guard, Yfrac, Xfrac, ZERO32);
            
            if (Carry == ZERO32)
                ;
            else
            {
                /*{{{   */
                Ans = Ans ^ SignBit32;
                Xfrac = Yfrac - (Xfrac >> ONE32);
                Xexp = Yexp;
                /*}}}*/
            }
            /*}}}*/
        }
        
        NORMALISE((BIT32 *) &Places, &Xfrac, (BIT32 *) &Guard, Xfrac, ZERO32);
        
        Xexp = Xexp - Places;
        
        if (Xexp <= ZERO32)
        {
            /*{{{   */
            SHIFTRIGHT(&Xfrac, (BIT32 *) &Guard, Xfrac, ZERO32, ONE32 - Xexp);
            Xexp = ZERO32;
            /*}}}*/
        }
        
        Places = Xfrac & RealExp;
        
        SHIFTRIGHT((BIT32 *) &Xexp, &Xfrac,
                   Xexp, Xfrac << ONE32, (BIT32) (RealShift + ONE32));
        
        if ((Places & RealRBit) == ZERO32)
            ;
        else if (((Guard | (Places & RealXcess)) | (Xfrac & ONE32)) == ZERO32)
            ;
        else
            Xfrac = Xfrac + ONE32;
        
        *Result = Ans | Xfrac;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  Real32Eq */
#ifdef ANSI
PUBLIC VOID Real32Eq (BOOL *Equal, BIT32 X, BIT32 Y)
#else
PUBLIC VOID Real32Eq (Equal, X, Y)
    BOOL *Equal;
    BIT32 X, Y;
#endif
{
    INT32 MagX, MagY;

    MagX = X & MOSTPOS_INT32;
    MagY = Y & MOSTPOS_INT32;

    *Equal = ((X == Y) || ((MagX + MagY) == ZERO32));
}
/*}}}*/

/*{{{  Real32Gt */
#ifdef ANSI
PUBLIC VOID Real32Gt (BOOL *Greater, BIT32 X, BIT32 Y)
#else
PUBLIC VOID Real32Gt (Greater, X, Y)
    BOOL *Greater;
    BIT32 X, Y;
#endif
{
    INT32 MagX, MagY;

    MagX = X & MOSTPOS_INT32;
    MagY = Y & MOSTPOS_INT32;
    
    if (((X ^ Y) & SignBit32) != ZERO32)
        *Greater = ((((Y & SignBit32) != ZERO32) && ((MagX + MagY) != ZERO32)));
    else if ((X & SignBit32) != ZERO32)
        *Greater = (MagY > MagX);
    else
        *Greater = (MagX > MagY);
}
/*}}}*/
/*}}}*/
