#include "extlib.h"

/*{{{  global procedures */
/*{{{  I32ToI64 */
#ifdef ANSI
PUBLIC VOID I32ToI64 (BIT32 *ResultHi, BIT32 *ResultLo, BIT32 A)
#else
PUBLIC VOID I32ToI64 (ResultHi, ResultLo, A)
    BIT32 *ResultHi, *ResultLo, A;
#endif
{
    *ResultLo = A;

    if ((A & SignBit32) != ZERO32)
        *ResultHi = -ONE32;
    else
        *ResultHi = ZERO32;
}
/*}}}*/

/*{{{  I32ToR32 */
#ifdef ANSI
PUBLIC VOID I32ToR32 (BIT32 *X, INT Mode, BIT32 N)
#else
PUBLIC VOID I32ToR32 (X, Mode, N)
    INT Mode;
    BIT32 *X, N;
#endif
{
    if (N == ZERO32)
        *X = ZERO32;
    else
    {
        /*{{{   */
        INT32 Guard, Places, Xexp, Xfrac, Xint, Xsign;
        
        if ((N & SignBit32) != ZERO32)
        {
            /*{{{   */
            Xsign = SignBit32;
            Xint = (N ^ (INT32) (-ONE32)) + ONE32;
            /*}}}*/
        }
        else
        {
            /*{{{   */
            Xsign = ZERO32;
            Xint = N;
            /*}}}*/
        }
        NORMALISE((BIT32 *) &Places,
                  (BIT32 *) &Xint, (BIT32 *) &Guard, Xint, ZERO32);
        
        Xexp = (RealXcess - ONE32) + (BitsPerWord32 - Places);
        
        SHIFTRIGHT((BIT32 *) &Xexp, (BIT32 *) &Xfrac, 
                   Xexp, Xint << ONE32, (BIT32) (RealShift + ONE32));
        
        if (Places > RealShift)
            ;
        else
        {
            /*{{{   */
            Xint = Xint & RealExp;
            if ((Mode == Truncate) || ((Xint & RealRBit) == ZERO32))
                ;
            else if (((Xint & RealXcess) | (Xfrac & ONE32)) == ZERO32)
                ;
            else
                Xfrac = Xfrac + ONE32;
            /*}}}*/
        }
        *X = Xsign | Xfrac;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  I32ToR64 */
#ifdef ANSI
PUBLIC VOID I32ToR64 (BIT32 *XHi, BIT32 *XLo, BIT32 N)
#else
PUBLIC VOID I32ToR64 (XHi, XLo, N)
    BIT32 *XHi, *XLo, N;
#endif
{
    if (N == ZERO32)
    {
        /*{{{   */
        *XHi = ZERO32;
        *XLo = ZERO32;
        /*}}}*/
    }
    else
    {
        /*{{{   */
        INT32 Dump, Places, Xexp, Xfrac, Xint, Xsign;
        
        if ((N & SignBit32) != ZERO32)
        {
            /*{{{   */
            Xsign = SignBit32;
            
            if (N == SignBit32)
                Xint = N;
            else
                Xint = -N;
            /*}}}*/
        }
        else
        {
            /*{{{   */
            Xsign = ZERO32;
            Xint = N;
            /*}}}*/
        }
        NORMALISE((BIT32 *) &Places,
                  (BIT32 *) &Xint, (BIT32 *) &Dump, Xint, ZERO32);
        
        Xexp = (DRealXcess - ONE32) + (BitsPerWord32 - Places);
        Xint = Xint << ONE32;
        
        SHIFTRIGHT((BIT32 *) &Xexp, (BIT32 *) &Xfrac, 
                   Xexp, Xint, (BIT32) (DRealShift + ONE32));
        SHIFTRIGHT((BIT32 *) &Xexp, XLo, 
                   Xint, ZERO32, (BIT32) (DRealShift + ONE32));
        
        *XHi = Xsign | Xfrac;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  I64ToI32 */
#ifdef ANSI
PUBLIC VOID I64ToI32 (BOOL *Error, BIT32 *Result, BIT32 AHi, BIT32 ALo)
#else
PUBLIC VOID I64ToI32 (Error, Result, AHi, ALo)
    BOOL *Error;
    BIT32 *Result, AHi, ALo;
#endif
{
    INT32 Res;

    Res = ALo;

    if (((Res < ZERO32) && (AHi != -ONE32)) ||
        ((Res >= ZERO32) && (AHi != ZERO32)))
        *Error = TRUE;
    else
        *Error = FALSE;

    *Result = Res;
}
/*}}}*/

/*{{{  I64ToR32 */
#ifdef ANSI
PUBLIC VOID I64ToR32 (BIT32 *Result, INT Mode, BIT32 AHi, BIT32 ALo)
#else
PUBLIC VOID I64ToR32 (Result, Mode, AHi, ALo)
    INT Mode;
    BIT32 *Result, AHi, ALo;
#endif
{
    INT32 B[2], Xfrac, Xexp, Ans, Carry, Places;

    if ((AHi & SignBit32) != ZERO32)
    {
        /*{{{   */
        LONGDIFF((BIT32 *) &Carry, (BIT32 *) &B[0], ZERO32, ALo, ZERO32);
        LONGDIFF((BIT32 *) &Carry, (BIT32 *) &B[1], ZERO32, AHi, Carry);
        Ans = SignBit32;
        /*}}}*/
    }
    else
    {
        /*{{{   */
        B[1] = AHi;
        B[0] = ALo;
        Ans = ZERO32;
        /*}}}*/
    }

    NORMALISE((BIT32 *) &Places,
              (BIT32 *) &B[1], (BIT32 *) &B[0], B[1], B[0]);

    if (Places == (2 * BitsPerWord32))
        *Result = ZERO32;
    else
    {
        /*{{{   */
        Xexp = (((2 * BitsPerWord32) - ONE32) - Places) + RealXcess;
        
        Places = B[1] & RealExp;
        
        SHIFTRIGHT((BIT32 *) &Xexp, (BIT32 *) &Xfrac, 
                   Xexp, B[1] << ONE32, (BIT32) (RealShift + ONE32));
        
        if ((Mode == Truncate) || ((Places & RealRBit) == ZERO32))
            ;
        else if (((B[0] | (Places & RealXcess)) | (Xfrac & ONE32)) == ZERO32)
            ;
        else
            Xfrac = Xfrac + ONE32;
        
        *Result = Ans | Xfrac;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  I64ToR64 */
#ifdef ANSI
PUBLIC VOID I64ToR64 (BIT32 *XHi, BIT32 *XLo, INT Mode, BIT32 NHi, BIT32 NLo)
#else
PUBLIC VOID I64ToR64 (XHi, XLo, Mode, NHi, NLo)
    INT Mode;
    BIT32 *XHi, *XLo, NHi, NLo;
#endif
{
    if ((NHi | NLo) == ZERO32)
    {
        /*{{{   */
        *XHi = ZERO32;
        *XLo = ZERO32;
        /*}}}*/
    }
    else
    {
        /*{{{   */
        INT32 Carry, Places, Xexp, Xfrac[2], Xint[2], Xsign;
        
        if ((NHi & SignBit32) != ZERO32)
        {
            /*{{{   */
            Xsign = SignBit32;
            LONGDIFF((BIT32 *) &Carry, (BIT32 *) &Xint[ZERO32], ZERO32, NLo, ZERO32);
            LONGDIFF((BIT32 *) &Carry, (BIT32 *) &Xint[1], ZERO32, NHi, Carry);
            /*}}}*/
        }
        else
        {
            /*{{{   */
            Xsign = ZERO32;
            Xint[1] = NHi;
            Xint[0] = NLo;
            /*}}}*/
        }
        
        NORMALISE((BIT32 *) &Places,
                  (BIT32 *) &Xint[1], (BIT32 *) &Xint[0], Xint[1], Xint[0]);
        
        Xexp = (DRealXcess - ONE32) + ((2 * BitsPerWord32) - Places);
        
        SHIFTLEFT((BIT32 *) &Xint[1], (BIT32 *) &Xint[0], Xint[1], Xint[0], ONE32);
        SHIFTRIGHT((BIT32 *) &Xexp, (BIT32 *) &Xfrac[1],
                   Xexp, Xint[1], (BIT32)(DRealShift + ONE32));
        SHIFTRIGHT((BIT32 *) &Xexp, (BIT32 *) &Xfrac[0],
                   Xint[1], Xint[0], (BIT32) (DRealShift + ONE32));
        
        if (Places > (BitsPerWord32 + DRealShift))
            ;
        else
        {
            /*{{{   */
            Xint[0] = Xint[0] & DRealExp;
            if ((Mode == Truncate) || ((Xint[0] & DRealRBit) == ZERO32))
                ;
            else if (((Xint[0] & DRealXcess) | (Xfrac[0] & ONE32)) == ZERO32)
                ;
            else
            {
                /*{{{   */
                LONGSUM((BIT32 *) &Carry, (BIT32 *) &Xfrac[0], Xfrac[0], ONE32, ZERO32);
                LONGSUM((BIT32 *) &Carry, (BIT32 *) &Xfrac[1], Xfrac[1], ZERO32, Carry);
                /*}}}*/
            }
            /*}}}*/
        }
        
        *XHi = Xsign | Xfrac[1];
        *XLo = Xfrac[0];
        /*}}}*/
    }
}
/*}}}*/

/*{{{  R32ToI32 */
#ifdef ANSI
PUBLIC VOID R32ToI32 (BOOL *Error, BIT32 *N, INT Mode, BIT32 X)
#else
PUBLIC VOID R32ToI32 (Error, N, Mode, X)
    INT Mode;
    BOOL *Error;
    BIT32 *N, X;
#endif
{
    INT32 Guard, Xexp, Xfrac;

    *Error = FALSE;

    SHIFTLEFT((BIT32 *) &Xexp, (BIT32 *) &Xfrac, 
              ZERO32, X & (~SignBit32), (BIT32) (RealShift + ONE32));

    if (Xexp == RealExp)
        *Error = TRUE;
    else if (Xexp < (RealXcess - ONE32))
        *N = ZERO32;
    else if (Xexp < RealXcess)
    {
        /*{{{   */
        if ((Mode == Truncate) || (Xfrac == ZERO32))
            *N = ZERO32;
        else if ((X & SignBit32) == ZERO32)
            *N = ONE32;
        else
            *N = -ONE32;
        /*}}}*/
    }
    else if (X == REAL32MININT32)
        *N = SignBit32;
    else
    {
        /*{{{   */
        Xexp = Xexp - RealXcess;
        
        Guard = ONE32;
        
        if (Xexp > (BitsPerWord32 - 2))
        {
            /*{{{   */
            *Error = TRUE;
            SHIFTLEFT((BIT32 *) &Guard, (BIT32 *) &Xfrac, Guard, Xfrac, Xexp - BitsPerWord32);
            /*}}}*/
        }
        else
            SHIFTLEFT((BIT32 *) &Guard, (BIT32 *) &Xfrac, Guard, Xfrac, Xexp);
        
        if ((Mode == Truncate) || ((Xfrac & SignBit32) == ZERO32))
            ;
        else if (((Xfrac & (~SignBit32)) | (Guard & ONE32)) == ZERO32)
            ;
        else
        {
            /*{{{   */
            Guard = Guard + ONE32;
            
            if ((Guard & SignBit32) == ZERO32)
                ;
            else
                *Error = TRUE;
            /*}}}*/
        }
        
        if ((X & SignBit32) == ZERO32)
            *N = Guard & (~SignBit32);
        else
            *N = -(Guard & (~SignBit32));
        /*}}}*/
    }
}
/*}}}*/

/*{{{  R32ToI64 */
#ifdef ANSI
PUBLIC VOID R32ToI64 (BOOL *Error, BIT32 *ResultHi, BIT32 *ResultLo, INT Mode, BIT32 A)
#else
PUBLIC VOID R32ToI64 (Error, ResultHi, ResultLo, Mode, A)
    INT Mode;
    BOOL *Error;
    BIT32 *ResultHi, *ResultLo, A;
#endif
{
    *Error = FALSE;

    if (A == REAL32MININT64)
    {
        /*{{{   */
        *ResultHi = SignBit32;
        *ResultLo = ZERO32;
        /*}}}*/
    }
    else
    {
        /*{{{   */
        BIT32 B[2], Xfrac, Xexp, Carry;
        
        SHIFTLEFT((BIT32 *) &Xexp, (BIT32 *) &Xfrac,
                  ZERO32, A << ONE32, (BIT32) RealShift);
        
        if (Xexp < (RealXcess - ONE32))
        {
            /*{{{   */
            *ResultHi = ZERO32;
            *ResultLo = ZERO32;
            /*}}}*/
        }
        else if (Xexp > (((2 * BitsPerWord32) - 2) + RealXcess))
            *Error = TRUE;
        else
        {
            /*{{{   */
            SHIFTRIGHT((BIT32 *) &Carry, (BIT32 *) &Xfrac, ONE32, Xfrac, ONE32);
            
            if (Xexp < (RealXcess + BitsPerWord32))
            {
                /*{{{   */
                SHIFTLEFT((BIT32 *) &B[0], (BIT32 *) &Xfrac,
                          ZERO32, Xfrac, (ONE32 + Xexp) - RealXcess);
                
                B[1] = ZERO32;
                
                if ((Mode == Truncate) || ((Xfrac & SignBit32) == ZERO32))
                    ;
                else if (((Xfrac & (~SignBit32)) | (B[0] & ONE32)) == ZERO32)
                    ;
                else
                {
                    /*{{{   */
                    LONGSUM((BIT32 *) &Carry, (BIT32 *) &B[0], ONE32, B[0], ZERO32);
                    LONGADD(&B[1], B[1], ZERO32, Carry);
                    /*}}}*/
                }
                /*}}}*/
            }
            else
            {
                /*{{{   */
                SHIFTLEFT((BIT32 *) &B[1], (BIT32 *) &B[0], 
                          ZERO32, Xfrac, ((ONE32 + Xexp) - RealXcess) - BitsPerWord32);
                /*}}}*/
            }
            
            if ((A & SignBit32) != ZERO32)
            {
                /*{{{   */
                LONGDIFF((BIT32 *) &Carry, ResultLo, ZERO32, B[0], ZERO32);
                LONGDIFF((BIT32 *) &Carry, ResultHi, ZERO32, B[1], Carry);
                /*}}}*/
            }
            else
            {
                /*{{{   */
                *ResultLo = B[0];
                *ResultHi = B[1];
                /*}}}*/
            }
            /*}}}*/
        }
        /*}}}*/
    }
}
/*}}}*/

/*{{{  R32ToR64 */
#ifdef ANSI
PUBLIC VOID R32ToR64 (BOOL *Error, BIT32 *ResultHi, BIT32 *ResultLo, BIT32 X)
#else
PUBLIC VOID R32ToR64 (Error, ResultHi, ResultLo, X)
    BOOL *Error;
    BIT32 *ResultHi, *ResultLo, X;
#endif
{
    BIT32 Xfrac;
    INT32 Yexp, Yfrac[2], Xexp, Places, Carry;

    *Error = FALSE;

    SHIFTLEFT((BIT32 *) &Xexp, &Xfrac, ZERO32, X << ONE32, (BIT32) RealShift);

    Xfrac = Xfrac >> ONE32;

    if (Xexp != RealExp)
    {
        /*{{{   */
        if ((Xexp != ZERO32))
        {
            /*{{{   */
            Yfrac[1] = Xfrac | SignBit32;
            Yexp = Xexp + (DRealXcess - RealXcess);
            /*}}}*/
        }
        else if ((Xexp | Xfrac) == ZERO32)
        {
            /*{{{   */
            Yfrac[1] = ZERO32;
            Yexp  = ZERO32;
            /*}}}*/
        }
        else
        {
            /*{{{   */
            NORMALISE((BIT32 *) &Places,
                      (BIT32 *) &Yfrac[1], (BIT32 *) &Yfrac[0], Xfrac, ZERO32);
            
            Yexp = ((DRealXcess - RealXcess) + (ONE32 - Places));
            /*}}}*/
        }
        /*}}}*/
    }
    else
    {
        /*{{{   */
        Yexp = DRealExp;
        Yfrac[1] = Xfrac;
        
        *Error = TRUE;
        /*}}}*/
    }

    SHIFTRIGHT((BIT32 *) &Yfrac[1], (BIT32 *) &Yfrac[0], 
               Yfrac[1] & (~SignBit32), ZERO32, (BIT32) DRealShift);
    SHIFTRIGHT((BIT32 *) &Carry, (BIT32 *) &Yexp, 
               Yexp, ZERO32, (BIT32) (DRealShift + ONE32));

    Yfrac[1] = Yfrac[1] | Yexp;

    *ResultHi = (Yfrac[1] | (X & SignBit32));
    *ResultLo = Yfrac[0];
}
/*}}}*/

/*{{{  R64ToI32 */
#ifdef ANSI
PUBLIC VOID R64ToI32 (BOOL *Error, BIT32 *N, INT Mode, BIT32 XHi, BIT32 XLo)
#else
PUBLIC VOID R64ToI32 (Error, N, Mode, XHi, XLo)
    INT Mode;
    BOOL *Error;
    BIT32 *N, XHi, XLo;
#endif
{
    INT32 Dump, Guard, Xexp, Xfrac[2];

    *Error = FALSE;

    SHIFTLEFT((BIT32 *) &Xexp, (BIT32 *) &Dump, 
              ZERO32, XHi & (~SignBit32), (BIT32) (DRealShift + ONE32));
    SHIFTLEFT((BIT32 *) &Xfrac[1], (BIT32 *) &Xfrac[0], 
              XHi, XLo, (BIT32) (DRealShift + ONE32));

    if (Xexp == DRealExp)
        *Error = TRUE;
    else if ((XHi == REAL64MININT32Hi) && ((Xfrac[1] == ZERO32) ||
        ((Mode == Truncate) && (Xfrac[1] == ONE32))))
        *N = SignBit32;
    else if (Xexp < (DRealXcess - ONE32))
        *N = ZERO32;
    else if (Xexp < DRealXcess)
    {
        /*{{{   */
        if ((Mode == Truncate) || ((Xfrac[1] | Xfrac[0]) == ZERO32))
            *N = ZERO32;
        else if ((XHi & SignBit32) == ZERO32)
            *N = ONE32;
        else
            *N = -ONE32;
        /*}}}*/
    }
    else
    {
        /*{{{   */
        Xexp = Xexp - DRealXcess;
        
        Guard = ONE32;
        
        if (Xexp > (BitsPerWord32 - 2))
            *Error = TRUE;
        
        SHIFTLEFT((BIT32 *) &Guard, (BIT32 *) &Dump, Guard, Xfrac[1], Xexp);
        SHIFTLEFT((BIT32 *) &Xfrac[1], (BIT32 *) &Xfrac[0], Xfrac[1], Xfrac[0], Xexp);
        
        if ((Mode == Truncate) || ((Xfrac[1] & SignBit32) == ZERO32))
            ;
        else if ((((Xfrac[1] & (~SignBit32)) | Xfrac[0]) | (Guard & ONE32)) == ZERO32)
            ;
        else
        {
            /*{{{   */
            LONGSUM((BIT32 *) &Dump, (BIT32 *) &Guard, Guard, ONE32, ZERO32);
            
            if (Guard < ZERO32)
                *Error = TRUE;
            /*}}}*/
        }
        
        if ((XHi & SignBit32) == ZERO32)
            ;
        else
            Guard = -Guard;
        
        *N = Guard;
        /*}}}*/
    }
}
/*}}}*/

/*{{{  R64ToI64 */
#ifdef ANSI
PUBLIC VOID R64ToI64 (BOOL *Error, BIT32 *NHi, BIT32 *NLo, INT Mode, BIT32 XHi, BIT32 XLo)
#else
PUBLIC VOID R64ToI64 (Error, NHi, NLo, Mode, XHi, XLo)
    INT Mode;
    BOOL *Error;
    BIT32 *NHi, *NLo, XHi, XLo;
#endif
{
    INT32 Carry, Dump, Guard, Xexp, Xfrac[2], Xsign;

    *Error = FALSE;

    SHIFTLEFT((BIT32 *) &Xexp, (BIT32 *) &Dump, 
              ZERO32, XHi & (~SignBit32), (BIT32) (DRealShift + ONE32));
    SHIFTLEFT((BIT32 *) &Xfrac[1], (BIT32 *) &Xfrac[0], 
              XHi, XLo, (BIT32) (DRealShift + ONE32));

    if (Xexp == DRealExp)
        *Error = TRUE;
    else if ((XHi == REAL64MININT64Hi) && (XLo == ZERO32))
    {
        /*{{{   */
        *NHi = SignBit32;
        *NLo = ZERO32;
        /*}}}*/
    }
    else if (Xexp < (DRealXcess - ONE32))
    {
        /*{{{   */
        *NHi = ZERO32;
        *NLo = ZERO32;
        /*}}}*/
    }
    else if (Xexp < DRealXcess)
    {
        /*{{{   */
        if ((Mode == Truncate) || ((Xfrac[1] | Xfrac[0]) == ZERO32))
        {
            /*{{{   */
            *NHi = ZERO32;
            *NLo = ZERO32;
            /*}}}*/
        }
        else if ((XHi & SignBit32) == ZERO32)
        {
            /*{{{   */
            *NHi = ZERO32;
            *NLo = ONE32;
            /*}}}*/
        }
        else
        {
            /*{{{   */
            *NHi = -ONE32;
            *NLo = -ONE32;
            /*}}}*/
        }
        /*}}}*/
    }
    else
    {
        /*{{{   */
        Xsign = XHi & SignBit32;
        Xexp = Xexp - DRealXcess;
        
        if (Xexp < BitsPerWord32)
        {
            /*{{{   */
            Carry = Xfrac[0];
            Xfrac[0] = Xfrac[1];
            Xfrac[1] = ONE32;
            Guard = ZERO32;
            /*}}}*/
        }
        else
        {
            /*{{{   */
            Xexp = Xexp - BitsPerWord32;
            Carry = ZERO32;
            Guard = ONE32;
            /*}}}*/
        }
        
        if (Xexp > (BitsPerWord32 - 2))
            *Error = TRUE;
        
        SHIFTLEFT((BIT32 *) &Guard, (BIT32 *) &Dump, Guard, Xfrac[1], Xexp);
        SHIFTLEFT((BIT32 *) &Xfrac[1], (BIT32 *) &Dump, Xfrac[1], Xfrac[0], Xexp);
        SHIFTLEFT((BIT32 *) &Xfrac[0], (BIT32 *) &Carry, Xfrac[0], Carry, Xexp);
        
        if ((Mode == Truncate) || ((Xfrac[0] & SignBit32) == ZERO32))
            ;
        else if ((((Xfrac[0] & (~SignBit32)) | Carry) | (Xfrac[1] & ONE32)) == ZERO32) 
            ;
        else
        {
            /*{{{   */
            LONGSUM((BIT32 *) &Carry, (BIT32 *) &Xfrac[1], Xfrac[1], ONE32, ZERO32);
            LONGSUM((BIT32 *) &Carry, (BIT32 *) &Guard, Guard, ZERO32, Carry);
            /*}}}*/
        }
        
        *NHi = Guard & (~SignBit32);
        *NLo = Xfrac[1];
        
        if (Xsign == ZERO32)
            ;
        else
        {
            /*{{{   */
            LONGDIFF((BIT32 *) &Carry, NLo, ZERO32, *NLo, ZERO32);
            LONGDIFF((BIT32 *) &Carry, NHi, ZERO32, *NHi, Carry);
            /*}}}*/
        }
        /*}}}*/
    }
}
/*}}}*/

/*{{{  R64ToR32 */
#ifdef ANSI
PUBLIC VOID R64ToR32 (BOOL *Error, BIT32 *Result, INT Mode, BIT32 XHi, BIT32 XLo)
#else
PUBLIC VOID R64ToR32 (Error, Result, Mode, XHi, XLo)
    INT Mode;
    BOOL *Error;
    BIT32 *Result, XHi, XLo;
#endif
{
    INT32 Xfrac[2], Xexp, Yfrac, Yexp, Places, Guard;

    *Error = FALSE;
    
    SHIFTLEFT((BIT32 *) &Xfrac[1], (BIT32 *) &Xfrac[0], 
              XHi, XLo, (BIT32) DRealShift);

    Xexp = (XHi >> DRealExpSh) & DRealExp;

    if (Xexp != DRealExp)
    {
        /*{{{   */
        if (Xexp != ZERO32)
        {
            /*{{{   */
            Yfrac = Xfrac[1] | SignBit32;
            Guard = Xfrac[0];
            Yexp = Xexp - (DRealXcess - RealXcess);
            
            if (Yexp >= RealExp)
            {
                /*{{{   */
                Yexp = RealExp;
                Yfrac = SignBit32;
                *Error = TRUE;
                /*}}}*/
            }
            else if (Yexp > ZERO32)
                ;
            else if (Yexp > (ONE32 - BitsPerWord32))
            {
                /*{{{   */
                Places = Guard;
                
                SHIFTRIGHT((BIT32 *) &Yfrac, (BIT32 *) &Guard, Yfrac, Guard, ONE32 - Yexp);
                
                Guard = Places | Guard;
                Yexp = ZERO32;
                /*}}}*/
            }
            else
            {
                /*{{{   */
                Guard = Guard | Yfrac;
                Yfrac = ZERO32;
                /*}}}*/
            }
            /*}}}*/
        }
        else
        {
            /*{{{   */
            Yexp = ZERO32;
            Yfrac = ZERO32;
            Guard = Xfrac[1] | Xfrac[0];
            /*}}}*/
        }
        /*}}}*/
    }
    else
    {
        /*{{{   */
        Xfrac[1] = Xfrac[1] & (~SignBit32);
        Yexp = RealExp;
        Yfrac = Xfrac[1] & (~(RealXcess | RealRBit));
        Guard = ZERO32;
        
        if ((Yfrac == ZERO32) && ((Xfrac[1] | Xfrac[0]) != ZERO32))
            Yfrac = Real64to32NaNfrac;
        
        *Error = TRUE;
        /*}}}*/
    }

    if (Yexp < RealExp)
    {
        /*{{{   */
        Places = Yfrac & RealExp;
        
        SHIFTRIGHT((BIT32 *) &Yexp, (BIT32 *) &Yfrac, 
                   Yexp, Yfrac << ONE32, (BIT32) (RealShift + ONE32));
        
        if ((Mode == Truncate) || ((Places & RealRBit) == ZERO32))
            ;
        else if (((Guard | (Places & RealXcess)) | (Yfrac & ONE32)) == ZERO32)
            ;
        else
        {
            /*{{{   */
            Yfrac = Yfrac + ONE32;
            
            if (Yfrac == RealInf)
                *Error = TRUE;
            /*}}}*/
        }
        /*}}}*/
    }
    else
    {
        /*{{{   */
        SHIFTRIGHT((BIT32 *) &Yexp, (BIT32 *) &Yfrac, 
                   Yexp, Yfrac << ONE32, (BIT32) (RealShift + ONE32));
        *Error = TRUE;
        /*}}}*/
    }

    *Result = (XHi & SignBit32) | Yfrac;
}
/*}}}*/
/*}}}*/
