/* host_os.h -- Define the constants for system dependence */
/* Copyright Inmos 1989, 1990 */
/* Version 1.0 -- 19900129 */
/* History */
/* ahp: First version written */

/* Define the possible hosts for execution */

#define SERVER   0   /* Transputer hosted, running under iserver */
#define MS_DOS   1   /* Hosted by MS-DOS                         */
#define HELIOS   2   /* Hosted by Helios                         */
#define    VMS   3   /* Hosted by VMS                            */
#define SUN_OS   4   /* Hosted by SunOs                          */

/* Define the expected host at execution time */

#define HOST -1

#ifdef SUN3
#undef HOST
#define HOST SUN_OS
#endif

#ifdef SUN4
#undef HOST
#define HOST SUN_OS
#endif

#ifdef PC
#undef HOST
#define HOST MS_DOS
#endif

#ifdef VAX
#undef HOST
#define HOST VMS
#endif

#ifdef TP
#undef HOST
#define HOST SERVER
#endif
