use strict;
use RIB::Util ();
use LWP::UserAgent ();
use HTTP::Request ();
use Data::Dumper ();
$Data::Dumper::Indent = 0;

my $RIBDIR = RIB::Util::GetRibDir;
my $filepath = "$RIBDIR/repositories";
my $buf = '';
my @a;
select(STDOUT) ; $| = 1;
opendir(DIR,$filepath) or die "Couldn't open the dirctory $filepath: $!";
OUTER: foreach ( readdir DIR ){
    next if ($_ eq '.' or $_ eq '..');
    my $nonlocal = "$filepath/$_/catalog/.nonlocal";
    next if ( !(-e $nonlocal) or (-z $nonlocal) );
    open(F,"<$nonlocal") or die "Couldn't open $nonlocal: $!";
    my ($url,$ua,$req,$res);
    print "Updating $_ ... ";
    @a = ();
    foreach $url (<F>){
	if ( $url =~ /^\$VAR1/){
          my $contents = $url; # this actually isn't a url
          undef($/);
          $contents .= <F>;
          $/ = "\n";
          my $entries =  eval "my $contents";
          my $entry;
          foreach $entry (@{$entries}) {
	    push @a, { 'URL' => $entry->{"URL"}, 'LM' =>  '', 'FILE' => $entry->{"FILE"} };
          }
          close(F);
          open(F,"+>$nonlocal") or die "Couldn't open $nonlocal: $!";
          print F Data::Dumper::Dumper(\@a);
          close(F);
          print "done\n";
          next OUTER;
        }
	$url =~ s/\s*$//;
	my $ua = LWP::UserAgent->new("RIBcatalog/1.0");
	my $req = HTTP::Request->new('HEAD',$url);
	my $res = $ua->request($req);
	if ($res->is_success){
	    my $lm = $res->header('Last-Modified');
	    push @a, { 'URL' => $url, 'LM' =>  $lm, 'FILE' => '' };
	} else {
	    push @a, { 'URL' => $url, 'LM' =>  '', 'FILE' => '' };
	}
    }
    close(F);
    open(F,"+>$nonlocal") or die "Couldn't open $nonlocal: $!";
    print F Data::Dumper::Dumper(\@a);
    close(F);
    print "done\n";
}
