#include "tools.h"
void Cinfog2l(I, J, desc, nprow, npcol, myrow, mycol, ii, jj, prow, pcol)
int I;
int J;
int *desc;
int nprow;
int npcol;
int myrow;
int mycol;
int *ii;
int *jj;
int *prow;
int  *pcol;
{
   int nblocks, dist, extrablocks;
/*
 * Figure values for row
 */
   nblocks = I / desc[MB_];
   *prow = (desc[RSRC_] + nblocks) % nprow;
   dist = (nprow + myrow - desc[RSRC_]) % nprow; /* distance from RSRC */

   *ii = (nblocks/nprow) * desc[MB_];  /* all processes get >= this many */

   extrablocks = nblocks % nprow;
   if (dist < extrablocks) *ii += desc[MB_];
   else if (dist == extrablocks) *ii += I % desc[MB_];

/*
 * Figure values for column
 */
   nblocks = J / desc[NB_];
   *pcol = (desc[CSRC_] + nblocks) % npcol;
   dist = (npcol + mycol - desc[CSRC_]) % npcol; /* distance from CSRC */

   *jj = (nblocks/npcol) * desc[NB_];  /* all processes get >= this many */

   extrablocks = nblocks % npcol;
   if (dist < extrablocks) *jj += desc[NB_];
   else if (dist == extrablocks) *jj += J % desc[NB_];

}
