      SUBROUTINE PBDTRAD1( ICONTXT, UPLO, FORM, M, N, NZ, ALPHA, A, LDA,
     $                     BETA, B, LDB, MINT, NINT, MEN, NEN )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     .. Scalar Arguments ..
      CHARACTER          FORM, UPLO
      INTEGER            ICONTXT, LDA, LDB, M, MEN, MINT, N, NEN, NINT,
     $                   NZ
      DOUBLE PRECISION   ALPHA, BETA
*     ..
*     .. Array Arguments ..
      DOUBLE PRECISION   A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  PBDTRAD1 copies part of an upper (or lower) triangular matrix A
*  to another matrix B:
*                       B <== alpha * A + beta * B
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, J, JP, JX, KZ, MM, MX
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      EXTERNAL           ICEIL, LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           PBDMATADD, PBDVECADD
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN
*     ..
*     .. Executable Statements ..
*
      IF( LSAME( UPLO, 'U' ) ) THEN
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is upper triangular (triangular part is at the bottom)
*
            MM = M
            JP = 0
            DO 10 J = 1, MIN( N-NZ, NEN-JP )
               JX = JP + J
               CALL PBDVECADD( ICONTXT, 'G', MM+J, ALPHA, A( 1, JX ), 1,
     $                         BETA, B( 1, JX ), 1 )
   10       CONTINUE
            MM = MM + MINT - NZ
            JP = JP + NINT - NZ
*
            DO 30 I = 2, ICEIL( NEN+NZ, NINT )
               DO 20 J = 1, MIN( N, NEN-JP )
                  JX = JP + J
                  CALL PBDVECADD( ICONTXT, 'G', MM+J, ALPHA, A( 1,JX ),
     $                            1, BETA, B( 1, JX ), 1 )
   20          CONTINUE
               MM = MM + MINT
               JP = JP + NINT
   30       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            MM = M
            JP = 1
            KZ = NZ
            DO 40 I = 1, ICEIL( NEN+NZ, NINT )
               CALL PBDMATADD( ICONTXT, 'G', MM, MIN( N-KZ, NEN-JP+1 ),
     $                         ALPHA, A( 1, JP ), LDA, BETA, B( 1,JP ),
     $                         LDB )
               MM = MM + MINT
               JP = JP + NINT - KZ
               KZ = 0
   40       CONTINUE
*
         END IF
*
      ELSE
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is lower triangular (triangular part is at the top)
*
            MM = M
            JP = 0
            DO 50 J = 1, MIN( N-NZ, NEN-JP )
               MX = MM + J
               JX = JP + J
               IF( MX.LE.MEN )
     $            CALL PBDVECADD( ICONTXT, 'G', MEN-MX+1, ALPHA,
     $                            A( MX, JX ), 1, BETA, B( MX, JX ), 1 )
   50       CONTINUE
            MM = MM + MINT - NZ
            JP = JP + NINT - NZ
*
            DO 70 I = 2, ICEIL( NEN+NZ, NINT )
               DO 60 J = 1, MIN( N, NEN-JP )
                  MX = MM + J
                  JX = JP + J
                  IF( MX.LE.MEN )
     $               CALL PBDVECADD( ICONTXT, 'G', MEN-MX+1, ALPHA,
     $                               A( MX, JX ), 1, BETA, B( MX, JX ),
     $                               1 )
   60          CONTINUE
               MM = MM + MINT
               JP = JP + NINT
   70       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            MM = M + 1
            JP = 1
            KZ = NZ
            DO 80 I = 1, ICEIL( NEN+NZ, NINT )
               CALL PBDMATADD( ICONTXT, 'G', MEN-MM+1,
     $                         MIN(N-KZ, NEN-JP+1), ALPHA, A( MM, JP ),
     $                         LDA, BETA, B( MM, JP ), LDB )
               MM = MM + MINT
               JP = JP + NINT - KZ
               KZ = 0
   80       CONTINUE
         END IF
      END IF
*
      RETURN
*
*     End of PBDTRAD1
*
      END
