/* $Id: mgimpl.h,v 1.10 1997/07/10 03:44:04 bsmith Exp $ */

/*
      Data structure used for Multigrid preconditioner.
*/
#if !defined(__MG_IMPL)
#define __MG_IMPL
#include "src/pc/pcimpl.h"
#include "mg.h"
#include "sles.h"

typedef struct _MG* MG;

/*
     Structure for abstract multigrid solver. 

     Level (0) is always the coarsest level and Level (levels-1) is the finest.
*/
struct _MG
{
    MGType   am;                           /* Multiplicative, additive or full */
    int      cycles;                       /* Number cycles to run */
    int      level;                        /* level = 0 coarsest level */
    int      levels;                       /* number of active levels used */
    int      maxlevels;                    /* total number of levels allocated */
    Vec      b;                            /* Right hand side */ 
    Vec      x;                            /* Solution */
    Vec      r;                            /* Residual */
    int      (*residual)(Mat,Vec,Vec,Vec);
    Mat      A;                            /* matrix used in forming residual*/ 
    SLES     smoothd;                      /* pre smoother */
    SLES     smoothu;                      /* post smoother */
    Mat      interpolate; 
    Mat      restrct;                      /* restrict is a reserved word on the Cray!!!*/ 
    int      default_smoothu;              /* number of smooths per level if not over-ridden */
    int      default_smoothd;              /*  with calls to KSPSetTolerances() */

};

#endif

