#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: fdq1d.c,v 1.5 1998/03/16 18:08:54 balay Exp $";
#endif
 
#include "src/gvec/impls/rectangular/rectimpl.h"

typedef struct  {
  int            dof;
  DAPeriodicType per;
} Grid_Rectangular_1D_Quadratic;

/*
     Sets up a coloring for 1d problems on a structured grid.
*/

/*

  Input Parameter:
.    J - the GMat (probably empty)

*/
#undef __FUNC__  
#define __FUNC__ "GMatFDColoringCreate_Rectangular_1D_Quadratic"
int GMatFDColoringCreate_Rectangular_1D_Quadratic(GMat J) 
{
  int                           ierr, xs,nx,*colors,i,ii,slot,gxs,xs1;           
  int                           m,dim,w,s,indices[3],*gindices,k,nx1,gnx;
  MPI_Comm                      comm;
  Scalar                        values[3];
  Grid                          grid;
  GridData                      gridd;
  GridData_Rectangular          *gridr;
  DA                            da;

  PetscFunctionBegin;
  /*
                                  m 
          -----------|----|------------------|----|--------------
                  gxs    xs <----- xn ------>                           
                      <--------- gnx ------------>
  */
  ierr  = GMatGetGrid(J,&grid); CHKERRQ(ierr);
  comm  = grid->comm;
  gridd = grid->griddata;
  gridr = (GridData_Rectangular *) gridd->data;
  da    = gridr->da;

  ierr  = DAGetInfo(da,&dim,&m,0,0,0,0,0,&w,&s,0); CHKERRQ(ierr);
  if (w != 1)   SETERRQ(PETSC_ERR_SUP,0,"Scalar problems only");
  if (s != 1)   SETERRQ(PETSC_ERR_SUP,0,"Stencil width 1 only");
  /* also no support for periodic boundary conditions */

  ierr = DAGetCorners(da,&xs,0,0,&nx,0,0); CHKERRQ(ierr);
  ierr = DAGetGhostCorners(da,&gxs,0,0,&gnx,0,0); CHKERRQ(ierr);
  ierr = PetscObjectGetComm((PetscObject)da,&comm); CHKERRQ(ierr);
  ierr = DAGetGlobalIndices(da,PETSC_NULL,&gindices);

  /* create the coloring */
  colors = (int *) PetscMalloc( nx*sizeof(int) ); CHKPTRQ(colors);
  ii = 0;
  for ( i=xs; i<xs+nx; i++ ) {
    colors[ii++] = (i % 3);
  }
  ierr = ISColoringCreate(comm,nx,colors,&grid->iscoloring); CHKERRQ(ierr);
  PetscFree(colors);

  values[0] = 0; values[1] = 0; values[2] = 0;
  /*
      For each node in the grid: we get the neighbors in the local (on processor ordering
    that includes the ghost points) then map those indices to the global PETSc ordering
    before inserting in the matrix
  */
  
  /* fill up Jacobian for left edge */
  xs1 = xs;
  nx1 = nx;
  if (xs == 0) {
    indices[0] = 0; 
    indices[1] = 1; 
    slot       = 0;
    ierr = MatSetValues(J,1,&slot,2,indices,values,INSERT_VALUES); CHKERRQ(ierr);
    xs1++;
    nx1--;
  }      

  /* fill up Jacobian for right edge */
  if (xs + nx == m) {
    indices[0] = gindices[m-gxs-2]; 
    indices[1] = gindices[m-gxs-1];
    slot       = gindices[m-gxs-1];
    ierr = MatSetValues(J,1,&slot,2,indices,values,INSERT_VALUES); CHKERRQ(ierr);
    nx1--;
  }   

  /* fill up Jacobian for interior of grid */
  for ( i=xs1; i<xs1+nx1; i++ ) {
    slot = i - gxs;
    indices[0] = slot - 1; indices[1] = slot; indices[2] = slot + 1;
    for ( k=0; k<3; k++ ) { indices[k] = gindices[indices[k]];}
    slot = gindices[slot];
    ierr = MatSetValues(J,1,&slot,3,indices,values,INSERT_VALUES); CHKERRQ(ierr);
  }
  ierr = MatAssemblyBegin(J,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);  
  ierr = MatAssemblyEnd(J,MAT_FINAL_ASSEMBLY); CHKERRQ(ierr);  

  ierr = MatFDColoringCreate(J,grid->iscoloring,&grid->fdcoloring); CHKERRQ(ierr);
  PetscFunctionReturn(0);
}









