/* matrix.c */
/* Fortran interface file */

/*
 * This file was generated automatically by bfort from the C source
 * file.  
 */

#ifdef USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void *);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void *);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (*(long *)(a))
#define PetscFromPointer(a) (long)(a)
#define PetscRmPointer(a)
#endif

#include "mat.h"
#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matvalid_ PMATVALID
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matvalid_ pmatvalid
#else
#define matvalid_ pmatvalid_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matvalid_ MATVALID
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matvalid_ matvalid
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matsetvalues_ PMATSETVALUES
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvalues_ pmatsetvalues
#else
#define matsetvalues_ pmatsetvalues_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matsetvalues_ MATSETVALUES
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvalues_ matsetvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matsetvaluesblocked_ PMATSETVALUESBLOCKED
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvaluesblocked_ pmatsetvaluesblocked
#else
#define matsetvaluesblocked_ pmatsetvaluesblocked_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matsetvaluesblocked_ MATSETVALUESBLOCKED
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvaluesblocked_ matsetvaluesblocked
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matgetvalues_ PMATGETVALUES
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetvalues_ pmatgetvalues
#else
#define matgetvalues_ pmatgetvalues_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matgetvalues_ MATGETVALUES
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetvalues_ matgetvalues
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matsetlocaltoglobalmapping_ PMATSETLOCALTOGLOBALMAPPING
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetlocaltoglobalmapping_ pmatsetlocaltoglobalmapping
#else
#define matsetlocaltoglobalmapping_ pmatsetlocaltoglobalmapping_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matsetlocaltoglobalmapping_ MATSETLOCALTOGLOBALMAPPING
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetlocaltoglobalmapping_ matsetlocaltoglobalmapping
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matsetlocaltoglobalmappingblocked_ PMATSETLOCALTOGLOBALMAPPINGBLOCKED
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetlocaltoglobalmappingblocked_ pmatsetlocaltoglobalmappingblocked
#else
#define matsetlocaltoglobalmappingblocked_ pmatsetlocaltoglobalmappingblocked_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matsetlocaltoglobalmappingblocked_ MATSETLOCALTOGLOBALMAPPINGBLOCKED
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetlocaltoglobalmappingblocked_ matsetlocaltoglobalmappingblocked
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matsetvalueslocal_ PMATSETVALUESLOCAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvalueslocal_ pmatsetvalueslocal
#else
#define matsetvalueslocal_ pmatsetvalueslocal_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matsetvalueslocal_ MATSETVALUESLOCAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvalueslocal_ matsetvalueslocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matsetvaluesblockedlocal_ PMATSETVALUESBLOCKEDLOCAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvaluesblockedlocal_ pmatsetvaluesblockedlocal
#else
#define matsetvaluesblockedlocal_ pmatsetvaluesblockedlocal_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matsetvaluesblockedlocal_ MATSETVALUESBLOCKEDLOCAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetvaluesblockedlocal_ matsetvaluesblockedlocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matmult_ PMATMULT
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmult_ pmatmult
#else
#define matmult_ pmatmult_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matmult_ MATMULT
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmult_ matmult
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matmulttrans_ PMATMULTTRANS
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttrans_ pmatmulttrans
#else
#define matmulttrans_ pmatmulttrans_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matmulttrans_ MATMULTTRANS
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttrans_ matmulttrans
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matmultadd_ PMATMULTADD
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmultadd_ pmatmultadd
#else
#define matmultadd_ pmatmultadd_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matmultadd_ MATMULTADD
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmultadd_ matmultadd
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matmulttransadd_ PMATMULTTRANSADD
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttransadd_ pmatmulttransadd
#else
#define matmulttransadd_ pmatmulttransadd_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matmulttransadd_ MATMULTTRANSADD
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matmulttransadd_ matmulttransadd
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matiludtfactor_ PMATILUDTFACTOR
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matiludtfactor_ pmatiludtfactor
#else
#define matiludtfactor_ pmatiludtfactor_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matiludtfactor_ MATILUDTFACTOR
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matiludtfactor_ matiludtfactor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matlufactor_ PMATLUFACTOR
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matlufactor_ pmatlufactor
#else
#define matlufactor_ pmatlufactor_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matlufactor_ MATLUFACTOR
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matlufactor_ matlufactor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matilufactor_ PMATILUFACTOR
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matilufactor_ pmatilufactor
#else
#define matilufactor_ pmatilufactor_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matilufactor_ MATILUFACTOR
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matilufactor_ matilufactor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matlufactorsymbolic_ PMATLUFACTORSYMBOLIC
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matlufactorsymbolic_ pmatlufactorsymbolic
#else
#define matlufactorsymbolic_ pmatlufactorsymbolic_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matlufactorsymbolic_ MATLUFACTORSYMBOLIC
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matlufactorsymbolic_ matlufactorsymbolic
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matlufactornumeric_ PMATLUFACTORNUMERIC
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matlufactornumeric_ pmatlufactornumeric
#else
#define matlufactornumeric_ pmatlufactornumeric_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matlufactornumeric_ MATLUFACTORNUMERIC
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matlufactornumeric_ matlufactornumeric
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matcholeskyfactor_ PMATCHOLESKYFACTOR
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcholeskyfactor_ pmatcholeskyfactor
#else
#define matcholeskyfactor_ pmatcholeskyfactor_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matcholeskyfactor_ MATCHOLESKYFACTOR
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcholeskyfactor_ matcholeskyfactor
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matcholeskyfactorsymbolic_ PMATCHOLESKYFACTORSYMBOLIC
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcholeskyfactorsymbolic_ pmatcholeskyfactorsymbolic
#else
#define matcholeskyfactorsymbolic_ pmatcholeskyfactorsymbolic_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matcholeskyfactorsymbolic_ MATCHOLESKYFACTORSYMBOLIC
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcholeskyfactorsymbolic_ matcholeskyfactorsymbolic
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matcholeskyfactornumeric_ PMATCHOLESKYFACTORNUMERIC
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcholeskyfactornumeric_ pmatcholeskyfactornumeric
#else
#define matcholeskyfactornumeric_ pmatcholeskyfactornumeric_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matcholeskyfactornumeric_ MATCHOLESKYFACTORNUMERIC
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcholeskyfactornumeric_ matcholeskyfactornumeric
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matsolve_ PMATSOLVE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolve_ pmatsolve
#else
#define matsolve_ pmatsolve_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matsolve_ MATSOLVE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolve_ matsolve
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matsolveadd_ PMATSOLVEADD
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolveadd_ pmatsolveadd
#else
#define matsolveadd_ pmatsolveadd_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matsolveadd_ MATSOLVEADD
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolveadd_ matsolveadd
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matsolvetrans_ PMATSOLVETRANS
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolvetrans_ pmatsolvetrans
#else
#define matsolvetrans_ pmatsolvetrans_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matsolvetrans_ MATSOLVETRANS
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolvetrans_ matsolvetrans
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matsolvetransadd_ PMATSOLVETRANSADD
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolvetransadd_ pmatsolvetransadd
#else
#define matsolvetransadd_ pmatsolvetransadd_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matsolvetransadd_ MATSOLVETRANSADD
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsolvetransadd_ matsolvetransadd
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matrelax_ PMATRELAX
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matrelax_ pmatrelax
#else
#define matrelax_ pmatrelax_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matrelax_ MATRELAX
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matrelax_ matrelax
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matgetdiagonal_ PMATGETDIAGONAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetdiagonal_ pmatgetdiagonal
#else
#define matgetdiagonal_ pmatgetdiagonal_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matgetdiagonal_ MATGETDIAGONAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetdiagonal_ matgetdiagonal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matequal_ PMATEQUAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matequal_ pmatequal
#else
#define matequal_ pmatequal_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matequal_ MATEQUAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matequal_ matequal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matdiagonalscale_ PMATDIAGONALSCALE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matdiagonalscale_ pmatdiagonalscale
#else
#define matdiagonalscale_ pmatdiagonalscale_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matdiagonalscale_ MATDIAGONALSCALE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matdiagonalscale_ matdiagonalscale
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matscale_ PMATSCALE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matscale_ pmatscale
#else
#define matscale_ pmatscale_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matscale_ MATSCALE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matscale_ matscale
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matnorm_ PMATNORM
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matnorm_ pmatnorm
#else
#define matnorm_ pmatnorm_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matnorm_ MATNORM
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matnorm_ matnorm
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matassemblybegin_ PMATASSEMBLYBEGIN
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matassemblybegin_ pmatassemblybegin
#else
#define matassemblybegin_ pmatassemblybegin_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matassemblybegin_ MATASSEMBLYBEGIN
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matassemblybegin_ matassemblybegin
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matassemblyend_ PMATASSEMBLYEND
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matassemblyend_ pmatassemblyend
#else
#define matassemblyend_ pmatassemblyend_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matassemblyend_ MATASSEMBLYEND
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matassemblyend_ matassemblyend
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matcompress_ PMATCOMPRESS
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcompress_ pmatcompress
#else
#define matcompress_ pmatcompress_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matcompress_ MATCOMPRESS
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matcompress_ matcompress
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matsetoption_ PMATSETOPTION
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetoption_ pmatsetoption
#else
#define matsetoption_ pmatsetoption_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matsetoption_ MATSETOPTION
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetoption_ matsetoption
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matzeroentries_ PMATZEROENTRIES
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matzeroentries_ pmatzeroentries
#else
#define matzeroentries_ pmatzeroentries_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matzeroentries_ MATZEROENTRIES
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matzeroentries_ matzeroentries
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matzerorows_ PMATZEROROWS
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matzerorows_ pmatzerorows
#else
#define matzerorows_ pmatzerorows_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matzerorows_ MATZEROROWS
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matzerorows_ matzerorows
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matzerorowslocal_ PMATZEROROWSLOCAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matzerorowslocal_ pmatzerorowslocal
#else
#define matzerorowslocal_ pmatzerorowslocal_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matzerorowslocal_ MATZEROROWSLOCAL
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matzerorowslocal_ matzerorowslocal
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matgetsize_ PMATGETSIZE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetsize_ pmatgetsize
#else
#define matgetsize_ pmatgetsize_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matgetsize_ MATGETSIZE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetsize_ matgetsize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matgetlocalsize_ PMATGETLOCALSIZE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetlocalsize_ pmatgetlocalsize
#else
#define matgetlocalsize_ pmatgetlocalsize_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matgetlocalsize_ MATGETLOCALSIZE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetlocalsize_ matgetlocalsize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matgetownershiprange_ PMATGETOWNERSHIPRANGE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetownershiprange_ pmatgetownershiprange
#else
#define matgetownershiprange_ pmatgetownershiprange_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matgetownershiprange_ MATGETOWNERSHIPRANGE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetownershiprange_ matgetownershiprange
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matilufactorsymbolic_ PMATILUFACTORSYMBOLIC
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matilufactorsymbolic_ pmatilufactorsymbolic
#else
#define matilufactorsymbolic_ pmatilufactorsymbolic_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matilufactorsymbolic_ MATILUFACTORSYMBOLIC
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matilufactorsymbolic_ matilufactorsymbolic
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matincompletecholeskyfactorsymbolic_ PMATINCOMPLETECHOLESKYFACTORSYMBOLIC
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matincompletecholeskyfactorsymbolic_ pmatincompletecholeskyfactorsymbolic
#else
#define matincompletecholeskyfactorsymbolic_ pmatincompletecholeskyfactorsymbolic_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matincompletecholeskyfactorsymbolic_ MATINCOMPLETECHOLESKYFACTORSYMBOLIC
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matincompletecholeskyfactorsymbolic_ matincompletecholeskyfactorsymbolic
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matincreaseoverlap_ PMATINCREASEOVERLAP
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matincreaseoverlap_ pmatincreaseoverlap
#else
#define matincreaseoverlap_ pmatincreaseoverlap_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matincreaseoverlap_ MATINCREASEOVERLAP
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matincreaseoverlap_ matincreaseoverlap
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matprinthelp_ PMATPRINTHELP
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matprinthelp_ pmatprinthelp
#else
#define matprinthelp_ pmatprinthelp_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matprinthelp_ MATPRINTHELP
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matprinthelp_ matprinthelp
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matgetblocksize_ PMATGETBLOCKSIZE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetblocksize_ pmatgetblocksize
#else
#define matgetblocksize_ pmatgetblocksize_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matgetblocksize_ MATGETBLOCKSIZE
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetblocksize_ matgetblocksize
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matsetunfactored_ PMATSETUNFACTORED
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetunfactored_ pmatsetunfactored
#else
#define matsetunfactored_ pmatsetunfactored_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matsetunfactored_ MATSETUNFACTORED
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matsetunfactored_ matsetunfactored
#endif
#endif

#ifdef MPI_BUILD_PROFILING
#ifdef HAVE_FORTRAN_CAPS
#define matgetsubmatrix_ PMATGETSUBMATRIX
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetsubmatrix_ pmatgetsubmatrix
#else
#define matgetsubmatrix_ pmatgetsubmatrix_
#endif
#else
#ifdef HAVE_FORTRAN_CAPS
#define matgetsubmatrix_ MATGETSUBMATRIX
#elif !defined(HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define matgetsubmatrix_ matgetsubmatrix
#endif
#endif



/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
void matvalid_(Mat m,PetscTruth *flg, int *__ierr ){
*__ierr = MatValid(
	(Mat)PetscToPointer( (m) ),flg);
}
void matsetvalues_(Mat mat,int *m,int *idxm,int *n,int *idxn,Scalar *v,InsertMode *addv, int *__ierr ){
*__ierr = MatSetValues(
	(Mat)PetscToPointer( (mat) ),*m,idxm,*n,idxn,v,*addv);
}
void matsetvaluesblocked_(Mat mat,int *m,int *idxm,int *n,int *idxn,Scalar *v,InsertMode *addv, int *__ierr ){
*__ierr = MatSetValuesBlocked(
	(Mat)PetscToPointer( (mat) ),*m,idxm,*n,idxn,v,*addv);
}
void matgetvalues_(Mat mat,int *m,int *idxm,int *n,int *idxn,Scalar *v, int *__ierr ){
*__ierr = MatGetValues(
	(Mat)PetscToPointer( (mat) ),*m,idxm,*n,idxn,v);
}
void matsetlocaltoglobalmapping_(Mat x,ISLocalToGlobalMapping mapping, int *__ierr ){
*__ierr = MatSetLocalToGlobalMapping(
	(Mat)PetscToPointer( (x) ),
	(ISLocalToGlobalMapping)PetscToPointer( (mapping) ));
}
void matsetlocaltoglobalmappingblocked_(Mat x,ISLocalToGlobalMapping mapping, int *__ierr ){
*__ierr = MatSetLocalToGlobalMappingBlocked(
	(Mat)PetscToPointer( (x) ),
	(ISLocalToGlobalMapping)PetscToPointer( (mapping) ));
}
void matsetvalueslocal_(Mat mat,int *nrow,int *irow,int *ncol,int *icol,Scalar *y,InsertMode *addv, int *__ierr ){
*__ierr = MatSetValuesLocal(
	(Mat)PetscToPointer( (mat) ),*nrow,irow,*ncol,icol,y,*addv);
}
void matsetvaluesblockedlocal_(Mat mat,int *nrow,int *irow,int *ncol,int *icol,Scalar *y,InsertMode *addv, int *__ierr ){
*__ierr = MatSetValuesBlockedLocal(
	(Mat)PetscToPointer( (mat) ),*nrow,irow,*ncol,icol,y,*addv);
}
void matmult_(Mat mat,Vec x,Vec y, int *__ierr ){
*__ierr = MatMult(
	(Mat)PetscToPointer( (mat) ),
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ));
}
void matmulttrans_(Mat mat,Vec x,Vec y, int *__ierr ){
*__ierr = MatMultTrans(
	(Mat)PetscToPointer( (mat) ),
	(Vec)PetscToPointer( (x) ),
	(Vec)PetscToPointer( (y) ));
}
void matmultadd_(Mat mat,Vec v1,Vec v2,Vec v3, int *__ierr ){
*__ierr = MatMultAdd(
	(Mat)PetscToPointer( (mat) ),
	(Vec)PetscToPointer( (v1) ),
	(Vec)PetscToPointer( (v2) ),
	(Vec)PetscToPointer( (v3) ));
}
void matmulttransadd_(Mat mat,Vec v1,Vec v2,Vec v3, int *__ierr ){
*__ierr = MatMultTransAdd(
	(Mat)PetscToPointer( (mat) ),
	(Vec)PetscToPointer( (v1) ),
	(Vec)PetscToPointer( (v2) ),
	(Vec)PetscToPointer( (v3) ));
}
void matiludtfactor_(Mat mat,double *dt,int *maxnz,IS row,IS col,Mat *fact, int *__ierr ){
*__ierr = MatILUDTFactor(
	(Mat)PetscToPointer( (mat) ),*dt,*maxnz,
	(IS)PetscToPointer( (row) ),
	(IS)PetscToPointer( (col) ),fact);
}
void matlufactor_(Mat mat,IS row,IS col,double *f, int *__ierr ){
*__ierr = MatLUFactor(
	(Mat)PetscToPointer( (mat) ),
	(IS)PetscToPointer( (row) ),
	(IS)PetscToPointer( (col) ),*f);
}
void matilufactor_(Mat mat,IS row,IS col,double *f,int *level, int *__ierr ){
*__ierr = MatILUFactor(
	(Mat)PetscToPointer( (mat) ),
	(IS)PetscToPointer( (row) ),
	(IS)PetscToPointer( (col) ),*f,*level);
}
void matlufactorsymbolic_(Mat mat,IS row,IS col,double *f,Mat *fact, int *__ierr ){
*__ierr = MatLUFactorSymbolic(
	(Mat)PetscToPointer( (mat) ),
	(IS)PetscToPointer( (row) ),
	(IS)PetscToPointer( (col) ),*f,fact);
}
void matlufactornumeric_(Mat mat,Mat *fact, int *__ierr ){
*__ierr = MatLUFactorNumeric(
	(Mat)PetscToPointer( (mat) ),fact);
}
void matcholeskyfactor_(Mat mat,IS perm,double *f, int *__ierr ){
*__ierr = MatCholeskyFactor(
	(Mat)PetscToPointer( (mat) ),
	(IS)PetscToPointer( (perm) ),*f);
}
void matcholeskyfactorsymbolic_(Mat mat,IS perm,double *f,Mat *fact, int *__ierr ){
*__ierr = MatCholeskyFactorSymbolic(
	(Mat)PetscToPointer( (mat) ),
	(IS)PetscToPointer( (perm) ),*f,fact);
}
void matcholeskyfactornumeric_(Mat mat,Mat *fact, int *__ierr ){
*__ierr = MatCholeskyFactorNumeric(
	(Mat)PetscToPointer( (mat) ),fact);
}
void matsolve_(Mat mat,Vec b,Vec x, int *__ierr ){
*__ierr = MatSolve(
	(Mat)PetscToPointer( (mat) ),
	(Vec)PetscToPointer( (b) ),
	(Vec)PetscToPointer( (x) ));
}
void matsolveadd_(Mat mat,Vec b,Vec y,Vec x, int *__ierr ){
*__ierr = MatSolveAdd(
	(Mat)PetscToPointer( (mat) ),
	(Vec)PetscToPointer( (b) ),
	(Vec)PetscToPointer( (y) ),
	(Vec)PetscToPointer( (x) ));
}
void matsolvetrans_(Mat mat,Vec b,Vec x, int *__ierr ){
*__ierr = MatSolveTrans(
	(Mat)PetscToPointer( (mat) ),
	(Vec)PetscToPointer( (b) ),
	(Vec)PetscToPointer( (x) ));
}
void matsolvetransadd_(Mat mat,Vec b,Vec y,Vec x, int *__ierr ){
*__ierr = MatSolveTransAdd(
	(Mat)PetscToPointer( (mat) ),
	(Vec)PetscToPointer( (b) ),
	(Vec)PetscToPointer( (y) ),
	(Vec)PetscToPointer( (x) ));
}
void matrelax_(Mat mat,Vec b,double *omega,MatSORType *flag,double *shift,
             int *its,Vec x, int *__ierr ){
*__ierr = MatRelax(
	(Mat)PetscToPointer( (mat) ),
	(Vec)PetscToPointer( (b) ),*omega,*flag,*shift,*its,
	(Vec)PetscToPointer( (x) ));
}
void matgetdiagonal_(Mat mat,Vec v, int *__ierr ){
*__ierr = MatGetDiagonal(
	(Mat)PetscToPointer( (mat) ),
	(Vec)PetscToPointer( (v) ));
}
void matequal_(Mat A,Mat B,PetscTruth *flg, int *__ierr ){
*__ierr = MatEqual(
	(Mat)PetscToPointer( (A) ),
	(Mat)PetscToPointer( (B) ),flg);
}
void matdiagonalscale_(Mat mat,Vec l,Vec r, int *__ierr ){
*__ierr = MatDiagonalScale(
	(Mat)PetscToPointer( (mat) ),
	(Vec)PetscToPointer( (l) ),
	(Vec)PetscToPointer( (r) ));
}
void matscale_(Scalar *a,Mat mat, int *__ierr ){
*__ierr = MatScale(a,
	(Mat)PetscToPointer( (mat) ));
}
void matnorm_(Mat mat,NormType *type,double *norm, int *__ierr ){
*__ierr = MatNorm(
	(Mat)PetscToPointer( (mat) ),*type,norm);
}
void matassemblybegin_(Mat mat,MatAssemblyType *type, int *__ierr ){
*__ierr = MatAssemblyBegin(
	(Mat)PetscToPointer( (mat) ),*type);
}
void matassemblyend_(Mat mat,MatAssemblyType *type, int *__ierr ){
*__ierr = MatAssemblyEnd(
	(Mat)PetscToPointer( (mat) ),*type);
}
void matcompress_(Mat mat, int *__ierr ){
*__ierr = MatCompress(
	(Mat)PetscToPointer( (mat) ));
}
void matsetoption_(Mat mat,MatOption *op, int *__ierr ){
*__ierr = MatSetOption(
	(Mat)PetscToPointer( (mat) ),*op);
}
void matzeroentries_(Mat mat, int *__ierr ){
*__ierr = MatZeroEntries(
	(Mat)PetscToPointer( (mat) ));
}
void matzerorows_(Mat mat,IS is,Scalar *diag, int *__ierr ){
*__ierr = MatZeroRows(
	(Mat)PetscToPointer( (mat) ),
	(IS)PetscToPointer( (is) ),diag);
}
void matzerorowslocal_(Mat mat,IS is,Scalar *diag, int *__ierr ){
*__ierr = MatZeroRowsLocal(
	(Mat)PetscToPointer( (mat) ),
	(IS)PetscToPointer( (is) ),diag);
}
void matgetsize_(Mat mat,int *m,int* n, int *__ierr ){
*__ierr = MatGetSize(
	(Mat)PetscToPointer( (mat) ),m,n);
}
void matgetlocalsize_(Mat mat,int *m,int* n, int *__ierr ){
*__ierr = MatGetLocalSize(
	(Mat)PetscToPointer( (mat) ),m,n);
}
void matgetownershiprange_(Mat mat,int *m,int* n, int *__ierr ){
*__ierr = MatGetOwnershipRange(
	(Mat)PetscToPointer( (mat) ),m,n);
}
void matilufactorsymbolic_(Mat mat,IS row,IS col,double *f,int *fill,Mat *fact, int *__ierr ){
*__ierr = MatILUFactorSymbolic(
	(Mat)PetscToPointer( (mat) ),
	(IS)PetscToPointer( (row) ),
	(IS)PetscToPointer( (col) ),*f,*fill,fact);
}
void matincompletecholeskyfactorsymbolic_(Mat mat,IS perm,double *f,int *fill,Mat *fact, int *__ierr ){
*__ierr = MatIncompleteCholeskyFactorSymbolic(
	(Mat)PetscToPointer( (mat) ),
	(IS)PetscToPointer( (perm) ),*f,*fill,fact);
}
void matincreaseoverlap_(Mat mat,int *n,IS *is,int *ov, int *__ierr ){
*__ierr = MatIncreaseOverlap(
	(Mat)PetscToPointer( (mat) ),*n,is,*ov);
}
void matprinthelp_(Mat mat, int *__ierr ){
*__ierr = MatPrintHelp(
	(Mat)PetscToPointer( (mat) ));
}
void matgetblocksize_(Mat mat,int *bs, int *__ierr ){
*__ierr = MatGetBlockSize(
	(Mat)PetscToPointer( (mat) ),bs);
}
void matsetunfactored_(Mat mat, int *__ierr ){
*__ierr = MatSetUnfactored(
	(Mat)PetscToPointer( (mat) ));
}
void matgetsubmatrix_(Mat mat,IS isrow,IS iscol,int *csize,MatGetSubMatrixCall *cll,Mat *newmat, int *__ierr ){
*__ierr = MatGetSubMatrix(
	(Mat)PetscToPointer( (mat) ),
	(IS)PetscToPointer( (isrow) ),
	(IS)PetscToPointer( (iscol) ),*csize,*cll,newmat);
}
#if defined(__cplusplus)
}
#endif
