
/* $Id: gvec.h,v 1.14 1998/04/16 22:47:19 balay Exp $ */

/*
      EXPERIMENTAL CODE - Use at your own risk.

    Routines for working with grids and vectors that represent functions
  on the grids.
*/

#ifndef __GVEC_H
#define __GVEC_H

#include "da.h"
#include "snes.h"

/* ----------------------------------------------------------------------------*/
/*
     A griddata is geometric information about a region, including possibly 
   points, cells etc.
*/
typedef enum {GRIDDATA_RECTANGULAR_1D,GRIDDATA_RECTANGULAR_2D,GRIDDATA_RECTANGULAR_3D,
              GRIDDATA_TRIANGLES} 
              GridDataType;

#define GRIDDATA_COOKIE PETSC_COOKIE+23
typedef struct _p_GridData* GridData;


extern int GridDataSetUp(GridData);
extern int GridDataView(GridData,Viewer);
extern int GridDataRefine(GridData,int,GridData *);
extern int GridDataDestroy(GridData);
extern int GridDataCopy(GridData,GridData);
extern int GridDataDuplicate(GridData,GridData *);

/* ----------------------------------------------------------------------------*/
/*
     A Grid is a griddata plus information about the discretization being used.
*/
typedef enum {DISCRETIZATION_LINEAR, DISCRETIZATION_BILINEAR, 
              DISCRETIZATION_QUADRATIC} DiscretizationType;

#define GRID_COOKIE PETSC_COOKIE+21
typedef struct _p_Grid* Grid;

extern int GridDataCreateGrid(GridData,DiscretizationType,Grid*);


extern int GridSetUp(Grid);
extern int GridGetGridData(Grid,GridData *);
extern int GridDestroy(Grid);
extern int GridView(Grid,Viewer);
extern int GridRefine(Grid,int,Grid *);

/* ----------------------------------------------------------------------------*/

extern int GridDataCreateRectangular1D(MPI_Comm,int,double,double,double *,GridData *);
extern int GridCreateRectangular1D(MPI_Comm,int,double,double,double *,DiscretizationType,Grid *);
extern int GridDataCreateRectangular2D(MPI_Comm,int,double,double,double *,
                                       int,double,double,double*,GridData *);
extern int GridCreateRectangular2D(MPI_Comm,int,double,double,double *,
                                   int,double,double,double*,DiscretizationType,Grid *);

extern int GridDataRectangularGetDA(GridData,DA*);
extern int GridDataRectangularGetXYZ(GridData,double**,double**,double**);

extern int GridRectangularSetPeriodicType(Grid,DAPeriodicType);

/* ----------------------------------------------------------------------------*/
/*
    A GVec is a vector plus all the grid and discretization information.
*/
#define GVec Vec
#define GMat Mat

extern int GVecInitialize(void);

typedef int (PointFunction)(int,double*,double*,double*,Scalar*,void*);
extern PointFunction PointFunctionOne;
extern PointFunction PointFunctionZero;

extern int GridCreateGVec(Grid,GVec *);
extern int GridCreateGMat(Grid,GMat*);
extern int GridCreateRestriction(Grid,Grid,GMat *);
extern int GVecGetGrid(GVec,Grid *);
extern int GMatGetGrid(GMat,Grid *);

extern int GVecGetLocalWorkGVec(GVec,GVec *);
extern int GVecRestoreLocalWorkGVec(GVec,GVec *);
extern int GVecGetWorkGVec(GVec,GVec*);
extern int GVecRestoreWorkGVec(GVec,GVec *);
extern int GVecGlobalToLocal(GVec,InsertMode,GVec);
extern int GVecLocalToGlobal(GVec,InsertMode,GVec);


typedef enum {GVEC_COMPONENT_1 = 1,GVEC_COMPONENT_2 = 2,GVEC_COMPONENT_3 = 4} 
              GVecComponents;

extern int GVecGetComponentGVecs(GVec,GVecComponents,GVec *);
extern int GVecAssembleComponentGVecs(GVec,GVecComponents,GVec *);
extern int GVecCreateComponentGVecs(GVec,GVecComponents,int *,GVec **);

extern int GVecView(GVec,Viewer);

extern int GVecEvaluateFunction(GVec,PointFunction,void*);
extern int GVecEvaluateFunctionGalerkin(GVec,PointFunction,void*);

extern int GMatFDColoringCreate(GMat);
extern int GMatFDColoringApply(GMat,Vec,MatStructure *,void *);

/*
    GVec routines specifically related to linear solvers 
*/
typedef struct {
  Viewer error_viewer;
  Viewer norm_error_viewer;
  GVec   solution;
} GVecErrorKSPMonitorCtx;
 
extern int GVecSolutionKSPMonitor(KSP,int,double,void*);
extern int GVecResidualKSPMonitor(KSP,int,double,void*);
extern int GVecErrorKSPMonitor(KSP,int,double,void*);
extern int GVecRhsKSPMonitor(KSP,int,double,void*);

#define GVECPCMGMONITOR_SOLUTION 1
#define GVECPCMGMONITOR_RESIDUAL 2
#define GVECPCMGMONITOR_RHS      4
extern int GVecPCMGSetMonitor(PC,int);

/*
    GVec routines specifically related to nonlinear solvers 
*/
typedef GVecErrorKSPMonitorCtx GVecErrorSNESMonitorCtx;
extern int GVecSolutionSNESMonitor(SNES,int,double,void*);
extern int GVecResidualSNESMonitor(SNES,int,double,void*);
extern int GVecErrorSNESMonitor(SNES,int,double,void*);
extern int GVecSNESDefaultComputeJacobianWithColoring(SNES,GVec,GMat*,GMat*,MatStructure*,void*);

#endif






