package jumpshot;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

//This class shows up a dialog having the size options for printing
public class PrintDlg extends Dialog 
implements ActionListener, ItemListener {
  ClogDisplay parent;
  Frame printFrame;
  
  MyTextField widthTxField, heightTxField;
  CheckboxGroup g;
  Checkbox inchesChkBox;
 
  double nonPrintGap;
  int finalWidth, finalHeight, maxPageW, maxPageH, dpi;
  Dimension pageDim;
 
  PrintJob pjob;
  
  public PrintDlg (ClogDisplay p) {
    super ((Frame)p, "Print Options", true);
    parent = p;
    setup ();
  }
  
  //setup methods----------------------------------------------------------
  void setup () {
    adjustFrameStuff ();
    setupPanel ();
  }
  
  void adjustFrameStuff () {
    setFont (parent.frameFont);
    setBackground (parent.frameBColor);
    setForeground (parent.frameFColor);
  }

  void setupPanel () {
    setLayout (new GridBagLayout ());
    GridBagConstraints con = new GridBagConstraints ();
    con.fill = GridBagConstraints.BOTH;
    con.weightx = 1.0; con.weighty = 1.0;
    
    con.gridx = 0; con.gridy = 0;
    add (new Label ("width:"), con);
    
    con.gridx = 1;
    add (widthTxField = new MyTextField ("", 10, true), con);
    
    con.gridx = 0; con.gridy = 1;
    add (new Label ("height:"), con);
    
    con.gridx = 1;
    add (heightTxField = new MyTextField ("", 10, true), con);
    
    //Attach radio buttons for dimensions
    g = new CheckboxGroup ();
    
    Checkbox c = new Checkbox ("cm", g, false);
    c.addItemListener (this);
    con.gridx = 2; con.gridy = 0; add (c, con);

    c = new Checkbox ("mm", g, false);
    c.addItemListener (this);
    con.gridy = 1; add (c, con);

    inchesChkBox = new Checkbox ("inches", g, false);
    inchesChkBox.addItemListener (this);
    con.gridy = 2; add (inchesChkBox, con);

    c = new Checkbox ("points", g, false);
    c.addItemListener (this);
    con.gridy = 3; add (c, con);
    
    con.gridx = 0;
    add (new MyButton ("Ok", this), con);
    
    con.gridx = 1;
    add (new MyButton ("Cancel Printing", this), con);

    pack ();
    setSize (getMinimumSize ());
  }
  //end of setup methods--------------------------------------------------------------
  
  //event handler methods-------------------------------------------------------------
  //events generated by buttons and radio buttons are caught

  //event handler for events generated by radio buttons
  public void itemStateChanged (ItemEvent e) {
    if (e.getStateChange () == ItemEvent.DESELECTED) return;
    if (e.getItem ().equals ("mm")) 
      {width (toMm (maxPageW)); height (toMm (maxPageH));}
    else if (e.getItem ().equals ("cm")) 
      {width (toCm (maxPageW)); height (toCm (maxPageH));}
    else if (e.getItem ().equals ("inches")) 
      {width (toInches (maxPageW)); height (toInches (maxPageH));}
    else if (e.getItem ().equals ("points")) 
      {width (maxPageW); height (maxPageH);}
  }

  //event handler for events generated by buttons
  public void actionPerformed (ActionEvent evt) {
    double w, h;
    String command = evt.getActionCommand ();
    if (command.equals ("Ok")) {
      setVisible (false);
      String name = g.getSelectedCheckbox ().getLabel ();
      double wVal = (new Double (widthTxField.getText ())).doubleValue ();
      double hVal = (new Double (heightTxField.getText ())).doubleValue ();
      if (name.equals ("cm")) {w = fromCm (wVal); h = fromCm (hVal);}
      else if (name.equals ("mm")) {w = fromMm (wVal); h = fromMm (hVal);}
      else if (name.equals ("inches")) {w = fromInches (wVal); h = fromInches (hVal);}
      else {w = wVal; h = hVal;}
      
      finalWidth = (int)Math.rint (w);
      finalHeight = (int)Math.rint (h);
      
      //Final Dimensions of the upshot data
      if (finalWidth > maxPageW) finalWidth = maxPageW;
      if (finalHeight > maxPageH) finalHeight = maxPageH;
      
      Graphics pg = pjob.getGraphics ();
      
      //Need to set the font or else ava crashes
      pg.setFont (parent.printFont); 
      FontMetrics fm = getToolkit ().getFontMetrics (pg.getFont ());
      if (pg != null) {
        //Center the image first.
        int hgap = (int)Math.rint (nonPrintGap + (maxPageW - finalWidth) / 2.0);
        int vgap = (int)Math.rint (nonPrintGap + (maxPageH - finalHeight) / 2.0);
        
        //Draw the header
        pg.setColor (parent.printBColor);
        pg.fill3DRect (0, 0, pageDim.width, pageDim.height, true);
        pg.setColor (Color.white);
        pg.drawString ("JUMPSHOT, Logfile:" + parent.parent.logFileName + 
                       ", Format:" + "clog", hgap, vgap + fm.getHeight ());
        
        //Print the states, arrows and associated time line
        if (printFrame instanceof ClogDisplay) {
          //Print the Key
          int val = parent.stateButtons.drawStuff (pg, hgap, vgap + fm.getHeight () * 2, 
                                                   finalWidth, finalHeight);
          //Print the Jumpshot data
          parent.canvas.print (pg, hgap + parent.vcanvas1.maxH, val, 
                               finalWidth - parent.vcanvas1.maxH, finalHeight - 
                               (val - vgap));
          
          // Print the Process scale
          parent.vcanvas1.drawStuff (pg, hgap, val, finalHeight - (val - vgap));
        }
        //Print histogram
        else if (printFrame instanceof Histwin) {
          Histwin win = (Histwin)printFrame;
          
          //print the state information
          pg.drawString ("'" + win.stateDef.description.desc + "'" + " state length distribution",
                         hgap, vgap + 2 * fm.getHeight ());
          
          pg.drawString (Integer.toString (win.canvas.view.statesDrawn) + " states of " +
                         Integer.toString (win.canvas.stateVector.size ()) + " (" + 
                         (new Float (win.canvas.view.statesDrawn * 100.0 / 
                                     (double)win.canvas.stateVector.size ())).toString () + "%)",
                         hgap, vgap + 3 * fm.getHeight ());
          
          //Print the Histogram data
          win.canvas.print (pg, hgap, 4 * fm.getHeight () + vgap, 
                               finalWidth, finalHeight - 4 * fm.getHeight ());
        }
          
        //flush the page from the printer when done
        pg.dispose (); 
      }
      pjob.end ();
    }
    else if (command.equals ("Cancel Printing")){ 
      setVisible (false);
      pjob.end ();
    }
  }
  //end of event handler methods-----------------------------------------------------------
  
  //This function is called when the user selects Ok to print
  //Options for size and printing commands are given.
  public void reset (PrintJob pj, Frame frame) {
    pjob = pj;
    printFrame = frame;
    pageDim = pjob.getPageDimension ();
    dpi = getToolkit ().getScreenResolution ();
    
    //Account for the non printing area (typically 1/4 th of an inch at all four sides)
    nonPrintGap = (double)0.25 * dpi;
    
    maxPageW = pageDim.width - (int)Math.round (2 * nonPrintGap);
    maxPageH = pageDim.height - (int)Math.round (2 * nonPrintGap);
    
    inchesChkBox.setState (true);
    
    width (toInches (maxPageW));
    height (toInches (maxPageH));
    
    setVisible (true);
  }
  
  //Functions to put the string in the text fields
  void width (double w) {widthTxField.setText (Float.toString ((float)w));}
  void height (double h) {heightTxField.setText (Float.toString ((float)h));}

  //Functions to convert
  double toInches (double dots) {return (double)(dots * 1.0 / dpi); }
  double toCm (double dots) {return (double)(toInches (dots) * 2.54);}
  double toMm (double dots) {return toCm (dots) * 10;}
  double fromInches (double inches) {return inches * dpi;}
  double fromCm (double cm) {return (double)(fromInches (cm) / 2.54);}
  double fromMm (double mm) {return (fromCm (mm) / 10);}
}










