package jumpshot;

import java.awt.*;
import java.util.Vector;
import java.awt.event.*;

//This dialog displays options
public class CanOptions extends Dialog 
implements ActionListener, ItemListener {
  ClogDisplay parent;
  Checkbox arrowsChkBox, elTLineChkBox, zoomLkLineChkBox;
  MyTextField nFacTxField;
  
  public CanOptions (ClogDisplay p) {
    super ((Frame)p, "Canvas Options", false);
    parent = p;
    setup ();
  }
  
  //setup methods--------------------------------------------------------
  void setup () {
    adjustDlgStuff ();
    setupPanel ();
    
    // Define, instantiate and register a WindowListener object.
    addWindowListener (new WindowAdapter () {
      public void windowClosing (WindowEvent e) {setVisible (false);}
    });
  }
  
  void adjustDlgStuff () {
    setFont (parent.frameFont);
    setBackground (parent.frameBColor);
    setForeground (parent.frameFColor);
  }

  void setupPanel () {
    setLayout (new GridBagLayout ());
    GridBagConstraints con = new GridBagConstraints ();
    con.fill = GridBagConstraints.BOTH;
    con.weightx = 1.0; con.weighty = 1.0;
    
    con.gridx = 0;
    add (arrowsChkBox = new Checkbox ("Arrows Display"), con);
    arrowsChkBox.addItemListener (this);
    
    con.gridx = 0; con.gridy = 1;
    add (elTLineChkBox = new Checkbox ("Elapsed Time Line Display"), con);
    elTLineChkBox.addItemListener (this);
    
    con.gridx = 1; 
    add (new MyButton ("Reset Elapsed Time", this), con);
    
    con.gridx = 0; con.gridy = 2;
    add (zoomLkLineChkBox = new Checkbox ("Zoom Lock Line Display"), con);
    zoomLkLineChkBox.addItemListener (this);
    
    con.gridx = 0; con.gridy = 3;
    add (nFacTxField = new MyTextField ("", 10, true), con);
    
    con.gridx = 1;
    add (new MyButton ("Change Nest Factor", this), con);
    
    con.gridx = 0; con.gridy = 4;
    add (new MyButton ("Calculate approp. Nest Factor", this), con);

    con.gridx = 1;
    add (new MyButton ("Close", this), con);

    pack ();
    setSize (getMinimumSize ());
  }
  //end of setup methods----------------------------------------------------------
  
  //event handler methods--------------------------------------------------------
  //events generated by buttons and checkboxes are processed

  //event handler method for ActionEvents generated by buttons
  public void actionPerformed (ActionEvent evt) {
    String command = evt.getActionCommand ();
    if (command.equals ("Close")) setVisible (false);
    else if (command.equals ("Reset Elapsed Time")) 
      parent.canvas.fixElTimePointer (0);
    else if (command.equals ("Change Nest Factor")) {
      parent.canvas.changeNestFactor ((new Double (nFacTxField.getText ())).doubleValue ());
      parent.canvas.Refresh ();
    }
    else if (command.equals ("Calculate approp. Nest Factor")) {
      parent.canvas.getAppropNestFac ();
      parent.canvas.Refresh ();
    }
  }
  
  //event handler method for ItemEvents generated by the checkboxes
  public void itemStateChanged (ItemEvent e) {
    Object o = e.getItem ();
    if (o.toString ().equals ("Arrows Display")) {
      parent.canvas.arrowDispStatus = arrowsChkBox.getState ();
      parent.canvas.Refresh ();
    }
    else if (o.toString ().equals ("Elapsed Time Line Display")) {
      parent.canvas.elTLineDispStatus = elTLineChkBox.getState ();
      parent.canvas.Refresh ();
    }
    else { 
      parent.canvas.zoomLkLineDispStatus = zoomLkLineChkBox.getState ();
      parent.canvas.Refresh ();
    }
  }
  //end of event handler methods------------------------------------------------------
  //Method used by ClogDisplay to reset values into this object
  public void reset () {
    arrowsChkBox.setState (parent.canvas.arrowDispStatus);
    elTLineChkBox.setState (parent.canvas.elTLineDispStatus);
    zoomLkLineChkBox.setState (parent.canvas.zoomLkLineDispStatus);
    nFacTxField.setText (Double.toString (parent.canvas.nestFactor));
  }
}








