#!/usr/local/bin/perl
use lib '/usr/local/rib/lib';
# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#
# $Id: delete_repository.pl,v 1.2 1998/01/23 03:52:42 rib Exp $
#
# $Log: delete_repository.pl,v $
# Revision 1.2  1998/01/23 03:52:42  rib
# changed delete_repository so that it tries to changes
# the permissions on a file that it can't delete before
# giving up
#
# Revision 1.1.1.1  1997/12/10 15:59:31  jhorner
# RIB pre 1.0
#
# Revision 1.2  1997/05/26 13:48:31  mcmahan
# added admin/ to the references to the paths which go through the cgi-bin/
# directory - this is to fix the problem with access control where the
# searching scripts were accidentally access controlled
#
# Revision 1.1  1997/05/06 18:19:52  jhorner
# Initial revision
#

use File::Path;
use File::Find;
use RIB::Util;

my $util = RIB::Util->new();
my %in = RIB::Util->ReadParse();

use strict;
my ($top, $RIBDIR, $back_to_top,
    @notwritable, $file, @repositories, $repository);

$| = 1;
umask 002;

$util->PrintHeader("nocache");

$RIBDIR = $util->GetRibDir();
$back_to_top = $util->BackToTop();

$top = "<head><title>Delete a Respoitory</title></head>\n"
     . "<body bgcolor=#FFFFF0><h1>Delete a Repository</h1>\n"
     . "<p><hr><p>\n";

if ($in{confirmation} && $in{repository}) {
  print $top;
  if ($in{confirmation}=~/^\s*delete\s+repository\s+\Q$in{repository}\E\s*/i) {
    print "Attempting to remove $RIBDIR/repositories/$in{repository}...<p>\n";
    
    if (!-d "$RIBDIR/repositories/$in{repository}") {
      print "<strong>Error</strong>: the repository that was at \n";
      print "$RIBDIR/repositories/$in{repository} cannot be removed\n";
      print "because it is no longer there.  Perhaps the repository had\n";
      print "already been removed and the previous page was stale(?)\n";
      print "Or perhaps the repository was already removed and you hit the\n";
      print "reload button on your browser(?)\n";
      print $back_to_top;
      print "</body>\n";
      exit;
    }
    sub wanted {
      !-w && push (@notwritable,$File::Find::name) ;
    }
    find(\&wanted,"$RIBDIR/repositories/$in{repository}");
    find(\&wanted,"$RIBDIR/cgi-bin/admin/repositories/$in{repository}");
    if (@notwritable) {
      foreach $file (@notwritable) { chmod 0600, $file; }
      @notwritable = ();
      find(\&wanted,"$RIBDIR/repositories/$in{repository}");
      find(\&wanted,"$RIBDIR/cgi-bin/admin/repositories/$in{repository}");
    }
    if (@notwritable) {
      print "Your http user (&quot;", (getpwuid($<))[0], "&quot;) ";
      print "doesn't have write ";
      print "permissions for the following file(s) \n";
      print "and/or directory(s):\n";
      print "<ul>\n";
      foreach $file (@notwritable) { print "<li>$file\n"; }
      print "</ul>\n";
      print "<p>You need to either make those files writable by your http ";
      print "user or manually remove them before this repository can be ";
      print "deleted.\n";
      print $back_to_top;
      exit;
    }
    print "<pre>\n";
    rmtree("$RIBDIR/repositories/$in{repository}",1,0);
    rmtree("$RIBDIR/cgi-bin/admin/repositories/$in{repository}",1,0);
    print "</pre>\n";
    print "<p>Repository $in{repository} has been deleted.\n";
    print $back_to_top;
    print "<br><a href=delete_repository.pl>Delete another repository</a>\n";
    exit;
  }
  else {
    print "What you typed in was not &quot;delete repository ";
    print "$in{repository}&quot;.";
    print "<p>Repository deletion has been cancelled.\n<p>\n";
    print "If you want to try typing in the phrase correctly then press \n";
    print "the back button on your browser and then try again.";
  }
  print $back_to_top;
}
elsif ($in{repository}) {
  print $top;
  print "<form action=delete_repository.pl method=post>\n";
  print "If you are absolutely sure that you want to delete the repository\n";
  print "named <strong>$in{repository}</strong> then type the words \n";
  print "<dl><dd><i>delete repository $in{repository}</i></dl> in the\n";
  print "space below and then press the submit button.<p>\n";
  print "<input name=confirmation size=50 maxlength=256><br>\n";
  print "<input type=hidden name=repository value=$in{repository}><br>\n";
  print "<input type=submit value=\"Delete Repository\"><br>\n";
  print "<p>\n";
  print "<i>\n";
  print "<font size=+1><strong>IMPORTANT</strong></font><br>\n";
  print "It is very important that you do not hit the &quot;stop&quot; ";
  print "button in your web browser while the repository is being deleted.\n";
  print "Once the deletion process has begun it cannot be stopped; attempting\n";
  print "to stop this process by pressing your web browser's stop button will\n";
  print " put your RIB\n";
  print "installation into an unstable state.\n";
  print "</i>\n";
  print "<p>\n";
  print $back_to_top;
  exit;
}

else {
  if (!opendir(DIR, "$RIBDIR/repositories")) {
    $util->ErrorMessage("Couldn't open directory at $RIBDIR/repositories <p>"
                     . "Reason : $!");
  }
  foreach $file (grep (/^[^\.]/,readdir(DIR))) {
    next unless -d "$RIBDIR/repositories/$file";
    push (@repositories, $file);
  }
  print $top;
  if (!@repositories) {
    print "There are no repositories to delete.\n";
  } else {
    print "Deleting a repository is a very serious action. ";
    print "It causes all of the Asset descriptions in that repository ";
    print "to be deleted, as well as all of the other object description files ";
    print "in that repository (Library, Organization, Certificate, etc.).\n";
    print "<p>Be aware that other repositories (either local or foreign)\n";
    print "may be pointing to one or more of the description files in your\n";
    print "repository and deleting it will cause their urls to turn stale.\n";
    print "<p>If you are absolutely sure that you want to delete a ";
    print "repository, thus obliterating all of its contents, then click ";
    print "the name of the repository that you want to delete below.<p>\n";
    print "<ul>\n";
    foreach $repository (sort {lc($a) cmp lc($b)} @repositories) {
      print "<li><a href=delete_repository.pl?repository=$repository>";
      print "$repository</a>\n";
    }
    print "</ul>\n";
  }
  print $back_to_top;
  print "</body>\n";
  exit;
}
