#!/usr/local/bin/perl
use lib '/usr/local/rib/lib';
# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#
use strict;
use integer;
use FileHandle; 
use RIB::Util ();
use RIB::DomainParser ();
use RIB::ConfigParser ();
use RIB::BIDMParser ();
use Data::Dumper ();

use vars qw($DEBUG);
#$DEBUG = 1;
################# Acquire Important Variables and Arguments

my $util = RIB::Util->new();
my ($repository,$buf);
$buf = '';
my $RIBDIR = $util->GetRibDir();
my $RIBURL = $util->GetRibUrl();
my $RIBSP = $util->GetRibIsearchCgiPath();
my $RIBI = $util->GetRibIindexPath();
if (@ARGV){
    $repository = $ARGV[0];
} else {
    $repository = $util->GetRepoName();
}
unless ($repository) {
    $util->ErrorMessage("A repository was not specified in your input");
}
my $filepath = "$RIBDIR/repositories/$repository";

select(STDERR) ; $| = 1; # no output buffering
select(STDOUT); $| = 1;


################# Print Header

$util->PrintHeader();

print "<html>\n";
print "<head><title>Generating deployment grid</title></head>\n";
print "<body bgcolor=#FFFFF0>\n";
print "<center><h1>Generating deployment grid</h1></center><P><hr><P>\n";

################ Load Configuration Object

my $cp = RIB::ConfigParser->new();
unless ($cp->load_config("$filepath/conf/BIDM.conf")){
    print "</pre>\n";
    $util->HtmlCroak("There is a problem with $repository\'s ".
	"configuration file. Problem: " . $cp->ErrorMsg() . ". Please ".
	"contact your RIB administrator");
}


#################
my %assets = {};         #assets in ncsa_teamA repos and their catalog pages
my %machines = {};       #machines in ncsa_teamA_deployment repos and their catalog pages
my %deployments= {};     #deployments in ncsa_teamA_deployment repos and their statuses


################# load %machines
unless (opendir (DIR,"$filepath/objects/Machine")) {
    print "</pre>\n";
    $util->HtmlCroak("Couldn't open the directory "
                   . "$filepath/objects/Machine."
                   . "<p>Reason: $!<p>Please contact rib\@nhse.org");
}
foreach (grep /\.html?$/i , readdir(DIR) ){
  my $file = "$filepath/objects/Machine/$_";

  # parse the deployment file
  my $Machine = RIB::BIDMParser->new();
  $Machine->parse_file($file);

  # determine the catalog entry for this asset
  my $ce = $file;
  $ce =~ s/$RIBDIR/$RIBURL/i;
  $ce =~ s/objects/catalog/i;

  my $machine = $Machine->valueof("Name");
  $machines{$machine} = $ce;
}
close DIR;

################# load %assets
unless (opendir (DIR,"$RIBDIR/repositories/ncsa_teamA/objects/Asset")) {
    print "</pre>\n";
    $util->HtmlCroak("Couldn't open the directory "
                   . "$RIBDIR/repositories/ncsa_teamA/objects/Asset"
                   . "<p>Reason: $!<p>Please contact rib\@nhse.org");
}
foreach (grep /\.html?$/i , readdir(DIR) ){
  my $file = "$RIBDIR/repositories/ncsa_teamA/objects/Asset/$_";

  # parse the deployment file
  my $Asset = RIB::BIDMParser->new();
  $Asset->parse_file($file);

  # determine the catalog entry for this asset
  my $ce = $file;
  $ce =~ s/$RIBDIR/$RIBURL/i;
  #$ce =~ s/objects/catalog/i;

  my $asset = $Asset->valueof("Name");
  $assets{$asset} = $ce;
}
close DIR;


################# Get Deployment objects
unless (opendir (DIR,"$filepath/objects/Deployment")) {
    print "</pre>\n";
    $util->HtmlCroak("Couldn't open the directory "
                   . "$filepath/objects/Deployment."
                   . "<p>Reason: $!<p>Please contact rib\@nhse.org");
}
foreach ( grep /\.html?$/i , readdir(DIR) ){
  # parse the deployment file
  my $Deployment = RIB::BIDMParser->new();
  $Deployment->parse_file("$filepath/objects/Deployment/$_");

  ######################################################
  # determine which Machine this deployment is on
  my $file1 = $Deployment->valueof("DeployedOn");
  $file1 =~ s/$RIBURL/$RIBDIR/i;
  my $DeployedOn = RIB::BIDMParser->new();
  $DeployedOn->parse_file($file1);
  my $machine = $DeployedOn->valueof("Name");

  ######################################################
  # determine which Asset this is a deployment of
  my $file2= $Deployment->valueof("IsDeploymentOf");
  $file2 =~ s/$RIBURL/$RIBDIR/i;
  my $IsDeploymentOf = RIB::BIDMParser->new();
  $IsDeploymentOf->parse_file($file2);
  my $asset = $IsDeploymentOf->valueof("Name");

  ######################################################
  # now store the status of the deployment and url to its catalog entry
  my $status = $Deployment->valueof("Status");
  $deployments{$machine}{$asset} =
     "<a href=\"$RIBURL/repositories/$repository/catalog/Deployment/$_\">$status</a>";
}
closedir DIR;


##################################################################
# get lock for the grid html file and then open it
my $grid = "$filepath/catalog/grid.html";
my $gridlock = "$filepath/catalog/grid.html.lock";
while (-e $gridlock) {
  if ((stat($gridlock))[10] < (time - 60)) {
    unlink $gridlock or $util->HtmlCroak("Can't unlink grid lock file : $!");
  }
  sleep 5;
}
unless (open(GRIDLOCK, ">$gridlock")) {
  $util->HtmlCroak("Can't create grid lock file : $!");
}
close GRIDLOCK;

unless (open (GRID,">$grid")) {
  unlink ($gridlock);
  $util->HtmlCroak("Can't create grid file : $!");
}


##################################################################
# print the grid
select GRID;

print << 'EOF';
<HTML>
<HEAD>
<TITLE>
Alliance Parallel Computing Repository
</TITLE>


<META NAME="description" CONTENT="">
    <!-- Add a description of this page to be displayed in search results. -->
<META NAME="keywords" CONTENT="NCSA,computing">
    <!--                       ^^^^^^^^^^^^^^ -->
    <!-- Add to or edit these keywords with words or phrases relevant to -->
    <!-- this webpage in order to improve search results. -->


<STYLE TYPE="TEXT/CSS">
<!--
BODY,TD { font-family: sans-serif; }
-->
</STYLE>



</HEAD>

<BODY BGCOLOR="#FFFFFF" TEXT="#000000" LINK="#0000FF" VLINK="#000088" ALINK="#CCCCFF"
>

<TABLE WIDTH="576" BORDER="0" CELLSPACING="0" CELLPADDING="0"><TR>

    <TD WIDTH="23" ROWSPAN=2><A HREF="http://www.ncsa.uiuc.edu/"><IMG
                SRC="http://www.ncsa.uiuc.edu/includes/navbar-button-home.jpg"
                WIDTH="23" HEIGHT="68" BORDER="0"
                ALT="NCSA Home "></A></TD>
    <TD WIDTH="530"><A HREF="http://www.ncsa.uiuc.edu/"><IMG
                SRC="http://www.ncsa.uiuc.edu/includes/navbar-title-nossi.jpg"
                WIDTH="530" HEIGHT="36" BORDER="0"
                ALT="NCSA: National Center for Supercomputing Applications"></A></TD>
    <TD WIDTH="23" ROWSPAN=2><A HREF="http://www.ncsa.uiuc.edu/Search/"><IMG
                SRC="http://www.ncsa.uiuc.edu/includes/navbar-button-search.jpg"
                WIDTH="23" HEIGHT="68" BORDER="0"
                ALT="NCSA Search "></A></TD></TR>

        <TR><TD NOWRAP><A HREF="http://www.ncsa.uiuc.edu/alliance/"><IMG
            SRC="http://www.ncsa.uiuc.edu/includes/navbar-button-alliance.jpg"
        WIDTH="112" HEIGHT="32" BORDER="0"
                NAME="alliance" ALT="Alliance " TITLE=""></A><A
        HREF="http://www.ncsa.uiuc.edu/ncsa.html"><IMG
            SRC="http://www.ncsa.uiuc.edu/includes/navbar-button-ncsa.jpg"
        WIDTH="102" HEIGHT="32" BORDER="0"
                NAME="ncsa" ALT="NCSA " TITLE=""></A><A
        HREF="http://www.ncsa.uiuc.edu/UserInfo.html"><IMG
            SRC="http://www.ncsa.uiuc.edu/includes/navbar-button-userinfo.jpg"
        WIDTH="102" HEIGHT="32" BORDER="0"
                NAME="userinfo" ALT="User_Info " TITLE=""></A><A
        HREF="http://www.ncsa.uiuc.edu/access.html"><IMG
            SRC="http://www.ncsa.uiuc.edu/includes/navbar-button-access.jpg"
        WIDTH="102" HEIGHT="32" BORDER="0"
                NAME="access" ALT="Access " TITLE=""></A><A
        HREF="http://www.ncsa.uiuc.edu/cgi-bin/list_bookmarks.cgi"><IMG
            SRC="http://www.ncsa.uiuc.edu/includes/navbar-button-mylinks.jpg"
        WIDTH="112" HEIGHT="32" BORDER="0"
                NAME="mylinks" ALT="MyLinks " TITLE=""></A></TD></TR></TABLE>

<!-- MAIN BODY BEGINS -->



EOF

my $tmp_date = `date '+%D'`;
print <<"EOF";
<center>
 <h2>Software Deployment Grid for Alliance Parallel Computing Team</h2>
</center>
<p><hr><P>
Shown below is a table which describes the current deployment status of
Alliance Parallel Computing Team software on Alliance machines as of $tmp_date.

<P>

Clicking on a machine name along the top row will show a description of
that machine. Clicking on a software title along the left
hand column will show a description of that software.
Clicking on the deployment status inside the table will give details about
that deployment.

<P>

Other items of interest for the deployment team include the
<a href=../forum/index.html>Parallel Computing Team deployment discussion
forum</a>, the <a href=../../ncsa_teamA/catalog/>Parallel Computing Team
software catalog</a> and the <a href=http://alliance.ncsa.uiuc.edu/>Alliance
Home Page</a>.
<P><HR><P>
<center><table border=5 cellpadding=10>
<tr><th>&nbsp;</th>
EOF

my $machine;
foreach $machine (sort keys %machines) {
  print "<th align=center><a href=" . $machines{$machine} . ">$machine</a></th>\n";
}
print "</tr>\n";

my $asset;
foreach $asset (sort {uc($a) cmp uc($b)} keys %assets) {
  print "<tr>\n";
  print "<th align=center><a href=/rib/cgi-bin/pub/show_object.pl?r=ncsa_teamA_deployment&u=" . $assets{$asset} . ">$asset</a></th>\n";
  foreach $machine (sort keys %machines) {
    print "<td align=center>";
    if ($deployments{$machine}{$asset}) {
      print $deployments{$machine}{$asset};
    } else {
      print "-";
    }
    print "</td>\n";
  }
  print "</tr>\n";
}
print "</table></center>\n";

print << 'EOF';
<!-- MAIN BODY ENDS -->



<!-- BEGIN STANDARD FOOTER -->

<P>| </P>
<HR WIDTH="100%" SIZE="1" NOSHADE ALIGN=left>

<!-- footer information -->
<TABLE WIDTH="100%" CELLPADDING=3 CELLSPACING=0 BORDER=0
bgcolor="#FFFFFF">
<TR valign=top><TD>
  <A HREF="http://www.ncsa.uiuc.edu/"><IMG
    SRC="http://www.ncsa.uiuc.edu/includes/footer-alliancelogo2.gif"
        WIDTH="72" HEIGHT="80" BORDER="0"
    ALT="[Alliance]" USEMAP="#a_logo"></A>

<MAP name="a_logo">
        <AREA COORDS="12,0,58,68" HREF="http://www.ncsa.uiuc.edu/" ALT="Alliance">
        <AREA COORDS="26,68,50,80" HREF="http://www.ncsa.uiuc.edu/ncsa.html" ALT="NCS
A">
        <AREA COORDS="50,68,72,80" HREF="http://www.uiuc.edu/" ALT="UIUC">
</MAP>

</TD><TD>
<P class="footer">
  <FONT SIZE="1" face="arial,helvetica">
  Contact <A HREF="mailto:teama@nhse.org">
  teama@nhse.org</A>
  with questions or comments regarding this page.
<BR>

  Last updated
<SCRIPT>
<!--
        document.write(document.lastModified);
// -->
</SCRIPT>
  For more information on NSF's PACI program see<BR>
  <A HREF="http://www.cise.nsf.gov/acir/">http://www.cise.nsf.gov/acir/</A> and
  <A HREF="http://www.npaci.edu/online/">http://www.npaci.edu/online/</A>
<BR>
  All rights reserved. Do not copy or redistribute in any form.<BR>
  NCSA Access 1998 Board of Trustees of the University of Illinois.<BR>
  </FONT> </P>

</TD><TD>
   <A HREF="http://www.ncsa.uiuc.edu/"><IMG
    SRC="http://www.ncsa.uiuc.edu/includes/footer-ncsalogo.gif" WIDTH=78 HEIGHT=27
    BORDER=0 ALT="[NCSA]"></A>
</TD></TR></TABLE>

<P>|

<!-- END STANDARD FOOTER -->


</BODY>
</HTML>
EOF

close GRID;
unlink($gridlock);

##################################################################
# report success
select STDOUT;
print "<P>Grid Generation was successful.<P>\n";
print "Click <a href=/rib/repositories/ncsa_teamA_deployment/catalog/grid.html>here</a>";
print " to see the grid.\n";
exit(0);
