#!/usr/local/bin/perl
use lib '/usr/local/rib/lib';
# NHSE Repository in a Box (RIB)
#
# The authors of this software are Paul McMahan and Jeff Horner.
# Copyright (c) 1997 by the University of Tennessee.
# Permission to use, copy, modify, and distribute this software for any
# purpose without fee is hereby granted, provided that this entire notice
# is included in all copies of any software which is or includes a copy
# or modification of this software and in all copies of the supporting
# documentation for such software.
# THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
# WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR UNIVERSITY OF TENNESSEE
# MAKE ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
# MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
#
# $Id: isearch.pl,v 1.1.1.1 1997/12/10 15:59:31 jhorner Exp $
#
# $Log: isearch.pl,v $
# Revision 1.1.1.1  1997/12/10 15:59:31  jhorner
# RIB pre 1.0
#
# Revision 1.1  1997/05/06 18:18:09  jhorner
# Initial revision
#

use RIB::Util ();
use strict;
 
# From this script, run the isrch_srch utility and pass a single argument:
# the directory where your database is stored.
#
# For example:
#
# /path/to/Isearch-cgi/isrch_srch /path/to/my/databases

unless (@ARGV){
    RIB::Util->PrintHeader();
    RIB::Util->ErrorMessage("This script <strong>MUST</strong>".
	" be called with one argument. Please contact the <strong>RIB".
	" </strong>maintainers.");
}

my $isearch = RIB::Util->GetRibIsearchCgiPath() . "/isrch_srch";
unless (-e $isearch){
    RIB::Util->ErrorMessage("Could not find program isrch_srch!".
	" Tried to find it here: $isearch. It has either been moved".
	" or RIB is incorrectly configured. Please contact your RIB".
	" administrator.");
}
my $ipath = RIB::Util->GetRibDir() . "/repositories/" . $ARGV[0] . 
    "/index/";
#print $ipath;
exec $isearch , $ipath;
