/* 
 *   $Id: ad_init.c,v 1.7 1998/01/26 23:48:57 thakur Exp $    
 *
 *   Copyright (C) 1997 University of Chicago. 
 *   See COPYRIGHT notice in top-level directory.
 */

#include "adio.h"

ADIOI_Flatlist_node *ADIOI_Flatlist;
ADIOI_Async_node *ADIOI_Async_list_head, *ADIOI_Async_list_tail;
    /* list of outstanding asynchronous requests */
ADIOI_Async_node *ADIOI_Async_avail_head, *ADIOI_Async_avail_tail;
    /* list of available (already malloced) nodes for above async list */
ADIOI_Malloc_async *ADIOI_Malloc_async_head, *ADIOI_Malloc_async_tail;
  /* list of malloced areas for async_list, which must be freed in ADIO_End */

ADIOI_Req_node *ADIOI_Req_avail_head, *ADIOI_Req_avail_tail;
    /* list of available (already malloced) request objects */
ADIOI_Malloc_req *ADIOI_Malloc_req_head, *ADIOI_Malloc_req_tail;
    /* list of malloced areas for requests, which must be freed in ADIO_End */

/* for f2c and c2f conversion */
ADIO_File *ADIOI_Ftable;
int ADIOI_Ftable_ptr, ADIOI_Ftable_max;
ADIO_Request *ADIOI_Reqtable;
int ADIOI_Reqtable_ptr, ADIOI_Reqtable_max;
#ifndef __HAS_MPI_INFO
MPI_Info *MPIR_Infotable;
int MPIR_Infotable_ptr, MPIR_Infotable_max;
#endif

int ADIO_Init_keyval=MPI_KEYVAL_INVALID;

void ADIO_Init(int *argc, char ***argv, int *error_code)
{

/* initialize the linked list containing flattened datatypes */
    ADIOI_Flatlist = (ADIOI_Flatlist_node *) ADIOI_Malloc(sizeof(ADIOI_Flatlist_node));
    ADIOI_Flatlist->type = (MPI_Datatype) NULL;
    ADIOI_Flatlist->next = NULL;
    ADIOI_Flatlist->blocklens = NULL;
    ADIOI_Flatlist->indices = NULL;

    ADIOI_Async_list_head = ADIOI_Async_list_tail = NULL;
    ADIOI_Async_avail_head = ADIOI_Async_avail_tail = NULL;
    ADIOI_Malloc_async_head = ADIOI_Malloc_async_tail = NULL;

    ADIOI_Req_avail_head = ADIOI_Req_avail_tail = NULL;
    ADIOI_Malloc_req_head = ADIOI_Malloc_req_tail = NULL;

    ADIOI_Ftable = NULL;
    ADIOI_Ftable_ptr = ADIOI_Ftable_max = 0;

    ADIOI_Reqtable = NULL;
    ADIOI_Reqtable_ptr = ADIOI_Reqtable_max = 0;

#ifndef __HAS_MPI_INFO
    MPIR_Infotable = NULL;
    MPIR_Infotable_ptr = MPIR_Infotable_max = 0;
#endif

    *error_code = MPI_SUCCESS;
}
