/* $Id: nreg.h,v 1.5 1998/03/23 21:18:58 bsmith Exp $ */
#ifndef __NREG
#define __NREG

struct FuncList_struct {
  int                    id;
  int                    (*routine)(void *);
  char                   *name;
  struct FuncList_struct *next;
};
typedef struct FuncList_struct FuncList;

typedef struct {
    FuncList *head, *tail;
} NRList;

extern int    NRCreate(NRList **);
extern int    NRRegister(NRList *,int,char*,int (*)(void *));
extern int    NRDestroy(NRList *);
extern int    (*(NRFindRoutine(NRList   *,int,char*)))(void*);
extern int    NRFindID(NRList   *,char*);
extern char   *NRFindName(NRList   *,int);
extern int    NRDestroyAll(void);
extern int    NRPrintTypes(MPI_Comm,FILE*,char*,char *,NRList *);
extern int    NRGetTypeFromOptions(char *,char *,NRList*,void *,int *);

#endif
