! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
!             Include file for program ex5f.F
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
!
!  This program uses CPP for preprocessing, as indicated by the use of
!  PETSc include files in the directory petsc/include/finclude.  This
!  convention enables use of the CPP preprocessor, which allows the use
!  of the #include statements that define PETSc objects and variables.
!
!  Use of the conventional Fortran include statements is also supported
!  In this case, the PETsc include files are located in the directory
!  petsc/include/foldinclude.
!         
!  Since one must be very careful to include each file no more than once
!  in a Fortran routine, application programmers must exlicitly list
!  each file needed for the various PETSc components within their
!  program (unlike the C/C++ interface).
!
!  See the Fortran section of the PETSc users manual for details.
!
!  The following include statements are generally used in SNES Fortran
!  programs:
!     petsc.h  - base PETSc routines
!     vec.h    - vectors
!     mat.h    - matrices
!     ksp.h    - Krylov subspace methods
!     pc.h     - preconditioners
!     sles.h   - SLES interface
!     snes.h   - SNES interface
!  In addition, we need the following for use of distributed arrays
!     da.h     - distributed arrays (DAs)

#include "include/finclude/petsc.h"
#include "include/finclude/vec.h"
#include "include/finclude/da.h"
#include "include/finclude/is.h"
#include "include/finclude/mat.h"
#include "include/finclude/ksp.h"
#include "include/finclude/pc.h"
#include "include/finclude/sles.h"
#include "include/finclude/snes.h"

!  Common blocks:
!  In this example we use common blocks to store data needed by the 
!  application-provided call-back routines, FormJacobian() and
!  FormFunction().  Note that we can store (pointers to)
!  PETSc objects within these common blocks. 
!
!  common /params/ - contains parameters for the global application 
!     mx, my   - global discretization in x- and y-directions
!     lambda   - nonlinearity parameter
!
!  common /pdata/  - contains some parallel data
!     localX   - local work vector (including ghost points)
!     localF   - local work vector (including ghost points)
!     da       - distributed array
!     rank     - processor rank within communicator
!     size     - number of processors
!     xs, ys   - local starting grid indices (no ghost points)
!     xm, ym   - widths of local grid (no ghost points)
!     gxs, gys - local starting grid indices (including ghost points)
!     gxm, gym - widths of local grid (including ghost points)

      Vec     localX, localF
      DA      da
      integer xs, xe, xm, gxs, gxe, gxm
      integer ys, ye, ym, gys, gye, gym
      integer mx, my, rank, size
      double precision lambda

      common /params/ lambda, mx, my
      common /pdata/  localX, localF, da, rank, size
      common /pdata/  xs, xe, xm, gxs, gxe, gxm
      common /pdata/  ys, ye, ym, gys, gye, gym

! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
