!
!  "$Id: ex2f.F,v 1.12 1998/04/15 18:02:53 balay Exp $"
!
!  Formatted Test for IS stride routines
!
      implicit none
#include "finclude/petsc.h"
#include "finclude/is.h"

      integer     i, n, ierr,ii(1),start,stride
      IS          is
      PetscTruth  flag
      PetscOffset iis

      call PetscInitialize(PETSC_NULL_CHARACTER,ierr)

!     Test IS of size 0 

      call ISCreateStride(PETSC_COMM_SELF,0,0,2,is,ierr)
      call ISGetSize(is,n,ierr)
      if (n .ne. 0) then 
        SETERRA(1,0,0)
      endif
      call ISStrideGetInfo(is,start,stride,ierr)
      if (start .ne. 0) then 
         SETERRA(1,0,0)
      endif
      if (stride .ne. 2) then
        SETERRA(1,0,0)
      endif
      call ISStride(is,flag,ierr)
      if (flag .ne. PETSC_TRUE) then 
        SETERRA(1,0,0) 
      endif
      call ISGetIndices(is,ii,iis,ierr)
      call ISRestoreIndices(is,ii,iis,ierr)
      call ISDestroy(is,ierr)

!     Test ISGetIndices()

      call ISCreateStride(PETSC_COMM_SELF,10000,-8,3,is,ierr)
      call ISGetSize(is,n,ierr)
      call ISGetIndices(is,ii,iis,ierr)
      do 10, i=1,10000
        if (ii(i+iis) .ne. -11 + 3*i) then 
          SETERRA(1,0,0)
        endif
 10   continue
      call ISRestoreIndices(is,ii,iis,ierr)
      call ISDestroy(is,ierr)

      call PetscFinalize(ierr)
      end
 






