#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: ivops.c,v 1.7 1997/10/19 03:27:58 bsmith Exp $";
#endif

/*
 * Inventor versions of the mesh output routines.
 * Note that we allow generation on non-SGI platforms, so we can't simply 
 * use the SGI-specific routines
 */

#include "src/draw/impls/vrml/vrmlimpl.h"

#undef __FUNC__  
#define __FUNC__ "ViDrawTensorSurfaceContour_IV"
int ViDrawTensorSurfaceContour_IV(  Draw Win, DrawMesh mesh, 
				   VRMLGetHue_fcn GetColor, 
				   void *color_context, int ncolor )
{
    Draw_VRML*  VWin = (Draw_VRML*) Win->data;
    int         i, j, nx, ny;
    double      *x, *y, *f;
    double      *fval, red, green, blue;
    PetscObject vobj = (PetscObject) Win;

    PetscFunctionBegin;
    if (vobj->cookie == DRAW_COOKIE && vobj->type == DRAW_NULLWINDOW) PetscFunctionReturn(0);

    /* Flush any previous object */
    DrawFlush( Win );

    /* Get parameters */
    nx = mesh->nx;
    ny = mesh->ny;
    x  = mesh->x;
    y  = mesh->y;
    f  = mesh->f;

    fprintf( VWin->curfp, "\nSeparator {\n   BaseColor {\n        rgb [ " );

    /* Output the vertex colors */
    fval = f;
    for (j=0; j<ny; j++) {
	for (i=0; i<nx; i++) {
	    (*GetColor)( *fval++, color_context, ncolor, &red, &green, &blue );
	    putc( ' ', VWin->curfp );
	    Vi_Out_double_VRML( VWin->curfp, red, PRECISION );
	    putc( ' ', VWin->curfp );
	    Vi_Out_double_VRML( VWin->curfp, green, PRECISION );
	    putc( ' ', VWin->curfp );
	    Vi_Out_double_VRML( VWin->curfp, blue, PRECISION );
	    putc( ',', VWin->curfp );
	    putc( '\n', VWin->curfp );
	}
    }
    fprintf( VWin->curfp, 
             "  ]\n }\nMaterialBinding {\nvalue PER_VERTEX\n}\n" );
    fprintf( VWin->curfp,
	"ShapeHints { vertexOrdering COUNTERCLOCKWISE }\n" );

    /* Output the mesh definition */
    fprintf( VWin->curfp, 
	     "QuadMesh { vertexProperty VertexProperty {\n vertex [ " );
    fval = f;
    for (j=0; j<ny; j++) {
	for (i=0; i<nx; i++) {
	    Vi_Out_double_VRML( VWin->curfp, x[i], PRECISION );
	    putc( ' ', VWin->curfp );
	    Vi_Out_double_VRML( VWin->curfp, y[j], PRECISION );
	    putc( ' ', VWin->curfp );
	    Vi_Out_double_VRML( VWin->curfp, *fval++, PRECISION );
	    putc( ',', VWin->curfp );
	    putc( '\n', VWin->curfp );
	}
    }
    fprintf( VWin->curfp, 
	     "]\n normal [ ]\ntexCoord [ ]\norderedRGBA [ ]\n}\n" ); 
    fprintf( VWin->curfp, "verticesPerColumn %d\nverticesPerRow %d\n }\n }\n",
	     ny, nx );

    PetscFunctionReturn(0);
}
    
#undef __FUNC__  
#define __FUNC__ "ViDrawTensorMapSurfaceContour_IV"
int ViDrawTensorMapSurfaceContour_IV( Draw Win, DrawMesh mesh, 
				      double ox, double oy, double oz, 
				      int coord_slice, int coord_dim,
				      VRMLGetHue_fcn GetColor, 
				      void *color_context, int ncolor,
				      double transparency )
{
    Draw_VRML*  VWin = (Draw_VRML*) Win->data;
    int         i, j, k, nx, ny;
    int         is, ie, js, je, ks, ke, idx, i_incr, j_incr, k_incr;
    double      red, green, blue;
    double      *f;
    PetscObject vobj = (PetscObject) Win;

    if (vobj->cookie == DRAW_COOKIE && vobj->type == DRAW_NULLWINDOW) PetscFunctionReturn(0);
    if (transparency < 0.0 || transparency >= 1.0) transparency = 0.5;

    /* Flush any previous object */
    DrawFlush( Win );

    /* Generate a new object, with examples of additional fields */
    fprintf( VWin->curfp, "\nSeparator {\n   BaseColor {\n        rgb [ " );

    ViSetupMeshVertices( VWin, mesh, coord_dim, coord_slice ); 

    /* Output the vertex colors */
    f	   = mesh->f;
    is	   = mesh->is;
    ie	   = mesh->ie;
    i_incr = mesh->i_incr;
    js	   = mesh->js;
    je	   = mesh->je;
    j_incr = mesh->j_incr;
    ks	   = mesh->ks;
    ke	   = mesh->ke;
    k_incr = mesh->k_incr;
    nx     = mesh->nx;
    ny     = mesh->ny;

    for (k=ks; k<=ke; k += k_incr) {
	for (j=js; j<=je; j += j_incr) {
	    for (i=is; i<=ie; i += i_incr) {
		idx = i + nx * (j + ny * k);
		/* color context has fmin, fmax in it */
		(*GetColor)( f[idx], color_context, ncolor, 
			     &red, &green, &blue );
		putc( ' ', VWin->curfp );
		Vi_Out_double_VRML( VWin->curfp, red, PRECISION );
		putc( ' ', VWin->curfp );
		Vi_Out_double_VRML( VWin->curfp, green, PRECISION );
		putc( ' ', VWin->curfp );
		Vi_Out_double_VRML( VWin->curfp, blue, PRECISION );
		putc( ',', VWin->curfp );
		putc( '\n', VWin->curfp );
	    }
	}
    }

    fprintf( VWin->curfp, 
             "  ]\n }\nMaterialBinding {\nvalue PER_VERTEX\n}\n" );
    fprintf( VWin->curfp,
	"ShapeHints { vertexOrdering COUNTERCLOCKWISE }\n" );

    /* Output the mesh definition */
    fprintf( VWin->curfp, 
	     "QuadMesh { vertexProperty VertexProperty {\n vertex [ " );
    ViOutMeshVertices( VWin, mesh, coord_dim, coord_slice, ox, oy, oz, 1 );

    fprintf( VWin->curfp, 
	     "]\n normal [ ]\ntexCoord [ ]\norderedRGBA [ ]\n}\n" ); 
    fprintf( VWin->curfp, "verticesPerColumn %d\nverticesPerRow %d\n }\n}\n",
	     mesh->act_ny, mesh->act_nx );
    
    
    PetscFunctionReturn(0);
}

#undef __FUNC__  
#define __FUNC__ "ViDrawTensorMapMesh_IV"
int ViDrawTensorMapMesh_IV( Draw Win, DrawMesh mesh, 
			    double ox, double oy, double oz, 
			    int coord_slice, int coord_dim )
{
    Draw_VRML*  VWin = (Draw_VRML*) Win->data;
    PetscObject vobj = (PetscObject) Win;

    if (vobj->cookie == DRAW_COOKIE && vobj->type == DRAW_NULLWINDOW) PetscFunctionReturn(0);

    /* Flush any previous object */
    DrawFlush( Win );

    /* Generate a new object, with examples of additional fields */
    fprintf( VWin->curfp, "Separator {\n" );

    /* Output the vertex color (set to red for now) */
    fprintf( VWin->curfp, 
	     "Material {\n diffuseColor 1.0 0.0 0.0\n }\nMaterialBinding {\n\
  value OVERALL\n}\n" );

    fprintf( VWin->curfp, "DrawStyle { style LINES }\n" );

    fprintf( VWin->curfp, 
	     "QuadMesh { vertexProperty VertexProperty {\n vertex [ " );
    if (ViOutMeshVertices( VWin, mesh, coord_dim, coord_slice, ox, oy, oz, 
			   1 )) 
	return 1;
    fprintf( VWin->curfp, 
	     "]\n normal [ ]\ntexCoord [ ]\norderedRGBA [ ]\n}\n" ); 
    fprintf( VWin->curfp, "verticesPerColumn %d\nverticesPerRow %d\n }\n}\n",
	     mesh->act_ny, mesh->act_nx );

    PetscFunctionReturn(0);
}
