dnl
dnl Special configure macros
dnl
define(AC_FORTRAN_NAMES_IN_C,[
AC_MSG_CHECKING(for Fortran external names)
# First, compile a Fortran program:
/bin/rm -f conff.f
cat > conff.f <<EOF
        subroutine d1chk()
        return
        end
EOF
if $FC -c conff.f >/dev/null 2>&1 ; then 
    :
else
    echo "Could not compile Fortran routine"
fi
# Now, build a C program and try to link with it
cat > conf.c <<EOF
main() {
d1chk_();
return 0;
}
EOF
if $CC -o conf conf.c conff.o >/dev/null 2>&1 ; then
    AC_DEFINE(HAVE_FORTRAN_UNDERSCORE)
    FORTRAN_NAMING="-DHAVE_FORTRAN_UNDERSCORE"
    /bin/rm -f conf conf.c conff.f conff.o conf.o
    AC_MSG_RESULT(trailing underscore)
else
    /bin/rm -f conf conf.c conf.o
    cat > conf.c <<EOF
main() {
d1chk();
return 0;
}
EOF
    if $CC -o conf conf.c conff.o >/dev/null 2>&1 ; then 
        AC_DEFINE(HAVE_FORTRAN_NOUNDERSCORE)
        FORTRAN_NAMING="-DHAVE_FORTRAN_NOUNDERSCORE"
        /bin/rm -f conf conf.c conff.f conff.o conf.o
        AC_MSG_RESULT(no underscore)
    else
        /bin/rm -f conf conf.c conf.o
        cat > conf.c <<EOF
main() {
D1CHK();
return 0;
}
EOF
        if $CC -o conf conf.c conff.o >/dev/null 2>&1 ; then 
            AC_DEFINE(HAVE_FORTRAN_CAPS)
            FORTRAN_NAMING="-DHAVE_FORTRAN_CAPS"
            /bin/rm -f conf conf.c conff.f conff.o conf.o
            AC_MSG_RESULT(uppercase)
        else
	    FORTRAN_NAMING=""
            AC_MSG_RESULT(unknown!)
        fi
    fi
fi
/bin/rm -f conf conf.c conff.f conff.o conf.o
#
AC_SUBST(FORTRAN_NAMING)])
dnl
dnl Check that a function prototype will work.  This is used to handle
dnl the various variants in such things as "select" and "connect" (!)
dnl The need to do this is one of the reasons that Window NT will win.
dnl
dnl AC_CHECK_PROTOTYPE(foo(int,...),action-if-corrent,action-if-fails)
define(AC_CHECK_PROTOTYPE,[
AC_TRY_COMPILE($1,return 1;,$2,$3)
])
