!
!      "$Id: ex3f.F,v 1.7 1998/04/15 18:00:16 balay Exp $";
!
!  Description: Displays a vector visually.
!
!/*T
!   Concepts: Vectors^Drawing vectors;
!   Routines: VecCreate(); VecSetValues(); VecView(); VecDestroy();
!   Routines: VecAssemblyBegin(); VecAssemblyEnd(); VecGetOwnershipRange();
!   Routines: ViewerDrawOpenX(); ViewerDestroy();
!   Processors: n
!T*/
! -----------------------------------------------------------------------

      program ex3f
      implicit none

! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!                    Include files
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!
!  The following include statements are required for Fortran programs
!  that use PETSc vectors:
!     petsc.h  - base PETSc routines
!     vec.h    - vectors
!  Include viewer.h so that we can use the PETSc viewers.
!
#include "include/finclude/petsc.h"
#include "include/finclude/vec.h"
#include "include/finclude/viewer.h"

! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!                 Beginning of program
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

      Vec     x
      Viewer  viewer
      Scalar  v
      integer i, istart, iend, n, ierr, flg

      call PetscInitialize(PETSC_NULL_CHARACTER,ierr)
      n = 50
      call OptionsGetInt(PETSC_NULL_CHARACTER,'-n',n,flg,ierr)

!  Create a vector, specifying only its global dimension.
!  When using VecCreate(), the vector format (currently parallel
!  or sequential) is determined at runtime.  Also, the parallel
!  partitioning of the vector is determined by PETSc at runtime.
      call VecCreate(PETSC_COMM_WORLD,PETSC_DECIDE,n,x,ierr)

!  Currently, all PETSc parallel vectors are partitioned by
!  contiguous chunks of rows across the processors.  Determine
!  which vector are locally owned. 
      call VecGetOwnershipRange(x,istart,iend,ierr)

!  Set the vector elements.
!   - Always specify global locations of vector entries.
!   - Each processor needs to insert only elements that it owns locally.
      do 100 i=istart,iend-1
         v = dble(i)
         call VecSetValues(x,1,i,v,INSERT_VALUES,ierr)
 100  continue

!  Assemble vector, using the 2-step process:
!    VecAssemblyBegin(), VecAssemblyEnd()
!  Computations can be done while messages are in transition
!  by placing code between these two statements.
      call VecAssemblyBegin(x,ierr)
      call VecAssemblyEnd(x,ierr)

!  Open an X-window viewer.  Note that we specify the same communicator
!  for the viewer as we used for the distributed vector (PETSC_COMM_WORLD).
!    - Helpful runtime option:
!         -draw_pause <pause> : sets time (in seconds) that the
!               program pauses after DrawPause() has been called
!              (0 is default, -1 implies until user input).

      call ViewerDrawOpenX(PETSC_COMM_WORLD,PETSC_NULL_CHARACTER,       &
     &                     PETSC_NULL_CHARACTER,0,0,300,300,viewer,ierr)

!  View the vector
      call VecView(x,viewer,ierr)

!  Free work space.  All PETSc objects should be destroyed when they
!  are no longer needed.

      call ViewerDestroy(viewer,ierr)
      call VecDestroy(x,ierr)

      call PetscFinalize(ierr)
      end
 
