      subroutine dodcps(t,mu1,mu2,t1,t2,result,option,lambda)
      integer option
      double precision t, mu1, mu2, t1, t2, result, lambda
!     **********
!
!     This subroutine computes the function psi(t) and the scaled
!     functions psi'(t)/t and psi''(t)/t for the optimal design
!     with composite materials problem.
!
!     The subroutine statement is
!
!       subroutine dodcps(t,mu1,mu2,t1,t2,result,option,lambda)
!
!     where
!
!       t is a double precision variable.
!         On entry t is the variable t
!         On exit t is unchanged
!
!       mu1 is a double precision variable.
!         On entry mu1 is the reciprocal shear modulus of material 1.
!         On exit mu1 is unchanged.
!
!       mu2 is a double precision variable.
!         On entry mu2 is the reciprocal shear modulus of material 2.
!         On exit mu2 is unchanged.
!
!       t1 is a double precision variable.
!         On entry t1 is the first breakpoint.
!         On exit t1 is unchanged.
!
!       t2 is a double precision variable.
!         On entry t2 is the second breakpoint.
!         On exit t2 is unchanged.
!
!       result is a double precision variable.
!         On entry result need not be specified.
!         On exit result is set according to task.
!
!       option is an integer variable.
!         On entry option specifies the action of the subroutine:
!
!            if option = 0 then evaluate the function psi(t).
!            if option = 1 then evaluate the scaled function psi'(t)/t.
!            if option = 2 then evaluate the scaled function psi''(t)/t.
!
!        On option task is unchanged.
!
!       lambda is a double precision variable
!         On entry lambda is the Lagrange multiplier.
!         On exit lambda is unchanged.
!
!     MINPACK-2 Project. November 1993.
!     Argonne National Laboratory and University of Minnesota.
!     Brett M. Averick.
!
!     **********
      double precision p25, p5, zero
      parameter (zero=0.0d0,p25=0.25d0,p5=0.5d0)

      double precision sqrtt

      sqrtt = sqrt(t)

      if (option .eq. 0) then
         if (sqrtt .le. t1) then
            result = p5*mu2*t
         else if (sqrtt .gt. t1 .and. sqrtt .lt. t2) then
            result = mu2*t1*sqrtt - lambda*mu1
         else if (sqrtt .ge. t2) then
            result = p5*mu1*t + lambda*(mu2-mu1)
         end if
      else if (option .eq. 1) then
         if (sqrtt .le. t1) then
            result = p5*mu2
         else if (sqrtt .gt. t1 .and. sqrtt .lt. t2) then
            result = p5*mu2*t1/sqrtt
         else if (sqrtt .ge. t2) then
            result = p5*mu1
         end if
      else if (option .eq. 2) then
         if (sqrtt .le. t1) then
            result = zero
         else if (sqrtt .gt. t1 .and. sqrtt .lt. t2) then
            result = -p25*mu2*t1/(sqrtt*t)
         else if (sqrtt .ge. t2) then
            result = zero
         end if
      end if

      end
