!
!  "$Id: fsolve.F,v 1.8 1998/04/15 18:03:16 balay Exp $";
!
!    Fortran kernel for sparse triangular solve in the AIJ matrix format
!
!
      subroutine FortranSolveAIJ(n,x,ai,aj,adiag,aa,b)
      implicit none
#include "include/finclude/petsc.h"

      Scalar           x(0:*),aa(0:*),b(0:*)
      integer          n, ai(0:*),aj(0:*),adiag(0:*)

      integer          i,j,jstart,jend
      Scalar           sum
!     
!     Forward Solve
!
      x(0) = b(0)
      do 20 i=1,n-1
         jstart = ai(i)
         jend   = adiag(i) - 1
         sum    = b(i)
         do 30 j=jstart,jend
            sum  = sum -  aa(j) * x(aj(j))
 30      continue
         x(i) = sum
 20   continue
      
!
!     Backward solve the upper triangular
!
      do 40 i=n-1,0,-1
         jstart  = adiag(i) + 1
         jend    = ai(i+1) - 1
         sum     = x(i)
         do 50 j=jstart,jend
            sum = sum - aa(j)* x(aj(j)) 
 50      continue
         x(i)    = sum * aa(adiag(i))
 40   continue
      return
      end
      
