#include "petsc.h"
#include <math.h>

static char help[] = "Demonstrates opening and drawing a surface with VRML\n";

#define X_SIZE 11
#define Y_SIZE 13

int main( int argc, char **argv )
{
    Draw draw;
    DrawMesh meshinfo;
    double   mesh[X_SIZE*Y_SIZE], x[X_SIZE], y[Y_SIZE], r;
    int      i, j, k, kmax, ierr, flg, do_contour = 0;
    void     *color_context;

    PetscInitialize(&argc,&argv,(char*)0,help);

    ierr = DrawOpenVRML(PETSC_COMM_WORLD,0,"Title",&draw); CHKERRA(ierr);

/* Setup the data */
    for (i=0; i<X_SIZE; i++) x[i] = i*(1.0/(X_SIZE-1));
    for (j=0; j<Y_SIZE; j++) y[j] = j*(1.0/(Y_SIZE-1));

    kmax = 5;
    ierr = OptionsGetInt(PETSC_NULL,"-kmax",&kmax,&flg); CHKERRA(ierr);

    ierr = OptionsHasName( PETSC_NULL, "-contour", &flg ); CHKERRA(ierr);
    if (flg) do_contour = 1;
    for (k=0; k<kmax; k++) {
	/* Create a slightly different surface */
	for (i=0; i<X_SIZE; i++)
	    for(j=0; j<Y_SIZE; j++) {
		r = sqrt( (x[i] - 0.5) * (x[i] - 0.5) + 
			  (y[j] - 0.5) * (y[j] - 0.5));
		mesh[i + j * X_SIZE] = (r == 0) ? 1.0 + k * 0.2 : 
		    sin(8.0*(k*0.2+1)*r) / (8.0 * r);
	    }
	DrawMeshCreateSimple( &meshinfo, x, y, (double *)0, X_SIZE,
			      Y_SIZE, 0, 1, mesh, 64 );
        DrawBOP( draw );
	if (!do_contour) 
	    DrawTensorSurface( draw, meshinfo, DRAW_BLUE );
	else {
	    color_context = VRMLGetHue_setup( meshinfo, 64 );
	    DrawTensorSurfaceContour( draw, meshinfo, VRMLGetHue, 
				      color_context, 64 ); 
	    VRMLGetHue_destroy( color_context );
	}
	DrawEOP( draw );
    }
    PetscFinalize();
    return 0;
}



