/* $Id: dfvimpl.h,v 1.22 1998/04/03 23:17:06 bsmith Exp $ */
/*
  This file includes the definition of structures used in the tools for
  discrete functions.  This should not be included in users' code.
*/

#ifndef __DFVECIMPL
#define __DFVECIMPL

#include "src/vec/vecimpl.h"
#include "dfvec.h"
#include "is.h"
#include "da.h"
#include <math.h>

/*
  DF - Context for discrete function (vector associated with a grid,
       possibly with multiple components per node)
 */

struct _DFOps {
   int (*refinevector)(DFVec,DFVec*),
       (*refinecoordinates)(DF,DF),
       (*assemblefullvector)(Vec*,DFVec),
       (*drawcontours)(DFVec,int,int),  /* should be removed and replaced with below */
       (*drawcontoursviewer)(DFVec,Viewer *),
       (*drawcontoursvrml)(DFVec),
       (*copy)(DF,DF),
       (*destroy)(DF),
       (*view)(DFVec,Viewer);
};

struct _p_DF {
  PETSCHEADER(struct _DFOps)
  int                 dim;         /* grid dimension (1, 2, or 3) */
  int                 nc;          /* number of components per grid point */
  DFComponentOrdering order;    /* ordering of unknowns */
  char                **label;     /* string associated with each component */
  int                 ldefault;    /* if true, default labels have been used */
  double              *coord[3];   /* local grid coordinates */
  int                 cset;        /* it true, coordinates have been set */
  int                 rset;        /* it true, refinement info has been set */
  int                 gnp[3];      /* number of global points in each direction 
                                      (REGULAR only) */
  int                 lnp[3];      /* number of local points in each direction
                                      (REGULAR only) */
  int                 calloc;      /* if true, coord have been internally allocated */
  void                *user;       /* optional user-defined context */
  int                 (*user_copy)(void*,void**); /* optional routine to copy
                                                       user-defined context */
  int                 cflag;       /* doing coordinate refinement */
  void                *df_local;   /* local DF context */

  /* ---------- These are used only for parallel, regular grids --------- */
  /* Will eventually incorporate in a private implementation-specific context */
  DA                  da_user;     /* DA for regular vector */
  DA                  da;          /* DA used internally for parallel refinement only */
};

extern int DFCopy_SeqRegular(DF,DF);
extern int DFRefineCoordinates_SeqRegular(DF,DF);

#endif
