/* $Id: ec.h,v 1.4 1998/03/23 21:27:32 bsmith Exp $ */
/*
   Defines the interface functions for computation of eigenvalues
*/
#ifndef __EC_PACKAGE
#define __EC_PACKAGE
#include "sles.h"

#define EC_COOKIE  PETSC_COOKIE+11

typedef struct _p_EC*     EC;

typedef enum { EC_LAPACK, EC_IRAM} ECType;
typedef enum { EC_EIGENVALUE, EC_GENERALIZED_EIGENVALUE } ECProblemType;
typedef enum { EC_LARGEST_REAL_PART, EC_LARGEST_MAGNITUDE,
               EC_SMALLEST_REAL_PART, EC_SMALLEST_MAGNITUDE,
               EC_INTERIOR} ECSpectrumPortion;

extern int ECCreate(MPI_Comm,ECProblemType,EC *);
extern int ECSetType(EC,ECType);
extern int ECSetUp(EC);
extern int ECSolve(EC);
extern int ECDestroy(EC);
extern int ECSetFromOptions(EC);
extern int ECSetOperators(EC,Mat,Mat);

extern int ECSolveEigenvectors(EC);
extern int ECGetEigenvectors(EC,int *,Vec *);

extern int ECSetEigenvectorsRequired(EC);

extern int ECSetSpectrumPortion(EC,int,ECSpectrumPortion,Scalar *);

extern int ECGetEigenvalues(EC,int*,double**,double**);


extern int ECGetType(EC, ECType *,char **);

extern int ECPrintHelp(EC);
extern int ECView(EC,Viewer);

/* 
    These routines are not commonly used by application programmers
*/

extern int ECSetOptionsPrefix(EC,char*);
extern int ECAppendOptionsPrefix(EC,char*);
extern int ECGetOptionsPrefix(EC,char**);
extern int ECRegisterAll(void);
extern int ECRegisterDestroy(void);
extern int ECRegister(ECType,char *,int (*)(EC));


#endif


