/* 
 *   $Id: set_size.c,v 1.10 1998/03/10 20:55:11 thakur Exp $    
 *
 *   Copyright (C) 1997 University of Chicago. 
 *   See COPYRIGHT notice in top-level directory.
 */

#include "mpioimpl.h"

/*@
    MPI_File_set_size - Sets the file size

Input Parameters:
. fh - file handle (handle)
. size - size to truncate or expand file (nonnegative integer)

.N fortran
@*/
int MPI_File_set_size(MPI_File fh, MPI_Offset size)
{
    int error_code;
    MPI_Offset tmp_sz;
#ifdef MPI_hpux
    int fl_xmpi;

    HPMP_IO_START(fl_xmpi, BLKMPIFILESETSIZE, TRDTBLOCK, fh,
		  MPI_DATATYPE_NULL, -1);
#endif /* MPI_hpux */

    if ((fh <= (MPI_File) 0) || (fh->cookie != ADIOI_FILE_COOKIE)) {
	printf("MPI_File_set_size: Invalid file handle\n");
	MPI_Abort(MPI_COMM_WORLD, 1);
    }

    if (size < 0) {
        printf("MPI_File_set_size: Invalid size argument\n");
        MPI_Abort(MPI_COMM_WORLD, 1);
    }

    tmp_sz = size;
    MPI_Bcast(&tmp_sz, 1, ADIO_OFFSET, 0, fh->comm);

    if (tmp_sz != size) {
	printf("MPI_File_set_size: size argument must be the same on all processes\n");
	MPI_Abort(MPI_COMM_WORLD, 1);
    }

    ADIO_Resize(fh, size, &error_code);
    
#ifdef MPI_hpux
    HPMP_IO_END(fl_xmpi, fh, MPI_DATATYPE_NULL, -1);
#endif /* MPI_hpux */

    return error_code;
}
