      PROGRAM PDBLA2TST
*
*  -- PBLAS testing driver (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*  Purpose
*  ========
*
*  PDBLA2TST is the main test program for the DOUBLE PRECISION
*  PBLAS Level 2 routines.
*
*  The program must be driven by a short data file.  An annotated
*  example of a data file can be obtained by deleting the first 3
*  characters from the following 53 lines:
*  'ScaLAPACK, Version 2.0, Level 2 PBLAS input file'
*  'Intel iPSC/860 hypercube, gamma model.'
*  'PDBLAT2.SUMM'     output file name (if any)
*  6       device out
*  F       logical flag, T to stop on failures
*  F       logical flag, T to test error exits
*  0       verbosity level, 0 for pass/fail, 1-3 matrix dump on errors
*  10      the leading dimension gap
*  16.0    threshold value of test ratio
*  1               number of process grids (ordered pairs of P & Q)
*  2 2 1 4 2 3 8   values of P
*  2 2 4 1 3 2 1   values of Q
*  1.0D0           value of ALPHA
*  1.0D0           value of BETA
*  2               number of tests problems
*  'U' 'L'         values of UPLO
*  'N' 'T'         values of TRANS
*  'N' 'U'         values of DIAG
*  3  4            values of M
*  3  4            values of N
*  6 10            values of M_A
*  6 10            values of N_A
*  2  5            values of MB_A
*  2  5            values of NB_A
*  0  1            values of RSRC_A
*  0  0            values of CSRC_A
*  1  1            values of IA
*  1  1            values of JA
*  6 10            values of M_X
*  6 10            values of N_X
*  2  5            values of MB_X
*  2  5            values of NB_X
*  0  1            values of RSRC_X
*  0  0            values of CSRC_X
*  1  1            values of IX
*  1  1            values of JX
*  1  1            values of INCX
*  6 10            values of M_Y
*  6 10            values of N_Y
*  2  5            values of MB_Y
*  2  5            values of NB_Y
*  0  1            values of RSRC_Y
*  0  0            values of CSRC_Y
*  1  1            values of IY
*  1  1            values of JY
*  6  1            values of INCY
*  PDGEMV  T  put F for no test in the same column
*  PDSYMV  T  put F for no test in the same column
*  PDTRMV  T  put F for no test in the same column
*  PDTRSV  T  put F for no test in the same column
*  PDGER   T  put F for no test in the same column
*  PDSYR   T  put F for no test in the same column
*  PDSYR2  T  put F for no test in the same column
*
*  Internal Parameters
*  ===================
*
*  TOTMEM   INTEGER, default = 2000000
*           TOTMEM is a machine-specific parameter indicating the
*           maximum amount of available memory in bytes.
*           The user should customize TOTMEM to his platform.  Remember
*           to leave room in memory for the operating system, the BLACS
*           buffer, etc.  For example, on a system with 8 MB of memory
*           per process (e.g., one processor on an Intel iPSC/860), the
*           parameters we use are TOTMEM=6200000 (leaving 1.8 MB for OS,
*           code, BLACS buffer, etc).  However, for PVM, we usually set
*           TOTMEM = 2000000.  Some experimenting with the maximum value
*           of TOTMEM may be required.
*
*  INTGSZ   INTEGER, default = 4 bytes.
*  DBLESZ   INTEGER, default = 8 bytes.
*           INTGSZ and DBLESZ indicate the length in bytes on the
*           given platform for an integer and a double precision real.
*  MEM      DOUBLE PRECISION array, dimension ( TOTMEM / DBLESZ )
*
*           All arrays used by SCALAPACK routines are allocated from
*           this array and referenced by pointers.  The integer IPA,
*           for example, is a pointer to the starting element of MEM for
*           the matrix A.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      INTEGER            MAXTESTS, MAXGRIDS, GAPMUL, DBLESZ, TOTMEM,
     $                   MEMSIZ, NSUBS
      DOUBLE PRECISION   ONE, PADVAL, ZERO, ROGUE
      PARAMETER          ( MAXTESTS = 20, MAXGRIDS = 20, GAPMUL = 10,
     $                     DBLESZ = 8, TOTMEM = 2000000,
     $                     MEMSIZ = TOTMEM / DBLESZ, ZERO = 0.0D+0,
     $                     ONE = 1.0D+0, PADVAL = -9923.0D+0,
     $                     NSUBS = 7, ROGUE = -1.0D+10 )
*     ..
*     .. Local Scalars ..
      LOGICAL            ERRFLG, SOF, TEE
      CHARACTER*1        AFORM, DIAG, TRANS, UPLO
      INTEGER            CSRCA, CSRCX, CSRCY, I, IAM, ICTXT, IGAP, INCX,
     $                   INCY, IMIDPADA, IMIDPADX, IMIDPADY, IPG,
     $                   IPMATA, IPMATX, IPMATY, IPREPADA, IPREPADX,
     $                   IPREPADY, IPOSTPADA, IPOSTPADX, IPOSTPADY, IPA,
     $                   IPX, IPY, IVERB, IA, IASEED, IX, IXSEED, IY,
     $                   IYSEED, J, JA, JX, JY, K, LDA, LDX, LDY, M, MA,
     $                   MBA, MBX, MBY, MEMREQD, MPA, MPX, MPY, MX, MY,
     $                   MYCOL, MYROW, N, NA, NBA, NBX, NBY, NCOLA,
     $                   NGRIDS, NLX, NLY, NOUT, NPCOL, NPROCS, NPROW,
     $                   NQA, NQX, NQY, NROWA, NTESTS, NX, NY, RSRCA,
     $                   RSRCX, RSRCY, TSKIP
      REAL               THRESH
      DOUBLE PRECISION   ALPHA, BETA
*     ..
*     .. Local Arrays ..
      LOGICAL            LTEST( NSUBS ), YCHECK( NSUBS )
      CHARACTER*1        DIAGVAL( MAXTESTS ), TRANSVAL( MAXTESTS ),
     $                   UPLOVAL( MAXTESTS )
      CHARACTER*80       OUTFILE
      INTEGER            CSRCAVAL( MAXTESTS ), CSRCXVAL( MAXTESTS ),
     $                   CSRCYVAL( MAXTESTS ), DESCA( DLEN_ ),
     $                   DESCX( DLEN_ ), DESCY( DLEN_ ), IERR( 6 ),
     $                   INCXVAL( MAXTESTS ), INCYVAL( MAXTESTS ),
     $                   IAVAL( MAXTESTS ), IXVAL( MAXTESTS ),
     $                   IYVAL( MAXTESTS ), JAVAL( MAXTESTS ),
     $                   JXVAL( MAXTESTS ), JYVAL( MAXTESTS ),
     $                   KFAIL( NSUBS ), KPASS( NSUBS ), KSKIP( NSUBS ),
     $                   KTESTS( NSUBS ), MVAL( MAXTESTS ),
     $                   MAVAL( MAXTESTS ), MBAVAL( MAXTESTS ),
     $                   MBXVAL( MAXTESTS ), MBYVAL( MAXTESTS ),
     $                   MXVAL( MAXTESTS ), MYVAL( MAXTESTS ),
     $                   NBAVAL( MAXTESTS ), NBXVAL( MAXTESTS ),
     $                   NBYVAL( MAXTESTS ), NVAL( MAXTESTS ),
     $                   NAVAL( MAXTESTS ), NXVAL( MAXTESTS ),
     $                   NYVAL( MAXTESTS ), PVAL( MAXTESTS ),
     $                   QVAL( MAXTESTS ), RSRCAVAL( MAXTESTS ),
     $                   RSRCXVAL( MAXTESTS ), RSRCYVAL( MAXTESTS )
      DOUBLE PRECISION   MEM( MEMSIZ )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_EXIT, BLACS_GET, BLACS_GRIDEXIT,
     $                   BLACS_GRIDINFO, BLACS_GRIDINIT, BLACS_PINFO,
     $                   IGSUM2D, PDCHEKPAD, PDFILLPAD,
     $                   PBDMATGEN, PDBLA2TCHK, PDBLA2TCHKE,
     $                   PDBLA2TINFO, PDCHKARG2, PDCHKVOUT,
     $                   MDESCCHK, VDESCCHK, VDIMCHK, MDIMCHK, DLASET,
     $                   PDLASET, DVPRNT, DMPRNT, PDLAPRNT,
     $                   PDGEMV, PDSYMV, PDTRMV, PDTRSV,
     $                   PDGER, PDSYR, PDSYR2
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      EXTERNAL           ICEIL, LSAME
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, MOD
*     ..
*     .. Scalars in Common ..
      CHARACTER*7        SNAMES( NSUBS )
      LOGICAL            ABRTFLG
      INTEGER            INFO
*     ..
*     .. Common blocks ..
      COMMON             /SNAMEC/SNAMES
      COMMON             /INFOC/INFO
      COMMON             /PBERRORC/NOUT, ABRTFLG
*     ..
*     .. Data Statements ..
      DATA               SNAMES/'PDGEMV', 'PDSYMV', 'PDTRMV',
     $                   'PDTRSV', 'PDGER ', 'PDSYR',
     $                   'PDSYR2'/
      DATA               YCHECK/.TRUE., .TRUE., .FALSE., .FALSE.,
     $                   .TRUE., .FALSE., .TRUE./
*     ..
*     .. Executable Statements ..
*
*     Initialization
*
*     Set flag so that PBERROR won't abort on errors, so that the tester
*     will detect unsupported operations.
*
      ABRTFLG = .FALSE.
*
*     So far no error, will become true as soon as one error is found.
*
      ERRFLG = .FALSE.
*
*     Test counters
*
      TSKIP  = 0
*
*     Seeds for random matrix generations.
*
      IASEED = 100
      IXSEED = 200
      IYSEED = 300
*
*     So far no tests have been performed.
*
      DO 10 I = 1, NSUBS
         KPASS( I )  = 0
         KSKIP( I )  = 0
         KFAIL( I )  = 0
         KTESTS( I ) = 0
   10 CONTINUE
*
*     Get starting information
*
      CALL BLACS_PINFO( IAM, NPROCS )
      CALL PDBLA2TINFO( OUTFILE, NOUT, NTESTS, DIAGVAL, TRANSVAL,
     $                  UPLOVAL, MVAL, NVAL, MAVAL, NAVAL, MBAVAL,
     $                  NBAVAL, RSRCAVAL, CSRCAVAL, IAVAL, JAVAL, MXVAL,
     $                  NXVAL, MBXVAL, NBXVAL, RSRCXVAL, CSRCXVAL,
     $                  IXVAL, JXVAL, INCXVAL, MYVAL, NYVAL, MBYVAL,
     $                  NBYVAL, RSRCYVAL, CSRCYVAL, IYVAL, JYVAL,
     $                  INCYVAL, MAXTESTS, NGRIDS, PVAL, MAXGRIDS, QVAL,
     $                  MAXGRIDS, LTEST, SOF, TEE, IAM, IGAP, IVERB,
     $                  NPROCS, THRESH, ALPHA, BETA, MEM )
*
      IF( IAM.EQ.0 ) THEN
         WRITE( NOUT, FMT = 9975 )
         WRITE( NOUT, FMT = * )
      END IF
*
*     If TEE is set then Test Error Exits of routines.
*
      IF( TEE )
     $   CALL PDBLA2TCHKE( LTEST, NOUT, NPROCS )
*
*     Loop over different process grids
*
      DO 60 I = 1, NGRIDS
*
         NPROW = PVAL( I )
         NPCOL = QVAL( I )
*
*        Make sure grid information is correct
*
         IERR( 1 ) = 0
         IF( NPROW.LT.1 ) THEN
            IF( IAM.EQ.0 )
     $         WRITE( NOUT, FMT = 9999 ) 'GRID SIZE', 'NPROW', NPROW
            IERR( 1 ) = 1
         ELSE IF( NPCOL.LT.1 ) THEN
            IF( IAM.EQ.0 )
     $         WRITE( NOUT, FMT = 9999 ) 'GRID SIZE', 'NPCOL', NPCOL
            IERR( 1 ) = 1
         ELSE IF( NPROW*NPCOL.GT.NPROCS ) THEN
            IF( IAM.EQ.0 )
     $         WRITE( NOUT, FMT = 9998 ) NPROW*NPCOL, NPROCS
            IERR( 1 ) = 1
         END IF
*
         IF( IERR( 1 ).GT.0 ) THEN
            IF( IAM.EQ.0 )
     $         WRITE( NOUT, FMT = 9997 ) 'GRID'
            TSKIP = TSKIP + 1
            GO TO 60
         END IF
*
*        Define process grid
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', NPROW, NPCOL )
         CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*        Go to bottom of process grid loop if this case doesn't use my
*        process
*
         IF( MYROW.GE.NPROW .OR. MYCOL.GE.NPCOL )
     $      GO TO 60
*
*        Loop over number of tests
*
         DO 50 J = 1, NTESTS
*
*           Get the test parameters
*
            DIAG  = DIAGVAL( J )
            TRANS = TRANSVAL( J )
            UPLO  = UPLOVAL( J )
*
            M     = MVAL( J )
            N     = NVAL( J )
*
            MA    = MAVAL( J )
            NA    = NAVAL( J )
            MBA   = MBAVAL( J )
            NBA   = NBAVAL( J )
            RSRCA = RSRCAVAL( J )
            CSRCA = CSRCAVAL( J )
            IA    = IAVAL( J )
            JA    = JAVAL( J )
*
            MX    = MXVAL( J )
            NX    = NXVAL( J )
            MBX   = MBXVAL( J )
            NBX   = NBXVAL( J )
            RSRCX = RSRCXVAL( J )
            CSRCX = CSRCXVAL( J )
            IX    = IXVAL( J )
            JX    = JXVAL( J )
            INCX  = INCXVAL( J )
*
            MY    = MYVAL( J )
            NY    = NYVAL( J )
            MBY   = MBYVAL( J )
            NBY   = NBYVAL( J )
            RSRCY = RSRCYVAL( J )
            CSRCY = CSRCYVAL( J )
            IY    = IYVAL( J )
            JY    = JYVAL( J )
            INCY  = INCYVAL( J )
*
            IF( IAM.EQ.0 ) THEN
*
               WRITE( NOUT, FMT = * )
               WRITE( NOUT, FMT = 9996 ) J, NPROW, NPCOL
               WRITE( NOUT, FMT = * )
*
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9994 )
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9993 ) M, N, UPLO, TRANS, DIAG
*
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9992 )
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9991 ) IA, JA, MA, NA, MBA, NBA,
     $                                   RSRCA, CSRCA
*
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9990 )
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9989 ) IX, JX, MX, NX, MBX, NBX,
     $                                   RSRCX, CSRCX, INCX
*
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9988 )
               WRITE( NOUT, FMT = 9995 )
               WRITE( NOUT, FMT = 9989 ) IY, JY, MY, NY, MBY, NBY,
     $                                   RSRCY, CSRCY, INCY
*
               WRITE( NOUT, FMT = 9995 )
*
            END IF
*
*           Check the validity of the input test parameters
*
            IF( .NOT.LSAME( UPLO, 'U' ).AND.
     $          .NOT.LSAME( UPLO, 'L' ) ) THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9997 ) 'UPLO'
               TSKIP = TSKIP + 1
               GO TO 40
            END IF
*
            IF( .NOT.LSAME( TRANS, 'N' ).AND.
     $          .NOT.LSAME( TRANS, 'T' ).AND.
     $          .NOT.LSAME( TRANS, 'C' ) ) THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9997 ) 'TRANS'
               TSKIP = TSKIP + 1
               GO TO 40
            END IF
*
            IF( .NOT.LSAME( DIAG , 'U' ).AND.
     $         .NOT.LSAME( DIAG , 'N' ) )THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9997 ) TRANS
               WRITE( NOUT, FMT = 9997 ) 'DIAG'
               TSKIP = TSKIP + 1
               GO TO 40
            END IF
*
*           Check and initialize the matrix descriptors
*
            CALL MDESCCHK( ICTXT, NOUT, 'A', DESCA, MA, NA, MBA, NBA,
     $                     RSRCA, CSRCA, MPA, NQA, IPREPADA, IMIDPADA,
     $                     IPOSTPADA, IGAP, GAPMUL, IERR( 1 ) )
            CALL VDESCCHK( ICTXT, NOUT, 'X', DESCX, MX, NX, MBX, NBX,
     $                     RSRCX, CSRCX, INCX, MPX, NQX, IPREPADX,
     $                     IMIDPADX, IPOSTPADX, IGAP, GAPMUL,
     $                     IERR( 2 ) )
            CALL VDESCCHK( ICTXT, NOUT, 'Y', DESCY, MY, NY, MBY, NBY,
     $                     RSRCY, CSRCY, INCY, MPY, NQY, IPREPADY,
     $                     IMIDPADY, IPOSTPADY, IGAP, GAPMUL,
     $                     IERR( 3 ) )
*
            IF( IERR( 1 ).GT.0 .OR. IERR( 2 ).GT.0 .OR.
     $          IERR( 3 ).GT.0 ) THEN
               TSKIP = TSKIP + 1
               GO TO 40
            END IF
*
            LDA = MAX( 1, MA )
            LDX = MAX( 1, MX )
            LDY = MAX( 1, MY )
*
*           Assign pointers into MEM for matrices corresponding to
*           the distributed matrices A, X and Y.
*
            IPA = IPREPADA + 1
            IPX = IPA + DESCA( LLD_ )*NQA + IPOSTPADA + IPREPADX
            IPY = IPX + DESCX( LLD_ )*NQX + IPOSTPADX + IPREPADY
            IPMATA = IPY + DESCY( LLD_ )*NQY + IPOSTPADY
            IPMATX = IPMATA + MA*NA
            IPMATY = IPMATX + MX*NX
            IPG = IPMATY + MAX( MX*NX, MY*NY )
*
*           Check if sufficient memory.
*           Requirement = mem for local part of parallel matrices +
*                         mem for whole matrices for comp. check +
*                         mem for recving comp. check error vals.
*                         mem for printing
*
            MEMREQD = IPG + MAX( MAX( MBA, MAX( MBX, MBY ) ),
     $                           MAX( M, N ) )- 1
            IERR( 1 ) = 0
            IF( MEMREQD.GT.MEMSIZ ) THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9986 ) MEMREQD*DBLESZ
               IERR( 1 ) = 1
            END IF
*
*           Check all processes for an error
*
            CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, 0 )
*
            IF( IERR( 1 ).GT.0 ) THEN
               IF( IAM.EQ.0 )
     $            WRITE( NOUT, FMT = 9987 )
               TSKIP = TSKIP + 1
               GO TO 40
            END IF
*
*           Loop over all PBLAS 2 routines
*
            DO 30 K = 1, NSUBS
*
*              Continue only if this subroutine has to be tested.
*
               IF( .NOT.LTEST( K ) )
     $            GO TO 30
*
               IF( IAM.EQ.0 ) THEN
                  WRITE( NOUT, FMT = * )
                  WRITE( NOUT, FMT = 9985 ) SNAMES( K )
               END IF
*
*              Define the size of the operands
*
               IF( K.EQ.1 ) THEN
                  NROWA = M
                  NCOLA = N
                  IF( LSAME( TRANS, 'N' ) ) THEN
                     NLX = N
                     NLY = M
                  ELSE
                     NLX = M
                     NLY = N
                  END IF
               ELSE IF( K.EQ.5 ) THEN
                  NROWA = M
                  NCOLA = N
                  NLX = M
                  NLY = N
               ELSE
                  NROWA = N
                  NCOLA = N
                  NLX = N
                  NLY = N
               END IF
*
*              Check the validity of the operand sizes
*
               CALL MDIMCHK( ICTXT, NOUT, NROWA, NCOLA, 'A', IA, JA,
     $                       DESCA, IERR( 1 ) )
               CALL VDIMCHK( ICTXT, NOUT, NLX, 'X', IX, JX, DESCX,
     $                       INCX, IERR( 2 ) )
               CALL VDIMCHK( ICTXT, NOUT, NLY, 'Y', IY, JY, DESCY,
     $                       INCY, IERR( 3 ) )
*
               IF( IERR( 1 ).NE.0 .OR. IERR( 2 ).NE.0 .OR.
     $             IERR( 3 ).NE.0 ) THEN
                  KSKIP( K ) = KSKIP( K ) + 1
                  GO TO 30
               END IF
*
*              Generate distributed matrices A, X and Y
*
               IF( K.EQ.2 .OR. K.EQ.6 .OR. K.EQ.7 ) THEN
                  AFORM = 'S'
               ELSE
                  AFORM = 'N'
               END IF
*
*              Avoid weakness of Matrix generator
*
               IF( LSAME( AFORM, 'S' ) .OR. LSAME( AFORM, 'H' ) ) THEN
                  IF( DESCA( M_ ).NE.DESCA( N_ ) .OR. IA.NE.JA ) THEN
                     IF( IAM.EQ.0 )
     $                  WRITE( NOUT, FMT = 9973 )
                     KSKIP( K ) = KSKIP( K ) + 1
                     GO TO 30
                  END IF
               END IF
*
               CALL PBDMATGEN( ICTXT, AFORM, 'No diag', DESCA( M_ ),
     $                         DESCA( N_ ), DESCA( MB_ ), DESCA( NB_ ),
     $                         MEM( IPA ), DESCA( LLD_ ),
     $                         DESCA( RSRC_ ), DESCA( CSRC_ ), IASEED,
     $                         0, MPA, 0, NQA, MYROW, MYCOL,
     $                         NPROW, NPCOL )
*
               CALL PBDMATGEN( ICTXT, 'None', 'No diag', DESCX( M_ ),
     $                         DESCX( N_ ), DESCX( MB_ ), DESCX( NB_ ),
     $                         MEM( IPX ), DESCX( LLD_ ),
     $                         DESCX( RSRC_ ), DESCX( CSRC_ ), IXSEED,
     $                         0, MPX, 0, NQX, MYROW, MYCOL,
     $                         NPROW, NPCOL )
*
               IF( YCHECK( K ) ) THEN
                  CALL PBDMATGEN( ICTXT, 'None', 'No diag', DESCY( M_ ),
     $                            DESCY( N_ ), DESCY( MB_ ),
     $                            DESCY( NB_ ), MEM( IPY ),
     $                            DESCY( LLD_ ), DESCY( RSRC_ ),
     $                            DESCY( CSRC_ ), IYSEED, 0, MPY, 0,
     $                            NQY,MYROW, MYCOL, NPROW, NPCOL )
               END IF
*
*              Generate entire matrices on each process.
*
               CALL PBDMATGEN( ICTXT, AFORM, 'No Diag', MA, NA, MA,
     $                         NA, MEM( IPMATA ), MA, MYROW, MYCOL,
     $                         IASEED, 0, MA, 0, NA, MYROW, MYCOL,
     $                         NPROW, NPCOL )
*
               CALL PBDMATGEN( ICTXT, 'None', 'No diag', MX, NX, MX,
     $                         NX, MEM( IPMATX ), MX, MYROW, MYCOL,
     $                         IXSEED, 0, MX, 0, NX, MYROW, MYCOL,
     $                         NPROW, NPCOL )
*
               IF( YCHECK( K ) ) THEN
                  CALL PBDMATGEN( ICTXT, 'None', 'No diag', MY, NY, MY,
     $                            NY, MEM( IPMATY ), MY, MYROW, MYCOL,
     $                            IYSEED, 0, MY, 0, NY, MYROW, MYCOL,
     $                            NPROW, NPCOL )
               ELSE
*
*                 If Y is not needed, generate a copy of X instead
*
                  CALL PBDMATGEN( ICTXT, 'None', 'No diag', MX, NX, MX,
     $                            NX, MEM( IPMATY ), MX, MYROW, MYCOL,
     $                            IXSEED, 0, MX, 0, NX, MYROW, MYCOL,
     $                            NPROW, NPCOL )
               END IF
*
*              Zero non referenced part of the matrices A
*
               IF( K.EQ.2 .OR. K.EQ.6 .OR. K.EQ.7 ) THEN
*
*                 The distributed matrix A is symmetric
*
                  IF( LSAME( UPLO, 'L' ) ) THEN
*
*                    Zeros the strict upper triangular part of A.
*
                     CALL PDLASET( 'Upper', NROWA-1, NCOLA-1, ROGUE,
     $                             ROGUE, MEM( IPA ), IA, JA+1, DESCA )
                     IF( K.NE.2 ) THEN
                        CALL DLASET( 'Upper', NROWA-1, NCOLA-1, ROGUE,
     $                               ROGUE, MEM( IPMATA+IA-1+JA*LDA ),
     $                               LDA )
                     END IF
*
                  ELSE IF( LSAME( UPLO, 'U' ) ) THEN
*
*                    Zeros the strict lower triangular part of A.
*
                     CALL PDLASET( 'Lower', NROWA-1, NCOLA-1, ROGUE,
     $                             ROGUE, MEM( IPA ), IA+1, JA, DESCA )
                     IF( K.NE.2 ) THEN
                        CALL DLASET( 'Lower', NROWA-1, NCOLA-1, ROGUE,
     $                               ROGUE, MEM( IPMATA+IA+(JA-1)*LDA ),
     $                               LDA )
                     END IF
*
                  END IF
*
               ELSE IF( K.EQ.3 .OR. K.EQ.4 ) THEN
*
                  IF( LSAME( UPLO, 'L' ) ) THEN
*
*                    The distributed matrix A is lower triangular
*
                     IF( LSAME( DIAG, 'N' ) ) THEN
*
                        CALL PDLASET( 'Upper', NROWA-1, NCOLA-1, ROGUE,
     $                                ROGUE, MEM( IPA ), IA, JA+1,
     $                                DESCA )
                        CALL DLASET( 'Upper', NROWA-1, NCOLA-1, ZERO,
     $                               ZERO, MEM( IPMATA+IA-1+JA*LDA ),
     $                               LDA )
                     ELSE
*
                        CALL PDLASET( 'Upper', NROWA, NCOLA, ROGUE, ONE,
     $                                MEM( IPA ), IA, JA, DESCA )
                        CALL DLASET( 'Upper', NROWA, NCOLA, ZERO, ONE,
     $                               MEM( IPMATA+IA-1+(JA-1)*LDA ),
     $                               LDA )
                     END IF
*
                  ELSE IF( LSAME( UPLO, 'U' ) ) THEN
*
*                    The distributed matrix A is upper triangular
*
                     IF( LSAME( DIAG, 'N' ) ) THEN
*
                        CALL PDLASET( 'Lower', NROWA-1, NCOLA-1, ROGUE,
     $                                ROGUE, MEM( IPA ), IA+1, JA,
     $                                DESCA )
                        CALL DLASET( 'Lower', NROWA-1, NCOLA-1, ZERO,
     $                               ZERO, MEM( IPMATA+IA+(JA-1)*LDA ),
     $                               LDA )
*
                     ELSE
*
                        CALL PDLASET( 'Lower', NROWA, NCOLA, ROGUE, ONE,
     $                                MEM( IPA ), IA, JA, DESCA )
                        CALL DLASET( 'Lower', NROWA, NCOLA, ZERO, ONE,
     $                               MEM( IPMATA+IA-1+(JA-1)*LDA ),
     $                               LDA )
*
                     END IF
                  END IF
               END IF
*
*              Pad the guard zones of A, X and Y
*
               CALL PDFILLPAD( ICTXT, MPA, NQA, MEM( IPA-IPREPADA ),
     $                         DESCA( LLD_ ), IPREPADA, IPOSTPADA,
     $                         PADVAL )
*
               CALL PDFILLPAD( ICTXT, MPX, NQX, MEM( IPX-IPREPADX ),
     $                         DESCX( LLD_ ), IPREPADX, IPOSTPADX,
     $                         PADVAL )
*
               IF( YCHECK( K ) ) THEN
                  CALL PDFILLPAD( ICTXT, MPY, NQY, MEM( IPY-IPREPADY ),
     $                            DESCY( LLD_ ), IPREPADY, IPOSTPADY,
     $                            PADVAL )
               END IF
*
*              Initialize the check for INPUT-only arguments.
*
               INFO = 0
               CALL PDCHKARG2( ICTXT, NOUT, SNAMES( K ), UPLO, TRANS,
     $                         DIAG, M, N, ALPHA, IA, JA, DESCA, IX, JX,
     $                         DESCX, INCX, BETA, IY, JY, DESCY, INCY,
     $                         INFO )
*
*              Call the Level 2 PBLAS routine
*
               INFO = 0
               IF( K.EQ.1 ) THEN
*
                  IF( IVERB.EQ.2 ) THEN
                     IF( INCY.EQ.DESCY( M_ ) ) THEN
                        CALL PDLAPRNT( 1, NLY, MEM( IPY ), IY, JY,
     $                                 DESCY, 0, 0,
     $                                 'PARALLEL_INITIAL_Y', NOUT,
     $                                 MEM( IPG ) )
                     ELSE
                        CALL PDLAPRNT( NLY, 1, MEM( IPY ), IY, JY,
     $                                 DESCY, 0, 0,
     $                                 'PARALLEL_INITIAL_Y', NOUT,
     $                                 MEM( IPG ) )
                     END IF
                  ELSE IF( IVERB.GE.3 ) THEN
                     CALL PDLAPRNT( MY, NY, MEM( IPY ), 1, 1, DESCY, 0,
     $                              0, 'PARALLEL_INITIAL_Y', NOUT,
     $                              MEM( IPG ) )
                  END IF
*
*                 Test PDGEMV
*
                  CALL PDGEMV( TRANS, M, N, ALPHA, MEM( IPA ), IA, JA,
     $                         DESCA, MEM( IPX ), IX, JX, DESCX, INCX,
     $                         BETA, MEM( IPY ), IY, JY, DESCY, INCY )
*
               ELSE IF( K.EQ.2 ) THEN
*
                  IF( IVERB.EQ.2 ) THEN
                     IF( INCY.EQ.DESCY( M_ ) ) THEN
                        CALL PDLAPRNT( 1, NLY, MEM( IPY ), IY, JY,
     $                                 DESCY, 0, 0,
     $                                 'PARALLEL_INITIAL_Y', NOUT,
     $                                 MEM( IPG ) )
                     ELSE
                        CALL PDLAPRNT( NLY, 1, MEM( IPY ), IY, JY,
     $                                 DESCY, 0, 0,
     $                                 'PARALLEL_INITIAL_Y', NOUT,
     $                                 MEM( IPG ) )
                     END IF
                  ELSE IF( IVERB.GE.3 ) THEN
                     CALL PDLAPRNT( MY, NY, MEM( IPY ), 1, 1, DESCY, 0,
     $                              0, 'PARALLEL_INITIAL_Y', NOUT,
     $                              MEM( IPG ) )
                  END IF
*
*                 Test PDSYMV
*
                  CALL PDSYMV( UPLO, N, ALPHA, MEM( IPA ), IA, JA,
     $                         DESCA, MEM( IPX ), IX, JX, DESCX, INCX,
     $                         BETA, MEM( IPY ), IY, JY, DESCY, INCY )
*
               ELSE IF( K.EQ.3 ) THEN
*
                  IF( IVERB.EQ.2 ) THEN
                     IF( INCX.EQ.DESCX( M_ ) ) THEN
                        CALL PDLAPRNT( 1, NLX, MEM( IPX ), IX, JX,
     $                                 DESCX, 0, 0,
     $                                 'PARALLEL_INITIAL_X', NOUT,
     $                                 MEM( IPG ) )
                     ELSE
                        CALL PDLAPRNT( NLX, 1, MEM( IPX ), IX, JX,
     $                                 DESCX, 0, 0,
     $                                 'PARALLEL_INITIAL_X', NOUT,
     $                                 MEM( IPG ) )
                     END IF
                  ELSE IF( IVERB.GE.3 ) THEN
                     CALL PDLAPRNT( MX, NX, MEM( IPX ), 1, 1, DESCX, 0,
     $                              0, 'PARALLEL_INITIAL_X', NOUT,
     $                              MEM( IPG ) )
                  END IF
*
*                 Test PDTRMV
*
                  CALL PDTRMV( UPLO, TRANS, DIAG, N, MEM( IPA ), IA, JA,
     $                         DESCA, MEM( IPX ), IX, JX, DESCX, INCX )
*
               ELSE IF( K.EQ.4 ) THEN
*
                  IF( IVERB.EQ.2 ) THEN
                     IF( INCX.EQ.DESCX( M_ ) ) THEN
                        CALL PDLAPRNT( 1, NLX, MEM( IPX ), IX, JX,
     $                                 DESCX, 0, 0,
     $                                 'PARALLEL_INITIAL_X', NOUT,
     $                                 MEM( IPG ) )
                     ELSE
                        CALL PDLAPRNT( NLX, 1, MEM( IPX ), IX, JX,
     $                                 DESCX, 0, 0,
     $                                 'PARALLEL_INITIAL_X', NOUT,
     $                                 MEM( IPG ) )
                     END IF
                  ELSE IF( IVERB.GE.3 ) THEN
                     CALL PDLAPRNT( MX, NX, MEM( IPX ), 1, 1, DESCX, 0,
     $                              0, 'PARALLEL_INITIAL_X', NOUT,
     $                              MEM( IPG ) )
                  END IF
*
*                 Test PDTRSV
*
                  CALL PDTRSV( UPLO, TRANS, DIAG, N, MEM( IPA ), IA, JA,
     $                         DESCA, MEM( IPX ), IX, JX, DESCX, INCX )
*
               ELSE IF( K.EQ.5 ) THEN
*
                  IF( IVERB.EQ.2 ) THEN
                     CALL PDLAPRNT( NROWA, NCOLA, MEM( IPA ), IA, JA,
     $                              DESCA, 0, 0, 'PARALLEL_INITIAL_A',
     $                              NOUT, MEM( IPG ) )
                  ELSE IF( IVERB.GE.3 ) THEN
                     CALL PDLAPRNT( MA, NA, MEM( IPA ), 1, 1, DESCA,
     $                              0, 0, 'PARALLEL_INITIAL_A', NOUT,
     $                              MEM( IPG ) )
                  END IF
*
*                 Test PDGER
*
                  CALL PDGER( M, N, ALPHA, MEM( IPX ), IX, JX, DESCX,
     $                        INCX, MEM( IPY ), IY, JY, DESCY, INCY,
     $                        MEM( IPA ), IA, JA, DESCA )
*
               ELSE IF( K.EQ.6 ) THEN
*
                  IF( IVERB.EQ.2 ) THEN
                     CALL PDLAPRNT( NROWA, NCOLA, MEM( IPA ), IA, JA,
     $                              DESCA, 0, 0, 'PARALLEL_INITIAL_A',
     $                              NOUT, MEM( IPG ) )
                  ELSE IF( IVERB.GE.3 ) THEN
                     CALL PDLAPRNT( MA, NA, MEM( IPA ), 1, 1, DESCA,
     $                              0, 0, 'PARALLEL_INITIAL_A', NOUT,
     $                              MEM( IPG ) )
                  END IF
*
*                 Test PDSYR
*
                  CALL PDSYR( UPLO, N, ALPHA, MEM( IPX ), IX, JX, DESCX,
     $                         INCX, MEM( IPA ), IA, JA, DESCA )
*
               ELSE IF( K.EQ.7 ) THEN
*
                  IF( IVERB.EQ.2 ) THEN
                     CALL PDLAPRNT( NROWA, NCOLA, MEM( IPA ), IA, JA,
     $                              DESCA, 0, 0, 'PARALLEL_INITIAL_A',
     $                              NOUT, MEM( IPG ) )
                  ELSE IF( IVERB.GE.3 ) THEN
                     CALL PDLAPRNT( MA, NA, MEM( IPA ), 1, 1, DESCA,
     $                              0, 0, 'PARALLEL_INITIAL_A', NOUT,
     $                              MEM( IPG ) )
                  END IF
*
*                 Test PDSYR2
*
                  CALL PDSYR2( UPLO, N, ALPHA, MEM( IPX ), IX, JX,
     $                         DESCX, INCX, MEM( IPY ), IY, JY, DESCY,
     $                         INCY, MEM( IPA ), IA, JA, DESCA )
*
               END IF
*
*              Check if the operation has been performed.
*
               IF( INFO.NE.0 ) THEN
                  KSKIP( K ) = KSKIP( K ) + 1
                  IF( IAM.EQ.0 )
     $               WRITE( NOUT, FMT = 9974 ) INFO
                  GO TO 30
               END IF
*
*              Check padding
*
               CALL PDCHEKPAD( ICTXT, 'PARALLEL_A', MPA, NQA,
     $                         MEM( IPA-IPREPADA ), DESCA( LLD_ ),
     $                         IPREPADA, IPOSTPADA, PADVAL )
*
               CALL PDCHEKPAD( ICTXT, 'PARALLEL_X', MPX, NQX,
     $                         MEM( IPX-IPREPADX ), DESCX( LLD_ ),
     $                         IPREPADX, IPOSTPADX, PADVAL )
*
               IF( YCHECK( K ) ) THEN
                  CALL PDCHEKPAD( ICTXT, 'PARALLEL_Y', MPY, NQY,
     $                            MEM( IPY-IPREPADY ), DESCY( LLD_ ),
     $                            IPREPADY, IPOSTPADY, PADVAL )
               END IF
*
*              Check the computations
*
               CALL PDBLA2TCHK( ICTXT, NOUT, K, UPLO, TRANS, DIAG, M, N,
     $                          ALPHA, MEM( IPMATA ), MEM( IPA ), IA,
     $                          JA, DESCA, MEM( IPMATX ), MEM( IPX ),
     $                          IX, JX, DESCX, INCX, BETA,
     $                          MEM( IPMATY ), MEM( IPY ), IY, JY,
     $                          DESCY, INCY, THRESH, ROGUE, MEM( IPG ),
     $                          INFO )
               IF( MOD( INFO, 2 ).EQ.1 ) THEN
                  IERR( 1 ) = 1
               ELSE IF( MOD( INFO / 2, 2 ).EQ.1 ) THEN
                  IERR( 2 ) = 1
               ELSE IF( MOD( INFO / 4, 2 ).EQ.1 ) THEN
                  IERR( 3 ) = 1
               ELSE IF( INFO.NE.0 ) THEN
                  IERR( 1 ) = 1
                  IERR( 2 ) = 1
                  IERR( 3 ) = 1
               END IF
*
*              Check input-only scalar arguments
*
               INFO = 1
               CALL PDCHKARG2( ICTXT, NOUT, SNAMES( K ), UPLO, TRANS,
     $                         DIAG, M, N, ALPHA, IA, JA, DESCA, IX, JX,
     $                         DESCX, INCX, BETA, IY, JY, DESCY, INCY,
     $                         INFO )
*
*              Check input-only array arguments
*
               CALL PDCHKMOUT( NROWA, NCOLA, MEM( IPMATA ), MEM( IPA ),
     $                         IA, JA, DESCA, IERR( 4 ) )
               CALL PDCHKVOUT( NLX, MEM( IPMATX ), MEM( IPX ), IX, JX,
     $                         DESCX, INCX, IERR( 5 ) )
*
               IF( IERR( 4 ).NE.0 ) THEN
                  IF( IAM.EQ.0 )
     $               WRITE( NOUT, FMT = 9982 ) 'PARALLEL_A',
     $                                         SNAMES( K )
               END IF
*
               IF( IERR( 5 ).NE.0 ) THEN
                  IF( IAM.EQ.0 )
     $               WRITE( NOUT, FMT = 9982 ) 'PARALLEL_X',
     $                                         SNAMES( K )
               END IF
*
               IF( YCHECK( K ) ) THEN
                  CALL PDCHKVOUT( NLY, MEM( IPMATY ), MEM( IPY ), IY,
     $                            JY, DESCY, INCY, IERR( 6 ) )
                  IF( IERR( 6 ).NE.0 ) THEN
                     IF( IAM.EQ.0 )
     $                  WRITE( NOUT, FMT = 9982 ) 'PARALLEL_Y',
     $                                            SNAMES( K )
                  END IF
               END IF
*
*              Only node 0 prints computational test result
*
               IF( INFO.NE.0 .OR. IERR( 1 ).NE.0 .OR.
     $             IERR( 2 ).NE.0 .OR. IERR( 3 ).NE.0 .OR.
     $             IERR( 4 ).NE.0 .OR. IERR( 5 ).NE.0 .OR.
     $             IERR( 6 ).NE.0 ) THEN
                  IF( IAM.EQ.0 )
     $               WRITE( NOUT, FMT = 9984 ) SNAMES( K )
                  KFAIL( K ) = KFAIL( K ) + 1
                  ERRFLG = .TRUE.
               ELSE
                  IF( IAM.EQ.0 )
     $               WRITE( NOUT, FMT = 9983 ) SNAMES( K )
                  KPASS( K ) = KPASS( K ) + 1
               END IF
*
*              Dump matrix if IVERB >= 1 and error.
*
               IF( IVERB.GE.1 .AND. ERRFLG ) THEN
                  IF( IERR( 4 ).NE.0 .OR. IVERB.GE.2 ) THEN
                     CALL DMPRNT( ICTXT, NOUT, MA, NA, MEM( IPMATA ),
     $                            LDA, 0, 0, 'SERIAL_A' )
                     CALL PDLAPRNT( MA, NA, MEM( IPA ), 1, 1, DESCA,
     $                              0, 0, 'PARALLEL_A', NOUT,
     $                              MEM( IPMATA ) )
                  ELSE IF( IERR( 1 ).NE.0 ) THEN
                     CALL DMPRNT( ICTXT, NOUT, NROWA, NCOLA,
     $                            MEM( IPMATA+IA-1+(JA-1)*LDA ),
     $                            LDA, 0, 0, 'SERIAL_A' )
                     CALL PDLAPRNT( NROWA, NCOLA, MEM( IPA ), IA, JA,
     $                              DESCA, 0, 0, 'PARALLEL_A', NOUT,
     $                              MEM( IPMATA ) )
                  END IF
                  IF( IERR( 5 ).NE.0 ) THEN
                     CALL DMPRNT( ICTXT, NOUT, MX, NX, MEM( IPMATX ),
     $                            LDX, 0, 0, 'SERIAL_X' )
                     CALL PDLAPRNT( MX, NX, MEM( IPX ), 1, 1, DESCX, 0,
     $                              0, 'PARALLEL_X', NOUT,
     $                              MEM( IPMATX ) )
                  ELSE IF( IERR( 2 ).NE.0 ) THEN
                     CALL DVPRNT( ICTXT, NOUT, NLX,
     $                            MEM( IPMATX+IX-1+(JX-1)*LDX ),
     $                            INCX, 0, 0, 'SERIAL_X' )
                     IF( INCX.EQ.DESCX( M_ ) ) THEN
                        CALL PDLAPRNT( 1, NLX, MEM( IPX ), IX, JX,
     $                                 DESCX, 0, 0, 'PARALLEL_X', NOUT,
     $                                 MEM( IPMATX ) )
                     ELSE
                        CALL PDLAPRNT( NLX, 1, MEM( IPX ), IX, JX,
     $                                 DESCX, 0, 0, 'PARALLEL_X', NOUT,
     $                                 MEM( IPMATX ) )
                     END IF
                  END IF
                  IF( YCHECK( K ) ) THEN
                     IF( IERR( 6 ).NE.0 ) THEN
                        CALL DMPRNT( ICTXT, NOUT, MY, NY, MEM( IPMATY ),
     $                               LDY, 0, 0, 'SERIAL_Y' )
                        CALL PDLAPRNT( MY, NY, MEM( IPY ), 1, 1, DESCY,
     $                                 0, 0, 'PARALLEL_Y', NOUT,
     $                                 MEM( IPMATX ) )
                     ELSE IF( IERR( 3 ).NE.0 ) THEN
                        CALL DVPRNT( ICTXT, NOUT, NLY,
     $                               MEM( IPMATY+IY-1+(JY-1)*LDY ),
     $                               INCY, 0, 0, 'SERIAL_Y' )
                        IF( INCY.EQ.DESCY( M_ ) ) THEN
                           CALL PDLAPRNT( 1, NLY, MEM( IPY ), IY, JY,
     $                                    DESCY, 0, 0, 'PARALLEL_Y',
     $                                    NOUT, MEM( IPMATX ) )
                        ELSE
                           CALL PDLAPRNT( NLY, 1, MEM( IPY ), IY, JY,
     $                                    DESCY, 0, 0, 'PARALLEL_Y',
     $                                    NOUT, MEM( IPMATX ) )
                        END IF
                     END IF
                  END IF
               END IF
*
*              Leave if error and "Stop On Failure"
*
               IF( SOF.AND.ERRFLG )
     $            GO TO 70
*
   30       CONTINUE
*
   40       IF( IAM.EQ.0 ) THEN
               WRITE( NOUT, FMT = * )
               WRITE( NOUT, FMT = 9981 ) J
            END IF
*
   50   CONTINUE
*
        CALL BLACS_GRIDEXIT( ICTXT )
*
   60 CONTINUE
*
*     Come here, if error and "Stop On Failure"
*
   70 CONTINUE
*
*     Before printing out final stats, add TSKIP to all skips
*
      DO 80 I = 1, NSUBS
         IF( LTEST( I ) ) THEN
            KSKIP( I ) = KSKIP( I ) + TSKIP
            KTESTS( I ) = KSKIP( I ) + KFAIL( I ) + KPASS( I )
         END IF
   80 CONTINUE
*
*     Print results
*
      IF( IAM.EQ.0 ) THEN
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9977 )
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9979 )
         WRITE( NOUT, FMT = 9978 )
*
         DO 90 I = 1, NSUBS
            WRITE( NOUT, FMT = 9980 ) SNAMES( I ), KTESTS( I ),
     $                                KPASS( I ), KFAIL( I ), KSKIP( I )
   90    CONTINUE
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9976 )
         WRITE( NOUT, FMT = * )
*
      END IF
*
      CALL BLACS_EXIT( 0 )
*
 9999 FORMAT( 'ILLEGAL ', A, ': ', A, ' = ', I10,
     $        ' should be at least 1' )
 9998 FORMAT( 'ILLEGAL GRID: NPROW*NPCOL = ', I4,
     $        '. It can be at most', I4 )
 9997 FORMAT( 'Bad ', A, ' parameters: going on to next test case.' )
 9996 FORMAT( 2X, 'Test number ', I2 , ' started on a ', I4, ' x ',
     $        I4, ' process grid.' )
 9995 FORMAT( 2X, '   ------------------------------------------------',
     $        '-------------------' )
 9994 FORMAT( 2X, '        M      N       UPLO       TRANS       DIAG' )
 9993 FORMAT( 5X,I6,1X,I6,9X,A1,11X,A1,10X,A1 )
 9992 FORMAT( 2X, '       IA     JA     MA     NA    MBA    NBA',
     $        ' RSRCA CSRCA' )
 9991 FORMAT( 5X,I6,1X,I6,1X,I6,1X,I6,1X,I6,1X,I6,1X,I5,1X,I5 )
 9990 FORMAT( 2X, '       IX     JX     MX     NX    MBX    NBX',
     $        ' RSRCX CSRCX   INCX' )
 9989 FORMAT( 5X,I6,1X,I6,1X,I6,1X,I6,1X,I6,1X,I6,1X,I5,1X,I5,1X,I6 )
 9988 FORMAT( 2X, '       IY     JY     MY     NY    MBY    NBY',
     $        ' RSRCY CSRCY   INCY' )
 9987 FORMAT( 'Not enough memory for this test: going on to',
     $        ' next test case.' )
 9986 FORMAT( 'Not enough memory. Need: ', I12 )
 9985 FORMAT( 2X, '   Tested Subroutine: ', A )
 9984 FORMAT( 2X, '   ***** Computational check: ', A, '       ',
     $        ' FAILED ',' *****' )
 9983 FORMAT( 2X, '   ***** Computational check: ', A, '       ',
     $        ' PASSED ',' *****' )
 9982 FORMAT( 2X, '   ***** ERROR ***** Matrix operand ', A,
     $        ' modified by ', A, ' *****' )
 9981 FORMAT( 2X, 'Test number ', I2, ' completed.' )
 9980 FORMAT( 5X,A7,8X,I4,6X,I4,5X,I4,4X,I4 )
 9979 FORMAT( 2X, '   SUBROUTINE  TOTAL TESTS  PASSED   FAILED  ',
     $        'SKIPPED' )
 9978 FORMAT( 2X, '   ----------  -----------  ------   ------  ',
     $        '-------' )
 9977 FORMAT( 2X, 'Testing Summary')
 9976 FORMAT( 2X, 'End of Tests.' )
 9975 FORMAT( 2X, 'Tests started.' )
 9974 FORMAT( 2X, '   ***** Operation not supported, error code: ',
     $        I5, ' *****' )
 9973 FORMAT( 2X, '   ***** Test not supported yet: SKIPPED *****' )
*
      STOP
*
*     End of PDBLA2TST
*
      END
      SUBROUTINE PDBLA2TINFO( SUMMRY, NOUT, NMAT, DIAGVAL, TRANSVAL,
     $                        UPLOVAL, MVAL, NVAL, MAVAL, NAVAL, MBAVAL,
     $                        NBAVAL, RSRCAVAL, CSRCAVAL, IAVAL, JAVAL,
     $                        MXVAL, NXVAL, MBXVAL, NBXVAL, RSRCXVAL,
     $                        CSRCXVAL, IXVAL, JXVAL, INCXVAL, MYVAL,
     $                        NYVAL, MBYVAL, NBYVAL, RSRCYVAL, CSRCYVAL,
     $                        IYVAL, JYVAL, INCYVAL, LDVAL, NGRIDS,
     $                        PVAL, LDPVAL, QVAL, LDQVAL, LTEST, SOF,
     $                        TEE, IAM, IGAP, IVERB, NPROCS, THRESH,
     $                        ALPHA, BETA, WORK )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER*( * )    SUMMRY
      LOGICAL            SOF, TEE
      INTEGER            IAM, IGAP, IVERB, LDPVAL, LDQVAL, LDVAL,
     $                   NGRIDS, NMAT, NOUT, NPROCS
      REAL               THRESH
      DOUBLE PRECISION   ALPHA, BETA
*     ..
*     .. Array Arguments ..
      CHARACTER          DIAGVAL( LDVAL ), TRANSVAL( LDVAL ),
     $                   UPLOVAL( LDVAL )
      LOGICAL            LTEST( * )
      INTEGER            CSRCAVAL( LDVAL ), CSRCXVAL( LDVAL ),
     $                   CSRCYVAL( LDVAL ), IAVAL( LDVAL ),
     $                   INCXVAL( LDVAL ), INCYVAL( LDVAL ),
     $                   IXVAL( LDVAL ), IYVAL( LDVAL ), JAVAL( LDVAL ),
     $                   JXVAL( LDVAL ), JYVAL( LDVAL ), MVAL( LDVAL ),
     $                   MAVAL( LDVAL ), MBAVAL( LDVAL ),
     $                   MBXVAL( LDVAL ), MBYVAL( LDVAL ),
     $                   MXVAL( LDVAL ), MYVAL( LDVAL ), NAVAL( LDVAL ),
     $                   NBAVAL( LDVAL ), NBXVAL( LDVAL ),
     $                   NBYVAL( LDVAL ), NVAL( LDVAL ), NXVAL( LDVAL ),
     $                   NYVAL( LDVAL ), PVAL( LDPVAL ), QVAL( LDQVAL ),
     $                   RSRCAVAL( LDVAL ), RSRCXVAL( LDVAL ),
     $                   RSRCYVAL( LDVAL ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDBLA2TINFO gets needed startup information for testing various
*  PBLAS 2 routines, and transmits it to all processes.
*
*  Arguments
*  =========
*
*  SUMMRY   (global output) CHARACTER*(*)
*           Name of output (summary) file (if any). Only defined for
*           process 0.
*
*  NOUT     (global output) INTEGER
*           The unit number for output file. NOUT = 6, ouput to screen,
*           NOUT = 0, output to stderr.  Only defined for process 0.
*
*  NMAT     (global output) INTEGER
*           The number of different test cases.
*
*  DIAGVAL  (global output) CHARACTER array, dimension (LDVAL)
*           The values of DIAG to run the code with.
*
*  TRANSVAL (global output) CHARACTER array, dimension (LDVAL)
*           The values of TRANS to run the code with.
*
*  UPLOVAL  (global output) CHARACTER array, dimension (LDVAL)
*           The values of UPLO to run the code with.
*
*  MVAL     (global output) INTEGER array, dimension (LDVAL)
*           The values of M to run the code with.
*
*  NVAL     (global output) INTEGER array, dimension (LDVAL)
*           The values of N to run the code with.
*
*  MAVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCA( M_ ) (number of rows in the
*           distributed matrix A) to run the code with.
*
*  NAVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCA( N_ ) (number of columns in
*           the distributed matrix A) to run the code with.
*
*  MBAVAL   (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCA( MB_ ) (row block sizes of the
*           distributed matrix A) to run the code with.
*
*  NBAVAL   (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCA( NB_ ) (column block sizes of
*           the distributed matrix A) to run the code with.
*
*  RSRCAVAL (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCA( RSRC_ ) (row process source of
*           the distributed matrix A) to run the code with.
*
*  CSRCAVAL (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCA( CSRC_ ) (column process source
*           of the distributed matrix A) to run the code with.
*
*  IAVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of IA (global row source index of the
*           matrix operand A) to run the code with.
*
*  JAVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of JA (global column source index of
*           the matrix operand A) to run the code with.
*
*  MXVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCX( M_ ) (number of rows in the
*           distributed matrix X) to run the code with.
*
*  NXVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCX( N_ ) (number of columns in
*           the distributed matrix X) to run the code with.
*
*  MBXVAL   (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCX( MB_ ) (row block sizes of the
*           distributed matrix X) to run the code with.
*
*  NBXVAL   (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCX( NB_ ) (column block sizes of
*           the distributed matrix X) to run the code with.
*
*  RSRCXVAL (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCX( RSRC_ ) (row process source of
*           the distributed matrix X) to run the code with.
*
*  CSRCXVAL (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCX( CSRC_ ) (column process source
*           of the distributed matrix X) to run the code with.
*
*  IXVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of IX (global row source index of the
*           vector operand X) to run the code with.
*
*  JXVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of JX (global column source index of
*           the vector operand X) to run the code with.
*
*  INCXVAL  (global output) INTEGER array, dimension (LDVAL)
*           The values of INCX (global increment of the vector
*           operand X(IX:,JX:) to run the code with.
*
*  MYVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCY( M_ ) (number of rows in the
*           distributed matrix Y) to run the code with.
*
*  NYVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCY( N_ ) (number of columns in
*           the distributed matrix Y) to run the code with.
*
*  MBYVAL   (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCY( MB_ ) (row block sizes of the
*           distributed matrix Y) to run the code with.
*
*  NBYVAL   (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCY( NB_ ) (column block sizes of
*           the distributed matrix Y) to run the code with.
*
*  RSRCYVAL (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCY( RSRC_ ) (row process source of
*           the distributed matrix Y) to run the code with.
*
*  CSRCYVAL (global output) INTEGER array, dimension (LDVAL)
*           The values of DESCY( CSRC_ ) (column process source
*           of the distributed matrix Y) to run the code with.
*
*  IYVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of IY (global row source index of the
*           vector operand Y) to run the code with.
*
*  JYVAL    (global output) INTEGER array, dimension (LDVAL)
*           The values of JY (global column source index of
*           the vector operand Y) to run the code with.
*
*  INCYVAL  (global output) INTEGER array, dimension (LDVAL)
*           The values of INCY (global increment of the vector
*           operand Y(IY:,JY:) to run the code with.
*
*  LDVAL    (global output) INTEGER array, dimension (LDVAL)
*           The maximum number of different values that can be used for
*           DIAG, TRANS, UPLO, M, N, DESCA(2:7), IA, JA, DESCX(2:7), IX,
*           JX, INCX, DESCY(2:7), IY, JY, INCY. This is also the maximum
*           number of test cases.
*
*  NGRIDS   (global output) INTEGER
*           The number of different values that can be used for P & Q.
*
*  PVAL     (global output) INTEGER array, dimension (LDPVAL)
*           The values of P (number of process rows) to run the code
*           with.
*
*  LDPVAL   (global input) INTEGER
*           The maximum number of different values that can be used for
*           P, LDPVAL >= NGRIDS.
*
*  QVAL     (global output) INTEGER array, dimension (LDQVAL)
*           The values of Q (number of process columns) to run the code
*           with.
*
*  LDQVAL   (global input) INTEGER
*           The maximum number of different values that can be used for
*           Q, LDQVAL >= NGRIDS.
*
*  LTEST    (Global output) LOGICAL array, dimension (>= NSUBS = 7 )
*           If LTEST( i ) is .TRUE. on exit, the i-th PBLAS-2 routine
*           will be tested. See the input file for the ordering of the
*           routines.
*
*  SOF      (Global output) LOGICAL
*           If SOF is .TRUE. on exit, the tester will stop on the first
*           detected failure. Otherwise, it won't.
*
*  TEE      (Global output) LOGICAL
*           If TEE is .TRUE. on exit, the tester will perform the error
*           exit tests. These tests won't be performed otherwise.
*
*  IAM      (local input) INTEGER
*           My process number.
*
*  IGAP     (Global output) INTEGER
*           On exit, the user-specified gap used for padding (>= 0).
*
*  IVERB    (Global output) INTEGER
*           The output verbosity level: 0 for pass/fail, 1, 2 or 3 for
*           matrix dump on errors.
*
*  NPROCS   (global input) INTEGER
*           The total number of processes.
*
*  THRESH   (global output) REAL
*           The threshhold value for the test ratio.
*
*  ALPHA    (global output) DOUBLE PRECISION
*           The value of ALPHA to be used in all the test cases.
*
*  BETA     (global output) DOUBLE PRECISION
*           The value of BETA to be used in all the test cases.
*
*  WORK     (local workspace) INTEGER array of dimension >=
*           MAX( 2, 2*NGRIDS+31*NMAT+NSUBS+4 ) with NSUBS = 7. Used to
*           pack all input arrays in order to send info in one message.
*
* ======================================================================
*
* Note: For packing the information we assumed that the length in bytes
* ===== of an integer is equal to the length in bytes of a real single
*       precision.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      INTEGER            NIN, NSUBS
      PARAMETER          ( NIN = 11, NSUBS = 7 )
*     ..
*     .. Local Scalars ..
      CHARACTER*7        SNAMET
      CHARACTER*79       USRINFO
      LOGICAL            LTESTT
      INTEGER            I, ICTXT, J
      DOUBLE PRECISION   EPS
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_ABORT, BLACS_GET, BLACS_GRIDEXIT,
     $                   BLACS_GRIDINIT, BLACS_SETUP, DGEBS2D,
     $                   DGEBR2D, ICOPY, IGEBR2D, IGEBS2D, SGEBR2D,
     $                   SGEBS2D
*     ..
*     .. External Functions ..
      DOUBLE PRECISION   PDLAMCH
      EXTERNAL           PDLAMCH
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          CHAR, ICHAR, MAX, MIN
*     ..
*     .. Scalars in Common ..
      CHARACTER*7        SNAMES( NSUBS )
*     ..
*     .. Common blocks ..
      COMMON             /SNAMEC/SNAMES
*     ..
*     .. Executable Statements ..
*
*     Process 0 reads the input data, broadcasts to other processes and
*     writes needed information to NOUT
*
      IF( IAM.EQ.0 ) THEN
*
*        Open file and skip data file header
*
         OPEN( NIN, FILE='PDBLA2TST.dat', STATUS='OLD' )
         READ( NIN, FMT = * ) SUMMRY
         SUMMRY = ' '
*
*        Read in user-supplied info about machine type, compiler, etc.
*
         READ( NIN, FMT = 9999 ) USRINFO
*
*        Read name and unit number for summary output file
*
         READ( NIN, FMT = * ) SUMMRY
         READ( NIN, FMT = * ) NOUT
         IF( NOUT.NE.0 .AND. NOUT.NE.6 )
     $      OPEN( NOUT, FILE = SUMMRY, STATUS = 'UNKNOWN' )
*
*        Read and check the parameter values for the tests.
*
*        Read the flag that indicates if Stop on Failure
*
         READ( NIN, FMT = * ) SOF
*
*        Read the flag that indicates if Test Error Exits
*
         READ( NIN, FMT = * ) TEE
*
*        Read the verbosity level
*
         READ( NIN, FMT = * ) IVERB
         IF( IVERB.LT.0 .OR. IVERB.GT.3 )
     $      IVERB = 0
*
*        Read the leading dimension gap
*
         READ( NIN, FMT = * ) IGAP
         IF( IGAP.LT.0 )
     $      IGAP = 0
*
*        Read the threshold value for test ratio
*
         READ( NIN, FMT = * ) THRESH
         IF( THRESH.LT.0.0 )
     $      THRESH = 16.0
*
*        Get number of grids
*
         READ( NIN, FMT = * ) NGRIDS
         IF( NGRIDS.LT.1 .OR. NGRIDS.GT.LDPVAL ) THEN
            WRITE( NOUT, FMT = 9998 ) 'Grids', LDPVAL
            GO TO 120
         ELSE IF( NGRIDS.GT.LDQVAL ) THEN
            WRITE( NOUT, FMT = 9998 ) 'Grids', LDQVAL
            GO TO 120
         END IF
*
*        Get values of P and Q
*
         READ( NIN, FMT = * ) ( PVAL( I ), I = 1, NGRIDS )
         READ( NIN, FMT = * ) ( QVAL( I ), I = 1, NGRIDS )
*
*        Read ALPHA, BETA
*
         READ( NIN, FMT = * ) ALPHA
         READ( NIN, FMT = * ) BETA
*
*        Read number of tests.
*
         READ( NIN, FMT = * ) NMAT
         IF( NMAT.LT.1 .OR. NMAT.GT.LDVAL ) THEN
            WRITE( NOUT, FMT = 9998 ) 'Tests', LDVAL
            GO TO 120
         ENDIF
*
*        Read in input data into arrays.
*
         READ( NIN, FMT = * ) ( UPLOVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( TRANSVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( DIAGVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MBAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NBAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( RSRCAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( CSRCAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( IAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( JAVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MBXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NBXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( RSRCXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( CSRCXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( IXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( JXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( INCXVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( MBYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( NBYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( RSRCYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( CSRCYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( IYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( JYVAL( I ), I = 1, NMAT )
         READ( NIN, FMT = * ) ( INCYVAL( I ), I = 1, NMAT )
*
*        Read names of subroutines and flags which indicate
*        whether they are to be tested.
*
         DO 10 I = 1, NSUBS
            LTEST( I ) = .FALSE.
   10    CONTINUE
   20    CONTINUE
         READ( NIN, FMT = 9996, END = 50 ) SNAMET, LTESTT
         DO 30 I = 1, NSUBS
            IF( SNAMET.EQ.SNAMES( I ) )
     $         GO TO 40
   30    CONTINUE
*
         WRITE( NOUT, FMT = 9995 )SNAMET
         GO TO 120
*
   40    CONTINUE
         LTEST( I ) = LTESTT
         GO TO 20
*
   50    CONTINUE
*
*        Close input file
*
         CLOSE ( NIN )
*
*        For pvm only: if virtual machine not set up, allocate it and
*        spawn the correct number of processes.
*
         IF( NPROCS.LT.1 ) THEN
            NPROCS = 0
            DO 60 I = 1, NGRIDS
               NPROCS = MAX( NPROCS, PVAL( I )*QVAL( I ) )
   60       CONTINUE
            CALL BLACS_SETUP( IAM, NPROCS )
         END IF
*
*        Temporarily define blacs grid to include all processes so
*        information can be broadcast to all processes
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
*
*        Compute machine epsilon
*
         EPS = PDLAMCH( ICTXT, 'eps' )
*
*        Pack information arrays and broadcast
*
         CALL SGEBS2D( ICTXT, 'All', ' ', 1, 1, THRESH, 1 )
         CALL DGEBS2D( ICTXT, 'All', ' ', 1, 1, ALPHA, 1 )
         CALL DGEBS2D( ICTXT, 'All', ' ', 1, 1, BETA, 1 )
*
         WORK( 1 ) = NGRIDS
         WORK( 2 ) = NMAT
         CALL IGEBS2D( ICTXT, 'All', ' ', 2, 1, WORK, 2 )
*
         I = 1
         IF( SOF ) THEN
            WORK( I ) = 1
         ELSE
            WORK( I ) = 0
         END IF
         I = I + 1
         IF( TEE ) THEN
            WORK( I ) = 1
         ELSE
            WORK( I ) = 0
         END IF
         I = I + 1
         WORK( I ) = IVERB
         I = I + 1
         WORK( I ) = IGAP
         I = I + 1
         DO 70 J = 1, NMAT
            WORK( I ) = ICHAR( DIAGVAL( J ) )
            WORK( I+1 ) = ICHAR( TRANSVAL( J ) )
            WORK( I+2 ) = ICHAR( UPLOVAL( J ) )
            I = I + 3
   70    CONTINUE
         CALL ICOPY( NGRIDS, PVAL, 1, WORK( I ), 1 )
         I = I + NGRIDS
         CALL ICOPY( NGRIDS, QVAL, 1, WORK( I ), 1 )
         I = I + NGRIDS
         CALL ICOPY( NMAT, MVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, MAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, MBAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NBAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, RSRCAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, CSRCAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, IAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, JAVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, MXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, MBXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NBXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, RSRCXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, CSRCXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, IXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, JXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, INCXVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, MYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, MBYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, NBYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, RSRCYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, CSRCYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, IYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, JYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, INCYVAL, 1, WORK( I ), 1 )
         I = I + NMAT
*
         DO 80 J = 1, NSUBS
            IF( LTEST( J ) ) THEN
               WORK( I ) = 1
            ELSE
               WORK( I ) = 0
            END IF
            I = I + 1
   80    CONTINUE
         I = I - 1
         CALL IGEBS2D( ICTXT, 'All', ' ', I, 1, WORK, I )
*
*        regurgitate input
*
         WRITE( NOUT, FMT = 9999 )
     $               'ScaLAPACK Level-2 PBLAS testing program.'
         WRITE( NOUT, FMT = 9999 ) USRINFO
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9999 )
     $               'Tests of the real double precision '//
     $               'Level-2 PBLAS'
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9993 ) NMAT
         WRITE( NOUT, FMT = 9992 ) NGRIDS
         WRITE( NOUT, FMT = 9990 )
     $               'P', ( PVAL(I), I = 1, MIN(NGRIDS, 5) )
         IF( NGRIDS.GT.5 )
     $      WRITE( NOUT, FMT = 9991 ) ( PVAL(I), I = 6,
     $                                  MAX( 10, NGRIDS ) )
         IF( NGRIDS.GT.10 )
     $      WRITE( NOUT, FMT = 9991 ) ( PVAL(I), I = 11,
     $                                  MAX( 15, NGRIDS ) )
         IF( NGRIDS.GT.15 )
     $      WRITE( NOUT, FMT = 9991 ) ( PVAL(I), I = 16, NGRIDS )
         WRITE( NOUT, FMT = 9990 )
     $               'Q', ( QVAL(I), I = 1, MIN(NGRIDS, 5) )
         IF( NGRIDS.GT.5 )
     $      WRITE( NOUT, FMT = 9991 ) ( QVAL(I), I = 6,
     $                                  MAX( 10, NGRIDS ) )
         IF( NGRIDS.GT.10 )
     $      WRITE( NOUT, FMT = 9991 ) ( QVAL(I), I = 11,
     $                                  MAX( 15, NGRIDS ) )
         IF( NGRIDS.GT.15 )
     $      WRITE( NOUT, FMT = 9991 ) ( QVAL(I), I = 16, NGRIDS )
         WRITE( NOUT, FMT = 9988 ) SOF
         WRITE( NOUT, FMT = 9987 ) TEE
         WRITE( NOUT, FMT = 9983 ) IGAP
         WRITE( NOUT, FMT = 9986 ) IVERB
         WRITE( NOUT, FMT = 9980 ) THRESH
         WRITE( NOUT, FMT = 9982 ) ALPHA
         WRITE( NOUT, FMT = 9981 ) BETA
         IF( LTEST( 1 ) ) THEN
            WRITE( NOUT, FMT = 9985 ) SNAMES( 1 ), ' ... Yes'
         ELSE
            WRITE( NOUT, FMT = 9985 ) SNAMES( 1 ), ' ... No '
         END IF
         DO 90 I = 1, NSUBS
            IF( LTEST( I ) ) THEN
               WRITE( NOUT, FMT = 9984 ) SNAMES( I ), ' ... Yes'
            ELSE
               WRITE( NOUT, FMT = 9984 ) SNAMES( I ), ' ... No '
            END IF
   90    CONTINUE
         WRITE( NOUT, FMT = 9994 ) EPS
         WRITE( NOUT, FMT = * )
*
      ELSE
*
*        If in pvm, must participate setting up virtual machine
*
         IF( NPROCS.LT.1 )
     $      CALL BLACS_SETUP( IAM, NPROCS )
*
*        Temporarily define blacs grid to include all processes so
*        information can be broadcast to all processes
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
*
*        Compute machine epsilon
*
         EPS = PDLAMCH( ICTXT, 'eps' )
*
         CALL SGEBR2D( ICTXT, 'All', ' ', 1, 1, THRESH, 1, 0, 0 )
         CALL DGEBR2D( ICTXT, 'All', ' ', 1, 1, ALPHA, 1, 0, 0 )
         CALL DGEBR2D( ICTXT, 'All', ' ', 1, 1, BETA, 1, 0, 0 )
*
         CALL IGEBR2D( ICTXT, 'All', ' ', 2, 1, WORK, 2, 0, 0 )
         NGRIDS = WORK( 1 )
         NMAT   = WORK( 2 )
*
         I = 2*NGRIDS + 31*NMAT + NSUBS + 4
         CALL IGEBR2D( ICTXT, 'All', ' ', I, 1, WORK, I, 0, 0 )
*
         I = 1
         IF( WORK( I ).EQ.1 ) THEN
            SOF = .TRUE.
         ELSE
            SOF = .FALSE.
         END IF
         I = I + 1
         IF( WORK( I ).EQ.1 ) THEN
            TEE = .TRUE.
         ELSE
            TEE = .FALSE.
         END IF
         I = I + 1
         IVERB = WORK( I )
         I = I + 1
         IGAP = WORK( I )
         I = I + 1
         DO 100 J = 1, NMAT
            DIAGVAL( J ) = CHAR( WORK( I ) )
            TRANSVAL( J ) = CHAR( WORK( I+1 ) )
            UPLOVAL( J ) = CHAR( WORK( I+2 ) )
            I = I + 3
  100    CONTINUE
         CALL ICOPY( NGRIDS, WORK( I ), 1, PVAL, 1 )
         I = I + NGRIDS
         CALL ICOPY( NGRIDS, WORK( I ), 1, QVAL, 1 )
         I = I + NGRIDS
         CALL ICOPY( NMAT, WORK( I ), 1, MVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, MAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, MBAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NBAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, RSRCAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, CSRCAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, IAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, JAVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, MXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, MBXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NBXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, RSRCXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, CSRCXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, IXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, JXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, INCXVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, MYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, MBYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, NBYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, RSRCYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, CSRCYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, IYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, JYVAL, 1 )
         I = I + NMAT
         CALL ICOPY( NMAT, WORK( I ), 1, INCYVAL, 1 )
         I = I + NMAT
*
         DO 110 J = 1, NSUBS
            IF( WORK( I ).EQ.1 ) THEN
               LTEST( J ) = .TRUE.
            ELSE
               LTEST( J ) = .FALSE.
            END IF
            I = I + 1
  110    CONTINUE
*
      END IF
*
      CALL BLACS_GRIDEXIT( ICTXT )
*
      RETURN
*
  120 WRITE( NOUT, FMT = 9997 )
      CLOSE( NIN )
      IF( NOUT.NE.6 .AND. NOUT.NE.0 )
     $   CLOSE( NOUT )
      CALL BLACS_ABORT( ICTXT, 1 )
*
      STOP
*
 9999 FORMAT( A )
 9998 FORMAT( ' Number of values of ',5A, ' is less than 1 or greater ',
     $        'than ', I2 )
 9997 FORMAT( ' Illegal input in file ',40A,'.  Aborting run.' )
 9996 FORMAT( A7, L2 )
 9995 FORMAT( '  Subprogram name ', A7, ' not recognized',
     $        /' ******* TESTS ABANDONED *******' )
 9994 FORMAT( 2X, 'Relative machine precision (eps) is taken to be ',
     $        E18.6 )
 9993 FORMAT( 2X, 'Number of Tests           : ', I6 )
 9992 FORMAT( 2X, 'Number of process grids   : ', I6 )
 9991 FORMAT( 2X, '                          : ', 5I6 )
 9990 FORMAT( 2X, A1, '                         : ', 5I6 )
 9988 FORMAT( 2X, 'Stop on failure flag      : ', L6 )
 9987 FORMAT( 2X, 'Test for error exits flag : ', L6 )
 9986 FORMAT( 2X, 'Verbosity level           : ', I6 )
 9985 FORMAT( 2X, 'Routines to be tested     :      ', A, A8 )
 9984 FORMAT( 2X, '                                 ', A, A8 )
 9983 FORMAT( 2X, 'Leading dimension gap     : ', I6 )
 9982 FORMAT( 2X, 'Alpha                     : ', G16.6 )
 9981 FORMAT( 2X, 'Beta                      : ', G16.6 )
 9980 FORMAT( 2X, 'Threshold value           : ', G16.6 )
*
*     End of PDBLA2TINFO
*
      END
      SUBROUTINE PDBLA2TCHKE( LTEST, INOUT, NPROCS )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      INTEGER            INOUT, NPROCS
*     ..
*     .. Array Arguments ..
      LOGICAL            LTEST( * )
*     ..
*
*  Purpose
*  =======
*
*  PDBLA2TCHKE tests the error exits of the Level 2 PBLAS.
*
*  Arguments
*  =========
*
*  LTEST    (global input) LOGICAL array, dimension (>= NSUBS = 7)
*           If LTEST( 1 ) is .TRUE., PDGEMV will be tested;
*           If LTEST( 2 ) is .TRUE., PDSYMV will be tested;
*           If LTEST( 3 ) is .TRUE., PDTRMV will be tested;
*           If LTEST( 4 ) is .TRUE., PDTRSV will be tested;
*           If LTEST( 5 ) is .TRUE., PDGER  will be tested;
*           If LTEST( 6 ) is .TRUE., PDSYR  will be tested;
*           If LTEST( 7 ) is .TRUE., PDSYR2 will be tested;
*
*  INOUT   (global input) INTEGER
*          The unit number for output file. INOUT = 6, ouput to screen,
*          INOUT = 0, output to stderr. Only defined for process 0.
*
*  NPROCS  (global input) INTEGER
*          The total number of processes calling this routine.
*
* ======================================================================
*
*  Calling sequence encodings
*  ==========================
*
*  code Formal argument list                                Examples
*
*  11   (n,      v1,v2)                                     _SWAP, _COPY
*  12   (n,s1,   v1   )                                     _SCAL, _SCAL
*  13   (n,s1,   v1,v2)                                     _AXPY, _DOT_
*  14   (n,s1,i1,v1   )                                     _AMAX
*  15   (n,u1,   v1   )                                     _ASUM, _NRM2
*
*  21   (     trans,     m,n,s1,m1,v1,s2,v2)                _GEMV
*  22   (uplo,             n,s1,m1,v1,s2,v2)                _SYMV, _HEMV
*  23   (uplo,trans,diag,  n,   m1,v1      )                _TRMV, _TRSV
*  24   (                m,n,s1,v1,v2,m1)                   _GER_
*  25   (uplo,             n,s1,v1,   m1)                   _SYR
*  26   (uplo,             n,u1,v1,   m1)                   _HER
*  27   (uplo,             n,s1,v1,v2,m1)                   _SYR2, _HER2
*
*  31   (          transa,transb,     m,n,k,s1,m1,m2,s2,m3) _GEMM
*  32   (side,uplo,                   m,n,  s1,m1,m2,s2,m3) _SYMM, _HEMM
*  33   (     uplo,trans,               n,k,s1,m1,   s2,m3) _SYRK
*  34   (     uplo,trans,               n,k,u1,m1,   u2,m3) _HERK
*  35   (     uplo,trans,               n,k,s1,m1,m2,s2,m3) _SYR2K
*  36   (     uplo,trans,               n,k,s1,m1,m2,u2,m3) _HER2K
*  37   (                             m,n,  s1,m1,   s2,m3) _TRAN_
*  38   (side,uplo,transa,       diag,m,n,  s1,m1,m2      ) _TRMM, _TRSM
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      INTEGER            NSUBS
      PARAMETER          ( NSUBS = 7 )
*     ..
*     .. Local Scalars ..
      LOGICAL            ABRTSAV
      INTEGER            I, ICTXT, MYCOL, MYROW, NPCOL, NPROW
*     ..
*     .. Local Arrays ..
      INTEGER            SCODE( NSUBS )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GET, BLACS_GRIDEXIT, BLACS_GRIDINFO,
     $                   BLACS_GRIDINIT, PDDIMEE, PDGEMV, PDGER,
     $                   PDMATEE, PDOPTEE, PDSYMV, PDSYR,
     $                   PDSYR2, PDTRMV, PDTRSV, PDVECEE
*     ..
*     .. Scalars in Common ..
      LOGICAL            ABRTFLG
      INTEGER            NOUT
*     ..
*     .. Arrays in Common ..
      CHARACTER*7        SNAMES( NSUBS )
*     ..
*     .. Common blocks ..
      COMMON /SNAMEC/SNAMES
      COMMON /PBERRORC/NOUT, ABRTFLG
*     ..
*     .. Data Statements ..
      DATA               SCODE/21, 22, 23, 23, 24, 25, 27/
*     ..
*     .. Executable Statements ..
*
*     Temporarily define blacs grid to include all processes so
*     information can be broadcast to all processes.
*
      CALL BLACS_GET( -1, 0, ICTXT )
      CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Set ABRTFLG to FALSE so that PBERROR won't abort on errors
*     during these tests and set the output device unit for PBERROR.
*
      ABRTSAV = ABRTFLG
      ABRTFLG = .FALSE.
      NOUT    = INOUT
*
*     Test PDGEMV
*
      I = 1
      IF( LTEST( I ) ) THEN
         CALL PDOPTEE( ICTXT, NOUT, PDGEMV, SCODE( I ), SNAMES( I ) )
         CALL PDDIMEE( ICTXT, NOUT, PDGEMV, SCODE( I ), SNAMES( I ) )
         CALL PDMATEE( ICTXT, NOUT, PDGEMV, SCODE( I ), SNAMES( I ) )
         CALL PDVECEE( ICTXT, NOUT, PDGEMV, SCODE( I ), SNAMES( I ) )
      END IF
*
*     Test PDSYMV
*
      I = I + 1
      IF( LTEST( I ) ) THEN
         CALL PDOPTEE( ICTXT, NOUT, PDSYMV, SCODE( I ), SNAMES( I ) )
         CALL PDDIMEE( ICTXT, NOUT, PDSYMV, SCODE( I ), SNAMES( I ) )
         CALL PDMATEE( ICTXT, NOUT, PDSYMV, SCODE( I ), SNAMES( I ) )
         CALL PDVECEE( ICTXT, NOUT, PDSYMV, SCODE( I ), SNAMES( I ) )
      END IF
*
*     Test PDTRMV
*
      I = I + 1
      IF( LTEST( I ) ) THEN
         CALL PDOPTEE( ICTXT, NOUT, PDTRMV, SCODE( I ), SNAMES( I ) )
         CALL PDDIMEE( ICTXT, NOUT, PDTRMV, SCODE( I ), SNAMES( I ) )
         CALL PDMATEE( ICTXT, NOUT, PDTRMV, SCODE( I ), SNAMES( I ) )
         CALL PDVECEE( ICTXT, NOUT, PDTRMV, SCODE( I ), SNAMES( I ) )
      END IF
*
*     Test PDTRSV
*
      I = I + 1
      IF( LTEST( I ) ) THEN
         CALL PDOPTEE( ICTXT, NOUT, PDTRSV, SCODE( I ), SNAMES( I ) )
         CALL PDDIMEE( ICTXT, NOUT, PDTRSV, SCODE( I ), SNAMES( I ) )
         CALL PDMATEE( ICTXT, NOUT, PDTRSV, SCODE( I ), SNAMES( I ) )
         CALL PDVECEE( ICTXT, NOUT, PDTRSV, SCODE( I ), SNAMES( I ) )
      END IF
*
*     Test PDGER
*
      I = I + 1
      IF( LTEST( I ) ) THEN
         CALL PDDIMEE( ICTXT, NOUT, PDGER, SCODE( I ), SNAMES( I ) )
         CALL PDVECEE( ICTXT, NOUT, PDGER, SCODE( I ), SNAMES( I ) )
         CALL PDMATEE( ICTXT, NOUT, PDGER, SCODE( I ), SNAMES( I ) )
      END IF
*
*     Test PDSYR
*
      I = I + 1
      IF( LTEST( I ) ) THEN
         CALL PDOPTEE( ICTXT, NOUT, PDSYR, SCODE( I ), SNAMES( I ) )
         CALL PDDIMEE( ICTXT, NOUT, PDSYR, SCODE( I ), SNAMES( I ) )
         CALL PDVECEE( ICTXT, NOUT, PDSYR, SCODE( I ), SNAMES( I ) )
         CALL PDMATEE( ICTXT, NOUT, PDSYR, SCODE( I ), SNAMES( I ) )
      END IF
*
*     Test PDSYR2
*
      I = I + 1
      IF( LTEST( I ) ) THEN
         CALL PDOPTEE( ICTXT, NOUT, PDSYR2, SCODE( I ), SNAMES( I ) )
         CALL PDDIMEE( ICTXT, NOUT, PDSYR2, SCODE( I ), SNAMES( I ) )
         CALL PDVECEE( ICTXT, NOUT, PDSYR2, SCODE( I ), SNAMES( I ) )
         CALL PDMATEE( ICTXT, NOUT, PDSYR2, SCODE( I ), SNAMES( I ) )
      END IF
*
      IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $   WRITE( NOUT, FMT = 9999 )
*
      CALL BLACS_GRIDEXIT( ICTXT )
*
*     Reset ABRTFLG to the value it had before calling this routine
*
      ABRTFLG = ABRTSAV
*
      RETURN
*
 9999 FORMAT( 2X, 'Error-exit tests completed.' )
*
*     End of PDBLA2TCHKE
*
      END
      SUBROUTINE PDCHKARG2( ICTXT, NOUT, SNAME, UPLO, TRANS, DIAG, M, N,
     $                      ALPHA, IA, JA, DESCA, IX, JX, DESCX, INCX,
     $                      BETA, IY, JY, DESCY, INCY, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar Arguments ..
      CHARACTER          DIAG, TRANS, UPLO
      INTEGER            IA, ICTXT, INCX, INCY, INFO, IX, IY, JA, JX,
     $                   JY, M, N, NOUT
      DOUBLE PRECISION   ALPHA, BETA
*     ..
*     .. Array Arguments ..
      CHARACTER*(*)      SNAME
      INTEGER            DESCA( * ), DESCX( * ), DESCY( * )
*     ..
*
*  Purpose
*  =======
*
*  PDCHKARG2 checks the input-only arguments of the level 2 PBLAS.
*  When INFO = 0, this routine makes a copy of its arguments (which are
*  INPUT only arguments to PBLAS routines). Otherwise, it verifies the
*  values of these arguments against the saved copies.
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  NOUT    (global input) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr. Only defined for process 0.
*
*  SNAME   (global input) CHARACTER*(*)
*          The subroutine name calling this subprogram.
*
*  UPLO    (global input) CHARACTER
*          The UPLO option in the Level 2 PBLAS routine.
*
*  TRANS   (global input) CHARACTER
*          The TRANS option in the Level 2 PBLAS routine.
*
*  DIAG    (global input) CHARACTER
*          The DIAG option in the Level 2 PBLAS routine.
*
*  M       (global input) INTEGER
*          The dimension of the distributed matrix and vector operands.
*
*  N       (global input) INTEGER
*          The dimension of the distributed matrix and vector operands.
*
*  ALPHA   (global input) DOUBLE PRECISION
*          The scalar ALPHA.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  IX      (global input) INTEGER
*          The row index in the global array X indicating the first
*          row of sub( X ).
*
*  JX      (global input) INTEGER
*          The column index in the global array X indicating the
*          first column of sub( X ).
*
*  DESCX   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix X.
*
*  INCX    (global input) INTEGER
*          The global increment for the elements of X. Only two values
*          of INCX are supported in this version, namely 1 and M_X.
*          INCX must not be zero.
*
*  BETA    (global input) DOUBLE PRECISION
*          The scalar BETA.
*
*  IY      (global input) INTEGER
*          The row index in the global array Y indicating the first
*          row of sub( Y ).
*
*  JY      (global input) INTEGER
*          The column index in the global array Y indicating the
*          first column of sub( Y ).
*
*  DESCY   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix Y.
*
*  INCY    (global input) INTEGER
*          The global increment for the elements of Y. Only two values
*          of INCY are supported in this version, namely 1 and M_Y.
*          INCY must not be zero.
*
*  INFO    (global input/global output) INTEGER
*          When INFO = 0 on entry, the values of the arguments (which
*          are INPUT only arguments to PBLAS routines) are copied into
*          static variables and INFO is unchanged on exit. Otherwise,
*          the values of the arguments are compared against the saved
*          copies. In case no error has been found INFO is zero on
*          return, otherwise it is non zero.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Local Scalars ..
      CHARACTER          DIAGREF, TRANSREF, UPLOREF
      INTEGER            I, IAREF, INCXREF, INCYREF, IXREF, IYREF,
     $                   JAREF, JXREF, JYREF, MREF, MYCOL, MYROW, NPCOL,
     $                   NPROW, NREF
      DOUBLE PRECISION   ALPHAREF, BETAREF
*     ..
*     .. Local Arrays ..
      CHARACTER*11       ARGNAME
      INTEGER            DESCAREF( DLEN_ ), DESCXREF( DLEN_ ),
     $                   DESCYREF( DLEN_ )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, IGSUM2D
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. Save Statement ..
      SAVE
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Check if first call. If yes, then save.
*
      IF( INFO.EQ.0 ) THEN
*
         DIAGREF = DIAG
         TRANSREF = TRANS
         UPLOREF = UPLO
         MREF = M
         NREF = N
         ALPHAREF = ALPHA
         IAREF = IA
         JAREF = IA
         DO 10 I = 1, DLEN_
            DESCAREF( I ) = DESCA( I )
   10    CONTINUE
         IXREF = IX
         JXREF = JX
         DO 20 I = 1, DLEN_
            DESCXREF( I ) = DESCX( I )
   20    CONTINUE
         INCXREF = INCX
         BETAREF = BETA
         IYREF = IY
         JYREF = JY
         DO 30 I = 1, DLEN_
            DESCYREF( I ) = DESCY( I )
   30    CONTINUE
         INCYREF = INCY
*
      ELSE
*
*        Test saved args. Return with first mismatch.
*
         ARGNAME = ' '
         IF( .NOT. LSAME( DIAG, DIAGREF ) ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'DIAG'
         ELSE IF( .NOT. LSAME( TRANS, TRANSREF ) ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'TRANS'
         ELSE IF( .NOT. LSAME( UPLO, UPLOREF ) ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'UPLO'
         ELSE IF( M.NE.MREF ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'M'
         ELSE IF( N.NE.NREF ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'N'
         ELSE IF( ALPHA.NE.ALPHAREF ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'ALPHA'
         ELSE IF( IA.NE.IAREF ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'IA'
         ELSE IF( JA.NE.JAREF ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'JA'
         ELSE IF( DESCA( DTYPE_ ).NE.DESCAREF( DTYPE_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'A', DTYPE_
         ELSE IF( DESCA( M_ ).NE.DESCAREF( M_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'A', M_
         ELSE IF( DESCA( N_ ).NE.DESCAREF( N_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'A', N_
         ELSE IF( DESCA( MB_ ).NE.DESCAREF( MB_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'A', MB_
         ELSE IF( DESCA( NB_ ).NE.DESCAREF( NB_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'A', NB_
         ELSE IF( DESCA( RSRC_ ).NE.DESCAREF( RSRC_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'A', RSRC_
         ELSE IF( DESCA( CSRC_ ).NE.DESCAREF( CSRC_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'A', CSRC_
         ELSE IF( DESCA( CTXT_ ).NE.DESCAREF( CTXT_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'A', CTXT_
         ELSE IF( DESCA( LLD_ ).NE.DESCAREF( LLD_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'A', LLD_
         ELSE IF( IX.NE.IXREF ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'IX'
         ELSE IF( JX.NE.JXREF ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'JX'
         ELSE IF( DESCX( DTYPE_ ).NE.DESCXREF( DTYPE_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'X', DTYPE_
         ELSE IF( DESCX( M_ ).NE.DESCXREF( M_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'X', M_
         ELSE IF( DESCX( N_ ).NE.DESCXREF( N_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'X', N_
         ELSE IF( DESCX( MB_ ).NE.DESCXREF( MB_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'X', MB_
         ELSE IF( DESCX( NB_ ).NE.DESCXREF( NB_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'X', NB_
         ELSE IF( DESCX( RSRC_ ).NE.DESCXREF( RSRC_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'X', RSRC_
         ELSE IF( DESCX( CSRC_ ).NE.DESCXREF( CSRC_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'X', CSRC_
         ELSE IF( DESCX( CTXT_ ).NE.DESCXREF( CTXT_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'X', CTXT_
         ELSE IF( DESCX( LLD_ ).NE.DESCXREF( LLD_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'X', LLD_
         ELSE IF( INCX.NE.INCXREF ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'INCX'
         ELSE IF( BETA.NE.BETAREF ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'BETA'
         ELSE IF( IY.NE.IYREF ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'IY'
         ELSE IF( JY.NE.JYREF ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'JY'
         ELSE IF( DESCY( DTYPE_ ).NE.DESCYREF( DTYPE_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'Y', DTYPE_
         ELSE IF( DESCY( M_ ).NE.DESCYREF( M_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'Y', M_
         ELSE IF( DESCY( N_ ).NE.DESCYREF( N_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'Y', N_
         ELSE IF( DESCY( MB_ ).NE.DESCYREF( MB_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'Y', MB_
         ELSE IF( DESCY( NB_ ).NE.DESCYREF( NB_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'Y', NB_
         ELSE IF( DESCY( RSRC_ ).NE.DESCYREF( RSRC_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'Y', RSRC_
         ELSE IF( DESCY( CSRC_ ).NE.DESCYREF( CSRC_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'Y', CSRC_
         ELSE IF( DESCY( CTXT_ ).NE.DESCYREF( CTXT_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'Y', CTXT_
         ELSE IF( DESCY( LLD_ ).NE.DESCYREF( LLD_ ) ) THEN
            WRITE( ARGNAME, FMT = 9997 ) 'Y', LLD_
         ELSE IF( INCY.NE.INCYREF ) THEN
            WRITE( ARGNAME, FMT = '(A)' ) 'INCY'
         ELSE
            INFO = 0
         END IF
*
         CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, INFO, 1, -1, 0 )
*
         IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 ) THEN
*
            IF( INFO.NE.0 ) THEN
               WRITE( NOUT, FMT = 9999 ) ARGNAME, SNAME
            ELSE
               WRITE( NOUT, FMT = 9998 ) SNAME
            END IF
*
         END IF
*
      END IF
*
      RETURN
*
 9999 FORMAT( 2X, '   ***** Input-only parameter check: ', A,
     $        ' FAILED  changed ', A, ' *****' )
 9998 FORMAT( 2X, '   ***** Input-only parameter check: ', A,
     $        ' PASSED  *****' )
 9997 FORMAT( 'DESC', A1, '( ', I2, ' )' )
*
*     End of PDCHKARG2
*
      END
      SUBROUTINE PDBLA2TCHK( ICTXT, NOUT, NROUT, UPLO, TRANS, DIAG, M,
     $                       N, ALPHA, A, PA, IA, JA, DESCA, X, PX, IX,
     $                       JX, DESCX, INCX, BETA, Y, PY, IY, JY,
     $                       DESCY, INCY, THRESH, ROGUE, WORK, INFO )
*
*  -- PBLAS test routine (version 1.5) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*     .. Scalar arguments ..
      CHARACTER          DIAG, TRANS, UPLO
      INTEGER            ICTXT, INCX, INCY, INFO, IA, IX, IY, JA, JX,
     $                   JY, M, N, NOUT, NROUT
      REAL THRESH
      DOUBLE PRECISION   ALPHA, BETA, ROGUE
*     ..
*     .. Array arguments ..
      INTEGER            DESCA( * ), DESCX( * ), DESCY( * )
      DOUBLE PRECISION   A( * ), PA( * ), PX( * ), PY( * ), WORK( * ),
     $                   X( * ), Y( * )
*     ..
*
*  Purpose
*  =======
*
*  PDBLA2TCHK performs the computational tests of the Level-2 PBLAS.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  ICTXT   (global input) INTEGER
*          The BLACS context handle, indicating the global context of
*          the operation. The context itself is global.
*
*  NOUT    (global input) INTEGER
*          The unit number for output file. NOUT = 6, ouput to screen,
*          NOUT = 0, output to stderr. Only defined for process 0.
*
*  NROUT   (global input) INTEGER
*          If NROUT = 1, PDGEMV will be tested;
*          else if NROUT = 2, PDSYMV will be tested;
*          else if NROUT = 3, PDTRMV will be tested;
*          else if NROUT = 4, PDTRSV will be tested;
*          else if NROUT = 5, PDGER  will be tested;
*          else if NROUT = 6, PDSYR  will be tested;
*          else if NROUT = 7, PDSYR2 will be tested;
*
*  UPLO    (global input) CHARACTER
*          UPLO specifies if the upper or lower part of the matrix
*          operand is to be referenced.
*
*  TRANS   (global input) CHARACTER
*          TRANS specifies if the matrix operand is to be transposed.
*
*  DIAG    (global input) CHARACTER
*          DIAG specifies if the triangular matrix operand is unit or
*          non-unit.
*
*  M       (global input) INTEGER
*          The number of rows of A.
*
*  N       (global input) INTEGER
*          The number of columns of A.
*
*  ALPHA   (global input) DOUBLE PRECISION
*          The scalar alpha.
*
*  A       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (DESCA( M_ ),*). This
*          array contains a local copy of the initial entire distribu-
*          ted matrix PA.
*
*  PA      (local input) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension (DESCA( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PA.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  X       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (DESCX( M_ ),*). This
*          array contains a local copy of the initial entire distribu-
*          ted matrix PX.
*
*  PX      (local input) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension (DESCX( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PX.
*
*  IX      (global input) INTEGER
*          The row index in the global array X indicating the first
*          row of sub( X ).
*
*  JX      (global input) INTEGER
*          The column index in the global array X indicating the
*          first column of sub( X ).
*
*  DESCX   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix X.
*
*  INCX    (global input) INTEGER
*          The global increment for the elements of X. Only two values
*          of INCX are supported in this version, namely 1 and M_X.
*          INCX must not be zero.
*
*  BETA    (global input) DOUBLE PRECISION
*          The scalar beta.
*
*  Y       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (DESCY( M_ ),*). This
*          array contains a local copy of the initial entire distribu-
*          ted matrix PY.
*
*  PY      (local input) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension (DESCY( LLD_ ),*). This array
*          contains the local pieces of the distributed matrix PY.
*
*  IY      (global input) INTEGER
*          The row index in the global array Y indicating the first
*          row of sub( Y ).
*
*  JY      (global input) INTEGER
*          The column index in the global array Y indicating the
*          first column of sub( Y ).
*
*  DESCY   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix Y.
*
*  INCY    (global input) INTEGER
*          The global increment for the elements of Y. Only two values
*          of INCY are supported in this version, namely 1 and M_Y.
*          INCY must not be zero.
*
*  THRESH  (global input) REAL
*          The threshold value for the test ratio.
*
*  ROGUE   (global input) DOUBLE PRECISION
*          The constant used to pad the non-referenced part of
*          triangular or symmetric matrices.
*
*  WORK    (workspace) DOUBLE PRECISION array of dimension LWORK.
*          LWORK >= MAX( M, N ). This array is used to store the
*          gauges (see PDMVCH).
*
*  INFO    (global output) INTEGER
*          On exit, if INFO = 0, no error has been found.
*          if( MOD( INFO, 2 ) = 1 ) an error on A has been found,
*          if( MOD( INFO/2, 2 ) = 1 ) an error on X has been found.
*          if( MOD( INFO/4, 2 ) = 1 ) an error on Y has been found.
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DTYPE_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     .. Local scalars ..
      INTEGER            I, MYCOL, MYROW, NPCOL, NPROW
      DOUBLE PRECISION   ERR
*     ..
*     .. Local Arrays ..
      INTEGER            IERR( 3 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, INFOG2L, PDCHKMIN, PDCHKVIN,
     $                   PDMVCH, DLASET, DTRSV, PDTRMV,
     $                   PDVMCH, PDVMCH2
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, MIN
*     ..
*     .. Executable Statements ..
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      INFO = 0
      DO 10 I = 1, 3
         IERR( I ) = 0
   10 CONTINUE
*
      IF( NROUT.EQ.1 ) THEN
*
*        Test PDGEMV
*
*        Check the resulting vector Y
*
         CALL PDMVCH( ICTXT, TRANS, M, N, ALPHA, A, IA, JA, DESCA, X,
     $                IX, JX, DESCX, INCX, BETA, Y, PY, IY, JY, DESCY,
     $                INCY, WORK, ERR, IERR( 3 ) )
*
         IF( IERR( 3 ).NE.0 ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9997 )
         ELSE IF( ERR.GT.DBLE( THRESH ) ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9996 ) ERR
         END IF
*
*        Check the input-only arguments
*
         CALL PDCHKMIN( ERR, M, N, A, PA, IA, JA, DESCA, IERR( 1 ) )
         IF( LSAME( TRANS, 'N' ) ) THEN
            CALL PDCHKVIN( ERR, N, X, PX, IX, JX, DESCX, INCX,
     $                     IERR( 2 ) )
         ELSE
            CALL PDCHKVIN( ERR, M, X, PX, IX, JX, DESCX, INCX,
     $                     IERR( 2 ) )
         END IF
*
      ELSE IF( NROUT.EQ.2 ) THEN
*
*        Test PDSYMV
*
*        Check the resulting vector Y
*
         CALL PDMVCH( ICTXT, 'No transpose', N, N, ALPHA, A, IA, JA,
     $                DESCA, X, IX, JX, DESCX, INCX, BETA, Y, PY, IY,
     $                JY, DESCY, INCY, WORK, ERR, IERR( 3 ) )
*
         IF( IERR( 3 ).NE.0 ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9997 )
         ELSE IF( ERR.GT.DBLE( THRESH ) ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9996 ) ERR
         END IF
*
*        Check the input-only arguments
*
         IF( LSAME( UPLO, 'L' ) ) THEN
            CALL DLASET( 'Upper', N-1, N-1, ROGUE, ROGUE,
     $                   A( IA+JA*DESCA( M_ ) ), DESCA( M_ ) )
         ELSE
            CALL DLASET( 'Lower', N-1, N-1, ROGUE, ROGUE,
     $                   A( IA+1+(JA-1)*DESCA( M_ ) ), DESCA( M_ ) )
         END IF
         CALL PDCHKMIN( ERR, N, N, A, PA, IA, JA, DESCA, IERR( 1 ) )
         CALL PDCHKVIN( ERR, N, X, PX, IX, JX, DESCX, INCX, IERR( 2 ) )
*
      ELSE IF( NROUT.EQ.3 ) THEN
*
*        Test PDTRMV
*
*        Check the resulting vector X
*
         CALL PDMVCH( ICTXT, TRANS, N, N, ONE, A, IA, JA, DESCA, Y, IX,
     $                JX, DESCX, INCX, ZERO, X, PX, IX, JX, DESCX, INCX,
     $                WORK, ERR, IERR( 2 ) )
*
         IF( IERR( 2 ).NE.0 ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9997 )
         ELSE IF( ERR.GT.DBLE( THRESH ) ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9996 ) ERR
         END IF
*
*        Check the input-only arguments
*
         IF( LSAME( UPLO, 'L' ) ) THEN
            IF( LSAME( DIAG, 'N' ) ) THEN
               CALL DLASET( 'Upper', N-1, N-1, ROGUE, ROGUE,
     $                      A( IA+JA*DESCA( M_ ) ), DESCA( M_ ) )
            ELSE
               CALL DLASET( 'Upper', N, N, ROGUE, ONE,
     $                      A( IA+(JA-1)*DESCA( M_ ) ), DESCA( M_ ) )
            END IF
         ELSE
            IF( LSAME( DIAG, 'N' ) ) THEN
               CALL DLASET( 'Lower', N-1, N-1, ROGUE, ROGUE,
     $                      A( IA+1+(JA-1)*DESCA( M_ ) ), DESCA( M_ ) )
            ELSE
               CALL DLASET( 'Lower', N, N, ROGUE, ONE,
     $                      A( IA+(JA-1)*DESCA( M_ ) ), DESCA( M_ ) )
            END IF
         END IF
         CALL PDCHKMIN( ERR, N, N, A, PA, IA, JA, DESCA, IERR( 1 ) )
*
      ELSE IF( NROUT.EQ.4 ) THEN
*
*        Test PDTRSV
*
*        Check the resulting vector X
*
         CALL DTRSV( UPLO, TRANS, DIAG, N, A( IA+(JA-1)*DESCA( M_ ) ),
     $               DESCA( M_ ), X( IX+(JX-1)*DESCX( M_ ) ), INCX )
         CALL PDTRMV( UPLO, TRANS, DIAG, N, PA, IA, JA, DESCA, PX, IX,
     $                JX, DESCX, INCX )
         CALL PDMVCH( ICTXT, TRANS, N, N, ONE, A, IA, JA, DESCA, X, IX,
     $                JX, DESCX, INCX, ZERO, Y, PX, IX, JX, DESCX, INCX,
     $                WORK, ERR, IERR( 2 ) )
*
         IF( IERR( 2 ).NE.0 ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9997 )
         ELSE IF( ERR.GT.DBLE( THRESH ) ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9996 ) ERR
         END IF
*
*        Check the input-only arguments
*
         IF( LSAME( UPLO, 'L' ) ) THEN
            IF( LSAME( DIAG, 'N' ) ) THEN
               CALL DLASET( 'Upper', N-1, N-1, ROGUE, ROGUE,
     $                      A( IA+JA*DESCA( M_ ) ), DESCA( M_ ) )
            ELSE
               CALL DLASET( 'Upper', N, N, ROGUE, ONE,
     $                      A( IA+(JA-1)*DESCA( M_ ) ), DESCA( M_ ) )
            END IF
         ELSE
            IF( LSAME( DIAG, 'N' ) ) THEN
               CALL DLASET( 'Lower', N-1, N-1, ROGUE, ROGUE,
     $                      A( IA+1+(JA-1)*DESCA( M_ ) ), DESCA( M_ ) )
            ELSE
               CALL DLASET( 'Lower', N, N, ROGUE, ONE,
     $                      A( IA+(JA-1)*DESCA( M_ ) ), DESCA( M_ ) )
            END IF
         END IF
         CALL PDCHKMIN( ERR, N, N, A, PA, IA, JA, DESCA, IERR( 1 ) )
*
      ELSE IF( NROUT.EQ.5 ) THEN
*
*        Test PDGER
*
*        Check the resulting matrix A
*
         CALL PDVMCH( ICTXT, 'Ge', M, N, ALPHA, X, IX, JX, DESCX, INCX,
     $                Y, IY, JY, DESCY, INCY, A, PA, IA, JA, DESCA,
     $                WORK, ERR, IERR( 1 ) )
         IF( IERR( 1 ).NE.0 ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9997 )
         ELSE IF( ERR.GT.DBLE( THRESH ) ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9996 ) ERR
         END IF
*
*        Check the input-only arguments
*
         CALL PDCHKVIN( ERR, M, X, PX, IX, JX, DESCX, INCX, IERR( 2 ) )
         CALL PDCHKVIN( ERR, N, Y, PY, IY, JY, DESCY, INCY, IERR( 3 ) )
*
      ELSE IF( NROUT.EQ.6 ) THEN
*
*        Test PDSYR
*
*        Check the resulting matrix A
*
         CALL PDVMCH( ICTXT, UPLO, N, N, ALPHA, X, IX, JX, DESCX, INCX,
     $                X, IX, JX, DESCX, INCX, A, PA, IA, JA, DESCA,
     $                WORK, ERR, IERR( 1 ) )
         IF( IERR( 1 ).NE.0 ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9997 )
         ELSE IF( ERR.GT.DBLE( THRESH ) ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9996 ) ERR
         END IF
*
*        Check the input-only arguments
*
         CALL PDCHKVIN( ERR, N, X, PX, IX, JX, DESCX, INCX, IERR( 2 ) )
*
      ELSE IF( NROUT.EQ.7 ) THEN
*
*        Test PDSYR2
*
*        Check the resulting matrix A
*
         CALL PDVMCH2( ICTXT, UPLO, N, N, ALPHA, X, IX, JX, DESCX, INCX,
     $                 Y, IY, JY, DESCY, INCY, A, PA, IA, JA, DESCA,
     $                 WORK, ERR, IERR( 1 ) )
         IF( IERR( 1 ).NE.0 ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9997 )
         ELSE IF( ERR.GT.DBLE( THRESH ) ) THEN
            IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $         WRITE( NOUT, FMT = 9996 ) ERR
         END IF
*
*        Check the input-only arguments
*
         CALL PDCHKVIN( ERR, N, X, PX, IX, JX, DESCX, INCX, IERR( 2 ) )
         CALL PDCHKVIN( ERR, N, Y, PY, IY, JY, DESCY, INCY, IERR( 3 ) )
*
      END IF
*
      IF( IERR( 1 ).NE.0 ) THEN
         INFO = INFO + 1
         IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $      WRITE( NOUT, FMT = 9999 ) 'A'
      END IF
*
      IF( IERR( 2 ).NE.0 ) THEN
         INFO = INFO + 2
         IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $      WRITE( NOUT, FMT = 9998 ) 'X'
      END IF
*
      IF( IERR( 3 ).NE.0 ) THEN
         INFO = INFO + 4
         IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 )
     $      WRITE( NOUT, FMT = 9998 ) 'Y'
      END IF
*
 9999 FORMAT( 2X, '   ***** ERROR: Matrix operand ', A,
     $        ' is incorrect.' )
 9998 FORMAT( 2X, '   ***** ERROR: Vector operand ', A,
     $        ' is incorrect.' )
 9997 FORMAT( 2X, '   ***** FATAL ERROR - Computed result is less ',
     $        'than half accurate *****' )
 9996 FORMAT( 2X, '   ***** Test completed with maximum test ratio: ',
     $        F11.5, ' SUSPECT *****' )
*
      RETURN
*
*     End of PDBLA2TCHK
*
      END
