      SUBROUTINE PBSDZERO( M, N, A, LDA, MINT, NINT, NEN )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     .. Scalar Arguments ..
      INTEGER            LDA, M, MINT, N, NINT, NEN
*     ..
*     .. Array Arguments ..
      REAL               A( LDA, * )
*     ..
*
*  Purpose
*  =======
*
*  PBSDZERO selects diagonal elements and makes them ZERO.
*
*  =====================================================================
*
*     .. Parameters ..
      REAL               ZERO
      PARAMETER          ( ZERO = 0.0E+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, J, JP, MN
*     ..
*     .. External Functions ..
      INTEGER            ICEIL
      EXTERNAL           ICEIL
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN
*     ..
*     .. Executable Statements ..
*
      JP = 0
      MN = M
*
      DO 20 I = 1, ICEIL( NEN, NINT )
         DO 10 J = 1, MIN( N, NEN-JP )
             A(MN+J,JP+J) = ZERO
   10    CONTINUE
*
         MN = MN + MINT
         JP = JP + NINT
   20 CONTINUE
*
      RETURN
*
*     End of PBSDZERO
*
      END
