/* $Id: f2p.c,v 1.1.1.1 1995/09/14 18:19:28 wak Exp $ */

#include <stdio.h>
#include <unistd.h>
#include <sys/wait.h>
#include <petit/definitions.h>
#include <petit/petit_args.h>
#include <petit/Exit.h>

void convert_to_petit()
    {
    if(petit_args.FileName)
        {
        int i;
        for (i=0; petit_args.FileName[i]; i++);

        if (i>=2&&petit_args.FileName[i-1]=='f'&&petit_args.FileName[i-2]=='.')
            {
            int pid;
            FILE *fd;
            printf("+ Translating %s to petit\n", petit_args.FileName);

            /* Check if .t file already exists */
            petit_args.FileName[i-1] = 't';
            if((fd=fopen(petit_args.FileName,"r"))!=NULL)
                {
                fclose(fd);
                fprintf(stderr,
                        "File %s already exists. "
                        "Do you want to overwrite it (y, [n]) ?", 
			petit_args.FileName);
                fflush(stderr);
                }
            petit_args.FileName[i-1] = 'f';

            pid=fork();
            Assert(pid>=0, "can not fork f2p");
            if (pid==0)
                {
                Assert(execlp("f2p", "f2p", petit_args.FileName, 
		       (char*)NULL) >= 0,
                       "Can not execute f2p");
                }
            else
                {
                int c, status;
                while((c=wait(&status))!=pid)
                    Assert(c!=-1, "wait f2p error");
                UserAssert(status==0,
                           "Translation to petit was not successful");
                }
            petit_args.FileName[i-1] = 't';
            }
        }
    } /* convert_to_petit */
