#include <basic/bool.h>
#include <omega.h>
#include <omega/Rel_map.h>
#include <code_gen/code_gen.h>
#include <basic/Collection.h>
#include <basic/Bag.h>
#include <basic/Map.h>
#include <basic/util.h>
#include <math.h>

#if ! defined DONT_EVEN_TRY_TO_COMPILE_CODE_GEN_WITH_CFRONT

static int last_level;// Should not be global, but it is.
static int OMEGA_WHINGE = -1;

SetTuple new_IS;
SetTupleTuple projected_nIS;
Tuple<naming_info *> statementNameInfo;

static void uncompress2(Relation &R)
    {
    R.uncompress();
    }

static CG_result * gen_recursive(int level, IntTuple &isActive);

// A utility functions for generating statements....
bool operator==(const naming_info &n1, const naming_info &n2) {
    assert(0);
    return false;
}

static
String outputEasyBound(Constraint_Handle &g, Variable_ID v, bool ignoreWC,
		       int ceiling, bool wrapInParens = false );

static
String outputSpaces(int indent_level) {
    String spaces;
    for(int i=1; i<indent_level; i++) spaces += "  ";
    return spaces;
}

String outputAsGuard(NOT_CONST Constraint_Handle &e, bool is_geq){
    String s;
    // pick any v in EQ, print in terms of it.
    Variable_ID v=0;
    for(Constr_Vars_Iter cvi(e,false); cvi; cvi++)
	if((*cvi).var->type() != Wildcard_Var) {
	    v = (*cvi).var;
	    break;
	}
    assert(v && "Must be some non-wildcards in the constraint");
    int saved_coef = ((e).get_coef(v));
    assert(saved_coef);

    // The coef of v should have the same sign as saved_coef, but its abs
    // should be 1 so that outputEasy doesn't divide through by its coef
    int sign = saved_coef < 0 ? -1 : 1;
    (e).update_coef_during_simplify(v,-saved_coef+sign);
    // outputEasyBound fixes coefficients for the sign of v's coefficient,
    // so we should use abs here.
    if(abs(saved_coef) != 1)
	s += itoS(abs(saved_coef)) + "*";
    s += v->name();
    if (is_geq) {
	if (saved_coef < 0)
	    s += " <= ";
	else
	    s += " >= ";
    } else {
	s += " == ";
    }
    s += outputEasyBound(e,v,false,0);
    (e).update_coef_during_simplify(v,saved_coef-sign);

    return s;
}

static
void get_stride(Constraint_Handle &h, Variable_ID &wc, int &step){
    wc = 0;
    for(Constr_Vars_Iter i(h,true); i; i++) {
	assert(wc == 0);
	wc = (*i).var;
	step = ((*i).coef);
    }
}


String outputStrideAsString(NOT_CONST EQ_Handle &e) {
    String s;
    Variable_ID wc;
    int step;
    get_stride(e,wc,step);
    assert(step != 0);
    int posstep = (step < 0) ? -step : step;
    e.update_coef_during_simplify(wc,1-step);
    s = String("intMod(") + outputEasyBound(e,wc,false,0) + "," + 
	       itoS(posstep) + ") == 0";
    e.update_coef_during_simplify(wc,step-1);
    return s;
}


String output_GEQ_strides(Relation &guards, Conjunct *c, bool &first) {
    String s;

// Collect wildcards
// For each whildcard
//   collect lower and upper bounds in which wildcard appears
//   For each lower bound
//     create constraint with each upper bound


    bool only_one;
    Tuple<Variable_ID> wcs;
    for(GEQ_Iterator g0(c); g0; g0++) {
	only_one = true;
	for(Constr_Vars_Iter cvi0(*g0,true); cvi0; cvi0++) {
	    assert(only_one && "Can't generate multiple wildcard GEQ guards");
	    if(!wcs.index((*cvi0).var)) wcs.append((*cvi0).var);
	    only_one = false;
	}
    }

    for(int i = 1; i <= wcs.length(); i++) {
	Variable_ID wc = wcs[i];
	Tuple<GEQ_Handle> lower, upper;
	for(GEQ_Iterator g(c); g; g++)
	    if((*g).get_coef(wc) > 0) 
		lower.append(*g); 
	    else 
		if((*g).get_coef(wc) < 0) 
		    upper.append(*g); 
//      low: c*alpha - x >= 0
//      up:  -d*alpha + y >= 0
	for(Tuple_Iterator<GEQ_Handle> low(lower); low; low++)
	    for(Tuple_Iterator<GEQ_Handle> up(upper); up; up++) {
		int low_coef = (*low).get_coef(wc);
		int up_coef = (*up).get_coef(wc);
		assert(low_coef > 0 && up_coef < 0);
		// low_expr <= low_coef * intDiv(up_expr,up_coef)
//		Relation new_low = Relation::True(guards);
//		GEQ_Handle new_low_geq = new_low.and_with_GEQ(*low);
//		new_low_geq.update_coef(wc, 1-low_coef);
//		new_low.simplify();
//		new_low_geq = 
//		 GEQ_Iterator(DNF_Iterator(new_low.query_DNF()).curr()).curr();

		(*low).update_coef_during_simplify(wc, 1-low_coef);
		String low_expr = 
		    outputEasyBound(*low,wc,false,0);
		(*low).update_coef_during_simplify(wc, low_coef-1);

//		Relation new_up = Relation::True(guards);
//		GEQ_Handle new_up_geq = new_up.and_with_GEQ(*low);
//		new_up_geq.update_coef(wc, 1-low_coef);
//		new_up.simplify();
//		new_up_geq = 
//		 GEQ_Iterator(DNF_Iterator(new_up.query_DNF()).curr()).curr();

// up_coef is negative, keep it that way
// low: low_coef*alpha >= low_expr
// up: -up_coef*alpha <= up_expr
		(*up).update_coef_during_simplify(wc, -1-up_coef);
		String up_expr = 
		    outputEasyBound(*up,wc,false,0);
		(*up).update_coef_during_simplify(wc, up_coef+1);

		if(!first) s += " && "; else s += "(";
		s +=low_expr + " <= " + itoS(low_coef) + " * " +
		    "intDiv(" + up_expr + "," + itoS(-up_coef) + ")";
		first = false;
	    }
    }
    return s;
}


#if 0
	    //  Get the stride
	    Variable_ID wc2;
	    get_stride(*g,wc2,step);
	    int sign = (step < 0? -1 : 1);
	    int the_const = (*g).get_const();
	    int mod_const = int_mod(the_const, sign*step);
            // Futz with things
	    (*g).update_const_during_simplify(-the_const);
	    (*g).update_coef_during_simplify(wc, 1-step);
	    if(!first) s += " && "; else s += "(";
	    s += "intDiv(" + outputEasyBound(*g,wc,true,0) +
		"," + itoS(sign*step) + ") >= " + itoS(mod_const);
	    (*g).update_const_during_simplify(the_const);
	    (*g).update_coef_during_simplify(wc, step-1);
#endif



// This returns a string containing the constraints in relation guards
// in a form suitable for C.  If there are no constraints in guards,
// nothing is returned.
String output_guard(Relation &guards_in) {
    Relation guards = guards_in;
    String s;
    bool first = true;
    assert(guards.has_single_conjunct());
    guards.setup_names();
    Conjunct *c = guards.single_conjunct();
    for(EQ_Iterator e(c); e; e++) {
	bool is_stride = (*e).has_wildcards();
	if (is_stride) {
	    if (!first) s += " && "; else s += "(";
	    s += outputStrideAsString(*e);
	    first = false;
	} else {
	    // This is a normal EQ, no stride
	    if (!first) s += " && "; else s += "(";
            //old way:	    s += (*e).print_to_string();
	    s += outputAsGuard(*e,false);
	    first = false;
	}
    }
    s += output_GEQ_strides(guards,c,first);
    for(GEQ_Iterator g(c); g; g++)
	if(!(*g).has_wildcards()) {
	    if(!first) s += " && "; else s += "(";
	    s += outputAsGuard(*g,true);
	    first = false;
	}
    if (!first) s += ")";
    return s;
}



#ifndef NDEBUG
#define PAINFULLY_EXPENSIVE_DEBUGGING 1
#endif

int code_gen_debug=0;
int code_gen_check_zero_trip=1;

void name_codegen_vars(Relation &R) {
    for(int i = 1; i <= R.n_set(); i ++)
	R.name_set_var(i,String("t")+itoS(i));
}



// Return true if there are no variables in g except wildcards & v
static 
bool isSimpleStride(const EQ_Handle &g, Variable_ID v){
    EQ_Handle gg = g;  // should not be necessary, but iterators are
    // a bit brain-dammaged
    bool is_simple=true;
    for(Constr_Vars_Iter cvi(gg, false); cvi && is_simple; cvi++)
	is_simple = ((*cvi).coef == 0 || (*cvi).var == v 
		     || (*cvi).var->type() == Wildcard_Var);
    return is_simple;
}


static 
int countStrides(Conjunct *c, Variable_ID v, EQ_Handle &strideEQ, 
		 bool &simple) {
    int strides=0;
    for(EQ_Iterator G(c); G; G++)
	for(Constr_Vars_Iter I(*G, true); I; I++)
	    if (((*I).coef != 0) && (*G).get_coef(v) != 0) {
		strides++;
		simple = isSimpleStride(*G,v);
		strideEQ = *G;
		break;
	    }
    return strides;
}


Relation project_onto_levels(Relation R, int last_level, bool wildcards) {

    assert(last_level >= 0 && R.is_set() && last_level <= R.n_set());
    if (last_level == R.n_set()) return R;

    int orig_vars = R.n_set();
    int num_projected = orig_vars - last_level;
    R = Extend_Set(R,num_projected);  // Project out vars numbered > last_level
    Mapping m1 = Mapping::Identity(R.n_set());  // now orig_vars+num_proj

    for(int i=last_level+1; i <= orig_vars; i++) {
	m1.set_map(Set_Var, i, Exists_Var, i);
	m1.set_map(Set_Var, i+num_projected, Set_Var, i);
    }

    MapRel1(R, m1, Comb_Id);
    R.finalize();
    R.simplify(1,2);
    if (!wildcards) 
        R = Approximate(R,1);
    assert(R.is_set());
    return R;
}

static Relation projectEliminatedVariables(Relation &R, Variable_ID_Tuple &elim) {
    if(elim.size() == 0) {
	if (code_gen_debug > 2)
	    fprintf(DebugFile, "::: projectEliminatedVariables: no vars eliminated\n");
	R.finalize();
	return R;
    }

    int i;
    for(i = 1; i <= elim.size(); i++)
	R = Project(R, elim[i]->get_position(), elim[i]->type());
    if(code_gen_debug > 2) {
	fprintf(DebugFile, "::: projectEliminatedVariables: variables eliminated: ");
	for(i = 1; i <= elim.size(); i++)
	    fprintf(DebugFile, "%s (%s %d)  ", elim[i]->char_name(), (elim[i]->type() == Input_Var? "input var" : "output var"), elim[i]->get_position());
	fprintf(DebugFile, "\n");
    }
    R.simplify(2,4);
    R.finalize();
    if (code_gen_debug > 2)
	R.prefix_print(DebugFile);
    return R;
}

// Check if the lower bound already enforces the stride by
// (Where m is coef of v in g and L is the bound on m*v):
// Check if m divides L evenly and Check if this l.bound on v implies strideEQ 



static 
bool boundHitsStride(GEQ_Handle &g, Variable_ID v, EQ_Handle &strideEQ,
		     int stride, Relation &known){
/* m = coef of v in g;
L = bound on v part of g;
*/ 
    // Check if m divides L evenly
    int m = g.get_coef(v);
    Relation test(known.n_set());
    F_Exists *e = test.add_exists();       // g is "L >= mv"
    Variable_ID alpha = e->declare();      // want: "l = m alpha"
    F_And *a = e->add_and();
    EQ_Handle h = a->add_EQ(); 
    for(Constr_Vars_Iter I(g,false); I; I++)
	if((*I).var != v) {
	    if((*I).var->type() != Global_Var)
		h.update_coef((*I).var, (*I).coef);
	    else
		h.update_coef(test.get_local((*I).var->get_global_var()), (*I).coef);
	}

    h.update_const(g.get_const());
    h.update_coef(alpha,m);                // set alpha's coef to m
    if (!(Gist(test,known).is_tautology()))      
	return false;
    // Check if this lower bound on v implies the strideEQ 
    Relation boundRel = known;    // want: "known and l = m v"
    boundRel.and_with_EQ(g);      // add in l = mv
    Relation strideRel(known.n_set());
    strideRel.and_with_EQ(strideEQ);
    return Gist(strideRel, boundRel).is_tautology();
}


/* Print the expression for the variable given as v.  Works for both 
   GEQ's and EQ's, but produces intDiv (not intMod) when v has a nonunit 
   coefficient.  So it is OK for loop bounds, but for checking stride
   constraints, you want to make sure the coef of v is 1, and insert the
   intMod yourself. */
static
String outputEasyBound(Constraint_Handle &g, Variable_ID v, bool ignoreWC,
		       int ceiling, bool wrapInParens )
{
    // assert ignoreWC => g is EQ

    /* rewrite constraint as foo (== or <= or >=) v, return foo as string */
    String s;
    bool first = true;
    int v_coef = g.get_coef(v);
    int v_sign = v_coef > 0 ? 1 : -1;
    v_coef *= v_sign;
    assert(v_coef > 0);
    /* foo is (-constraint)/v_sign/v_coef */
    /* foo is (-constraint*v_sign)/v_coef */
    int sign_adj = -v_sign;
    int terms = 0;

    if (v_coef != 1) s += "intDiv(";

    for(Constr_Vars_Iter c2(g,false); c2; c2++) {
        if ((*c2).var != v && (!ignoreWC || (*c2).var->type()!=Wildcard_Var)) {

	    int cf = (*c2).coef*sign_adj;
	    assert(cf != 0);
	    terms++;
	    if (cf > 1) {
		if (!first) s += "+";
		s += itoS( cf );
	    }
	    else if (cf == 1) {
		if (!first) s += "+";
	    }
	    else if (cf == -1) {
		s += "-";
	    }
	    else if (cf < -1) {
		s += "-";
		s += itoS( -cf );
	    }
	    if (cf != 1 && cf != -1) 
		s += "*";
	    s += (*c2).var->name();
	    first = false;
	}
    }
    if (g.get_const()) {
	int cf = g.get_const()*sign_adj;
        terms++;
	assert(cf != 0);
	if(first && cf > 0)
	    s += itoS(cf);
	else if(cf > 0)
	    s += "+" + itoS(cf);
	else 
	    s += "-" + itoS(-cf);
    }
    else
	if(first) s += "0";
    if (v_coef > 1) {
	assert(ceiling >= 0);
	if (ceiling) s += "+" + itoS(v_coef-1);
	s += "," + itoS(v_coef) + ")";
    }
    else if (wrapInParens && terms > 1) s = "(" + s + ")";

    if(code_gen_debug > 2) {
	fprintf(DebugFile,
		"::: generated bound of %s on %s\n",
		(const char *)s,v->char_name());

	if (!ignoreWC) 
	    for(Constr_Vars_Iter c3(g,true); c3; c3++) 
		fprintf(DebugFile,
			"::: found wildcard %d %s when generating bound %s on %s\n",
			(*c3).coef,
			(*c3).var->char_name(),
			(const char *) s,
			v->char_name());
    }
    return s;
}



// one is 1 for LB
String outputLBasString(const GEQ_Handle &g, Relation &bounds, Variable_ID v,
			int stride, const EQ_Handle &strideEQ, const Relation &known){
#if ! defined NDEBUG
    int v_coef;
    assert((v_coef = g.get_coef(v)) > 0);
#endif
    String s;
    if (stride == 1)
	s = outputEasyBound(g,v,false,1);
    else {
	if (!boundHitsStride(g,v,strideEQ,stride,known)) {
	    bounds.setup_names(); // boundsHitsStride resets variable names
	    String c = outputEasyBound(strideEQ, v, true, 0,true);
	    String LoverM = outputEasyBound(g, v, false, 1,false);           //   L/m
	    if (code_gen_debug > 2) {
		fprintf(DebugFile,"::: LoverM is %s\n",(const char *)LoverM);
		fprintf(DebugFile,"::: c is %s\n",(const char *)c);
	    };
	    if (c.length() < LoverM.length()) {
		s = itoS(stride) + "*intDiv(";                      // g * ceil((
		s += LoverM;           //   L/m
		if (c != "0") s += " - " + c; // - c)
		s +=  "+" + itoS(stride-1) + "," + itoS(stride) + ")";   // over g)
		if (c != "0") s +=  "+" + c;  // +c)
	    }
	    else {
		if (LoverM == "0") s = "intMod(" + c + "," +itoS(stride) + ")";
		else s = LoverM + "+intMod(" + c + "-" + LoverM + "," +itoS(stride) + ")";
	    }
	} else {
	    bounds.setup_names(); // boundsHitsStride resets variable names
	    s = outputEasyBound(g,v,false, 0);
	}
    }
    return s;
}


// one is -1 for UB
String outputUBasString(const GEQ_Handle &g, Relation &bounds, Variable_ID v,
			int stride, const EQ_Handle &strideEQ){
    assert(g.get_coef(v) < 0);
    String s = outputEasyBound(g,v,false,0);
    return s;
}


static 
bool outputAssignment(Conjunct *c, Variable_ID v, int indent,
		      String &s, Relation &new_known, Variable_ID_Tuple &eliminated) {

    EQ_Iterator I(c); 

    // Find first EQ that involves the interesting variable
    while(I.live() && (*I).get_coef(v) == 0) I++;

    if (!I.live()) {
	if (code_gen_debug > 2) 
	    fprintf(DebugFile, "::: outputAssignment: no EQs?\n");
	return false;  // No EQ's but also no UB or LB's on this var
    }

// If there is a simple substitution for this variable, (the
// variable's coefficient is +-1) we can remove it from the generated
// code.  In order to avoid seeing this variable in later loop bounds,
// we will project it away (at that time) and replace it with a
// variable that has no constraints on it.  Here we just mark it as
// eliminated.

    bool first = true;
    int divider = (*I).get_coef(v);
    int sign = 1;
    if (divider < 0) {
	divider = -divider;
	sign = -1;
    }
    assert(divider >= 1);
    if (divider == 1) {
	eliminated.append(v);
    } else {
	s += outputSpaces(indent) + v->name() + " = " + "intDiv(";
	for(Constr_Vars_Iter CVI(*I,false); CVI; CVI++)
	    if((*CVI).var != v) {
		assert((*CVI).var->type() != Wildcard_Var);
		if (-sign*(*CVI).coef == -1)
		    s += "-";
		else if (-sign*(*CVI).coef < -1)
		    s += "-" + itoS(sign*(*CVI).coef);
		else {
		    if (!first) s += "+";
		    if (-sign*(*CVI).coef != 1)
			s += itoS(-sign*(*CVI).coef);
		};
		first = false;
		s += (*CVI).var->name();
	    }
	int c_term = -((*I).get_const() * sign);
	if (c_term) {    // Not a zero
	    if (!first && c_term > 0) s += "+";
	    s += itoS(c_term);
	} else {
	    if (first)  // Must print the zero if no other terms
		s += itoS(c_term);
	}
	s += "+" + itoS(divider-1) + "," + itoS(divider) + ")" + "\n";
    }

    new_known.and_with_EQ(*I);
    // See if any more EQ's with this variable
    I++;
    while(I.live() && (*I).get_coef(v) == 0) I++;

    if ((code_gen_debug > 2) && I.live())
	fprintf(DebugFile, "::: outputAssignment: more than 1 EQ found\n");
    return (!I.live());  // return false if >1 EQ , true otherwise
}

static 
bool printBounds(Relation &b, Variable_ID v, int indent,
		 Relation &known, Relation &new_known, String &s,
		 Variable_ID_Tuple &eliminated) {


    if (code_gen_debug> 2) {
	fprintf(DebugFile,"::: printBounds generating bounds for\n");
	b.prefix_print(DebugFile);
    };
    name_codegen_vars(b);
    name_codegen_vars(known);
    b.setup_names();
    Conjunct *c = b.query_DNF()->single_conjunct();
    int lower_bounds=0, upper_bounds=0, coef;
    // Count bounds.
    for(GEQ_Iterator CI(c); CI; CI++) 
	if ((coef = (*CI).get_coef(v)) != 0) {  // In this constraint?
	    if(coef > 0) // lb or ub
		lower_bounds++;
	    else 
		upper_bounds++;
	    new_known.and_with_GEQ(*CI);    // add to result
	}
    new_known.finalize();
    if (upper_bounds == 0 || lower_bounds == 0) {
	if (code_gen_debug > 2) {
	    fprintf(DebugFile,"::: printBounds looking for EQ :\n");
	    b.prefix_print(DebugFile);
	}
	if (outputAssignment(c,v,indent,s,new_known,eliminated)) {
	    if (code_gen_debug > 2)
		fprintf(DebugFile,"::: printBounds   %s\n", (const char *) s);
	    return true;
	}
    }


    b.setup_names();
    String variable_name = v->name();
    // EQ not found, really a loop.
    s += outputSpaces(indent) + "for(" + variable_name + " = ";

    EQ_Handle strideEQ;
    int step=1, stride_const=0;
    bool simpleStride=true;
    int strides = countStrides(c,v,strideEQ,simpleStride);

    if (strides > 1) {
	if (code_gen_debug > 2) fprintf(DebugFile, "::: printBounds: Too many strides\n");
	return false;
    }
    if (strides == 1) {
	Constr_Vars_Iter it(strideEQ,true);
	assert(it.live());  // At least 1 wildcard
        int sign = strideEQ.get_coef(v) > 0 ? 1 : -1;
	step = (*it).coef * sign;
	stride_const = strideEQ.get_const() * -sign;
	assert(step > 1 || step < -1);
	if (step < 0) step = -step;
	it++;
	assert(!it.live()); //  > 1 wildcard in stride constraint
	new_known.and_with_EQ(strideEQ);
	new_known.finalize();
    }

    bool seenUB = false, seenLB = false;
    int const_ub = posInfinity, const_lb = negInfinity;

    b.setup_names();

    if (lower_bounds == 0) s += "-infinity";
    else {
	// Do lower bounds
	for (GEQ_Iterator g(c); g; g++) {
	    if ((*g).get_coef(v) == 0) continue;
	    if ((*g).get_coef(v) > 0) { // lower
		if ((*g).is_const(v) && !strides) { //no variables but v in constr
		    int L,m;
		    L = -((*g).get_const());
	
		    m = (*g).get_coef(v);
		    int sb  =  (int) (ceil(((float) L) /m));
		    set_max(const_lb, sb);
		}
		else if ((*g).is_const(v) && simpleStride) { //no variables but v in constr
		    //make LB fit the stride constraint
		    int L,m,s,c;
		    L = -((*g).get_const());
		    m = (*g).get_coef(v);
		    s = step;
		    c = stride_const;
		    int sb  =  (s * (int) (ceil( (float) (L - (c * m)) /(s*m))))+ c;
		    set_max(const_lb, sb);
		} else
		    if (!seenLB) {
			seenLB = true;
			if (lower_bounds > 1) s += "max(";
			s += outputLBasString(*g, b, v, step, strideEQ,known);
		    } else {
			s+=","+outputLBasString(*g, b, v, step, strideEQ,known);
		    }
	    }
	}
    }
    if (const_lb != negInfinity) {
	assert(step == 1 || simpleStride);
	if (seenLB)
	    s+= "," + itoS(const_lb);
	else
	    s += itoS(const_lb);
    }
    if (lower_bounds > 1) s += ")";
    s+= "; "  + variable_name + " <= ";

    if (upper_bounds == 0) s += "+infinity";
    // Do upper bounds 
    else for (GEQ_Iterator g(c); g; g++) {
	if ((*g).get_coef(v) == 0) continue;
	if ((*g).get_coef(v) < 0) { // upper
	    if ((*g).is_const(v))  { // no variables but v in constraint
		set_min(const_ub,-(*g).get_const()/(*g).get_coef(v));
	    } else
		if (!seenUB) {
		    seenUB = true;
		    if (upper_bounds >1) s += "min(";
		    s += outputUBasString(*g, b, v, step, strideEQ);
		} else {
		    s+= ","+ outputUBasString(*g, b, v, step, strideEQ);
		}
	}
    }
    if (const_ub != posInfinity) {  // some UB has only a constant
	if(seenUB)
	    s+= "," + itoS(const_ub);
	else
	    s += itoS(const_ub);
    } 
    if (upper_bounds > 1) s += ")";


    // Steps are never negative since we scan in lex. order.  The actual 
    // representation might have a negative coefficient, though.
    step = abs(step);
    if(step == 1)
	s += "; " + variable_name + "++) {\n"; // }
    else
	s += "; " + variable_name + " += " + itoS(abs(step)) + ") {\n"; // } 
//    if (step != 1) s += " step " + itoS(abs(step));
//     s+= " do\n";
    Relation k0,k1,k2;
    k1 = known;
    k2 = new_known;
    k0 = Intersection(k1,k2);
    if (code_gen_debug > 2) {
	fprintf(DebugFile,"::: Known from loop bounds:\n");
	k0.prefix_print(DebugFile);
    }
    b = Gist(b,k0,1);
    if (code_gen_debug > 2) {
	fprintf(DebugFile,"::: Constraints not yet expressed:\n");
	b.prefix_print(DebugFile);
    }
    return true;
}



inline bool isLB(GEQ_Handle &g, Variable_ID v) {
    return g.get_coef(v) > 0;
}

inline bool isUB(GEQ_Handle &g, Variable_ID v) {
    return g.get_coef(v) < 0;
}


/* This is dd_gcd from ddutil.c */
static
int wgcd( int a, int b )
{
    int g, r;
    int g0, g1;

    if( a == 0 ){
	g = abs(b);
    }else if( b == 0 ){
	g = abs(a);
    }else{
	g0 = abs(a);
	g1 = abs(b);
	r = g0 % g1;
	while( r != 0 ){
	    g0 = g1; g1 = r;
	    r = g0 % g1;
	}
	g = g1;
    }
    return g;
}/* wgcd */


/* These next two are stolen from Wayne's gencode.c, slightly modified */
static
int update_gcs(int gcs, EQ_Handle new_stride, EQ_Handle first) {
    int number_wildcards = 0;
    gcs = wgcd(gcs, abs(new_stride.get_const() - first.get_const()));
    for(Constr_Vars_Iter j(new_stride,false); j; j++)
	if ((*j).var->type() == Wildcard_Var)
	    {
		gcs=wgcd(gcs, abs((*j).coef));
		number_wildcards++;
	    }
	else
	    gcs=wgcd(gcs, abs((*j).coef - first.get_coef((*j).var)));
    assert(number_wildcards == 1);
    return gcs;
}

static
Relation greatest_common_step(SetTuple &I, IntTuple &active, Relation &known, int level,int vars, int nr_statements)
{

    int gcs = 0;

    EQ_Handle first;
    bool firstStride = true;

    for (int stmt=1; stmt<=nr_statements; stmt++)
        if (active[stmt])
	    {
		bool sawStride = false;
		Relation &orig = I[stmt];
		Variable_ID t_col = set_var(level);
            
		Conjunct *c = orig.single_conjunct();
		for (EQ_Iterator k = c->EQs(); k.live(); k.next())
		    {
			if (abs((*k).get_coef(t_col)) == 1)
			    {
				for (Variable_ID_Iterator j(*(c->variables())); 
				     j.live(); 
				     j.next())
				    {
					if ((*j)->type()==Wildcard_Var 
					    && (*k).get_coef(*j)!=0)
					    {
						if (code_gen_debug > 2)
						    {
							fprintf(DebugFile,
								"::: gcs found stride constraint, level %d, stmt %d, stride %d\n",
								level,stmt,(*k).get_coef(*j));
						    }
						sawStride = true;
// Here, get the gcs of this stride (*k)
						if(firstStride) {
						    first = *k;
						    firstStride=false;
						}
						gcs = update_gcs(gcs,*k,first);
						break;
					    }
				    }
			    }
		    }
		if(!sawStride) // There's no stride, so we can't enforce any at all
		    {
			if (code_gen_debug > 2)
			    fprintf(DebugFile,"::: gcs: stmt %d has no stride, using 1\n",stmt);
			return Relation::True(vars);
		    }
	    }

    if (firstStride)
	{
	    if (code_gen_debug > 2)
		fprintf(DebugFile,"::: gcs: no strides found for level %d\n",level);
	    return Relation::True(vars);
	}

    if (code_gen_debug > 2)
	fprintf(DebugFile, ":::   gcs == %d\n", gcs);

    if (gcs == 0) gcs = 1;

    Relation R0(vars); 
    F_And *a0 = R0.add_and();
    EQ_Handle new_eq = a0->add_stride(gcs);


    new_eq.update_const(first.get_const());
    for (Constr_Vars_Iter c(first, 0); c.live() ; c.next())
        {
	    switch (c.curr_var()->type()) 
		{
		case Input_Var:
		case Output_Var:
		    new_eq.update_coef((*c).var, c.curr_coef());
		    break;
		case Global_Var:
		    {
		    Global_Var_ID g = c.curr_var()->get_global_var();
		    new_eq.update_coef(R0.get_local(g), c.curr_coef());
		    break;
		    }
		case Wildcard_Var:
		    /* don't set */
		    break;
		default:
		    assert(0);
		}
	}
    R0.finalize();
    return R0;
} /* greatest_common_step */



static
String outputStatements(int stmt, int indent, Relation &mapping, 
			Relation &known) {

    String s = outputSpaces(indent);

    Relation Inv_mapping = Restrict_Domain(Inverse(copy(mapping)),copy(known));
    s += statementNameInfo[stmt]->name(&Inv_mapping);
    s += "\n";
    return s;
}


RelTuple transformations;

bool hasBound(Relation r, int level, int UB) {
    r.simplify();
    Variable_ID v = set_var(level);
    Conjunct *s_conj = r.single_conjunct();
    for(GEQ_Iterator G(s_conj); G; G++) {
	if (UB && (*G).get_coef(v) < 0) return 1;
	if (!UB && (*G).get_coef(v) > 0) return 1;
    };
    for(EQ_Iterator E(s_conj); E; E++) {
	if ((*E).get_coef(v)) return 1;
    }
    return 0;
}

Relation pickBound(Relation r, int level, int UB) {
    r.simplify();
    Variable_ID v = set_var(level);
    Conjunct *s_conj = r.single_conjunct();
    for(GEQ_Iterator G(s_conj); G; G++) {
	if ((UB && (*G).get_coef(v) < 0)
	    ||  (!UB && (*G).get_coef(v) > 0) ) {
	    Relation test_rel(r.n_set());
	    test_rel.and_with_GEQ(*G);
	    return test_rel;
	}
    };
    for(EQ_Iterator E(s_conj); E; E++) {
	if ((*E).get_coef(v)) {
	    Relation test_rel(r.n_set());
	    test_rel.and_with_GEQ(*E);
	    if ((UB && (*E).get_coef(v) > 0)
		||  (!UB && (*E).get_coef(v) < 0) ) 
		test_rel = Complement(test_rel);
	    return test_rel;
	}
    }
    assert(0);
    return r;
}

Relation pickOverhead(Relation r, int liftTo) {
    r.simplify();
    Conjunct *s_conj = r.single_conjunct();
    for(GEQ_Iterator G(s_conj); G; G++) {
	Relation test_rel(r.n_set());
	test_rel.and_with_GEQ(*G);
	Variable_ID v;
	int pos = -1;
	int c= 0;
	for(Constr_Vars_Iter cvi(*G, false); cvi; cvi++) 
	    if ((*cvi).coef && (*cvi).var->type() == Input_Var 
		&& (*cvi).var->get_position() > pos) {
		v = (*cvi).var;
		pos = (*cvi).var->get_position();
		c = (*cvi).coef;
	    }
#if 0
	fprintf(DebugFile,"Coef = %d, constraint = %s\n",
		c,(const char *)test_rel.print_formula_to_string());
#endif
	return test_rel;
    }
    for(EQ_Iterator E(s_conj); E; E++) {
	assert(liftTo >= 1);
	int pos = (*E).max_tuple_pos();
/* Pick stride constraints only when the variables with stride are outer
   loop variables */
	if ((*E).has_wildcards()  && pos < liftTo) {
	    Relation test_rel(r.n_set());
	    test_rel.and_with_EQ(*E);
	    return test_rel;
	}
	else 
	if (!(*E).has_wildcards()  && pos <= liftTo) {
	    Relation test_rel(r.n_set());
	    test_rel.and_with_EQ(*E);
	    test_rel.simplify();
	    test_rel = EQs_to_GEQs(test_rel,true);
	    return pickOverhead(test_rel,liftTo);
	}
    }
    if (code_gen_debug>1) {
	fprintf(DebugFile,"Could not find overhead:\n");
	r.prefix_print(DebugFile);
    }
    return Relation::True(r.n_set());
}

Relation minMaxOverhead(Relation r, int level) {
    r.finalize();
    r.simplify();
    Conjunct *s_conj = r.single_conjunct();
    GEQ_Handle LBs[50],UBs[50];
    int numLBs = 0;
    int numUBs = 0;
    Variable_ID v = set_var(level);
    for(GEQ_Iterator G(s_conj); G; G++) if ((*G).get_coef(v)) {
	GEQ_Handle g = *G;
	if (g.get_coef(v) > 0) LBs[numLBs++] = g;
	else UBs[numUBs++] = g;
    }
    if (numLBs <= 1 && numUBs <= 1) {
	return Relation::True(r.n_set());
    }
    Relation r1(r.n_set());
    Relation r2(r.n_set());
    if (numLBs > 1) {
	// remove a max in lower bound
	r1.and_with_GEQ(LBs[0]);
	r2.and_with_GEQ(LBs[1]);
	r1 = project_onto_levels(Difference(r1,r2),level-1,0);
    }
    else {
	// remove a min in upper bound
	r1.and_with_GEQ(UBs[0]);
	r2.and_with_GEQ(UBs[1]);
	r1 = project_onto_levels(Difference(r1,r2),level-1,0);
    }
#if 0
    fprintf(DebugFile,"Testing %s\n",(const char *)r1.print_formula_to_string());
    fprintf(DebugFile,"will removed overhead on bounds of t%d: %s\n",level,
	    (const char *)r.print_formula_to_string());
#endif
			

    return pickOverhead(r1, -1);
}



CG_split::CG_split(IntTuple &active, int lvl, Relation cond,
	     CG_result *T, CG_result *F) {
    assert(cond.has_single_conjunct());
    // If overhead is a GEQ, make it a LB on innermost loop var
    int c=0,pos=-1;  // initialize c to shut up the compiler
    GEQ_Iterator G(cond.single_conjunct());
    if (G) {
	for(Constr_Vars_Iter cvi(*G, false); cvi; cvi++) 
	    if ((*cvi).coef && (*cvi).var->type() == Input_Var 
		&& (*cvi).var->get_position() > pos) {
		pos = (*cvi).var->get_position();
		c = (*cvi).coef;
	    }
	// Evan had an assert pos > 0 here, but we can allow pos == 0
#ifndef NDEBUG
	if(pos > lvl+1) {
		fprintf(DebugFile,"Illegal split at lvl %d\n", lvl);
		cond.prefix_print(DebugFile);
		code_gen_debug = 1;
		// fprintf(DebugFile,"Then clause:\n%s\n", (const char *) T->print(5));
		// fprintf(DebugFile,"Else clause:\n%s\n", (const char *) F->print(5));
		}
	assert(pos == 0 || pos <= lvl+1);
#endif
	if (pos > 0 && c > 0) {
	    CG_result *foo = T;
	    T = F;
	    F = foo;
	    if (code_gen_debug) {
		    fprintf(DebugFile,"Reversing clause in new split node at lvl %d\n",lvl);
			cond.prefix_print(DebugFile);
		    }
	    cond = Complement(cond);
	     // Simplify is Temporary workaround to gist problem (2/15/95)
	    cond.simplify(); // if we don't do this, later we must do 
             	             // high redundant conjunct effort 
	    assert(cond.has_single_conjunct());
	}
    } else { 
	assert(EQ_Iterator(cond.single_conjunct())); // Has >= 1 EQ
    }
    isActive = active;
    condition = cond;
    condition.compress();
    level = lvl;
    trueClause = T;
    falseClause = F;
}

CG_result *CG_split::new_copy() {
	uncompress2(condition);
	Relation c = condition;
	condition.compress();
	return new CG_split(isActive,level,c,
			    trueClause->new_copy(),falseClause->new_copy());
}



String CG_split::printStructure(int indent) {
	    char buf[80];
	    sprintf(buf,"%p",(void *)this);
	    uncompress2(condition);
	    String result = outputSpaces(indent) 
		+ "// split at "
		+ buf
		+ "\n"
		+ outputSpaces(indent) 
		+"// if " + condition.print_formula_to_string()
		+ " then\n"
		+ trueClause->printStructure(indent+1)
		+ outputSpaces(indent) 
		+ "// else\n"
		+ falseClause->printStructure(indent+1);
            condition.compress();
	    return result;
}
String CG_split::print(int indent) {
	if (code_gen_debug) {
	    char buf[80];
	    sprintf(buf,"%p",(void *)this);
	    uncompress2(condition);
	    String result = outputSpaces(indent) 
		+ "// split at "
		+ buf
		+ "\n"
		+ outputSpaces(indent) 
		+"// if " + condition.print_formula_to_string()
		+ " then\n"
		+ trueClause->print(indent+1)
		+ outputSpaces(indent) 
		+ "// else\n"
		+ falseClause->print(indent+1);
            condition.compress();
	    return result;
	}
	else
	    return trueClause->print(indent)
		       + falseClause->print(indent);
}


CG_result * CG_split::liftOverhead(int depth) {
	assert(depth >= 1);
	trueClause = trueClause->liftOverhead(depth);
	falseClause = falseClause->liftOverhead(depth);
	return this;
}

CG_result * CG_split::force_finite_bounds() {
	trueClause = trueClause->force_finite_bounds();
	falseClause = falseClause->force_finite_bounds();
	return this;
}
Relation CG_split::findOverhead(int liftTo) {
	Relation r = trueClause->findOverhead(liftTo);
	if (r.is_tautology()) r = falseClause->findOverhead(liftTo);
	return r;
}

CG_result * CG_split::recompute(const Relation k, const Relation r,
				  Variable_ID_Tuple e)  { // CG_split recompute
	known = k;
	restrictions = r;
	eliminated = e;
	known.simplify();
	restrictions.simplify();
	Relation kr = Intersection(copy(known),copy(restrictions));
	restrictions.compress();
	known.compress();
	int numActive = 0;
	for(int s = 1; s<= isActive.size(); s++) if (isActive[s]) {
	    uncompress2(projected_nIS[level][s]);
	    Relation I = projected_nIS[level][s];
	    projected_nIS[level][s].compress();
	    if (!Intersection(copy(kr),I).is_satisfiable()) 
		isActive[s] = 0;
	    else numActive++;
	}
	if (numActive == 0) {
	    delete this;
	    return new CG_null;
	}
	else if (numActive == 1 && 0) {
	    // Need to rethink this -- can undo loop bounds
	    // overhead removal
	    CG_result * n = gen_recursive(level, isActive);
	    n = n->recompute(k,r,e);
	    delete this;
	    return n;
	}

	uncompress2(condition);
	Relation c = condition;
	if (code_gen_debug) {
		fprintf(DebugFile,"\nRecomputing split node %p\n",
			(void *)this);
		fprintf(DebugFile,"Known: %s\n",
			(const char *) copy(k).print_formula_to_string());
		fprintf(DebugFile,"restriction: %s\n",
			(const char *) copy(r).print_formula_to_string());
		fprintf(DebugFile,"split: %s\n",
			(const char *) c.print_formula_to_string());
		}
	condition.compress();
	trueClause = trueClause->recompute(k, Intersection(copy(r), copy(c)),e);
	falseClause = falseClause->recompute(k, Difference(copy(r), copy(c)),e);
	if (trueClause->isNull()) {
	    if (code_gen_debug) {
		uncompress2(condition);
		fprintf(DebugFile,"Pruning true branch of %p: %s\n",
			(void *) this,
			(const char *)condition.print_formula_to_string());
                condition.compress();
                uncompress2(known);
		fprintf(DebugFile,"Known: %s\n",
			(const char *) known.print_formula_to_string());
                known.compress();
                uncompress2(restrictions);
		fprintf(DebugFile,"restrictions: %s\n",
			(const char *) restrictions.print_formula_to_string());
                restrictions.compress();
		fprintf(DebugFile,"True branch: \n%s\n\n",
			(const char *)trueClause->print(2));
		fprintf(DebugFile,"False branch: \n%s\n\n",
			(const char *)falseClause->print(2));
	    };
	    CG_result * r = falseClause;
	    falseClause = 0;
	    delete this;
	    return r;
	};
	if (falseClause->isNull()) {
	    if (code_gen_debug) {
		uncompress2(condition);
		fprintf(DebugFile,"Pruning false branch of %p: %s\n",
			(void *) this,
			(const char *)condition.print_formula_to_string());
                condition.compress();
                uncompress2(known);
		fprintf(DebugFile,"Known: %s\n",
			(const char *) known.print_formula_to_string());
                known.compress();
                uncompress2(restrictions);
		fprintf(DebugFile,"restrictions: %s\n",
			(const char *) restrictions.print_formula_to_string());
                restrictions.compress();
		fprintf(DebugFile,"True branch: \n%s\n\n",
			(const char *)trueClause->print(2));
		fprintf(DebugFile,"False branch: \n%s\n\n",
			(const char *)falseClause->print(2));
	    }
	    CG_result * r = trueClause;
	    trueClause = 0;
	    delete this;
	    return r;
	};
	return this;
}

// CG_leaf implementation

Relation CG_leaf::findOverhead(int liftTo) {
	for(int s=1; s<=isActive.size(); s++) if (isActive[s]) {
	    uncompress2(guard[s]);
	    int bb = !guard[s].is_tautology();
	    if (bb) {
		if (code_gen_debug)
		    fprintf(DebugFile,"Trying to remove overhead on guard of statement s%d: %s\n",
			    s,(const char *) guard[s].print_formula_to_string());
		Relation r =  pickOverhead(guard[s], liftTo);
	        guard[s].compress();
		if (!r.is_tautology()) return r;
	    }
	guard[s].compress();
        }
	return Relation::True(known.n_set());
}


String CG_leaf::printStructure(int indent) {
	String result;
	for(int s=1; s<=isActive.size(); s++) if (isActive[s]) {
		char  buf[80];
		sprintf(buf,"s%d ",s);
		result += buf;
		}
	return result+"\n";
}




String CG_leaf::print(int indent) {
	String result;
        uncompress2(known);
	if (code_gen_debug>1) result +=
				  outputSpaces(indent) 
				  + "// known: " 
				  + known.print_formula_to_string()
				  + "\n";
	for(int s=1; s<=isActive.size(); s++) if (isActive[s]) {
	    uncompress2(guard[s]);
	    if (guard[s].is_tautology())
		{
		uncompress2(transformations[s]);
		result += outputStatements(s,indent,
					   transformations[s],
					   known);
                transformations[s].compress();
		}
	    else {
                uncompress2(restrictions);
		if (code_gen_debug>1) result +=
					  outputSpaces(indent) 
					  + "// restrictions: " 
					  + restrictions.print_formula_to_string()
					  + "\n";
                restrictions.compress();
		result +=
		    outputSpaces(indent) 
		    + "if " 
		    + output_guard(guard[s])
		    + " {\n";
		Relation g = Intersection(copy(guard[s]),
					  copy(known));
                uncompress2(transformations[s]);
		result += outputStatements(s,indent+1,
					   transformations[s],
					   g);
                transformations[s].compress();
		result +=  outputSpaces(indent)
		    + "}\n";
	    }
        guard[s].compress();
	}
        known.compress();
	return result;
}







CG_result * CG_leaf::recompute(const Relation k, const Relation r,
				  Variable_ID_Tuple e)  {
	known = k;
	restrictions = r;
	eliminated = e;
	known.simplify();
	known.compress();
	restrictions.simplify();
        restrictions.compress();
	Relation kr = Intersection(copy(k),copy(r));
	guard.reallocate(isActive.size());
        if (code_gen_debug > 1) {
		fprintf(DebugFile,"Recomputing leaf node %p\n", (void *) this);
		fprintf(DebugFile,"Known: %s\n",
			(const char *) copy(k).print_formula_to_string());
		fprintf(DebugFile,"restrictions: %s\n",
			(const char *) copy(r).print_formula_to_string());
		}
	int count = 0;
	for(int s=1; s<=isActive.size(); s++) if (isActive[s]) {
	    uncompress2(new_IS[s]);
	    if (code_gen_debug > 1) {
			fprintf(DebugFile,"s%d I: %s\n", s,
				(const char *) copy(new_IS[s]).print_formula_to_string());
			};
	    Relation I = 
		Intersection(copy(new_IS[s]),
			     copy(kr));
            new_IS[s].compress();
	    if (!I.is_satisfiable()) isActive[s] = 0;
	    else {
		count++;
		assert(!I.is_null());
		if (code_gen_debug > 1) {
			fprintf(DebugFile,"s%d Ikr: %s\n", s,
				(const char *) copy(I).print_formula_to_string());
			};
		guard[s] = Gist(
		    projectEliminatedVariables(I,eliminated),
		    projectEliminatedVariables(copy(k),eliminated),
		    1);
		name_codegen_vars(guard[s]);
		if (code_gen_debug > 1) {
			fprintf(DebugFile,"s%d g: %s\n", s,
				(const char *) copy(guard[s]).print_formula_to_string());
			};
		guard[s].compress();
	    }
	}
	if (count == 0) {
	    if (code_gen_debug) {
		fprintf(DebugFile,"Pruning leaf node %p\n", (void *) this);
		uncompress2(known);
		fprintf(DebugFile,"Known: %s\n",
			(const char *) known.print_formula_to_string());
                known.compress();
                uncompress2(restrictions);
		fprintf(DebugFile,"restrictions: %s\n",
			(const char *) restrictions.print_formula_to_string());
                restrictions.compress();
	    };
	    delete this;
	    return new CG_null();
	}
	return this;
}

// CG_loop implementation




Relation CG_loop::findOverhead(int liftTo) {
// If a loop is nec., search for both guard and min/max overheads, otherwise
// skip those step
    if (needLoop) {
	uncompress2(guard);
	int bb = !guard.is_tautology();
	guard.compress();
	if (bb) {
	    uncompress2(guard);
#if 0
	    fprintf(DebugFile,"Trying to remove overhead on guard of loop %x at level %d: %s\n",
		    (void *) this, level, (const char *) guard.print_formula_to_string());
#endif
	    Relation r = pickOverhead(guard, liftTo);
	    guard.compress();
	    if (!r.is_tautology()) return r;
	}
	uncompress2(bounds);
	Relation b = bounds;
	bounds.compress();
	Relation r = minMaxOverhead(b,level);
	if (!r.is_tautology()) {
	    uncompress2(guard);
#if 0
	    fprintf(DebugFile,"Trying to remove minMax overhead on guard of loop %x at level %d: %s\n",
		    (void *) this, level, (const char *) guard.print_formula_to_string());
	    guard.compress();
#endif
	    return r;
	}
    } // if (needLoop)...
	Relation r = body->findOverhead(liftTo);
	if (r.is_tautology()) return r;

// If there's a loop at this level, the overhead returned may use the
// current loop variable we need to take it out.  If there is NO loop
// here, then we eliminated this var before recomputing subtree, so we
// don't need to.  More importantly, it can gist away the overhead
// since we didn't output the guard we really should
// have. (i.e. bounds are stricter since they weren't gisted according
// to the guard we normally output, and so would gist away the
// overhead)

   
     // fprintf(DebugFile,"Lifting out guard past level %x at level %d: %s\n",
		    // (void *) this, level, (const char *) r.print_formula_to_string());
      //fprintf(DebugFile,"Bounds are: %s\n",(const char *)bounds.print_formula_to_string());
    uncompress2(bounds);
    r = Intersection(r, copy(bounds));
      //fprintf(DebugFile,"Intersection: %s\n",(const char *)r.print_formula_to_string());
    r = project_onto_levels(r,level,0);
      //fprintf(DebugFile,"projected: %s\n",(const char *)r.print_formula_to_string());
    r = Gist(r,copy(bounds),1);
    bounds.compress();
    //fprintf(DebugFile,"Got %s\n",
		 //(const char *) r.print_formula_to_string());
    return r;
}


CG_result * CG_loop::force_finite_bounds() {
	uncompress2(bounds);
	if (!needLoop || hasBound(bounds,level,0) && hasBound(bounds,level,1)) {
	    body = body->force_finite_bounds();
	    bounds.compress();
	    return this;
	} else
	    bounds.compress();
#if 0
	fprintf(DebugFile,"Don't have finite bounds in:\n%s\n\n",
		(const char *) this->print(2));
#endif
	uncompress2(bounds);
	int bb = !hasBound(bounds,level,0);
	bounds.compress();
	if (bb) {
	    for(int s = 1; s <= isActive.size(); s++) if (isActive[s]) {
		uncompress2(projected_nIS[level][s]);
		Relation I = projected_nIS[level][s];
		projected_nIS[level][s].compress();
		if (hasBound(I,level,0)) {
		    Relation S = pickOverhead(
			pickBound(I,level,0),level);
		    assert(OMEGA_WHINGE >= 0);
		    if (S.is_tautology()) {
			if (!OMEGA_WHINGE) continue;
			fprintf(DebugFile,"hasBound(%s,%d,0) said true, but overhead was tautology\n",(const char *)I.print_formula_to_string(),level);
			assert(0);
			}

		    if (code_gen_debug) 
		      fprintf(DebugFile,"Spliting on %s\n",
			    (const char *) S.print_formula_to_string());
		    CG_result *s = 
			new CG_split(isActive,level,S,this,this->new_copy());
		    uncompress2(restrictions);
		    uncompress2(known);
		    Relation restrictions_copy = restrictions,
			known_copy = known;
		    restrictions.compress();
		    known.compress();
		    s = s->recompute(known_copy,restrictions_copy,eliminated);
#if 0
		    if (code_gen_debug) 
		    fprintf(DebugFile,"Split on to create finite bounds:\n%s\n\n",
			    (const char *) s->print(2));
#endif
		    return s->force_finite_bounds();
		}
	    }
	}
	else {
		uncompress2(bounds);
		assert(!hasBound(bounds,level,1));
		bounds.compress();
		    for(int s = 1; s <= isActive.size(); s++) if (isActive[s]) {
			   uncompress2(projected_nIS[level][s]);
			   Relation I = projected_nIS[level][s];
			   projected_nIS[level][s].compress();
			   if (hasBound(I,level,1)) {
			       Relation S = pickOverhead(pickBound(I,level,1),level);
			    if (code_gen_debug) 
			       fprintf(DebugFile,"Spliting on %s\n",
				       (const char *) S.print_formula_to_string());
			       CG_result *s = 
				   new CG_split(isActive,level, S,this,this->new_copy());
		               uncompress2(restrictions);
			       uncompress2(known);
			       Relation restrictions_copy = restrictions,
				   known_copy = known;
		               restrictions.compress();
			       known.compress();
			       s = s->recompute(known_copy,restrictions_copy,eliminated);
#if 0
			       fprintf(DebugFile,"Split to create finite bounds:\n%s\n\n",
				       (const char *) s->print(2));
#endif
			       return s->force_finite_bounds();
			   }
		       }
	   }
	return this;
}


CG_result * CG_loop::liftOverhead(int depth) {
	assert(depth >= 1);
	if (needLoop) depth --;
	if (depth) {
	    body = body->liftOverhead(depth);
	    return this;
	}
	assert(needLoop);
	Relation c = body->findOverhead(level);
	if (c.is_tautology()) return this;
	assert(c.is_satisfiable());
	String before;
	if (code_gen_debug) {
	    fprintf(DebugFile,"Decided to lift out overhead of %s\n",
		    (const char *) c.print_formula_to_string());
	    before = print(1);
	    fprintf(DebugFile,"from: \n%s\n", (const char *)before);
	}
	CG_result *s = new CG_split(isActive,level,c,this,this->new_copy());
	uncompress2(restrictions);
	uncompress2(known);
	Relation restrictions_copy = restrictions,
	    known_copy = known;
	restrictions.compress();
	known.compress();
	s = s->recompute(known_copy,restrictions_copy,eliminated);
	if (code_gen_debug) {
	    String after = s->print(1);
	    fprintf(DebugFile,"Lifted out overhead of %s\n",
		    (const char *) c.print_formula_to_string());
	    fprintf(DebugFile,"from:\n%s\n",(const char *)before);
	    fprintf(DebugFile,"to get:\n%s\n",(const char *)after);
	}
	s = s->liftOverhead(depth+1);
	return s;
}


String CG_loop::printStructure(int indent) { // CG_loop print method
	String S = "";
	int indnt = indent;
	    char buf[80];
	    sprintf(buf,"%p",(void *)this);
	    S += outputSpaces(indent) 
		+ "// loop for t" + itoS(level) + " at "
		+ buf
		+ "\n";
	    if (eliminated.size()) {
	      S += outputSpaces(indent) + "// eliminated: ";
	      int t;
	      for(t=1;t<=eliminated.size();t++)
		S += itoS(eliminated[t]->get_position()) + " ";
	      S += "\n";
	      }
	    // Print each statement's bounds in debugging info
		for(int s = 1; s<= isActive.size(); s++) if (isActive[s]) {
		   projected_nIS[level][s].uncompress();
		    S += outputSpaces(indent)
			+ "// "
			+ statementNameInfo[s]->debug_name()
			+ ":" + projected_nIS[level][s].print_formula_to_string()
			+ "\n";
		   projected_nIS[level][s].compress();
		}

	return S + body->printStructure(indnt+1) + outputSpaces(indnt+1)+ "}\n";
	} 





String CG_loop::print(int indent) { // CG_loop print method
	String S = "";
	int indnt = indent;
	int guarded = 0;
	if (code_gen_debug) {
	    char buf[80];
	    sprintf(buf,"%p",(void *)this);
	    S += outputSpaces(indent) 
		+ "// loop for t" + itoS(level) + " at "
		+ buf
		+ "\n";
            uncompress2(known);
	    S += outputSpaces(indent) 
		+ "// known: "
		+ known.print_formula_to_string()
		+ "\n";
	    known.compress();
            uncompress2(restrictions);
	    S += outputSpaces(indent) 
		+ "// restrictions: "
		+ restrictions.print_formula_to_string()
		+ "\n";
	    restrictions.compress();
	    if (eliminated.size()) {
	      S += outputSpaces(indent) + "// eliminated: ";
	      int t;
	      for(t=1;t<=eliminated.size();t++)
		S += itoS(eliminated[t]->get_position()) + " ";
	      S += "\n";
	      }
	    S += outputSpaces(indent) + "// active: ";
	    for(int s = 1; s <= isActive.size(); s++) 
		if (isActive[s])
		    S += itoS(s)+ " ";
	    S += "\n";
            uncompress2(bounds);
	    S += outputSpaces(indent) 
		+ "// bounds: "
		+ bounds.print_formula_to_string()
		+ "\n";
            bounds.compress();
	    uncompress2(guard);
	    S += outputSpaces(indent) 
		+ "// guard: "
		 + guard.print_formula_to_string()
		+ "\n";
            guard.compress();
	    // Print each statement's bounds in debugging info
	    uncompress2(bounds);
            int cc = !hasBound(bounds,level,0) || !hasBound(bounds,level,1);
	    bounds.compress();
            if (cc) {
		int s;
		for(s = 1; s<= isActive.size(); s++) if (isActive[s]) {
		    uncompress2(projected_nIS[level][s]);
		    uncompress2(restrictions);
		    uncompress2(known);
		    assert(Intersection(Intersection(copy(restrictions),copy(known)),copy(projected_nIS[level][s])).is_satisfiable());
		    known.compress();
		    S += outputSpaces(indent)
			+ "// "
			+ statementNameInfo[s]->debug_name()
			+ ":" + projected_nIS[level][s].print_formula_to_string()
			+ "\n";
		   projected_nIS[level][s].compress();
		   restrictions.compress();
		    };
		// Print hull in debugging info
		for(s = 1; s<= isActive.size(); s++) if (isActive[s])
		   uncompress2(projected_nIS[level][s]);
		Relation hull(Hull(projected_nIS[level],isActive,1));
		for(s = 1; s<= isActive.size(); s++) if (isActive[s])
		   projected_nIS[level][s].compress();
	        S += outputSpaces(indent)
			+ "// hull: "
			+ hull.print_formula_to_string()
			+ "\n";
		}

	} // if (code_gen_debug)
	// Generate guard if necessary
	// If code_gen_check_zero_trip is set, use the guard as is; otherwise,
	// omit the parts of the guard that check if this is zero-trip loop
	Relation current_guard;
	if (! code_gen_check_zero_trip)
	    {
	    uncompress2(guard);
	    current_guard = guard;
            guard.compress();
	    }
	else {
	    // gist guard given the zero trip check
	    uncompress2(bounds);
	    uncompress2(guard);
	    Relation zero_trip_check = Project(Gist(copy(bounds),copy(guard)),
					       level, set_var(level)->type());
            bounds.compress();
	    guard.compress();
	    uncompress2(guard);
	    current_guard = Gist(copy(guard),zero_trip_check);
	    guard.compress();
            }

	if (! current_guard.is_tautology()) {
	    guarded = 1;
	    S += 
		outputSpaces(indent)
		+ "if " + output_guard(current_guard)
		+ " {\n";	    
	    indnt++;
	}
	Variable_ID v = set_var(level);       // get ID of current loop var
	Variable_ID_Tuple elim = eliminated;

	uncompress2(known);
	Relation enforced(known);
          // b: actual bounds are gisted given info in guards
        uncompress2(bounds);
	Relation b = Gist(copy(bounds),copy(current_guard),1); 
	bounds.compress();
	name_codegen_vars(b);
	bool r =
	    printBounds(b,v,indnt,
			copy(known),enforced,S,elim);
	known.compress();
        // Below should never happen: says the current variable v generates an
        // assignment rather than a loop, but we thought we needed a loop
	if (needLoop && elim.size() != eliminated.size()) r = 0; 
	if (!r) {
	    fprintf(DebugFile,"Code generation failure\n");
	    fprintf(DebugFile,"Loop %p at lvl %d\n",
		    (void *) this,
		    level);
	    if (!r) fprintf(DebugFile,"printBounds failed\n");
	    fprintf(DebugFile,"bounds:\n");
	    uncompress2(bounds);
	    bounds.prefix_print(DebugFile);
	    bounds.compress();
	    fprintf(DebugFile,"known:\n");
	    uncompress2(known);
	    known.prefix_print(DebugFile);
	    known.compress();
	    fprintf(DebugFile,"restrictions:\n");
	    uncompress2(restrictions);
	    restrictions.prefix_print(DebugFile);
	    restrictions.compress();
	    fprintf(DebugFile,"active:");
	    int s;
	    for(s = 1; s <= isActive.size(); s++) 
		if (isActive[s])
		    fprintf(DebugFile,"%d ",s);
	    fprintf(DebugFile,"\n");
	    SetTuple I(isActive.size());
	    for(s = 1; s<= isActive.size(); s++) if (isActive[s]) {
		uncompress2(projected_nIS[level][s]);
	    }
	    Relation hull = 
		Intersection(Hull(projected_nIS[level],isActive,1),
			     greatest_common_step(projected_nIS[level], 
					  isActive, 
					  Relation::True(restrictions.n_set()),
				          level,last_level, isActive.size()));
	    for(s = 1; s<= isActive.size(); s++) if (isActive[s]) {
		projected_nIS[level][s].compress();
	    }
	    fprintf(DebugFile,"new hull:\n");
	    hull.prefix_print(DebugFile);
	    assert(0);
	} // if (!r)... (failure)
	if (!needLoop) {
	    S += body->print(indnt);
	}
	else S += body->print(indnt+1) + outputSpaces(indnt+1)+ "}\n";
	if (guarded) S +=  outputSpaces(indent)
			 + "}\n";
	return S;
}


CG_result * CG_loop::recompute(const Relation k, const Relation r,
				  Variable_ID_Tuple e)  { // CG_loop recompute
// We generate a guard (and change known) only when a real loop is generated.
	known = k;
	restrictions = r;
	eliminated = e;
	known.simplify();
	restrictions.simplify();
	Relation kr = Intersection(copy(known),
				   copy(restrictions));
	kr.simplify();
	if (code_gen_debug) {
		fprintf(DebugFile,"\nRecomputing loop for t%d (node %p)\n",
			level, (void *)this);
		fprintf(DebugFile,"known: %s\n",
			(const char *) known.print_formula_to_string());
		if (!restrictions.is_tautology()) {
			fprintf(DebugFile,"restrictions: %s\n",
				(const char *) restrictions.print_formula_to_string());
			fprintf(DebugFile,"Known and restrictions: %s\n",
				(const char *) kr.print_formula_to_string());
			}
		}
	known.compress();
        restrictions.compress();
	SetTuple I(isActive.size());
	int anyActive = 0;
	int s;
	for(s = 1; s<= isActive.size(); s++) if (isActive[s]) {
	    uncompress2(projected_nIS[level][s]);
	    if (!Intersection(copy(kr),copy(projected_nIS[level][s])).is_satisfiable())  {
		
		if (code_gen_debug) {
			fprintf(DebugFile,"Thought s%d was active but it isn't\n",
					s);
			fprintf(DebugFile,"Iteration space: %s\n",
				(const char *) projected_nIS[level][s].print_formula_to_string());
			}
		isActive[s] = 0;
		}
	    else anyActive = 1;
	    projected_nIS[level][s].compress();
	};
	if (!anyActive) {
	    CG_result *r = new CG_null();
	    if (code_gen_debug) {
		fprintf(DebugFile,"Pruning loop node %p\n",
			(void *)this);
                uncompress2(known);
		fprintf(DebugFile,"Known: %s\n",
			(const char *) known.print_formula_to_string());
	        known.compress();
                uncompress2(restrictions);
		fprintf(DebugFile,"restrictions: %s\n",
			(const char *) restrictions.print_formula_to_string());
                restrictions.compress();
	    };
	    delete this;
	    return r;
	};
	for(s = 1; s<= isActive.size(); s++) if (isActive[s])
	    uncompress2(projected_nIS[level][s]);
	Relation projected_hull = Hull(projected_nIS[level],isActive,1);

        uncompress2(known);
	Relation the_gcs =
	    greatest_common_step(projected_nIS[level], isActive, copy(known),
					      level,last_level,isActive.size());
	if (code_gen_debug) {
		fprintf(DebugFile,"greatest common step is: %s\n",
				(const char *) the_gcs.print_formula_to_string());
		fprintf(DebugFile,"Projected Hull is: %s\n",
				(const char *) projected_hull.print_formula_to_string());
		}
	known.compress();
	for(s = 1; s<= isActive.size(); s++) if (isActive[s])
	    projected_nIS[level][s].compress();
	Relation hull = Intersection(projected_hull, the_gcs);

	hull.simplify(1,1);
	assert(hull.is_satisfiable());
	if (code_gen_debug) {
		fprintf(DebugFile,"first hull is: %s\n\n",
				(const char *) hull.print_formula_to_string());
		}
	hull = Intersection(hull,copy(kr));
	hull = projectEliminatedVariables(hull,eliminated);
	hull.simplify(1,1);
	uncompress2(known);
	Relation k0 = copy(known);
	known.compress();
	k0 = projectEliminatedVariables(k0,eliminated);
	bounds = Gist(copy(hull),copy(k0),1);
	bounds.simplify(2,2);
	name_codegen_vars(bounds);
	needLoop = 1;
	Relation eq_constraint = Relation::True(bounds);
	Conjunct *c = bounds.query_DNF()->single_conjunct();
	EQ_Iterator eq(c);
	Variable_ID v = set_var(level);
	// Search for EQs that involves the interesting variable
	for(;eq.live() && needLoop;eq++) {
	    if ((*eq).get_coef(v)) {
		for(Constr_Vars_Iter w(*eq, 1); w; w++)
		    if ((*w).coef != 0) goto nextEQ;
		// Found EQ involving v and no wildcards
		assert(needLoop); // there are not two of these
		eq_constraint.and_with_EQ(*eq);
		eq_constraint.finalize();
		needLoop = 0;
	    }
	  nextEQ: ;
	}
	bounds.compress();
	if (!needLoop) {
#if 0
	    fprintf(DebugFile,"No loop needed\n");
#endif
	    e.append(set_var(level));
	    // don't generate guard, exclude that info from known
	    guard = Relation::True(bounds.n_set());
	    guard.compress();
	    // add only info about current loop var to known, not guard info
	    bounds = eq_constraint;
	    bounds.compress();
	    uncompress2(known);
	    Relation new_known = Intersection(copy(known),eq_constraint);
	    known.compress();
	    uncompress2(restrictions);
	    Relation new_restrictions = Gist(copy(restrictions),copy(new_known));
	    restrictions.compress();
	    body = body->recompute(new_known,new_restrictions,e);
	    return this;
	}
	
	uncompress2(bounds);
	Relation loop_guard = Gist(project_onto_levels(copy(bounds),level-1,1),
			  copy(k0),1);
        bounds.compress();
	loop_guard.simplify(2,4);
	// A real loop will be generated
	guard = loop_guard;
	name_codegen_vars(guard);
#if 0
	fprintf(DebugFile,"Loop guard at lvl %d for %x is:\n",
		level,
		(void *) this);
	guard.prefix_print(DebugFile);
#endif
	guard = Approximate(guard,1); // Should check for exactness
	guard.compress();
#if 0
	fprintf(DebugFile,"Approximate guard is:\n");
        uncompress2(guard);
	guard.prefix_print(DebugFile);
	guard.compress();
	fprintf(DebugFile,"Bounds are:\n");
	uncompress2(bounds);
	bounds.prefix_print(DebugFile);
        bounds.compress();
	fprintf(DebugFile,"hull is:\n");
	hull.prefix_print(DebugFile);
	fprintf(DebugFile,"known is:\n");
	uncompress2(known);
	known.prefix_print(DebugFile);
	known.compress();
	fprintf(DebugFile,"kr is:\n");
	kr.prefix_print(DebugFile);
	fprintf(DebugFile,"k0 is:\n");
	k0.prefix_print(DebugFile);
	Relation b99 = Gist(copy(hull),copy(k0),1);
	fprintf(DebugFile,"b99 is:\n");
	b99.prefix_print(DebugFile);
	fprintf(DebugFile,"active: ");
	for(s = 1; s <= isActive.size(); s++) 
	    if (isActive[s])
		fprintf(DebugFile,"%d ",s);
	fprintf(DebugFile,"\n");
	if (eliminated.size()) {
	    int t;
	    for(t=1;t<=eliminated.size();t++)
		fprintf(DebugFile,"%d is eliminated\n",
			eliminated[t]->get_position());
	}
	fprintf(DebugFile,"\n\n\n");
#endif
	Relation newRestrictions = Relation::True(hull.n_set());
	body = body->recompute(Intersection(hull,kr),
			       newRestrictions,e);
	return this;
}



String MMGenerateCode(RelTuple &T, SetTuple &old_IS, Relation &known, int effort)
{
    Tuple<naming_info *> NameInfo;
    for (int stmt = 1; stmt <= T.size(); stmt++)
	{
	    NameInfo.append(new default_stmt_info(stmt));

	}
    return MMGenerateCode(T, old_IS, NameInfo, known, effort);
}

String MMGenerateCode(RelTuple &T, SetTuple &old_IS, 
		      Tuple<naming_info *> &name_func_tuple,
		      Relation &known, int effort){
    int i;
    int stmts = T.size();
    if (OMEGA_WHINGE < 0)
       OMEGA_WHINGE = getenv("OMEGA_WHINGE") ? atoi(getenv("OMEGA_WHINGE")) : 0;

    new_IS.reallocate(stmts);
    transformations.reallocate(stmts);
    statementNameInfo.reallocate(stmts);    
    last_level = T[1].n_out();
    projected_nIS.clear();
    projected_nIS.reallocate(last_level);
    int maxStmt = 1;
    int stmt;
    for (stmt = 1; stmt <= stmts; stmt++)
	{
	uncompress2(T[stmt]);
	uncompress2(old_IS[stmt]);
	}

    for (stmt = 1; stmt <= stmts; stmt++)
	{
            for(i = 1; i <= last_level; i ++)
                T[stmt].name_output_var(i,String("t")+itoS(i));

	    Relation R = 
		Range(Restrict_Domain(copy(T[stmt]), copy(old_IS[stmt])));

	    R.simplify(2,4);
	    name_codegen_vars(R);
	    while(R.is_satisfiable()) {
		new_IS.reallocate(maxStmt);
		transformations.reallocate(maxStmt);
		statementNameInfo.reallocate(maxStmt);
		DNF *dnf = R.query_DNF();
		DNF_Iterator c(dnf);
		new_IS[maxStmt] = Relation(R,*c);
		new_IS[maxStmt].simplify(2,4);
		transformations[maxStmt] = T[stmt];
		statementNameInfo[maxStmt] = name_func_tuple[stmt];
		maxStmt++;
		c.next();
		if (!c.live()) break;
    		if(code_gen_debug) {
			fprintf(DebugFile, "splitting iteration space for disjoint form\n");
			fprintf(DebugFile, "Original iteration space: \n");
			R.print_with_subs(DebugFile);
			fprintf(DebugFile, "First conjunct: \n");
			new_IS[maxStmt-1].print_with_subs(DebugFile);
			}
		Relation remainder(R,*c);
		c.next();
		while (c.live()) {
			remainder = Union(remainder,Relation(R,*c));
			c.next();
			}
		R  = Difference(remainder, copy( new_IS[maxStmt-1]));
		R.simplify(2,4);
    		if(code_gen_debug) {
			fprintf(DebugFile, "Remaining iteration space: \n");
			R.print_with_subs(DebugFile);
			}
	    }
	}

    for (stmt = 1; stmt <= stmts; stmt++)
	{
	T[stmt].compress();
	old_IS[stmt].compress();
	}

    stmts = maxStmt-1;
    if(stmts == 0) // Empty region
	return String("/* No points in any of the iteration spaces */\n");

    for (stmt = 1; stmt <= stmts; stmt++)
	{
	transformations[stmt].compress();
	new_IS[stmt].compress();
	}

    if(code_gen_debug) fprintf(DebugFile, "::: MMGenerateCode\n");

    for(i = 1; i <= last_level; i++ ) 
	projected_nIS[i].reallocate(stmts);

    for (stmt = 1; stmt <= stmts; stmt++)
	{
	uncompress2(new_IS[stmt]);
	Relation I = new_IS[stmt];
        for(i = last_level; i >= 1; i-- ) {
		I = project_onto_levels(I, i,0);
		projected_nIS[i][stmt] = I;
		}
        for(i = 2; i <= last_level; i++ ) {
		projected_nIS[i][stmt] = Intersection(projected_nIS[i][stmt],I);
		projected_nIS[i][stmt].simplify();
		I = projected_nIS[i][stmt];
		projected_nIS[i][stmt].compress();
		}
	new_IS[stmt] = Intersection(new_IS[stmt],I);

	new_IS[stmt].compress();

	if (code_gen_debug > 1) {
          for(i = 1; i <= last_level; i++ ) {
		projected_nIS[i][stmt].compress();
		fprintf(DebugFile,"Stmt s%d iteration space at level %d: \n  %s\n",stmt,i,
			(const char *) projected_nIS[i][stmt].print_formula_to_string());
		projected_nIS[i][stmt].uncompress();

		}
	   }
	}

    if(known.is_null()) 
	{
	known = Relation::True(last_level);
	known.compress();
	}
    int maxRank = 0;
    for (stmt = stmts; stmt > 0; stmt--)
	{
	    int rank,tmp;
	    uncompress2(new_IS[stmt]);
	    new_IS[stmt].dimensions(rank,tmp);
	    new_IS[stmt].compress();
	    assert(rank == tmp);
	    if (maxRank < rank) maxRank = rank;
	}
    IntTuple allStmts(stmts);
    for(i=1; i<=stmts; i++) allStmts[i] = 1;
    CG_result *r = gen_recursive(1, allStmts); 
    Variable_ID_Tuple empty;
    print_in_code_gen_style++;
    uncompress2(known);
    known.simplify(1,2);
    known=Approximate(known,1);
    known=Hull(known,1);
    if (code_gen_debug)
	fprintf(DebugFile,"Before recompute:\n%s\n\n",
		(const char *)r->printStructure(1));
    r = r->recompute(known,Relation::True(last_level),empty);
    int rdepth = r->depth();
#if !defined(NDEBUG)
    if(code_gen_debug && maxRank != rdepth){
	fprintf(DebugFile, "ERROR: dimension computation failed!\n"
		"should be %d, computed as %d\n",rdepth,maxRank);
	fprintf(stderr, "// ERROR: dimension computation failed!\n"
		"// should be %d, computed as %d\n",rdepth,maxRank);
    }
#endif
    if (code_gen_debug)
	fprintf(DebugFile,"Before overhead removal:\n%s\n\n",
		(const char *)r->print(1));
    if (effort >= -1)  
        r = r->force_finite_bounds();
    if (effort >= 0)  {
	for(int ov = rdepth; ov >= rdepth-effort && ov >= 1; ov--) {
	    r = r->liftOverhead(ov);
#if !defined(NDEBUG)
	    if(code_gen_debug && ! r->verify_overhead_removal(ov))
		fprintf(DebugFile,"ERROR: overhead removal failure,"
			" overhead NOT removed to level %d\n",ov);
#endif
	    if (code_gen_debug)
		fprintf(DebugFile,"Overhead removed to depth %d:\n%s\n\n",ov,
			(const char *)r->print(1));
	}
    }

#if !defined(NDEBUG)
    if(! r->verify_overhead_removal(rdepth-effort))
	fprintf(stderr,"ERROR: overhead removal failure,"
		" overhead NOT removed to level %d\n",rdepth-effort);

    if(code_gen_debug > 1) {
	int pick;
	bool lastone=true;
	for(pick = 0; pick <= rdepth && lastone; pick++)
	    lastone = !r->verify_overhead_removal(pick);
	fprintf(stderr,"Innermost overhead nested inside level %d\n",pick-1);
    }
#endif

    String S = r->print(1);
    print_in_code_gen_style--;
    delete r;
    r = 0;
    projected_nIS.clear();
    transformations.clear();
    new_IS.clear();
    return S;
}

CG_result * gen_recursive( int level, IntTuple &isActive)
{

    int stmts = isActive.size();

    Set<int> active;
    int s;
    for(s = 1; s <= stmts; s++)
	if(isActive[s]) active.insert(s);

    assert (active.size() >= 1);
    if(level > last_level) return new CG_leaf(isActive);

    if (active.size() == 1)
	    return new CG_loop(isActive,level, gen_recursive(level+1,isActive));

    if(code_gen_debug) {
	fprintf(DebugFile, "::: gen_recursive: level %d\n",level);
	fprintf(DebugFile, ":::   incoming isActive statements: ");
	foreach(i, int, active, fprintf(DebugFile, "%d ", i));
	if(code_gen_debug > 1) {
	    fprintf(DebugFile, "\n::: incoming transformed iteration spaces:\n");
	    for(int i=1; i<=stmts; i++) {
		if (isActive[i]) {
		    fprintf(DebugFile, "statement %d:\n", i);
		    uncompress2(projected_nIS[level][i]);
		    projected_nIS[level][i].prefix_print(DebugFile);
		    projected_nIS[level][i].compress();
		}
	    }
	}
	fprintf(DebugFile, "\n");
    }

#if PAINFULLY_EXPENSIVE_DEBUGGING
    // Assert that the isActive list is in correspondence
    // with the iteration spaces
    if (code_gen_debug) {
	foreach(check,int,active,
		{ uncompress2(projected_nIS[level][check]);
		  assert(!isActive[check] 
		       || (!projected_nIS[level][check].is_null() && 
		       projected_nIS[level][check].is_satisfiable()));
		  projected_nIS[level][check].compress();});
	}
#endif


	bool constantLevel = true;
   
	int test_rel_size;
	int start,finish; 
	finish = -(MAXINT-1);
	start = MAXINT;
        Tuple<int> when(stmts);
	for(s=1; s<=stmts; s++) if (isActive[s]) {
		int lb,ub;
		uncompress2(projected_nIS[level][s]);
		test_rel_size = projected_nIS[level][s].n_set();
		projected_nIS[level][s].single_conjunct()
			->query_variable_bounds(
				projected_nIS[level][s].set_var(level),
				lb,ub);
	        if(code_gen_debug) {
			fprintf(DebugFile, "IS%d:  %d <= t%d <= %d\n",s,
					lb,level,ub);
			projected_nIS[level][s].prefix_print(DebugFile);
			}
		projected_nIS[level][s].compress();
		if (lb != ub) {
			constantLevel = false;
			break;
			}
		else {
			set_max(finish,lb);
			set_min(start,lb);
			when[s] = lb;
		};
		}

	
	if (constantLevel && finish-start <= stmts) {
    		IntTuple newActive(isActive.size());
	        for(int i=1; i<=stmts; i++)  
			newActive[i] = isActive[i] && when[i] == start;
		CG_result *r  = new CG_loop(isActive,level, 
				gen_recursive(level+1,newActive));
		for(int time = start+1; time <= finish; time++) {
		    int count = 0;
		    for(int i=1; i<=stmts; i++)   {
			newActive[i] = isActive[i] && when[i] == time;
			if (newActive[i]) count++;
			}
		    if (count) {
			Relation test_rel(test_rel_size);
			GEQ_Handle g = test_rel.and_with_GEQ();	
			g.update_coef(test_rel.set_var(level),-1);
			g.update_const(time-1);
			
		        r = new CG_split(isActive,level,test_rel,r,
				new CG_loop(isActive,level, 
					gen_recursive(level+1,newActive)));
			}
		
		}
		return r;
		}


// Since the Hull computation is approximate, we will get regions that
// have no stmts.  (since we will have split on constraints on the
// hull, and thus we are looking at a region outside the convex hull
// of all the iteration spaces.)


    for(s = 1; s<= isActive.size(); s++) if (isActive[s])
        uncompress2(projected_nIS[level][s]);
#if 1
    Relation hull = Hull(projected_nIS[level],isActive,1);
#else
    Relation hull = Hull(projected_nIS[level],isActive,0);
#endif

#if PAINFULLY_EXPENSIVE_DEBUGGING
    if(code_gen_debug)
	foreach(s,int,active,assert(Subset(copy(projected_nIS[level][s]),copy(hull))));
#endif

    for(s = 1; s<= isActive.size(); s++) if (isActive[s])
        projected_nIS[level][s].compress();

    if(code_gen_debug) {
	fprintf(DebugFile, "Hull (level %d) is:\n",level);
	hull.prefix_print(DebugFile);
    }
    IntTuple firstChunk(isActive);
    IntTuple secondChunk(isActive);

    foreach(s,int,active,
	    {
	    uncompress2(projected_nIS[level][s]);
	    Relation gist = Gist(copy(projected_nIS[level][s]),copy(hull),1);
	    projected_nIS[level][s].compress();
	    if (gist.is_tautology()) break;
	    gist.simplify();
	    Conjunct *s_conj = gist.single_conjunct();
	    for(GEQ_Iterator G(s_conj); G; G++) {
		Relation test_rel(gist.n_set());
		test_rel.and_with_GEQ(*G);
		Variable_ID v = set_var(level);
		int sign = (*G).get_coef(v);
		if(sign > 0) test_rel = Complement(test_rel);
		if(code_gen_debug) {
		    fprintf(DebugFile, "Considering split from stmt %d:\n",s);
		    test_rel.prefix_print(DebugFile);
		}
		
		firstChunk[s] = sign <= 0;
		secondChunk[s] = sign > 0;
		int numberFirst = sign <= 0;
		int numberSecond = sign > 0;
		foreach(s2,int,active, if (s!=s2) {
		    if(code_gen_debug) 
			fprintf(DebugFile,"Consider stmt %d\n",s2);
	            uncompress2(projected_nIS[level][s2]);
		    bool t = Intersection(copy(projected_nIS[level][s2]),
					  copy(test_rel)).is_satisfiable();
		    bool f = Difference(copy(projected_nIS[level][s2]),
					copy(test_rel)).is_satisfiable();
	            projected_nIS[level][s2].compress();
		    assert(t || f);
		    if(code_gen_debug  && t&&f) 
			fprintf(DebugFile, "Slashes stmt %d\n",s2);
		    if (t&&f) goto nextGEQ;
		    if(code_gen_debug) {
			if (t)
			    fprintf(DebugFile, "true for stmt %d\n",s2);
			else 
			    fprintf(DebugFile, "false for stmt %d\n",s2);
		    }
		    if (t) numberFirst++;
		    else numberSecond++;
		    firstChunk[s2] = t;
		    secondChunk[s2] = !t;
		});
		assert(numberFirst+numberSecond>1 && "Can't handle wildcard in iteration space");
	       if(code_gen_debug) 
			fprintf(DebugFile, "%d true, %d false\n",
						numberFirst,
						numberSecond);
		if (numberFirst && numberSecond) {
		    // Found a dividing constraint
		    if(code_gen_debug) {
			fprintf(DebugFile, "Splitting on:");
			test_rel.prefix_print(DebugFile);
			fprintf(DebugFile, "First chunk:");
			    foreach(s,int,active,
				    {assert(firstChunk[s] || secondChunk[s]);
				    assert(!(firstChunk[s] && secondChunk[s]));
				    if (firstChunk[s]) fprintf(DebugFile,"s%d ",s);
				});
			fprintf(DebugFile, "\n");
		    }
			
		    return new CG_split(isActive,level,test_rel,
					gen_recursive(level,firstChunk),
					gen_recursive(level,secondChunk));
		}
	      nextGEQ: ;
	    }
	    }
	);

    // No way found to divide stmts without splitting, generate loop

    return new CG_loop(isActive,level, gen_recursive(level+1,isActive));
}


// VERIFY FUNCTIONS


bool CG_result::verify_overhead_removal(int depth) {
    return true;
}

bool CG_null::verify_overhead_removal(int depth) {
    return true;
}

bool CG_split::verify_overhead_removal(int depth) {
    bool b1 = trueClause->verify_overhead_removal(depth);
    bool b2 = falseClause->verify_overhead_removal(depth);
    return b1 && b2;
}

bool CG_leaf::verify_overhead_removal(int depth) {
    bool no_guards = true;
    if(depth < 0)
	for(int i = 1; i <= isActive.size(); i++)
	    if(isActive[i]) {
		uncompress2(guard[i]);
		if (!guard[i].is_tautology()) {
/* Exclude strides that can't be move further out */
		    for(DNF_Iterator d(guard[i].query_DNF()); d; d++)
			for(EQ_Iterator e(*d); e; e++)
			    if(!((*e).has_wildcards() && (*e).max_tuple_pos() == last_level)) {
				fprintf(stderr,"statement guard overhead found on"
					"statement %d\n",i);
				no_guards = false;
			    }
		}
		guard[i].compress();
            }
    return no_guards;
}




/*
    Overheads here are in the form of min/maxes and guards
    Zero-trip loops are checked by the guards, and z-t guards are
    not removed from them till printing, so we don't have to examine 
    bounds for those.
*/
bool CG_loop::verify_overhead_removal(int depth) {
    bool no_over_guard=true,no_over_minmax=true; 
    if(depth < 0) {
	uncompress2(guard);
	if(!guard.is_tautology()) {
	    /* Exclude strides that can't be moved further out */
	    for(DNF_Iterator d(guard.query_DNF()); d; d++)
		for(EQ_Iterator e(*d); e; e++)
		    if(!((*e).has_wildcards() && (*e).max_tuple_pos() == level-1)) {
			no_over_guard = false;
			fprintf(stderr,"loop guard overhead found at level %d\n",level);
		    }
	}
	guard.compress();
	int coef,upper_bounds=0,lower_bounds=0;
	Variable_ID v = set_var(level);
	
	if(needLoop) {
	    uncompress2(bounds);
	    for(GEQ_Iterator CI(bounds.single_conjunct()); CI; CI++) 
		if ((coef = (*CI).get_coef(v)) != 0) {  // In this constraint?
		    if(coef > 0) // lb or ub
			lower_bounds++;
		    else 
			upper_bounds++;
		}
            bounds.compress();
//	    assert(lower_bounds > 0 && upper_bounds > 0);
	    if (lower_bounds > 1 || upper_bounds > 1 ) {
		fprintf(stderr,"min/max overhead found at level %d\n",level);
		no_over_minmax = false;
	    }
	} else {
	    // no overheads result from a single-valued level
	    no_over_minmax = true;
	}
    }
    bool no_over_body = body->verify_overhead_removal(needLoop?depth-1:depth);
    return (no_over_guard && no_over_minmax && no_over_body);
}






#else

int code_gen_debug=0;

String MMGenerateCode(Tuple<Relation> &, Tuple<Relation> &, Relation &,
			int)
    {
    assert(0);
    abort();
    return "";
    }

String MMGenerateCode(Tuple<Relation> &, Tuple<Relation> &, Tuple<char*> &,
			Relation, int)
    {
    assert(0);
    abort();
    return "";
    }


#endif
