/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include <rpc/rpc.h>
#include "pfsd.h"
/*****************************************************************************
 *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

bool_t
xdr_errorinfo(xdrs, objp)
	XDR *xdrs;
	errorinfo *objp;
{
	if (!xdr_int(xdrs, &objp->errno)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->errstr, MAXERRLEN)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_pfslib_data(xdrs, objp)
	XDR *xdrs;
	pfslib_data *objp;
{
	if (!xdr_bytes(xdrs, (char **)&objp->pfslib_data_val, (u_int *)&objp->pfslib_data_len, MAXDATALEN)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_pfslib_fhdl(xdrs, objp)
	XDR *xdrs;
	pfslib_fhdl *objp;
{
	if (!xdr_int(xdrs, &objp->vfd)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->how_many)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->which)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->mode)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_pfslib_ipaddr(xdrs, objp)
	XDR *xdrs;
	pfslib_ipaddr objp;
{
	if (!xdr_opaque(xdrs, objp, IPADDRLEN)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_iod_address(xdrs, objp)
	XDR *xdrs;
	iod_address *objp;
{
	if (!xdr_string(xdrs, &objp->hname, 1024)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->port)) {
		return (FALSE);
	}
	if (!xdr_pfslib_ipaddr(xdrs, objp->ipaddr)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_pfslib_fattr(xdrs, objp)
	XDR *xdrs;
	pfslib_fattr *objp;
{
	if (!xdr_int(xdrs, &objp->type)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->amode)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->nlink)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->userid)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->groupid)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->size)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->atime)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->mtime)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->ctime)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->actual)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_openargs(xdrs, objp)
	XDR *xdrs;
	openargs *objp;
{
	if (!xdr_bool(xdrs, &objp->global)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->filename, 1024)) {
		return (FALSE);
	}
	if (!xdr_pfslib_otype(xdrs, &objp->oflags)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->permission)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->how_many)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->which)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->mode)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_setiomodeargs(xdrs, objp)
	XDR *xdrs;
	setiomodeargs *objp;
{
	if (!xdr_pfslib_fhdl(xdrs, &objp->fh)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->mode)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_getioidargs(xdrs, objp)
	XDR *xdrs;
	getioidargs *objp;
{
	if (!xdr_pfslib_fhdl(xdrs, &objp->fh)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->op)) {
		return (FALSE);
	}
	if (!xdr_bool(xdrs, &objp->ssync)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->iolen)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_ioidstatargs(xdrs, objp)
	XDR *xdrs;
	ioidstatargs *objp;
{
	if (!xdr_pfslib_fhdl(xdrs, &objp->fh)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->ioID)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_ioopargs(xdrs, objp)
	XDR *xdrs;
	ioopargs *objp;
{
	if (!xdr_int(xdrs, &objp->op)) {
		return (FALSE);
	}
	if (!xdr_pfslib_fhdl(xdrs, &objp->fh)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->ioID)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->iolen)) {
		return (FALSE);
	}
	if (!xdr_pfslib_data(xdrs, &objp->data)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_fpmoveargs(xdrs, objp)
	XDR *xdrs;
	fpmoveargs *objp;
{
	if (!xdr_pfslib_fhdl(xdrs, &objp->fh)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->whence)) {
		return (FALSE);
	}
	if (!xdr_u_int(xdrs, &objp->offset)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_resetargs(xdrs, objp)
	XDR *xdrs;
	resetargs *objp;
{
	if (!xdr_string(xdrs, &objp->fname, 1024)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_prtstatargs(xdrs, objp)
	XDR *xdrs;
	prtstatargs *objp;
{
	if (!xdr_bool(xdrs, &objp->verbose)) {
		return (FALSE);
	}
	if (!xdr_bool(xdrs, &objp->iods)) {
		return (FALSE);
	}
	if (!xdr_string(xdrs, &objp->fname, 1024)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_openres(xdrs, objp)
	XDR *xdrs;
	openres *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case 0:
		if (!xdr_pfslib_fhdl(xdrs, &objp->openres_u.fh)) {
			return (FALSE);
		}
		break;
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->openres_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_setiomoderes(xdrs, objp)
	XDR *xdrs;
	setiomoderes *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->setiomoderes_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_iomoderes(xdrs, objp)
	XDR *xdrs;
	iomoderes *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case 0:
		if (!xdr_int(xdrs, &objp->iomoderes_u.mode)) {
			return (FALSE);
		}
		break;
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->iomoderes_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_gioidres(xdrs, objp)
	XDR *xdrs;
	gioidres *objp;
{
	if (!xdr_int(xdrs, &objp->ioID)) {
		return (FALSE);
	}
	if (!xdr_iod_address(xdrs, &objp->iod_addr)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_getioidres(xdrs, objp)
	XDR *xdrs;
	getioidres *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case 0:
		if (!xdr_gioidres(xdrs, &objp->getioidres_u.res)) {
			return (FALSE);
		}
		break;
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->getioidres_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_iodoneres(xdrs, objp)
	XDR *xdrs;
	iodoneres *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case 0:
		if (!xdr_bool(xdrs, &objp->iodoneres_u.done)) {
			return (FALSE);
		}
		break;
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->iodoneres_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_iowaitres(xdrs, objp)
	XDR *xdrs;
	iowaitres *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->iowaitres_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_opres(xdrs, objp)
	XDR *xdrs;
	opres *objp;
{
	if (!xdr_u_int(xdrs, &objp->iolen)) {
		return (FALSE);
	}
	if (!xdr_pfslib_data(xdrs, &objp->data)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_ioopres(xdrs, objp)
	XDR *xdrs;
	ioopres *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case 0:
		if (!xdr_opres(xdrs, &objp->ioopres_u.res)) {
			return (FALSE);
		}
		break;
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->ioopres_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_lsizeres(xdrs, objp)
	XDR *xdrs;
	lsizeres *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case 0:
		if (!xdr_u_int(xdrs, &objp->lsizeres_u.size)) {
			return (FALSE);
		}
		break;
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->lsizeres_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_iseofres(xdrs, objp)
	XDR *xdrs;
	iseofres *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case 0:
		if (!xdr_bool(xdrs, &objp->iseofres_u.eof)) {
			return (FALSE);
		}
		break;
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->iseofres_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_lseekres(xdrs, objp)
	XDR *xdrs;
	lseekres *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case 0:
		if (!xdr_u_int(xdrs, &objp->lseekres_u.pos)) {
			return (FALSE);
		}
		break;
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->lseekres_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_fattrres(xdrs, objp)
	XDR *xdrs;
	fattrres *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case 0:
		if (!xdr_pfslib_fattr(xdrs, &objp->fattrres_u.attr)) {
			return (FALSE);
		}
		break;
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->fattrres_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_closeres(xdrs, objp)
	XDR *xdrs;
	closeres *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->closeres_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_resetres(xdrs, objp)
	XDR *xdrs;
	resetres *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case 0:
		if (!xdr_int(xdrs, &objp->resetres_u.count)) {
			return (FALSE);
		}
		break;
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->resetres_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

bool_t
xdr_iodresargs(xdrs, objp)
	XDR *xdrs;
	iodresargs *objp;
{
	if (!xdr_pfslib_fhdl(xdrs, &objp->fh)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->ioID)) {
		return (FALSE);
	}
	if (!xdr_bool(xdrs, &objp->ok)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->errno)) {
		return (FALSE);
	}
	if (!xdr_pfslib_data(xdrs, &objp->dhb)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_iodregargs(xdrs, objp)
	XDR *xdrs;
	iodregargs *objp;
{
	if (!xdr_iod_address(xdrs, &objp->addr)) {
		return (FALSE);
	}
	if (!xdr_int(xdrs, &objp->pid)) {
		return (FALSE);
	}
	return (TRUE);
}

bool_t
xdr_iodregres(xdrs, objp)
	XDR *xdrs;
	iodregres *objp;
{
	if (!xdr_int(xdrs, &objp->stat)) {
		return (FALSE);
	}
	switch (objp->stat) {
	case -1:
		if (!xdr_errorinfo(xdrs, &objp->iodregres_u.err)) {
			return (FALSE);
		}
		break;
	}
	return (TRUE);
}

#include <fcntl.h>

/* ********************************************************************** */
/* xdr routine to convert open flags                                      */
/* ********************************************************************** */
bool_t
xdr_pfslib_otype(xdrs, objp)
  XDR *xdrs;
  pfslib_otype *objp;
{
  int res = 0;
  
  switch (xdrs->x_op)
  {
  case XDR_ENCODE:
    if (*objp & O_RDONLY) res |= PFSLIB_O_RDONLY;
    if (*objp & O_WRONLY) res |= PFSLIB_O_WRONLY;
    if (*objp & O_RDWR) res |= PFSLIB_O_RDWR;
    if (*objp & O_APPEND) res |= PFSLIB_O_APPEND;
    if (*objp & O_CREAT) res |= PFSLIB_O_CREAT;
    if (*objp & O_EXCL) res |= PFSLIB_O_EXCL;
    if (*objp & O_NOCTTY) res |= PFSLIB_O_NOCTTY;
    if (*objp & O_NONBLOCK) res |= PFSLIB_O_NONBLOCK;
    if (*objp & O_TRUNC) res |= PFSLIB_O_TRUNC;
    if (*objp & O_NDELAY) res |= PFSLIB_O_NDELAY;
    if (*objp & O_SYNC) res |= PFSLIB_O_SYNC;
    return (xdr_int(xdrs, &res));
  case XDR_DECODE:
    if (!xdr_int(xdrs, &res))
    {
      return (FALSE);
    }
    *objp = 0;
    if (res & PFSLIB_O_RDONLY) *objp |= O_RDONLY;
    if (res & PFSLIB_O_WRONLY) *objp |= O_WRONLY;
    if (res & PFSLIB_O_RDWR) *objp |= O_RDWR;
    if (res & PFSLIB_O_APPEND) *objp |= O_APPEND;
    if (res & PFSLIB_O_CREAT) *objp |= O_CREAT;
    if (res & PFSLIB_O_EXCL) *objp |= O_EXCL;
    if (res & PFSLIB_O_NOCTTY) *objp |= O_NOCTTY;
    if (res & PFSLIB_O_NONBLOCK) *objp |= O_NONBLOCK;
    if (res & PFSLIB_O_TRUNC) *objp |= O_TRUNC;
    if (res & PFSLIB_O_NDELAY) *objp |= O_NDELAY;
    if (res & PFSLIB_O_SYNC) *objp |= O_SYNC;
    return (TRUE);
  case XDR_FREE:
    return (xdr_int(xdrs, &res));
  }
  return (FALSE);
}

