/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#include <stdio.h>
#include <rpc/rpc.h>
#include "pfsd.h"
/*****************************************************************************
 *
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

#ifdef SUN4
#include <memory.h>
#else
#include <string.h>
#endif /* SUN4 */

#define bzero(a,b) memset(a,0,b)

extern void _pfsd_init
#ifdef ANSI_C
(int argc, char **argv);
#else
();
#endif /* ANSI_C */

#include "auth_ok.c"

static void pfsd_main
#ifdef ANSI_C
(int argc, char **argv);
#else
();
#endif /* ANSI_C */

int main
#ifdef ANSI_C
(int argc, char **argv)
#else
(argc, argv)
int    argc;
char **argv;
#endif /* ANSI_C */
{
  char hostname[1024];
  
  if (gethostname(hostname,1024) < 0)
  {
    perror("gethostname");
    exit(1);
  }
  
  if (callrpc(hostname, PFSD, PFSD_VERS, NULLPROC,
              xdr_void, (char *)NULL, xdr_void, (char *)0) == RPC_SUCCESS)
  {
    fprintf(stderr,"%s: There is already a pfsd registered on this machine\n",
            argv[0]);
    fprintf(stderr,"%s: Exiting\n",argv[0]);
    exit(1);
  }

  pfsd_main(argc,argv);
  return (1);
}

/* define main to be able to access the original main procedure */
#ifdef ANSI_C
#define main() static void pfsd_main(int argc, char **argv)
#else
#define main() static void pfsd_main(argc, argv)\
int argc;\
char **argv;
#endif

/* Initialize before running svc_run() */
#ifdef ANSI_C
static int pfsd_svc_run(int argc, char **argv)
#else
static int pfsd_svc_run(argc, argv)
int argc;
char **argv;
#endif /* ANSI_C */
{
  _pfsd_init(argc, argv);
  svc_run();
  /* Should never return */
  exit(1);
}

#define svc_run() pfsd_svc_run(argc, argv)  


static void pfsd_1();
static void pfsd_iod_1();

main()
{
	register SVCXPRT *transp;

	(void) pmap_unset(PFSD, PFSD_VERS);
	(void) pmap_unset(PFSD_IOD, PFSD_IOD_VERS);

	transp = svcudp_create(RPC_ANYSOCK);
	if (transp == NULL) {
		fprintf(stderr, "cannot create udp service.");
		exit(1);
	}
	if (!svc_register(transp, PFSD, PFSD_VERS, pfsd_1, IPPROTO_UDP)) {
		fprintf(stderr, "unable to register (PFSD, PFSD_VERS, udp).");
		exit(1);
	}
	if (!svc_register(transp, PFSD_IOD, PFSD_IOD_VERS, pfsd_iod_1, IPPROTO_UDP)) {
		fprintf(stderr, "unable to register (PFSD_IOD, PFSD_IOD_VERS, udp).");
		exit(1);
	}

	transp = svctcp_create(RPC_ANYSOCK, 0, 0);
	if (transp == NULL) {
		fprintf(stderr, "cannot create tcp service.");
		exit(1);
	}
	if (!svc_register(transp, PFSD, PFSD_VERS, pfsd_1, IPPROTO_TCP)) {
		fprintf(stderr, "unable to register (PFSD, PFSD_VERS, tcp).");
		exit(1);
	}
	if (!svc_register(transp, PFSD_IOD, PFSD_IOD_VERS, pfsd_iod_1, IPPROTO_TCP)) {
		fprintf(stderr, "unable to register (PFSD_IOD, PFSD_IOD_VERS, tcp).");
		exit(1);
	}

	svc_run();
	fprintf(stderr, "svc_run returned");
	exit(1);
	/* NOTREACHED */
}

static void
pfsd_1(rqstp, transp)
	struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	union {
		openargs pfsd_open_1_arg;
		setiomodeargs pfsd_setiomode_1_arg;
		pfslib_fhdl pfsd_getiomode_1_arg;
		getioidargs pfsd_getioid_1_arg;
		ioidstatargs pfsd_iodone_1_arg;
		ioidstatargs pfsd_iowait_1_arg;
		ioopargs pfsd_ioop_1_arg;
		fpmoveargs pfsd_lsize_1_arg;
		pfslib_fhdl pfsd_iseof_1_arg;
		fpmoveargs pfsd_lseek_1_arg;
		pfslib_fhdl pfsd_getfattr_1_arg;
		pfslib_fhdl pfsd_close_1_arg;
		resetargs pfsd_reset_1_arg;
		pfslib_fhdl pfsd_cltexit_1_arg;
		prtstatargs pfsd_prtstat_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();


/* BEGIN PATCH done by Makefile */
if (!auth_ok(rqstp,transp)) return;
/* END PATCH */

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void) svc_sendreply(transp, xdr_void, (char *)NULL);
		return;

	case PFSD_OPEN:
		xdr_argument = xdr_openargs;
		xdr_result = xdr_openres;
		local = (char *(*)()) pfsd_open_1;
		break;

	case PFSD_SETIOMODE:
		xdr_argument = xdr_setiomodeargs;
		xdr_result = xdr_setiomoderes;
		local = (char *(*)()) pfsd_setiomode_1;
		break;

	case PFSD_GETIOMODE:
		xdr_argument = xdr_pfslib_fhdl;
		xdr_result = xdr_iomoderes;
		local = (char *(*)()) pfsd_getiomode_1;
		break;

	case PFSD_GETIOID:
		xdr_argument = xdr_getioidargs;
		xdr_result = xdr_getioidres;
		local = (char *(*)()) pfsd_getioid_1;
		break;

	case PFSD_IODONE:
		xdr_argument = xdr_ioidstatargs;
		xdr_result = xdr_iodoneres;
		local = (char *(*)()) pfsd_iodone_1;
		break;

	case PFSD_IOWAIT:
		xdr_argument = xdr_ioidstatargs;
		xdr_result = xdr_iowaitres;
		local = (char *(*)()) pfsd_iowait_1;
		break;

	case PFSD_IOOP:
		xdr_argument = xdr_ioopargs;
		xdr_result = xdr_ioopres;
		local = (char *(*)()) pfsd_ioop_1;
		break;

	case PFSD_LSIZE:
		xdr_argument = xdr_fpmoveargs;
		xdr_result = xdr_lsizeres;
		local = (char *(*)()) pfsd_lsize_1;
		break;

	case PFSD_ISEOF:
		xdr_argument = xdr_pfslib_fhdl;
		xdr_result = xdr_iseofres;
		local = (char *(*)()) pfsd_iseof_1;
		break;

	case PFSD_LSEEK:
		xdr_argument = xdr_fpmoveargs;
		xdr_result = xdr_lseekres;
		local = (char *(*)()) pfsd_lseek_1;
		break;

	case PFSD_GETFATTR:
		xdr_argument = xdr_pfslib_fhdl;
		xdr_result = xdr_fattrres;
		local = (char *(*)()) pfsd_getfattr_1;
		break;

	case PFSD_CLOSE:
		xdr_argument = xdr_pfslib_fhdl;
		xdr_result = xdr_closeres;
		local = (char *(*)()) pfsd_close_1;
		break;

	case PFSD_NUMCLNTS:
		xdr_argument = xdr_void;
		xdr_result = xdr_int;
		local = (char *(*)()) pfsd_numclnts_1;
		break;

	case PFSD_NUMFILES:
		xdr_argument = xdr_void;
		xdr_result = xdr_int;
		local = (char *(*)()) pfsd_numfiles_1;
		break;

	case PFSD_RESET:
		xdr_argument = xdr_resetargs;
		xdr_result = xdr_resetres;
		local = (char *(*)()) pfsd_reset_1;
		break;

	case PFSD_CLTEXIT:
		xdr_argument = xdr_pfslib_fhdl;
		xdr_result = xdr_void;
		local = (char *(*)()) pfsd_cltexit_1;
		break;

	case PFSD_PRTSTAT:
		xdr_argument = xdr_prtstatargs;
		xdr_result = xdr_void;
		local = (char *(*)()) pfsd_prtstat_1;
		break;

	case PFSD_EXIT:
		xdr_argument = xdr_void;
		xdr_result = xdr_void;
		local = (char *(*)()) pfsd_exit_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	bzero((char *)&argument, sizeof(argument));
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);

/* BEGIN PATCH done by Makefile */
/* Send reply only if resul != NULL
* otherwise reply has to be delayed and sent by _do_op()
*/
if (result != NULL) {
if (!svc_sendreply(transp, xdr_result, result)) {
svcerr_systemerr(transp); }}
/* END PATCH */

	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		fprintf(stderr, "unable to free arguments");
		exit(1);
	}
	return;
}

static void
pfsd_iod_1(rqstp, transp)
	struct svc_req *rqstp;
	register SVCXPRT *transp;
{
	union {
		iodresargs pfsd_iod_result_1_arg;
		iodregargs pfsd_iod_register_1_arg;
	} argument;
	char *result;
	bool_t (*xdr_argument)(), (*xdr_result)();
	char *(*local)();


/* BEGIN PATCH done by Makefile */
if (!auth_ok(rqstp,transp)) return;
/* END PATCH */

	switch (rqstp->rq_proc) {
	case NULLPROC:
		(void) svc_sendreply(transp, xdr_void, (char *)NULL);
		return;

	case PFSD_IOD_RESULT:
		xdr_argument = xdr_iodresargs;
		xdr_result = xdr_void;
		local = (char *(*)()) pfsd_iod_result_1;
		break;

	case PFSD_IOD_REGISTER:
		xdr_argument = xdr_iodregargs;
		xdr_result = xdr_iodregres;
		local = (char *(*)()) pfsd_iod_register_1;
		break;

	default:
		svcerr_noproc(transp);
		return;
	}
	bzero((char *)&argument, sizeof(argument));
	if (!svc_getargs(transp, xdr_argument, &argument)) {
		svcerr_decode(transp);
		return;
	}
	result = (*local)(&argument, rqstp);

/* BEGIN PATCH done by Makefile */
/* Send reply only if resul != NULL
* otherwise reply has to be delayed and sent by _do_op()
*/
if (result != NULL) {
if (!svc_sendreply(transp, xdr_result, result)) {
svcerr_systemerr(transp); }}
/* END PATCH */

	if (!svc_freeargs(transp, xdr_argument, &argument)) {
		fprintf(stderr, "unable to free arguments");
		exit(1);
	}
	return;
}
