/******************************************************************************
 *
 *    pfsd_open.c,v : open a file
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_open.c,v
 *  RCS Date     : 1995/10/27 10:15:09
 *  RCS Revision : 1.6
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef lint
static char rcs_id[] = "pfsd_open.c,v 1.6 1995/10/27 10:15:09 lamberts Rel";
#endif


#include <rpc/rpc.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <errno.h>

#include "pfsd.h"
#include "pfsd_defines.h"
#include "pfsd_macros.h"
#include "pfslib_errno.h"

extern filetabel *_cftbl;


openres *pfsd_open_1
#ifdef ANSI_C
(openargs *argp, struct svc_req *rqstp)
#else
(argp, rqstp)
openargs *argp;
struct svc_req *rqstp;
#endif /* ANSI_C */
{

	static openres  result;

  int _ftix;                    /* File table index */
  int _ctix = argp->which;      /* Client table index */

  bool_t all_done;
  bool_t syncok;
  
	struct stat buf;

  int          _clc;            /* counter for loop over clienttable */
  int          _cid;            /* counter for loop over IO-idtable */


	struct authunix_parms *unix_cred;

  /*
	xdr_free(xdr_openres, (char *)&result);
  */

  /* Test input parameter */

  if ((argp->which < 0) || (argp->which >= argp->how_many) ||
      (argp->how_many < 1))
  {
    ERR_MACRO(openres_u,EPFSLINVAL);
    return (&result);
  }
  

  if ((argp->oflags & O_NDELAY) || (argp->oflags & O_NONBLOCK))
  {
    /* We don't know yet how to support O_APPEND in a meaningfull way */
    ERR_MACRO(openres_u,EPFSLNDELAY);
    return(&result);
  }
  
  switch (argp->mode)
  {
  case M_UNIX:
  case M_LOG:
  case M_RECORD:
  case M_SYNC:
  case M_GLOBAL:
    break;
  default:
    ERR_MACRO(openres_u,EPFSLINVAL);
    return (&result);
  }
  

	switch (rqstp->rq_cred.oa_flavor)
  {
	case AUTH_UNIX:
		unix_cred = (struct authunix_parms *) rqstp->rq_clntcred;
    break;
	default:
    break;
	}
	/*
	 * has the file already been opened ?
	 */

  for (_ftix=0; _ftix < MAXNUMFILES; _ftix++)
	{
    /* Look for a matching file in the filetable */
		if ((_RFDC != -1) &&    /* element in use */
        (_CFTE.cltab != (CltTabEl *)0) && /* cttab allocated */
        (_CFTE.actual < _CFTE.how_many) && /* Missing processes */
        (_CFTE.uid == unix_cred->aup_uid) &&   /* unix user id */
        (_CFTE.gid == unix_cred->aup_gid) &&   /* unix group id */
        (strcmp(argp->filename,_CFTE.filename) == 0) && /* correct filename */
        (argp->oflags == _CFTE.oflags) && /* correct openflags */
        (argp->permission == _CFTE.permission) && /* correct permission */
        (argp->how_many == _CFTE.how_many) && /* correct client count */
        (_ctix < _CFTE.how_many) && /* correct which count */
        (!_CLNT.access) && /* not accessing already */
        /* If it's a gopen() it's a gopen by all others too*/
        (((argp->global) && (_CFTE.sync == PFSD_SYNC_OPEN) && 
          (!_CLNT.syncdone) &&  /* this process missing .. */
          (_CFTE.mode == argp->mode)) || /* .. and wants the same mode */
         ((!argp->global) && (_CFTE.sync != PFSD_SYNC_OPEN))))
		{
      /* OK this file is allready open just set the access and actual
         counters */

      _CFTE.actual++;
      _CLNT.access = TRUE;
      _CLNT.ident.uid = unix_cred->aup_uid;
      _CLNT.ident.gid = unix_cred->aup_gid;
      _CLNT.ident.aup_time = unix_cred->aup_time;
      strcpy(_CLNT.ident.hname,unix_cred->aup_machname);
      
      /* LAMBO Set client authetification */

      if (_CFTE.sync == PFSD_SYNC_OPEN)
      {
        _CLNT.syncdone = TRUE;
        _CLNT.transp = rqstp->rq_xprt;

        /* Check wheter all did the gopen() */
        all_done = TRUE;
        syncok = TRUE;
        for (_clc = 0; _clc < _CFTE.how_many; _clc++)
        {
          if (!_CNCL.syncdone)
          {
            all_done = FALSE;
            break;
          }
          else if (!_CNCL.syncok)
          {                   /* There was an error */
            syncok  = FALSE;
          }
        }
        if (all_done)
        {
          if (syncok)
          {
            result.stat = RPC_OK;
            result.openres_u.fh.vfd     =  _ftix;
            result.openres_u.fh.how_many = _CFTE.how_many;
            result.openres_u.fh.mode    =  _CFTE.mode;
          }
          else
          {
            ERR_MACRO(openres_u, _CLNT.syncerr);
          }

          /* Send reply */
          for (_clc=0; _clc < _CFTE.how_many; _clc++)
          {
            if (syncok) 
              result.openres_u.fh.which   = _clc;

            if (!svc_sendreply(_CNCL.transp, xdr_openres, (char *)&result))
            {
              svcerr_systemerr(_CNCL.transp);
            }
          }

          if (!syncok)
          {
            /* Reset file table */
            free(_CFTE.cltab);
            _CFTE.cltab = (CltTabEl *)0;
            _RFDC = -1;
          }
          else
            _CFTE.sync = PFSD_SYNC_NONE;
        }
        return ((openres *)0); /* Reply was already sent or must be delayed */
      }        

      /* Not synchronizing */
      result.stat = RPC_OK;
      result.openres_u.fh.vfd      = _ftix;
      result.openres_u.fh.how_many = _CFTE.how_many;
      result.openres_u.fh.which    = _ctix;
      result.openres_u.fh.mode     = _CFTE.mode;
      
      return (&result);
    }
  }

  /* HA, there is no matching open file */

  /* Let'd find a free tbl element */

  for (_ftix = 0; _ftix < MAXNUMFILES; _ftix++)
    if (_RFDC == -1)
      break;
  
  if (_ftix >= MAXNUMFILES)
  {
    ERR_MACRO(openres_u, EPFSLMFILE);
    return (&result);
  }
  
  /* Allocate the clttab */
  if ((_CFTE.cltab = (CltTabEl *)malloc(sizeof(CltTabEl)*argp->how_many))
      == (CltTabEl *)0)
  {
    ERR_MACRO(openres_u, EPFSLMFILE);
    return (&result);
  }

  /* Initialize the table entry */
	_CFTE.oflags     = argp->oflags;
  _CFTE.permission = argp->permission;
  _CFTE.uid = unix_cred->aup_uid;
  _CFTE.gid = unix_cred->aup_gid;
  strcpy(_CFTE.filename,argp->filename);
  if (argp->global)
    _CFTE.mode     = argp->mode;
  else
    _CFTE.mode     = M_UNIX;
  _CFTE.shoffs     = 0;
	_CFTE.how_many   = argp->how_many;
	_CFTE.actual     = 1;

	for (_clc=0; _clc < _CFTE.how_many; _clc++)
	{
		/* 
		 * reset everything in the memory which might be there from previous calls
		 */
		
		_CNCL.access   = FALSE;
		_CNCL.foffs    = 0;
    _CNCL.syncdone = FALSE;
    _CNCL.syncok   = TRUE;
    _CNCL.syncerr  = 0;
		_CNCL.transp   = (SVCXPRT *)0;

    _CNCL.ioseq    = 0;

		for (_cid=0; _cid<MAXIOID; _cid++)
    {
      _CNID.state  = ID_UNUSED;
      _CNID.ioseq  = 0;
      _CNID.oldmode = FALSE;
    }      
	}

  _CLNT.ident.uid = unix_cred->aup_uid;
  _CLNT.ident.gid = unix_cred->aup_gid;
  _CLNT.ident.aup_time = unix_cred->aup_time;
  strcpy(_CLNT.ident.hname, unix_cred->aup_machname);

	_CLNT.access  = TRUE;

  if ((argp->global) && (argp->how_many > 1))
  {
    _CFTE.sync = PFSD_SYNC_OPEN;
    _CLNT.syncdone = TRUE;
    _CLNT.transp = rqstp->rq_xprt;
  }
  else
    _CFTE.sync = PFSD_SYNC_NONE;
  


	/* everything is okay, good luck when opening */

  if ((_RFDC =
       open(_CFTE.filename,_CFTE.oflags & (~O_APPEND),_CFTE.permission)) < 0)
	{                             /* open failed */
    _CLNT.syncok  = FALSE;
    _CLNT.syncerr = errno;
	}
  else if (fstat(_RFDC, &buf) < 0)
  {                             /* fstat failed */
    _CLNT.syncok  = FALSE;
    _CLNT.syncerr = errno;
  }
  else if (! S_ISREG(buf.st_mode))
	{                             /* not a  regular file */
    _CLNT.syncok  = FALSE;
    _CLNT.syncerr = EPFSLBADFT;
	}
  else if ((_CFTE.endoffs = lseek(_RFDC, 0, SEEK_END)) < 0)
  {                             /* fstat failed */
    _CLNT.syncok  = FALSE;
    _CLNT.syncerr = errno;
  }
  else
  {  
    /* Set end of file offset */  
    for (_clc = 0; _clc < _CFTE.how_many; _clc++)
      _CNCL.endoffs = _CFTE.endoffs;
  }

  if (!_CLNT.syncok)
  {
    close (_RFDC);
  }
  
  if (_CFTE.sync == PFSD_SYNC_OPEN) 
    return ((openres *)0);      /* Delay reply */
  
  if (!_CLNT.syncok)
  {
    ERR_MACRO(openres_u, _CLNT.syncerr);
    
    free(_CFTE.cltab);
    _CFTE.cltab = (CltTabEl *)0;
    _RFDC = -1;
  
    return (&result);
  }
  
	result.stat = RPC_OK;
	result.openres_u.fh.vfd      = _ftix;
	result.openres_u.fh.how_many = _CFTE.how_many;
	result.openres_u.fh.which    = _ctix;
  result.openres_u.fh.mode     = _CFTE.mode;
  
	return(&result);
}

