/******************************************************************************
 *
 *    pfsd_macros.h,v : macros for pfsd
 *    Copyright (C) 1995 A. Bode, S. Lamberts, T. Ludwig, C. R"oder
 *
 *    PFSLib (Parallel I/O on workstations)
 *
 *    PFSLib offers parallel access to files for a parallel application
 *    running on a cluster of workstations.
 *    It is intended but not restricted to be used in message passing
 *    applications based on PVM, NXLib, MPI, and other.
 *
 *    PFSLib consists of a LIBRARY, deamon PROGRAMS, and utility PROGRAMS.
 *
 *    PFSLib is free software; you can redistribute the LIBRARY and/or
 *    modify it under the terms of the GNU Library General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    You can redistribute the daemon PROGRAMS and utility PROGRAMS
 *    and/or modify them under the terms of the GNU General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *
 *    PFSLib is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Library General Public License and GNU General Public License 
 *    for more details.
 *
 *    You should have received a copy of the GNU Library General Public
 *    License and the GNU General Public License along with this
 *    library; if not, write to the Free 
 *    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Contact to the authors:
 *
 *    electronic mail: pfslib@informatik.tu-muenchen.de
 *
 *    paper mail:      Prof. Dr. A. Bode
 *                     Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
 *                     Institut f"ur Informatik
 *                     Technische Universit"at M"unchen
 *                     80290 M"unchen
 *                     Germany
 *
 *    This project was partially funded by a research grant form Intel
 *    Corporation. 
 *
 *****************************************************************************/

/******************************************************************************
 *
 *  RCS Filename : pfsd_macros.h,v
 *  RCS Date     : 1995/11/29 14:08:44
 *  RCS Revision : 1.5
 *  RCS Author   : lamberts
 *
 *  Authors: Stefan Lamberts, Christian R"oder
 *
 *****************************************************************************/
#ifndef __pfslib_pfsd_macros_h__
#define __pfslib_pfsd_macros_h__

#ifndef lint
static char rcs_id_pfsd_macros[] = "pfsd_macros.h,v 1.5 1995/11/29 14:08:44 lamberts Rel";
#endif


/* 
 * Macros defined for filetable access of the pfsd:
 *
 * _CFTE: currently accessed element of filetable
 * _RFDC: currently accessed real filedescriptor
 * _SYFL: currently accessed synchronising flag
 * _MODE: IO mode of the currently accessed file
 * _CLNT: (ONE client) which client is currently accessing the server
 * _CNCL: (ALL clients) for loop over clienttable
 * _IOID: IO identificator currently in progress (ONE client)
 * _CNID: IO identificator currently in progress (ALL clients)
 */

#define _CFTE _cftbl[_ftix]
#define _RFDC _cftbl[_ftix].filedes 
#define _SYFL _cftbl[_ftix].syncflag
#define _MODE _cftbl[_ftix].mode
#define _CLNT _cftbl[_ftix].cltab[_ctix]
#define _IOID _cftbl[_ftix].cltab[_ctix].ioIDs[_ioID]
#define _CNCL _cftbl[_ftix].cltab[_clc]
#define _CNID _cftbl[_ftix].cltab[_clc].ioIDs[_cid]


extern char  *_geterrstr
#ifdef ANSI_C
(int);
#else
();
#endif /* ANSI_C */

/* Macro to set error return values */
#define ERR_MACRO(a,b)\
result.stat = RPC_ERR;\
result.a.err.errno = b;\
result.a.err.errstr = _geterrstr(b);

/* Macro to copy RPC strings */
#define RPCSTRCPY(a,b,c)\
strncpy(a,b.c.c ## _val,b.c.c ## _len);\
a[b.c.c ## _len] = '\0'

#endif /* __pfslib_pfsd_macros_h__ */
